import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">:host{display:flex;flex-direction:column}#newWord{width:100%;--cr-input-width:216px}#newWord::part(row-container){justify-content:normal}iron-list .word{flex:1;padding-inline-start:10px}#list{padding:0 var(--cr-section-padding)}.list-item{border-bottom:var(--cr-separator-line)}#noWordsLabel{padding-top:39px;text-align:center}</style>
<div class="cr-row continuation">
  $i18n{editDictionaryDescription}
</div>
<div class="cr-row first">
  <iron-a11y-keys id="keys" keys="enter esc"
      on-keys-pressed="onKeysPress_">
  </iron-a11y-keys>
  <cr-input id="newWord" value="{{newWordValue_}}"
      invalid="[[isNewWordInvalid_(newWordState_)]]"
      error-message="[[getErrorMessage_(newWordState_)]]"
      spellcheck="false"
      aria-label="$i18n{editDictionaryDescription}">
    <cr-button on-click="onAddWordClick_" id="addWord" slot="suffix"
        disabled="[[disableAddButton_]]">
      $i18n{addDictionaryWordButtonLabel}
    </cr-button>
  </cr-input>
</div>
<iron-list id="list" items="[[words_]]" preserve-focus
    scroll-target="[[subpageScrollTarget]]" risk-selection>
  <template>
    <div class="list-item">
      <div id$="word[[index]]" class="word text-elide" aria-hidden="true">
        [[item]]
      </div>
      <cr-icon-button class="icon-clear" on-click="onRemoveWordClick_"
          tabindex$="[[tabIndex]]"
          title="$i18n{deleteDictionaryWordTooltip}"
          aria-describedby$="word[[index]]">
      </cr-icon-button>
    </div>
  </template>
</iron-list>
<div id="noWordsLabel" class="secondary" hidden="[[hasWords_]]">
  $i18n{noDictionaryWordsLabel}
</div>
<!--_html_template_end_-->`;
}
