// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'os-settings-japanese-clear-ime-data-dialog' is used to
 * manage clearing personalized data for the Japanese input decoder.
 */
import 'chrome://resources/ash/common/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { getTemplate } from './os_japanese_clear_ime_data_dialog.html.js';
import { UserDataServiceProvider } from './user_data_service_provider.js';
export class OsSettingsClearPersonalizedDataDialogElement extends PolymerElement {
    constructor() {
        super(...arguments);
        this.clearConversionHistory_ = false;
        this.clearSuggestionHistory_ = false;
    }
    static get is() {
        return 'os-settings-japanese-clear-ime-data-dialog';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            clearConversionHistory_: {
                type: Boolean,
            },
            clearSuggestionHistory_: {
                type: Boolean,
            },
        };
    }
    onCancelButtonClick_() {
        this.$.dialog.close();
    }
    async onClearButtonClick_() {
        await UserDataServiceProvider.getRemote().clearJapanesePersonalizationData(this.clearConversionHistory_, this.clearSuggestionHistory_);
        this.$.dialog.close();
    }
}
customElements.define(OsSettingsClearPersonalizedDataDialogElement.is, OsSettingsClearPersonalizedDataDialogElement);
