import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared md-select">:host{display:flex;flex-direction:column}.entry-row{display:flex;justify-content:space-between;align-items:stretch;gap:16px}.category-div{display:flex;flex-direction:column;flex:1}.category-label{font:var(--cros-annotation-2-font);font-weight:500}.delete-icon{--cr-icon-button-size:32px;--cr-icon-button-icon-size:20px;align-self:center}</style>

<div class="cr-row continuation entry-row">
  <cr-input value="[[entry.key]]"
     label="$i18n{japaneseDictionaryReading}"
     type="text"
     aria-description="[[i18nEntryDescription_()]]"
     on-change="saveReading_"></cr-input>
  <cr-input value="[[entry.value]]"
     label="$i18n{japaneseDictionaryWord}"
     type="text"
     aria-description="[[i18nEntryDescription_()]]"
     on-change="saveWord_"></cr-input>
  <div class="category-div" >
    <label id="categoryLabel" class="cr-form-field-label category-label">
      $i18n{japaneseDictionaryCategory}
    </label>
    <!--
      These Japanese terms are not translated on purpose since they are technical linguistic terms
      The option values needs to corresponds to the int value of the mojo enum JpPosType.
    -->
    <select id="posDropdownMenu" class="md-select" on-change="onOptionChanged_"
       aria-labelledby="categoryLabel"
       aria-description="[[i18nEntryDescription_()]]">
       <template is="dom-repeat" items="[[posTypeOptions_]]">
         <option value="[[item.value]]"
            selected="[[isSelectedOption_(item.value)]]">
           [[item.label]]
         </option>
       </template>
    </select>
  </div>
  <cr-input value="[[entry.comment]]"
     label="$i18n{japaneseDictionaryComment}"
     type="text"
     aria-description="[[i18nEntryDescription_()]]"
     on-change="saveComment_"></cr-input>
  <cr-icon-button class="delete-icon no-overlap"
     iron-icon="cr:close"
     on-click="deleteEntry_"
     aria-description="[[i18nEntryDescription_()]]"
     title="$i18n{japaneseDictionaryDeleteEntry}"></cr-icon-button>
</div>

<!--_html_template_end_-->`;
}
