import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared action-link iron-flex">h2{padding-inline-start:var(--cr-section-padding)}.subsection{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-indent-padding)}.subsection>cr-link-row{padding-inline-end:0;padding-inline-start:0}cr-action-menu.complex .dropdown-item{min-height:36px}cr-policy-indicator{margin-inline-end:8px}.bottom-margin{margin-bottom:var(--cr-section-vertical-margin)}.list-item.non-translate-target .target-info{display:none}.list-item.translate-target~.list-item.translate-target .target-info{display:none}#addLanguages{margin-top:16px}cr-checkbox{--cr-checkbox-label-padding-start:8px}</style>

<div class="cr-row first">
  <div class="flex cr-padded-text" aria-hidden="true">
    $i18n{deviceLanguageTitle}
    <div class="secondary">
      [[getLanguageDisplayName_(languages.prospectiveUILanguage)]]
    </div>
  </div>
  <template is="dom-if" if="[[isSecondaryUser_]]">
    <cr-policy-indicator id="changeDeviceLanguagePolicyIndicator"
        indicator-type="primary_user"
        indicator-source-name="[[primaryUserEmail_]]">
    </cr-policy-indicator>
  </template>
  <template is="dom-if" if="[[!isGuest_]]">
    <cr-button id="changeDeviceLanguage"
        on-click="onChangeDeviceLanguageClick_"
        disabled="[[isSecondaryUser_]]"
        aria-label="[[getChangeDeviceLanguageButtonDescription_(
          languages.prospectiveUILanguage)]]"
        deep-link-focus-id$="[[Setting.kChangeDeviceLanguage]]">
      $i18n{changeDeviceLanguageLabel}
    </cr-button>
  </template>
</div>

<template is="dom-if" if="[[isPerAppLanguageEnabled_]]">
  <cr-link-row
      id="appLanguagesSection"
      class="hr"
      label="$i18n{appLanguagesTitle}"
      sub-label="$i18n{appLanguagesDescription}"
      on-click="onAppLanguagesClick_"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>

<div class="hr bottom-margin">
  <h2 aria-hidden="true">
    [[getLanguagePreferenceTitle_(languageSettingsV2Update2Enabled_)]]
  </h2>
  <div class="cr-row first bottom-margin">
    <localized-link id="webLanguagesDescription"
        localized-string="[[getLanguagePreferenceDescription_(
            languageSettingsV2Update2Enabled_)]]"
        on-link-clicked="onLanguagePreferenceDescriptionLinkClick_">
    </localized-link>
  </div>
  <div class="list-frame vertical-list" id="languagesList">
    <template is="dom-repeat" items="[[languages.enabled]]">
      <div class$="list-item [[getTranslationTargetClass_(
          item.language.code, languages.translateTarget)]]">
        <div class="flex" id="displayText-[[index]]"
            aria-hidden="true">
          <div title="[[item.language.nativeDisplayName]]">
            [[item.language.displayName]]
          </div>
          <div class="target-info secondary">
            $i18n{translateTargetLabel}
          </div>
        </div>
        <cr-icon-button class="icon-more-vert"
            title="$i18n{moreActions}" id="more-[[item.language.code]]"
            on-click="onDotsClick_"
            aria-labelledby$="displayText-[[index]]">
        </cr-icon-button>
      </div>
    </template>
    <div class="list-item">
      <cr-button id="addLanguages"
          disabled="[[!canEnableSomeSupportedLanguage_(languages)]]"
          on-click="onAddLanguagesClick_"
          deep-link-focus-id$="[[Setting.kAddLanguage]]">
        <iron-icon id="addLanguagesIcon" icon="cr:add" slot="prefix-icon">
        </iron-icon>
        $i18n{addLanguages}
      </cr-button>
    </div>
  </div>
</div>

<template is="dom-if" if="[[languageSettingsV2Update2Enabled_]]">
  <div class="hr">
    <h2 aria-hidden="true">$i18n{googleAccountLanguageTitle}</h2>
    <div class="cr-row first">
      $i18n{googleAccountLanguageDescription}
    </div>
    <div class="subsection cr-padded-text">
      <cr-link-row id="manageGoogleAccountLanguage"
          label="$i18n{manageGoogleAccountLanguageLabel}"
          on-click="openManageGoogleAccountLanguage_"
          external>
      </cr-link-row>
    </div>
  </div>
</template>

<settings-toggle-button id="offerTranslation" class="hr"
    pref="{{prefs.translate.enabled}}"
    label="[[getOfferTranslationLabel_(
        languageSettingsV2Update2Enabled_)]]"
    sub-label="[[getOfferTranslationSublabel_(
        languageSettingsV2Update2Enabled_)]]"
    on-settings-boolean-control-change="onTranslateToggleChange_"
    deep-link-focus-id$="[[Setting.kOfferTranslation]]">
</settings-toggle-button>

<cr-lazy-render id="menu">
  <template>
    <cr-action-menu class="complex"
        role-description="$i18n{menu}">
      <cr-checkbox id="offerTranslations"
          class="dropdown-item"
          checked="[[detailLanguage_.state.translateEnabled]]"
          on-change="onTranslateCheckboxChange_"
          hidden="[[!prefs.translate.enabled.value]]"
          disabled="[[disableTranslateCheckbox_(
              detailLanguage_.state, languages.translateTarget)]]" noink>
        $i18n{offerToTranslateThisLanguage}
      </cr-checkbox>
      <button class="dropdown-item" role="menuitem"
          on-click="onMoveToTopClick_"
          hidden="[[showMoveToTop_(detailLanguage_)]]">
        $i18n{moveToTop}
      </button>
      <button class="dropdown-item" role="menuitem"
          on-click="onMoveUpClick_"
          hidden="[[!showMoveUp_(detailLanguage_)]]">
        $i18n{moveUp}
      </button>
      <button class="dropdown-item" role="menuitem"
          on-click="onMoveDownClick_"
          hidden="[[!showMoveDown_(detailLanguage_)]]">
        $i18n{moveDown}
      </button>
      <button class="dropdown-item" role="menuitem"
          on-click="onRemoveLanguageClick_"
          disabled="[[!detailLanguage_.state.removable]]">
        $i18n{removeLanguage}
      </button>
    </cr-action-menu>
  </template>
</cr-lazy-render>

<template is="dom-if" if="[[showChangeDeviceLanguageDialog_]]" restamp>
  <os-settings-change-device-language-dialog languages="[[languages]]"
      language-helper="[[languageHelper]]"
      on-close="onChangeDeviceLanguageDialogClose_">
  </os-settings-change-device-language-dialog>
</template>

<template is="dom-if" if="[[showAddLanguagesDialog_]]" restamp>
  <!-- TODO(b/238031866): Change this two-way binding to be one-way. -->
  <os-settings-add-languages-dialog languages="{{languages}}"
      language-helper="[[languageHelper]]"
      on-close="onAddLanguagesDialogClose_">
  </os-settings-add-languages-dialog>
</template>
<!--_html_template_end_-->`;
}
