import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">cr-input{--cr-input-error-display:none}cr-tooltip-icon{--cr-icon-size:16px;--cr-tooltip-icon-fill-color:var(--cros-sys-on_surface_variant)}iron-icon{--iron-icon-fill-color:var(--cros-sys-on_surface_variant);--iron-icon-height:16px;--iron-icon-width:16px}#savedFingerprints{margin-inline-end:4px;color:var(--cros-sys-on_surface_variant)}#fingerprintTooltip{--paper-tooltip-delay-out:500ms}#fingerprintNotice{--cr-localized-link-display:block;font-size:12px;line-height:18px}#fingerprintsList{padding-inline-start:2px}#lockScreenFingerprintWarning{margin-inline-start:4px;color:var(--cros-sys-on_surface_variant)}
</style>
<h2 class="settings-box">
  <div id="savedFingerprints">
    $i18n{lockScreenRegisteredFingerprints}
  </div>
  <cr-tooltip-icon id="fingerprintTooltip" tooltip-position="right"
      icon-class="cr:help-outline" icon-aria-label="$i18n{learnMore}">
    <localized-link id="fingerprintNotice"
        localized-string="$i18n{lockScreenFingerprintNotice}"
        link-url="$i18n{fingerprintLearnMoreLink}"
        slot="tooltip-text">
      <!-- paper-tooltip probes for children textContent to decide whether
        to show tooltip or not-->
      _
    </localized-link>
  </cr-tooltip-icon>
</h2>
<div class="list-frame layout vertical">
  <iron-list id="fingerprintsList" items="[[fingerprints_]]">
    <template>
      <div class="list-item">
        <cr-input value="{{item}}" on-change="onFingerprintLabelChanged_">
        </cr-input>
        <cr-icon-button class="icon-delete-gray"
            on-click="onFingerprintDeleteTapped_"
            aria-label$="[[getButtonAriaLabel_(item)]]"
            deep-link-focus-id$="[[Setting.kRemoveFingerprintV2]]">
        </cr-icon-button>
      </div>
    </template>
  </iron-list>
  <div class="continuation">
    <cr-button id="addFingerprint" class="action-button"
        on-click="openAddFingerprintDialog_"
        deep-link-focus-id$="[[Setting.kAddFingerprintV2]]">
      $i18n{lockScreenAddFingerprint}
    </cr-button>
  </div>
</div>
<div id="fingerprintWarning" class="settings-box continuation">
  <iron-icon icon="cr:info-outline"></iron-icon>
  <div id="lockScreenFingerprintWarning">
    $i18n{lockScreenFingerprintWarning}
  </div>
</div>
<template is="dom-if" if="[[showSetupFingerprintDialog_]]" restamp>
  <settings-setup-fingerprint-dialog
      auth-token="[[authToken]]"
      on-add-fingerprint="updateFingerprintsList_"
      on-close="onSetupFingerprintDialogClose_"
      allow-add-another-finger="[[allowAddAnotherFinger_]]">
  </settings-setup-fingerprint-dialog>
</template>
<!--_html_template_end_-->`;
}
