import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">cr-radio-group{display:flex;flex-wrap:wrap}.list-item{width:100%}#lockOptionsDiv{display:block}.underbar{border-bottom:var(--cr-separator-line)}#passwordSettings{border-top:var(--cr-separator-line);padding:var(--cr-section-vertical-padding) 0}</style>
<div>
  <settings-toggle-button id="enableLockScreen"
      pref="{{prefs.settings.enable_screen_lock}}"
      on-settings-boolean-control-change="onScreenLockChange_" no-set-pref
      label="$i18n{enableScreenlock}"
      deep-link-focus-id$="[[Setting.kLockScreenV2]]">
  </settings-toggle-button>
  <h2 class="settings-box">
    $i18n{lockScreenSignInOptions}
  </h2>
  <div class="list-frame underbar" id="signInOptionsList">
    <settings-pin-settings
        id="pinSettings"
        auth-token="[[authToken]]"
        prefs="{{prefs}}"
        class="list-item"
        deep-link-focus-id$="[[Setting.kChangeAuthPinV2]]">
    </settings-pin-settings>
    <template is="dom-if" if="[[showPasswordSettings_]]" restamp>
      <settings-password-settings
          id="passwordSettings"
          auth-token="[[authToken]]"
          class="list-item">
      </settings-password-settings>
    </template>
  </div>
  <template is="dom-if" if="[[lockScreenNotificationsEnabled_]]">
    <h2 class="settings-box">
      $i18n{lockScreenNotificationTitle}
    </h2>
    <div class="list-frame underbar">
      <settings-radio-group
          id="notificationSettings"
          pref="{{prefs.ash.message_center.lock_screen_mode}}"
          group-aria-label="$i18n{lockScreenNotificationTitle}"
          deep-link-focus-id$="[[Setting.kLockScreenNotification]]">
        <template is="dom-if"
            if="[[lockScreenHideSensitiveNotificationSupported_]]">
          <cr-radio-button name="hideSensitive" class="list-item underbar"
               pref="[[prefs.ash.message_center.lock_screen_mode]]"
               label="$i18n{lockScreenNotificationHideSensitive}">
          </cr-radio-button>
        </template>
        <cr-radio-button name="show" class="list-item underbar"
             pref="[[prefs.ash.message_center.lock_screen_mode]]"
             label="$i18n{lockScreenNotificationShow}">
        </cr-radio-button>
        <cr-radio-button name="hide" class="list-item"
             pref="[[prefs.ash.message_center.lock_screen_mode]]"
             label="$i18n{lockScreenNotificationHide}">
        </cr-radio-button>
      </settings-radio-group>
    </div>
  </template>
  <settings-toggle-button
      id="recoveryToggle"
      label="$i18n{recoveryToggleLabel}"
      sub-label="[[recoveryToggleSubLabel_(recovery_)]]"
      learn-more-url="[[recoveryToggleLearnMoreUrl_(recovery_)]]"
      pref="{{recoveryTogglePref_(recovery_)}}"
      disabled="[[recoveryToggleDisabled_(recovery_,
                      recoveryChangeInProcess_)]]"
      deep-link-focus-id$="[[Setting.kDataRecovery]]"
      no-set-pref
      on-settings-boolean-control-change="onRecoveryChange_">
  </settings-toggle-button>
  <template is="dom-if" if="[[showDisableRecoveryDialog_]]" restamp>
    <local-data-recovery-dialog id="localDataRecoveryDialog"
      auth-token="[[authToken]]"
      on-close="onRecoveryDialogClose_">
    </local-data-recovery-dialog>
  </template>
  <template is="dom-if" if="[[fingerprintUnlockEnabled_]]">
    <div id="fingerprintDiv" class="settings-box two-line">
      <div class="start">
        $i18n{lockScreenEditFingerprints}
        <div class="secondary" id="lockScreenEditFingerprintsSecondary">
          [[numFingerprintDescription_]]
        </div>
      </div>
      <div class="separator"></div>
      <div class="secondary-action">
        <cr-button id="editFingerprints" on-click="onEditFingerprints_"
            aria-label="$i18n{lockScreenEditFingerprints}"
            aria-descibedby="lockScreenEditFingerprintsSecondary">
          $i18n{lockScreenSetupFingerprintButton}
        </cr-button>
      </div>
    </div>
  </template>
  <settings-multidevice-smartlock-item
    auth-token="[[authToken]]">
  </settings-multidevice-smartlock-item>
</div>
<!--_html_template_end_-->`;
}
