import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared">.list-item{display:flex}.list-item>div{flex:1}div[label-disabled]{opacity:var(--cros-disabled-opacity)}</style>
<div class="settings-box first">
  <localized-link class="secondary"
      localized-string="$i18n{osSyncFeatureLabel}"
      on-link-clicked="onBrowserSyncSettingsClicked_">
  </localized-link>
</div>
<div id="syncDataRadio" class="cr-row first">
  <cr-radio-group
      selected="[[selectedSyncDataRadio_(osSyncPrefs)]]"
      on-selected-changed="onSyncDataRadioSelectionChanged_">
    <cr-radio-button name="sync-everything">
      $i18n{syncEverythingCheckboxLabel}
    </cr-radio-button>
    <cr-radio-button name="customize-sync">
      $i18n{customizeSyncLabel}
    </cr-radio-button>
  </cr-radio-group>
</div>
<div class="cr-row first">
  <h2 class="cr-title-text flex">$i18n{syncData}</h2>
</div>
<div class="list-frame" id="sync-data-types">
  <div class="list-item" hidden="[[!osSyncPrefs.osAppsRegistered]]">
    <div id="osAppsCheckboxLabel"
        label-disabled$="[[areDataTypeTogglesDisabled_]]">
      $i18n{osSyncAppsCheckboxLabel}
    </div>
    <cr-toggle id="osAppsControl"
        checked="{{osSyncPrefs.osAppsSynced}}"
        on-change="onSingleSyncDataTypeChanged_"
        disabled="[[areDataTypeTogglesDisabled_]]"
        aria-labelledby="osAppsCheckboxLabel">
    </cr-toggle>
  </div>
  <div class="list-item" hidden="[[!osSyncPrefs.osPreferencesRegistered]]">
    <div id="osSettingsCheckboxLabel"
        label-disabled$="[[areDataTypeTogglesDisabled_]]">
      $i18n{osSyncSettingsCheckboxLabel}
    </div>
    <cr-toggle id="osPreferencesControl"
        checked="{{osSyncPrefs.osPreferencesSynced}}"
        on-change="onSettingsSyncedChanged_"
        disabled="[[areDataTypeTogglesDisabled_]]"
        aria-labelledby="osSettingsCheckboxLabel">
    </cr-toggle>
  </div>
  <div class="list-item"
       hidden="[[!osSyncPrefs.osWifiConfigurationsRegistered]]">
    <div id="osWifiConfigurationsCheckboxLabel"
        label-disabled$="[[areDataTypeTogglesDisabled_]]">
      $i18n{osSyncWifiConfigurationsCheckboxLabel}
    </div>
    <cr-toggle checked="{{osSyncPrefs.osWifiConfigurationsSynced}}"
        on-change="onSingleSyncDataTypeChanged_"
        disabled="[[areDataTypeTogglesDisabled_]]"
        aria-labelledby="osWifiConfigurationsCheckboxLabel">
    </cr-toggle>
  </div>
  <div class="list-item" hidden="[[!osSyncPrefs.osAppsRegistered]]">
    <!-- Wallpaper sync is a special case; its implementation relies upon
         OS Settings to be synced. Thus, the wallpaper label and toggle are
         only enabled when the Settings sync toggle above is on. -->
    <div id="wallpaperCheckboxLabel"
        label-disabled$="[[shouldWallpaperSyncSectionBeDisabled_(
            areDataTypeTogglesDisabled_, osSyncPrefs.osAppsSynced)]]">
      $i18n{wallpaperCheckboxLabel}
    </div>
    <cr-toggle checked="{{osSyncPrefs.wallpaperEnabled}}"
        on-change="onSingleSyncDataTypeChanged_"
        disabled="[[shouldWallpaperSyncSectionBeDisabled_(
            areDataTypeTogglesDisabled_, osSyncPrefs.osAppsSynced)]]"
        aria-labelledby="wallpaperCheckboxLabel">
    </cr-toggle>
  </div>
</div>
<!--_html_template_end_-->`;
}
