import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared">#create-password-box{margin-bottom:1em}#create-password-box .list-item{margin-bottom:var(--cr-form-field-bottom-spacing)}cr-input{--cr-input-width:var(--cr-default-input-max-width)}.passphrase-reset-icon{margin-inline-end:8px}cr-radio-button[name='encrypt-with-passphrase']{align-items:start}</style>

<template is="dom-if" if="[[!syncPrefs.passphraseRequired]]">
  <div id="encryptionRadioGroupContainer" class="list-frame">
    <cr-radio-group
        id="encryptionRadioGroup"
        selected="[[selectedEncryptionRadio_(syncPrefs)]]"
        on-selected-changed="onEncryptionRadioSelectionChanged_"
        disabled$="[[disableEncryptionOptions_]]">
      <cr-radio-button name="encrypt-with-google" class="list-item"
          aria-label="$i18n{encryptWithGoogleCredentialsLabel}">
        $i18n{encryptWithGoogleCredentialsLabel}
      </cr-radio-button>
      <cr-radio-button name="encrypt-with-passphrase"
          class="list-item">
        <span hidden="[[!existingPassphraseLabel]]">
          [[existingPassphraseLabel]]
        </span>
        <span on-click="onLearnMoreClick_"
            hidden="[[existingPassphraseLabel]]">
          $i18nRaw{encryptWithSyncPassphraseLabel}
        </span>
        <template is="dom-if" if="[[creatingNewPassphrase_]]" restamp>
          <div id="create-password-box">
            <div class="list-item">
              <span>$i18nRaw{passphraseExplanationText}</span>
            </div>
            <cr-input id="passphraseInput" type="password"
                value="{{passphrase_}}"
                placeholder="$i18n{passphrasePlaceholder}"
                error-message="$i18n{emptyPassphraseError}"
                on-keypress="onNewPassphraseInputKeypress_">
            </cr-input>
            <cr-input id="passphraseConfirmationInput" type="password"
                value="{{confirmation_}}"
                placeholder="$i18n{passphraseConfirmationPlaceholder}"
                error-message="$i18n{mismatchedPassphraseError}"
                on-keypress="onNewPassphraseInputKeypress_">
            </cr-input>
            <cr-button id="saveNewPassphrase"
                on-click="onSaveNewPassphraseClick_" class="action-button"
                disabled="[[!isSaveNewPassphraseEnabled_(
                              passphrase_, confirmation_)]]">
              $i18n{save}
            </cr-button>
          </div>
        </template>
      </cr-radio-button>
    </cr-radio-group>
  </div>
</template>
<!--_html_template_end_-->`;
}
