import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">.two-elements-left-right{align-items:center;display:flex;flex-direction:row;justify-content:space-between}:host{display:block}:host>div{width:100%}</style>
<div>
  <div class="two-elements-left-right">
    <div>
      $i18n{lockScreenPasswordLabel}
      <template is="dom-if" if="[[hasNoPassword_(hasGaiaPassword_, hasLocalPassword_)]]">
        <div class="secondary" id="setupPasswordSecondaryLabel">
          $i18n{lockScreenSwitchSetLocalPasswordDescription}
        </div>
      </template>
      <template
        is="dom-if"
        if="[[hasGaiaPassword_]]"
      >
        <div class="secondary" id="switchLocalPasswordSecondaryLabel">
          $i18n{lockScreenSwitchLocalPasswordDescription}
        </div>
      </template>
    </div>
    <div class="settings-row">
      <div>
        <template is="dom-if" if="[[!hasLocalPassword_]]">
          <cr-button
            id="switchLocalPasswordButton"
            aria-describedby="switchLocalPasswordSecondaryLabel"
            on-click="openSetLocalPasswordDialog_"
          >
            $i18n{lockScreenSetupPasswordButton}
          </cr-button>
        </template>
        <template is="dom-if" if="[[hasLocalPassword_]]">
          <cr-button on-click="openSetLocalPasswordDialog_">
            $i18n{lockScreenChangePasswordButton}
          </cr-button>
        </template>
      </div>
      <template
        is="dom-if"
        if="[[isRemoveAllowed_(hasCryptohomePinV2_, hasGaiaPassword_, hasLocalPassword_)]]"
        restamp
      >
        <div class="separator"></div>
        <cr-icon-button
          id="moreButton"
          class="icon-more-vert"
          aria-haspopup="menu"
          aria-label="$i18n{lockScreenPinMoreButtonAriaLabel}"
          on-click="onMoreButtonClicked_"
          disabled$="[[!isRemoveAllowed_(hasCryptohomePinV2_, hasGaiaPassword_, hasLocalPassword_)]]"
        >
        </cr-icon-button>
        <cr-action-menu
          id="moreMenu"
          role-description="$i18n{menu}"
          accessibility-label="$i18n{moreActions}"
        >
          <button
            class="dropdown-item"
            on-click="onRemovePasswordButtonClicked_"
            disabled$="[[!isRemoveAllowed_(hasCryptohomePinV2_, hasGaiaPassword_, hasLocalPassword_)]]"
          >
            $i18n{lockScreenRemoveButton}
          </button>
        </cr-action-menu>
      </template>
    </div>
  </div>
  <settings-set-local-password-dialog id="setLocalPasswordDialog" auth-token="[[authToken]]">
  </settings-set-local-password-dialog>
</div>
<!--_html_template_end_-->`;
}
