import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">.two-elements-left-right{display:flex;flex-direction:row;justify-content:space-between;align-items:center}:host{display:block}:host>div{width:100%}cr-policy-indicator{margin-left:16px;margin-right:16px}</style>
<div>
  <div class="two-elements-left-right">
    <div class="label" id="setupPinLabel">$i18n{lockScreenPinLabel}</div>
    <div class="settings-row">
      <template is="dom-if" if="[[quickUnlockDisabledByPolicy_]]">
        <cr-policy-indicator indicator-type="userPolicy">
        </cr-policy-indicator>
      </template>
      <template is="dom-if" if="[[!hasPin_]]" restamp>
        <cr-button
            class="set-pin-button"
            aria-describedby="setupPinLabel"
            on-click="onSetPinButtonClicked_"
            disabled$="[[quickUnlockDisabledByPolicy_]]">
          $i18n{lockScreenSetupPinButton}
        </cr-button>
      </template>
      <template is="dom-if" if="[[hasPin_]]" restamp>
        <cr-button
            class="set-pin-button"
            on-click="onSetPinButtonClicked_"
            disabled$="[[quickUnlockDisabledByPolicy_]]">
          $i18n{lockScreenChangePinButton}
        </cr-button>
        <div class="separator"></div>
        <cr-icon-button
            id="moreButton"
            class="icon-more-vert"
            aria-haspopup="menu"
            aria-label="$i18n{lockScreenPinMoreButtonAriaLabel}"
            on-click="onMoreButtonClicked_"
            disabled$="[[removeDisabled_(
              hasPassword_, quickUnlockDisabledByPolicy_)]]">
        </cr-icon-button>
        <cr-action-menu id="moreMenu"
            role-description="$i18n{menu}"
            accessibility-label="$i18n{moreActions}">
          <button
              class="dropdown-item"
              on-click="onRemovePinButtonClicked_"
              disabled$="[[removeDisabled_(
                hasPassword_, quickUnlockDisabledByPolicy_)]]">
            $i18n{lockScreenRemoveButton}
          </button>
        </cr-action-menu>
      </template>
    </div>
  </div>
  <template is="dom-if" if="[[hasPin_]]">
    <settings-toggle-button id="enablePinAutoSubmit"
        pref="{{prefs.pin_unlock_autosubmit_enabled}}" no-set-pref
        on-settings-boolean-control-change="onPinAutosubmitChange_"
        label="$i18n{lockScreenPinAutoSubmit}"
        disabled$="[[quickUnlockDisabledByPolicy_]]">
    </settings-toggle-button>
  </template>
  <template is="dom-if" if="[[showSetPinDialog_]]" restamp>
    <settings-setup-pin-dialog id="setupPin" auth-token="[[authToken]]"
        on-close="onSetPinDialogClose_">
    </settings-setup-pin-dialog>
  </template>
  <template is="dom-if" if="[[showPinAutosubmitDialog_]]" restamp>
    <settings-pin-autosubmit-dialog id="pinAutosubmitDialog"
        auth-token="[[authToken]]"
        on-close="onPinAutosubmitDialogClose_">
    </settings-pin-autosubmit-dialog>
  </template>
</div>
<!--_html_template_end_-->`;
}
