import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">.error{color:var(--cros-text-color-alert)}#dialog [slot=body]{padding-top:5px}</style>
<cr-dialog id="dialog" ignore-enter-key close-text="$i18n{close}">
  <div slot="title">$i18n{setLocalPasswordDialogTitle}</div>
  <div slot="body">
    <set-local-password-input
        id="setPasswordInput"
        value="{{password_}}"
        on-submit="submit">
    </set-local-password-input>
    <template is="dom-if" if="[[showError_]]">
      <!--
        When this element appears, the dialog element will grow in size,
        causing a reflow. That's not very good UX, but since this happens only
        for internal errors, which shouldn't happen at all, it's acceptable.
        The alternative would be to inject this error message into the
        set-local-password-input element above, which reserves some size to
        display its errors. But that would be more complicated with little
        benefit.
      -->
      <div class="error">
        $i18n{setLocalPasswordDialogInternalError}
      </div>
    </template>
  </div>
  <div slot="button-container">
    <cr-button
        class="cancel-button"
        on-click="cancel">
      $i18n{cancel}
    </cr-button>
    <cr-button
        id="submitButton"
        class="action-button"
        on-click="submit"
        disabled="[[!password_]]">
      $i18n{confirm}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
