import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">#dialog::part(dialog){min-width:500px;width:500px}#scannerLocationLottie{height:220px;padding:10px 0}#messageDiv[invisible]{visibility:hidden}#closeButton{margin-inline-start:5px}</style>
<cr-dialog id="dialog" on-close="close"
    close-text="$i18n{close}">
  <div slot="title">$i18n{configureFingerprintTitle}</div>
  <div slot="body">
    <div id="messageDiv"
        invisible$="[[!getInstructionMessage_(step_, problemMessage_)]]"
        aria-live="polite">
      <span>[[getInstructionMessage_(step_, problemMessage_)]]</span>
    </div>
    <div id="scannerLocationLottie" hidden="[[!showScannerLocation_(step_)]]">
      <cros-lottie-renderer asset-url="fingerprint_scanner_animation.json"
          autoplay dynamic>
      </cros-lottie-renderer>
    </div>
    <fingerprint-progress id="arc" dynamic
        circle-radius="100"
        autoplay hidden="[[!showArc_(step_)]]">
    </fingerprint-progress>
  </div>
  <div slot="button-container">
    <cr-button id="addAnotherButton" on-click="onAddAnotherFingerprint_"
        hidden$="[[hideAddAnother_(step_, allowAddAnotherFinger)]]">
      $i18n{configureFingerprintAddAnotherButton}
    </cr-button>
    <cr-button id="closeButton"
        class$="[[getCloseButtonClass_(step_)]]" on-click="onClose_">
      [[getCloseButtonText_(step_)]]
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
