// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-setup-pin-dialog' is the settings page for choosing a PIN.
 *
 * Example:
 * * <settings-setup-pin-dialog auth-token="[[authToken]]">
 * </settings-setup-pin-dialog>
 */
import 'chrome://resources/ash/common/quick_unlock/pin_keyboard.js';
import 'chrome://resources/ash/common/quick_unlock/setup_pin_keyboard.js';
import 'chrome://resources/ash/common/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/ash/common/cr_elements/cr_dialog/cr_dialog.js';
import '../settings_shared.css.js';
import { I18nMixin } from 'chrome://resources/ash/common/cr_elements/i18n_mixin.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { getTemplate } from './setup_pin_dialog.html.js';
const SettingsSetupPinDialogElementBase = I18nMixin(PolymerElement);
class SettingsSetupPinDialogElement extends SettingsSetupPinDialogElementBase {
    static get is() {
        return 'settings-setup-pin-dialog';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            /*
             * Token to be used for calls into the pinFactorEditor service.
             */
            authToken: { type: String, notify: true },
            /**
             * Should the step-specific submit button be displayed?
             */
            enableSubmit_: Boolean,
            /**
             * The current step/subpage we are on.
             */
            isConfirmStep_: { type: Boolean, value: false },
            /**
             * Interface for chrome.quickUnlockPrivate calls. May be overridden by
             * tests.
             */
            quickUnlockPrivate: { type: Object, value: chrome.quickUnlockPrivate },
        };
    }
    connectedCallback() {
        super.connectedCallback();
        this.$.dialog.showModal();
        this.$.pinKeyboard.focus();
    }
    close() {
        if (this.$.dialog.open) {
            this.$.dialog.close();
        }
        this.$.pinKeyboard.resetState();
    }
    onCancelClick_() {
        this.$.pinKeyboard.resetState();
        this.$.dialog.close();
    }
    onPinSubmit_() {
        this.$.pinKeyboard.doSubmit();
    }
    onSetPinDone_() {
        if (this.$.dialog.open) {
            this.$.dialog.close();
        }
    }
    getTitleMessage_(isConfirmStep) {
        return this.i18n(isConfirmStep ? 'configurePinConfirmPinTitle' :
            'configurePinChoosePinTitle');
    }
    /**
     * @private
     * @param {boolean} isConfirmStep
     * @return {string}
     */
    getContinueMessage_(isConfirmStep) {
        return this.i18n(isConfirmStep ? 'confirm' : 'continue');
    }
}
customElements.define(SettingsSetupPinDialogElement.is, SettingsSetupPinDialogElement);
