import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cups-printer-shared">.subtext{margin-bottom:10px;padding-inline-end:20px;padding-inline-start:20px}#make-model-body{height:290px}</style>
<add-printer-dialog>
  <div slot="dialog-title">
    <span>$i18n{manufacturerAndModelDialogTitle}</span>
    <printer-dialog-error error-text="[[errorText_]]">
    </printer-dialog-error>
  </div>
  <div id="make-model-body" slot="dialog-body">
    <div class="subtext" id="makeModelTextInfo">
      <localized-link
          localized-string=
              "[[getManufacturerAndModelSubtext_(activePrinter.*)]]"
          link-url="$i18n{printingCUPSPrintLearnMoreUrl}">
      </localized-link>
    </div>
    <div class="settings-box two-line">
      <cr-searchable-drop-down id="manufacturerDropdown"
          items="[[manufacturerList]]"
          label="$i18n{printerManufacturer}"
          value="{{activePrinter.ppdManufacturer}}"
          invalid="{{isManufacturerInvalid_}}">
      </cr-searchable-drop-down>
    </div>
    <div class="settings-box two-line">
      <cr-searchable-drop-down id="modelDropdown"
          items="[[modelList]]"
          label="$i18n{printerModel}"
          value="{{activePrinter.ppdModel}}"
          invalid="{{isModelInvalid_}}">
      </cr-searchable-drop-down>
    </div>
    <div id="ppdLabel" class="cr-form-field-label">
      <localized-link localized-string="$i18n{advancedConfigSelectDriver}"
                      link-url="$i18n{printingCUPSPrintPpdLearnMoreUrl}">
      </localized-link>
    </div>
    <div class="settings-box two-line">
      <cr-input class="browse-file-input" readonly value="[[newUserPPD_]]"
          aria-labelledby="ppdLabel" invalid="[[invalidPPD_]]"
          error-message="$i18n{selectDriverErrorMessage}" input-tabindex="-1">
      </cr-input>
      <cr-button class="browse-button" on-click="onBrowseFile_"
          aria-label="$i18n{selectDriverButtonAriaLabel}">
        $i18n{selectDriverButtonText}
      </cr-button>
    </div>
  </div>
  <div slot="dialog-buttons">
    <div> <!-- Left group -->
      <div class="eula" id="eulaUrl" hidden="[[!eulaUrl_]]">
        <a href="[[eulaUrl_]]" target="_blank">$i18n{printerEulaNotice}</a>
      </div>
    </div>
    <div> <!-- Right group -->
      <cr-button class="cancel-button" on-click="onCancelClick_">
        $i18n{cancel}
      </cr-button>
      <cr-button class="action-button" id="addPrinterButton"
          disabled="[[!canAddPrinter_(activePrinter.ppdManufacturer,
                                      activePrinter.ppdModel,
                                      activePrinter.printerPPDPath,
                                      addPrinterInProgress_,
                                      isManufacturerInvalid_,
                                      isModelInvalid_)]]"
          on-click="addPrinter_">
        $i18n{addPrinterButtonText}
      </cr-button>
    </div>
  </div>
</add-printer-dialog>
<!--_html_template_end_-->`;
}
