import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style cups-printer-shared"></style>
<add-printer-dialog>
  <div slot="dialog-title">
    <iron-icon
      hidden="[[!pendingPrinter_.isManaged]]"
      aria-label="$i18n{viewPrinterDialogManagedLabel}"
      icon="cr20:domain">
    </iron-icon>
    [[getDialogTitle_(pendingPrinter_.isManaged)]]
    <printer-dialog-error error-text="[[errorText_]]">
    </printer-dialog-error>
  </div>
  <div slot="dialog-body">
    <div class="settings-box first two-line">
      <cr-input class="printer-name-input"
          id="printerName"
          value="{{pendingPrinter_.printerName}}"
          on-input="onPrinterInfoChange_"
          label="$i18n{printerName}"
          aria-label="$i18n{printerName}"
          readonly="[[pendingPrinter_.isManaged]]"
          maxlength=64>
      </cr-input>
    </div>
    <div class="settings-box two-line">
      <cr-input label="$i18n{printerAddress}"
          aria-label="$i18n{printerAddress}"
          id="printerAddress"
          on-input="onPrinterInfoChange_"
          value="{{pendingPrinter_.printerAddress}}"
          disabled="[[!isInputFieldEnabled_(networkProtocolActive_,
              pendingPrinter_.printServerUri)]]"
          maxlength=63
          readonly="[[isInputFieldReadonly_(pendingPrinter_.isManaged,
              isOnline_)]]">
      </cr-input>
    </div>
    <div class="settings-box two-line">
      <div class="start">
        <div id="printerProtocol" class="cr-form-field-label"
            aria-hidden="true">
          $i18n{printerProtocol}
        </div>
        <div class="secondary">
          <select class="md-select" aria-labelledby="printerProtocol"
              value="[[pendingPrinter_.printerProtocol]]"
              on-change="onProtocolChange_"
              disabled="[[!protocolSelectEnabled_(
                  networkProtocolActive_,
                  pendingPrinter_.printServerUri,
                  pendingPrinter_.isManaged,
                  isOnline_)]]">
            <option value="ipp">
              $i18n{printerProtocolIpp}
            </option>
            <option value="ipps">
              $i18n{printerProtocolIpps}
            </option>
            <option value="http"
                disabled="[[isAutoconfPrinter_(pendingPrinter_.*)]]">
              $i18n{printerProtocolHttp}
            </option>
            <option value="https"
                disabled="[[isAutoconfPrinter_(pendingPrinter_.*)]]">
              $i18n{printerProtocolHttps}
            </option>
            <option value="socket"
                disabled="[[isAutoconfPrinter_(pendingPrinter_.*)]]">
              $i18n{printerProtocolAppSocket}
            </option>
            <option value="lpd"
                disabled="[[isAutoconfPrinter_(pendingPrinter_.*)]]">
              $i18n{printerProtocolLpd}
            </option>
            <option value="usb" disabled="[[networkProtocolActive_]]">
              $i18n{printerProtocolUsb}
            </option>
            <option value="ippusb" disabled="[[networkProtocolActive_]]">
              $i18n{printerProtocolIppUsb}
            </option>
          </select>
        </div>
      </div>
    </div>
    <div class="settings-box two-line">
      <cr-input id="printerQueue" label="$i18n{printerQueue}"
          aria-label="$i18n{printerQueue}"
          value="{{pendingPrinter_.printerQueue}}"
          on-input="onPrinterInfoChange_"
          maxlength=64
          disabled="[[!isInputFieldEnabled_(networkProtocolActive_,
              pendingPrinter_.printServerUri)]]"
          readonly="[[isInputFieldReadonly_(pendingPrinter_.isManaged,
              isOnline_)]]">
      </cr-input>
    </div>
    <div class="settings-box two-line">
      <cr-input label="$i18n{printerURI}" readonly
          aria-label="$i18n{printerURI}"
          value="[[getPrinterUri_(pendingPrinter_)]]"
          disabled="[[!isInputFieldEnabled_(networkProtocolActive_,
              pendingPrinter_.printServerUri)]]"
          readonly="[[pendingPrinter_.isManaged]]">
      </cr-input>
    </div>
    <template id="makeAndModelSection" is="dom-if"
        if="[[!isAutoconfPrinter_(pendingPrinter_.*)]]">
      <div class="settings-box two-line"
          hidden="[[shouldHideMakeAndModel_(pendingPrinter_,
                pendingPrinter_.isManaged, pendingPrinter_.ppdManufacturer,
                pendingPrinter_.ppdModel)]]">
        <cr-searchable-drop-down items="[[manufacturerList]]"
            id="printerPPDManufacturer"
            label="$i18n{printerManufacturer}"
            aria-label="$i18n{printerManufacturer}"
            value="{{pendingPrinter_.ppdManufacturer}}"
            readonly="[[isInputFieldReadonly_(pendingPrinter_.isManaged,
                isOnline_)]]"
            invalid="{{isManufacturerInvalid_}}">
        </cr-searchable-drop-down>
      </div>
      <div class="settings-box two-line"
          hidden="[[shouldHideMakeAndModel_(pendingPrinter_,
                pendingPrinter_.isManaged, pendingPrinter_.ppdManufacturer,
                pendingPrinter_.ppdModel)]]">
        <cr-searchable-drop-down items="[[modelList]]"
            id="printerPPDModel"
            label="$i18n{printerModel}"
            value="{{pendingPrinter_.ppdModel}}"
            readonly="[[isInputFieldReadonly_(pendingPrinter_.isManaged,
                isOnline_)]]"
            invalid="{{isModelInvalid_}}">
        </cr-searchable-drop-down>
      </div>
      <div class="settings-box two-line"
          hidden="[[!pendingPrinter_.isManaged]]">
        <cr-input label="$i18n{managedPrinterPPD}"
            aria-label="$i18n{managedPrinterPPD}" id="managedPrinterPPD"
            value="[[userPPD_]]" readonly>
        </cr-input>
      </div>
      <div id="ppdLabel" class="cr-form-field-label">
        <div class="select-ppd-and-view">
          <cr-button class="ppd-button" on-click="onViewPpd_"
                     disabled="[[printerInfoChanged_]]">
            $i18n{cupsPrintersViewPpd}
          </cr-button>
          <localized-link localized-string="$i18n{selectDriver}"
                          link-url="$i18n{printingCUPSPrintPpdLearnMoreUrl}"
                          hidden="[[pendingPrinter_.isManaged]]">
          </localized-link>
        </div>
      </div>
      <div class="settings-box two-line"
           hidden="[[pendingPrinter_.isManaged]]">
        <cr-input class="browse-file-input" readonly input-tabindex="-1"
            value="[[userPPD_]]" aria-labelledby="ppdLabel"
            error-message="$i18n{selectDriverErrorMessage}"
            invalid="[[invalidPPD_]]" id="printerPPD">
        </cr-input>
        <cr-button class="browse-button" on-click="onBrowseFile_"
            disabled="[[!isOnline_]]"
            aria-label="$i18n{selectDriverButtonAriaLabel}">
          $i18n{selectDriverButtonText}
        </cr-button>
      </div>
    </template>
  </div>
  <div slot="dialog-buttons">
    <div>
      <div class="eula" id="eulaUrl" hidden="[[!eulaUrl_]]">
        <a href="[[eulaUrl_]]" target="_blank">$i18n{printerEulaNotice}</a>
      </div>
    </div>
    <div>
      <cr-button class="cancel-button" on-click="onCancelClick_"
          hidden="[[pendingPrinter_.isManaged]]">
        $i18n{cancel}
      </cr-button>
      <cr-button class="action-button" on-click="onSaveClick_"
          disabled="[[!canSavePrinter_(pendingPrinter_.*,
              printerInfoChanged_,
              isOnline_, isManufacturerInvalid_, isModelInvalid_)]]"
              hidden="[[pendingPrinter_.isManaged]]">
        $i18n{editPrinterButtonText}
      </cr-button>
      <cr-button class="close-button" on-click="onCancelClick_"
       hidden="[[!pendingPrinter_.isManaged]]">
       $i18n{close}
      </cr-button>
    </div>
  </div>
</add-printer-dialog>
<!--_html_template_end_-->`;
}
