import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cups-printer-shared iron-flex iron-flex-alignment
    iron-flex-factors">:host{display:flex;flex-direction:column}#no-search-results{margin-top:20px}#show-more-container{align-items:center;min-height:var(--cr-section-min-height)}#show-more-line-separator{border-bottom:var(--cr-separator-line);margin-inline-end:20px;margin-inline-start:60px;position:relative;width:596px}#show-more-icon{--cr-icon-button-margin-end:0}#show-more-text{flex:1}.list-frame{padding-inline:0}</style>

<cr-action-menu role-description="$i18n{menu}">
  <button id="viewButton" class="dropdown-item" on-click="onViewClick_">
    $i18n{viewPrinter}
  </button>
  <button id="removeButton" class="dropdown-item" disabled>
    $i18n{removePrinter}
  </button>
</cr-action-menu>

<iron-list class="list-frame vertical-list flex-auto" id="printerEntryList"
    items="[[filteredPrinters_]]">
  <template>
    <settings-cups-printers-entry printer-entry="[[item]]"
        tabindex$="[[tabIndex]]" last-focused="{{lastFocused_}}"
        list-blurred="{{listBlurred_}}" focus-row-index="[[index]]"
        iron-list-tab-index="[[tabIndex]]">
    </settings-cups-printers-entry>
  </template>
</iron-list>
<template is="dom-if" id="show-more-button-section"
    if="[[shouldPrinterListBeCollapsed_(searchTerm, enterprisePrinters.*,
    hasShowMoreBeenTapped_)]]" restamp>
  <div id="show-more-line-separator"></div>
  <div class="list-frame layout horizontal" id="show-more-container">
    <div id="show-more-text">$i18n{showMorePrinters}</div>
    <cr-icon-button class="action-button" id="show-more-icon"
        iron-icon="cr:expand-more"
        on-click="onShowMoreClick_"
        title="$i18n{showMorePrinters}">
    </cr-icon-button>
  </div>
</template>
<div id="no-search-results"
    hidden="[[!showNoSearchResultsMessage_(searchTerm,
        filteredPrinters_.*)]]">
  $i18n{noSearchResults}
</div>
<!--_html_template_end_-->`;
}
