import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cups-printer-shared">:host{display:flex;flex-direction:column}#no-search-results{margin-top:20px}.list-frame{padding-inline:0}</style>

<iron-list class="list-frame vertical-list flex-auto" id="printerEntryList"
    items="[[filteredPrinters_]]">
  <template>
    <settings-cups-printers-entry printer-entry="[[item]]"
        tabindex$="[[tabIndex]]" last-focused="{{lastFocused_}}"
        list-blurred="{{listBlurred_}}" focus-row-index="[[index]]"
        iron-list-tab-index="[[tabIndex]]"
        user-printers-allowed="[[userPrintersAllowed]]"
        saving-printer="[[savingPrinter_]]"
        num-printers="[[printersCount]]">
    </settings-cups-printers-entry>
  </template>
</iron-list>
<div id="no-search-results"
    hidden="[[!showNoSearchResultsMessage_(searchTerm,
        filteredPrinters_.*)]]">
  $i18n{noSearchResults}
</div>
<!--_html_template_end_-->`;
}
