import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cups-printer-shared action-link iron-flex
    iron-flex-alignment">.custom-list-item-bottom{border-bottom:var(--cr-separator-line);min-height:var(--cr-section-min-height)}.custom-list-item-top{min-height:var(--cr-section-min-height)}:host(:not([nearby-printers-empty_])) .custom-list-item-top{border-top:var(--cr-separator-line)}.padded{padding:20px}#addManualPrinterButton{background:none}#cloudOffIcon{--iron-icon-fill-color:var(--cros-icon-color-secondary);margin-top:10px}#connectionMessage{padding-inline-start:20px}#noConnectivityContentContainer{border-bottom:var(--cr-separator-line);padding-inline-start:20px}#noSearchResultsMessage{color:var(--md-loading-message-color);font-size:16px;font-weight:500;margin-top:80px;text-align:center}#savedPrintersContainer{border-bottom:var(--cr-separator-line);padding-bottom:8px;padding-inline-start:var(--cr-section-padding)}#savedPrintersDescription{height:64px;margin-bottom:8px;padding-inline-start:0}#enterprisePrintersContainer{border-top:var(--cr-separator-line);padding-inline-start:var(--cr-section-padding)}:host(:not([has-active-network-connection])) .add-printer-section,:host(:not([has-active-network-connection])) .nearby-printers-section{opacity:var(--cr-disabled-opacity);pointer-events:none}#nearbyPrinters{display:flex}#nearbyPrintersDescription{flex:1}#nearbyPrinterToggleButton{margin:0}#collapsibleSection{padding-inline-end:0;padding-inline-start:20px;padding-bottom:20px;padding-top:0}#helpSection{align-items:center;background-color:var(--cros-sys-app_base_shaded);border-radius:12px;display:flex;margin-bottom:8px;margin-inline:-6px 14px;padding:16px 12px}#helpIconSection{--iron-icon-height:48px;--iron-icon-width:48px;flex-basis:48px}#helpSectionText{flex:1;margin-inline-start:12px}.help-title{color:var(--cros-text-color-primary);font:var(--cros-button-1-font);margin-bottom:5px}#noSavedPrinters{align-items:center;display:flex;height:48px;margin:8px 0;padding-inline-start:20px}#addPrinterSection{height:64px;padding-inline:0}#addPrinterSectionContainer{padding-inline-start:10px;padding-top:8px}cr-button{border-radius:18px}cr-button.prefix-icon{padding-inline:12px 16px}.section-title{font:var(--cros-button-2-font)}</style>


<cr-link-row id="printManagement"
    on-click="onClickPrintManagement_"
    external
    using-slotted-label
    sub-label="$i18n{printJobsSublabel}"
    deep-link-focus-id$="[[Setting.kPrintJobs]]">
  <div slot="label" class="section-title">$i18n{printJobsTitle}
  </div>
</cr-link-row>
<div class="hr"></div>

<template is="dom-if" if="[[!hasActiveNetworkConnection]]">
  <div id="noConnectivityContentContainer"
      class="layout horizontal padded">
    <iron-icon id="cloudOffIcon" icon="os-settings:cloud-off"></iron-icon>
    <div id="connectionMessage" class="layout vertical">
      <div role="heading" aria-level="2"
           class="section-title">$i18n{noInternetConnection}</div>
      <div class="secondary">$i18n{checkNetworkAndTryAgain}</div>
    </div>
  </div>
</template>

<div id="savedPrintersContainer">
  <div id="savedPrintersDescription" class="settings-box first">
    <div class="start">
      <span role="heading" aria-level="2"
            aria-label$="[[savedPrintersAriaLabel_]]" class="section-title">
        $i18n{savedPrintersTitle}
      </span>
      <div class="secondary" aria-hidden="true">
        $i18n{savedPrintersSubtext}
      </div>
    </div>
  </div>
  <div id="noSavedPrinters" class="list-frame secondary"
      hidden="[[doesAccountHaveSavedPrinters_(savedPrinters_)]]">
    $i18n{noSavedPrinters}
  </div>

  <settings-cups-saved-printers id="savedPrinters"
      active-printer="{{activePrinter}}"
      search-term="[[searchTerm]]"
      printers-count="{{savedPrinterCount_}}">
  </settings-cups-saved-printers>
</div>
<template is="dom-if" if="[[attemptedLoadingPrinters_]]">
  <div id="nearbyPrintersRevamp"
      class="settings-box first nearby-printers-section"
      hidden="[[!hasActiveNetworkConnection]]">
    <div id="nearbyPrintersDescription" aria-hidden="true">
      <div id="availablePrintersReadyTitle"
          aria-label$="[[nearbyPrintersAriaLabel_]]"
          role="heading" aria-level="2"
          class="section-title">
        $i18n{availablePrintersReadyTitle}
      </div>
      <div id="availablePrintersReadySubtext" class="secondary"
          hidden="[[!nearbyPrintersExpanded_]]">
        $i18n{availablePrintersReadySubtext}
      </div>
    </div>
    <span id="nearbyPrintersAriaLabel" hidden>
      [[nearbyPrintersAriaLabel_]]
    </span>
    <cr-icon-button id="nearbyPrinterToggleButton" on-click="toggleClicked_"
        iron-icon="[[getIconDirection_(nearbyPrintersExpanded_)]]"
        aria-expanded="[[nearbyPrintersExpanded_]]"
        aria-label="$i18n{availablePrintersReadyTitle}"
        aria-describedby="availablePrintersReadySubtext
            nearbyPrintersAriaLabel">
    </cr-icon-button>
    <cr-policy-pref-indicator
        pref="[[prefs.native_printing.user_native_printers_allowed]]"
        icon-aria-label="$i18n{printingPageTitle}">
    </cr-policy-pref-indicator>
  </div>

  <template is="dom-if" if="[[hasActiveNetworkConnection]]" restamp>
    <div id="collapsibleSection"
        hidden="[[!nearbyPrintersExpanded_]]">
      <div id="helpSection">
        <div id="helpIconSection">
          <iron-icon icon="os-settings:printer-setup"></iron-icon>
        </div>
        <div id="helpSectionText">
          <div class="help-title">
            $i18n{helpSectionTitle}
          </div>
          <div class="secondary">
            <localized-link id="helpLink" class="secondary"
                localized-string="$i18n{helpSectionDescription}"
                link-url="$i18n{printingCUPSPrintLearnMoreUrl}"
                on-link-clicked="onHelpLinkClicked_">
            </localized-link>
          </div>
        </div>
      </div>
      <settings-cups-nearby-printers search-term="[[searchTerm]]"
          user-printers-allowed="[[!prefs.native_printing.
              user_native_printers_allowed.value]]"
          active-printer="{{activePrinter}}"
          printers-count="{{nearbyPrinterCount_}}">
      </settings-cups-nearby-printers>
      <div id="addPrinterSection" class="list-frame add-printer-section">
        <div id="addPrinterSectionContainer"
            class="layout horizontal center custom-list-item-top">
          <cr-button id="addManualPrinterButton"
              class="prefix-icon" on-click="onAddPrinterClick_"
              disabled="[[!addPrinterButtonActive_(hasActiveNetworkConnection,
                  prefs.native_printing.user_native_printers_allowed.value)]]"
              deep-link-focus-id$="[[Setting.kAddPrinter]]">
            <iron-icon icon="cr:add" slot="prefix-icon"></iron-icon>
            $i18n{addCupsPrinterManually}
          </cr-button>
        </div>
      </div>
    </div>
  </template>
</template>

<template is="dom-if"
    if="[[doesAccountHaveEnterprisePrinters_(enterprisePrinters_)]]"
    restamp>
  <div id="enterprisePrintersContainer">
    <div class="settings-box first">
      <div class="start">
        <span aria-label$="[[enterprisePrintersAriaLabel_]]">
          $i18n{enterprisePrintersTitle}
        </span>
      </div>
    </div>
    <settings-cups-enterprise-printers
        id="enterprisePrinters"
        active-printer="{{activePrinter}}"
        search-term="[[searchTerm]]"
        printers-count="{{enterprisePrinterCount_}}">
    </settings-cups-enterprise-printers>
  </div>
</template>

<settings-cups-add-printer-dialog id="addPrinterDialog"
    on-close="onAddPrinterDialogClose_">
</settings-cups-add-printer-dialog>

<template is="dom-if" if="[[showCupsEditPrinterDialog_]]" restamp>
  <settings-cups-edit-printer-dialog id="editPrinterDialog"
      active-printer="{{activePrinter}}"
      on-close="onEditPrinterDialogClose_">
  </settings-cups-edit-printer-dialog>
</template>

<cr-toast id="errorToast" duration="3000">
  <div class="error-message" id="addPrinterDoneMessage">
    [[addPrinterResultText_]]
  </div>
</cr-toast>

<cr-toast id="printServerErrorToast" duration="3000">
  <div class="error-message" id="addPrintServerDoneMessage">
    [[addPrintServerResultText_]]
  </div>
</cr-toast>
<!--_html_template_end_-->`;
}
