import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared action-link">.settings-box:first-of-type{border-top:none}#add-user-button{margin-inline-start:var(--cr-section-indent-padding)}.block{display:block}#header{padding-inline-start:20px}</style>
<div class="settings-box" hidden$="[[!isUserListManaged_]]">
  $i18n{settingsManagedLabel}
</div>
<div class="settings-box"
    hidden$="[[shouldHideModifiedByOwnerLabel_(
        isUserListManaged_, isOwner_)]]">
  $i18n{usersModifiedByOwnerLabel}
</div>
<settings-toggle-button
    pref="{{prefs.cros.accounts.allowBWSI}}"
    id="allowGuestBrowsing"
    label="$i18n{guestBrowsingLabel}"
    disabled="[[isEditingDisabled_(isOwner_, isUserListManaged_)]]"
    deep-link-focus-id$="[[Setting.kGuestBrowsingV2]]">
</settings-toggle-button>
<settings-toggle-button
    pref="{{prefs.cros.accounts.showUserNamesOnSignIn}}"
    id="showUserNamesOnSignIn"
    label="$i18n{showOnSigninLabel}"
    disabled="[[isEditingDisabled_(isOwner_, isUserListManaged_)]]"
    deep-link-focus-id$="[[Setting.kShowUsernamesAndPhotosAtSignInV2]]">
</settings-toggle-button>
<settings-toggle-button
    pref="{{prefs.cros.accounts.allowGuest}}"
    id="restrictSignIn"
    label="$i18n{restrictSigninLabel}"
    sub-label="$i18n{restrictSigninDescription}"
    disabled="[[isEditingDisabled_(isOwner_, isUserListManaged_)]]"
    deep-link-focus-id$="[[Setting.kRestrictSignInV2]]"
    inverted>
</settings-toggle-button>
<template is="dom-if"
    if="[[isEditingUsersEnabled_(isOwner_, isUserListManaged_,
        prefs.cros.accounts.allowGuest.value, isChild_)]]">
  <div class="list-frame" >
    <settings-user-list prefs="[[prefs]]">
    </settings-user-list>
    <div id="add-user-button" class="list-item">
      <a is="action-link"
          deep-link-focus-id$="[[Setting.kAddToUserAllowlistV2]]"
          class="list-button" on-click="openAddUserDialog_">
        $i18n{addUsers}
      </a>
    </div>
  </div>
</template>
<settings-users-add-user-dialog id="addUserDialog"
    on-close="onAddUserDialogClose_">
</settings-users-add-user-dialog>
<!--_html_template_end_-->`;
}
