// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { sendWithPromise } from 'chrome://resources/js/cr.js';
let instance = null;
export class PrivacyHubBrowserProxyImpl {
    getInitialMicrophoneHardwareToggleState() {
        return sendWithPromise('getInitialMicrophoneHardwareToggleState');
    }
    getInitialMicrophoneMutedBySecurityCurtainState() {
        return sendWithPromise('getInitialMicrophoneMutedBySecurityCurtainState');
    }
    getInitialCameraSwitchForceDisabledState() {
        return sendWithPromise('getInitialCameraSwitchForceDisabledState');
    }
    getInitialGeolocationAccessLevelState() {
        return sendWithPromise('getInitialGeolocationAccessLevelState');
    }
    getCameraLedFallbackState() {
        return sendWithPromise('getCameraLedFallbackState');
    }
    getCurrentTimeZoneName() {
        return sendWithPromise('getCurrentTimeZoneName');
    }
    getCurrentSunriseTime() {
        return sendWithPromise('getCurrentSunriseTime');
    }
    getCurrentSunsetTime() {
        return sendWithPromise('getCurrentSunsetTime');
    }
    static getInstance() {
        return instance || (instance = new PrivacyHubBrowserProxyImpl());
    }
    static setInstanceForTesting(obj) {
        instance = obj;
    }
}
