import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">.list-item:not(:last-of-type){border-bottom:var(--cr-separator-line)}#onOffText[on]{color:var(--cros-sys-primary)}#accessStatusRow:hover[actionable]{background-color:var(--cr-hover-background-color)}.subsection{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-indent-padding)}.subsection>cr-link-row{padding-inline-end:0;padding-inline-start:0}h2{padding-inline-start:var(--cr-section-padding)}</style>
<div
    id="accessStatusRow"
    class="settings-box first"
    actionable$="[[!shouldDisableCameraToggle_]]"
    on-click="onAccessStatusRowClick_">
  <div class="start settings-box-text" aria-hidden="true">
    <div id="onOffText" on$="[[prefs.ash.user.camera_allowed.value]]">
      [[computeOnOffText_(prefs.ash.user.camera_allowed.value)]]
    </div>
    <div id="onOffSubtext" class="secondary">
      [[cameraAccessStateText_]]
    </div>
  </div>
  <div id="cameraToggleWrapper">
    <cr-toggle
        id="cameraToggle"
        checked="{{prefs.ash.user.camera_allowed.value}}"
        disabled="[[shouldDisableCameraToggle_]]"
        on-click="onCameraToggleClick_"
        aria-label="$i18n{cameraToggleTitle}"
        aria-description="[[cameraAccessStateText_]]">
    </cr-toggle>
  </div>
</div>
<div id="cameraListSection" class="list-frame">
  <template is="dom-if" if="[[isCameraListEmpty_]]" restamp>
    <div id="noCameraText" class="list-item">
      $i18n{noCameraConnectedText}
    </div>
  </template>
  <template is="dom-if" if="[[!isCameraListEmpty_]]" restamp>
    <template id="cameraList" is="dom-repeat" items="[[connectedCameraNames_]]">
      <div class="list-item">
        <span id="cameraName"
            hidden$="[[!prefs.ash.user.camera_allowed.value]]">
          [[item]]
        </span>
        <span id="cameraNameWithBlockedSuffix"
            hidden$="[[prefs.ash.user.camera_allowed.value]]">
          [[i18n('privacyHubSensorNameWithBlockedSuffix', item)]]
        </span>
      </div>
    </template>
  </template>
</div>
<div class="hr"></div>
<div id="appsSection">
  <h2 id="appsSectionTitle">$i18n{privacyHubAppsSectionTitle}</h2>
  <template is="dom-if" if="[[prefs.ash.user.camera_allowed.value]]" restamp>
    <div class="list-frame">
      <template id="appList" is="dom-repeat" items="[[appList_]]" as="app"
          sort="alphabeticalSort_">
        <settings-privacy-hub-app-permission-row
            class="list-item"
            app="[[app]]"
            permission-type="kCamera">
        </settings-privacy-hub-app-permission-row>
      </template>
    </div>
  </template>
  <template is="dom-if" if="[[!prefs.ash.user.camera_allowed.value]]" restamp>
    <div id="noAppHasAccessText" class="settings-box-text subsection">
      $i18n{noAppCanUseCameraText}
    </div>
  </template>
</div>
<div class="hr"></div>
<div id="websitesSection">
  <h2 id="websitesSectionTitle">$i18n{websitesSectionTitle}</h2>
  <template is="dom-if" if="[[prefs.ash.user.camera_allowed.value]]" restamp>
    <cr-link-row
        id="managePermissionsInChromeRow"
        class="subsection"
        start-icon="os-settings:chrome"
        label="$i18n{manageCameraPermissionsInChromeText}"
        on-click="onManagePermissionsInChromeRowClick_"
        external>
    </cr-link-row>
  </template>
  <template is="dom-if" if="[[!prefs.ash.user.camera_allowed.value]]" restamp>
    <div id="noWebsiteHasAccessText" class="settings-box-text subsection">
      $i18n{noWebsiteCanUseCameraText}
    </div>
  </template>
</div>
<div class="hr"></div>
<div id="systemServicesSection">
  <h2 id="systemServicesSectionTitle">
    $i18n{privacyHubSystemServicesSectionTitle}
  </h2>
  <div class="list-frame">
    <template id="systemServiceList" is="dom-repeat" items="[[systemApps_]]"
        as="app" sort="alphabeticalSort_">
      <settings-privacy-hub-system-service-row
          class="list-item"
          name="[[app.name]]"
          permission-state="[[getSystemServicesPermissionText_(
            prefs.ash.user.camera_allowed.value)]]"
          icon-source="chrome://app-icon/[[app.id]]/64">
      </settings-privacy-hub-system-service-row>
    </template>
  </div>
</div>
<!--_html_template_end_-->`;
}
