import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">.list-item:not(:last-of-type){border-bottom:var(--cr-separator-line)}div{display:inline-flex}#managedIconDiv{padding-top:var(--cr-section-vertical-padding);padding-left:var(--cr-section-padding)}#managedIcon{margin-inline-end:0px}</style>

<div>
  <template is="dom-if" if="[[isSecondaryUser_]]">
    <div id="managedIconDiv">
      <cr-tooltip-icon
          class="secondary-accounts-disabled-tooltip"
          icon-class="cr:group"
          tooltip-text="[[settingControlledByPrimaryUserText_()]]"
          icon-aria-label="[[settingControlledByPrimaryUserText_()]]">
    </cr-tooltip-icon>
    </div>
  </template>
  <template is="dom-if" if="[[showPrivacyHubLocationControl_]]" restamp>
    <settings-toggle-button id="geoLocationAccuracyToggle"
      pref="{{prefs.ash.user.geolocation_accuracy_enabled}}"
      disabled="[[isSecondaryUser_]]"
      label="$i18n{geolocationAccuracyToggleTitle}"
      sub-label="$i18n{geolocationAccuracyToggleText}"
      learn-more-url="$i18n{geolocationAccuracyLearnMoreUrl}">
    </settings-toggle-button>
  </template>
</div>
<!--_html_template_end_-->`;
}
