import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">#geolocationModeDescriptionDiv{padding-bottom:var(--cr-section-vertical-padding);padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}#dialogTitleIcon{fill:var(--cros-sys-primary);height:32px;margin-bottom:var(--cr-section-vertical-padding);width:32px}#dialogTitle{font-size:18px}#changeAccessButton{margin-inline-start:var(--cr-icon-button-margin-start)}h2{padding-inline-start:var(--cr-section-padding)}.list-item:not(:last-of-type){border-bottom:var(--cr-separator-line)}.subsection{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-indent-padding)}.subsection>cr-link-row{padding-inline-end:0;padding-inline-start:0}settings-dropdown-menu{--md-select-width:100%}controlled-radio-button{align-items:flex-start;padding-top:var(--cr-section-vertical-padding);padding-bottom:var(--cr-section-vertical-padding)}controlled-radio-button div{color:var(--cr-primary-text-color) !important}settings-privacy-hub-system-service-row{cursor:pointer}cr-dialog{--cr-dialog-body-padding-horizontal:32px;--cr-dialog-button-container-padding-bottom:32px;--cr-dialog-button-container-padding-horizontal:32px;--cr-dialog-title-slot-padding-end:32px;--cr-dialog-title-slot-padding-start:32px;--cr-dialog-title-slot-padding-top:32px}</style>


<div class="settings-box first">
  <div class="start settings-box-text">
    <div id="geolocationStatus" class="cr-primary-text">
      [[computeGeolocationAccessLevelText_(systemGeolocationAccessLevel_)]]
    </div>
    <div id="geolocationStatusDescription" class="cr-secondary-text">
      [[computeGeolocationAccessLevelDescriptionText_(systemGeolocationAccessLevel_)]]
    </div>
  </div>
  <template is="dom-if" if="[[isSecondaryUser_]]">
    <cr-tooltip-icon
        class="secondary-accounts-disabled-tooltip"
        icon-class="cr:group"
        tooltip-text="[[settingControlledByPrimaryUserText_()]]"
        icon-aria-label="[[settingControlledByPrimaryUserText_()]]">
    </cr-tooltip-icon>
  </template>
  <controlled-button
      id="changeAccessButton"
      class="action-button"
      label="$i18n{geolocationChangeAccessButtonText}"
      on-click="showManageGeolocationDialog_"
      disabled="[[!isGeolocationModifiable_(prefs.ash.user.geolocation_access_level.*)]]"
      pref="[[prefs.ash.user.geolocation_access_level]]">
  </controlled-button>
</div>

<div class="hr"></div>
<div id="appsSection">
  <h2 id="appsSectionTitle">$i18n{privacyHubAppsSectionTitle}</h2>
  <template is="dom-if" if="[[isGeolocationAllowedForApps_]]" restamp>
    <div class="list-frame">
      <template id="appList" is="dom-repeat" items="[[appList_]]" as="app"
          sort="alphabeticalSort_">
        <settings-privacy-hub-app-permission-row
            class="list-item"
            app="[[app]]"
            permission-type="kLocation">
        </settings-privacy-hub-app-permission-row>
      </template>
    </div>
  </template>
  <template is="dom-if" if="[[!isGeolocationAllowedForApps_]]" restamp>
    <div id="noAppHasAccessText" class="settings-box-text subsection">
      $i18n{noAppCanUseGeolocationText}
    </div>
  </template>
</div>

<div class="hr"></div>
<div id="websitesSection">
  <h2 id="websitesSectionTitle">$i18n{websitesSectionTitle}</h2>
  <div class="subsection">
    <template is="dom-if" if="[[isGeolocationAllowedForApps_]]" restamp>
      <cr-link-row
          id="managePermissionsInChromeRow"
          start-icon="os-settings:chrome"
          label="$i18n{manageLocationPermissionsInChromeText}"
          on-click="onManagePermissionsInChromeRowClick_"
          external>
      </cr-link-row>
    </template>
    <template is="dom-if" if="[[!isGeolocationAllowedForApps_]]" restamp>
      <div id="noWebsiteHasAccessText" class="settings-box-text">
        $i18n{noWebsiteCanUseLocationText}
      </div>
    </template>
  </div>
</div>

<div class="hr"></div>
<div id="systemServicesSection">
  <h2 id="systemServicesSectionTitle">
    $i18n{privacyHubSystemServicesSectionTitle}
  </h2>
  <div class="list-frame">
      <settings-privacy-hub-system-service-row
          class="list-item"
          on-click="onTimeZoneClick_"
          name="$i18n{privacyHubSystemServicesAutomaticTimeZoneName}"
          permission-state="[[automaticTimeZoneText_]]"
          icon-source="chrome://app-icon/$i18n{osSettingsAppId}/64">
      </settings-privacy-hub-system-service-row>
      <settings-privacy-hub-system-service-row
          class="list-item"
          on-click="onNightLightClick_"
          name="$i18n{privacyHubSystemServicesSunsetScheduleName}"
          permission-state="[[nightLightText_]]"
          icon-source="chrome://app-icon/$i18n{osSettingsAppId}/64">
      </settings-privacy-hub-system-service-row>
      <settings-privacy-hub-system-service-row
          class="list-item"
          on-click="onDarkThemeClick_"
          name="$i18n{privacyHubSystemServicesDarkThemeName}"
          permission-state="[[darkThemeText_]]"
          icon-source="chrome://app-icon/$i18n{osSettingsAppId}/64">
      </settings-privacy-hub-system-service-row>
      <settings-privacy-hub-system-service-row
          class="list-item"
          on-click="onLocalWeatherClick_"
          name="$i18n{privacyHubSystemServicesLocalWeatherName}"
          permission-state="[[localWeatherText_]]"
          icon-source="chrome://app-icon/$i18n{osSettingsAppId}/64">
      </settings-privacy-hub-system-service-row>
  </div>
</div>

<div class="hr"></div>
<cr-link-row
    id="geolocationAdvancedAreaLinkRow"
    on-click="onGeolocationAdvancedAreaClick_"
    deep-link-focus-id$="[[Setting.kGeolocationAdvanced]]"
    using-slotted-label>
  <div slot="label">$i18n{geolocationAdvancedAreaTitle}</div>
</cr-link-row>

<template is="dom-if" if="[[shouldShowManageGeolocationDialog_]]" restamp>
    <cr-dialog id="systemGeolocationDialog" show-on-attach>
      <div slot="title" id="dialogTitleDiv">
        <iron-icon id="dialogTitleIcon" icon="cr:location-on"></iron-icon>
        <div id="dialogTitle" class="title">$i18n{geolocationAreaTitle}</div>
      </div>
      <div slot="body">
        <settings-radio-group id="manageGeolocationRadioGroup"
              pref="{{prefs.ash.user.geolocation_access_level}}" no-set-pref>
            <controlled-radio-button
                id="systemGeolocationAccessAllowedForAll"
                name="[[geolocationAccessLevelPrefValues_.ALLOWED]]"
                pref="[[prefs.ash.user.geolocation_access_level]]">
              <div class="cr-title-text">
                $i18n{geolocationAccessLevelAllowed}
              </div>
              <localized-link class="cr-secondary-text"
                  localized-string="$i18n{geolocationDialogAllowedModeDescription}"
                  link-url="$i18n{systemGeolocationDialogLearnMoreUrl}">
              </localized-link>
            </controlled-radio-button>
            <controlled-radio-button
                id="systemGeolocationAccessOnlyAllowedForSystem"
                name="[[geolocationAccessLevelPrefValues_.ONLY_ALLOWED_FOR_SYSTEM]]"
                pref="[[prefs.ash.user.geolocation_access_level]]">
              <div class="cr-title-text">
                $i18n{geolocationAccessLevelOnlyAllowedForSystem}
              </div>
              <localized-link class="cr-secondary-text"
                  localized-string="$i18n{geolocationDialogOnlyAllowedForSystemModeDescription}"
                  link-url="$i18n{systemGeolocationDialogLearnMoreUrl}">
              </localized-link>
            </controlled-radio-button>
            <controlled-radio-button
                id="systemGeolocationAccessBlocked"
                name="[[geolocationAccessLevelPrefValues_.DISALLOWED]]"
                pref="[[prefs.ash.user.geolocation_access_level]]">
              <div class="cr-title-text">
                $i18n{geolocationAccessLevelDisallowed}
              </div>
              <localized-link class="cr-secondary-text"
                  localized-string="$i18n{geolocationDialogBlockedModeDescription}"
                  link-url="$i18n{systemGeolocationDialogLearnMoreUrl}">
              </localized-link>
            </controlled-radio-button>
          </settings-radio-group>
      </div>
      <div slot="button-container">
        <cr-button id="cancelButton"
            class="cancel-button"
            on-click="onCancelClicked_">
          $i18n{geolocationAccessLevelDialogCancelButton}
        </cr-button>
        <cr-button id="confirmButton"
            class="action-button"
            on-click="onConfirmClicked_">
          $i18n{geolocationAccessLevelDialogConfirmButton}
        </cr-button>
      </div>
    </cr-dialog>
  </div>
</template>
<!--_html_template_end_-->`;
}
