import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">.list-item:not(:last-of-type){border-bottom:var(--cr-separator-line)}.list-frame{padding-bottom:8px;padding-top:8px}.separator{margin:0}</style>

<template is="dom-if" if="[[showPrivacyHubLocationControl_]]" restamp>
  <cr-link-row
      id="geolocationAreaLinkRow"
      start-icon="app-management:location"
      on-click="onGeolocationAreaClick_"
      label="$i18n{geolocationAreaTitle}"
      sub-label="[[locationSubLabel_]]"
      role-description="$i18n{subpageArrowRoleDescription}"
      deep-link-focus-id$="[[Setting.kGeolocationOnOff]]"
      using-slotted-label>
    </div>
  </cr-link-row>
</template>

<div id="cameraSection">
  <div id="cameraRow" class="settings-box no-padding">
    <cr-link-row id="cameraSubpageLink"
        start-icon="app-management:camera"
        label="$i18n{cameraToggleTitle}"
        sub-label="[[cameraRowSubtext_]]"
        on-click="onCameraSubpageLinkClick_"
        role-description="$i18n{subpageArrowRoleDescription}">
    </cr-link-row>
    <div class="separator"></div>
    <div id="cameraToggleWrapper">
      <cr-toggle
          id="cameraToggle"
          class="margin-matches-padding"
          checked="{{prefs.ash.user.camera_allowed.value}}"
          disabled="[[shouldDisableCameraToggle_]]"
          aria-label="$i18n{cameraToggleTitle}"
          aria-description="[[cameraRowSubtext_]]">
      </cr-toggle>
    </div>
    <paper-tooltip
        id="cameraToggleTooltip"
        hidden="[[!isCameraListEmpty_]]"
        aria-hidden="true"
        for="cameraToggleWrapper"
        fit-to-visible-bounds>
      $i18n{privacyHubNoCameraConnectedTooltipText}
    </paper-tooltip>
  </div>
</div>

<div id="microphoneSection">
  <div id="microphoneRow" class="settings-box no-padding">
    <cr-link-row id="microphoneSubpageLink"
        start-icon="app-management:microphone"
        label="$i18n{microphoneToggleTitle}"
        sub-label="[[microphoneRowSubtext_]]"
        on-click="onMicrophoneSubpageLinkClick_"
        role-description="$i18n{subpageArrowRoleDescription}">
    </cr-link-row>
    <div class="separator"></div>
    <div id="microphoneToggleWrapper">
      <cr-toggle
          id="microphoneToggle"
          class="margin-matches-padding"
          checked="{{prefs.ash.user.microphone_allowed.value}}"
          disabled="[[shouldDisableMicrophoneToggle_]]"
          aria-label="$i18n{microphoneToggleTitle}"
          aria-description="[[microphoneRowSubtext_]]">
      </cr-toggle>
    </div>
    <paper-tooltip
        id="microphoneToggleTooltip"
        hidden="[[!shouldDisableMicrophoneToggle_]]"
        aria-hidden="true"
        for="microphoneToggleWrapper"
        fit-to-visible-bounds>
      [[microphoneToggleTooltipText_]]
    </paper-tooltip>
  </div>
</div>

<template is="dom-if" if="[[showSpeakOnMuteDetectionPage_]]" restamp>
  <div class="hr"></div>
  <settings-toggle-button
      pref="{{prefs.ash.user.speak_on_mute_detection_enabled}}"
      id="speakonmuteDetectionToggle"
      label="$i18n{speakOnMuteDetectionToggleTitle}"
      sub-label="$i18n{speakOnMuteDetectionToggleSubtext}"
      deep-link-focus-id$="[[Setting.kSpeakOnMuteDetectionOnOff]]"
      learn-more-url="$i18n{speakOnMuteDetectionLearnMoreURL}">
  </settings-toggle-button>
</template>



<div class="hr"></div>
<settings-toggle-button id="contentRecommendationsToggle"
    pref="{{prefs.settings.suggested_content_enabled}}"
    label="$i18n{enableSuggestedContent}"
    sub-label="$i18n{enableSuggestedContentDesc}"
    learn-more-url="$i18n{suggestedContentLearnMoreURL}">
</settings-toggle-button>
<!--_html_template_end_-->`;
}
