import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">cr-radio-group{display:flex;flex-flow:column wrap}.indented{margin-inline-start:var(--cr-section-padding)}.doubly-indented{padding-inline-start:var(--cr-section-indent-padding)}.left-float-graphic{float:left;height:200px;margin-inline-end:10px;width:200px}.large-icon{--iron-icon-fill-color:var(--cros-icon-color-prominent);--iron-icon-stroke-color:var(--cros-icon-color-prominent);--iron-icon-height:32px;--iron-icon-width:32px;margin-bottom:10px}.banner{display:inline-block;margin:0 0 10px 0;padding:0 10px 10px 10px}</style>

<div class="banner">
  <iron-icon id="smartPrivacyIllo"
      icon="os-settings-illo:smart-privacy"
      class="left-float-graphic">
  </iron-icon>

  <div>
    <iron-icon class="large-icon" icon="cr:security">
    </iron-icon>
  </div>
  <div>
    <localized-link
        localized-string="$i18n{smartPrivacyDesc}"
        link-url="$i18n{smartPrivacyLearnMoreURL}">
    </localized-link>
  </div>
</div>
<template is="dom-if" if="[[isQuickDimEnabled_]]" restamp>
  <settings-toggle-button
      pref="{{prefs.power.quick_dim_enabled}}"
      id="quickDimToggle"
      label="$i18n{smartPrivacyQuickDimTitle}"
      sub-label="$i18n{smartPrivacyQuickDimSubtext}"
      deep-link-focus-id$="[[Setting.kQuickDim]]"
      class="hr">
  </settings-toggle-button>
  <iron-collapse id="quickDimOptions"
      opened="[[prefs.power.quick_dim_enabled.value]]">
    <div class="doubly-indented">
      <div class="settings-box">
        <div class="start" aria-hidden="true">
          $i18n{smartPrivacyQuickLockTitle}
        </div>
        <settings-slider
          pref="{{prefs.power.quick_lock_delay.ms}}"
          ticks="[[smartPrivacyQuickLockRangeMs_]]"
          label-aria="$i18n{smartPrivacyQuickLockTitle}"
          label-min="$i18n{smartPrivacyQuickLockShort}"
          label-max="$i18n{smartPrivacyQuickLockLong}">
        </settings-slider>
      </div>
    </div>
  </iron-collapse>
</template>
<template is="dom-if" if="[[isSnoopingProtectionEnabled_]]" restamp>
  <settings-toggle-button
      pref="{{prefs.ash.privacy.snooping_protection_enabled}}"
      id="snoopingProtectionToggle"
      label="$i18n{smartPrivacySnoopingTitle}"
      sub-label="$i18n{smartPrivacySnoopingSubtext}"
      deep-link-focus-id$="[[Setting.kSnoopingProtection]]"
      class="hr">
  </settings-toggle-button>
  <iron-collapse id="snoopingProtectionOptions"
      opened="[[prefs.ash.privacy.snooping_protection_enabled.value]]">
    <div class="doubly-indented">
      <settings-toggle-button
          pref="{{prefs.ash.privacy.snooping_protection_notification_suppression_enabled}}"
          label="$i18n{smartPrivacySnoopingNotifications}"
          class="hr">
      </settings-toggle-button>
    </div>
  </iron-collapse>
</template>
<!--_html_template_end_-->`;
}
