import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">:host{--cr-dialog-width:400px}:host cr-checkbox{--cr-checkbox-label-color:var(--cr-secondary-text-color);--cr-checkbox-label-padding-start:12px;--cr-checkbox-unchecked-box-color:var(--cros-icon-color-primary)}iron-list{background-color:var(--cros-textfield-background-color);border-radius:4px;margin-top:8px;padding-bottom:8px}os-settings-powerwash-dialog-esim-item{height:32px;padding-inline-end:16px;padding-inline-start:16px}#profilesListContainer{margin-bottom:8px;margin-top:20px}#profilesListTitle{font-size:calc(14 / 13 * 100%)}#checkboxLabel{margin-top:16px}</style>
<cr-dialog id="dialog" close-text="$i18n{close}"
    ignore-enter-key>
  <template is="dom-if" if="[[shouldShowESimWarning_]]" restamp>
    <div slot="title">$i18n{powerwashDialogESimWarningTitle}</div>
    <div slot="body">
      <localized-link
          localized-string="$i18n{powerwashDialogESimWarning}"
          on-link-clicked="onMobileSettingsLinkClicked_">
      </localized-link>
      <div id="profilesListContainer">
        <div id="profilesListTitle">
          $i18n{powerwashDialogESimListTitle}
        </div>
        <iron-list items="[[installedESimProfiles]]"
            scroll-target="profilesListContainer"
            role="listbox">
          <template>
            <os-settings-powerwash-dialog-esim-item
                profile="[[item]]"
                tabindex="0"
                role="option">
            </os-powerwash-dialog-esim-item>
          </template>
        </iron-list>
      </div>
      <cr-checkbox checked="{{isESimCheckboxChecked_}}">
        <div id="checkboxLabel">
          $i18n{powerwashDialogESimWarningCheckbox}
        </div>
      </cr-checkbox>
    </div>
  </template>
  <template is="dom-if" if="[[!shouldShowESimWarning_]]" restamp>
    <div slot="title">$i18n{powerwashDialogTitle}</div>
    <div slot="body">
      <div id="powerwashContainer">
        <localized-link
          localized-string="$i18n{powerwashDialogExplanation}"
          link-url="$i18nRaw{powerwashLearnMoreUrl}">
        </localized-link>
      </div>
    </div>
  </template>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onCancelClick_"
        id="cancel">$i18n{cancel}</cr-button>
    <template is="dom-if" if="[[!shouldShowESimWarning_]]" restamp>
      <cr-button class="action-button" id="powerwash"
          on-click="onRestartClick_">
        $i18n{powerwashDialogButton}
      </cr-button>
    </template>
    <template is="dom-if" if="[[shouldShowESimWarning_]]" restamp>
      <cr-button class="action-button" id="continue"
          on-click="onContinueClick_"
          disabled="[[!isESimCheckboxChecked_]]">
        $i18n{powerwashContinue}
      </cr-button>
    </template>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
