import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">#powerwashIcon{fill:var(--cros-sys-primary);margin-inline-end:16px}#sanitizeIcon{fill:var(--cros-sys-primary);margin-inline-end:16px}#sanitizeCard{padding-bottom:var(--cr-section-vertical-padding);padding-top:var(--cr-section-vertical-padding)}</style>

<settings-card header-text="$i18n{resetPageTitle}">
  <div class="settings-box two-line first">
    <iron-icon id="powerwashIcon" icon="os-settings:startup"></iron-icon>
    <div class="start" id="title" aria-hidden="true">
      $i18n{powerwashTitle}
      <div class="secondary" id="secondaryText" aria-hidden="true">
        $i18n{powerwashDescription}
      </div>
    </div>
    <cr-button id="powerwashButton"
        on-click="onShowPowerwashDialog_"
        aria-labelledby="title"
        aria-describedby="secondaryText"
        aria-roledescription="$i18n{powerwashButtonRoleDescription}"
        deep-link-focus-id$="[[Setting.kPowerwash]]">
      $i18n{powerwashButton}
    </cr-button>
  </div>
  <template is="dom-if" if="[[isSanitizeAllowed_]]">
    <div class="settings-box two-line hr" id="sanitizeCard">
      <iron-icon id="sanitizeIcon" icon="os-settings:sanitize"></iron-icon>
      <div class="start" id="sanitizeTitle" aria-hidden="true">
        $i18n{sanitizeTitle}
        <div class="secondary" aria-hidden="true">
          $i18n{sanitizeShortDescription}
        </div>
      </div>
      <cr-button id="sanitizeButton"
          on-click="onShowSanitizeDialog_"
          aria-labelledby="sanitizeTitle"
          deep-link-focus-id$="[[Setting.kSanitize]]">
        $i18n{sanitizeButton}
      </cr-button>
    </div>
  </template>
</settings-card>
<template is="dom-if" if="[[showPowerwashDialog_]]" restamp>
  <os-settings-powerwash-dialog
      installed-e-sim-profiles="[[installedESimProfiles_]]"
      on-close="onPowerwashDialogClose_">
  </os-settings-powerwash-dialog>
</template>
<!--_html_template_end_-->`;
}
