// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { PageHandlerFactory, PageHandlerRemote } from '../mojom-webui/magic_boost_handler.mojom-webui.js';
// Communicates with the MagicBoostNoticeBrowserProxy in the browser process.
class MagicBoostNoticeBrowserProxy {
    constructor() {
        // Invoke methods from the browser process.
        this.handler = new PageHandlerRemote();
        const factory = PageHandlerFactory.getRemote();
        factory.createPageHandler(this.handler.$.bindNewPipeAndPassReceiver());
    }
    static getInstance() {
        return instance || (instance = new MagicBoostNoticeBrowserProxy());
    }
    static setInstance(proxy) {
        instance = proxy;
    }
    showNotice() {
        this.handler.showNotice();
    }
}
let instance = null;
export { MagicBoostNoticeBrowserProxy };
