import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">settings-toggle-button{--cr-icon-button-margin-end:16px;--iron-icon-fill-color:var(--cros-sys-primary)}.sub-item{padding-inline-start:var(--cr-section-indent-width)}#magic-boost-banner{margin-inline-end:20px;margin-inline-start:12px}</style>

<settings-card header-text="$i18n{osSearchPageTitle}">
  <!-- Search -->
  <template is="dom-if" if="[[!isQuickAnswersSupported_]]">
    <settings-search-engine
        deep-link-focus-id$="[[Setting.kPreferredSearchEngine]]">
    </settings-search-engine>
  </template>
  <template is="dom-if" if="[[isQuickAnswersSupported_]]">
    <cr-link-row
        id="searchRow"
        start-icon="os-settings:explore"
        label="$i18n{searchSubpageTitle}"
        on-click="onSearchClick_"
        role-description="$i18n{subpageArrowRoleDescription}">
    </cr-link-row>
  </template>

  <settings-toggle-button id="contentRecommendationsToggle"
      class="hr"
      icon="os-settings:content-recommend"
      pref="{{prefs.settings.suggested_content_enabled}}"
      label="$i18n{enableSuggestedContent}"
      sub-label="$i18n{enableSuggestedContentDesc}"
      learn-more-url="$i18n{suggestedContentLearnMoreURL}">
  </settings-toggle-button>

  <!--TODO(b:337868408) learn more link for magicboost-->
  <template is="dom-if" if="[[isMagicBoostFeatureEnabled_]]">
    <settings-toggle-button id="magicBoostToggle"
        class="hr"
        icon="os-settings:magic-boost"
        pref="{{prefs.settings.magic_boost_enabled}}"
        label="$i18n{enableMagicBoost}"
        sub-label="$i18n{enableMagicBoostDesc}"
        deep-link-focus-id$="[[Setting.kMagicBoostOnOff]]"
        >
    </settings-toggle-button>
    <template is="dom-if" if="[[isMagicBoostNoticeBannerVisible_]]">
      <div class="sub-item" id="magic-boost-banner">
        <magic-boost-review-terms-banner
          description="$i18n{magicBoostReviewTermsBannerDescription}"
          button-label="$i18n{magicBoostReviewTermsButtonLabel}">
        </magic-boost-review-terms-banner>
      </div>
    </template>
    <iron-collapse opened="[[prefs.settings.magic_boost_enabled.value]]"
        id="magicBoostCollapse">
      <div class="sub-item">
        <!-- \`restamp\` is needed to ensure that deep links work correctly if
         \`isHmrAllowedByEnterprisePolicy_\` changes. -->
        <template is="dom-if" restamp if="[[!isHmrAllowedByEnterprisePolicy_]]">
          <!-- As the enterprise policy is under a different pref, use that one
               here to make this toggle appear as managed. The toggle needs to
               be explicitly disabled in case the policy is recommended. -->
          <settings-toggle-button
              id="helpMeReadEnterpriseToggle"
              class="hr"
              icon="os-settings:help-me-read"
              pref="{{prefs.settings.managed.help_me_read}}"
              numeric-unchecked-values="[[enterprisePolicyToggleUncheckedValues_]]"
              disabled
              no-set-pref
              label="$i18n{enableHelpMeRead}"
              sub-label="$i18n{enableHelpMeReadDesc}"
              deep-link-focus-id$="[[Setting.kMahiOnOff]]"
              learn-more-url="$i18n{helpMeReadWriteLearnMoreUrl}">
          </settings-toggle-button>
        </template>
        <template is="dom-if" restamp if="[[isHmrAllowedByEnterprisePolicy_]]">
          <settings-toggle-button id="helpMeReadToggle"
              class="hr"
              icon="os-settings:help-me-read"
              pref="{{prefs.settings.mahi_enabled}}"
              label="$i18n{enableHelpMeRead}"
              sub-label="$i18n{enableHelpMeReadDesc}"
              deep-link-focus-id$="[[Setting.kMahiOnOff]]"
              learn-more-url="$i18n{helpMeReadWriteLearnMoreUrl}">
          </settings-toggle-button>
        </template>
      </div>
      <div class="sub-item">
        <!-- \`restamp\` is needed to ensure that deep links work correctly if
         \`isHmwAllowedByEnterprisePolicy_\` changes. -->
        <template is="dom-if" restamp if="[[!isHmwAllowedByEnterprisePolicy_]]">
          <!-- As the enterprise policy is under a different pref, use that one
               here to make this toggle appear as managed. The toggle needs to
               be explicitly disabled in case the policy is recommended. -->
          <settings-toggle-button
              id="helpMeWriteEnterpriseToggle"
              class="hr"
              icon="os-settings:help-me-write"
              pref="{{prefs.settings.managed.help_me_write}}"
              numeric-unchecked-values=
                "[[enterprisePolicyToggleUncheckedValues_]]"
              disabled
              no-set-pref
              label="$i18n{enableHelpMeWrite}"
              sub-label="$i18n{enableHelpMeWriteDesc}"
              deep-link-focus-id$="[[Setting.kShowOrca]]"
              learn-more-url="$i18n{helpMeReadWriteLearnMoreUrl}">
          </settings-toggle-button>
        </template>
        <template is="dom-if" restamp if="[[isHmwAllowedByEnterprisePolicy_]]">
          <settings-toggle-button id="helpMeWriteToggle"
              class="hr"
              icon="os-settings:help-me-write"
              pref="{{prefs.assistive_input.orca_enabled}}"
              label="$i18n{enableHelpMeWrite}"
              sub-label="$i18n{enableHelpMeWriteDesc}"
              deep-link-focus-id$="[[Setting.kShowOrca]]"
              learn-more-url="$i18n{helpMeReadWriteLearnMoreUrl}">
          </settings-toggle-button>
        </template>
      </div>
      <div class="sub-item">
        <template is="dom-if" if="[[isLobsterSettingsToggleVisible_]]">
          <template is="dom-if" if="[[!isLobsterAllowedByEnterprisePolicy_]]"
            restamp>
            <!-- As the enterprise policy is under a different pref, use that
                one here to make this toggle appear as managed. The toggle
                needs to be explicitly disabled in case the policy is
                recommended. -->
            <settings-toggle-button id="lobsterEnterpriseToggle"
                class="hr"
                icon="ash-internal:lobster"
                pref="{{prefs.settings.lobster.enterprise_settings}}"
                numeric-unchecked-values=
                  "[[enterprisePolicyToggleUncheckedValues_]]"
                disabled
                no-set-pref
                label="$i18n{enableLobster}"
                sub-label="$i18n{enableLobsterDesc}"
                deep-link-focus-id$="[[Setting.kLobsterOnOff]]"
                learn-more-url="$i18n{lobsterLearnMoreUrl}">
            </settings-toggle-button>
          </template>
          <template is="dom-if" if="[[isLobsterAllowedByEnterprisePolicy_]]"
            restamp>
            <settings-toggle-button id="lobsterToggle"
                class="hr"
                icon="ash-internal:lobster"
                pref="{{prefs.settings.lobster_enabled}}"
                label="$i18n{enableLobster}"
                sub-label="$i18n{enableLobsterDesc}"
                deep-link-focus-id$="[[Setting.kLobsterOnOff]]"
                learn-more-url="$i18n{lobsterLearnMoreUrl}">
            </settings-toggle-button>
          </template>
        </template>
      </div>
    </iron-collapse>
  </template>

  <template is="dom-if" if="[[isScannerSettingsToggleVisible_]]">
    <!-- TODO: crbug.com/404069127 - Add a learn more link. -->
    <!-- \`restamp\` is needed to ensure that deep links work correctly if
         \`isScannerAllowedByEnterprisePolicy_\` changes. -->
    <template is="dom-if" restamp if="[[!isScannerAllowedByEnterprisePolicy_]]">
      <!-- As the enterprise policy is under a different pref, use that one here
           to make this toggle appear as managed. The toggle needs to be
           explicitly disabled in case the policy is recommended. -->
      <settings-toggle-button
          id="scannerEnterpriseToggle"
          class="hr"
          pref="{{prefs.ash.scanner.enterprise_policy_allowed}}"
          numeric-unchecked-values="[[enterprisePolicyToggleUncheckedValues_]]"
          disabled
          no-set-pref
          icon="os-settings:scanner"
          label="$i18n{enableScanner}"
          sub-label="$i18n{enableScannerDesc}"
          learn-more-url="$i18n{scannerLearnMoreUrl}"
          deep-link-focus-id$="[[Setting.kScannerOnOff]]">
      </settings-toggle-button>
    </template>
    <template is="dom-if" restamp if="[[isScannerAllowedByEnterprisePolicy_]]">
      <settings-toggle-button
          id="scannerToggle"
          class="hr"
          pref="{{prefs.ash.scanner.enabled}}"
          icon="os-settings:scanner"
          label="$i18n{enableScanner}"
          sub-label="$i18n{enableScannerDesc}"
          learn-more-url="$i18n{scannerLearnMoreUrl}"
          deep-link-focus-id$="[[Setting.kScannerOnOff]]">
      </settings-toggle-button>
    </template>
  </template>

</settings-card>
<!--_html_template_end_-->`;
}
