// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview The main entry point for the ChromeOS Settings SWA. This
 * imports all of the necessary modules and custom elements to load the page.
 */
import '/strings.m.js';
import './os_settings_ui/os_settings_ui.js';
import { ColorChangeUpdater } from 'chrome://resources/cr_components/color_change_listener/colors_css_updater.js';
/**
 * With the optimize_webui() build step, the generated JS files are bundled
 * into a single JS file. The exports below are necessary so they can be
 * imported into browser tests.
 */
export { getContactManager, observeContactManager, setContactManagerForTesting } from '/shared/nearby_contact_manager.js';
export { NearbyProgressElement } from '/shared/nearby_progress.js';
export * as nearbyShareMojom from '/shared/nearby_share.mojom-webui.js';
export { getNearbyShareSettings, observeNearbyShareSettings, setNearbyShareSettingsForTesting } from '/shared/nearby_share_settings.js';
export { NearbyShareSettingsMixin } from '/shared/nearby_share_settings_mixin.js';
export { DEFAULT_CHECKED_VALUE, DEFAULT_UNCHECKED_VALUE } from '/shared/settings/controls/settings_boolean_control_mixin.js';
export { ExtensionControlBrowserProxyImpl } from '/shared/settings/extension_control_browser_proxy.js';
export { LifetimeBrowserProxyImpl } from '/shared/settings/lifetime_browser_proxy.js';
export { ProfileInfoBrowserProxyImpl } from '/shared/settings/people_page/profile_info_browser_proxy.js';
export { ChromeSigninUserChoice, PageStatus, SignedInState, StatusAction, SyncBrowserProxyImpl } from '/shared/settings/people_page/sync_browser_proxy.js';
export { SettingsPrefsElement } from '/shared/settings/prefs/prefs.js';
export { CrSettingsPrefs } from '/shared/settings/prefs/prefs_types.js';
export { PrivacyPageBrowserProxyImpl, SecureDnsMode, SecureDnsUiManagementMode } from '/shared/settings/privacy_page/privacy_page_browser_proxy.js';
export { CrA11yAnnouncerElement } from 'chrome://resources/ash/common/cr_elements/cr_a11y_announcer/cr_a11y_announcer.js';
export { CrActionMenuElement } from 'chrome://resources/ash/common/cr_elements/cr_action_menu/cr_action_menu.js';
export { CrAutoImgElement } from 'chrome://resources/ash/common/cr_elements/cr_auto_img/cr_auto_img.js';
export { CrButtonElement } from 'chrome://resources/ash/common/cr_elements/cr_button/cr_button.js';
export { CrCheckboxElement } from 'chrome://resources/ash/common/cr_elements/cr_checkbox/cr_checkbox.js';
export { CrDialogElement } from 'chrome://resources/ash/common/cr_elements/cr_dialog/cr_dialog.js';
export { CrDrawerElement } from 'chrome://resources/ash/common/cr_elements/cr_drawer/cr_drawer.js';
export { CrExpandButtonElement } from 'chrome://resources/ash/common/cr_elements/cr_expand_button/cr_expand_button.js';
export { CrIconButtonElement } from 'chrome://resources/ash/common/cr_elements/cr_icon_button/cr_icon_button.js';
export { CrInputElement } from 'chrome://resources/ash/common/cr_elements/cr_input/cr_input.js';
export { CrLinkRowElement } from 'chrome://resources/ash/common/cr_elements/cr_link_row/cr_link_row.js';
export { CrCardRadioButtonElement } from 'chrome://resources/ash/common/cr_elements/cr_radio_button/cr_card_radio_button.js';
export { CrRadioButtonElement } from 'chrome://resources/ash/common/cr_elements/cr_radio_button/cr_radio_button.js';
export { CrRadioGroupElement } from 'chrome://resources/ash/common/cr_elements/cr_radio_group/cr_radio_group.js';
export { CrSearchFieldElement } from 'chrome://resources/ash/common/cr_elements/cr_search_field/cr_search_field.js';
export { CrSearchableDropDownElement } from 'chrome://resources/ash/common/cr_elements/cr_searchable_drop_down/cr_searchable_drop_down.js';
export { CrSliderElement } from 'chrome://resources/ash/common/cr_elements/cr_slider/cr_slider.js';
export { CrTextareaElement } from 'chrome://resources/ash/common/cr_elements/cr_textarea/cr_textarea.js';
export { CrToastElement } from 'chrome://resources/ash/common/cr_elements/cr_toast/cr_toast.js';
export { CrToggleElement } from 'chrome://resources/ash/common/cr_elements/cr_toggle/cr_toggle.js';
export { CrToolbarSearchFieldElement } from 'chrome://resources/ash/common/cr_elements/cr_toolbar/cr_toolbar_search_field.js';
export { LocalizedLinkElement } from 'chrome://resources/ash/common/cr_elements/localized_link/localized_link.js';
export { CrPolicyIndicatorElement } from 'chrome://resources/ash/common/cr_elements/policy/cr_policy_indicator.js';
export { CrTooltipIconElement } from 'chrome://resources/ash/common/cr_elements/policy/cr_tooltip_icon.js';
export { ApnDetailDialog } from 'chrome://resources/ash/common/network/apn_detail_dialog.js';
export { ApnSelectionDialog } from 'chrome://resources/ash/common/network/apn_selection_dialog.js';
export { ApnSelectionDialogListItem } from 'chrome://resources/ash/common/network/apn_selection_dialog_list_item.js';
export { CrPolicyNetworkBehaviorMojo } from 'chrome://resources/ash/common/network/cr_policy_network_behavior_mojo.js';
export { OpenWindowProxyImpl } from 'chrome://resources/js/open_window_proxy.js';
export { getTrustedHTML } from 'chrome://resources/js/static_types.js';
export { AppLanguageSelectionDialogEntryPoint } from './common/app_language_selection_dialog/app_language_selection_dialog.js';
export { addApp, changeApp, removeApp, updateSelectedAppId, updateSubAppToParentAppId } from './common/app_management/actions.js';
export { AppManagementBrowserProxy, AppManagementComponentBrowserProxy } from './common/app_management/browser_proxy.js';
export { reduceAction, updateApps } from './common/app_management/reducers.js';
export { AppManagementStore } from './common/app_management/store.js';
export { AppManagementStoreMixin } from './common/app_management/store_mixin.js';
export { resetGlobalScrollTargetForTesting, setGlobalScrollTarget as setGlobalScrollTargetForTesting } from './common/global_scroll_target_mixin.js';
export { ControlledButtonElement } from './controls/controlled_button.js';
export { ControlledRadioButtonElement } from './controls/controlled_radio_button.js';
export { ExtensionControlledIndicatorElement } from './controls/extension_controlled_indicator.js';
export { SettingsDropdownMenuElement } from './controls/settings_dropdown_menu.js';
export { SettingsRadioGroupElement } from './controls/settings_radio_group.js';
export { SettingsSliderElement } from './controls/settings_slider.js';
export { SettingsToggleButtonElement } from './controls/settings_toggle_button.js';
export { BaseRowMixin } from './controls/v2/base_row_mixin.js';
export { PrefControlMixinInternal } from './controls/v2/pref_control_mixin_internal.js';
export { SettingsDropdownRowElement } from './controls/v2/settings_dropdown_row.js';
export { SettingsDropdownV2Element } from './controls/v2/settings_dropdown_v2.js';
export { SettingsRowElement } from './controls/v2/settings_row.js';
export { SettingsSliderRowElement } from './controls/v2/settings_slider_row.js';
export { SettingsSliderV2Element } from './controls/v2/settings_slider_v2.js';
export { SettingsToggleV2Element } from './controls/v2/settings_toggle_v2.js';
export { DateTimeBrowserProxy, DateTimePageCallbackRouter, DateTimePageHandlerRemote, DateTimePageRemote } from './date_time_page/date_time_browser_proxy.js';
export { setCrosAudioConfigForTesting } from './device_page/cros_audio_config.js';
export { SettingsDevicePageElement } from './device_page/device_page.js';
export { DevicePageBrowserProxyImpl, IdleBehavior, LidClosedBehavior, OptimizedChargingStrategy, setDisplayApiForTesting, StorageSpaceState } from './device_page/device_page_browser_proxy.js';
export { getDisplaySettingsProvider, setDisplaySettingsProviderForTesting } from './device_page/display_settings_mojo_interface_provider.js';
export * as fakeCrosAudioConfig from './device_page/fake_cros_audio_config.js';
export { fakeGraphicsTabletButtonActions, fakeGraphicsTablets, fakeGraphicsTablets2, fakeKeyboards, fakeKeyboards2, fakeMice, fakeMice2, fakeMouseButtonActions, fakePointingSticks, fakePointingSticks2, fakeStyluses, fakeTouchpads, fakeTouchpads2 } from './device_page/fake_input_device_data.js';
export { FakeInputDeviceSettingsProvider } from './device_page/fake_input_device_settings_provider.js';
export { getInputDeviceSettingsProvider, setInputDeviceSettingsProviderForTesting, setupFakeInputDeviceSettingsProvider } from './device_page/input_device_mojo_interface_provider.js';
export { AcceleratorAction, CompanionAppState, Fkey, MetaKey, ModifierKey, PolicyStatus, SimulateRightClickModifier, SixPackKey, SixPackShortcutModifier, TopRowActionKey, Vkey } from './device_page/input_device_settings_types.js';
export { getShortcutInputProvider } from './device_page/shortcut_input_mojo_interface_provider.js';
export { ensureLazyLoaded } from './ensure_lazy_loaded.js';
export { ApnSubpageElement } from './internet_page/apn_subpage.js';
export { OsSettingsCellularSetupDialogElement } from './internet_page/cellular_setup_dialog.js';
export { EsimRemoveProfileDialogElement } from './internet_page/esim_remove_profile_dialog.js';
export { EsimRenameDialogElement } from './internet_page/esim_rename_dialog.js';
export { HotspotConfigDialogElement, WiFiSecurityType } from './internet_page/hotspot_config_dialog.js';
export { HotspotSummaryItemElement } from './internet_page/hotspot_summary_item.js';
export { InternetConfigElement } from './internet_page/internet_config.js';
export { SettingsInternetDetailMenuElement } from './internet_page/internet_detail_menu.js';
export { SettingsInternetPageElement } from './internet_page/internet_page.js';
export { InternetPageBrowserProxyImpl } from './internet_page/internet_page_browser_proxy.js';
export { NetworkSummaryElement } from './internet_page/network_summary.js';
export { NetworkSummaryItemElement } from './internet_page/network_summary_item.js';
export { SettingsKerberosPageElement } from './kerberos_page/kerberos_page.js';
export { MainPageContainerElement } from './main_page_container/main_page_container.js';
export { PageDisplayerElement } from './main_page_container/page_displayer.js';
export { recordClick, recordNavigation, recordPageBlur, recordPageFocus, recordSearch, recordSettingChange, setUserActionRecorderForTesting } from './metrics_recorder.js';
export * as acceleratorInfoMojom from './mojom-webui/accelerator_info.mojom-webui.js';
export * as appNotificationHandlerMojom from './mojom-webui/app_notification_handler.mojom-webui.js';
export * as appParentalControlsHandlerMojom from './mojom-webui/app_parental_controls_handler.mojom-webui.js';
export * as appPermissionHandlerMojom from './mojom-webui/app_permission_handler.mojom-webui.js';
export * as crosAudioConfigMojom from './mojom-webui/cros_audio_config.mojom-webui.js';
export * as displaySettingsProviderMojom from './mojom-webui/display_settings_provider.mojom-webui.js';
export * as graduationHandlerMojom from './mojom-webui/graduation_handler.mojom-webui.js';
export * as personalizationSearchMojom from './mojom-webui/personalization_search.mojom-webui.js';
export * as routesMojom from './mojom-webui/routes.mojom-webui.js';
export * as searchMojom from './mojom-webui/search.mojom-webui.js';
export * as searchResultIconMojom from './mojom-webui/search_result_icon.mojom-webui.js';
export * as settingMojom from './mojom-webui/setting.mojom-webui.js';
export * as userActionRecorderMojom from './mojom-webui/user_action_recorder.mojom-webui.js';
export { MultiDeviceBrowserProxyImpl } from './multidevice_page/multidevice_browser_proxy.js';
export { MultiDeviceFeature, MultiDeviceFeatureState, MultiDeviceSettingsMode, PhoneHubFeatureAccessProhibitedReason, PhoneHubFeatureAccessStatus, PhoneHubPermissionsSetupAction, PhoneHubPermissionsSetupFeatureCombination, PhoneHubPermissionsSetupFlowScreens, PhoneHubPermissionsSetupMode } from './multidevice_page/multidevice_constants.js';
export { NotificationAccessSetupOperationStatus, SettingsMultideviceNotificationAccessSetupDialogElement } from './multidevice_page/multidevice_notification_access_setup_dialog.js';
export { SettingsMultidevicePageElement } from './multidevice_page/multidevice_page.js';
export { PermissionsSetupStatus, SettingsMultidevicePermissionsSetupDialogElement, SetupFlowStatus } from './multidevice_page/multidevice_permissions_setup_dialog.js';
export { NearbyAccountManagerBrowserProxyImpl } from './nearby_share_page/nearby_account_manager_browser_proxy.js';
export { NearbyShareConfirmPageElement } from './nearby_share_page/nearby_share_confirm_page.js';
export { NearbyShareHighVisibilityPageElement } from './nearby_share_page/nearby_share_high_visibility_page.js';
export { getReceiveManager, observeReceiveManager, setReceiveManagerForTesting } from './nearby_share_page/nearby_share_receive_manager.js';
export { dataUsageStringToEnum, NearbyShareDataUsage } from './nearby_share_page/types.js';
export { ChromeVoxSubpageBrowserProxyImpl } from './os_a11y_page/chromevox_subpage_browser_proxy.js';
export { FaceGazeSubpageBrowserProxyImpl } from './os_a11y_page/facegaze_subpage_browser_proxy.js';
export { OsSettingsA11yPageElement } from './os_a11y_page/os_a11y_page.js';
export { OsA11yPageBrowserProxyImpl } from './os_a11y_page/os_a11y_page_browser_proxy.js';
export { SelectToSpeakSubpageBrowserProxyImpl } from './os_a11y_page/select_to_speak_subpage_browser_proxy.js';
export { SwitchAccessSubpageBrowserProxyImpl } from './os_a11y_page/switch_access_subpage_browser_proxy.js';
export { TextToSpeechSubpageBrowserProxyImpl } from './os_a11y_page/text_to_speech_subpage_browser_proxy.js';
export { TtsVoiceSubpageBrowserProxyImpl } from './os_a11y_page/tts_voice_subpage_browser_proxy.js';
export { AboutPageBrowserProxyImpl, BrowserChannel, UpdateStatus } from './os_about_page/about_page_browser_proxy.js';
export { DeviceNameBrowserProxyImpl } from './os_about_page/device_name_browser_proxy.js';
export { DeviceNameState, SetDeviceNameResult } from './os_about_page/device_name_util.js';
export { OsAboutPageElement } from './os_about_page/os_about_page.js';
export { AndroidAppsBrowserProxyImpl } from './os_apps_page/android_apps_browser_proxy.js';
export { AppManagementFileHandlingItemElement } from './os_apps_page/app_management_page/file_handling_item.js';
export { PluginVmBrowserProxyImpl } from './os_apps_page/app_management_page/plugin_vm_page/plugin_vm_browser_proxy.js';
export { AppManagementReadOnlyPermissionItemElement } from './os_apps_page/app_management_page/read_only_permission_item.js';
export { AppManagementSupportedLinksItemElement } from './os_apps_page/app_management_page/supported_links_item.js';
export { AppManagementToggleRowElement } from './os_apps_page/app_management_page/toggle_row.js';
export { setAppNotificationProviderForTesting } from './os_apps_page/app_notifications_page/mojo_interface_provider.js';
export { setAppParentalControlsProviderForTesting } from './os_apps_page/app_parental_controls/mojo_interface_provider.js';
export { OsSettingsAppsPageElement } from './os_apps_page/os_apps_page.js';
export { OsBluetoothDevicesSubpageBrowserProxyImpl } from './os_bluetooth_page/os_bluetooth_devices_subpage_browser_proxy.js';
export { SettingsBluetoothPageElement } from './os_bluetooth_page/os_bluetooth_page.js';
export { SettingsBluetoothPairingDialogElement } from './os_bluetooth_page/os_bluetooth_pairing_dialog.js';
export { SettingsBluetoothSummaryElement } from './os_bluetooth_page/os_bluetooth_summary.js';
export { FastPairSavedDevicesOptInStatus } from './os_bluetooth_page/settings_fast_pair_constants.js';
export { GoogleDriveBrowserProxy, GoogleDrivePageCallbackRouter, GoogleDrivePageHandlerRemote, GoogleDrivePageRemote, Stage } from './os_files_page/google_drive_browser_proxy.js';
export { OneDriveBrowserProxy, OneDrivePageCallbackRouter, OneDrivePageHandlerRemote, OneDrivePageRemote } from './os_files_page/one_drive_browser_proxy.js';
export { createPageAvailability as createPageAvailabilityForTesting } from './os_page_availability.js';
export { AccountManagerSettingsCardElement } from './os_people_page/account_manager_settings_card.js';
export { AdditionalAccountsSettingsCardElement } from './os_people_page/additional_accounts_settings_card.js';
export { setGraduationHandlerProviderForTesting } from './os_people_page/graduation/mojo_interface_provider.js';
export { OsSettingsPeoplePageElement } from './os_people_page/os_people_page.js';
export { MetricsConsentBrowserProxyImpl } from './os_privacy_page/metrics_consent_browser_proxy.js';
export { setAppPermissionProviderForTesting } from './os_privacy_page/mojo_interface_provider.js';
export { OsSettingsPrivacyPageElement } from './os_privacy_page/os_privacy_page.js';
export { PeripheralDataAccessBrowserProxyImpl } from './os_privacy_page/peripheral_data_access_browser_proxy.js';
export { SettingsPrivacyHubAppPermissionRow } from './os_privacy_page/privacy_hub_app_permission_row.js';
export { GeolocationAccessLevel, ScheduleType } from './os_privacy_page/privacy_hub_geolocation_subpage.js';
export { PrivacyHubSensorSubpageUserAction } from './os_privacy_page/privacy_hub_metrics_util.js';
export { SettingsPrivacyHubSystemServiceRow } from './os_privacy_page/privacy_hub_system_service_row.js';
export { OsResetBrowserProxyImpl } from './os_reset_page/os_reset_browser_proxy.js';
export { SearchAndAssistantSettingsCardElement } from './os_search_page/search_and_assistant_settings_card.js';
export { SettingsSearchEngineElement } from './os_search_page/search_engine.js';
export { SearchEnginesBrowserProxyImpl } from './os_search_page/search_engines_browser_proxy.js';
export { ManagedFootnoteElement } from './os_settings_main/managed_footnote.js';
export { OsSettingsMainElement } from './os_settings_main/os_settings_main.js';
export { OsSettingsMenuItemElement } from './os_settings_menu/menu_item.js';
export { OsSettingsMenuElement } from './os_settings_menu/os_settings_menu.js';
export { OsSettingsSubpageElement } from './os_settings_page/os_settings_subpage.js';
export { SettingsCardElement } from './os_settings_page/settings_card.js';
export { SettingsIdleLoadElement } from './os_settings_page/settings_idle_load.js';
export { createRoutes as createRoutesForTesting } from './os_settings_routes.js';
export { OsSettingsSearchBoxElement } from './os_settings_search_box/os_settings_search_box.js';
export { OsSettingsSearchBoxBrowserProxyImpl } from './os_settings_search_box/os_settings_search_box_browser_proxy.js';
export { OsSettingsHatsBrowserProxyImpl } from './os_settings_ui/os_settings_hats_browser_proxy.js';
export { OsSettingsUiElement } from './os_settings_ui/os_settings_ui.js';
export { SettingsToolbarElement as ToolbarElement } from './os_settings_ui/toolbar.js';
export { ParentalControlsBrowserProxyImpl } from './parental_controls_page/parental_controls_browser_proxy.js';
export { ParentalControlsSettingsCardElement } from './parental_controls_page/parental_controls_settings_card.js';
export { PersonalizationHubBrowserProxyImpl } from './personalization_page/personalization_hub_browser_proxy.js';
export { SettingsPersonalizationPageElement } from './personalization_page/personalization_page.js';
export { createRouter as createRouterForTesting, Route, Router, routes } from './router.js';
export { getPersonalizationSearchHandler, setPersonalizationSearchHandlerForTesting } from './search/personalization_search_handler.js';
export { getSettingsSearchHandler, setSettingsSearchHandlerForTesting } from './search/settings_search_handler.js';
export { SettingsSchedulerSliderElement } from './settings_scheduler_slider/settings_scheduler_slider.js';
export { MultitaskingSettingsCardElement } from './system_preferences_page/multitasking_settings_card.js';
export { StartupSettingsCardElement } from './system_preferences_page/startup_settings_card.js';
export { StorageAndPowerSettingsCardElement } from './system_preferences_page/storage_and_power_settings_card.js';
export { SettingsSystemPreferencesPageElement } from './system_preferences_page/system_preferences_page.js';
window.addEventListener('load', () => {
    // Listen for changes to Jelly dynamic colors.
    ColorChangeUpdater.forDocument().start();
});
