import '//resources/polymer/v3_0/iron-iconset-svg/iron-iconset-svg.js';
import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
const template = html `<!--
<iron-icon> is used to render many SVG images that may or may not be icons
(e.g. illustrations, etc.). Include SVGs under the most appropriate
<iron-iconset-svg> below:
  - os-settings: icons, small square images
  - os-settings-illo: illustrations, larger images
-->

<!--
NOTE: Most icons should be exported at 20x20px. For icons that are not 20x20px,
ensure viewBox is specified.

Many legacy icons were exported at 24px and use viewBox to scale down to 20px.
These icons may appear blurry.
-->
<iron-iconset-svg name="os-settings" size="20">
  <svg>
    <defs>
      <!-- A11y page section -->
      <g id="accessibility" viewBox="0 0 20 20"><path d="M10.03 5.76A1.81 1.81 0 0 1 8.7 5.208 1.81 1.81 0 0 1 8.15 3.88c0-.518.184-.96.552-1.328A1.81 1.81 0 0 1 10.03 2c.518 0 .96.184 1.329.552.367.368.551.81.551 1.328s-.184.96-.551 1.328a1.81 1.81 0 0 1-1.329.552ZM7.372 18V8.62a16.886 16.886 0 0 1-2.187-.306A57.218 57.218 0 0 1 3 7.762l.47-1.675c1.09.3 2.18.524 3.27.674 1.103.15 2.2.225 3.29.225 1.09 0 2.186-.075 3.29-.225a25.937 25.937 0 0 0 3.31-.674l.429 1.675c-.763.191-1.499.368-2.207.532-.695.163-1.417.279-2.166.347V18h-1.819l-.184-4.659H9.396L9.192 18h-1.82Z"/></g>
      <g id="a11y-image-description" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M5.417 14.063h9.166L11.5 9.896l-2.25 3-1.5-2-2.333 3.166Zm.146-3.5c1.388 0 2.569-.487 3.541-1.459.972-.972 1.459-2.153 1.459-3.541h-1.5c0 .972-.34 1.798-1.021 2.479-.68.68-1.507 1.02-2.48 1.02v1.5Zm0-3c.555 0 1.027-.195 1.416-.584.39-.389.583-.86.583-1.416h-2v2Zm-1 9.604c-.487 0-.896-.167-1.23-.5a1.716 1.716 0 0 1-.5-1.23V4.563c0-.473.167-.875.5-1.209.334-.347.743-.52 1.23-.52h10.875c.486 0 .895.173 1.229.52.333.333.5.736.5 1.209v10.875c0 .472-.167.881-.5 1.229-.334.333-.743.5-1.23.5H4.563Zm0-1.73h10.875V4.563H4.563v10.875Zm0 0V4.563v10.875Z"></path>
      </g>
      <g id="text-to-speech" viewBox="0 0 16 16">
        <path fill-rule="evenodd" d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0Zm-5.335-3.549a33.45 33.45 0 0 0-.762.79l.039.042c.696.775 1.467 1.633 1.413 2.738.068 1.127-.67 2.053-1.434 2.805.216.286.434.57.653.855 1.258-.839 2.037-2.313 1.937-3.812-.02-1.355-.798-2.58-1.846-3.418Zm3.772 5.35a6.562 6.562 0 0 1-2.562 3.566c-.233-.31-.458-.624-.678-.942l.205-.203c.524-.519 1.054-1.044 1.404-1.694.869-1.564.818-3.568-.099-5.102-.309-.514-.735-.943-1.158-1.37a31.85 31.85 0 0 1-.306-.311c.233-.306.467-.61.704-.914 2.263 1.469 3.192 4.445 2.49 6.97ZM6.768 1.68c-.11-.003-.225-.008-.345-.014-2.921.698-5.09 3.281-5.09 6.361 0 2.658 1.614 4.946 3.934 5.972a23.226 23.226 0 0 1 1.48-.387c.206-1.043.328-2.1.379-3.162-.481-.277-.981-.52-1.481-.763-.228-.11-.456-.221-.682-.335l.557-.104c.652-.12 1.305-.24 1.946-.416l.042-.633c.02-.295.038-.59.061-.886a61.936 61.936 0 0 1 1.548-.978 11.89 11.89 0 0 0-.812-1.77c-.203-.367-.39-.742-.576-1.117-.3-.6-.599-1.2-.96-1.767Z" clip-rule="evenodd"></path>
      </g>
      <g id="a11y-keyboard-and-text-input" viewBox="0 0 14 8">
        <path fill-rule="evenodd" d="M3 7.75v-1.5h8v1.5H3Zm-2.75-3v-1.5h1.5v1.5H.25Zm3 0v-1.5h1.5v1.5h-1.5Zm3 0v-1.5h1.5v1.5h-1.5Zm3 0v-1.5h1.5v1.5h-1.5Zm3 0v-1.5h1.5v1.5h-1.5Zm-12-3V.25h1.5v1.5H.25Zm3 0V.25h1.5v1.5h-1.5Zm3 0V.25h1.5v1.5h-1.5Zm3 0V.25h1.5v1.5h-1.5Zm3 0V.25h1.5v1.5h-1.5Z"></path>
      </g>
      <g id="a11y-hearing" viewBox="0 0 16 18">
        <path fill-rule="evenodd" d="M12.167 17.146c-.945 0-1.667-.292-2.167-.875a5.825 5.825 0 0 1-1.104-2.042 9.489 9.489 0 0 0-.667-1.604c-.222-.444-.666-.847-1.333-1.208A5.187 5.187 0 0 1 4.77 9.375 5.648 5.648 0 0 1 4 6.5c0-1.556.542-2.875 1.625-3.958C6.722 1.458 8.049.917 9.605.917c1.569 0 2.895.555 3.978 1.666 1.098 1.111 1.646 2.466 1.646 4.063H13.5c0-1.111-.382-2.056-1.146-2.833-.75-.778-1.66-1.167-2.729-1.167-1.083 0-2.007.375-2.77 1.125-.75.75-1.126 1.66-1.126 2.729 0 .722.188 1.396.563 2.02a3.83 3.83 0 0 0 1.52 1.418c.848.444 1.424.923 1.73 1.437.32.514.639 1.264.958 2.25.222.667.465 1.132.73 1.396.277.264.582.396.916.396.375 0 .694-.146.958-.438.264-.291.396-.646.396-1.062h1.73c0 .916-.3 1.687-.897 2.312a2.918 2.918 0 0 1-2.166.917ZM3.313 12.75a9.161 9.161 0 0 1-1.896-2.875A9.003 9.003 0 0 1 .77 6.521c0-1.14.215-2.25.646-3.333A9.096 9.096 0 0 1 3.313.292L4.5 1.52a7.644 7.644 0 0 0-1.48 2.333A7.068 7.068 0 0 0 2.5 6.52c0 .917.174 1.812.52 2.687a7.454 7.454 0 0 0 1.5 2.334L3.314 12.75Zm6.312-4.23a1.929 1.929 0 0 1-1.417-.582 1.929 1.929 0 0 1-.583-1.417c0-.556.194-1.028.583-1.417a1.929 1.929 0 0 1 1.417-.583c.556 0 1.028.194 1.417.583.389.39.583.861.583 1.417a1.93 1.93 0 0 1-.583 1.417 1.929 1.929 0 0 1-1.417.583Z"></path>
      </g>
      <g id="a11y-find-more" viewBox="0 0 19 17">
        <path fill-rule="evenodd" d="M8 3.708c-.5 0-.93-.173-1.292-.52a1.787 1.787 0 0 1-.541-1.313c0-.5.18-.924.541-1.27A1.763 1.763 0 0 1 8 .061c.5 0 .93.181 1.292.542.36.347.541.778.541 1.292 0 .5-.18.93-.541 1.292A1.8 1.8 0 0 1 8 3.707Zm5.104 9.313c.528 0 .972-.18 1.334-.542.374-.36.562-.805.562-1.333a1.78 1.78 0 0 0-.562-1.334 1.778 1.778 0 0 0-1.334-.562c-.528 0-.972.18-1.333.542a1.812 1.812 0 0 0-.542 1.333c0 .528.18.98.542 1.354.36.361.805.542 1.333.542Zm3.938 3.27-2.063-2.062c-.278.18-.576.313-.896.396-.32.083-.646.125-.979.125-1 0-1.854-.347-2.562-1.042C9.847 13 9.5 12.138 9.5 11.125c0-1 .347-1.847 1.042-2.542a3.492 3.492 0 0 1 2.562-1.062c1 0 1.854.354 2.563 1.062.708.695 1.062 1.542 1.062 2.542 0 .333-.048.667-.146 1-.083.32-.208.618-.375.896l2.063 2.041-1.23 1.23Zm-8.105-.229v-1.979c.209.32.452.604.73.854.291.25.597.473.916.667v.459H8.937Zm-3.52 0V6.459c-.764-.07-1.521-.18-2.271-.333a42.886 42.886 0 0 1-2.208-.562l.416-1.521c1.084.291 2.18.52 3.292.687a24.596 24.596 0 0 0 6.708 0 29.184 29.184 0 0 0 3.313-.687l.416 1.52c-.736.237-1.479.424-2.229.563-.75.125-1.507.23-2.27.313v.229A5.157 5.157 0 0 0 8.707 8.5C8.236 9.278 8 10.146 8 11.104v-.041c0-.028-.007-.05-.02-.063h-.918v5.063H5.418Z"></path>
      </g>
      <g id="chevron-left" viewBox="0 0 20 21">
        <path fill-rule="evenodd" d="m14 6.178-4.945 4.59L14 15.358l-1.522 1.41-6.478-6 6.478-6L14 6.178Z" clip-rule="evenodd"></path>
      </g>
      <g id="chevron-right" viewBox="0 0 20 21">
        <path fill-rule="evenodd" d="m6 6.178 4.945 4.59L6 15.358l1.522 1.41 6.478-6-6.478-6L6 6.178Z" clip-rule="evenodd"></path>
      </g>
      <g id="a11y-contact-support" viewBox="0 -960 960 960">
        <path fill-rule="evenodd" d="m480-80-10-120h-10q-142 0-241-99t-99-241q0-142 99-241t241-99q71 0 132.5 26.5t108 73q46.5 46.5 73 108T800-540q0 75-24.5 144t-67 128q-42.5 59-101 107T480-80Zm80-146q71-60 115.5-140.5T720-540q0-109-75.5-184.5T460-800q-109 0-184.5 75.5T200-540q0 109 75.5 184.5T460-280h100v54Zm-101-95q17 0 29-12t12-29q0-17-12-29t-29-12q-17 0-29 12t-12 29q0 17 12 29t29 12Zm-29-127h60q0-30 6-42t38-44q18-18 30-39t12-45q0-51-34.5-76.5T460-720q-44 0-74 24.5T344-636l56 22q5-17 19-33.5t41-16.5q27 0 40.5 15t13.5 33q0 17-10 30.5T480-558q-35 30-42.5 47.5T430-448Zm30-65Z"></path>
      </g>

      <!-- Apps page section -->
      <g id="apps-notifications" viewBox="0 0 18 18">
        <path fill-rule="evenodd" d="M.833 9c0-1.139.209-2.201.625-3.187a8.327 8.327 0 0 1 1.75-2.584 8.112 8.112 0 0 1 2.605-1.75c1-.43 2.062-.646 3.187-.646.361 0 .715.021 1.063.063.36.041.708.11 1.041.208a3.602 3.602 0 0 0-.583.708 4.43 4.43 0 0 0-.417.855 3.164 3.164 0 0 0-.541-.084A7.9 7.9 0 0 0 9 2.563c-1.792 0-3.312.624-4.562 1.874C3.188 5.688 2.563 7.209 2.563 9c0 1.792.624 3.313 1.874 4.563 1.25 1.25 2.771 1.874 4.563 1.874 1.792 0 3.313-.624 4.563-1.874 1.25-1.25 1.874-2.771 1.874-4.563 0-.18-.006-.368-.02-.562a3.16 3.16 0 0 0-.084-.542c.306-.111.59-.25.854-.417.264-.167.5-.36.709-.583.097.333.166.68.208 1.042.042.347.063.7.063 1.062a7.974 7.974 0 0 1-.646 3.188c-.417.986-1 1.854-1.75 2.604a8.328 8.328 0 0 1-2.584 1.75A8.106 8.106 0 0 1 9 17.167a8.205 8.205 0 0 1-3.187-.625 8.59 8.59 0 0 1-2.605-1.75 8.589 8.589 0 0 1-1.75-2.604A8.204 8.204 0 0 1 .833 9ZM14 6.625a2.53 2.53 0 0 1-1.854-.77A2.528 2.528 0 0 1 11.375 4c0-.722.257-1.34.77-1.854A2.528 2.528 0 0 1 14 1.375c.722 0 1.34.257 1.854.77.514.515.771 1.133.771 1.855s-.257 1.34-.77 1.854A2.528 2.528 0 0 1 14 6.625Z"></path>
      </g>
      <g id="google-play" viewBox="0 0 18 20">
        <path fill-rule="evenodd" d="M7.063 10.604a.836.836 0 0 0 .229-.583.734.734 0 0 0-.25-.563L2.354 4.771v10.604l4.709-4.77Zm1.145-2.312c.153.166.34.25.563.25.222 0 .41-.084.562-.25l1.75-1.75L4 2.458a1.06 1.06 0 0 0-.77-.125c-.279.042-.494.146-.647.313l5.625 5.646Zm-4.25 9.27 7.105-4.083-1.73-1.708a.765.765 0 0 0-.562-.23.836.836 0 0 0-.584.23l-5.583 5.604c.195.194.403.306.625.333.236.028.48-.02.73-.145Zm8.584-4.895L15.354 11a1.8 1.8 0 0 0 .438-.417.991.991 0 0 0 .166-.562.957.957 0 0 0-.166-.542 1.145 1.145 0 0 0-.438-.416l-2.791-1.667L10.5 9.479a.836.836 0 0 0-.23.584c0 .222.077.41.23.562l2.042 2.042Zm-9.146 6.666c-.778 0-1.43-.264-1.958-.791a2.647 2.647 0 0 1-.771-1.917V3.395c0-.75.257-1.388.77-1.916.529-.542 1.182-.812 1.96-.812.25 0 .493.034.729.104.236.07.465.166.688.292L16.23 7.646c.43.236.771.562 1.021.979.264.417.396.875.396 1.375s-.132.965-.396 1.396a2.73 2.73 0 0 1-1.062 1L4.77 18.958a2.48 2.48 0 0 1-.646.292 3.17 3.17 0 0 1-.73.083Z"></path>
      </g>
      <g id="apps-android-settings" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M7.438 12.417a.862.862 0 0 1-.605-.23.823.823 0 0 1-.25-.604c0-.236.077-.437.23-.604a.823.823 0 0 1 .604-.25c.236 0 .444.084.625.25.18.153.27.354.27.604 0 .236-.09.438-.27.604a.862.862 0 0 1-.604.23Zm5.125 0a.94.94 0 0 1-.626-.23.823.823 0 0 1-.25-.604c0-.236.084-.437.25-.604a.848.848 0 0 1 .626-.25c.236 0 .437.084.604.25.166.167.25.368.25.604a.824.824 0 0 1-.25.604.862.862 0 0 1-.604.23Zm-9.355 3.875a1.53 1.53 0 0 1-1.125-.459 1.53 1.53 0 0 1-.458-1.125V5.292c0-.43.153-.799.458-1.104.306-.32.68-.48 1.125-.48h13.584c.43 0 .798.16 1.104.48.32.305.479.673.479 1.104v9.416c0 .445-.16.82-.48 1.125a1.505 1.505 0 0 1-1.103.459H3.208Zm.5-1.584h12.584v-1.146a5.763 5.763 0 0 0-.771-2.937 6.973 6.973 0 0 0-2-2.27L15 6.5a.481.481 0 0 0 .104-.417.535.535 0 0 0-.208-.396.666.666 0 0 0-.438-.104.471.471 0 0 0-.375.209l-1.562 2.02a5.298 5.298 0 0 0-1.23-.395A5.848 5.848 0 0 0 10 7.27a6.1 6.1 0 0 0-2.583.563L5.854 5.791a.535.535 0 0 0-.396-.209.59.59 0 0 0-.416.104.532.532 0 0 0-.23.375.502.502 0 0 0 .146.417l1.48 1.917a7.047 7.047 0 0 0-2 2.25 5.98 5.98 0 0 0-.73 2.916v1.146Z"></path>
      </g>
      <g id="apps-manage-isolated-web-apps" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M3.646 16.396a2.02 2.02 0 0 1-1.458-.584 2.023 2.023 0 0 1-.584-1.458V5.625c0-.57.195-1.049.583-1.437a2.023 2.023 0 0 1 1.459-.584h12.708c.57 0 1.049.202 1.438.604.402.39.604.868.604 1.438v8.729a1.92 1.92 0 0 1-.604 1.438 1.953 1.953 0 0 1-1.438.583H3.646Zm0-2.042h8.208v-2.5H3.646v2.5Zm9.708 0h3v-6.5h-3v6.5Zm-9.708-4h8.208v-2.5H3.646v2.5Z"></path>
      </g>
      <g id="apps-parental-controls" viewBox="0 -960 960 960">
        <path fill-rule="evenodd" d="M480-48q-182.62 0-307.31-67T48-281.81Q48-350 112-406t176-86v75q-77 23-122.5 59.83T120-282.48Q120-217 227.5-168.5T480-120q145 0 252.5-48.73T840-282.44Q840-320 794.5-357T672-417v-75q111 29 175.5 85.69 64.5 56.7 64.5 124.73Q912-182 787.31-115 662.62-48 480-48ZM360-192v-408H192v-72h576v72H600v408h-72v-192h-96v192h-72Zm119.75-540q-34.75 0-59.25-24.75t-24.5-59.5q0-34.75 24.75-59.25t59.5-24.5q34.75 0 59.25 24.75t24.5 59.5q0 34.75-24.75 59.25t-59.5 24.5Z"></path>
      </g>

      <!-- About page section -->
      <g id="counter-1">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M2 10C2 5.584 5.584 2 10 2C14.416 2 18 5.584 18 10C18 14.416 14.416 18 10 18C5.584 18 2 14.416 2 10ZM9.59448 14H11.1467V6.16895H10.9802L7.74146 7.3291V8.59131L9.59448 8.0166V14Z"></path>
      </g>
      <g id="counter-2">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M2 10C2 5.584 5.584 2 10 2C14.416 2 18 5.584 18 10C18 14.416 14.416 18 10 18C5.584 18 2 14.416 2 10ZM7.37622 14H12.7366V12.7485H9.37427L11.1521 10.874C11.6391 10.3405 11.9828 9.87321 12.1833 9.47217C12.3839 9.07112 12.4841 8.67725 12.4841 8.29053C12.4841 7.58512 12.2612 7.03906 11.8154 6.65234C11.3696 6.26562 10.7439 6.07227 9.93823 6.07227C9.41186 6.07227 8.941 6.18416 8.52563 6.40796C8.11027 6.63176 7.7889 6.94059 7.56152 7.33447C7.33415 7.72835 7.22046 8.16341 7.22046 8.63965H8.77808C8.77808 8.24577 8.87923 7.92798 9.08154 7.68628C9.28385 7.44458 9.56046 7.32373 9.91138 7.32373C10.2372 7.32373 10.4879 7.42309 10.6633 7.62183C10.8388 7.82056 10.9265 8.09359 10.9265 8.44092C10.9265 8.69515 10.8433 8.9637 10.6768 9.24658C10.5103 9.52946 10.2533 9.86068 9.90601 10.2402L7.37622 12.9365V14Z"></path>
      </g>
      <g id="counter-3">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M2 10C2 5.584 5.584 2 10 2C14.416 2 18 5.584 18 10C18 14.416 14.416 18 10 18C5.584 18 2 14.416 2 10ZM9.78247 9.40234H8.95532V10.6162H9.7771C10.6365 10.6162 11.0662 11.0065 11.0662 11.7871C11.0662 12.1094 10.9614 12.3681 10.752 12.5632C10.5425 12.7584 10.2533 12.856 9.88452 12.856C9.56225 12.856 9.29102 12.7629 9.0708 12.5767C8.85058 12.3905 8.74048 12.1506 8.74048 11.8569H7.18823C7.18823 12.5337 7.4362 13.078 7.93213 13.4897C8.42806 13.9015 9.06632 14.1074 9.84692 14.1074C10.6812 14.1074 11.3517 13.898 11.8584 13.479C12.3651 13.0601 12.6184 12.5033 12.6184 11.8086C12.6184 11.3789 12.5101 11.0065 12.2935 10.6914C12.0768 10.3763 11.7483 10.14 11.3079 9.98242C11.6624 9.82129 11.9488 9.59033 12.1672 9.28955C12.3857 8.98877 12.4949 8.65934 12.4949 8.30127C12.4949 7.6066 12.2603 7.06144 11.7913 6.66577C11.3222 6.2701 10.6741 6.07227 9.84692 6.07227C9.37068 6.07227 8.93474 6.16357 8.53906 6.34619C8.14339 6.52881 7.83545 6.78214 7.61523 7.1062C7.39502 7.43026 7.28491 7.79638 7.28491 8.20459H8.83716C8.83716 7.9432 8.93742 7.73104 9.13794 7.56812C9.33846 7.40519 9.58732 7.32373 9.88452 7.32373C10.214 7.32373 10.4727 7.41146 10.6606 7.58691C10.8486 7.76237 10.9426 8.00765 10.9426 8.32275C10.9426 8.6486 10.8477 8.90999 10.658 9.10693C10.4682 9.30387 10.1764 9.40234 9.78247 9.40234Z"></path>
      </g>
      <g id="counter-4">
        <path d="M10.4163 11.0566H8.68677L10.3142 8.47314L10.4163 8.2959V11.0566Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M10 2C5.584 2 2 5.584 2 10C2 14.416 5.584 18 10 18C14.416 18 18 14.416 18 10C18 5.584 14.416 2 10 2ZM11.9685 11.0566H12.8547V12.3081H11.9685V14H10.4163V12.3081H7.20972L7.13989 11.3306L10.4001 6.17969H11.9685V11.0566Z"></path>
      </g>
      <g id="counter-5">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M2 10C2 5.584 5.584 2 10 2C14.416 2 18 5.584 18 10C18 14.416 14.416 18 10 18C5.584 18 2 14.416 2 10ZM8.05835 6.17969L7.60718 10.1543L8.84253 10.4604L8.99292 10.3208C9.22209 10.1274 9.52108 10.0308 9.88989 10.0308C10.2909 10.0308 10.6007 10.1489 10.8191 10.3853C11.0375 10.6216 11.1467 10.9617 11.1467 11.4058C11.1467 11.8677 11.0518 12.2249 10.8621 12.4773C10.6723 12.7297 10.4019 12.856 10.051 12.856C9.73592 12.856 9.4808 12.7655 9.28564 12.5847C9.09049 12.4039 8.97681 12.1506 8.94458 11.8247H7.40845C7.42277 12.2687 7.5472 12.6644 7.78174 13.0117C8.01628 13.3591 8.33585 13.6285 8.74048 13.8201C9.1451 14.0116 9.58374 14.1074 10.0564 14.1074C10.5971 14.1074 11.0662 13.9973 11.4636 13.7771C11.8611 13.5569 12.1663 13.2472 12.3794 12.8479C12.5924 12.4486 12.699 11.9966 12.699 11.4917C12.699 10.661 12.4877 10.0147 12.0652 9.55273C11.6427 9.09082 11.059 8.85986 10.3142 8.85986C9.89884 8.85986 9.50676 8.95833 9.13794 9.15527L9.3313 7.47412H12.4412V6.17969H8.05835Z"></path>
      </g>
      <g id="counter-6">
        <path d="M9.39038 10.2107C9.59448 10.08 9.82186 10.0146 10.0725 10.0146C10.4234 10.0146 10.7027 10.1453 10.9104 10.4067C11.1181 10.6681 11.2219 11.0119 11.2219 11.438C11.2219 11.8569 11.119 12.198 10.9131 12.4612C10.7072 12.7244 10.4377 12.856 10.1047 12.856C9.73592 12.856 9.44946 12.71 9.24536 12.4182C9.04126 12.1264 8.93921 11.7209 8.93921 11.2017V10.729C9.03589 10.5142 9.18628 10.3414 9.39038 10.2107Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M10 2C5.584 2 2 5.584 2 10C2 14.416 5.584 18 10 18C14.416 18 18 14.416 18 10C18 5.584 14.416 2 10 2ZM11.5872 6.09912V7.37744H11.4368C10.7349 7.38818 10.1701 7.5708 9.74219 7.92529C9.31429 8.27979 9.05737 8.77213 8.97144 9.40234C9.3868 8.97982 9.91137 8.76855 10.5452 8.76855C11.2255 8.76855 11.7662 9.01204 12.1672 9.49902C12.5683 9.986 12.7688 10.6269 12.7688 11.4219C12.7688 11.9303 12.6587 12.3905 12.4385 12.8022C12.2183 13.214 11.9067 13.5345 11.5039 13.7637C11.1011 13.9928 10.6454 14.1074 10.137 14.1074C9.31339 14.1074 8.64828 13.821 8.1416 13.248C7.63493 12.6751 7.38159 11.9106 7.38159 10.9546V10.396C7.38159 9.54736 7.54183 8.7981 7.8623 8.14819C8.18278 7.49829 8.6429 6.9952 9.24268 6.63892C9.84245 6.28263 10.538 6.1027 11.3293 6.09912H11.5872Z"></path>
      </g>
      <g id="counter-7">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M2 10C2 5.584 5.584 2 10 2C14.416 2 18 5.584 18 10C18 14.416 14.416 18 10 18C5.584 18 2 14.416 2 10ZM9.66968 14L12.6936 7.0498V6.17969H7.17212V7.43652H11.0608L8.03149 14H9.66968Z"></path>
      </g>
      <g id="counter-8">
        <path d="M11.0823 11.7441C11.0823 11.404 10.9838 11.1318 10.7869 10.9277C10.5899 10.7236 10.325 10.6216 9.99194 10.6216C9.66251 10.6216 9.39933 10.7227 9.20239 10.925C9.00545 11.1274 8.90698 11.4004 8.90698 11.7441C8.90698 12.0772 9.00366 12.3457 9.19702 12.5498C9.39038 12.7539 9.65893 12.856 10.0027 12.856C10.3393 12.856 10.6034 12.7575 10.7949 12.5605C10.9865 12.3636 11.0823 12.0915 11.0823 11.7441Z"></path>
        <path d="M10.6794 7.60034C10.8406 7.78475 10.9211 8.02913 10.9211 8.3335C10.9211 8.64502 10.8415 8.89567 10.6821 9.08545C10.5228 9.27523 10.2963 9.37012 10.0027 9.37012C9.70906 9.37012 9.48169 9.27523 9.32056 9.08545C9.15942 8.89567 9.07886 8.64502 9.07886 8.3335C9.07886 8.01839 9.15942 7.77132 9.32056 7.59229C9.48169 7.41325 9.70727 7.32373 9.99731 7.32373C10.2909 7.32373 10.5183 7.41593 10.6794 7.60034Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M2 10C2 5.584 5.584 2 10 2C14.416 2 18 5.584 18 10C18 14.416 14.416 18 10 18C5.584 18 2 14.416 2 10ZM12.1887 9.26807C12.3785 8.97445 12.4734 8.63786 12.4734 8.2583C12.4734 7.58512 12.2505 7.05249 11.8047 6.6604C11.3589 6.26831 10.7564 6.07227 9.99731 6.07227C9.23462 6.07227 8.63127 6.2701 8.18726 6.66577C7.74324 7.06144 7.52124 7.59228 7.52124 8.2583C7.52124 8.63786 7.61523 8.97445 7.80322 9.26807C7.99121 9.56169 8.25171 9.79622 8.58472 9.97168C8.20874 10.1507 7.90975 10.4014 7.68774 10.7236C7.46574 11.0459 7.35474 11.4237 7.35474 11.8569C7.35474 12.548 7.59285 13.0959 8.06909 13.5005C8.54533 13.9051 9.18986 14.1074 10.0027 14.1074C10.8155 14.1074 11.4583 13.906 11.9309 13.5032C12.4036 13.1003 12.6399 12.5516 12.6399 11.8569C12.6399 11.4237 12.5289 11.0468 12.3069 10.7263C12.0849 10.4058 11.7841 10.1543 11.4045 9.97168C11.7376 9.79622 11.9989 9.56169 12.1887 9.26807Z"></path>
      </g>
      <g id="counter-9">
        <path d="M10.6177 10.0898C10.4368 10.2188 10.2211 10.2832 9.97046 10.2832C9.61596 10.2832 9.34115 10.1462 9.146 9.87231C8.95085 9.59839 8.85327 9.24837 8.85327 8.82227C8.85327 8.39258 8.95353 8.0354 9.15405 7.75073C9.35457 7.46606 9.61059 7.32373 9.92212 7.32373C10.2587 7.32373 10.5273 7.46875 10.7278 7.75879C10.9283 8.04883 11.0286 8.45703 11.0286 8.9834V9.62256C10.9355 9.80518 10.7985 9.96094 10.6177 10.0898Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M10 2C5.584 2 2 5.584 2 10C2 14.416 5.584 18 10 18C14.416 18 18 14.416 18 10C18 5.584 14.416 2 10 2ZM11.0071 10.874C10.6025 11.2715 10.1298 11.4702 9.58911 11.4702C8.89803 11.4702 8.34481 11.233 7.92944 10.7585C7.51408 10.2841 7.3064 9.64405 7.3064 8.83838C7.3064 8.32633 7.41829 7.85637 7.64209 7.42847C7.86589 7.00057 8.1783 6.66756 8.57935 6.42944C8.98039 6.19132 9.43156 6.07227 9.93286 6.07227C10.4485 6.07227 10.9068 6.20117 11.3079 6.45898C11.7089 6.7168 12.0204 7.0874 12.2424 7.5708C12.4644 8.0542 12.5772 8.60742 12.5808 9.23047V9.80518C12.5808 11.1086 12.2568 12.1326 11.6086 12.8774C10.9605 13.6222 10.0421 14.0197 8.85327 14.0698L8.47192 14.0752V12.7808L8.81567 12.7754C10.1656 12.7145 10.8961 12.0807 11.0071 10.874Z"></path>
      </g>
      <g id="about-update-complete" viewBox="0 0 16 16">
        <path fill-rule="evenodd" d="M8 15.167a7.012 7.012 0 0 1-2.792-.563 7.165 7.165 0 0 1-2.27-1.52 7.731 7.731 0 0 1-1.542-2.292A7.012 7.012 0 0 1 .833 8c0-.986.188-1.917.563-2.792a7.46 7.46 0 0 1 1.542-2.27 6.996 6.996 0 0 1 2.27-1.542A7.012 7.012 0 0 1 8 .833c1.139 0 2.18.243 3.125.73A7.009 7.009 0 0 1 13.542 3.5V.875h1.583V6H10V4.417h2.083a4.944 4.944 0 0 0-1.791-1.354A5.314 5.314 0 0 0 8 2.563c-1.5 0-2.785.534-3.854 1.604C3.09 5.222 2.563 6.5 2.563 8s.527 2.785 1.583 3.854C5.216 12.91 6.5 13.438 8 13.438s2.778-.528 3.833-1.584c1.07-1.07 1.604-2.354 1.604-3.854h1.73c0 2-.695 3.694-2.084 5.083C11.694 14.473 10 15.167 8 15.167Zm2.042-4.292L7.208 8.042V4h1.584v3.375l2.375 2.375-1.125 1.125Z"></path>
      </g>
      <g id="about-update-warning" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M.854 17.083 10 1.833l9.146 15.25H.854Zm2.917-1.645h12.458L10 5.063 3.77 15.438ZM10 14.479c.208 0 .389-.07.542-.208a.765.765 0 0 0 .229-.563.74.74 0 0 0-.23-.541.698.698 0 0 0-.541-.23.74.74 0 0 0-.542.23.698.698 0 0 0-.229.541c0 .209.07.39.209.542.152.153.34.23.562.23ZM9.25 12h1.5V8.063h-1.5V12Z"></path>
      </g>
      <g id="about-update-error" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M10 14.167c.25 0 .458-.084.625-.25a.839.839 0 0 0 .27-.646c0-.25-.09-.459-.27-.625a.815.815 0 0 0-.625-.271c-.25 0-.465.09-.646.27a.848.848 0 0 0-.25.626c0 .25.084.465.25.646a.92.92 0 0 0 .646.25ZM9.125 11h1.75V5.896h-1.75V11ZM10 18.167a8.205 8.205 0 0 1-3.187-.625 8.59 8.59 0 0 1-2.605-1.75 8.589 8.589 0 0 1-1.75-2.604A8.204 8.204 0 0 1 1.833 10c0-1.139.209-2.201.625-3.187a8.327 8.327 0 0 1 1.75-2.584 8.112 8.112 0 0 1 2.605-1.75c1-.43 2.062-.646 3.187-.646 1.139 0 2.201.216 3.188.646.986.417 1.847 1 2.583 1.75a7.82 7.82 0 0 1 1.75 2.604c.43.986.646 2.042.646 3.167a7.974 7.974 0 0 1-.646 3.188c-.417.986-1 1.854-1.75 2.604a8.262 8.262 0 0 1-2.604 1.75 8.053 8.053 0 0 1-3.167.625Zm0-1.73c1.792 0 3.313-.625 4.563-1.875 1.25-1.25 1.874-2.77 1.874-4.562 0-1.792-.625-3.312-1.875-4.562-1.25-1.25-2.77-1.875-4.562-1.875-1.792 0-3.312.624-4.562 1.874C4.188 6.688 3.563 8.209 3.563 10c0 1.792.624 3.313 1.874 4.563 1.25 1.25 2.771 1.874 4.563 1.874Z"></path>
      </g>
      <g id="about-release-notes" viewBox="0 0 18 18">
        <path fill-rule="evenodd" d="m4.792 13.208 6.041-2.375 2.375-6.041-6.041 2.375-2.375 6.041ZM9 10a.896.896 0 0 1-.708-.27A1.035 1.035 0 0 1 8 9c0-.278.097-.514.292-.708A.964.964 0 0 1 9 8c.278 0 .514.097.708.292.195.194.292.43.292.708a.964.964 0 0 1-.292.708A.964.964 0 0 1 9 10Zm0 7.167a8.205 8.205 0 0 1-3.187-.625 8.59 8.59 0 0 1-2.605-1.75 8.589 8.589 0 0 1-1.75-2.604A8.204 8.204 0 0 1 .833 9c0-1.139.209-2.201.625-3.187a8.327 8.327 0 0 1 1.75-2.584 8.112 8.112 0 0 1 2.605-1.75c1-.43 2.062-.646 3.187-.646 1.139 0 2.201.216 3.188.646.986.417 1.847 1 2.583 1.75a7.82 7.82 0 0 1 1.75 2.604c.43.986.646 2.042.646 3.167a7.974 7.974 0 0 1-.646 3.188c-.417.986-1 1.854-1.75 2.604a8.262 8.262 0 0 1-2.604 1.75A8.053 8.053 0 0 1 9 17.167Zm0-1.73c1.792 0 3.313-.624 4.563-1.874 1.25-1.25 1.874-2.771 1.874-4.563 0-1.792-.624-3.312-1.874-4.562-1.25-1.25-2.771-1.875-4.563-1.875-1.792 0-3.312.624-4.562 1.874C3.188 5.688 2.563 7.209 2.563 9c0 1.792.624 3.313 1.874 4.563 1.25 1.25 2.771 1.874 4.563 1.874Z"></path>
      </g>
      <g id="about-help" viewBox="0 0 16 16">
        <path fill-rule="evenodd" d="M7.98 12.5a.897.897 0 0 0 .687-.292.964.964 0 0 0 .291-.708.921.921 0 0 0-.291-.708.931.931 0 0 0-.688-.271c-.278 0-.52.09-.729.27a.922.922 0 0 0-.292.709c0 .278.098.514.292.708a.99.99 0 0 0 .73.292Zm-.75-2.854h1.478c0-.472.042-.806.125-1 .084-.195.299-.452.646-.771.278-.264.521-.549.73-.854.222-.32.333-.708.333-1.167 0-.75-.257-1.326-.771-1.729-.5-.417-1.097-.625-1.792-.625-.68 0-1.25.201-1.708.604-.445.39-.757.833-.938 1.334L6.667 6c.097-.236.236-.48.416-.73.195-.263.493-.395.896-.395s.688.111.854.333c.18.209.271.438.271.688 0 .278-.104.535-.312.77-.209.223-.41.431-.604.626-.445.43-.716.77-.813 1.02-.097.25-.146.695-.146 1.334Zm-4.667 5.52c-.487 0-.896-.166-1.23-.5a1.671 1.671 0 0 1-.5-1.229V2.563c0-.487.167-.896.5-1.23a1.67 1.67 0 0 1 1.23-.5h10.875c.486 0 .895.167 1.229.5.333.334.5.743.5 1.23v10.875c0 .486-.167.895-.5 1.229-.334.333-.743.5-1.23.5H2.563Zm0-1.729h10.875V2.563H2.563v10.875Zm0-10.874v10.875V2.563Z"></path>
      </g>
      <g id="about-feedback" viewBox="0 0 18 18">
        <path fill-rule="evenodd" d="M9 11.5a.79.79 0 0 0 .583-.23.756.756 0 0 0 .25-.582.756.756 0 0 0-.25-.584.756.756 0 0 0-.583-.25.823.823 0 0 0-.604.25.765.765 0 0 0-.23.563c0 .236.077.437.23.604.166.153.368.229.604.229Zm-.792-2.458h1.584V3.5H8.208v5.542ZM.833 17.167V2.562c0-.486.167-.895.5-1.229a1.67 1.67 0 0 1 1.23-.5h12.875c.486 0 .895.167 1.229.5.333.334.5.743.5 1.23v9.875c0 .486-.167.895-.5 1.229-.334.333-.743.5-1.23.5H3.834l-3 3Zm2.375-4.73h12.23V2.563H2.563v10.52l.645-.646Zm-.646 0V2.563v9.875Z"></path>
      </g>
      <g id="about-diagnostics" viewBox="0 0 20 14">
        <path fill-rule="evenodd" d="M7.542 13.125a1.34 1.34 0 0 1-.792-.25 1.391 1.391 0 0 1-.48-.646L4.5 7.875H.875v-1.75h4.813l1.854 4.625 3.646-9a1.34 1.34 0 0 1 1.27-.875c.292 0 .549.083.771.25.236.167.403.382.5.646L15.5 6.125h3.625v1.75h-4.792L12.458 3.25l-3.645 9a1.36 1.36 0 0 1-.5.625 1.25 1.25 0 0 1-.771.25Z"></path>
      </g>
      <g id="about-firmware-updates" viewBox="0 0 18 14">
        <path fill-rule="evenodd" d="M2.563 13.167c-.487 0-.896-.167-1.23-.5a1.671 1.671 0 0 1-.5-1.23V2.563c0-.487.167-.896.5-1.23a1.67 1.67 0 0 1 1.23-.5h4.312v1.73H2.563v8.875h12.875V2.563h-4.313V.833h4.313c.486 0 .895.167 1.229.5.333.334.5.743.5 1.23v8.875c0 .486-.167.895-.5 1.229-.334.333-.743.5-1.23.5H2.563Zm6.437-3L4.833 6l1.23-1.208 2.062 2.062V.834h1.75v6.02l2.063-2.062L13.167 6 9 10.167Z"></path>
      </g>
      <g id="about-additional-details" viewBox="0 0 16 10">
        <path fill-rule="evenodd" d="M.833 9.833V8.125h5.25v1.708H.833Zm0-3.958v-1.73h9.292v1.73H.833Zm0-3.98V.168h14.334v1.729H.833Z"></path>
      </g>
      <g id="about-linux" viewBox="0 0 16 16">
        <path fill-rule="evenodd" d="M6.345 5.812c0 .47-.37.85-.828.85a.84.84 0 0 1-.827-.85c0-.47.37-.85.827-.85a.84.84 0 0 1 .828.85ZM10.483 6.662a.84.84 0 0 0 .827-.85.84.84 0 0 0-.827-.85.84.84 0 0 0-.828.85c0 .47.37.85.828.85ZM7.832 7.122a.384.384 0 0 1 .318 0l1.136.512a.398.398 0 0 1 .128.63L8.285 9.51a.386.386 0 0 1-.575 0L6.585 8.26a.4.4 0 0 1 .128-.629l1.12-.509Z"></path>
        <path fill-rule="evenodd" d="M8 15.22c-.068 0-.136.051-.203.102l-.076.055c-.03.325-.274.623-1.652.623-1.693 0-1.674-.352-1.65-.815.004-.058.007-.117.007-.177 0-.082.016-.156.047-.221-1.96-.815-3.215-2.462-3.258-5.33-.198.104-.422.121-.682.024-.741-.278-.575-1.206-.303-2.034.226-.685.995-1.186 1.372-1.29C2.478 2.704 4.536 0 8 0c3.506 0 5.577 2.592 6.43 6.166.385.122 1.12.614 1.34 1.281.272.828.438 1.756-.303 2.034-.26.097-.484.08-.682-.023-.039 2.887-1.296 4.525-3.256 5.334.03.064.045.136.045.216 0 .06.004.12.007.177.024.463.043.815-1.65.815-1.388 0-1.626-.302-1.652-.63-.023-.015-.046-.032-.068-.048-.07-.05-.14-.102-.211-.102Zm0-1.662c3.657 0 4.975-1.602 4.975-5.148 0-2.943-1.199-5.645-3.189-6.097-.324-.073-.598.296-.882.678-.275.37-.558.751-.904.751-.353 0-.657-.398-.946-.775-.285-.373-.555-.725-.84-.654-1.999.504-3.19 3.31-3.19 6.097 0 3.346 1.32 5.149 4.976 5.149Z" clip-rule="evenodd"></path>
      </g>
      <g id="about-manage-develop-environment" viewBox="0 0 18 16">
        <path fill-rule="evenodd" d="M.833 3.917V2.563c0-.487.167-.896.5-1.23.348-.333.757-.5 1.23-.5h12.875c.486 0 .895.167 1.229.5.333.334.5.743.5 1.23v1.354h-1.73V2.563H2.563v1.354H.833Zm5.084 11.25v-2H2.563c-.473 0-.882-.167-1.23-.5a1.671 1.671 0 0 1-.5-1.23v-1.354h1.73v1.354h12.875v-1.354h1.729v1.354c0 .487-.167.896-.5 1.23-.334.333-.743.5-1.23.5h-3.354v2H5.917ZM3.063 7 5 5.063 3.875 3.938.833 7l3.042 3.063L5 8.937 3.063 7Zm11.875 0L13 8.938l1.125 1.104L17.167 7l-3.042-3.062L13 5.062 14.938 7Z"></path>
      </g>

      <!-- Crostini Mascot icon for Settings drawer -->
      <g id="crostini-mascot" fill-rule="evenodd" viewBox="0 0 24 24">
        <rect width="24" height="24" fill="none"></rect>
        <path d="M6.70994751,22.1802367 C3.77039152,20.9576222 1.88689678,18.4876617 1.82270453,14.1866283 C1.52620735,14.3410271 1.18877909,14.3669908 0.800057996,14.221322 C-0.312414045,13.804436 -0.0624529958,12.4120387 0.345560769,11.1705211 C0.68346303,10.142341 1.83735671,9.39181671 2.40240955,9.23479478 C3.71763772,4.05541221 6.80346772,0 12,0 C17.2584272,0 20.3654882,3.88805047 21.6436562,9.24850027 C22.2231374,9.43172978 23.3254781,10.1695473 23.6544392,11.1705211 C24.062453,12.4120387 24.312414,13.804436 23.199942,14.221322 C22.8112853,14.3669667 22.4739044,14.3410357 22.1774428,14.186705 C22.1189307,18.5169382 20.2342349,20.9750038 17.2936622,22.1879533 C17.3379726,22.2841737 17.3614392,22.3916932 17.3614392,22.5115654 C17.3614392,23.3336051 17.750632,24 14.8965517,24 C12.813813,24 12.4581871,23.5470722 12.4180882,23.0543665 C12.2796354,22.9647547 12.14026,22.8305157 12,22.8305157 C11.8594243,22.8305157 11.7197425,22.9755283 11.5809922,23.0650454 C11.536581,23.553597 11.171131,24 9.10344828,24 C6.24936798,24 6.63856075,23.3336051 6.63856075,22.5115654 C6.63856075,22.3884786 6.66330281,22.278416 6.70994751,22.1802367 Z M12,20.3378361 C17.4851654,20.3378361 19.4630542,17.934489 19.4630542,12.6147346 C19.4630542,8.20063746 17.6641739,4.14700996 14.6790451,3.47027327 C13.7222433,3.25336374 13.052482,5.61336212 12,5.61336212 C10.947518,5.61336212 10.1820765,3.25336374 9.32095491,3.47027327 C6.32316904,4.22539115 4.53694581,8.43392639 4.53694581,12.6147346 C4.53694581,17.6346061 6.51483457,20.3378361 12,20.3378361 Z M8.27586207,9.99377535 C7.59026721,9.99377535 7.03448276,9.42257974 7.03448276,8.71797424 C7.03448276,8.01336875 7.59026721,7.44217314 8.27586207,7.44217314 C8.96145693,7.44217314 9.51724138,8.01336875 9.51724138,8.71797424 C9.51724138,9.42257974 8.96145693,9.99377535 8.27586207,9.99377535 Z M15.7241379,9.99377535 C15.0385431,9.99377535 14.4827586,9.42257974 14.4827586,8.71797424 C14.4827586,8.01336875 15.0385431,7.44217314 15.7241379,7.44217314 C16.4097328,7.44217314 16.9655172,8.01336875 16.9655172,8.71797424 C16.9655172,9.42257974 16.4097328,9.99377535 15.7241379,9.99377535 Z M12.224615,10.6827627 L13.9283449,11.4510541 C14.2234366,11.5841248 14.3564393,11.9349546 14.2254148,12.2346546 C14.1996198,12.293657 14.1645229,12.3479919 14.1215061,12.39552 L12.4275305,14.2671455 C12.2090286,14.5085621 11.8392003,14.5243719 11.6014958,14.3024578 C11.5890079,14.2907994 11.5770255,14.2785946 11.5655826,14.265878 L9.87720766,12.3895636 C9.65939502,12.1475054 9.67603268,11.771949 9.91436891,11.5507349 C9.9604013,11.5080095 10.012868,11.4730393 10.0697797,11.4471502 L11.7484004,10.6835476 C11.8998356,10.6146599 12.0729604,10.6143745 12.224615,10.6827627 Z"></path>
      </g>

      <!-- Developer Tags icon for Settings drawer -->
      <g id="developer-tags" viewBox="0 0 24 24">
        <rect width="24" height="24" fill="none"></rect>
        <path d="M0 0h24v24H0V0z" fill="none"></path><path d="M16 6l-1.41 1.41L19.17 12l-4.58 4.59L16 18l6-6zM8 18l1.41-1.41L4.83 12l4.58-4.59L8 6l-6 6z"></path>
      </g>

      <!-- Device section -->
      <g id="device-pointing-stick" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M10 11.625c-.444 0-.826-.16-1.146-.48-.32-.319-.479-.7-.479-1.145 0-.444.16-.826.48-1.146.319-.32.7-.479 1.145-.479.444 0 .826.16 1.146.48.32.319.479.7.479 1.145 0 .444-.16.826-.48 1.146-.319.32-.7.479-1.145.479Zm-.875-4.75v-5.02h1.75v5.02h-1.75Zm0 11.27v-5.02h1.75v5.02h-1.75Zm4-7.27v-1.75h5.02v1.75h-5.02Zm-11.27 0v-1.75h5.02v1.75h-5.02Z"></path>
      </g>
      <g id="device-mouse" viewBox="0 0 20 20">
           <path fill-rule="evenodd" d="M10 18.167c-1.708 0-3.167-.598-4.375-1.792C4.431 15.167 3.833 13.708 3.833 12V8c0-1.708.598-3.16 1.792-4.354C6.833 2.438 8.292 1.833 10 1.833c1.708 0 3.16.605 4.354 1.813C15.563 4.84 16.167 6.292 16.167 8v4c0 1.708-.605 3.167-1.813 4.375-1.194 1.194-2.646 1.792-4.354 1.792ZM10.75 7.5h3.646a4.316 4.316 0 0 0-1.167-2.542c-.666-.708-1.493-1.146-2.479-1.312V7.5Zm-5.146 0H9.25V3.646a4.14 4.14 0 0 0-2.48 1.312A4.316 4.316 0 0 0 5.605 7.5ZM10 16.438c1.222 0 2.264-.431 3.125-1.292.875-.875 1.313-1.924 1.313-3.146V9H5.563v3c0 1.222.43 2.27 1.291 3.146.875.86 1.924 1.291 3.146 1.291Z"></path>
      </g>
      <g id="device-touchpad" viewBox="0 0 18 16">
        <path fill-rule="evenodd" d="M12.583 13.52c.82 0 1.514-.284 2.084-.853a2.88 2.88 0 0 0 .854-2.084V9.75H9.646v.833c0 .806.285 1.5.854 2.084a2.88 2.88 0 0 0 2.083.854ZM9.688 8.126h2.083V5.75a2.997 2.997 0 0 0-1.396.875 2.775 2.775 0 0 0-.687 1.5Zm3.708 0h2.083a2.906 2.906 0 0 0-.708-1.5 2.866 2.866 0 0 0-1.375-.875v2.375Zm-.813 7.042c-1.291 0-2.382-.438-3.27-1.313C8.437 12.965 8 11.875 8 10.584V8.645c0-1.292.438-2.375 1.313-3.25.888-.89 1.979-1.333 3.27-1.333 1.292 0 2.375.444 3.25 1.333.89.875 1.334 1.958 1.334 3.25v1.937c0 1.292-.445 2.382-1.334 3.271-.875.875-1.958 1.313-3.25 1.313Zm-10.02-3.73V2.563v8.874Zm0 1.73c-.487 0-.896-.167-1.23-.5a1.716 1.716 0 0 1-.5-1.23V2.563c0-.473.167-.876.5-1.209.334-.347.743-.52 1.23-.52h12.875c.486 0 .895.173 1.229.52.333.333.5.736.5 1.209v2.083a5.916 5.916 0 0 0-.813-.75 5.5 5.5 0 0 0-.916-.604v-.73H2.563v8.876h4c.027.305.083.604.166.895.083.292.195.57.333.834h-4.5Z"></path>
      </g>
      <g id="device-keyboard" viewBox="0 0 18 12">
        <path fill-rule="evenodd" d="M2.5 11.23c-.472 0-.882-.168-1.23-.5a1.716 1.716 0 0 1-.5-1.23v-7c0-.472.167-.875.5-1.208C1.619.944 2.029.77 2.5.77h13c.472 0 .875.173 1.208.52.348.334.521.737.521 1.209v7c0 .472-.173.882-.52 1.23-.334.332-.737.5-1.209.5h-13Zm0-1.73h13v-7h-13v7ZM6 9h6V7.5H6V9ZM4 6.5h1.5V5H4v1.5Zm2.125 0h1.5V5h-1.5v1.5Zm2.125 0h1.5V5h-1.5v1.5Zm2.125 0h1.5V5h-1.5v1.5Zm2.125 0H14V5h-1.5v1.5ZM4 4.5h1.5V3H4v1.5Zm2.125 0h1.5V3h-1.5v1.5Zm2.125 0h1.5V3h-1.5v1.5Zm2.125 0h1.5V3h-1.5v1.5Zm2.125 0H14V3h-1.5v1.5Zm-10 5v-7 7Z"></path>
      </g>
      <g id="device-stylus" viewBox="0 0 16 16">
        <path fill-rule="evenodd" d="M1.917 15.125a.83.83 0 0 1-.813-.23.952.952 0 0 1-.229-.832l.77-3.75 4.022 4.041-3.75.771Zm3.75-.77-4.021-4.043 8.958-8.937c.334-.333.736-.5 1.209-.5.472 0 .874.167 1.208.5l1.604 1.583c.333.334.5.743.5 1.23 0 .472-.167.875-.5 1.208l-8.958 8.958Zm6.146-11.75-8.021 8.04 1.562 1.563 8.042-8.02-1.584-1.584Z"></path>
      </g>
      <g id="device-tablet" viewBox="0 0 20 14">
        <path fill-rule="evenodd" d="M2.583 13.167a1.67 1.67 0 0 1-1.229-.5 1.716 1.716 0 0 1-.5-1.23V2.563c0-.487.167-.896.5-1.23a1.67 1.67 0 0 1 1.23-.5h14.833c.486 0 .895.174 1.229.521.333.333.5.736.5 1.209v8.875c0 .486-.167.895-.5 1.229a1.67 1.67 0 0 1-1.23.5H2.584Zm1-10.604h-1v8.875h1V2.563Zm1.5 8.875h9.834V2.563H5.083v8.875Zm11.334-8.875v8.875h1V2.563h-1Zm0 0h1-1Zm-12.834 0h-1 1Z"></path>
      </g>
      <g id="device-display" viewBox="0 0 18 16">
        <path fill-rule="evenodd" d="M5.917 15.167v-2H2.563c-.487 0-.896-.167-1.23-.5a1.671 1.671 0 0 1-.5-1.23V2.563c0-.487.167-.896.5-1.23a1.67 1.67 0 0 1 1.23-.5h12.875c.486 0 .895.167 1.229.5.333.334.5.743.5 1.23v8.875c0 .486-.167.895-.5 1.229-.334.333-.743.5-1.23.5h-3.354v2H5.917Zm-3.354-3.73h12.875V2.563H2.563v8.875Zm0 0V2.563v8.875Z"></path>
      </g>
      <g id="device-audio" viewBox="0 0 12 17">
        <path fill-rule="evenodd" d="M6 11.23c-.75 0-1.389-.258-1.917-.772a2.646 2.646 0 0 1-.77-1.916V3.583c0-.75.256-1.389.77-1.916A2.61 2.61 0 0 1 6 .875c.75 0 1.382.264 1.896.792a2.61 2.61 0 0 1 .792 1.916v4.959a2.61 2.61 0 0 1-.792 1.916c-.514.514-1.146.771-1.896.771Zm-.833 5.083v-2.084c-1.417-.194-2.59-.826-3.521-1.896C.716 11.25.25 9.986.25 8.542h1.646c0 1.139.396 2.11 1.187 2.916.806.792 1.778 1.188 2.917 1.188 1.139 0 2.104-.396 2.896-1.188.805-.805 1.208-1.777 1.208-2.916h1.646c0 1.444-.465 2.708-1.396 3.791-.93 1.07-2.104 1.702-3.52 1.896v2.084H5.166ZM6 9.5c.278 0 .507-.09.688-.27.18-.181.27-.41.27-.688V3.583a.931.931 0 0 0-.27-.687A.932.932 0 0 0 6 2.625a.932.932 0 0 0-.687.27.931.931 0 0 0-.271.688v4.959c0 .277.09.507.27.687.181.18.41.271.688.271Z"></path>
      </g>
      <g id="device-print" viewBox="0 0 18 16">
        <path fill-rule="evenodd" d="M14.167 3.833H3.833v-3h10.334v3Zm-.521 4.875c.222 0 .41-.076.562-.229a.756.756 0 0 0 .25-.583.79.79 0 0 0-.229-.583.757.757 0 0 0-.583-.25.823.823 0 0 0-.604.25.765.765 0 0 0-.23.562c0 .236.077.438.23.604.166.153.368.23.604.23Zm-1.209 4.855v-2.626H5.564v2.626h6.875Zm1.73 1.687H3.833v-3.104h-3V7c0-.597.209-1.104.625-1.52.417-.431.924-.647 1.521-.647h12.042c.597 0 1.104.216 1.52.646.417.417.626.924.626 1.521v5.146h-3v3.104Z"></path>
      </g>
      <g id="device-scan" viewBox="0 0 16 13">
        <path fill-rule="evenodd" d="M10.708 5.77 1.167 2.334 1.729.771l12.209 4.416c.43.14.756.382.979.73.236.333.354.701.354 1.104V10.5c0 .472-.174.882-.521 1.23-.333.332-.736.5-1.208.5H2.458c-.472 0-.882-.168-1.229-.5a1.716 1.716 0 0 1-.5-1.23v-3c0-.486.167-.896.5-1.23.347-.332.757-.5 1.23-.5h8.25Zm2.834 4.73v-3H2.458v3h11.084Zm-7.084-.75h6.084v-1.5H6.458v1.5Zm-2.25 0c.209 0 .382-.07.521-.208A.74.74 0 0 0 4.96 9a.707.707 0 0 0-.209-.52.698.698 0 0 0-.542-.23.74.74 0 0 0-.541.23.707.707 0 0 0-.209.52c0 .208.07.389.209.542a.779.779 0 0 0 .541.208Zm-1.75.75v-3 3Z"></path>
      </g>
      <g id="volume-down"><path fill-rule="evenodd" clip-rule="evenodd" d="M1 13H4.46667L8 16.5V3.5L4.46667 7H1V13ZM10 6.5V13.5C11.776 12.8652 12.5 11.0043 12.5 10C12.5 8.99565 11.776 7.14348 10 6.5Z"></path></g>
      <g id="volume-up"><path fill-rule="evenodd" clip-rule="evenodd" d="M1 13H4.46667L8 16.4V3.40002L4.46667 7.00002H1V13ZM10 6.40002V13.4C11.776 12.7652 12.5 10.9044 12.5 9.90002C12.5 8.89568 11.776 7.0435 10 6.40002ZM10 4.16171C12.4771 4.89717 14.5 7.18908 14.5 9.90002C14.5 12.611 12.4771 14.9029 10 15.6383V17.4C13.4371 16.6218 16 13.5602 16 9.90002C16 6.23982 13.4371 3.17825 10 2.40002V4.16171Z"></path></g>
      <g id="volume-up-off"><path fill-rule="evenodd" clip-rule="evenodd" d="M10 6.513V7.97617L12.4583 10.5528C12.6093 10.1206 12.5 7.42639 10 6.513ZM13.9946 12.3314L15.1797 13.4534C15.7487 12.3314 16 11.3267 16 9.9645C16 6.07761 13 3.12889 10 2.49896V4.2774C12.6423 5.05842 14.5 7.5 14.5 9.9645C14.5 10.8182 14.3055 11.5867 13.9946 12.3314ZM1 3.12889L4.71387 6.74969L4.5 7H1V13H4.5L8 16.5V10L12.5 14.3494C11.7872 14.8533 11.5515 15.2067 10 15.7357V17.4865C11.4697 17.2198 12.4473 16.5573 13.5598 15.6162L15.8711 18L17 16.8711L2.12889 2L1 3.12889ZM6.573 4.83173L8 6.16345V3.5L6.573 4.83173Z"></g>
      <g id="volume-zero"><path fill-rule="evenodd" clip-rule="evenodd" d="M1 13H4.46667L8 16.5V3.5L4.46667 7H1V13Z"></g>

      <!-- Files section -->
      <g id="folder-outline"><path d="M16 5h-4l-2-2H4c-1.1 0-1.99.9-1.99 2L2 15c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 10H4V7h12v8z"></path></g>
      <g id="folder-shared" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M10 14h6v-.354c0-.403-.306-.764-.917-1.084-.61-.319-1.305-.479-2.083-.479-.792 0-1.493.16-2.104.48-.597.305-.896.666-.896 1.083V14Zm3-2.917c.417 0 .77-.146 1.063-.437.291-.292.437-.646.437-1.063 0-.416-.146-.77-.438-1.062A1.447 1.447 0 0 0 13 8.083c-.417 0-.77.153-1.063.459a1.446 1.446 0 0 0-.437 1.062c0 .403.146.75.438 1.042.291.291.645.437 1.062.437Zm-9.438 5.084c-.472 0-.881-.167-1.229-.5a1.716 1.716 0 0 1-.5-1.23V5.563c0-.487.167-.896.5-1.23.348-.333.757-.5 1.23-.5h4.354L10 5.896h6.438c.486 0 .895.173 1.229.52.333.334.5.737.5 1.209v6.813c0 .472-.167.881-.5 1.229-.334.333-.743.5-1.23.5H3.563Zm0-1.73h12.876V7.625H9.27L7.208 5.562H3.562v8.875Zm0 0V5.563v8.875Z"></path>
      </g>

      <!-- Graduation icons -->
      <g id="graduation" viewBox="0 -960 960 960">
        <path fill-rule="evenodd" d="M480-120 200-272v-240L40-600l440-240 440 240v320h-80v-276l-80 44v240L480-120Zm0-332 274-148-274-148-274 148 274 148Zm0 241 200-108v-151L480-360 280-470v151l200 108Zm0-241Zm0 90Zm0 0Z"></path>
      </g>

      <!-- Keyboard shortcut banner icons -->
      <g id="keyboard-shortcut" viewBox="0 0 48 48"><path d="M11 17h26v20H11V17Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M8 17a3 3 0 0 1 3-3h26a3 3 0 0 1 3 3v20a3 3 0 0 1-3 3H11a3 3 0 0 1-3-3V17Zm3 0v20h26V17H11Z" fill="var(--cros-sys-illo-color1-1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M13.5 21a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-1ZM18 33h12v2H18v-2Zm2.5-13a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1v-1a1 1 0 0 0-1-1h-1Zm5 1a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-1Zm7-1a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1v-1a1 1 0 0 0-1-1h-1Zm-7 8a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-1Zm7-1a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1v-1a1 1 0 0 0-1-1h-1Zm-13 1a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-1Zm-5-1a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1v-1a1 1 0 0 0-1-1h-1Z" fill="var(--cros-sys-illo-color1-1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M16 8a1 1 0 0 0-1 1v11.868h18V9a1 1 0 0 0-1-1H16Zm7.418 18.887L15 20.867h18l-8.418 6.019a1 1 0 0 1-1.164 0Z" fill="var(--cros-sys-illo-color1)"/><path d="m25 12 3 3-3 3" stroke="var(--cros-sys-illo-base)" stroke-width="2" stroke-linecap="square" stroke-linejoin="round"/><path d="M27 15h-6a1 1 0 0 0-1 1v3" stroke="var(--cros-sys-illo-base)" stroke-width="2" stroke-linejoin="round"/></g>

      <!-- Magic boost review terms banner icon -->
      <g id="magic-boost-banner-icon" viewBox="0 0 48 48">
        <path d="M37.9837 37.8347C37.9819 39.5828 36.5633 40.9985 34.8151 40.9968L11.5631 40.9729C10.6891 40.972 9.98121 40.2627 9.98211 39.3886L10.0137 8.55395C10.0146 7.67987 10.724 6.97202 11.598 6.97291L36.4327 6.99839C37.3068 6.99929 38.0146 7.7086 38.0137 8.58268L37.9837 37.8347Z" fill="var(--cros-sys-muted_variant)"></path>
        <path d="M7.70841 33.8329L32.4485 33.8573C30.967 36.4572 32.1091 40.6926 34.3314 40.9812L34.8151 40.9817C34.6489 41.0023 34.4875 41.0015 34.3314 40.9812L9.67945 40.9569C7.30585 40.5733 6.12291 36.6155 7.70841 33.8329Z" fill="var(--cros-sys-illo-color1-1)"></path>
        <path d="M14 17H34" stroke="var(--cros-sys-illo-color1-1)" stroke-width="2"></path>
        <path d="M14 22H34" stroke="var(--cros-sys-illo-color1-1)" stroke-width="2"></path>
        <path d="M14 27H30" stroke="var(--cros-sys-illo-color1-1)" stroke-width="2"></path>
        <path d="M37.5 19C41.6421 19 45 15.6421 45 11.5C45 7.35786 41.6421 4 37.5 4C33.3579 4 30 7.35786 30 11.5C30 15.6421 33.3579 19 37.5 19Z" fill="var(--cros-sys-illo-color1)"></path>
        <path d="M34 12.1401L35.9074 13.9129C36.0324 14.029 36.2361 14.029 36.3611 13.9129L41 9.625" stroke="var(--cros-sys-illo-base)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
        <rect x="14" y="10" width="3" height="3" rx="1" fill="var(--cros-sys-illo-color1-1)"></rect>
        <rect x="19" y="10" width="3" height="3" rx="1" fill="var(--cros-sys-illo-color1-1)"></rect>
      </g>

      <!-- Input customization banner icons -->
      <g id="mouse-banner" viewBox="0 0 48 48">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M24.5001 43.958C21.1667 43.958 18.3334 42.8052 16.0001 40.4997C13.6945 38.1663 12.5417 35.333 12.5417 31.9997V24.208H36.4584V31.9997C36.4584 35.333 35.2917 38.1663 32.9584 40.4997C30.6529 42.8052 27.8334 43.958 24.5001 43.958Z" fill="var(--cros-sys-illo-color1-2)"></path>
        <path d="M15.5417 13.4997C13.5417 15.7497 12.5417 18.4025 12.5417 21.458H23.1251V9.58301C20.0973 9.91634 17.5695 11.2219 15.5417 13.4997Z" fill="var(--cros-sys-illo-color1-1)"></path>
        <path d="M25.875 9.58301V21.458H36.4583C36.4583 18.4025 35.4444 15.7497 33.4167 13.4997C31.4167 11.2219 28.9028 9.91634 25.875 9.58301Z" fill="var(--cros-sys-illo-color1-1)"></path>
        <rect x="21" y="17" width="7" height="13" rx="3.5" fill="var(--cros-sys-illo-color1)" stroke="white" stroke-width="2"></rect>
        <path d="M32.2153 5.08339L33.3062 7.44452L29.7645 9.08091L28.6736 6.71978L32.2153 5.08339Z" fill="var(--cros-sys-illo-color1)"></path>
        <path d="M20.061 7.06444L19.1628 9.50542L15.504 8.15918L16.4023 5.71821L20.061 7.06444Z" fill="var(--cros-sys-illo-color1)"></path>
        <path d="M23.4954 4.81448L21.1342 5.90541L19.4979 2.36372L21.8591 1.27279L23.4954 4.81448Z" fill="var(--cros-sys-illo-color1)"></path>
        <path d="M26.4203 1.09042L28.8613 1.98859L27.5139 5.65006L25.0729 4.75189L26.4203 1.09042Z" fill="var(--cros-sys-illo-color1)"></path>
      </g>
      <g id="pen-buttons-banner" viewBox="0 0 48 48">
        <path
          d="M5.79167 37.6667C5.01389 37.6667 4.34722 37.4028 3.79167 36.875C3.26389 36.3194 3 35.6528 3 34.875V13.7917C3 13.0139 3.26389 12.3611 3.79167 11.8333C4.34722 11.2778 5.01389 11 5.79167 11H36.875C37.6528 11 38.3056 11.2778 38.8333 11.8333C39.3889 12.3611 39.6667 13.0139 39.6667 13.7917V34.875C39.6667 35.6528 39.3889 36.3194 38.8333 36.875C38.3056 37.4028 37.6528 37.6667 36.875 37.6667H5.79167ZM9.95833 33.875C9.95833 34.4273 10.406 34.875 10.9583 34.875H31.7083C32.2606 34.875 32.7083 34.4273 32.7083 33.875V14.7917C32.7083 14.2394 32.2606 13.7917 31.7083 13.7917H10.9583C10.406 13.7917 9.95833 14.2394 9.95833 14.7917V33.875Z"
          fill="var(--cros-sys-illo-color1-1)"></path>
        <rect x="9.5" y="13.5" width="27" height="22" rx="1.5" fill="var(--cros-sys-illo-base)"
          stroke="var(--cros-sys-illo-color1-2)"></rect>
        <circle cx="6" cy="24" r="1.5" stroke="var(--cros-sys-illo-base)"></circle>
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M5.5 28C5.22386 28 5 28.2239 5 28.5C5 28.7761 5.22386 29 5.5 29H6.5C6.77614 29 7 28.7761 7 28.5C7 28.2239 6.77614 28 6.5 28H5.5ZM5.5 31C5.22386 31 5 31.2239 5 31.5C5 31.7761 5.22386 32 5.5 32H6.5C6.77614 32 7 31.7761 7 31.5C7 31.2239 6.77614 31 6.5 31H5.5Z"
          fill="var(--cros-sys-illo-base)"></path>
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M5.5 16C5.22386 16 5 16.2239 5 16.5C5 16.7761 5.22386 17 5.5 17H6.5C6.77614 17 7 16.7761 7 16.5C7 16.2239 6.77614 16 6.5 16H5.5ZM5.5 19C5.22386 19 5 19.2239 5 19.5C5 19.7761 5.22386 20 5.5 20H6.5C6.77614 20 7 19.7761 7 19.5C7 19.2239 6.77614 19 6.5 19H5.5Z"
          fill="var(--cros-sys-illo-base)"></path>
        <rect x="46.8774" y="11" width="2.5" height="4" transform="rotate(75.7796 46.8774 11)"
          fill="var(--cros-sys-illo-color1)"></rect>
        <rect x="42.2493" y="6" width="2.5" height="4" transform="rotate(34.2165 42.2493 6)"
          fill="var(--cros-sys-illo-color1)"></rect>
        <rect x="35.839" y="5.5957" width="2.5" height="4" transform="rotate(-15.5352 35.839 5.5957)"
          fill="var(--cros-sys-illo-color1)"></rect>
        <path
          d="M25.2045 30.8705L21.8926 27.5586L21.732 29.9668C21.6918 30.5705 22.1927 31.0713 22.7963 31.0311L25.2045 30.8705Z"
          fill="var(--cros-sys-illo-color1-1)"></path>
        <rect x="36.0863" y="13.3652" width="4.68378" height="20.0733" transform="rotate(45 36.0863 13.3652)"
          fill="var(--cros-sys-illo-color1)"></rect>
        <path
          d="M36.7962 12.656C37.7107 11.7414 39.1935 11.7414 40.1081 12.656V12.656C41.0227 13.5705 41.0227 15.0533 40.1081 15.9679L39.8715 16.2045L36.5596 12.8925L36.7962 12.656Z"
          fill="var(--cros-sys-illo-color1)"></path>
      </g>
      <g id="tablet-buttons-banner" viewBox="0 0 48 48">
        <g clip-path="url(#clip0_2096_5820)">
          <path
            d="M8.79167 37.6667C8.01389 37.6667 7.34722 37.4028 6.79167 36.875C6.26389 36.3194 6 35.6528 6 34.875V13.7917C6 13.0139 6.26389 12.3611 6.79167 11.8333C7.34722 11.2778 8.01389 11 8.79167 11H39.875C40.6528 11 41.3056 11.2778 41.8333 11.8333C42.3889 12.3611 42.6667 13.0139 42.6667 13.7917V34.875C42.6667 35.6528 42.3889 36.3194 41.8333 36.875C41.3056 37.4028 40.6528 37.6667 39.875 37.6667H8.79167ZM12.9583 33.875C12.9583 34.4273 13.406 34.875 13.9583 34.875H34.7083C35.2606 34.875 35.7083 34.4273 35.7083 33.875V14.7917C35.7083 14.2394 35.2606 13.7917 34.7083 13.7917H13.9583C13.406 13.7917 12.9583 14.2394 12.9583 14.7917V33.875Z"
            fill="var(--cros-sys-illo-color1)"></path>
          <rect x="12.5" y="13.5" width="27" height="22" rx="1.5" fill="var(--cros-sys-illo-base)"
            stroke="var(--cros-sys-illo-color1-1)"></rect>
          <path fill-rule="evenodd" clip-rule="evenodd"
            d="M8 16.5C8 16.2239 8.22386 16 8.5 16H9.5C9.77614 16 10 16.2239 10 16.5C10 16.7761 9.77614 17 9.5 17H8.5C8.22386 17 8 16.7761 8 16.5ZM8 19.5C8 19.2239 8.22386 19 8.5 19H9.5C9.77614 19 10 19.2239 10 19.5C10 19.7761 9.77614 20 9.5 20H8.5C8.22386 20 8 19.7761 8 19.5ZM9 25C9.55228 25 10 24.5523 10 24C10 23.4477 9.55228 23 9 23C8.44772 23 8 23.4477 8 24C8 24.5523 8.44772 25 9 25ZM9 26C10.1046 26 11 25.1046 11 24C11 22.8954 10.1046 22 9 22C7.89543 22 7 22.8954 7 24C7 25.1046 7.89543 26 9 26ZM8.5 28C8.22386 28 8 28.2239 8 28.5C8 28.7761 8.22386 29 8.5 29H9.5C9.77614 29 10 28.7761 10 28.5C10 28.2239 9.77614 28 9.5 28H8.5ZM8.5 31C8.22386 31 8 31.2239 8 31.5C8 31.7761 8.22386 32 8.5 32H9.5C9.77614 32 10 31.7761 10 31.5C10 31.2239 9.77614 31 9.5 31H8.5Z"
            fill="var(--cros-sys-illo-color1-1)"></path>
          <rect x="19.4703" y="3.67383" width="2.5" height="4" transform="rotate(33.4841 19.4703 3.67383)"
            fill="var(--cros-sys-illo-color1)"></rect>
          <rect x="11.6138" y="2.86133" width="2.5" height="4" transform="rotate(-8.079 11.6138 2.86133)"
            fill="var(--cros-sys-illo-color1)"></rect>
          <rect x="0.358521" y="10.8125" width="2.5" height="4" transform="rotate(-56.5159 0.358521 10.8125)"
            fill="var(--cros-sys-illo-color1)"></rect>
          <path
            d="M32.7829 30.2604L29.7393 27.2168L29.5979 29.3375C29.5576 29.9412 30.0585 30.4421 30.6622 30.4018L32.7829 30.2604Z"
            fill="var(--cros-sys-illo-color1)"></path>
          <rect x="42.7832" y="14.1738" width="4.30434" height="18.4472" transform="rotate(45 42.7832 14.1738)"
            fill="var(--cros-sys-illo-color1-1)"></rect>
          <path
            d="M43.4355 13.5218C44.2759 12.6813 45.6386 12.6813 46.4791 13.5218C47.3196 14.3623 47.3196 15.725 46.4791 16.5654L46.2617 16.7828L43.2181 13.7392L43.4355 13.5218Z"
            fill="var(--cros-sys-illo-color1-1)"></path>
          <rect x="5.06213" y="5.54492" width="2.5" height="4" transform="rotate(-32.2748 5.06213 5.54492)"
            fill="var(--cros-sys-illo-color1)"></rect>
        </g>
        <defs>
          <clipPath id="clip0_2096_5820">
            <rect width="48" height="48" fill="var(--cros-sys-illo-base)"></rect>
          </clipPath>
        </defs>
      </g>

      <!-- Languages section -->
      <g id="language" viewBox="0 0 20 20"><path fill-rule="evenodd" d="m10.167 18.146 3.625-9.667h1.75l3.625 9.667H17.5l-.875-2.48h-3.896l-.896 2.48h-1.666Zm3.062-3.875h2.896l-1.417-4.021h-.083l-1.396 4.02Zm-9.833 1.333-1.063-1.083 4.084-4.042a18.19 18.19 0 0 1-1.438-1.666 11.185 11.185 0 0 1-1.125-1.896h1.73c.263.458.555.889.874 1.291.334.39.667.771 1 1.146A18.405 18.405 0 0 0 8.938 7.5a8.8 8.8 0 0 0 1.104-2.083H.833V3.875h5.854v-2.02H8.23v2.02h5.854v1.542h-2.416a10.189 10.189 0 0 1-1.313 2.708A18.938 18.938 0 0 1 8.5 10.479l1.938 1.917-.605 1.583-2.375-2.396-4.062 4.021Z"/></g>

      <!-- Offline -->
      <g id="offline"><path d="M11.91 6.244a.833.833 0 111.18 1.179l-3.334 3.333a.833.833 0 01-1.179 0L6.911 9.089a.833.833 0 011.178-1.178l1.078 1.077 2.744-2.744zM6.75 12a.75.75 0 000 1.5h6.5a.75.75 0 000-1.5h-6.5z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-2 0a6 6 0 11-12 0 6 6 0 0112 0z"></path></g>

      <!-- MultiDevice Settings UI -->
      <g id="connected-devices-android-phone" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M8.5 16.417h3v-1h-3v1Zm-2.917 2.729a1.67 1.67 0 0 1-1.229-.5 1.67 1.67 0 0 1-.5-1.23V2.584c0-.486.167-.896.5-1.229a1.67 1.67 0 0 1 1.23-.5h8.833c.486 0 .896.167 1.229.5.333.333.5.743.5 1.23v14.833c0 .486-.167.895-.5 1.229a1.67 1.67 0 0 1-1.23.5H5.584Zm0-4.73v3h8.834v-3H5.583Zm0-1.5h8.834V5.084H5.583v7.834Zm0-9.333h8.834v-1H5.583v1Zm0 10.834v3-3Zm0-10.834v-1 1Z"></path>
      </g>
      <g id="multidevice-wifi-sync" viewBox="0 0 24 24" transform="translate(1.000000, 3.000000)" fill-rule="nonzero">
        <path d="M17,13 C17,13.5522847 16.5522847,14 16,14 L13,14 C12.4477153,14 12,13.5522847 12,13 L12,7 C12,6.44771525 12.4477153,6 13,6 L16,6 C16.5522847,6 17,6.44771525 17,7 L17,13 Z M13,12.5 L13,13 L16,13 L16,12.5 L13,12.5 Z M16,7 L13,7 L13,7.5 L16,7.5 L16,7 Z M13,11.5 L16,11.5 L16,8.5 L13,8.5 L13,11.5 Z"></path>
        <path d="M17.1681,2.62915 C17.5337,2.88721 17.6103,3.40882 17.3327,3.76542 L16.594,4.71403 C16.0864,4.57451 15.5519,4.5 14.9999983,4.5 C11.6863,4.5 8.99999832,7.1863 8.99999832,10.5 C8.99999832,11.5774 9.284,12.5886 9.7812,13.4626 L9.5901,13.708 C9.2867,14.0975 8.71102,14.0975 8.40763,13.7072 L0.66733,3.76542 C0.38972,3.40882 0.46633,2.88721 0.83192,2.62915 C2.09858,1.7353 5.03466,0 8.99999832,0 C12.9661,0 15.9014,1.7353 17.1681,2.62915 Z" ></path>
      </g>
      <g id="multidevice-smart-lock" viewBox="0 0 24 24"><path d="M18,9 L17,9 L17,7 C17,4.24 14.76,2 12,2 C9.24,2 7,4.24 7,7 L7,9 L6,9 C4.9,9 4,9.9 4,11 L4,21 C4,22.1 4.9,23 6,23 L18,23 C19.1,23 20,22.1 20,21 L20,11 C20,9.9 19.1,9 18,9 Z M9,7 C9,5.34 10.34,4 12,4 C13.66,4 15,5.34 15,7 L15,9 L9,9 L9,7 Z M18,21 L6,21 L6,11 L18,11 L18,21 Z M12,18 C13.1,18 14,17.1 14,16 C14,14.9 13.1,14 12,14 C10.9,14 10,14.9 10,16 C10,17.1 10.9,18 12,18 Z"></path></g>
      <g id="nearby-share" viewBox="0 0 24 24">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M2.71638 8.86876C2.24237 9.31907 2.23052 10.0656 2.69268 10.5396L3.88956 11.7839L5.53674 10.0775L4.38727 8.89246C3.93696 8.41845 3.19039 8.4066 2.71638 8.86876ZM16.2612 15.7533L17.2566 14.7342L18.9157 13.0396L21.345 10.5511C21.5701 10.3141 21.6768 10.0178 21.6768 9.72155C21.6768 9.41344 21.5583 9.10534 21.3213 8.86833C20.8591 8.41802 20.1007 8.41802 19.6504 8.89203L17.2566 11.345L15.5976 13.0396L14.5666 14.0943C13.8911 14.7935 12.9905 15.1727 12.0188 15.1727C11.1537 15.1727 10.3479 14.8646 9.70802 14.2957L8.06083 15.9903C9.15105 16.9857 10.5375 17.5427 12.0188 17.5427C13.6304 17.5427 15.1354 16.9146 16.2612 15.7533Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M12.0188 8.53696C10.4072 8.53696 8.90219 9.16502 7.77641 10.3263L4.06729 14.1303L2.69266 15.5404C2.24235 16.0026 2.24235 16.761 2.71636 17.2113C3.17852 17.6616 3.93694 17.6616 4.38725 17.1876L6.78099 14.7346L8.44003 13.04L9.471 11.9854C10.1465 11.2862 11.0471 10.907 12.0188 10.907C12.8839 10.907 13.6778 11.2151 14.3296 11.7839L15.9768 10.0893C14.8866 9.09392 13.5001 8.53696 12.0188 8.53696ZM21.6768 16.3699C21.6768 16.0737 21.5701 15.7656 21.345 15.5404L20.1599 14.3199L18.5127 16.0263L19.6504 17.1995C20.1007 17.6735 20.8472 17.6853 21.3213 17.2232C21.5583 16.9862 21.6768 16.6781 21.6768 16.3699Z"></path>
      </g>
      <g id="failure-alert" width="26" height="26" viewBox="0 0 26 26">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M11.4002 13H14.6002V6.59995H11.4002V13ZM13.0002 0.199951C5.9346 0.199951 0.200195 5.93435 0.200195 13C0.200195 20.0655 5.9346 25.7999 13.0002 25.7999C20.0658 25.7999 25.8002 20.0655 25.8002 13C25.8002 5.93435 20.0658 0.199951 13.0002 0.199951ZM13.0002 22.5999C7.7082 22.5999 3.4002 18.292 3.4002 13C3.4002 7.70795 7.7082 3.39995 13.0002 3.39995C18.2922 3.39995 22.6002 7.70795 22.6002 13C22.6002 18.292 18.2922 22.5999 13.0002 22.5999ZM11.4002 19.4H14.6002V16.2H11.4002V19.4Z"></path>
      </g>
      <g id="multidevice-recent-photos" width="20" height="20" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M7.1249 1C6.02033 1 5.1249 1.89543 5.1249 3V13C5.1249 14.1046 6.02033 15 7.1249 15H17.1249C18.2295 15 19.1249 14.1046 19.1249 13V3C19.1249 1.89543 18.2295 1 17.1249 1H7.1249ZM17.1249 3H7.1249V13H17.1249V3ZM2.60539 5.52163L4.12492 5.30807V7.32773L2.88373 7.50217L4.27546 17.4048L14.1781 16.0131L14.1763 15.9999H16.1783C16.1861 16.9876 15.4612 17.8524 14.4565 17.9937L4.55381 19.3854C3.45999 19.5391 2.44865 18.777 2.29493 17.6832L0.903197 7.78051C0.74947 6.68669 1.51157 5.67536 2.60539 5.52163ZM8.13422 10.7979L11.1342 4.79785L13.1342 8.79785L14.1342 7.29785L16.1342 10.7979H8.13422Z"></path>
      </g>
      <g id="multidevice-notifications" width="20" height="20" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M18.1235 14V16H2.12347V14H4.12347V9.5C4.12347 6.42 5.76347 3.86 8.62347 3.18V2.5C8.62347 1.67 9.29347 1 10.1235 1C10.9535 1 11.6235 1.67 11.6235 2.5V3.18C14.4935 3.86 16.1235 6.43 16.1235 9.5V14H18.1235ZM14.1235 9.5C14.1235 7.02 12.6135 5 10.1235 5C7.63347 5 6.12347 7.02 6.12347 9.5V14H14.1235V9.5ZM10.1235 19C11.2235 19 12.1235 18.1 12.1235 17H8.12347C8.12347 18.1 9.02347 19 10.1235 19Z"></path>
      </g>
      <g id="multidevice-app-streaming" width="20" height="20" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M13.1235 1.01L5.12347 1C4.02347 1 3.12347 1.9 3.12347 3V17C3.12347 18.1 4.02347 19 5.12347 19H13.1235C14.2235 19 15.1235 18.1 15.1235 17V12.9765H13.1235V14H5.12347V6H13.1235V6.00338H15.1235V3C15.1235 1.9 14.2235 1.01 13.1235 1.01ZM13.1235 17H5.12347V16H13.1235V17ZM5.12347 4V3H13.1235V4H5.12347Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M10.6984 6.40161V13.3136L12.3596 12.3628H17.8731V6.40161H10.6984ZM16.3731 7.90161H12.1984V10.8628H16.3731V7.90161Z"></path>
      </g>
      <g id="multidevice-error" width="20" height="20" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M9 10H11V6H9V10ZM10 2C5.584 2 2 5.584 2 10C2 14.416 5.584 18 10 18C14.416 18 18 14.416 18 10C18 5.584 14.416 2 10 2ZM10 16C6.6925 16 4 13.3075 4 10C4 6.6925 6.6925 4 10 4C13.3075 4 16 6.6925 16 10C16 13.3075 13.3075 16 10 16ZM9 14H11V12H9V14Z"></path>
      </g>
      <g id="multidevice-caption-error" width="16" height="16" viewBox="0 0 16 16">
        <path d="M6.99888 4.60514H8.85603V7.91291H6.99888V4.60514Z"></path>
        <path d="M6.99888 9.18871H8.85603V11.0459H6.99888V9.18871Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM12.6429 8C12.6429 10.5642 10.5642 12.6429 8 12.6429C5.43582 12.6429 3.35714 10.5642 3.35714 8C3.35714 5.43582 5.43582 3.35714 8 3.35714C10.5642 3.35714 12.6429 5.43582 12.6429 8Z"></path>
      </g>

      <!-- Material icon from http://icons/ -->
      <g id="play-prism" viewBox="0 0 24 24"><path d="M20.18 10.88l-3.06-1.74L14.26 12l2.86 2.86 3.06-1.74c.55-.31.82-.71.82-1.12 0-.41-.27-.81-.82-1.12zM4.71 2.45l8.42 8.42 2.55-2.55-10.7-6.06c-.07-.04-.14-.07-.21-.1-.17-.07-.3.05-.15.21.03.02.06.05.09.08zm0 19.1l-.08.08c-.15.15-.02.28.15.21.07-.03.14-.06.21-.1l10.69-6.06-2.55-2.55s-7.2 7.21-8.42 8.42zM12 12L3.38 3.38c-.19-.19-.38-.07-.38.19v16.86c0 .26.19.38.38.19L12 12z"></path></g>

      <!-- Plugin VM icon for Settings drawer -->
      <g id="plugin-vm" viewBox="0 0 24 24"><path transform="scale(1.2)" d="M7 12v4H4V4a1 1 0 0 1 1-1h8a3 3 0 0 1 3 3v3a3 3 0 0 1-3 3H7zm0-6v3h5a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1H7z"></path></g>

      <!-- Personalization section -->
      <g id="paint-brush"><path d="M4.5 11C3 11 2 12 2 13.3c0 1-1 1.6-1.6 1.6.7 1 2 1.5 3.3 1.5 1.7 0 3.2-1.4 3.2-3 0-1.4-1-2.4-2.4-2.4zM12.7 1a2 2 0 0 1 2.8 0L17 2.4c.8.8.8 2 0 2.8l-6.3 6.4a2 2 0 0 1-2.9 0l-1.4-1.4a2 2 0 0 1 0-2.8L12.7 1zM14 2.4L7.7 8.8l1.5 1.4 6.3-6.4-1.4-1.4z"></path></g>
      <g id="personalization-menu" viewBox="0 0 20 20"><path d="M5.051.808.81 5.05 5.05 9.293l1.414-1.414L3.637 5.05l1.414-1.414L6.465 5.05l-.707.707.707.707.708-.707.707.707L9.294 5.05 5.05.808ZM14.95 10.707l-1.413 1.414 1.414 1.415-.707.707.707.707.707-.707.707.707-1.414 1.414-2.829-2.829-1.414 1.415 4.243 4.242 4.242-4.242-4.242-4.243Z"/><path fill-rule="evenodd" clip-rule="evenodd" d="m17.411 3.935-1.35-1.35c-.78-.78-2.05-.78-2.83 0l-2.83 2.82-8.4 8.41v4.18h4.18l11.23-11.23c.79-.78.79-2.05 0-2.83Zm-13.41 12.06v-1.36l7.82-7.82 1.41 1.41-7.82 7.83-1.41-.06Z"/></g>
      <g id="personalization" viewBox="0 0 18 18">
        <path fill-rule="evenodd" d="M9 17.167a8.205 8.205 0 0 1-3.187-.625 8.59 8.59 0 0 1-2.605-1.75 8.589 8.589 0 0 1-1.75-2.604A8.204 8.204 0 0 1 .833 9c0-1.139.216-2.201.646-3.187A8.152 8.152 0 0 1 3.25 3.229a8.233 8.233 0 0 1 2.667-1.75A8.175 8.175 0 0 1 9.146.833c1.11 0 2.153.195 3.125.584a7.89 7.89 0 0 1 2.541 1.562 7.235 7.235 0 0 1 1.73 2.354 6.69 6.69 0 0 1 .625 2.875c0 1.348-.473 2.514-1.417 3.5-.93.973-2.083 1.459-3.458 1.459H11a.415.415 0 0 0-.27.104.28.28 0 0 0-.126.25c0 .194.09.347.271.458.194.097.292.438.292 1.021 0 .528-.209 1.02-.625 1.48-.403.457-.917.687-1.542.687ZM4.563 9.75c.347 0 .638-.118.875-.354.25-.25.375-.549.375-.896s-.125-.639-.375-.875a1.156 1.156 0 0 0-.875-.375c-.348 0-.646.125-.896.375a1.189 1.189 0 0 0-.354.875c0 .347.118.646.354.896.25.236.548.354.896.354ZM7.02 6.792c.347 0 .639-.118.875-.354.25-.25.375-.55.375-.896 0-.348-.125-.64-.375-.875a1.156 1.156 0 0 0-.875-.375c-.347 0-.646.125-.896.375a1.189 1.189 0 0 0-.354.875c0 .347.118.646.354.896.25.236.549.354.896.354Zm3.958 0c.347 0 .64-.118.875-.354.25-.25.375-.55.375-.896 0-.348-.125-.64-.375-.875a1.156 1.156 0 0 0-.875-.375c-.347 0-.646.125-.896.375a1.189 1.189 0 0 0-.354.875c0 .347.118.646.354.896.25.236.549.354.896.354Zm2.438 2.958c.347 0 .639-.118.875-.354.25-.25.375-.549.375-.896s-.125-.639-.375-.875a1.156 1.156 0 0 0-.875-.375c-.348 0-.646.125-.896.375a1.189 1.189 0 0 0-.354.875c0 .347.118.646.354.896.25.236.548.354.896.354Zm-4.438 5.688c.14 0 .25-.056.334-.167a.532.532 0 0 0 .124-.313c0-.222-.104-.41-.312-.562-.208-.153-.312-.486-.312-1 0-.542.187-1 .562-1.375a1.905 1.905 0 0 1 1.396-.584h1.52c.917 0 1.667-.312 2.25-.937a3.214 3.214 0 0 0 .896-2.27c0-1.598-.61-2.938-1.833-4.022-1.222-1.097-2.708-1.646-4.458-1.646-1.834 0-3.39.626-4.667 1.876C3.201 5.688 2.563 7.208 2.563 9c0 1.792.618 3.313 1.854 4.563 1.25 1.25 2.77 1.874 4.562 1.874Z"></path>
      </g>

      <!-- Printing section -->
      <g id="printer-status-illo-green">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.9999 3H4.99994V7H4C2.89543 7 2 7.89543 2 9V14H4.99994V17H10.8026C10.4513 16.3926 10.2033 15.7179 10.0829 15H6.99994V12H10.3414C11.165 9.66962 13.3875 8 15.9999 8C16.6542 8 17.284 8.10471 17.8734 8.29829C17.5892 7.53986 16.8577 7 16 7H14.9999V3ZM6.99994 5H12.9999V7H6.99994V5Z" fill="var(--cros-sys-on_primary_container)"></path>
        <circle cx="16" cy="14" r="3" fill="var(--cros-sys-positive)"></circle>
      </g>
      <g id="printer-status-illo-grey">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.9999 3H4.99994V7H4C2.89543 7 2 7.89543 2 9V14H4.99994V17H10.8026C10.4513 16.3926 10.2033 15.7179 10.0829 15H6.99994V12H10.3414C11.165 9.66962 13.3875 8 15.9999 8C16.6542 8 17.284 8.10471 17.8734 8.29829C17.5892 7.53986 16.8577 7 16 7H14.9999V3ZM6.99994 5H12.9999V7H6.99994V5Z" fill="var(--cros-sys-on_primary_container)"></path>
        <circle cx="16" cy="14" r="3" fill="var(--cros-sys-disabled_opaque)"></circle>
      </g>
      <g id="printer-status-illo-red">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.9999 3H4.99994V7H4C2.89543 7 2 7.89543 2 9V14H4.99994V17H10.8026C10.4513 16.3926 10.2033 15.7179 10.0829 15H6.99994V12H10.3414C11.165 9.66962 13.3875 8 15.9999 8C16.6542 8 17.284 8.10471 17.8734 8.29829C17.5892 7.53986 16.8577 7 16 7H14.9999V3ZM6.99994 5H12.9999V7H6.99994V5Z" fill="var(--cros-sys-on_primary_container)"></path>
        <circle cx="16" cy="14" r="3" fill="var(--cros-sys-error)"></circle>
      </g>
      <g id="printer-status-illo-orange">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.9999 3H4.99994V7H4C2.89543 7 2 7.89543 2 9V14H4.99994V17H10.8026C10.4513 16.3926 10.2033 15.7179 10.0829 15H6.99994V12H10.3414C11.165 9.66962 13.3875 8 15.9999 8C16.6542 8 17.284 8.10471 17.8734 8.29829C17.5892 7.53986 16.8577 7 16 7H14.9999V3ZM6.99994 5H12.9999V7H6.99994V5Z" fill="var(--cros-sys-on_primary_container)"></path>
        <circle cx="16" cy="14" r="3" fill="var(--cros-sys-warning)"></circle>
      </g>
      <g id="printer-plain">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M5 3H15V7H16C17.1046 7 18 7.89543 18 9V14H15V17H5V14H2V9C2 7.89543 2.89543 7 4 7H5V3ZM13 5H7V7H13V5ZM16 10C16 10.5523 15.5523 11 15 11C14.4477 11 14 10.5523 14 10C14 9.44772 14.4477 9 15 9C15.5523 9 16 9.44772 16 10ZM7 12H13V15H7V12Z" fill="var(--cros-sys-on_primary_container)"></path>
      </g>
      <g id="printer-setup" viewBox="0 0 48 48">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M9 19C7.89543 19 7 19.8954 7 21V34C7 35.1046 7.89543 36 9 36H39C40.1046 36 41 35.1046 41 34V21C41 19.8954 40.1046 19 39 19H9ZM35 29H13V33H35V29Z" fill="var(--cros-sys-illo-color1-1)"></path>
        <circle cx="11.5" cy="23.5" r="1.5" fill="var(--cros-sys-illo-color1)"></circle>
        <rect x="14" y="30" width="20" height="12" rx="1" fill="var(--cros-sys-illo-color1-2)"></rect>
        <path d="M14 9C14 8.44772 14.4477 8 15 8H33C33.5523 8 34 8.44772 34 9V18H14V9Z" fill="var(--cros-sys-illo-color1-2)"></path>
        <path d="M12 15C12 14.4477 12.4477 14 13 14H35C35.5523 14 36 14.4477 36 15V18H12V15Z" fill="var(--cros-sys-illo-color1-1)"></path>
        <line x1="17" y1="34.25" x2="31" y2="34.25" stroke="var(--cros-sys-illo-color1-1)" stroke-width="1.5"></line>
        <line x1="17" y1="38.25" x2="31" y2="38.25" stroke="var(--cros-sys-illo-color1-1)" stroke-width="1.5"></line>
        <circle cx="35" cy="15" r="9" fill="var(--cros-sys-illo-color1)" stroke="var(--cros-sys-illo-base)" stroke-width="2"></circle>
        <path d="M34.1209 16.7814V16.3209C34.1209 16.014 34.1628 15.7442 34.2465 15.5116C34.3302 15.2698 34.4651 15.0326 34.6512 14.8C34.8465 14.5674 35.0977 14.3163 35.4047 14.0465C35.5721 13.8977 35.7163 13.7581 35.8372 13.6279C35.9581 13.4977 36.0465 13.3628 36.1023 13.2233C36.1674 13.0837 36.2 12.9256 36.2 12.7488C36.2 12.4698 36.093 12.2279 35.8791 12.0233C35.6744 11.8186 35.3907 11.7163 35.0279 11.7163C34.7674 11.7163 34.5395 11.7721 34.3442 11.8837C34.1581 11.9953 34.0047 12.1395 33.8837 12.3163C33.7628 12.4837 33.6698 12.6651 33.6047 12.8605L32 12.1907C32.1023 11.8372 32.2791 11.493 32.5302 11.1581C32.7907 10.8233 33.1256 10.5488 33.5349 10.3349C33.9442 10.1116 34.4279 10 34.986 10C35.5814 10 36.1023 10.1163 36.5488 10.3488C37.0047 10.5814 37.3581 10.8977 37.6093 11.2977C37.8698 11.6977 38 12.1488 38 12.6512C38 13.0047 37.9442 13.3163 37.8326 13.586C37.7302 13.8558 37.586 14.1023 37.4 14.3256C37.214 14.5488 37.0093 14.7674 36.786 14.9814C36.5814 15.1767 36.4186 15.3535 36.2977 15.5116C36.1767 15.6605 36.0884 15.8186 36.0326 15.986C35.986 16.1442 35.9628 16.3349 35.9628 16.5581V16.7814H34.1209ZM35.0279 20.2977C34.693 20.2977 34.4047 20.1814 34.1628 19.9488C33.9302 19.707 33.814 19.4186 33.814 19.0837C33.814 18.7488 33.9302 18.4651 34.1628 18.2326C34.4047 18 34.693 17.8837 35.0279 17.8837C35.3628 17.8837 35.6465 18 35.8791 18.2326C36.1116 18.4651 36.2279 18.7488 36.2279 19.0837C36.2279 19.4186 36.1116 19.707 35.8791 19.9488C35.6465 20.1814 35.3628 20.2977 35.0279 20.2977Z" fill="var(--cros-sys-illo-base)"></path>
      </g>

      <!-- Privacy section -->
      <g id="privacy-controls" viewBox="0 0 15 20">
        <path fill-rule="evenodd" d="M6.896 9.792V1.625a.79.79 0 0 1 .229-.583.8.8 0 0 1 .583-.25c.236 0 .43.083.584.25a.79.79 0 0 1 .229.583v8.167H6.896Zm-3.021 0V2.646a.79.79 0 0 1 .23-.583.765.765 0 0 1 .562-.23.79.79 0 0 1 .583.23c.167.152.25.347.25.583v7.146H3.875ZM7.5 19.167c-1.847 0-3.424-.646-4.73-1.938C1.48 15.938.834 14.361.834 12.5V4.646a.79.79 0 0 1 .23-.583.79.79 0 0 1 .583-.23c.222 0 .41.077.562.23.167.152.25.347.25.583V12.5c0 1.403.486 2.597 1.459 3.583.986.973 2.18 1.459 3.583 1.459s2.59-.486 3.563-1.459c.986-.986 1.479-2.18 1.479-3.583V9.563H12.5a.906.906 0 0 0-.667.27.906.906 0 0 0-.27.667v3.188H8.75c-.458 0-.854.166-1.187.5-.334.319-.5.715-.5 1.187v.5H5.438v-.5c0-.93.319-1.715.958-2.354a3.21 3.21 0 0 1 2.354-.98h1.188V3.647a.79.79 0 0 1 .229-.583.79.79 0 0 1 .583-.23c.222 0 .41.077.563.23.166.152.25.347.25.583v4.479a1.61 1.61 0 0 1 .458-.146c.166-.028.326-.042.479-.042h1.667V12.5c0 1.861-.646 3.438-1.938 4.73-1.291 1.29-2.868 1.937-4.729 1.937Z"></path>
      </g>
      <g id="sync" viewBox="0 0 17 14">
        <path fill-rule="evenodd" d="M1.5 13.104v-1.583h1.396a6.354 6.354 0 0 1-1.48-2A5.912 5.912 0 0 1 .876 7c0-1.444.444-2.715 1.333-3.812a6.102 6.102 0 0 1 3.417-2.125v1.791a4.424 4.424 0 0 0-2.167 1.563c-.57.736-.854 1.597-.854 2.583 0 .653.132 1.25.396 1.792a4.708 4.708 0 0 0 1.02 1.396V9h1.584v4.104H1.5Zm8.875.167c-.68 0-1.257-.23-1.73-.688a2.364 2.364 0 0 1-.687-1.708c0-.667.223-1.23.667-1.687a2.321 2.321 0 0 1 1.646-.709 2.57 2.57 0 0 1 .958-1.083 2.639 2.639 0 0 1 1.48-.438c.708 0 1.319.223 1.833.667.514.43.805.965.875 1.604.514.042.951.257 1.312.646.361.375.542.833.542 1.375 0 .556-.202 1.035-.604 1.438a1.953 1.953 0 0 1-1.438.583h-4.854ZM11.292 6a3.932 3.932 0 0 0-.521-1.208 4.22 4.22 0 0 0-.792-.98V5H8.396V.896H12.5v1.583h-1.396c.5.458.917.986 1.25 1.584A5.96 5.96 0 0 1 13.042 6h-1.75Zm-.917 5.625h4.875a.366.366 0 0 0 .27-.104c.07-.07.105-.16.105-.271a.336.336 0 0 0-.125-.27.414.414 0 0 0-.27-.105h-1.418V9.729c0-.305-.11-.562-.333-.77a1.082 1.082 0 0 0-.791-.334.992.992 0 0 0-.75.333 1.048 1.048 0 0 0-.313.771v.396h-1.25a.733.733 0 0 0-.542.208.707.707 0 0 0-.208.521c0 .222.07.41.208.563.14.139.32.208.542.208Z"></path>
      </g>
      <g id="lock" viewBox="0 0 16 16">
        <path fill-rule="evenodd" d="M7.958 15.167v-1.73h5.48V2.563h-5.48V.833h5.48c.486 0 .895.167 1.229.5.333.334.5.743.5 1.23v10.875c0 .486-.167.895-.5 1.229-.334.333-.743.5-1.23.5H7.959Zm-1.646-3.438-1.229-1.208L6.73 8.875H.833v-1.75H6.73L5.083 5.479l1.23-1.208L10.042 8l-3.73 3.73Z"></path>
      </g>
      <g id="privacy-manage-people" viewBox="0 0 18 15">
        <path fill-rule="evenodd" d="M7 6.917c-.889 0-1.639-.306-2.25-.917a3.104 3.104 0 0 1-.917-2.25c0-.889.306-1.639.917-2.25S6.111.583 7 .583 8.639.89 9.25 1.5s.917 1.361.917 2.25c0 .875-.306 1.625-.917 2.25-.611.611-1.361.917-2.25.917ZM.833 13.25v-2.083c0-.417.098-.785.292-1.104.208-.32.465-.57.77-.75a10.094 10.094 0 0 1 2.46-1.021A9.588 9.588 0 0 1 7 7.917c.153 0 .306.007.458.02.167 0 .334.007.5.021a6.548 6.548 0 0 0-.27.834c-.07.32-.125.61-.167.875l-.5-.021a8.38 8.38 0 0 0-2.188.291 7.683 7.683 0 0 0-2.041.855.338.338 0 0 0-.167.146.477.477 0 0 0-.062.25v.333h5.166c.07.291.174.59.313.896.152.305.312.583.479.833H.833Zm11.563.917-.271-1.188a5.91 5.91 0 0 1-.52-.229 2.764 2.764 0 0 1-.46-.333l-1.166.375-.729-1.25.875-.854a1.9 1.9 0 0 1-.083-.563c.014-.208.041-.403.083-.583l-.875-.834.73-1.27 1.145.333c.139-.125.292-.236.458-.333.18-.112.361-.188.542-.23l.292-1.187h1.458l.27 1.187c.181.056.355.132.522.23.18.097.34.208.479.333l1.146-.313.729 1.25-.854.813c.041.194.055.396.041.604 0 .194-.02.382-.062.563l.875.833-.73 1.25-1.166-.354a2.768 2.768 0 0 1-.458.333 2.48 2.48 0 0 1-.521.23l-.292 1.187h-1.458Zm.75-2.604c.403 0 .743-.146 1.02-.438.292-.292.438-.639.438-1.042 0-.402-.146-.743-.437-1.02a1.423 1.423 0 0 0-1.042-.438c-.389 0-.73.146-1.02.438a1.422 1.422 0 0 0-.438 1.041c0 .39.146.73.437 1.021.292.292.64.438 1.042.438ZM7 5.187c.403 0 .743-.138 1.02-.416a1.43 1.43 0 0 0 .418-1.021c0-.403-.146-.743-.438-1.02a1.364 1.364 0 0 0-1-.417 1.35 1.35 0 0 0-1.02.437 1.364 1.364 0 0 0-.418 1c0 .403.14.743.417 1.02A1.43 1.43 0 0 0 7 5.188Z"></path>
      </g>
      <g id="privacy-smart-privacy" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="m3.563 8.208 2.645-2.645H3.563v2.645Zm0 5 7.645-7.645H8.667l-5.104 5.104v2.541Zm1.229 1.23h11.646V5.563h-2.771l-8.875 8.875Zm-1.23 1.729c-.486 0-.895-.167-1.229-.5a1.671 1.671 0 0 1-.5-1.23V5.563c0-.487.167-.896.5-1.23a1.67 1.67 0 0 1 1.23-.5h12.875c.486 0 .895.167 1.229.5.333.334.5.743.5 1.23v8.875c0 .486-.167.895-.5 1.229-.334.333-.743.5-1.23.5H3.563Z"></path>
      </g>
      <g id="content-recommend" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M8 13.98h3.375a.948.948 0 0 0 .52-.147.935.935 0 0 0 .376-.396l1.625-3.229c.028-.07.048-.139.062-.208A.786.786 0 0 0 14 9.75V9.5a.964.964 0 0 0-.292-.708A.964.964 0 0 0 13 8.5h-2.5l.417-2.042a.832.832 0 0 0-.021-.416.886.886 0 0 0-.23-.375L10 5 7.208 8.73c-.07.096-.125.194-.166.29A1.133 1.133 0 0 0 7 9.334v3.646c0 .278.097.514.292.709.194.194.43.291.708.291Zm2 4.187a8.205 8.205 0 0 1-3.187-.625 8.59 8.59 0 0 1-2.605-1.75 8.589 8.589 0 0 1-1.75-2.604A8.204 8.204 0 0 1 1.833 10c0-1.139.209-2.201.625-3.187a8.327 8.327 0 0 1 1.75-2.584 8.112 8.112 0 0 1 2.605-1.75c1-.43 2.062-.646 3.187-.646 1.139 0 2.201.216 3.188.646a7.88 7.88 0 0 1 2.583 1.75 7.82 7.82 0 0 1 1.75 2.604c.43.986.646 2.042.646 3.167a7.974 7.974 0 0 1-.646 3.188c-.417.986-1 1.854-1.75 2.604a8.262 8.262 0 0 1-2.604 1.75 8.053 8.053 0 0 1-3.167.625Zm0-1.73c1.792 0 3.313-.625 4.563-1.875 1.25-1.25 1.874-2.77 1.874-4.562 0-1.792-.625-3.312-1.875-4.562-1.25-1.25-2.77-1.875-4.562-1.875-1.792 0-3.312.624-4.562 1.874C4.188 6.688 3.563 8.209 3.563 10c0 1.792.624 3.313 1.874 4.563 1.25 1.25 2.771 1.874 4.563 1.874Z"></path>
      </g>
      <g id="privacy-verified-access" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M10 12.167 7.833 10 10 7.833 12.167 10 10 12.167Zm-1.792-5.5L6.104 4.563 10 .667l3.896 3.896-2.104 2.104L10 4.875 8.208 6.667Zm-3.645 7.229L.667 10l3.896-3.896 2.104 2.104L4.875 10l1.792 1.792-2.104 2.104Zm10.875 0-2.105-2.104L15.125 10l-1.792-1.792 2.105-2.104L19.333 10l-3.895 3.896ZM10 19.333l-3.896-3.895 2.104-2.105L10 15.125l1.792-1.792 2.104 2.105L10 19.333Z"></path>
      </g>
      <g id="privacy-data-access-protection" viewBox="0 0 14 18">
        <path fill-rule="evenodd" d="M5.75 11.542h2.5l-.458-2.709c.236-.125.416-.305.541-.541.14-.25.209-.514.209-.792 0-.43-.153-.792-.459-1.083A1.437 1.437 0 0 0 7 5.958c-.43 0-.799.153-1.104.459A1.471 1.471 0 0 0 5.458 7.5c0 .278.063.542.188.792.139.236.326.416.562.541l-.458 2.709ZM7 17.167c-1.93-.459-3.528-1.535-4.792-3.23C.958 12.23.333 10.34.333 8.272V3.375L7 .833l6.667 2.542v4.896c0 2.07-.632 3.958-1.896 5.666-1.25 1.695-2.84 2.771-4.771 3.23Zm0-1.792c1.417-.458 2.59-1.347 3.52-2.667a7.502 7.502 0 0 0 1.418-4.437V4.562L7 2.668 2.063 4.563V8.27a7.58 7.58 0 0 0 1.395 4.437c.945 1.32 2.125 2.209 3.542 2.667Z"></path>
      </g>
      <g id="privacy-secure-dns" viewBox="0 0 18 18">
        <path fill-rule="evenodd" d="M9 17.167a8.205 8.205 0 0 1-3.187-.625 8.59 8.59 0 0 1-2.605-1.75 8.589 8.589 0 0 1-1.75-2.604A8.204 8.204 0 0 1 .833 9c0-1.125.223-2.18.667-3.167A8.557 8.557 0 0 1 3.27 3.23a8.112 8.112 0 0 1 2.605-1.75c1-.43 2.042-.646 3.125-.646.306 0 .59.014.854.042.264.028.465.062.604.104V6a30.905 30.905 0 0 0-.708-1.98c-.264-.665-.514-1.13-.75-1.394-.306.292-.562.778-.77 1.458-.195.68-.348 1.327-.46 1.938h2.688v1.5H7.583c-.027.278-.048.535-.062.77V9.73c.014.235.035.485.062.75h2.834c.027-.279.041-.536.041-.772v-.646c0-.194-.007-.423-.02-.687 0-.278-.007-.549-.021-.812h1.52c0 .319.007.61.021.875a11.264 11.264 0 0 1 .001 1.333c0 .236-.008.472-.021.708h3.312A5.462 5.462 0 0 0 15.438 9c0-.236-.021-.48-.063-.73a5.358 5.358 0 0 0-.125-.707h1.792c.041.277.07.527.083.75.028.222.042.45.042.687a7.872 7.872 0 0 1-.646 3.146c-.417.986-1 1.854-1.75 2.604a8.556 8.556 0 0 1-2.604 1.77A7.826 7.826 0 0 1 9 17.168Zm-6.25-6.688h3.313c-.028-.264-.05-.52-.063-.77v-1.48c.014-.236.035-.472.063-.708H2.75A5.466 5.466 0 0 0 2.563 9c0 .236.013.472.041.708.028.236.077.493.146.771Zm4.375 4.688a6.246 6.246 0 0 1-.52-1.396 17.79 17.79 0 0 1-.355-1.792H3.313A6.394 6.394 0 0 0 4.896 14c.667.556 1.41.944 2.229 1.167ZM3.313 6.02H6.25c.097-.653.215-1.25.354-1.792a6.973 6.973 0 0 1 .542-1.396 5.87 5.87 0 0 0-2.25 1.188 6.164 6.164 0 0 0-1.583 2ZM9 15.375c.222-.222.451-.653.688-1.292.236-.652.416-1.354.541-2.104H7.771c.125.75.298 1.452.52 2.104.237.64.473 1.07.709 1.292Zm1.875-.208A5.849 5.849 0 0 0 13.083 14a6.266 6.266 0 0 0 1.604-2.02H11.73c-.083.652-.201 1.25-.354 1.79a7.053 7.053 0 0 1-.5 1.397Zm1.063-9.104V.832h5.229v5.23h-5.23Zm2.687-2.688h1.354V2.021h-1.354v1.354Z"></path>
      </g>

      <!-- System Preferences -->
      <g id="sanitize" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M4.5 17.167c-.458 0-.854-.16-1.188-.48-.319-.333-.479-.729-.479-1.187v-3.583a1.944 1.944 0 0 0 1.313-.584c.36-.375.542-.82.542-1.333 0-.514-.181-.951-.542-1.313a1.906 1.906 0 0 0-1.313-.604V4.5c0-.236.042-.451.125-.646.084-.208.202-.389.354-.542l1.25 1.25v2.271a3.247 3.247 0 0 1 1.355 1.313c.333.57.5 1.187.5 1.854 0 .68-.167 1.306-.5 1.875-.32.57-.771 1.007-1.354 1.313v2.25h2.25a3.382 3.382 0 0 1 1.333-1.355c.57-.333 1.187-.5 1.854-.5s1.285.167 1.854.5c.57.32 1.014.771 1.334 1.354h2.25l1.25 1.25c-.153.153-.334.271-.542.355-.195.083-.41.125-.646.125h-3.583a1.906 1.906 0 0 0-.604-1.313A1.788 1.788 0 0 0 10 15.313c-.514 0-.958.18-1.333.541a1.944 1.944 0 0 0-.584 1.313H4.5Zm12.667-2.292-1.73-1.73V10.5h1.542a.459.459 0 0 0 .334-.146.454.454 0 0 0 .166-.354.454.454 0 0 0-.166-.354.459.459 0 0 0-.334-.146h-1.541V4.562H10.5V3.022a.459.459 0 0 0-.146-.333A.454.454 0 0 0 10 2.52a.454.454 0 0 0-.354.167.459.459 0 0 0-.146.333v1.542H6.854l-1.729-1.73h2.73a2.17 2.17 0 0 1 .666-1.458C8.937.986 9.43.792 10 .792c.57 0 1.056.194 1.458.583.417.389.646.875.688 1.458H15.5c.458 0 .847.167 1.167.5.333.32.5.709.5 1.167v3.354c.583.042 1.07.271 1.458.688.389.402.583.889.583 1.458 0 .57-.194 1.063-.583 1.48a2.17 2.17 0 0 1-1.458.666v2.729Zm-.98 3.458L1.668 3.813 2.77 2.708 17.29 17.23l-1.104 1.104Z"></g>
      <g id="system-preferences" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M8.519 18h2.96c.59 0 1.087-.422 1.167-.953l.216-1.491a8.54 8.54 0 0 0 .623-.36l1.44.563c.552.21 1.168-.008 1.44-.492l1.487-2.514a1.127 1.127 0 0 0-.296-1.453l-1.215-.93c.008-.116.016-.233.016-.358 0-.125-.008-.242-.016-.36l1.215-.929a1.13 1.13 0 0 0 .288-1.468l-1.471-2.483c-.272-.484-.888-.71-1.456-.507l-1.44.562a7.26 7.26 0 0 0-.631-.36l-.216-1.475c-.072-.57-.568-.992-1.16-.992H8.511c-.584 0-1.08.43-1.152.976l-.216 1.492a8.51 8.51 0 0 0-.623.359l-1.448-.57c-.544-.211-1.16.008-1.432.492l-1.48 2.49a1.106 1.106 0 0 0 .297 1.469l1.215.929a5.394 5.394 0 0 0-.016.36c0 .124.008.241.016.358l-1.223.93c-.448.343-.568.952-.288 1.468l1.463 2.475c.272.484.888.71 1.448.508l1.44-.563c.208.133.415.25.631.36l.216 1.475c.072.57.568.992 1.16.992Zm2.542-2H8.947l-.291-1.854-.406-.16a4.35 4.35 0 0 1-1.018-.56l-.345-.255-1.83.698L4 12.124l1.555-1.15-.054-.407A3.476 3.476 0 0 1 5.455 10c0-.19.023-.385.046-.575l.054-.407L4 7.87l1.064-1.738 1.823.69.345-.24a4.91 4.91 0 0 1 1.026-.574l.406-.152L8.947 4h2.114l.283 1.855.398.16c.352.138.697.327 1.019.56l.344.254 1.83-.698L16 7.876l-1.555 1.15.054.407c.023.182.046.37.046.567 0 .19-.021.366-.044.548l-.002.02-.054.407L16 12.123l-1.057 1.745-1.822-.698-.345.247c-.352.248-.69.437-1.026.568l-.406.16L11.061 16ZM11 8a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-1.5 5a.5.5 0 0 1-.5-.5V10a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v2.5a.5.5 0 0 1-.5.5h-1Z"></path></g>
      <g id="storage" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M1.77 16.375v-3.292h16.46v3.292H1.77Zm1.73-.854h1.583v-1.584H3.5v1.584ZM1.77 6.917V3.625h16.46v3.292H1.77Zm1.73-.854h1.583V4.479H3.5v1.583Zm-1.73 5.583V8.354h16.46v3.292H1.77Zm1.73-.854h1.583V9.208H3.5v1.584Z"></path></g>
      <g id="clock" viewBox="0 0 24 24"><path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z"></path></g>
      <g id="24hour" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M9.063 16.462H4v-3.039a1 1 0 0 1 1-1h2.375v-.808H4V10h4.063a1 1 0 0 1 1 1v2.039a1 1 0 0 1-1 1H5.688v.807h3.375v1.616ZM16 16.462h-1.688v-1.616h-2.374a1 1 0 0 1-1-1V10h1.687v3.23h1.688V10H16v6.462Z"></path><path fill="none" stroke="var(--cros-sys-primary)" stroke-width="2" d="M18 10a8 8 0 0 0-16 0"></path></g>
      <g id="set-date-time" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M4.563 7.5h10.875V5.562H4.562V7.5Zm0 0V5.562 7.5Zm0 10.667c-.487 0-.896-.167-1.23-.5a1.671 1.671 0 0 1-.5-1.23V5.563c0-.472.167-.875.5-1.208.348-.347.757-.52 1.23-.52H6v-2h1.625v2h4.75v-2H14v2h1.438c.472 0 .874.173 1.208.52.347.333.52.736.52 1.208v4.355a3.444 3.444 0 0 0-.833-.271 6.34 6.34 0 0 0-.895-.146V9H4.562v7.438h5.209c.083.319.194.625.333.916.153.278.327.549.521.813H4.562Zm10.52.833c-1.11 0-2.055-.389-2.833-1.167-.778-.777-1.167-1.722-1.167-2.833 0-1.111.39-2.056 1.167-2.833A3.927 3.927 0 0 1 15.104 11c1.097 0 2.035.389 2.813 1.167.777.777 1.166 1.722 1.166 2.833 0 1.111-.389 2.056-1.166 2.833-.778.778-1.723 1.167-2.834 1.167Zm1.146-2.104.771-.75-1.375-1.375v-1.813h-1.063v2.271l1.667 1.667Z"></path></g>
      <g id="restore" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 11.583a1.53 1.53 0 0 1-1.125-.458A1.575 1.575 0 0 1 8.417 10c0-.43.152-.799.458-1.104.32-.32.694-.48 1.125-.48.43 0 .799.16 1.104.48.32.305.48.673.48 1.104 0 .444-.16.82-.48 1.125a1.505 1.505 0 0 1-1.104.458Zm0 5.584c-1.986 0-3.68-.695-5.083-2.084C3.514 13.694 2.819 12 2.833 10h1.73c.027 1.514.562 2.799 1.604 3.854C7.222 14.91 8.5 15.438 10 15.438c1.514 0 2.799-.528 3.854-1.584 1.056-1.055 1.584-2.34 1.584-3.854 0-1.514-.528-2.799-1.584-3.854C12.8 5.09 11.514 4.563 10 4.563c-.778 0-1.52.166-2.23.5-.707.319-1.326.77-1.853 1.354H8V8H2.875V2.875h1.583V5.5c.68-.847 1.5-1.5 2.459-1.958A6.882 6.882 0 0 1 10 2.833c.986 0 1.917.188 2.792.563a6.996 6.996 0 0 1 2.27 1.542 7.165 7.165 0 0 1 1.521 2.27c.39.861.584 1.792.584 2.792 0 1-.195 1.938-.584 2.813a7.49 7.49 0 0 1-1.52 2.27 7.165 7.165 0 0 1-2.271 1.521 7.012 7.012 0 0 1-2.792.563Z"></path></g>
      <g id="snap-window-suggestions" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M12.5 17q-.625 0-1.062-.437A1.45 1.45 0 0 1 11 15.5v-11q0-.604.438-1.042A1.41 1.41 0 0 1 12.5 3h3q.604 0 1.042.458Q17 3.896 17 4.5v11q0 .624-.458 1.063A1.42 1.42 0 0 1 15.5 17zm-8 0q-.625 0-1.062-.437A1.45 1.45 0 0 1 3 15.5v-11q0-.604.438-1.042A1.41 1.41 0 0 1 4.5 3h3q.604 0 1.042.458Q9 3.896 9 4.5v11q0 .624-.458 1.063A1.42 1.42 0 0 1 7.5 17zm0-12.5v11h3v-11zm3 11h-3z"></path></g>
      <g id="battery-charging-80" viewBox="0 0 24 24"><path fill-rule="evenodd" d="M8 22C7.71667 22 7.475 21.9083 7.275 21.725C7.09167 21.525 7 21.2833 7 21V5C7 4.71667 7.09167 4.48333 7.275 4.3C7.475 4.1 7.71667 4 8 4H10V2H14V4H16C16.2833 4 16.5167 4.1 16.7 4.3C16.9 4.48333 17 4.71667 17 5V12C15.3333 12.0167 13.9167 12.6083 12.75 13.775C11.5833 14.925 11 16.3333 11 18C11 18.7667 11.1333 19.4917 11.4 20.175C11.6667 20.8583 12.0417 21.4667 12.525 22H8ZM9 10H15V6H9V10ZM16.5 22V19H14L17.5 14V17H20L16.5 22Z"></path></g>

      <!-- General OS Settings icons -->
      <g id="account" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.6 9.8a1 1 0 1 0 0 2 1 1 0 0 0 0-2Zm4.8 0a1 1 0 1 0 0 2 1 1 0 0 0 0-2ZM10 2c-4.416 0-8 3.584-8 8s3.584 8 8 8 8-3.584 8-8-3.584-8-8-8Zm0 14.4A6.409 6.409 0 0 1 3.6 10c0-.232.016-.464.04-.688a8.05 8.05 0 0 0 4.168-4.296 7.98 7.98 0 0 0 8.328 3.176c.168.568.264 1.176.264 1.808 0 3.528-2.872 6.4-6.4 6.4Z"/></g>
      <g id="android"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.15545 1.37568C7.05465 1.22183 6.84735 1.17314 6.6918 1.26969C6.54236 1.36576 6.49393 1.55821 6.57371 1.71244L7.41124 3.15992C6.02666 3.96928 5.12596 5.40608 5 7.00763H15C14.874 5.40607 13.9733 3.96926 12.5887 3.15991L13.4251 1.71451L13.4262 1.71238C13.5114 1.54737 13.4473 1.34438 13.2866 1.25867C13.1324 1.17889 12.9404 1.2266 12.8443 1.37604L11.9968 2.83646L11.9911 2.83895C11.9846 2.84172 11.9767 2.84511 11.9674 2.84906C10.7051 2.33473 9.29491 2.33473 8.03265 2.84904L8.00441 2.83702L8.00315 2.83647L7.15693 1.37795L7.15545 1.37568ZM8 5.5C8.27614 5.5 8.5 5.27614 8.5 5C8.5 4.72386 8.27614 4.5 8 4.5C7.72386 4.5 7.5 4.72386 7.5 5C7.5 5.27614 7.72386 5.5 8 5.5ZM12.5 5C12.5 5.27614 12.2761 5.5 12 5.5C11.7239 5.5 11.5 5.27614 11.5 5C11.5 4.72386 11.7239 4.5 12 4.5C12.2761 4.5 12.5 4.72386 12.5 5Z"></path><path d="M5 7.50378H15V14.5038C15 15.0561 14.5523 15.5038 14 15.5038H6C5.44772 15.5038 5 15.0561 5 14.5038V7.50378Z"></path><rect x="7" y="14.5038" width="2" height="4" rx="1"></rect><rect x="11" y="14.5038" width="2" height="4" rx="1"></rect><rect x="3" y="7.50378" width="1.5" height="6.5" rx="0.75"></rect><rect x="15.5" y="7.50378" width="1.5" height="6.5" rx="0.75"></rect></g>
      <g id="apps" viewBox="0 0 20 20"><path fill="none"/><path d="M15 7c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2ZM5 17c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2ZM15 17c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2ZM12 15c0 1.1-.9 2-2 2s-2-.9-2-2 .9-2 2-2 2 .9 2 2ZM7 5c0 1.1-.9 2-2 2s-2-.9-2-2 .9-2 2-2 2 .9 2 2ZM10 7c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2ZM17 10c0 1.1-.9 2-2 2s-2-.9-2-2 .9-2 2-2 2 .9 2 2ZM5 12c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2ZM12 10c0 1.1-.9 2-2 2s-2-.9-2-2 .9-2 2-2 2 .9 2 2Z"/></g>
      <g id="assistant"><path d="M6.36364 3C8.77382 3 10.7273 4.95418 10.7273 7.36364C10.7273 9.77309 8.77382 11.7273 6.36364 11.7273C3.95345 11.7273 2 9.77309 2 7.36364C2 4.95418 3.95345 3 6.36364 3Z"></path><path d="M18 6.99997C18 7.60215 17.5113 8.09088 16.9091 8.09088C16.3069 8.09088 15.8182 7.60215 15.8182 6.99997C15.8182 6.39778 16.3069 5.90906 16.9091 5.90906C17.5113 5.90906 18 6.39778 18 6.99997Z"></path><path d="M15.8182 9.54547C15.8182 10.7506 14.8414 11.7273 13.6363 11.7273C12.4313 11.7273 11.4545 10.7506 11.4545 9.54547C11.4545 8.34037 12.4313 7.36365 13.6363 7.36365C14.8414 7.36365 15.8182 8.34037 15.8182 9.54547Z"></path><path d="M13.6363 17.5455C15.0422 17.5455 16.1818 16.4059 16.1818 15C16.1818 13.5942 15.0422 12.4546 13.6363 12.4546C12.2305 12.4546 11.0909 13.5942 11.0909 15C11.0909 16.4059 12.2305 17.5455 13.6363 17.5455Z"></path></g>
      <g id="audio"><path fill-rule="evenodd" clip-rule="evenodd" d="M1 13H4.46667L8 16.4V3.40002L4.46667 7.00002H1V13ZM10 6.40002V13.4C11.776 12.7652 12.5 10.9044 12.5 9.90002C12.5 8.89568 11.776 7.0435 10 6.40002ZM10 4.16171C12.4771 4.89717 14.5 7.18908 14.5 9.90002C14.5 12.611 12.4771 14.9029 10 15.6383V17.4C13.4371 16.6218 16 13.5602 16 9.90002C16 6.23982 13.4371 3.17825 10 2.40002V4.16171Z"></path></g>
      <g id="auth-key"><path d="M6.364 5C3.956 5 2 7.018 2 9.5S3.956 14 6.364 14c1.898 0 3.512-1.252 4.11-3H13.5v3h3v-3H18V8h-7.527c-.597-1.747-2.21-3-4.11-3zm0 6c-.8 0-1.455-.675-1.455-1.5S5.563 8 6.363 8c.8 0 1.454.675 1.454 1.5S7.164 11 6.364 11z"></path></g>
      <g id="autoclick" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M7 10a3 3 0 1 0 6 0 3 3 0 0 0-6 0Zm4 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z" fill="var(--cros-sys-primary)"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M10 2c-4.416 0-8 3.584-8 8s3.584 8 8 8 8-3.584 8-8-3.584-8-8-8Zm0 14c-3.308 0-6-2.693-6-6 0-3.308 2.692-6 6-6 3.307 0 6 2.692 6 6 0 3.307-2.693 6-6 6Z" fill="var(--cros-sys-primary)"></path></g>
      <g id="camera"><path d="M10 13C11.3807 13 12.5 11.8807 12.5 10.5C12.5 9.11929 11.3807 8 10 8C8.61929 8 7.5 9.11929 7.5 10.5C7.5 11.8807 8.61929 13 10 13Z" fill="#1B1B1F"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M12 3H8L6 5H4C3.44772 5 3 5.44772 3 6V15C3 15.5523 3.44772 16 4 16H16C16.5523 16 17 15.5523 17 15V6C17 5.44772 16.5523 5 16 5H14L12 3ZM5 7H15V14H5V7Z" fill="#1B1B1F"></path></g>
      <g id="cellular"><path fill-rule="evenodd" clip-rule="evenodd" d="M15.002 15.002V7.41622L7.41622 15.002H15.002ZM16.002 17.002C16.5543 17.002 17.002 16.5543 17.002 16.002V5.002C17.002 4.1111 15.9249 3.66493 15.2949 4.2949L4.2949 15.2949C3.66493 15.9249 4.1111 17.002 5.002 17.002H16.002Z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M13.5 16.002C13.5 16.5543 13.0523 17.002 12.5 17.002H5.002C4.1111 17.002 3.66493 15.9249 4.2949 15.2949L11.7929 7.79289C12.4229 7.16293 13.5 7.6091 13.5 8.5V16.002Z"></path></g>
      <g id="chrome" viewBox="0 0 20 20"><path d="M17.418 6.25h-7.417c-1.833 0-3.416 1.417-3.666 3.166l-2.75-4.75c1.5-1.833 3.833-3 6.416-3 3.25 0 6.084 1.834 7.417 4.584Z"/><path d="M6.751 11.833c.667 1.167 1.834 1.917 3.25 1.917.5 0 .917-.084 1.417-.25l-2.75 4.75c-4-.667-7-4.084-7-8.25 0-1.667.5-3.25 1.333-4.583l3.75 6.416Z"/><path d="M13.751 10c0 .666-.166 1.333-.5 1.833l-3.75 6.5h.5c4.584 0 8.334-3.75 8.334-8.333 0-1-.167-2-.5-2.917h-5.5c.833.667 1.416 1.75 1.416 2.917Z"/><path d="M12.918 10a2.917 2.917 0 1 1-5.833 0 2.917 2.917 0 0 1 5.833 0Z"/></g>
      <g id="cloud-off"><path d="M16.4732571,13.3443682 C16.8002856,12.9882746 17,12.5134184 17,11.9922 C17,10.8882 16.104,9.9922 15,9.9922 L13.494,9.9922 L13.494,9.0002 C13.494,7.0672 11.927,5.5002 9.994,5.5002 C9.5847901,5.5002 9.1930204,5.57089988 8.82954884,5.70065995 L7.33083687,4.20194798 C8.11843435,3.75577808 9.02717677,3.5002 10,3.5002 C12.71,3.5002 14.957,5.4612 15.411,8.0412 C17.424,8.2502 19,9.9312 19,12.0002 C19,13.0718701 18.5784721,14.0451601 17.8921876,14.7632987 L16.4732571,13.3443682 Z M17.8711111,17 L16.8711111,18 L14.8713111,16.0002 L6,16.0002 C3.239,16.0002 1,13.7622 1,11.0002 C1,8.58475294 2.71868905,6.59044755 4.99627833,6.12516722 L2,3.12888889 L3,2.12888889 L17.8711111,17 Z M6.86331111,7.9922 L6,7.9922 C4.343,7.9922 3,9.3352 3,10.9922 C3,12.6492 4.343,13.9922 6,13.9922 L12.8633111,13.9922 L6.86331111,7.9922 Z"></path></g>
      <g id="color-correction" viewBox="0 0 20 20"><path d="M1.19209e-07 14.0833V10.375L7.125 3.25L6 2.14583L7.0625 1.08333L8.5625 2.58333L10.8542 0.291665C11.0069 0.138887 11.1875 0.0624986 11.3958 0.0624986C11.6181 0.0624986 11.8056 0.138887 11.9583 0.291665L13.7708 2.125C13.9236 2.27778 14 2.46528 14 2.6875C14 2.89583 13.9236 3.07639 13.7708 3.22917L11.5 5.5L13 7.02083L11.9375 8.08333L10.8125 6.95833L3.70833 14.0833H1.19209e-07ZM1.5 12.5833H3.08333L9.75 5.91667L8.1875 4.33333L1.5 11V12.5833ZM10.3333 4.5625L12.2083 2.66667L11.4167 1.85417L9.52083 3.72917L10.3333 4.5625ZM10.3333 4.5625L9.52083 3.72917L10.3333 4.5625Z"></g>
      <g id="connected-devices" viewBox="0 0 20 20"><path d="M6.306 16.405h-2.37c-.553 0-1.014-.184-1.383-.553A1.919 1.919 0 0 1 2 14.469V5.936c0-.54.184-.994.553-1.363A1.884 1.884 0 0 1 3.936 4h12.326v1.936H3.936v8.533h2.37v1.936Zm1.422 0v-1.56a2.32 2.32 0 0 1-.79-.85 2.607 2.607 0 0 1-.257-1.146c0-.408.093-.79.277-1.145.184-.356.441-.646.77-.87v-1.58h2.845v1.56c.316.238.56.534.73.89.185.342.277.717.277 1.126 0 .395-.085.777-.257 1.145a2.038 2.038 0 0 1-.75.85v1.58H7.728Zm1.403-2.726c.25 0 .454-.079.612-.237A.836.836 0 0 0 10 12.83a.773.773 0 0 0-.257-.593.795.795 0 0 0-.612-.257.836.836 0 0 0-.612.257.773.773 0 0 0-.257.593c0 .237.085.44.257.612a.872.872 0 0 0 .612.237Zm7.862 2.726h-3.516a.993.993 0 0 1-.731-.296 1.057 1.057 0 0 1-.277-.751V8.879c0-.303.092-.553.277-.75a.993.993 0 0 1 .73-.297h3.517a.93.93 0 0 1 .71.296c.198.198.297.448.297.751v6.479c0 .303-.099.553-.296.75a.929.929 0 0 1-.711.297Zm-2.944-1.58h2.37V9.412h-2.37v5.413Z"/></g>
      <g id="contrast" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M18 10a8 8 0 1 1-16 0 8 8 0 0 1 16 0Zm-1.882 0A6.118 6.118 0 0 0 10 3.882v12.236A6.118 6.118 0 0 0 16.118 10Z"></path></g>
      <g id="cursor-click" viewBox="0 0 15 15"><path fill-rule="evenodd" d="M6.042 11.23c-1.459.013-2.702-.487-3.73-1.5C1.286 8.7.772 7.457.772 6c0-1.458.507-2.694 1.52-3.708C3.307 1.278 4.542.77 6 .77c1.458 0 2.694.514 3.708 1.542 1.028 1.027 1.535 2.27 1.521 3.729L9.563 5.5a3.436 3.436 0 0 0-1.209-2.187A3.463 3.463 0 0 0 6 2.417c-.986 0-1.833.354-2.542 1.062A3.434 3.434 0 0 0 2.417 6c0 .889.291 1.674.875 2.354A3.579 3.579 0 0 0 5.5 9.563l.542 1.666Zm7.125 3.416-3.5-3.5-1.125 2.979L6 6l8.125 2.542-2.98 1.104 3.5 3.52-1.478 1.48Z"></path></g>
      <g id="dictation" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="m12.571 4.5-.008 5c0 1.383-1.14 2.5-2.563 2.5-1.423 0-2.571-1.117-2.571-2.5v-5C7.429 3.117 8.577 2 10 2c1.423 0 2.571 1.117 2.571 2.5Zm-2.524-1a1 1 0 0 0-1 .992l-.04 5a1 1 0 0 0 2 .016l.04-5a1 1 0 0 0-1-1.008ZM10 13.874c-2.366 0-4.543-1.769-4.543-4.295H4c0 2.88 2.331 5.246 5.143 5.659V18h1.714v-2.762C13.67 14.834 16 12.459 16 9.579h-1.457c0 2.526-2.177 4.295-4.543 4.295Z"></path></g>
      <g id="display"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.5 3H2.5C1.6 3 1 3.7 1 4.55556V14.5C1 15.3556 1.6 16 2.5 16H7V18H13V16H17.5C18.4 16 19 15.3556 19 14.5V4.5C19 3.64444 18.4 3 17.5 3ZM17 14H3V5H17V14Z"></path></g>
      <g id="docked-magnifier" viewBox="0 0 20 20"><path d="M14 11V9h2V8h-2V6h-1v2h-2v1h2v2h1Z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M17.5 3h-15C1.6 3 1 3.7 1 4.556V15.5c0 .856.6 1.5 1.5 1.5h15c.9 0 1.5-.644 1.5-1.5v-11c0-.856-.6-1.5-1.5-1.5Zm-.5 9H3V5h14v7Z"></path></g>
      <g id="reduced-animations" viewBox="0 -960 960 960"><path d="M360-80q-58 0-109-22t-89-60q-38-38-60-89T80-360q0-81 42-148t110-102q20-39 49.5-68.5T350-728q33-68 101-110t149-42q58 0 109 22t89 60q38 38 60 89t22 109q0 85-42 150T728-350q-20 39-49.5 68.5T610-232q-35 68-102 110T360-80Zm0-80q33 0 63.5-10t56.5-30q-58 0-109-22t-89-60q-38-38-60-89t-22-109q-20 26-30 56.5T160-360q0 42 16 78t43 63q27 27 63 43t78 16Zm120-120q33 0 64.5-10t57.5-30q-59 0-110-22.5T403-403q-38-38-60.5-89T320-602q-20 26-30 57.5T280-480q0 42 15.5 78t43.5 63q27 28 63 43.5t78 15.5Zm120-120q18 0 34.5-3t33.5-9q22-60 6.5-115.5T621-621q-38-38-93.5-53.5T412-668q-6 17-9 33.5t-3 34.5q0 42 15.5 78t43.5 63q27 28 63 43.5t78 15.5Zm160-78q20-26 30-57.5t10-64.5q0-42-15.5-78T741-741q-27-28-63-43.5T600-800q-35 0-65.5 10T478-760q59 0 110 22.5t89 60.5q38 38 60.5 89T760-478Z"></path></g>
      <g id="scroll-vertical" viewBox="0 0 8 18">
        <path fill="#1B1B1F" fill-rule="evenodd" clip-rule="evenodd"
          d="M3 3.29 1.128 5.245 0 4.09 4 0l4 4.09-1.128 1.155L5 3.37v11.34l1.872-1.956L8 13.91 4 18l-4-4.09 1.128-1.155L3 14.63V3.29Z">
        </path>
      </g>
      <g id="end-of-life-offer" viewBox="0 0 20 20"><path d="M7 20V18H17V20H7ZM11 16V7.825L8.4 10.4L7 9L12 4L17 9L15.6 10.4L13 7.825V16H11Z"></path></g>
      <g id="explore" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M9.854 18.167a8.144 8.144 0 0 1-3.125-.688 8.4 8.4 0 0 1-2.562-1.75 8.54 8.54 0 0 1-1.709-2.583A7.999 7.999 0 0 1 1.833 10c0-1.139.209-2.201.625-3.188A8.153 8.153 0 0 1 4.23 4.23a8.112 8.112 0 0 1 2.604-1.75A7.827 7.827 0 0 1 10 1.833c2.028 0 3.778.632 5.25 1.896 1.486 1.264 2.41 2.854 2.77 4.771h-1.77a6.056 6.056 0 0 0-1.333-2.667 6.267 6.267 0 0 0-2.438-1.75v.459A1.459 1.459 0 0 1 11 6.022H9.001v.999A.964.964 0 0 1 8.02 8h-1v2H8v1.958h-.98L3.709 8.646c-.041.222-.076.444-.104.666a5.54 5.54 0 0 0-.042.688c0 1.764.612 3.27 1.834 4.52 1.222 1.237 2.708 1.876 4.458 1.918v1.729Zm7.104-.459-2.562-2.583c-.278.167-.57.299-.875.396a3.396 3.396 0 0 1-.938.125c-1 0-1.847-.347-2.541-1.042A3.434 3.434 0 0 1 9 12.084c0-1 .347-1.848 1.042-2.542.694-.695 1.541-1.042 2.541-1.042.986 0 1.827.347 2.521 1.042a3.434 3.434 0 0 1 1.042 2.52c0 .348-.049.674-.146.98-.083.305-.208.59-.375.854l2.563 2.583-1.23 1.23Zm-4.395-3.791c.513 0 .95-.174 1.312-.521.361-.361.542-.799.542-1.313 0-.514-.18-.951-.542-1.312a1.72 1.72 0 0 0-1.292-.542c-.514 0-.951.18-1.312.542a1.72 1.72 0 0 0-.542 1.291c0 .514.174.952.521 1.313.361.361.799.542 1.313.542Z"></path></g>
      <g id="face-gaze"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.875 16.125V14.375H10.4792L9.14583 12.2708C9.14583 12.2569 9.13889 12.25 9.125 12.25C9.125 12.2361 9.125 12.2222 9.125 12.2083V8.875H10.875V11.7708L12.2708 14.0417C12.3542 14.1528 12.4097 14.2708 12.4375 14.3958C12.4792 14.5069 12.5 14.6319 12.5 14.7708C12.5 15.1458 12.3611 15.4653 12.0833 15.7292C11.8194 15.9931 11.4931 16.125 11.1042 16.125H7.875ZM5.9375 12.0833C5.35417 12.0833 4.86111 11.8819 4.45833 11.4792C4.05556 11.0764 3.85417 10.5833 3.85417 10C3.85417 9.43056 4.05556 8.94444 4.45833 8.54167C4.86111 8.125 5.34722 7.91667 5.91667 7.91667C6.5 7.91667 6.99306 8.11806 7.39583 8.52083C7.79861 8.92361 8 9.41667 8 10C8 10.5694 7.79861 11.0625 7.39583 11.4792C6.99306 11.8819 6.50694 12.0833 5.9375 12.0833ZM14.0833 12.0833C13.5 12.0833 13.0069 11.8819 12.6042 11.4792C12.2014 11.0764 12 10.5833 12 10C12 9.43056 12.2014 8.94444 12.6042 8.54167C13.0069 8.125 13.4931 7.91667 14.0625 7.91667C14.6458 7.91667 15.1389 8.11806 15.5417 8.52083C15.9444 8.92361 16.1458 9.41667 16.1458 10C16.1458 10.5694 15.9444 11.0625 15.5417 11.4792C15.1389 11.8819 14.6528 12.0833 14.0833 12.0833ZM3.33333 6.52083L2.14583 5.3125C2.61806 4.88194 3.13889 4.54167 3.70833 4.29167C4.27778 4.04167 4.875 3.91667 5.5 3.91667C6.125 3.91667 6.72917 4.03472 7.3125 4.27083C7.89583 4.50694 8.40972 4.85417 8.85417 5.3125L7.66667 6.52083C7.36111 6.25694 7.02083 6.04861 6.64583 5.89583C6.28472 5.72917 5.90278 5.64583 5.5 5.64583C5.09722 5.64583 4.70833 5.72917 4.33333 5.89583C3.97222 6.0625 3.63889 6.27083 3.33333 6.52083ZM12.3333 6.52083L11.1458 5.3125C11.5903 4.85417 12.1042 4.50694 12.6875 4.27083C13.2708 4.03472 13.875 3.91667 14.5 3.91667C15.125 3.91667 15.7292 4.03472 16.3125 4.27083C16.8958 4.50694 17.4097 4.85417 17.8542 5.3125L16.6667 6.52083C16.3472 6.25694 16.0069 6.04861 15.6458 5.89583C15.2847 5.72917 14.9028 5.64583 14.5 5.64583C14.0972 5.64583 13.7153 5.72917 13.3542 5.89583C12.9931 6.04861 12.6528 6.25694 12.3333 6.52083Z"></path></g>
      <g id="fullscreen-magnifier" viewBox="0 0 20 20"><path d="M14 11V9h2V8h-2V6h-1v2h-2v1h2v2h1Z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M17.5 3h-15C1.6 3 1 3.7 1 4.556V15.5c0 .856.6 1.5 1.5 1.5h15c.9 0 1.5-.644 1.5-1.5v-11c0-.856-.6-1.5-1.5-1.5ZM17 15H3V5h14v10Z"></path></g>
      <g id="geolocation"><path d="M12 8C12 9.10457 11.1046 10 10 10C8.89543 10 8 9.10457 8 8C8 6.89543 8.89543 6 10 6C11.1046 6 12 6.89543 12 8Z" fill="#1B1B1F"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M16 8C16 10.2091 14 13.5425 10 18C6 13.5425 4 10.2091 4 8C4 4.68629 6.68629 2 10 2C13.3137 2 16 4.68629 16 8ZM10 4C7.79086 4 6 5.79086 6 8C6 9.32543 7.318 11.7149 10 14.9435C12.682 11.7149 14 9.32543 14 8C14 5.79086 12.2091 4 10 4Z" fill="#1B1B1F"></path></g>
      <g id="google-drive" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M4.875 16.125h10.25l1.958-3.375-5.145-8.875H8.062L2.918 12.75l1.958 3.375Zm0 1.52c-.292 0-.556-.062-.792-.187a1.57 1.57 0 0 1-.541-.583L1.604 13.5a1.785 1.785 0 0 1-.208-.75c0-.278.07-.535.208-.77L6.73 3.124c.125-.236.306-.424.542-.563.25-.138.514-.208.792-.208h3.874c.264 0 .514.07.75.208.25.14.445.327.584.563l5.125 8.854c.11.236.166.493.166.771.014.264-.041.514-.166.75l-1.938 3.375c-.152.25-.347.444-.583.583a1.503 1.503 0 0 1-.75.188H4.875Zm1.292-3.624L5.604 13l3.667-6.417h1.458L14.396 13l-.563 1.02H6.167ZM7.646 12.5h4.708L10 8.396 7.646 12.5Z"></path></g>
      <g id="google-play"><path fill-rule="evenodd" clip-rule="evenodd" d="M16.8167 9.06658L14.2667 7.61658L11.8834 9.99991L14.2667 12.3832L16.8167 10.9332C17.275 10.6749 17.5 10.3416 17.5 9.99991C17.5 9.65824 17.275 9.32491 16.8167 9.06658ZM3.92498 2.04163C4.93332 3.04996 10.9417 9.05829 10.9417 9.05829L13.0666 6.93329L4.14998 1.88329C4.09165 1.84996 4.03332 1.82496 3.97498 1.79996C3.83332 1.74163 3.72498 1.84163 3.84998 1.97496C3.87498 1.99163 3.89998 2.01663 3.92498 2.04163ZM3.92501 17.9583C3.90001 17.9833 3.87501 18.0083 3.85834 18.025C3.73334 18.15 3.84168 18.2583 3.98334 18.2C4.04168 18.175 4.10001 18.15 4.15834 18.1166L13.0667 13.0667L10.9417 10.9417C10.9417 10.9417 4.94168 16.95 3.92501 17.9583ZM10 9.99995C10 9.99995 2.975 2.97495 2.81667 2.81662C2.65833 2.65828 2.5 2.75828 2.5 2.97495V17.025C2.5 17.2416 2.65833 17.3416 2.81667 17.1833C2.975 17.025 10 9.99995 10 9.99995Z"></path></g>
      <g id="hard-drive"><path d="M14 14C14 14.5523 13.5523 15 13 15C12.4477 15 12 14.5523 12 14C12 13.4477 12.4477 13 13 13C13.5523 13 14 13.4477 14 14Z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M5 2C3.89543 2 3 2.89543 3 4V16C3 17.1046 3.89543 18 5 18H15C16.1046 18 17 17.1046 17 16V4C17 2.89543 16.1046 2 15 2H5ZM5 16H15V12H5V16ZM5 10H15V4H5V10Z"></path></g>
      <g id="help-me-read"><path fill-rule="evenodd" clip-rule="evenodd" d="M9.175 13.75V9.306h1.65v4.444h-1.65ZM10 8.406a.903.903 0 0 1-.637-.244.903.903 0 0 1-.244-.637.868.868 0 0 1 .881-.881c.25 0 .456.087.619.262a.808.808 0 0 1 .262.619.868.868 0 0 1-.881.881Zm5.662.863 1.557-1.556c.125.375.212.75.262 1.125.05.375.075.762.075 1.162 0 1.05-.2 2.031-.6 2.944a7.511 7.511 0 0 1-1.612 2.4 7.774 7.774 0 0 1-2.4 1.631 7.452 7.452 0 0 1-2.944.581 7.452 7.452 0 0 1-2.944-.581 7.774 7.774 0 0 1-2.4-1.631 7.774 7.774 0 0 1-1.631-2.4A7.452 7.452 0 0 1 2.444 10c0-1.063.194-2.044.581-2.944.4-.912.944-1.712 1.631-2.4a7.511 7.511 0 0 1 2.4-1.612 7.25 7.25 0 0 1 2.944-.6c.4 0 .787.025 1.162.075.375.05.75.137 1.125.262l-1.556 1.557-.375-.038A3.23 3.23 0 0 0 10 4.281c-1.6 0-2.956.557-4.069 1.669-1.1 1.1-1.65 2.45-1.65 4.05 0 1.6.55 2.956 1.65 4.069 1.113 1.1 2.469 1.65 4.069 1.65s2.95-.55 4.05-1.65c1.112-1.113 1.669-2.469 1.669-4.069 0-.125-.006-.244-.019-.356l-.037-.375Zm-1.612.918c0-1.175-.413-2.175-1.238-3-.824-.825-1.824-1.237-3-1.237 1.176 0 2.176-.413 3-1.237.825-.825 1.238-1.825 1.238-3 0 1.175.412 2.175 1.237 3 .825.824 1.825 1.237 3 1.237-1.174 0-2.174.412-3 1.237-.825.825-1.237 1.825-1.237 3Z"></path></g>
      <g id="help-me-write"><path fill-rule="evenodd" clip-rule="evenodd" d="M6.081 14.819h.956l6.3-6.3-.937-.957-6.319 6.32v.937Zm-1.837 1.837v-3.543l9.319-9.32a1.23 1.23 0 0 1 .487-.337c.188-.075.381-.112.581-.112.188 0 .369.037.544.112.188.063.369.169.544.319l1.406 1.387c.15.15.262.32.337.507a1.551 1.551 0 0 1 0 1.162 1.498 1.498 0 0 1-.337.506l-9.319 9.32H4.244ZM15.625 6.27l-.975-.994.975.994ZM12.869 8.03l-.469-.469.938.957-.47-.488ZM5.725 9.962c0-1.187-.412-2.187-1.237-3-.826-.824-1.832-1.237-3.02-1.237 1.188 0 2.195-.412 3.02-1.237.824-.826 1.237-1.832 1.237-3.02 0 1.188.406 2.195 1.219 3.02.825.824 1.831 1.237 3.019 1.237-1.188 0-2.194.413-3.02 1.238-.812.812-1.218 1.812-1.218 3Z"></path></g>
      <g id="hotspot"><path d="M2 10.5C2 5.84343 5.808 2 10.5 2C15.192 2 19 5.84343 19 10.5C19 13.7534 17.2915 16.5158 15 18L14 16.5C15.9315 15.3233 17.3 13.1185 17.5 10.5C17.3 6.78713 14.257 3.71582 10.5 3.5C6.743 3.71582 3.7 6.78713 3.5 10.5C3.7 13.1185 5.0685 15.3233 7 16.5L6 18C3.7085 16.5158 2 13.7534 2 10.5Z"></path><path d="M15.5 10.5C15.5 7.78374 13.2583 5.5 10.5 5.5C7.74167 5.5 5.5 7.78374 5.5 10.5C5.5 12.4786 6.50833 14.1171 8 15L9 13.5C7.84167 12.9285 7.16667 11.8503 7 10.5C7.16667 8.71761 8.65833 7.19794 10.5 7C12.3417 7.19794 13.8333 8.71761 14 10.5C13.8333 11.8503 13.1583 12.9285 12 13.5L13 15C14.4917 14.1171 15.5 12.4786 15.5 10.5Z"></path><path d="M10.5 12C11.3284 12 12 11.3284 12 10.5C12 9.67157 11.3284 9 10.5 9C9.67157 9 9 9.67157 9 10.5C9 11.3284 9.67157 12 10.5 12Z"></path></g>
      <g id="ic-checked-filled"><circle cx="10" cy="10" r="8" fill="#1967D2"></circle><path fill-rule="evenodd" clip-rule="evenodd" d="M8.33333 11.833L6.16667 9.66634L5 10.833L8.33333 14.1663L15 7.49967L13.8333 6.33301L8.33333 11.833Z" fill="white"></path></g>
      <g id="ic-checked-filled-dark"><circle cx="10" cy="10" r="8" fill="#AECBFA"></circle><path fill-rule="evenodd" clip-rule="evenodd" d="M8.33333 11.833L6.16667 9.66634L5 10.833L8.33333 14.1663L15 7.49967L13.8333 6.33301L8.33333 11.833Z" fill="#2A2A2D"></path></g>
      <g id="launcher" viewbox="0 0 20 20">
        <path d="M10 15C12.7614 15 15 12.7614 15 10C15 7.23858 12.7614 5 10 5C7.23858 5 5 7.23858 5 10C5 12.7614 7.23858 15 10 15Z"></path>
        <path fill-rule="evenodd" d="M10 18.5C14.6944 18.5 18.5 14.6944 18.5 10C18.5 5.30558 14.6944 1.5 10 1.5C5.30558 1.5 1.5 5.30558 1.5 10C1.5 14.6944 5.30558 18.5 10 18.5ZM17 10C17 13.866 13.866 17 10 17C6.13401 17 3 13.866 3 10C3 6.13401 6.13401 3 10 3C13.866 3 17 6.13401 17 10Z"></path>
      </g>
      <g id="lock"><path d="M11.75 12.5C11.75 13.4665 10.9665 14.25 10 14.25C9.0335 14.25 8.25 13.4665 8.25 12.5C8.25 11.5335 9.0335 10.75 10 10.75C10.9665 10.75 11.75 11.5335 11.75 12.5Z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M14 7H13.5V5C13.5 3.34315 11.6569 2 10 2C8.34315 2 6.5 3.34315 6.5 5V7H6C4.89543 7 4 7.89543 4 9V16C4 17.1046 4.89543 18 6 18H14C15.1046 18 16 17.1046 16 16V9C16 7.89543 15.1046 7 14 7ZM12 5.5V7H8V5.5C8 5 8.5 3.5 10 3.5C11.5 3.5 12 5 12 5.5ZM6 9V16H14V9H6Z"></path></g>
      <g id="keyboard"><path fill-rule="evenodd" clip-rule="evenodd" d="M18 3H2C0.9 3 0.01 3.9 0.01 5L0 15C0 16.1 0.9 17 2 17H18C19.1 17 20 16.1 20 15V5C20 3.9 19.1 3 18 3ZM18 5V15H2V5H18ZM11 6H9V8H11V6ZM9 9H11V11H9V9ZM8 6H6V8H8V6ZM6 9H8V11H6V9ZM5 9H3V11H5V9ZM3 6H5V8H3V6ZM14 12H6V14H14V12ZM12 9H14V11H12V9ZM14 6H12V8H14V6ZM15 9H17V11H15V9ZM17 6H15V8H17V6Z"></path></g>
      <g id="magic-boost"><path fill-rule="evenodd" clip-rule="evenodd" d="M10 18.168c0-1.133-.21-2.191-.637-3.18a8.28 8.28 0 0 0-1.758-2.593 8.282 8.282 0 0 0-2.593-1.758A7.945 7.945 0 0 0 1.832 10c1.133 0 2.191-.21 3.18-.637A8.28 8.28 0 0 0 9.363 5C9.79 4.008 10 2.95 10 1.832c0 1.117.21 2.176.637 3.168A8.243 8.243 0 0 0 15 9.363c.992.426 2.05.637 3.168.637-1.117 0-2.176.21-3.168.637a8.28 8.28 0 0 0-4.363 4.352A7.95 7.95 0 0 0 10 18.168Z"></path></g>
      <g id="magic-tethering"><path d="M19 6.49212C14.5855 1.83596 6.42182 1.83596 2 6.49212L3.5 8C7.5 3.97898 13.5 3.97898 17.5 8L19 6.49212Z"></path><path d="M6.23521 11L4.5 9.33611C5.90378 7.99334 7.67283 7.21963 9.5 7L8.2038 9.73544C7.48803 10.0225 6.81737 10.4418 6.23521 11Z"></path><path d="M16.5 9.33645L14.7651 11C14.183 10.4419 13.5125 10.0227 12.7968 9.7357L11.5 7C13.3286 7.21876 15.0982 7.99231 16.5 9.33645Z"></path><path d="M6.5 12.9992L9.2496 11.7496L10.4992 9L11.7496 11.7496L14.5 12.9992L11.7496 14.2504L10.4992 17L9.2496 14.2504L6.5 12.9992Z"></path></g>
      <g id="mahi" viewbox="0 0 20 20"><g clip-path="url(#a)"><path fill-rule="evenodd" clip-rule="evenodd" d="M6.75 14c.208 0 .382-.07.52-.208a.74.74 0 0 0 .23-.542.675.675 0 0 0-.23-.52.675.675 0 0 0-.52-.23.74.74 0 0 0-.542.23.707.707 0 0 0-.208.52c0 .208.07.389.208.542A.779.779 0 0 0 6.75 14Zm0-3.25c.208 0 .382-.07.52-.208A.74.74 0 0 0 7.5 10a.675.675 0 0 0-.23-.52.675.675 0 0 0-.52-.23.74.74 0 0 0-.542.23A.707.707 0 0 0 6 10c0 .208.07.389.208.542a.779.779 0 0 0 .542.208Zm0-3.25c.208 0 .382-.07.52-.208a.74.74 0 0 0 .23-.542.675.675 0 0 0-.23-.52.675.675 0 0 0-.52-.23.74.74 0 0 0-.542.23.707.707 0 0 0-.208.52c0 .208.07.389.208.542a.779.779 0 0 0 .542.208ZM9 14h5v-1.5H9V14Zm0-3.25h4v-1.5H9v1.5ZM4.5 17c-.417 0-.77-.146-1.063-.438A1.492 1.492 0 0 1 3 15.5v-11c0-.403.146-.75.438-1.042A1.414 1.414 0 0 1 4.5 3H11v1.5H4.5v11h11V9H17v6.5c0 .403-.146.757-.438 1.063A1.446 1.446 0 0 1 15.5 17h-11Zm10-7c0-1.25-.438-2.313-1.313-3.188C12.313 5.938 11.25 5.5 10 5.5c1.25 0 2.313-.438 3.188-1.313C14.062 3.313 14.5 2.25 14.5 1c0 1.25.438 2.313 1.313 3.188C16.686 5.063 17.75 5.5 19 5.5c-1.25 0-2.313.438-3.188 1.313C14.938 7.688 14.5 8.75 14.5 10Z"></g><defs><clipPath id="a"><path fill-rule="evenodd" clip-rule="evenodd" d="M0 0h20v20H0z"></clipPath></defs></g>
      <g id="microphone"><path fill-rule="evenodd" clip-rule="evenodd" d="M10 12.1053C11.4229 12.1053 12.5629 10.9768 12.5629 9.57895L12.5714 4.52632C12.5714 3.12842 11.4229 2 10 2C8.57716 2 7.42859 3.12842 7.42859 4.52632V9.57895C7.42859 10.9768 8.57716 12.1053 10 12.1053ZM14.5429 9.57898C14.5429 12.1053 12.3657 13.8737 10 13.8737C7.63429 13.8737 5.45714 12.1053 5.45714 9.57898H4C4 12.459 6.33143 14.8253 9.14286 15.2379V18H10.8571V15.2379C13.6686 14.8337 16 12.459 16 9.57898H14.5429Z" fill="#1B1B1F"></path></g>
      <g id="move"><path d="M10.078 3.038a.1.1 0 0 0-.156 0L8.13 5.278a.1.1 0 0 0 .078.162h3.584a.1.1 0 0 0 .078-.163l-1.792-2.24ZM16 6.94H4v2h12v-2ZM16 10.5H4v2h12v-2ZM9.922 16.402a.1.1 0 0 0 .156 0l1.792-2.24a.1.1 0 0 0-.078-.162H8.208a.1.1 0 0 0-.078.162l1.792 2.24Z"></path></g>
      <g id="mouse"><path fill-rule="evenodd" clip-rule="evenodd" d="M10 2C6.68286 2 4 4.504 4 7.6V12.4C4 15.496 6.68286 18 10 18C13.3171 18 16 15.496 16 12.4V7.6C16 4.504 13.3171 2 10 2ZM14 7.5V8H11V4C13 4 14 6 14 7.5ZM9 4V8H6V7.6C6 6 7 4 9 4ZM10 16C7.63429 16 6 14.608 6 12.4V10H14V12.4C14 14.608 12.3657 16 10 16Z"></path></g>
      <g id="mouse-keys">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M15.1667 16.1042C14.5972 16.6736 13.9028 16.9583 13.0833 16.9583C12.2778 16.9583 11.5833 16.6736 11 16.1042C10.4306 15.5208 10.1458 14.8264 10.1458 14.0208V13.1875H16.0208V14.0208C16.0208 14.8264 15.7361 15.5208 15.1667 16.1042ZM12.2708 11.5625H10.1875C10.2708 10.9792 10.5 10.4792 10.875 10.0625C11.25 9.64583 11.7153 9.35417 12.2708 9.1875V11.5625ZM15.9792 11.5625H13.8958V9.1875C14.4514 9.35417 14.9097 9.64583 15.2708 10.0625C15.6458 10.4792 15.8819 10.9792 15.9792 11.5625ZM9.8125 17.2917C10.7014 18.1667 11.7917 18.6042 13.0833 18.6042C14.375 18.6042 15.4583 18.1667 16.3333 17.2917C17.2222 16.4028 17.6667 15.3125 17.6667 14.0208V12.0833C17.6667 10.7917 17.2222 9.70833 16.3333 8.83333C15.4583 7.94444 14.375 7.5 13.0833 7.5C11.7917 7.5 10.7014 7.94444 9.8125 8.83333C8.9375 9.70833 8.5 10.7917 8.5 12.0833V14.0208C8.5 15.3125 8.9375 16.4028 9.8125 17.2917Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M4 3C3.44772 3 3 3.44772 3 4V6C3 6.55228 3.44772 7 4 7H6C6.55228 7 7 6.55228 7 6V4C7 3.44772 6.55228 3 6 3H4ZM4 8C3.44772 8 3 8.44772 3 9V11C3 11.5523 3.44772 12 4 12H6C6.55228 12 7 11.5523 7 11V9C7 8.44772 6.55228 8 6 8H4ZM4 13C3.44772 13 3 13.4477 3 14V16C3 16.5523 3.44772 17 4 17H6C6.55228 17 7 16.5523 7 16V14C7 13.4477 6.55228 13 6 13H4ZM11.9966 6.08354C11.1522 6.22571 10.3676 6.54426 9.6822 7H9C8.44772 7 8 6.55228 8 6V4C8 3.44772 8.44772 3 9 3H11C11.5523 3 12 3.44772 12 4V6C12 6.02813 11.9988 6.05599 11.9966 6.08354ZM16.2641 6.96474C15.3247 6.35448 14.2037 6 13 6V4C13 3.44772 13.4477 3 14 3H16C16.5523 3 17 3.44772 17 4V6C17 6.46085 16.6883 6.84889 16.2641 6.96474Z"></path>
      </g>
      <g id="ms365" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M8.15 4.5v2.47a4.17 4.17 0 0 1 3.74 0l4.53 2.33c.61.342 1.148.8 1.58 1.35V7.31a3.37 3.37 0 0 0-1.76-3l-4.56-2.5a3.32 3.32 0 0 0-2.2-.36l-.14.06C8.61 1.91 8.15 3 8.15 4.5Zm9.42 8.24a4.63 4.63 0 0 0-1.83-2.1l-2.26-1.16v.25a4.19 4.19 0 0 1-2.2 3.68l-4.57 2.48a6.14 6.14 0 0 1-1.6.53l3.27 1.78a3.5 3.5 0 0 0 3.27 0l4.56-2.48a3.38 3.38 0 0 0 1.6-1.91 1.81 1.81 0 0 0-.24-1.07Zm-9.17.52L6 14.56a4.39 4.39 0 0 1-3.15.35A3.4 3.4 0 0 1 2 12.66V7.31a3.43 3.43 0 0 1 1.81-3.02l3.03-1.67a7.16 7.16 0 0 0-.24 1.86l-.003.255c-.011.89-.049 3.823.003 5.115a4.57 4.57 0 0 0 1.8 3.41Z" clip-rule="evenodd"></path></g>
      <g id="network-wifi"><path fill-rule="evenodd" clip-rule="evenodd" d="M10.5554 16.7289C10.2698 17.0905 9.72802 17.0905 9.44247 16.7281L2.15749 7.49646C1.89621 7.16533 1.96831 6.68099 2.31239 6.44135C3.50455 5.61135 6.26792 4 10 4C13.7328 4 16.4955 5.61135 17.6876 6.44135C18.0317 6.68099 18.1038 7.16533 17.8425 7.49646L10.5554 16.7289ZM5.46762 8.4626L4.61134 7.37751C5.85753 6.71277 7.72159 6 10 6C12.2788 6 14.1425 6.71268 15.3886 7.37739L14.5315 8.46329C13.348 7.94707 11.8035 7.5 9.99865 7.5C8.19498 7.5 6.65099 7.94668 5.46762 8.4626Z"></path></g>
      <g id="on-screen-keyboard" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M5 14V9h11v5H5Zm8-2H8v1h5v-1Zm-6-2h1v1H7v-1Zm3 0H9v1h1v-1Zm1 0h1v1h-1v-1Zm3 0h-1v1h1v-1Z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M2 4.669C2 3.75 2.736 3 3.636 3h13.728c.9 0 1.636.75 1.636 1.669v10.68c0 .917-.736 1.651-1.636 1.651H3.636C2.736 17 2 16.266 2 15.348V4.668ZM4 5v10h13V5H4Z"></path></g>
      <g id="onedrive"><path d="m11.94 8.81 2.23-.94a7.4 7.4 0 0 1 1.18-.31 5.8 5.8 0 0 0-5.21-3.44 5.68 5.68 0 0 0-3.93 1.61 7.38 7.38 0 0 1 1.72.68l4.01 2.4Zm2.82.44-1.22.52 1.19.71 4.72 2.83a3.43 3.43 0 0 0 0-1.88 4.07 4.07 0 0 0-.22-.52l-.09-.19-.14-.24a4.68 4.68 0 0 0-.29-.37 3.88 3.88 0 0 0-1-.76l-.18-.07-.4-.16a3.82 3.82 0 0 0-.77-.12 4.39 4.39 0 0 0-1.6.25Zm-5.07.51.54-.23L7.16 7.7A5.21 5.21 0 0 0 4.84 7a4.44 4.44 0 0 0-4.41 4.5v.08a4.54 4.54 0 0 0 .48 1.88l8.78-3.7Zm2.13.73-10 4.2a4.41 4.41 0 0 0 3 1.17h11.3a3.4 3.4 0 0 0 2.62-1.22L15.93 13l-4.11-2.51Z"></path></g>
      <g id="print"><path fill-rule="evenodd" clip-rule="evenodd" d="M5 3H15V7H16C17.1046 7 18 7.89543 18 9V14H15V17H5V14H2V9C2 7.89543 2.89543 7 4 7H5V3ZM13 5H7V7H13V5ZM16 10C16 10.5523 15.5523 11 15 11C14.4477 11 14 10.5523 14 10C14 9.44772 14.4477 9 15 9C15.5523 9 16 9.44772 16 10ZM7 12H13V15H7V12Z"></path></g>
      <g id="printer-add"><path fill-opacity=".3" d="M17.8734304,8.29826826 C17.2839707,8.10470383 16.6542128,8 16,8 C13.3875623,8 11.1650842,9.66961525 10.3414114,12 L7,12 L7,15 L10.0829584,15 C10.2034032,15.7179235 10.4513404,16.3926158 10.8026932,17 L5,17 L5,14 L2,14 L2,9 C2,7.8954305 2.8954305,7 4,7 L5,7 L5,3 L15,3 L15,7 L16,7 C16.8576527,7 17.5892179,7.53984453 17.8734304,8.29826826 Z M7,5 L7,7 L13,7 L13,5 L7,5 Z"></path><polygon points="17 13 19 13 19 15 17 15 17 17 15 17 15 15 13 15 13 13 15 13 15 11 17 11"></polygon></g>
      <g id="refresh"><path fill-rule="evenodd" clip-rule="evenodd" d="M10 3C6.136 3 3 6.136 3 10C3 13.864 6.136 17 10 17C12.1865 17 14.1399 15.9959 15.4239 14.4239L13.9984 12.9984C13.0852 14.2129 11.6325 15 10 15C7.24375 15 5 12.7563 5 10C5 7.24375 7.24375 5 10 5C11.6318 5 13.0839 5.78641 13.9972 7H11V9H17V3H15V5.10253C13.7292 3.80529 11.9581 3 10 3Z"></path></g>
      <g id="scanner" viewBox="2 2 20 20"><path d="M11.0625 8.03125c-1.125 0-2.075.39375-2.85 1.18125-.7875.775-1.18125 1.725-1.18125 2.85 0-1.125-.3875-2.075-1.1625-2.85C5.08125 8.425 4.125 8.03125 3 8.03125c1.125 0 2.08125-.3875 2.86875-1.1625.775-.7875 1.1625-1.74375 1.1625-2.86875 0 1.125.39375 2.08125 1.18125 2.86875.775.775 1.725 1.1625 2.85 1.1625Zm8.675 3.25005H17.9V7.2625h-5.0187V5.425H17.9c.5125 0 .95.18125 1.3125.54375.35.35.525.78125.525 1.29375v4.0188Zm-8.4562 7.4562H6.2625c-.5125 0-.94375-.175-1.29375-.525-.3625-.3625-.54375-.8-.54375-1.3125v-3.0187h1.8375V16.9h5.0188v1.8375Z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M13.6357 17.2985c1.018.9889 2.5432 1.1346 3.7105.4495l1.9844 1.9279 1.29-1.3279-2.031-1.9731c.5309-1.1546.3094-2.5665-.6541-3.5026-1.2222-1.1873-3.1756-1.159-4.363.0632-1.1873 1.2223-1.159 3.1756.0632 4.363Zm1.2898-1.328c.4888.4748 1.2701.4635 1.7451-.0253.4749-.489.4636-1.2703-.0252-1.7452-.489-.475-1.2703-.4637-1.7452.0253-.475.4888-.4637 1.2702.0253 1.7452Z"></path></g>
      <g id="select-to-speak" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M18 10a8 8 0 1 1-16 0 8 8 0 0 1 16 0ZM7.778 11.368H6V8.632h1.778L10 6.352v7.297l-2.222-2.28ZM12 10c0-.807-.453-1.5-1.111-1.838v3.671A2.046 2.046 0 0 0 12 10Zm-1.111-3.06V6C12.67 6.415 14 8.048 14 10s-1.329 3.585-3.111 4v-.94c1.284-.392 2.222-1.614 2.222-3.06s-.938-2.668-2.222-3.06ZM5 7V5h2v1H6v1H5Zm10 6v2h-2v-1h1v-1h1Z"></path></g>
      <g id="social-group"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.5 3C9.425 3 11 4.575 11 6.5C11 8.425 9.425 10 7.5 10C5.575 10 4 8.425 4 6.5C4 4.575 5.575 3 7.5 3ZM7.5 5C6.67957 5 6 5.67957 6 6.5C6 7.32043 6.67957 8 7.5 8C8.32043 8 9 7.32043 9 6.5C9 5.67957 8.32043 5 7.5 5ZM13.9916 14.0859C13.7789 12.0336 9.60583 11 7.5 11C5.33875 11 1 12.0887 1 14.25V17H14V14.25L13.9916 14.0859ZM11.9947 14.3433C11.9867 14.3476 11.9693 14.3346 11.9329 14.3011L11.8432 14.2246C11.6159 14.0441 11.2636 13.85 10.8172 13.6713C9.79154 13.2607 8.42752 13 7.5 13C6.57248 13 5.20846 13.2607 4.18279 13.6713C3.73641 13.85 3.38414 14.0441 3.15679 14.2246L3.0671 14.3011C3.01855 14.3458 3.00384 14.3539 3 14.3335V15H12V14.3335L11.9947 14.3433ZM11.2717 9.77623C11.6543 9.92081 12.0683 10 12.5 10C14.425 10 16 8.425 16 6.5C16 4.575 14.425 3 12.5 3C12.0683 3 11.6543 3.07919 11.2717 3.22377C12.0361 4.10238 12.5 5.24886 12.5 6.5C12.5 7.75114 12.0361 8.89762 11.2717 9.77623ZM15.5 17H19V14.25L18.9916 14.0859C18.8063 12.2977 15.6141 11.2828 13.4026 11.0513C14.5583 11.7896 15.3634 12.7824 15.4896 14.0088L15.5 14.25V17Z"></path></g>
      <g id="stylus"><path fill-rule="evenodd" clip-rule="evenodd" d="M2 14.6662V18H5.32305L12.0225 11.3057L8.69053 7.97192L2 14.6662ZM15.6565 2.26452L17.7356 4.33592C18.0821 4.68263 18.091 5.2516 17.7445 5.59831L12.9732 10.3634L9.63234 7.02073L11.8803 4.77153L11.2317 4.12255L6.20266 9.15435L4.95874 7.90974L10.6186 2.25563C10.9651 1.90892 11.5426 1.91781 11.8803 2.26452L13.142 3.51803L14.4037 2.26452C14.7413 1.91781 15.31 1.91781 15.6565 2.26452Z"></path></g>
      <g id="switch-access" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M18 9v2h-1.17a3.001 3.001 0 1 1 0-2H18ZM6 7c.463 0 .902.105 1.293.292L10 4.586 11.414 6 8.708 8.707A3 3 0 1 1 3.17 11H2V9h1.17A3.001 3.001 0 0 1 6 7Zm0 4a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm8 0a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"></path></g>
      <g id="sync"><path fill-rule="evenodd" clip-rule="evenodd" d="M8.99977 3.07092L8.9991 5.1002C6.71731 5.56382 5 7.58136 5 10C5 11.8507 6.00553 13.4666 7.50008 14.3311L7.5 12H9V17H4V15.5L5.6705 15.5009C4.04414 14.2191 3 12.2315 3 10C3 6.55562 5.48772 3.69227 8.76441 3.1087L8.99977 3.07092ZM16 3V4.5L14.3315 4.5007C15.9567 5.78256 17 7.76944 17 10C17 13.5264 14.3924 16.4438 11.0002 16.9291L11.0009 14.8998C13.2827 14.4362 15 12.4186 15 10C15 8.14968 13.9949 6.5341 12.5009 5.66945L12.5 8H11V3H16Z"></path></g>
      <g id="wallpaper"><path fill-rule="evenodd" clip-rule="evenodd" d="M4 3H16C17.1046 3 18 3.89543 18 5V15C18 16.1046 17.1046 17 16 17H4C2.89543 17 2 16.1046 2 15V5C2 3.89543 2.89543 3 4 3ZM4 5V15H16V5H4ZM6 13L9 7L11 11L12 9.5L14 13H6Z"></path></g>
      <g id="zoom-in" viewBox="0 0 16 16"><path fill-rule="evenodd" d="m13.938 15.188-5.021-5.042a5.43 5.43 0 0 1-1.375.729 4.851 4.851 0 0 1-1.584.25c-1.416 0-2.625-.5-3.625-1.5C1.347 8.625.854 7.417.854 6c0-1.417.493-2.625 1.48-3.625 1-1 2.208-1.5 3.624-1.5 1.417 0 2.625.5 3.625 1.5s1.5 2.208 1.5 3.625a5.04 5.04 0 0 1-.25 1.604 5.05 5.05 0 0 1-.687 1.334l5 5.02-1.209 1.23Zm-7.98-5.813c.945 0 1.743-.326 2.396-.98.667-.652 1-1.45 1-2.395 0-.944-.333-1.743-1-2.396-.653-.653-1.451-.979-2.396-.979-.944 0-1.743.326-2.395.98-.653.652-.98 1.45-.98 2.395 0 .944.327 1.743.98 2.396.652.653 1.45.979 2.395.979Zm-.75-1.146V6.75H3.75v-1.5h1.458V3.77h1.5v1.48h1.48v1.5h-1.48v1.48h-1.5Z"></path></g>

      <!-- Switch Access Action Assignment Dialog icons -->
      <g id="add-assignment" fill-rule="evenodd"><path fill-rule="evenodd" clip-rule="evenodd" d="M14 9V11H11V14H9V11H6V9H9V6H11V9H14ZM10 2C5.576 2 2 5.576 2 10C2 14.424 5.576 18 10 18C14.424 18 18 14.424 18 10C18 5.576 14.424 2 10 2ZM10 16C6.6925 16 4 13.3075 4 10C4 6.6925 6.6925 4 10 4C13.3075 4 16 6.6925 16 10C16 13.3075 13.3075 16 10 16Z"></path></g>
      <g id="assigned"><path d="M13.7071 7.29289C13.3166 6.90237 12.6834 6.90237 12.2929 7.29289L9 10.5858L7.70711 9.29289C7.31658 8.90237 6.68342 8.90237 6.29289 9.29289C5.90237 9.68342 5.90237 10.3166 6.29289 10.7071L8.29289 12.7071C8.68342 13.0976 9.31658 13.0976 9.70711 12.7071L13.7071 8.70711C14.0976 8.31658 14.0976 7.68342 13.7071 7.29289Z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M10 18C14.4183 18 18 14.4183 18 10C18 5.58172 14.4183 2 10 2C5.58172 2 2 5.58172 2 10C2 14.4183 5.58172 18 10 18ZM10 16C13.3137 16 16 13.3137 16 10C16 6.68629 13.3137 4 10 4C6.68629 4 4 6.68629 4 10C4 13.3137 6.68629 16 10 16Z"></path></g>
      <g id="error"><path fill-rule="evenodd" clip-rule="evenodd" d="M9 10H11V6H9V10ZM10 2C5.584 2 2 5.584 2 10C2 14.416 5.584 18 10 18C14.416 18 18 14.416 18 10C18 5.584 14.416 2 10 2ZM10 16C6.6925 16 4 13.3075 4 10C4 6.6925 6.6925 4 10 4C13.3075 4 16 6.6925 16 10C16 13.3075 13.3075 16 10 16ZM9 14H11V12H9V14Z"></path></g>
      <g id="remove-assignment" fill-rule="evenodd"><path fill-rule="evenodd" clip-rule="evenodd" d="M12.072 6.79999L9.99999 8.87199L7.92799 6.79999L6.79999 7.92799L8.87199 9.99999L6.79999 12.072L7.92799 13.2L9.99999 11.128L12.072 13.2L13.2 12.072L11.128 9.99999L13.2 7.92799L12.072 6.79999ZM10 2C5.576 2 2 5.576 2 10C2 14.424 5.576 18 10 18C14.424 18 18 14.424 18 10C18 5.576 14.424 2 10 2ZM10 16C6.6925 16 4 13.3075 4 10C4 6.6925 6.6925 4 10 4C13.3075 4 16 6.6925 16 10C16 13.3075 13.3075 16 10 16Z"></path></g>

      <!-- Keep alphabetized. -->

      <!--
      These icons are copied from Polymer's iron-icons and kept in sorted order.
      See http://goo.gl/Y1OdAq for instructions on adding additional icons.
      -->
      <g id="alert-device-out-of-range" viewBox="0 0 24 24"><path d="M8.167 11.5h1.666v1.667H8.167V11.5zm0-6.667h1.666v5H8.167v-5zM8.992.667C4.392.667.667 4.4.667 9s3.725 8.333 8.325 8.333c4.608 0 8.341-3.733 8.341-8.333S13.6.667 8.992.667zm.008 15A6.665 6.665 0 0 1 2.333 9 6.665 6.665 0 0 1 9 2.333 6.665 6.665 0 0 1 15.667 9 6.665 6.665 0 0 1 9 15.667z"></path></g>
      <g id="bluetooth" viewBox="0 0 24 24"><path d="M17.71 7.71L12 2h-1v7.59L6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 11 14.41V22h1l5.71-5.71-4.3-4.29 4.3-4.29zM13 5.83l1.88 1.88L13 9.59V5.83zm1.88 10.46L13 18.17v-3.76l1.88 1.88z"></path></g>
      <g id="bluetooth-connected" viewBox="0 0 24 24"><path d="M7 12l-2-2-2 2 2 2 2-2zm10.71-4.29L12 2h-1v7.59L6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 11 14.41V22h1l5.71-5.71-4.3-4.29 4.3-4.29zM13 5.83l1.88 1.88L13 9.59V5.83zm1.88 10.46L13 18.17v-3.76l1.88 1.88zM19 10l-2 2 2 2 2-2-2-2z"></path></g>
      <g id="bluetooth-disabled" viewBox="0 0 24 24"><path d="M13 5.83l1.88 1.88-1.6 1.6 1.41 1.41 3.02-3.02L12 2h-1v5.03l2 2v-3.2zM5.41 4L4 5.41 10.59 12 5 17.59 6.41 19 11 14.41V22h1l4.29-4.29 2.3 2.29L20 18.59 5.41 4zM13 18.17v-3.76l1.88 1.88L13 18.17z"></path></g>
      <g id="chevron-left" viewBox="0 0 24 24"><path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"></path></g>
      <g id="edit" width="20" height="20" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M15.41 1.935L14.06 0.585C13.28 -0.195 12.01 -0.195 11.23 0.585L8.4 3.405L0 11.815V15.995H4.18L15.41 4.765C16.2 3.985 16.2 2.715 15.41 1.935ZM2 13.995V12.635L9.82 4.815L11.23 6.225L3.41 14.055L2 13.995Z"></path></g>
      <g id="end-of-life" viewBox="0 0 24 24"><path d="M4.574 2.916H4.55l.01.01.014-.01zM2.5 4.968v.023a.18.18 0 0 1 .01-.013l-.01-.01zm14.585 10.49v-.024l-.01.013.01.01zm.223 1.817l-.933-.95-4.106-4.11L8.026 7.99 3.675 3.635l-.942-.941-.712-.713L1 3.002l1.733 1.733A9.056 9.056 0 0 0 1.05 9.98c0 1.95.628 3.748 1.683 5.22.574.8 1.274 1.501 2.074 2.075a8.918 8.918 0 0 0 5.218 1.684 8.918 8.918 0 0 0 5.218-1.684L16.991 19l1.02-1.021-.703-.704zM15.243 2.684A8.922 8.922 0 0 0 10.025 1a8.922 8.922 0 0 0-5.218 1.684c-.005.003 4.135 4.16 4.135 4.16l1.083-1.814L15.042 11h-1.846l4.11 4.214a8.939 8.939 0 0 0 .011-10.456 9.021 9.021 0 0 0-2.074-2.074zM12 15H7.012v-3.989L4.5 11l2.227-1.876L12 14.6v.4z" fill-rule="evenodd"></path></g>
      <g id="feedback" viewBox="0 0 24 24"><path d="M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H5.17l-.59.59-.58.58V4h16v12zm-9-4h2v2h-2zm0-6h2v4h-2z"></path></g>
      <g id="fingerprint" viewBox="0 0 24 24"><path d="M17.81 4.47c-.08 0-.16-.02-.23-.06C15.66 3.42 14 3 12.01 3c-1.98 0-3.86.47-5.57 1.41-.24.13-.54.04-.68-.2-.13-.24-.04-.55.2-.68C7.82 2.52 9.86 2 12.01 2c2.13 0 3.99.47 6.03 1.52.25.13.34.43.21.67-.09.18-.26.28-.44.28zM3.5 9.72c-.1 0-.2-.03-.29-.09-.23-.16-.28-.47-.12-.7.99-1.4 2.25-2.5 3.75-3.27C9.98 4.04 14 4.03 17.15 5.65c1.5.77 2.76 1.86 3.75 3.25.16.22.11.54-.12.7-.23.16-.54.11-.7-.12-.9-1.26-2.04-2.25-3.39-2.94-2.87-1.47-6.54-1.47-9.4.01-1.36.7-2.5 1.7-3.4 2.96-.08.14-.23.21-.39.21zm6.25 12.07c-.13 0-.26-.05-.35-.15-.87-.87-1.34-1.43-2.01-2.64-.69-1.23-1.05-2.73-1.05-4.34 0-2.97 2.54-5.39 5.66-5.39s5.66 2.42 5.66 5.39c0 .28-.22.5-.5.5s-.5-.22-.5-.5c0-2.42-2.09-4.39-4.66-4.39-2.57 0-4.66 1.97-4.66 4.39 0 1.44.32 2.77.93 3.85.64 1.15 1.08 1.64 1.85 2.42.19.2.19.51 0 .71-.11.1-.24.15-.37.15zm7.17-1.85c-1.19 0-2.24-.3-3.1-.89-1.49-1.01-2.38-2.65-2.38-4.39 0-.28.22-.5.5-.5s.5.22.5.5c0 1.41.72 2.74 1.94 3.56.71.48 1.54.71 2.54.71.24 0 .64-.03 1.04-.1.27-.05.53.13.58.41.05.27-.13.53-.41.58-.57.11-1.07.12-1.21.12zM14.91 22c-.04 0-.09-.01-.13-.02-1.59-.44-2.63-1.03-3.72-2.1-1.4-1.39-2.17-3.24-2.17-5.22 0-1.62 1.38-2.94 3.08-2.94 1.7 0 3.08 1.32 3.08 2.94 0 1.07.93 1.94 2.08 1.94s2.08-.87 2.08-1.94c0-3.77-3.25-6.83-7.25-6.83-2.84 0-5.44 1.58-6.61 4.03-.39.81-.59 1.76-.59 2.8 0 .78.07 2.01.67 3.61.1.26-.03.55-.29.64-.26.1-.55-.04-.64-.29-.49-1.31-.73-2.61-.73-3.96 0-1.2.23-2.29.68-3.24 1.33-2.79 4.28-4.6 7.51-4.6 4.55 0 8.25 3.51 8.25 7.83 0 1.62-1.38 2.94-3.08 2.94s-3.08-1.32-3.08-2.94c0-1.07-.93-1.94-2.08-1.94s-2.08.87-2.08 1.94c0 1.71.66 3.31 1.87 4.51.95.94 1.86 1.46 3.27 1.85.27.07.42.35.35.61-.05.23-.26.38-.47.38z"></path></g>
      <g id="gamepad" viewBox="0 0 24 24"><path d="M15 7.5V2H9v5.5l3 3 3-3zM7.5 9H2v6h5.5l3-3-3-3zM9 16.5V22h6v-5.5l-3-3-3 3zM16.5 9l-3 3 3 3H22V9h-5.5z"></path></g>
      <g id="headset" viewBox="0 0 24 24"><path d="M12 1c-4.97 0-9 4.03-9 9v7c0 1.66 1.34 3 3 3h3v-8H5v-2c0-3.87 3.13-7 7-7s7 3.13 7 7v2h-4v8h3c1.66 0 3-1.34 3-3v-7c0-4.97-4.03-9-9-9z"></path></g>
      <g id="hotspot-disabled"><path fill-rule="evenodd" clip-rule="evenodd" d="M3.18333 2L2 3.175L4.24167 5.41667C3.15833 6.825 2.50833 8.58333 2.50833 10.4917C2.50833 12.7917 3.44167 14.875 4.95 16.3833L6.13333 15.2C4.925 14 4.175 12.3333 4.175 10.4917C4.175 9.03333 4.65 7.7 5.43333 6.60833L6.625 7.8C6.13333 8.575 5.84167 9.5 5.84167 10.4917C5.84167 11.875 6.40833 13.1167 7.30833 14.025L8.49167 12.8417C7.88333 12.2417 7.50833 11.4167 7.50833 10.4917C7.50833 9.96666 7.63333 9.46667 7.85 9.025L9.19167 10.3667C9.19167 10.3875 9.1875 10.4083 9.18333 10.4292C9.17917 10.45 9.175 10.4708 9.175 10.4917C9.175 10.95 9.36667 11.3667 9.66667 11.6667C9.96667 11.9667 10.3833 12.1583 10.8417 12.1583C10.8773 12.1583 10.9128 12.1523 10.9536 12.1453L10.975 12.1417L17.325 18.4917L18.5 17.3167L3.18333 2ZM15.5917 12.05C15.75 11.5583 15.8417 11.0333 15.8417 10.4917C15.8417 7.73333 13.6 5.49167 10.8417 5.49167C10.3 5.49167 9.775 5.575 9.28333 5.74167L10.7083 7.16667C10.75 7.15833 10.8 7.15833 10.8417 7.15833C12.6833 7.15833 14.175 8.65 14.175 10.4917C14.175 10.5333 14.175 10.5833 14.1667 10.625L15.5917 12.05ZM17.5083 10.4917C17.5083 6.80833 14.525 3.825 10.8417 3.825C9.825 3.825 8.86667 4.05 8 4.45833L6.76667 3.225C7.975 2.54167 9.35833 2.15833 10.8417 2.15833C15.4417 2.15833 19.175 5.89167 19.175 10.4917C19.175 11.975 18.7833 13.3667 18.1083 14.5667L16.8667 13.325C17.2833 12.4667 17.5083 11.5083 17.5083 10.4917Z"></path></g>
      <g id="hotspot-enabled"><path d="M2 10.5C2 5.84343 5.808 2 10.5 2C15.192 2 19 5.84343 19 10.5C19 13.7534 17.2915 16.5158 15 18L14 16.5C15.9315 15.3233 17.3 13.1185 17.5 10.5C17.3 6.78713 14.257 3.71582 10.5 3.5C6.743 3.71582 3.7 6.78713 3.5 10.5C3.7 13.1185 5.0685 15.3233 7 16.5L6 18C3.7085 16.5158 2 13.7534 2 10.5Z"></path><path d="M15.5 10.5C15.5 7.78374 13.2583 5.5 10.5 5.5C7.74167 5.5 5.5 7.78374 5.5 10.5C5.5 12.4786 6.50833 14.1171 8 15L9 13.5C7.84167 12.9285 7.16667 11.8503 7 10.5C7.16667 8.71761 8.65833 7.19794 10.5 7C12.3417 7.19794 13.8333 8.71761 14 10.5C13.8333 11.8503 13.1583 12.9285 12 13.5L13 15C14.4917 14.1171 15.5 12.4786 15.5 10.5Z"></path><path d="M10.5 12C11.3284 12 12 11.3284 12 10.5C12 9.67157 11.3284 9 10.5 9C9.67157 9 9 9.67157 9 10.5C9 11.3284 9.67157 12 10.5 12Z"></path></g>
      <g id="info-outline" viewBox="0 0 24 24"><path d="M11 17h2v-6h-2v6zm1-15C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zM11 9h2V7h-2v2z"></path></g>
      <g id="laptop-chromebook" viewBox="0 0 24 24"><path d="M22 18V3H2v15H0v2h24v-2h-2zm-8 0h-4v-1h4v1zm6-3H4V5h16v10z"></path></g>
      <g id="mic-off" viewBox="0 0 24 24"><path d="M19,11h-2c0,0.91-0.25,1.76-0.68,2.49l1.45,1.45C18.54,13.82,19,12.47,19,11z M2.81,2.81L1.39,4.22l11.66,11.66 C12.71,15.96,12.36,16,12,16c-2.76,0-5-2.24-5-5H5c0,3.53,2.61,6.43,6,6.92V21h2v-3.08c0.57-0.08,1.12-0.24,1.64-0.45l5.14,5.14 l1.41-1.41L2.81,2.81z M15,11V5c0-1.66-1.34-3-3-3S9,3.34,9,5v1.17l5.81,5.81C14.92,11.67,15,11.35,15,11z"></path></g>
      <g id="power" viewBox="0 0 24 24"><path d="M16.01 7L16 3h-2v4h-4V3H8v4h-.01C7 6.99 6 7.99 6 8.99v5.49L9.5 18v3h5v-3l3.5-3.51v-5.5c0-1-1-2-1.99-1.99z"></path></g>
      <g id="settings-ethernet" viewBox="0 0 24 24"><path d="M7.77 6.76L6.23 5.48.82 12l5.41 6.52 1.54-1.28L3.42 12l4.35-5.24zM7 13h2v-2H7v2zm10-2h-2v2h2v-2zm-6 2h2v-2h-2v2zm6.77-7.52l-1.54 1.28L20.58 12l-4.35 5.24 1.54 1.28L23.18 12l-5.41-6.52z"></path></g>
      <g id="settings-general" viewBox="0 0 24 24"><path d="M19.43 12.98c.04-.32.07-.64.07-.98s-.03-.66-.07-.98l2.11-1.65c.19-.15.24-.42.12-.64l-2-3.46c-.12-.22-.39-.3-.61-.22l-2.49 1c-.52-.4-1.08-.73-1.69-.98l-.38-2.65C14.46 2.18 14.25 2 14 2h-4c-.25 0-.46.18-.49.42l-.38 2.65c-.61.25-1.17.59-1.69.98l-2.49-1c-.23-.09-.49 0-.61.22l-2 3.46c-.13.22-.07.49.12.64l2.11 1.65c-.04.32-.07.65-.07.98s.03.66.07.98l-2.11 1.65c-.19.15-.24.42-.12.64l2 3.46c.12.22.39.3.61.22l2.49-1c.52.4 1.08.73 1.69.98l.38 2.65c.03.24.24.42.49.42h4c.25 0 .46-.18.49-.42l.38-2.65c.61-.25 1.17-.59 1.69-.98l2.49 1c.23.09.49 0 .61-.22l2-3.46c.12-.22.07-.49-.12-.64l-2.11-1.65zM12 15.5c-1.93 0-3.5-1.57-3.5-3.5s1.57-3.5 3.5-3.5 3.5 1.57 3.5 3.5-1.57 3.5-3.5 3.5z"></path></g>
      <g id="signal-cellular-0-bar" viewBox="0 0 24 24"><path fill-opacity=".3" d="M2 22h20V2z"></path></g>
      <g id="signal-cellular-1-bar" viewBox="0 0 24 24"><path fill-opacity=".3" d="M2 22h20V2z"></path><path d="M12 12L2 22h10z"></path></g>
      <g id="signal-cellular-2-bar" viewBox="0 0 24 24"><path fill-opacity=".3" d="M2 22h20V2z"></path><path d="M14 10L2 22h12z"></path></g>
      <g id="signal-cellular-3-bar" viewBox="0 0 24 24"><path fill-opacity=".3" d="M2 22h20V2z"></path><path d="M17 7L2 22h15z"></path></g>
      <g id="signal-cellular-4-bar" viewBox="0 0 24 24"><path d="M2 22h20V2z"></path></g>
      <g id="smartphone" viewBox="0 0 24 24"><path d="M17 1.01L7 1c-1.1 0-2 .9-2 2v18c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V3c0-1.1-.9-1.99-2-1.99zM17 19H7V5h10v14z"></path></g>
      <g id="startup" viewBox="0 0 24 24"><path d="M13 3h-2v10h2V3zm4.83 2.17l-1.42 1.42C17.99 7.86 19 9.81 19 12c0 3.87-3.13 7-7 7s-7-3.13-7-7c0-2.19 1.01-4.14 2.58-5.42L6.17 5.17C4.23 6.82 3 9.26 3 12c0 4.97 4.03 9 9 9s9-4.03 9-9c0-2.74-1.23-5.18-3.17-6.83z"></path></g>
      <g id="tablet" viewBox="0 0 24 24"><path d="M21 4H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h18c1.1 0 1.99-.9 1.99-2L23 6c0-1.1-.9-2-2-2zm-2 14H5V6h14v12z"></path></g>
      <!-- Keep alphabetized. -->
    </defs>
  </svg>
</iron-iconset-svg>

<!-- Include illustrations below -->
<iron-iconset-svg name="os-settings-illo" size="200">
  <svg>
    <defs>
      <!-- A11y section -->
      <!-- Switch access-->
      <g id="switch-access-setup-guide-assign-next" viewBox="0 0 216 216" fill="none">
        <path d="M137.85 46.05a6.1 6.1 0 0 1 1 8.4l-8.6 11a5.796 5.796 0 0 1-3.937 2.266 5.802 5.802 0 0 1-4.363-1.266 5.893 5.893 0 0 1-2.126-6.228 5.904 5.904 0 0 1 1.026-2.072l8.6-11a6 6 0 0 1 8.4-1.1Z" fill="var(--cros-sys-illo-color3)"/><path d="M60.85 67.95c4.5 2.5 9.3 6.3 10.6 11.8 1.9 8-4.8 13.5-2.8 21.2.9 3.5 3.6 7.7 11.3 11.6" stroke="var(--cros-sys-illo-color1-2)" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/><path d="m93.072 73.505-5.764 10.979a2.8 2.8 0 0 0 1.178 3.78L99.58 94.09a2.8 2.8 0 0 0 3.78-1.178l5.764-10.979a2.8 2.8 0 0 0-1.177-3.78l-11.094-5.825a2.8 2.8 0 0 0-3.78 1.178Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M105.35 45.95a8 8 0 1 0 0-16 8 8 0 0 0 0 16Z" fill="var(--cros-sys-illo-color5)"/><path d="M131.083 100.235v-9.8a.7.7 0 0 0-1-.6l-8.5 4.9a.694.694 0 0 0-.34.6.695.695 0 0 0 .34.6l8.5 4.9a.597.597 0 0 0 .735.093.597.597 0 0 0 .265-.693Z" fill="var(--cros-sys-illo-color2)"/><path d="M123.1 163.65H92.7a3.6 3.6 0 0 0-3.6 3.6v10.11a3.6 3.6 0 0 0 3.6 3.6h30.4a3.6 3.6 0 0 0 3.6-3.6v-10.11a3.6 3.6 0 0 0-3.6-3.6Z" fill="var(--cros-sys-illo-color1-1)"/><path d="M129.4 183.95H86.6c-2.3 0-4.1-1.4-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1s3.3 1 5.2 1.4c14.8 3.2 28.5 1 37.6-1.4a4.907 4.907 0 0 1 2.9.9 2.904 2.904 0 0 1 1.2 2.2v8.6c0 1.7-1.9 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-base)"/><path d="M129.4 183.95H86.6c-2.3 0-4.1-1.4-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1s3.3 1 5.2 1.4c14.8 3.2 28.5 1 37.6-1.4a4.907 4.907 0 0 1 2.9.9 2.904 2.904 0 0 1 1.2 2.2v8.6c0 1.7-1.9 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M134.5 177.73v-5.506l-.001-.026a3.909 3.909 0 0 0-1.614-2.959l-.007-.005a5.905 5.905 0 0 0-3.492-1.084l-.123.002-.118.031c-9.017 2.378-22.545 4.544-37.134 1.39l-.005-.001c-.64-.135-1.136-.337-1.712-.571a32.296 32.296 0 0 0-.583-.233c-.841-.326-1.794-.618-3.111-.618-2.584 0-5.1 1.613-5.1 4.1v5.48h-2.15v7.07h-31.8a1.25 1.25 0 0 0 0 2.5h120.9a1.25 1.25 0 0 0 0-2.5h-31.8v-7.07h-2.15Zm-4.971-7.58c-9.183 2.409-22.995 4.608-37.938 1.378-.832-.175-1.54-.465-2.142-.711-.161-.065-.314-.128-.46-.184-.709-.275-1.406-.483-2.389-.483-2.016 0-3.1 1.187-3.1 2.1v5.48h49v-5.451a1.903 1.903 0 0 0-.781-1.415 3.897 3.897 0 0 0-2.19-.714Z" fill="var(--cros-sys-illo-color1)"/><rect x="89.824" y="112.55" width="36.353" height="36.353" rx="8" fill="var(--cros-sys-illo-color1-2)"/><path d="M111.682 122.64a1.94 1.94 0 0 0-2.771 2.717l3.424 3.494H99.299a1.94 1.94 0 1 0 0 3.881h12.643c-1.052 1.132-2.094 2.269-3.131 3.4l-.01.011a1.941 1.941 0 0 0 2.861 2.623c2.138-2.333 4.254-4.641 6.431-6.881a1.941 1.941 0 0 0-.006-2.711l-6.405-6.534Z" fill="var(--cros-sys-illo-color1)"/>
      </g>
      <g id="switch-access-setup-guide-assign-previous" viewBox="0 0 216 216" fill="none">
        <path d="M137.85 46.05a6.1 6.1 0 0 1 1 8.4l-8.6 11a5.796 5.796 0 0 1-3.937 2.266 5.802 5.802 0 0 1-4.363-1.266 5.893 5.893 0 0 1-2.126-6.228 5.904 5.904 0 0 1 1.026-2.072l8.6-11a6 6 0 0 1 8.4-1.1Z" fill="var(--cros-sys-illo-color3)"/><path d="M60.85 67.95c4.5 2.5 9.3 6.3 10.6 11.8 1.9 8-4.8 13.5-2.8 21.2.9 3.5 3.6 7.7 11.3 11.6" stroke="var(--cros-sys-illo-color1-2)" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/><path d="m93.072 73.505-5.764 10.979a2.8 2.8 0 0 0 1.178 3.78L99.58 94.09a2.8 2.8 0 0 0 3.78-1.178l5.764-10.979a2.8 2.8 0 0 0-1.177-3.78l-11.094-5.825a2.8 2.8 0 0 0-3.78 1.178Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M105.35 45.95a8 8 0 1 0 0-16 8 8 0 0 0 0 16Z" fill="var(--cros-sys-illo-color5)"/><path d="M131.083 100.235v-9.8a.7.7 0 0 0-1-.6l-8.5 4.9a.694.694 0 0 0-.34.6.695.695 0 0 0 .34.6l8.5 4.9a.597.597 0 0 0 .735.093.597.597 0 0 0 .265-.693Z" fill="var(--cros-sys-illo-color2)"/><path d="M123.1 163.65H92.7a3.6 3.6 0 0 0-3.6 3.6v10.11a3.6 3.6 0 0 0 3.6 3.6h30.4a3.6 3.6 0 0 0 3.6-3.6v-10.11a3.6 3.6 0 0 0-3.6-3.6Z" fill="var(--cros-sys-illo-color1-1)"/><path d="M129.4 183.95H86.6c-2.3 0-4.1-1.4-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1s3.3 1 5.2 1.4c14.8 3.2 28.5 1 37.6-1.4a4.907 4.907 0 0 1 2.9.9 2.904 2.904 0 0 1 1.2 2.2v8.6c0 1.7-1.9 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-base)"/><path d="M129.4 183.95H86.6c-2.3 0-4.1-1.4-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1s3.3 1 5.2 1.4c14.8 3.2 28.5 1 37.6-1.4a4.907 4.907 0 0 1 2.9.9 2.904 2.904 0 0 1 1.2 2.2v8.6c0 1.7-1.9 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M134.5 177.73v-5.506l-.001-.026a3.909 3.909 0 0 0-1.614-2.959l-.007-.005a5.905 5.905 0 0 0-3.492-1.084l-.123.002-.118.031c-9.017 2.378-22.545 4.544-37.134 1.39l-.005-.001c-.64-.135-1.136-.337-1.712-.571a32.296 32.296 0 0 0-.583-.233c-.841-.326-1.794-.618-3.111-.618-2.584 0-5.1 1.613-5.1 4.1v5.48h-2.15v7.07h-31.8a1.25 1.25 0 0 0 0 2.5h120.9a1.25 1.25 0 0 0 0-2.5h-31.8v-7.07h-2.15Zm-4.971-7.58c-9.183 2.409-22.995 4.608-37.938 1.378-.832-.175-1.54-.465-2.142-.711-.161-.065-.314-.128-.46-.184-.709-.275-1.406-.483-2.389-.483-2.016 0-3.1 1.187-3.1 2.1v5.48h49v-5.451a1.903 1.903 0 0 0-.781-1.415 3.897 3.897 0 0 0-2.19-.714Z" fill="var(--cros-sys-illo-color1)"/><rect x="89.824" y="112.55" width="36.353" height="36.353" rx="8" fill="var(--cros-sys-illo-color1-2)"/><path d="M104.317 122.64a1.94 1.94 0 1 1 2.772 2.717l-3.424 3.494h13.036a1.94 1.94 0 1 1 0 3.881h-12.643c1.052 1.132 2.094 2.269 3.131 3.4l.01.011a1.94 1.94 0 0 1-2.861 2.623c-2.138-2.333-4.254-4.641-6.43-6.881a1.941 1.941 0 0 1 .005-2.711l6.404-6.534Z" fill="var(--cros-sys-illo-color1)"/>
      </g>
      <g id="switch-access-setup-guide-assign-select" viewBox="0 0 216 216" fill="none">
        <path d="M137.85 46.05a6.1 6.1 0 0 1 1 8.4l-8.6 11a5.796 5.796 0 0 1-3.937 2.266 5.802 5.802 0 0 1-4.363-1.266 5.893 5.893 0 0 1-2.126-6.228 5.904 5.904 0 0 1 1.026-2.072l8.6-11a6 6 0 0 1 8.4-1.1Z" fill="var(--cros-sys-illo-color3)"/><path d="M60.85 67.95c4.5 2.5 9.3 6.3 10.6 11.8 1.9 8-4.8 13.5-2.8 21.2.9 3.5 3.6 7.7 11.3 11.6" stroke="var(--cros-sys-illo-color1-2)" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/><path d="m93.072 73.505-5.764 10.979a2.8 2.8 0 0 0 1.178 3.78L99.58 94.09a2.8 2.8 0 0 0 3.78-1.178l5.764-10.979a2.8 2.8 0 0 0-1.177-3.78l-11.094-5.825a2.8 2.8 0 0 0-3.78 1.178Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M105.35 45.95a8 8 0 1 0 0-16 8 8 0 0 0 0 16Z" fill="var(--cros-sys-illo-color5)"/><path d="M131.083 100.235v-9.8a.7.7 0 0 0-1-.6l-8.5 4.9a.694.694 0 0 0-.34.6.695.695 0 0 0 .34.6l8.5 4.9a.597.597 0 0 0 .735.093.597.597 0 0 0 .265-.693Z" fill="var(--cros-sys-illo-color2)"/><path d="M123.1 163.65H92.7a3.6 3.6 0 0 0-3.6 3.6v10.11a3.6 3.6 0 0 0 3.6 3.6h30.4a3.6 3.6 0 0 0 3.6-3.6v-10.11a3.6 3.6 0 0 0-3.6-3.6Z" fill="var(--cros-sys-illo-color1-1)"/><path d="M129.4 183.95H86.6c-2.3 0-4.1-1.4-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1s3.3 1 5.2 1.4c14.8 3.2 28.5 1 37.6-1.4a4.907 4.907 0 0 1 2.9.9 2.904 2.904 0 0 1 1.2 2.2v8.6c0 1.7-1.9 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-base)"/><path d="M129.4 183.95H86.6c-2.3 0-4.1-1.4-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1s3.3 1 5.2 1.4c14.8 3.2 28.5 1 37.6-1.4a4.907 4.907 0 0 1 2.9.9 2.904 2.904 0 0 1 1.2 2.2v8.6c0 1.7-1.9 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M134.5 177.73v-5.506l-.001-.026a3.909 3.909 0 0 0-1.614-2.959l-.007-.005a5.905 5.905 0 0 0-3.492-1.084l-.123.002-.118.031c-9.017 2.378-22.545 4.544-37.134 1.39l-.005-.001c-.64-.135-1.136-.337-1.712-.571a32.296 32.296 0 0 0-.583-.233c-.841-.326-1.794-.618-3.111-.618-2.584 0-5.1 1.613-5.1 4.1v5.48h-2.15v7.07h-31.8a1.25 1.25 0 0 0 0 2.5h120.9a1.25 1.25 0 0 0 0-2.5h-31.8v-7.07h-2.15Zm-4.971-7.58c-9.183 2.409-22.995 4.608-37.938 1.378-.832-.175-1.54-.465-2.142-.711-.161-.065-.314-.128-.46-.184-.709-.275-1.406-.483-2.389-.483-2.016 0-3.1 1.187-3.1 2.1v5.48h49v-5.451a1.903 1.903 0 0 0-.781-1.415 3.897 3.897 0 0 0-2.19-.714Z" fill="var(--cros-sys-illo-color1)"/><rect x="89.824" y="112.55" width="36.353" height="36.353" rx="8" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M100 130.727a8 8 0 0 1 8-8 8 8 0 1 1 0 16 8 8 0 0 1-8-8Zm8-4a4 4 0 1 0 0 8 4 4 0 0 0 0-8Z" fill="var(--cros-sys-illo-color1)"/>
      </g>
      <g id="switch-access-setup-guide-auto-scan" viewBox="0 0 217 216" fill="none">
        <g clip-path="url(#a)"><path d="M104.131 157.894 91.337 172.61a4.5 4.5 0 0 0 .444 6.349l14.536 12.636a4.502 4.502 0 0 0 6.349-.444l12.793-14.717a4.502 4.502 0 0 0-.444-6.349l-14.536-12.635a4.499 4.499 0 0 0-6.348.444Z" fill="var(--cros-sys-illo-color2)"/><path d="m31.205 128.6-11.8-11.8a2.398 2.398 0 0 1-.6-2.3l4.3-16.2a2.299 2.299 0 0 1 1.7-1.6l16.1-4.3a2.2 2.2 0 0 1 2.3.6l11.8 11.8a2.2 2.2 0 0 1 .6 2.3l-4.3 16.1a2.303 2.303 0 0 1-1.6 1.7l-16.2 4.3a2.406 2.406 0 0 1-2.3-.6Z" fill="var(--cros-sys-illo-color3)"/><path d="m164.386 172.227 20.439 14.741c3.135 2.261 7.505 1.56 9.76-1.567 2.255-3.126 1.541-7.494-1.594-9.756l-20.439-14.741c-3.136-2.261-7.506-1.56-9.761 1.567-2.255 3.127-1.541 7.494 1.595 9.756Z" fill="var(--cros-sys-illo-color1)"/><path d="M105.205 98.7c-.816 1.81-1.252 3.821-1.9 5.7a10.4 10.4 0 0 1-4.8 5.7c-3.1 1.7-6.7 2.6-8.2 6.2a9.502 9.502 0 0 0-.47 4.614c.437 2.993 2.323 5.713 5.055 7.042a8.908 8.908 0 0 0 3.696.895 8.964 8.964 0 0 0 6.819-2.951c1-1.2 1.8-2.6 2.7-3.8a9.495 9.495 0 0 1 2.848-2.811c2.066-1.315 4.492-1.508 6.852-1.889a9.178 9.178 0 0 0 2.8-.5 11.497 11.497 0 0 0 5.3-3.1c4.2-4.3 4.5-11.4.7-16.5s-12.9-7.1-18.3-2.5a12.998 12.998 0 0 0-3.1 3.9Z" fill="var(--cros-sys-illo-color1-1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M23.213 161.417a18.902 18.902 0 0 0 23.129 24.635 18.9 18.9 0 0 0 10.78-8.329c.163-.269.133-.626-.17-.772l-32.998-15.9-.016-.008c-.339-.168-.613.07-.725.374Zm-.876-3.143a3.497 3.497 0 0 1 2.926.078l32.995 15.897a3.5 3.5 0 0 1 1.417 5.049 21.9 21.9 0 0 1-39.29-18.883 3.502 3.502 0 0 1 1.952-2.141Z" fill="var(--cros-sys-illo-color5)"/><path d="M190.005 32.2h-27a1.4 1.4 0 0 0-1.4 1.4v27.03a1.4 1.4 0 0 0 1.4 1.4h27a1.4 1.4 0 0 0 1.4-1.4V33.6a1.4 1.4 0 0 0-1.4-1.4Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M38.105 66.1c10.052 0 18.2-8.148 18.2-18.2s-8.148-18.2-18.2-18.2-18.2 8.148-18.2 18.2 8.148 18.2 18.2 18.2Z" fill="var(--cros-sys-illo-color4)"/><path d="m125.605 46.6-27.5-15.9a.699.699 0 0 0-1.1.6V63a.7.7 0 0 0 1.1.6l27.5-15.8a.705.705 0 0 0 0-1.2Z" fill="var(--cros-sys-illo-color5)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M170.505 97.26c-7.684 3.898-10.754 13.283-6.859 20.961 3.895 7.677 13.282 10.743 20.966 6.845l.267-.136c7.685-3.898 10.754-13.283 6.859-20.961-3.895-7.678-13.281-10.743-20.966-6.845l-.267.136Zm-9.534 22.318c-4.646-9.157-.984-20.347 8.177-24.994l.267-.136c9.16-4.647 20.353-.993 24.998 8.164 4.646 9.157.984 20.346-8.176 24.994l-.268.135c-9.16 4.648-20.353.994-24.998-8.163Z" fill="var(--cros-sys-illo-color6)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M37.505 83.6c-14.857 0-26.9 12.044-26.9 26.9 0 14.857 12.043 26.9 26.9 26.9 14.856 0 26.9-12.043 26.9-26.9 0-14.856-12.044-26.9-26.9-26.9Zm-29.9 26.9c0-16.513 13.387-29.9 29.9-29.9 16.513 0 29.9 13.387 29.9 29.9 0 16.513-13.387 29.9-29.9 29.9-16.513 0-29.9-13.387-29.9-29.9Z" fill="var(--cros-sys-illo-color1-2)"/></g><defs><clipPath id="a"><path fill="var(--cros-sys-illo-base)" transform="translate(.305)" d="M0 0h216v216H0z"/></clipPath></defs>
      </g>
      <g id="switch-access-setup-guide-choose-1-switch" viewBox="0 0 217 216" fill="none">
        <path d="M125.305 51h-34c-9.776 0-17.7 7.925-17.7 17.7v34c0 9.775 7.924 17.7 17.7 17.7h34c9.775 0 17.7-7.925 17.7-17.7v-34c0-9.775-7.925-17.7-17.7-17.7Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M108.305 78.1a7.6 7.6 0 1 0 0 15.2 7.6 7.6 0 0 0 0-15.2Zm-13.6 7.6c0-7.511 6.089-13.6 13.6-13.6 7.511 0 13.6 6.089 13.6 13.6 0 7.511-6.089 13.6-13.6 13.6-7.511 0-13.6-6.089-13.6-13.6Z" fill="var(--cros-sys-illo-color1)"/><path d="M123.455 151.7h-30.4a3.6 3.6 0 0 0-3.6 3.6v10.11a3.6 3.6 0 0 0 3.6 3.6h30.4a3.6 3.6 0 0 0 3.6-3.6V155.3a3.6 3.6 0 0 0-3.6-3.6Z" fill="var(--cros-sys-illo-color1-1)"/><path d="M129.655 172h-42.8c-2.3 0-4.1-1.3-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1l5.2 1.4c14.8 3.3 28.5 1 37.6-1.4a4.895 4.895 0 0 1 2.9.9 3.103 3.103 0 0 1 1.2 2.2v8.6c0 1.8-1.8 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-base)"/><path d="M129.655 172h-42.8c-2.3 0-4.1-1.3-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1l5.2 1.4c14.8 3.3 28.5 1 37.6-1.4a4.895 4.895 0 0 1 2.9.9 3.103 3.103 0 0 1 1.2 2.2v8.6c0 1.8-1.8 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M134.755 165v-4.742l-.004-.041a4.098 4.098 0 0 0-1.587-2.91l-.015-.012-.016-.011a5.898 5.898 0 0 0-3.492-1.084l-.123.002-.118.031c-9.019 2.379-22.533 4.64-37.106 1.396l-5.307-1.429h-.132c-2.584 0-5.1 1.613-5.1 4.1v4.7h-2.1v8.1h-75.5a1 1 0 0 0 0 2h208.3a1 1 0 0 0 0-2h-75.5V165h-2.2Zm-4.971-6.8c-9.177 2.408-22.996 4.71-37.947 1.376l-.021-.005-5.088-1.369c-1.934.048-2.973 1.204-2.973 2.098v4.7h49v-4.654a2.1 2.1 0 0 0-.795-1.442 3.901 3.901 0 0 0-2.176-.704Z" fill="var(--cros-sys-illo-color1)"/>
      </g>
      <g id="switch-access-setup-guide-choose-2-switches" viewBox="0 0 217 216" fill="none">
        <path d="M51.005 48.4h34c9.775 0 17.7 7.925 17.7 17.7v34c0 9.775-7.925 17.7-17.7 17.7h-34c-9.776 0-17.7-7.925-17.7-17.7v-34c0-9.775 7.925-17.7 17.7-17.7ZM135.305 48.4h34c9.775 0 17.7 7.925 17.7 17.7v34c0 9.775-7.925 17.7-17.7 17.7h-34c-9.775 0-17.7-7.925-17.7-17.7v-34c0-9.775 7.925-17.7 17.7-17.7Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M71.702 68.76a3 3 0 0 1 4.242.037l11.6 11.8a3 3 0 0 1 .06 4.144l-11.7 12.6a3 3 0 0 1-4.397-4.082L78.06 86.2H53.705a3 3 0 0 1 0-6h25.036l-7.075-7.197a3 3 0 0 1 .036-4.243Z" fill="var(--cros-sys-illo-color1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M152.305 69.5c-7.511 0-13.6 6.089-13.6 13.6 0 7.511 6.089 13.6 13.6 13.6 7.511 0 13.6-6.089 13.6-13.6 0-7.511-6.089-13.6-13.6-13.6Zm-7.6 13.6a7.6 7.6 0 1 1 15.2 0 7.6 7.6 0 0 1-15.2 0Z" fill="var(--cros-sys-illo-color1)"/><path d="M52.805 151.7h30.4a3.6 3.6 0 0 1 3.6 3.6v10.11a3.6 3.6 0 0 1-3.6 3.6h-30.4a3.6 3.6 0 0 1-3.6-3.6V155.3a3.6 3.6 0 0 1 3.6-3.6ZM137.105 151.7h30.4a3.6 3.6 0 0 1 3.6 3.6v10.11a3.6 3.6 0 0 1-3.6 3.6h-30.4a3.6 3.6 0 0 1-3.6-3.6V155.3a3.6 3.6 0 0 1 3.6-3.6Z" fill="var(--cros-sys-illo-color1-1)"/><path d="M46.605 172h42.8c2.3 0 4.1-1.3 4.1-3.1v-8.6a3.1 3.1 0 0 0-1.2-2.2 4.894 4.894 0 0 0-2.9-.9c-9.1 2.4-22.8 4.7-37.6 1.4l-5.2-1.4c-2.3 0-4.1 1.4-4.1 3.1v8.6c0 1.8 1.8 3.1 4.1 3.1ZM130.905 172h42.8c2.3 0 4.1-1.3 4.1-3.1v-8.6a3.099 3.099 0 0 0-1.2-2.2 4.893 4.893 0 0 0-2.9-.9c-9.1 2.4-22.8 4.7-37.6 1.4l-5.2-1.4c-2.3 0-4.1 1.4-4.1 3.1v8.6c0 1.8 1.8 3.1 4.1 3.1Z" fill="var(--cros-sys-illo-base)"/><path d="M46.605 172h42.8c2.3 0 4.1-1.3 4.1-3.1v-8.6a3.1 3.1 0 0 0-1.2-2.2 4.894 4.894 0 0 0-2.9-.9c-9.1 2.4-22.8 4.7-37.6 1.4l-5.2-1.4c-2.3 0-4.1 1.4-4.1 3.1v8.6c0 1.8 1.8 3.1 4.1 3.1ZM130.905 172h42.8c2.3 0 4.1-1.3 4.1-3.1v-8.6a3.099 3.099 0 0 0-1.2-2.2 4.893 4.893 0 0 0-2.9-.9c-9.1 2.4-22.8 4.7-37.6 1.4l-5.2-1.4c-2.3 0-4.1 1.4-4.1 3.1v8.6c0 1.8 1.8 3.1 4.1 3.1Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M41.505 160.3v4.7h-2.15v8.1h-35.2a1 1 0 0 0 0 2h208.3a1 1 0 0 0 0-2h-31.5V165h-2.15v-4.742l-.003-.041a4.092 4.092 0 0 0-1.588-2.91l-.015-.012-.016-.011a5.898 5.898 0 0 0-3.492-1.084l-.123.002-.118.031c-9.019 2.379-22.533 4.64-37.106 1.396l-5.307-1.429h-.132c-2.584 0-5.1 1.613-5.1 4.1v4.7h-2.15v8.1h-27V165h-2.15v-4.742l-.004-.041a4.102 4.102 0 0 0-1.587-2.91l-.015-.012-.016-.011a5.897 5.897 0 0 0-3.492-1.084l-.123.002-.118.031c-9.019 2.379-22.533 4.64-37.106 1.396l-5.307-1.429h-.132c-2.584 0-5.1 1.613-5.1 4.1Zm48.03-2.1c-9.178 2.408-22.997 4.71-37.948 1.376l-.021-.005-5.088-1.369c-1.934.048-2.973 1.204-2.973 2.098v4.7h49v-4.654a2.104 2.104 0 0 0-.795-1.442 3.902 3.902 0 0 0-2.176-.704Zm87.27 6.8h-49v-4.7c0-.894 1.039-2.05 2.974-2.098l5.087 1.369.021.005c14.951 3.334 28.77 1.032 37.947-1.376a3.901 3.901 0 0 1 2.176.704 2.1 2.1 0 0 1 .795 1.442V165Z" fill="var(--cros-sys-illo-color1)"/>
      </g>
      <g id="switch-access-setup-guide-choose-3-switches" viewBox="0 0 217 216" fill="none">
        <path d="M48.105 50.7h-23.6c-9.775 0-17.7 7.924-17.7 17.7v23.57c0 9.775 7.925 17.7 17.7 17.7h23.6c9.775 0 17.7-7.925 17.7-17.7V68.4c0-9.776-7.925-17.7-17.7-17.7ZM120.105 50.7h-23.6c-9.775 0-17.7 7.924-17.7 17.7v23.57c0 9.775 7.924 17.7 17.7 17.7h23.6c9.775 0 17.7-7.925 17.7-17.7V68.4c0-9.776-7.925-17.7-17.7-17.7ZM168.505 50.7h23.6c9.775 0 17.7 7.924 17.7 17.7v23.57c0 9.775-7.925 17.7-17.7 17.7h-23.6c-9.776 0-17.7-7.925-17.7-17.7V68.4c0-9.776 7.924-17.7 17.7-17.7Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M123.699 151.7h-30.4a3.6 3.6 0 0 0-3.6 3.6v10.11a3.6 3.6 0 0 0 3.6 3.6h30.4a3.6 3.6 0 0 0 3.6-3.6V155.3a3.6 3.6 0 0 0-3.6-3.6ZM194.305 151.7h-30.4a3.6 3.6 0 0 0-3.6 3.6v10.11a3.6 3.6 0 0 0 3.6 3.6h30.4a3.6 3.6 0 0 0 3.6-3.6V155.3a3.6 3.6 0 0 0-3.6-3.6ZM22.205 151.7h30.4a3.6 3.6 0 0 1 3.6 3.6v10.11a3.6 3.6 0 0 1-3.6 3.6h-30.4a3.6 3.6 0 0 1-3.6-3.6V155.3a3.6 3.6 0 0 1 3.6-3.6Z" fill="var(--cros-sys-illo-color1-1)"/><path d="M34.847 71.9a3 3 0 0 0-4.285-4.2l-9.9 10.1a3 3 0 0 0-.049 4.148l10 10.7a3 3 0 1 0 4.384-4.096L30.089 83.3h19.616a3 3 0 1 0 0-6h-20.15l5.292-5.4ZM184.347 67.7a3 3 0 1 0-4.284 4.2l5.293 5.4h-20.151a3 3 0 1 0 0 6h19.544c-1.627 1.75-3.238 3.508-4.84 5.256l-.015.017a2.999 2.999 0 1 0 4.422 4.054c3.305-3.605 6.576-7.173 9.941-10.637a3 3 0 0 0-.01-4.19l-9.9-10.1Z" fill="var(--cros-sys-illo-color1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M96.505 80.2c0-6.627 5.373-12 12-12s12 5.373 12 12-5.373 12-12 12-12-5.373-12-12Zm12-6a6 6 0 1 0 0 12 6 6 0 0 0 0-12Z" fill="var(--cros-sys-illo-color1)"/><path d="M16.105 172h42.8c2.2 0 4.1-1.4 4.1-3.1v-8.6a2.896 2.896 0 0 0-1.2-2.2 4.894 4.894 0 0 0-2.9-.9c-9.1 2.4-22.8 4.6-37.6 1.4-.736-.155-1.337-.4-1.93-.642-.94-.383-1.86-.758-3.27-.758-2.3 0-4.1 1.4-4.1 3.1v8.6c0 1.7 1.8 3.1 4.1 3.1ZM129.899 172h-42.8c-2.3 0-4.1-1.3-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1l5.2 1.4c14.8 3.3 28.5 1 37.6-1.4a4.895 4.895 0 0 1 2.9.9 3.103 3.103 0 0 1 1.2 2.2v8.6c0 1.8-1.8 3.1-4.1 3.1ZM200.605 172h-42.8c-2.3 0-4.1-1.4-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1 1.409 0 2.331.376 3.27.758.593.242 1.194.487 1.93.642 14.8 3.2 28.5 1 37.6-1.4a4.907 4.907 0 0 1 2.9.9 2.904 2.904 0 0 1 1.2 2.2v8.6c0 1.7-1.9 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-base)"/><path d="M16.105 172h42.8c2.2 0 4.1-1.4 4.1-3.1v-8.6a2.896 2.896 0 0 0-1.2-2.2 4.894 4.894 0 0 0-2.9-.9c-9.1 2.4-22.8 4.6-37.6 1.4-.736-.155-1.337-.4-1.93-.642-.94-.383-1.86-.758-3.27-.758-2.3 0-4.1 1.4-4.1 3.1v8.6c0 1.7 1.8 3.1 4.1 3.1ZM129.899 172h-42.8c-2.3 0-4.1-1.3-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1l5.2 1.4c14.8 3.3 28.5 1 37.6-1.4a4.895 4.895 0 0 1 2.9.9 3.103 3.103 0 0 1 1.2 2.2v8.6c0 1.8-1.8 3.1-4.1 3.1ZM200.605 172h-42.8c-2.3 0-4.1-1.4-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1 1.409 0 2.331.376 3.27.758.593.242 1.194.487 1.93.642 14.8 3.2 28.5 1 37.6-1.4a4.907 4.907 0 0 1 2.9.9 2.904 2.904 0 0 1 1.2 2.2v8.6c0 1.7-1.9 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M64.005 165v-4.726l-.001-.027a3.898 3.898 0 0 0-1.614-2.958l-.007-.005a5.897 5.897 0 0 0-3.492-1.084l-.123.002-.118.031c-9.017 2.378-22.545 4.544-37.134 1.39l-.005-.002c-.64-.134-1.136-.336-1.712-.57a41.42 41.42 0 0 0-.583-.234c-.841-.325-1.794-.617-3.111-.617-2.584 0-5.1 1.613-5.1 4.1v4.7h-2.2v8.1H4.399a1 1 0 0 0 0 2h208.3a1 1 0 0 0 0-2h-4.894V165h-2.1v-4.726l-.001-.026a3.909 3.909 0 0 0-1.614-2.959l-.007-.005a5.905 5.905 0 0 0-3.492-1.084l-.123.002-.118.031c-9.017 2.378-22.545 4.544-37.134 1.39l-.005-.001c-.64-.135-1.136-.337-1.711-.571a33.947 33.947 0 0 0-.584-.233c-.841-.326-1.794-.618-3.111-.618-2.584 0-5.1 1.613-5.1 4.1v4.7h-2.2v8.1h-13.306V165h-2.2v-4.742l-.004-.041a4.098 4.098 0 0 0-1.587-2.91l-.015-.012-.016-.011a5.898 5.898 0 0 0-3.492-1.084l-.123.002-.118.031c-9.019 2.379-22.533 4.64-37.106 1.396L87.23 156.2H87.1c-2.584 0-5.1 1.613-5.1 4.1v4.7h-2.1v8.1H66.105V165h-2.1Zm-4.97-6.8c-9.184 2.409-22.996 4.608-37.939 1.378-.832-.176-1.54-.465-2.143-.711-.16-.065-.313-.128-.46-.184-.708-.275-1.405-.483-2.388-.483-2.016 0-3.1 1.187-3.1 2.1v4.7h49v-4.671a1.902 1.902 0 0 0-.782-1.415 3.894 3.894 0 0 0-2.189-.714Zm144.67 6.8h-49v-4.7c0-.913 1.084-2.1 3.1-2.1.983 0 1.68.208 2.389.483.146.056.299.119.459.184.603.246 1.311.536 2.143.711 14.942 3.23 28.755 1.031 37.938-1.378a3.899 3.899 0 0 1 2.189.714 1.902 1.902 0 0 1 .782 1.415V165Zm-73.677-6.8c-9.177 2.408-22.996 4.71-37.947 1.376l-.021-.005-5.088-1.369C85.038 158.25 84 159.406 84 160.3v4.7h49v-4.654a2.1 2.1 0 0 0-.795-1.442 3.901 3.901 0 0 0-2.176-.704Z" fill="var(--cros-sys-illo-color1)"/>
      </g>
      <g id="switch-access-setup-guide-closing" viewBox="0 0 217 216" fill="none">
        <path d="M165.023 79.312a75.104 75.104 0 0 0-94.711-24.448 75.1 75.1 0 1 0 108.211 67.448 74.812 74.812 0 0 0-13.5-43Z" fill="var(--cros-sys-illo-color1-2)"/><path d="m130.808 46.332 5.125-3.834a1.4 1.4 0 0 0 .282-1.96l-3.822-5.108a1.4 1.4 0 0 0-1.959-.283l-5.125 3.834a1.4 1.4 0 0 0-.282 1.96l3.821 5.108a1.4 1.4 0 0 0 1.96.283Z" fill="var(--cros-sys-illo-color4)"/><path d="m119.823 30.012 2.7-2.7a2.397 2.397 0 0 0 .6-2.3l-1-3.7a2.201 2.201 0 0 0-1.6-1.6l-3.7-1a2.402 2.402 0 0 0-2.3.6l-2.7 2.7a2.204 2.204 0 0 0-.6 2.3l.9 3.7a2.493 2.493 0 0 0 1.7 1.6l3.7 1a2.398 2.398 0 0 0 2.3-.6Z" fill="var(--cros-sys-illo-color5)"/><path d="m132.823 63.912-7.5 6a1.703 1.703 0 0 1-2.324-.239 1.69 1.69 0 0 1-.376-.761l-1.5-9.5a1.697 1.697 0 0 1 1.368-1.847c.277-.054.563-.038.832.047l9 3.4a1.81 1.81 0 0 1 1.002 1.32 1.796 1.796 0 0 1-.502 1.58ZM51.671 91.497a9.1 9.1 0 0 0-3.7-12.3l-18.8-10a9.1 9.1 0 0 0-12.3 3.7v0a9.098 9.098 0 0 0 3.8 12.3l18.7 10.1a9.1 9.1 0 0 0 12.3-3.8Z" stroke="var(--cros-sys-illo-base)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M51.671 91.497a9.1 9.1 0 0 0-3.7-12.3l-18.8-10a9.1 9.1 0 0 0-12.3 3.7v0a9.098 9.098 0 0 0 3.8 12.3l18.7 10.1a9.1 9.1 0 0 0 12.3-3.8Z" stroke="var(--cros-sys-illo-color3)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M107.123 75.912a3.995 3.995 0 0 1-1.6 2.8 3.302 3.302 0 0 1-3.8.3M126.623 123.312a28.303 28.303 0 0 0-.8 3.9c-.7 4.7.3 7.1.1 11.7a32.128 32.128 0 0 1-1 6.2M90.178 129.512c1.1 5.2 2.1 10.4 3.1 15.6" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M160.723 80.112a14.482 14.482 0 0 0-3.2 3.7c-4.2 7.1 1 16.4 1.5 17.3" stroke="var(--cros-sys-illo-color1-1)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M160.723 80.112a32.915 32.915 0 0 0 6-5.6c4.4-4.9 5.9-9.3 8.6-9.1a2.837 2.837 0 0 1 2.2 1.3c1 1.7-.2 4.7-3.3 7.4" stroke="var(--cros-sys-illo-base)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M192.555 65.157c-.541-.81-1.251-1.307-2.08-1.459-.794-.146-1.563.049-2.214.345-1.275.58-2.419 1.694-3.096 2.515a26.207 26.207 0 0 1-8.153 6.065 10.465 10.465 0 0 0 1.316-2.19c.626-1.445.785-2.99.056-4.228a3.836 3.836 0 0 0-2.995-1.79c-.986-.072-1.824.292-2.547.858-.7.548-1.344 1.324-1.983 2.177-.369.493-.744 1.023-1.141 1.582-1.021 1.44-2.183 3.078-3.739 4.812a31.907 31.907 0 0 1-5.842 5.458 1 1 0 0 0 1.171 1.62 33.885 33.885 0 0 0 6.171-5.756c1.634-1.821 2.9-3.606 3.934-5.064.378-.533.725-1.022 1.048-1.454.624-.834 1.136-1.426 1.614-1.8.453-.355.814-.466 1.174-.439l.014.001c.56.034 1.101.35 1.405.822.265.463.319 1.265-.176 2.408-.489 1.13-1.458 2.44-2.926 3.718a.997.997 0 0 0-.342.798c-.778.24-1.571.43-2.374.57a.999.999 0 1 0 .345 1.97 21.503 21.503 0 0 0 5.329-1.668 28.204 28.204 0 0 0 10.172-7.182c.586-.715 1.506-1.58 2.392-1.982.434-.198.774-.245 1.026-.199.206.038.461.157.733.538.054.151.06.422-.088.874-.131.403-.327.788-.517 1.162l-.093.183c-1.172 1.866-3.79 3.847-6.693 5.596-2.875 1.732-5.858 3.138-7.537 3.879a1 1 0 0 0 .807 1.83c1.721-.76 4.788-2.204 7.763-3.996 2.789-1.68 6.113-3.787 7.713-6.743.115-.212.282-.39.486-.519a1.424 1.424 0 0 1 1.883.37c.264.493.286 1.065.101 1.729-.194.692-.596 1.409-1.062 2.062-3.631 5.063-9.006 8.16-15.258 9.92a1 1 0 1 0 .541 1.925c6.41-1.803 12.128-5.006 16.09-10.334a.992.992 0 0 0 .287-.299c.527-.841 1.781-.921 2.416-.174.182.361.198.826-.001 1.432-.212.646-.636 1.342-1.149 1.994l-.023.03c-3.525 4.86-8.896 7.864-15.065 9.626a1 1 0 1 0 .549 1.923c6.174-1.763 11.792-4.779 15.66-9.742.246.081.473.216.664.394.485.503.562 1.048.389 1.692-.19.71-.68 1.47-1.253 2.151l-.004.005c-4.233 5.099-11.823 9.304-18.364 10.967a.994.994 0 0 0-.388.188c-.743.59-.152 2.162-.04 2.845.198 1.217.472 2.984.771 5.174a1 1 0 1 0 1.981-.27 202.91 202.91 0 0 0-.947-6.237c6.644-1.88 14.157-6.128 18.524-11.387.646-.767 1.35-1.794 1.651-2.916.318-1.183.188-2.51-.904-3.625l-.019-.018-.006-.006a3.8 3.8 0 0 0-.862-.617c.299-.487.559-1.01.735-1.547.315-.96.395-2.078-.194-3.108a1.028 1.028 0 0 0-.076-.114 3.464 3.464 0 0 0-2.731-1.346l.014-.05c.285-1.02.314-2.186-.304-3.284a.956.956 0 0 0-.042-.07c-.758-1.122-2.101-1.65-3.373-1.448a2.55 2.55 0 0 0-.262-1.04.913.913 0 0 0-.062-.107Z" fill="var(--cros-sys-illo-color1-1)"/><path d="m134.728 100.112 61.277.202a1.929 1.929 0 0 1 2.047 1.679c.041.323-.001.652-.122.955l-13.363 41.295a2.001 2.001 0 0 1-1.996 1.869h-72.8a2 2 0 0 1 0-4h8.252l13.058-39.367a4.046 4.046 0 0 1 3.647-2.633Z" fill="var(--cros-sys-illo-color1)"/><path d="M144.292 146.627c1.7-2 5.16-5.042 6.96-7.042 2.761-3.068-.429-5.272-3.729-4.138-7.393 3.242-18.898 11.589-20.332 13.79-1.434 2.201 8.671 22.526 8.671 22.526 11.661-4.69 40.397-7.481 36.461-17.151 0-1.481 2.517-2.394 2.517-5.375-.172-1.189-1.201-2.382-1.295-3.555.861-1.938.632-3.199 0-4.495-.582-1.193-1.837-.899-2.926-1.893-.237-2.415 1.183-5.066-3.084-5.328-4.267-.262-9.133 6.765-11.839 7.684-2.706.918-11.404 4.977-11.404 4.977Z" fill="var(--cros-sys-illo-base)"/><path d="M144.292 146.627c1.7-2 5.16-5.042 6.96-7.042 2.761-3.068-.429-5.272-3.729-4.138-7.393 3.242-18.898 11.589-20.332 13.79-1.434 2.201 8.671 22.526 8.671 22.526 11.661-4.69 40.397-7.481 36.461-17.151 0-1.481 2.517-2.394 2.517-5.375-.172-1.189-1.201-2.382-1.295-3.555.861-1.938.632-3.199 0-4.495-.582-1.193-1.837-.899-2.926-1.893-.237-2.415 1.183-5.066-3.084-5.328-4.267-.262-9.133 6.765-11.839 7.684-2.706.918-11.404 4.977-11.404 4.977Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M162.723 137.303a14.469 14.469 0 0 1 3.885-2.419c1.049-.24 2.067.084 2.638.64.283.276.443.594.48.926.037.329-.038.753-.37 1.262l-.022.035a10.297 10.297 0 0 1-1.744 2.204l-.014.014c-6.619 6.618-11.303 9.833-19.949 12.781a.914.914 0 1 0 .591 1.732c7.861-2.68 12.61-5.616 18.241-10.882a.915.915 0 0 0 .322-.159l2.589-1.992c.745-.537 1.673-.797 2.414-.698.36.048.659.177.89.379.227.198.437.508.559 1 .277 1.189-.487 2.565-1.731 3.713l-.015.014-.011.011c-1 .999-2.093 1.899-3.265 2.689l-.013.009a73.26 73.26 0 0 1-9.676 5.727c-1.311.631-2.679 1.169-4.087 1.705l-.712.27c-1.176.445-2.378.9-3.561 1.407a.914.914 0 1 0 .721 1.682c1.143-.49 2.301-.928 3.477-1.373l.726-.275c1.415-.539 2.846-1.101 4.234-1.769l.007-.003a75.2 75.2 0 0 0 9.914-5.867 23.95 23.95 0 0 0 3.072-2.463.901.901 0 0 0 .21.024c.491 0 .9.272 1.195.781.299.516.407 1.171.314 1.689a5.686 5.686 0 0 1-2.228 3.061l-.03.022c-4.493 3.369-9.292 5.079-14.966 7.101-1.225.437-2.491.887-3.803 1.373a.915.915 0 1 0 .635 1.716c1.261-.466 2.493-.905 3.7-1.334 5.07-1.804 9.676-3.442 13.968-6.289a.95.95 0 0 0 .025.181 3.98 3.98 0 0 1-1.293 3.978 12.49 12.49 0 0 1-4.557 2.323 1.048 1.048 0 0 0-.074.023c-8.135 2.965-10.915 3.574-15.475 4.574-2.021.443-4.392.963-7.733 1.798a.91.91 0 0 0-.101.032l-6.9 2.6a.915.915 0 1 0 .645 1.712l6.851-2.581a245.685 245.685 0 0 1 7.568-1.759c4.609-1.011 7.511-1.647 15.736-4.643a14.313 14.313 0 0 0 5.197-2.661l.016-.013a5.817 5.817 0 0 0 1.899-5.815.915.915 0 0 0-.54-.63l.285-.211a7.516 7.516 0 0 0 2.944-4.088.65.65 0 0 0 .019-.076c.195-.977.001-2.103-.518-3-.341-.59-.853-1.122-1.523-1.427.932-1.193 1.619-2.726 1.234-4.362l-.002-.009c-.201-.814-.589-1.47-1.134-1.946-.542-.473-1.191-.725-1.851-.814a4.593 4.593 0 0 0-1.282.018l.157-.257c.519-.803.734-1.64.644-2.446-.09-.808-.478-1.503-1.021-2.033-1.069-1.043-2.781-1.501-4.423-1.091a.849.849 0 0 0-.129.043 16.28 16.28 0 0 0-4.437 2.744 59.896 59.896 0 0 1-13.441 8.217l.319-.313.011-.011c1.267-1.242 2.551-2.501 3.463-3.463.96-1.013 1.551-2.358 1.389-3.63a2.912 2.912 0 0 0-.883-1.764c-.511-.485-1.197-.797-2.015-.937a5.424 5.424 0 0 0-2.766.241l-.009.004a24.642 24.642 0 0 0-3.736 1.763c-5.111 2.907-12.85 7.648-18.223 12.019a.915.915 0 1 0 1.155 1.419c5.252-4.272 12.887-8.955 17.976-11.849l.006-.004a22.808 22.808 0 0 1 3.456-1.632 3.588 3.588 0 0 1 1.828-.158l.004.001c.543.092.87.276 1.062.459.187.178.295.4.33.67.073.572-.197 1.395-.903 2.14-.885.934-2.146 2.171-3.426 3.426l-.011.01c-1.267 1.242-2.551 2.501-3.463 3.464a.915.915 0 0 0 1.1 1.434.938.938 0 0 0 .177-.045 61.739 61.739 0 0 0 17.788-10.069Z" fill="var(--cros-sys-illo-color1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M87.887 72.614a11.15 11.15 0 0 1-6.664 2.198c-6.186 0-11.2-5.014-11.2-11.2 0-6.186 5.014-11.2 11.2-11.2 6.185 0 11.2 5.014 11.2 11.2 0 1.16-.177 2.279-.504 3.33a12.248 12.248 0 0 1 7.604-2.63c6.793 0 12.3 5.507 12.3 12.3 0 3.738-1.668 7.087-4.3 9.342l2.018 9.033c5.22.55 19.544 2.884 31.295 14.924a50.004 50.004 0 0 1 12.754 22.448.999.999 0 1 1-1.935.506 47.991 47.991 0 0 0-12.245-21.551l-.003-.004c-11.21-11.488-24.887-13.778-29.989-14.325a13.615 13.615 0 0 1-1.073 2.288c-.851 1.432-2.228 3.064-4.369 3.874-2.163.819-4.872.554-7.337-.591a12.906 12.906 0 0 1-5.82-5.438c-5.013 1.087-17.254 4.55-25.901 15.9-11.226 14.74-10.352 34.895-2.934 47.486l.002.003c11.556 19.742 43.435 28.482 72.969 13.24l-11.301-27.824-30.315.489a1 1 0 0 1-.032-2l31-.5a.999.999 0 0 1 .942.624l11.9 29.3a1 1 0 0 1-.457 1.259c-30.443 16.182-64.092 7.502-76.432-13.577-7.781-13.209-8.706-34.253 3.067-49.712 9.293-12.197 22.5-15.688 27.431-16.72a1.001 1.001 0 0 1 .31-.141l3.304-7.16c-4.22-1.95-7.15-6.22-7.15-11.173 0-1.4.234-2.744.665-3.998Zm1.394 5.102c.551 5.17 4.926 9.196 10.242 9.196 5.688 0 10.3-4.612 10.3-10.3 0-5.18-3.824-9.467-8.802-10.192a18.102 18.102 0 0 1-5.046 7.634c-2.096 1.88-4.11 2.984-6.694 3.662Zm8.2 23.026a10.902 10.902 0 0 1-4.832-4.45l3.582-7.761.024-.058c1.04.286 2.136.439 3.268.439 2.275 0 4.405-.618 6.233-1.695l1.931 8.647a11.758 11.758 0 0 1-1.062 2.387c-.723 1.218-1.797 2.436-3.356 3.026-1.537.581-3.678.446-5.788-.535Z" fill="var(--cros-sys-illo-color1)"/><path d="M160.16 79.165a14.476 14.476 0 0 0-3.569 4c-4.487 7.6.917 17.3 1.529 18.3a.916.916 0 0 0 .379.391c.894.487 1.926-.327 1.457-1.291-.612-.9-5.507-9.7-1.632-16.2a12.476 12.476 0 0 1 3.06-3.5l2.957-2.4-1.224-1.6-2.957 2.3Z" fill="var(--cros-sys-illo-color1)"/><path d="m34.032 93.55 4.864 2.627.008.004a10.1 10.1 0 0 0 13.65-4.215 10.1 10.1 0 0 0-4.108-13.649l-4.23-2.25a75.25 75.25 0 0 0-1.224 1.615l4.504 2.395.003.002a8.1 8.1 0 0 1 3.29 10.947l-.002.005a8.103 8.103 0 0 1-7.919 4.285 8.1 8.1 0 0 1-3.026-.9l-5.018-2.711a73.62 73.62 0 0 0-.792 1.845Z" fill="var(--cros-sys-illo-base)"/><path d="M166.175 49.216h-.139a.761.761 0 0 1-.763-.208l-6.655-5.2a1.04 1.04 0 1 1 1.247-1.664l5.824 4.645 7.696-10.469a12.064 12.064 0 0 0-16.362-.277l-.139.138a12.07 12.07 0 0 0-3.734 13.142 12.054 12.054 0 0 0 6.26 7.046 12.064 12.064 0 0 0 13.49-2.161l.139-.139a11.994 11.994 0 0 0 1.733-16.154L166.729 48.8c-.135.194-.33.34-.554.416Z" fill="var(--cros-sys-illo-color2)"/><path d="M177.476 32.507a1.108 1.108 0 0 0-1.456.208l-2.635 3.605.694.763.693.831 2.912-3.951a1.112 1.112 0 0 0-.208-1.456Z" fill="var(--cros-sys-illo-color1-1)"/>
      </g>
      <g id="switch-access-setup-guide-start-pairing" viewBox="0 0 217 216" fill="none">
        <path d="M4.105 149.598h208.4" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round"/><path d="m135.605 76.898 3.8-1.1a1.996 1.996 0 0 0 1.4-1.4l.9-3.9a1.899 1.899 0 0 0-.5-1.9l-2.9-2.8a2 2 0 0 0-2-.4l-3.8 1.1a2.1 2.1 0 0 0-1.4 1.5l-.9 3.8a2 2 0 0 0 .6 1.9l2.9 2.8a1.9 1.9 0 0 0 1.9.4Z" fill="var(--cros-sys-illo-color6)"/><path d="M40.405 102.299a3.4 3.4 0 1 0-.001-6.801 3.4 3.4 0 0 0 0 6.801Z" fill="var(--cros-sys-illo-color5)"/><path d="M74.705 59.198a7.593 7.593 0 0 0-.9 1.8l-1 1.9a7.8 7.8 0 0 1-3.9 3.5c-2.4.9-4.9 1.2-6.3 3.6a6.3 6.3 0 0 0-.1 6.1l.2.3a6.101 6.101 0 0 0 9.2 1.2l2.2-2.4a7.3 7.3 0 0 1 5-2.3h4.2a9 9 0 0 0 4-1.8 8.7 8.7 0 0 0-10.1-14.1 9.5 9.5 0 0 0-2.5 2.2v0Z" stroke="var(--cros-sys-illo-color3)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M58.505 90.198c6.296 0 11.4-5.103 11.4-11.4 0-6.296-5.104-11.4-11.4-11.4s-11.4 5.104-11.4 11.4 5.104 11.4 11.4 11.4Z" fill="var(--cros-sys-illo-color2)"/><path d="M69.855 79.872a7.099 7.099 0 0 1-7.985-2.923l-.197-.296a1.01 1.01 0 0 1-.05-.085 7.3 7.3 0 0 1 .115-7.068l.003-.005a6.27 6.27 0 0 1 .989-1.288c.673.269 1.314.6 1.916.986-.46.337-.854.755-1.176 1.307a5.3 5.3 0 0 0-.104 5.087l.177.266a5.1 5.1 0 0 0 6.314 1.892 11.538 11.538 0 0 1-.002 2.127Z" fill="var(--cros-sys-illo-base)"/><path d="M198.905 82.698h-84.4a4.302 4.302 0 0 0-4.1 3.7l-5 60.1h91.9l5.1-60.1c.113-1.981-1.515-3.703-3.5-3.7Z" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M195.105 149.598h-112.4c-.69 0-1.351-.364-1.838-1.012-.488-.648-.762-1.527-.762-2.444 0-.458.137-.897.38-1.221.245-.324.575-.507.92-.507h115c.345 0 .675.183.919.507s.381.763.381 1.221c0 .917-.274 1.796-.762 2.444-.487.648-1.148 1.012-1.838 1.012Z" fill="var(--cros-sys-illo-base)"/><path d="M198.122 87.335h-83.495c-.773-.055-1.506.516-1.562 1.301l-4.393 52.23h86.161l4.642-52.23c.069-.755-.615-1.363-1.353-1.3Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M154.908 86.603a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z" fill="var(--cros-sys-illo-color1-1)"/><path d="M188.605 146.959a1 1 0 0 1 1-1h3.7a1 1 0 1 1 0 2h-3.7a1 1 0 0 1-1-1ZM187.714 146.959a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z" fill="var(--cros-sys-illo-color1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M82.705 150.598c-1.061 0-1.999-.561-2.638-1.411-.634-.843-.962-1.941-.962-3.044 0-.646.19-1.304.582-1.823.395-.525 1-.905 1.718-.905h115c.717 0 1.323.38 1.718.905.391.519.582 1.177.582 1.823 0 1.103-.328 2.201-.962 3.044-.639.85-1.577 1.411-2.638 1.411h-112.4Zm113.439-2.613c-.336.447-.721.613-1.039.613h-27.3v-3a.996.996 0 0 0-.017-.183h28.615c.002 0 .008.002.017.007.02.011.059.039.105.1.097.128.18.35.18.621 0 .729-.22 1.389-.561 1.842Zm-30.322-2.57H81.407l-.004.001a.357.357 0 0 0-.119.106c-.096.128-.179.35-.179.621 0 .729.22 1.389.56 1.842.337.447.722.613 1.04.613h83.1v-3c0-.063.006-.124.017-.183Z" fill="var(--cros-sys-illo-color1)"/><path d="M164.674 116.502c1.778-6.728-1.932-13.543-8.286-15.221-6.355-1.68-12.947 2.414-14.724 9.142-1.778 6.728 1.932 13.543 8.286 15.222 6.354 1.678 12.947-2.415 14.724-9.143Z" fill="var(--cros-sys-illo-color1)"/><path d="M123.605 62.398a6 6 0 0 1-8.4 1.1l-11.1-8.4a5.998 5.998 0 0 1-1.1-8.4 5.898 5.898 0 0 1 8.3-1.1l11.1 8.4a6.014 6.014 0 0 1 2.34 3.952 6 6 0 0 1-1.14 4.448Z" fill="var(--cros-sys-illo-color5)"/><path d="m34.205 123.998 6.9.7a1.8 1.8 0 0 0 1.8-.8l4-5.3a1.9 1.9 0 0 0 .3-2l-2.8-6.1a2.108 2.108 0 0 0-1.6-1.1l-7-.7a2.003 2.003 0 0 0-1.8.7l-4 5.3a2.204 2.204 0 0 0-.2 2.1l2.8 6a2.003 2.003 0 0 0 1.6 1.2Z" stroke="var(--cros-sys-illo-color4)" stroke-width="2" stroke-miterlimit="10"/><path d="m146.205 110.598 4.6 5.9a.796.796 0 0 0 1.2.2l13.4-10.4" stroke="var(--cros-sys-illo-base)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="m149.109 97.8-.4-6a.992.992 0 0 0-1.016-.935.997.997 0 0 0-.484.135l-5 3.4a.997.997 0 0 0-.27 1.357.998.998 0 0 0 .37.343l5.4 2.6a.898.898 0 0 0 1.4-.9ZM50.318 131.104H25.913a2.89 2.89 0 0 0-2.89 2.89v8.116a2.89 2.89 0 0 0 2.89 2.89h24.405a2.89 2.89 0 0 0 2.89-2.89v-8.116a2.89 2.89 0 0 0-2.89-2.89Z" fill="var(--cros-sys-illo-color1-1)"/><path d="M55.376 147.4h-34.36c-1.846 0-3.291-1.124-3.291-2.489v-6.904c0-1.364 1.445-2.488 3.291-2.488 1.847 0 2.65.802 4.175 1.124 11.881 2.569 22.88.802 30.185-1.124a3.934 3.934 0 0 1 2.328.722 2.33 2.33 0 0 1 .963 1.766v6.904c0 1.365-1.525 2.489-3.291 2.489Z" fill="var(--cros-sys-illo-base)"/><path d="M55.376 147.4h-34.36c-1.846 0-3.291-1.124-3.291-2.489v-6.904c0-1.364 1.445-2.488 3.291-2.488 1.847 0 2.65.802 4.175 1.124 11.881 2.569 22.88.802 30.185-1.124a3.934 3.934 0 0 1 2.328.722 2.33 2.33 0 0 1 .963 1.766v6.904c0 1.365-1.525 2.489-3.291 2.489Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M16.922 142.406v-4.399c0-1.996 2.02-3.291 4.094-3.291 1.058 0 1.823.234 2.498.496.166.064.32.127.468.187.462.188.86.35 1.374.458l.004.001c11.712 2.532 22.572.794 29.811-1.115l.095-.026.098-.001a4.741 4.741 0 0 1 2.804.87l.005.004a3.131 3.131 0 0 1 1.296 2.375l.001.021v4.42h1.726v6.68h-46v-6.68h1.726Zm8.101-4.978c11.996 2.593 23.085.827 30.457-1.106.63.009 1.242.209 1.757.572a1.538 1.538 0 0 1 .627 1.137v4.375H18.528v-4.399c0-.733.87-1.685 2.488-1.685.79 0 1.349.167 1.918.387.117.045.24.095.37.148.483.198 1.051.43 1.72.571Z" fill="var(--cros-sys-illo-color1)"/>
      </g>

      <!-- Mouse Keys-->
      <g id="mouse-keys-primary-keyboard-cursor-control" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" rx="4" fill="var(--cros-sys-illo-color1-2)"/><rect x="6" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="25" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="44" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="63" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="82" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="101" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="120" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="139" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="158" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="177" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="196" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="215" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="234" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="253" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="6" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="24" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="42" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="60" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="78" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="96" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="114" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="132" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1)"/><rect x="150" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1)"/><rect x="168" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1)"/><rect x="186" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="204" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="222" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="240" y="15" width="29" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><path fill-rule="evenodd" clip-rule="evenodd" d="m158.05 20.539 2.622 2.76.678-.702-3.85-3.949-3.85 3.95.679.695 2.621-2.754v5.81h1.1v-5.81ZM177.275 21.503l-.098 3.805.976-.016.069-5.514-5.514.07-.012.971 3.801-.093-4.108 4.108.778.777 4.108-4.108ZM138.503 20.725l3.805.097-.016-.975-5.514-.07.069 5.515.972.012-.094-3.801 4.108 4.108.778-.778-4.108-4.108Z" fill="var(--cros-sys-illo-base)"/><rect x="6" y="33" width="29" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="38" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="56" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="74" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="92" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="110" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="128" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="146" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1)"/><rect x="164" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1-1)"/><rect x="182" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="m191.46 41.052-2.76 2.621.701.679 3.949-3.85-3.949-3.85-.696.678 2.755 2.622h-5.81v1.1h5.81ZM151.541 39.948l2.759-2.621-.701-.679-3.949 3.85 3.949 3.85.696-.678-2.754-2.622h5.809v-1.1h-5.809Z" fill="var(--cros-sys-illo-base)"/><rect x="200" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="218" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="236" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="254" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="6" y="51" width="39" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="48" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="66" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="84" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="102" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="120" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="138" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="156" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1)"/><rect x="174" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1)"/><rect x="192" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1)"/><rect x="210" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="228" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="246" y="51" width="23" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><path fill-rule="evenodd" clip-rule="evenodd" d="m161.726 59.497.097-3.805-.975.016-.07 5.514 5.514-.07.013-.971-3.802.094 4.108-4.108-.777-.778-4.108 4.108ZM200.497 60.275l-3.805-.097.016.975 5.515.07-.07-5.515-.972-.012.094 3.801-4.108-4.108-.778.778 4.108 4.108ZM180.95 60.461l-2.621-2.76-.679.702 3.85 3.949 3.85-3.95-.678-.695-2.622 2.754v-5.81h-1.1v5.81Z" fill="var(--cros-sys-illo-base)"/><rect x="6" y="69" width="48" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="57" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="75" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="93" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="111" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="129" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="147" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="165" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1-1)"/><rect x="183" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1-1)"/><rect x="201" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1-1)"/><rect x="219" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1-1)"/><rect x="237" y="69" width="32" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="6" y="87" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="24" y="87" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="42" y="87" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="60" y="87" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="78" y="87" width="103" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="184" y="87" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="202" y="87" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="220" y="96" width="15" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="237" y="87" width="15" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="237" y="96" width="15" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="254" y="96" width="15" height="6" rx="1" fill="var(--cros-sys-illo-base)"/>
      </g>
      <g id="mouse-keys-primary-keyboard-press-mouse-button" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-primary-keyboard-change-mouse-button" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-primary-keyboard-double-click" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-primary-keyboard-hold-mouse-button" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-primary-keyboard-release-mouse-button" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-left-primary-keyboard-cursor-control" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><path fill="var(--cros-sys-illo-base)" fill-rule="evenodd" d="m50.05 20.539 2.622 2.76.678-.702-3.85-3.949-3.85 3.95.679.695 2.621-2.754v5.81h1.1v-5.81ZM69.275 21.503l-.098 3.805.976-.016.07-5.514-5.515.07-.012.971 3.8-.093-4.107 4.108.778.777 4.108-4.108ZM30.503 20.725l3.805.097-.016-.975-5.514-.07.07 5.515.971.012-.093-3.801 4.108 4.108.777-.778-4.108-4.108Z" clip-rule="evenodd"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><path fill="var(--cros-sys-illo-base)" fill-rule="evenodd" d="m83.46 41.052-2.76 2.621.701.679 3.95-3.85-3.95-3.85-.696.678 2.755 2.622h-5.81v1.1h5.81ZM43.54 39.948l2.76-2.621-.701-.679-3.949 3.85 3.949 3.85.696-.678-2.754-2.622h5.81v-1.1h-5.81Z" clip-rule="evenodd"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><path fill="var(--cros-sys-illo-base)" fill-rule="evenodd" d="m53.726 59.497.097-3.805-.975.016-.07 5.514 5.514-.07.013-.971-3.802.094 4.108-4.108-.777-.778-4.108 4.108ZM92.497 60.275l-3.805-.097.016.975 5.514.07-.07-5.515-.971-.012.094 3.801-4.109-4.108-.777.778 4.108 4.108ZM72.95 60.461l-2.621-2.76-.679.702 3.85 3.949 3.85-3.95-.678-.695-2.622 2.754v-5.81h-1.1v5.81Z" clip-rule="evenodd"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-left-primary-keyboard-press-mouse-button" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-left-primary-keyboard-change-mouse-button" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-left-primary-keyboard-double-click" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-left-primary-keyboard-hold-mouse-button" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-left-primary-keyboard-release-mouse-button" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-num-keypad-cursor-control" viewBox="0 0 352 108" fill="none">
       <rect width="352" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="40" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="58" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="76" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="94" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="112" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="130" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="148" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="166" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="220" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="238" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="49" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="67" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="85" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="103" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="121" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="139" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="157" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="175" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="193" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="211" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="229" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="277" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="295" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="331" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="33" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="295" y="33" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="313" y="33" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="33" x="331" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="51" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="295" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="51" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="277" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="295" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="313" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="33" x="331" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="33" height="15" x="277" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/><path fill="var(--cros-sys-illo-base)" fill-rule="evenodd" d="m303.05 38.539 2.622 2.76.678-.702-3.85-3.949-3.85 3.95.679.695 2.621-2.754v5.81h1.1v-5.81ZM322.275 39.503l-.098 3.805.976-.016.069-5.514-5.514.07-.012.971 3.801-.094-4.108 4.108.778.778 4.108-4.108ZM283.503 38.725l3.805.097-.016-.975-5.514-.07.069 5.515.972.012-.094-3.801 4.108 4.108.778-.778-4.108-4.108ZM322.46 59.052l-2.76 2.621.701.679 3.949-3.85-3.949-3.85-.696.678 2.755 2.622h-5.81v1.1h5.81ZM282.54 57.948l2.76-2.621-.701-.679-3.949 3.85 3.949 3.85.696-.678-2.755-2.622h5.81v-1.1h-5.81ZM301.95 78.461l-2.621-2.76-.679.702 3.85 3.949 3.85-3.95-.678-.695-2.622 2.754v-5.81h-1.1v5.81ZM321.497 78.275l-3.805-.097.016.975 5.514.07-.069-5.515-.972-.012.094 3.801-4.108-4.108-.778.778 4.108 4.108ZM282.725 77.497l.098-3.805-.976.016-.069 5.514 5.514-.07.012-.971-3.801.094 4.108-4.109-.778-.777-4.108 4.108Z" clip-rule="evenodd"/>
      </g>
      <g id="mouse-keys-num-keypad-press-mouse-button" viewBox="0 0 352 108" fill="none">
        <rect width="352" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="40" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="58" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="76" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="94" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="112" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="130" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="148" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="166" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="220" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="238" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="49" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="67" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="85" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="103" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="121" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="139" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="157" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="175" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="193" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="211" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="229" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="277" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="295" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="331" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="51" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="313" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="33" height="15" x="277" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/>
      </g>
      <g id="mouse-keys-num-keypad-change-mouse-button" viewBox="0 0 352 108" fill="none">
        <rect width="352" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="40" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="58" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="76" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="94" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="112" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="130" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="148" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="166" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="220" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="238" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="49" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="67" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="85" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="103" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="121" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="139" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="157" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="175" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="193" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="211" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="229" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="277" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="295" y="15" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="313" y="15" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="331" y="15" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="277" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="33" height="15" x="277" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/>
      </g>
      <g id="mouse-keys-num-keypad-double-click" viewBox="0 0 352 108" fill="none">
        <rect width="352" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="40" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="58" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="76" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="94" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="112" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="130" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="148" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="166" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="220" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="238" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="49" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="67" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="85" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="103" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="121" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="139" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="157" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="175" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="193" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="211" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="229" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="277" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="295" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="331" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="33" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="277" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="33" height="15" x="277" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/>
      </g>
      <g id="mouse-keys-num-keypad-hold-mouse-button" viewBox="0 0 352 108" fill="none">
        <rect width="352" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="40" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="58" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="76" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="94" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="112" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="130" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="148" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="166" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="220" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="238" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="49" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="67" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="85" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="103" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="121" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="139" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="157" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="175" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="193" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="211" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="229" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="277" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="295" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="331" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="33" height="15" x="277" y="87" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="313" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/>
      </g>
      <g id="mouse-keys-num-keypad-release-mouse-button" viewBox="0 0 352 108" fill="none">
        <rect width="352" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="40" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="58" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="76" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="94" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="112" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="130" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="148" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="166" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="220" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="238" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="49" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="67" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="85" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="103" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="121" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="139" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="157" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="175" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="193" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="211" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="229" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="277" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="295" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="331" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="33" height="15" x="277" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="87" fill="var(--cros-sys-illo-color1)" rx="1"/>
      </g>

      <!-- Privacy section -->
      <g id="smart-privacy" viewBox="0 0 246 268" fill="none">
        <path d="m175 123-19-1.662 2.841-2.276 5.327-3.062 3.996.438 4.084 3.324L175 123Z" fill="var(--cros-sys-illo-color1)"/><path d="M166.3 130.8c-.5.3-1.5.6-2.5.7-1 .1-2-.1-2.3-.4M154.6 206.2c-1.1.4-3.6-.1-3.7-1.3-.1-.9.3-1.8 1-2.4.7-.6 1.5-1 2.3-1.3 7.2-2.8 14.1-2.7 21.7-1.6" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M176.1 195.3c-3.6-.4-7.1-.9-10.7-.8-3.6 0-7.3.6-10.6 2-1 .4-2 1-2.6 1.9-.6.9-.6 2.4.3 3" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M152.3 197.9c-.3-.9-.2-1.9.3-2.8.6-1.1 1.5-1.7 2-2 5.3-2.9 18.6-2.1 18.6-2.1 4.5.3 8.2.5 11 .8M175.7 204.9c-8.7-1.2-19.9-2-21.2 1.4-.2.6-.2 1.4.1 2.1 1.2 2.6 6.4 1.3 14.4 2 4.3.4 3.6.8 7.9 1.3 4.8.5 10.1 1.1 15.4-.2M123.1 209.6c-8.3-8.3-11.4-22.1-7.9-35.3 3.7-14 14.5-26.9 27.2-33.3M195.952 170c1.316 3.482 2.631 7.066 4.048 10.548L183 187" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M182.3 187.2c3.3 8.3 6.6 16.7 9.9 25 15.2-3 27.7-12.1 30.9-24.3 3.8-14.4-7-27-18.7-40.7-4.5-5.2-7.9-7.2-10.8-8.3-3.4-1.3-7.3-1.8-10-2.2-3-.4-5.5-.5-7.3-.6" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M195.7 169.7c.1 2.3-.7 4.2-1.2 5.8-.1.4-.3 1.1-.4 1.9-.1.6 0 1.9 0 2.5 0 1.5-.6 2.4-1.4 2.4M173.4 133.4c1.1 1.9 2.3 3.8 3.4 5.8-.1.4-1.3 5.1-5.2 6.3-1.1.3-2.1.3-2.9.2" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M186.1 176h-5c-2.3 0-4.2-1.9-4.2-4.2v-9.2h13.4v9.2c0 2.3-1.9 4.2-4.2 4.2Z" stroke="var(--cros-sys-illo-color1)" stroke-width="1.905" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M165.5 136c5.247 0 9.5-4.477 9.5-10s-4.253-10-9.5-10-9.5 4.477-9.5 10 4.253 10 9.5 10Z" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M179.232 119.532c2.7-.4 6 1.1 8.2-.2 2.3-1.3 2.7-5 4.3-7 1.6-2.1 5-3.4 5.7-6 .7-2.5-1.6-5.3-1.9-8-.4-2.7 1.1-6-.2-8.2-1.3-2.3-5-2.7-7-4.3-2.1-1.6-3.4-5-6-5.7-2.5-.7-5.3 1.6-8 1.9-2.7.4-6-1.1-8.2.2-2.3 1.3-2.7 5-4.3 7-1.6 2.1-5 3.4-5.7 6-.7 2.5 1.6 5.3 1.9 8 .4 2.7-1.1 6 .2 8.2 1.3 2.3 5 2.7 7 4.3 2.1 1.6 3.4 5 6 5.7 2.4.7 5.2-1.6 8-1.9Z" fill="var(--cros-sys-illo-color1)"/><path d="M71.8 160.6h71.4c.7 0 1.3.6 1.3 1.2L149 210H75.1l-4.4-48.2c-.1-.6.4-1.2 1.1-1.2Z" fill="var(--cros-sys-illo-color1)" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M79.4 211h82.5" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M149.4 149.6c-2.2 3.5-4.4 7-6.6 10.6M153.6 137.2c-4-4-5.8-8.4-5.4-11 .1-.9.6-2.4 1.6-3.9.7-1.1 1.2-1.3 1.6-1.4.7-.1 1.5.4 1.9 1 .9 1.4-.7 2.5-.3 4.8.3 1.8 1.5 3.1 2.9 4.5.3.3.9.9 3.1 2.5 1.6 1.1 2.6 1.5 4.5 3 2.4 2 4.6 4.5 5 7.6.5 3.2-.6 5.7-2.1 8.9-1.8 3.9-4.2 9.4-6.7 16.6" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M149.3 121c-.4-.6-1.4-.8-2.1-.6-2 .6-2.3 5.1-2.3 6.1-.3 5.8 3.2 10.8 5.7 13.6" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M145.4 122.8c-.5-.3-1.1-.3-1.6-.1-1.4.6-1.7 2.4-1.8 4-.1 5.6 2.2 10.7 5.7 15.2" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M149.6 149.3c-4.5-4.6-8.5-11.8-9.5-18.1-.1-.9-.2-1.8 0-2.7.2-.6.6-1.1 1.1-1.5M145.2 165.7c5.6 2 11.1 4.1 16.7 6.1l-13.2 28.8" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="m79.07 193.135-22.601.032c-4.601.046-8.257-3.698-8.302-8.298l-.033-22.602c-.045-4.601 3.698-8.257 8.3-8.303l22.701-.031c4.6-.045 8.257 3.698 8.302 8.299l.033 22.602c-.055 4.6-3.798 8.255-8.4 8.301Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M76 150.5a8.5 8.5 0 0 0-17 0v4h-2v-4c0-5.799 4.701-10.5 10.5-10.5S78 144.701 78 150.5h-2Z" fill="var(--cros-sys-illo-color1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M76 154v19.5a8.5 8.5 0 0 1-17 0V154h-2v19.5c0 5.799 4.701 10.5 10.5 10.5S78 179.299 78 173.5V154h-2Z" fill="var(--cros-sys-illo-base)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M69.32 167.028a3.7 3.7 0 1 0-3.134.049L65 173.1c-.3 1.1.5 2 1.6 2h2.6c1 0 1.8-1 1.5-2l-1.38-6.072Z" fill="var(--cros-sys-illo-color1)"/><path d="M66.9 213.5c24.08 0 43.6-19.52 43.6-43.6 0-24.08-19.52-43.6-43.6-43.6-24.08 0-43.6 19.52-43.6 43.6 0 24.08 19.52 43.6 43.6 43.6Z" stroke="var(--cros-sys-illo-color3)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="m87.5 122.1-.8-2.6c0-.1-.2-.3-.3-.3l-2.6-.6c-.1 0-.3 0-.4.1l-1.8 2c-.1.1-.1.3-.1.4l.8 2.6c0 .1.2.3.3.3l2.6.6c.1 0 .3 0 .4-.1l1.8-2c.1-.1.2-.2.1-.4Z" fill="var(--cros-sys-illo-color5)"/><path d="M52.148 100.506c3.5-1.4 7.4.2 8.9 3.6v.1c1.4 3.5-.2 7.4-3.6 8.9-3.5 1.4-7.4-.2-8.9-3.6v-.1c-1.5-3.5.2-7.5 3.6-8.9Z" stroke="var(--cros-sys-illo-color4)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M99.158 68.187c-.336.812-.523 1.649-.652 2.444l-.684 2.643c-.57 2.254-1.975 4.015-3.87 5.34-2.586 1.823-5.662 2.904-6.757 6.195-.832 2.619-.235 5.521 1.622 7.557.083.116.174.182.307.305 3.423 3.362 8.97 2.733 11.731-1.103.789-1.096 1.395-2.324 2.101-3.535 1.206-2.1 3.191-3.664 5.533-4.304l2.616-.748a9.622 9.622 0 0 0 2.45-.673 10.615 10.615 0 0 0 4.398-3.264c3.42-4.137 3.298-10.277-.276-14.275-4.263-4.773-11.564-4.94-16.007-.459-1.176 1.289-1.989 2.534-2.512 3.877Z" stroke="var(--cros-sys-illo-color1-1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M98.95 99.234c1.284-7.904-4.082-15.353-11.987-16.638-7.904-1.284-15.353 4.083-16.638 11.987-1.284 7.905 4.083 15.354 11.987 16.638 7.905 1.284 15.354-4.083 16.638-11.987Z" fill="var(--cros-sys-illo-secondary)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M86.242 84.506c-.933 2.936-.275 6.196 1.807 8.502.133.168.3.313.367.372l.02.017c2.949 2.884 7.263 3.152 10.525 1.229a14.42 14.42 0 0 0-.488-2.067c-2.58 1.863-6.234 1.77-8.648-.601a6.3 6.3 0 0 0-.128-.117l-.002-.001-.061-.056-.011-.01a.996.996 0 0 0-.067-.082c-1.608-1.762-2.134-4.287-1.41-6.574a5.591 5.591 0 0 1 1.126-1.951 14.59 14.59 0 0 0-2.11-.537 7.544 7.544 0 0 0-.916 1.864l-.004.012Z" fill="var(--cros-sys-illo-base)"/><path d="M41.882 75.548c1.8-1.1 4.2-.5 5.2 1.4l4.6 7.7c1.1 1.8.5 4.2-1.4 5.2-1.8 1.1-4.2.5-5.2-1.4l-4.6-7.7c-1-1.8-.4-4.1 1.4-5.2Z" fill="var(--cros-sys-illo-secondary)"/><path d="M21.596 99.825c1.741 4.851 5.068 9.141 9.093 12.178 2.098 1.583 4.39 2.641 6.698 3.552 2.169.867 4.828 1.741 7.041 3.091" stroke="var(--cros-sys-illo-color1-2)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
      </g>
    </defs>
  </svg>
</iron-iconset-svg>
`;
document.head.appendChild(template.content);
