import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style>
      :host {
        align-items: center;
        border-top: 1px solid var(--cr-separator-color);
        color: var(--cr-secondary-text-color);
        display: none;
        /* Should be 13px when <html> font-size is 16px */
        font-size: 0.8125rem;
        justify-content: center;
        padding: 0 24px;
      }

      :host([is-managed_]) {
        display: flex;
      }

      a[href] {
        color: var(--cr-link-color);
      }

      iron-icon {
        align-self: flex-start;
        flex-shrink: 0;
        height: 20px;
        padding-inline-end: var(--managed-footnote-icon-padding, 8px);
        width: 20px;
      }
    </style>

    <template is="dom-if" if="[[isManaged_]]">
      <iron-icon icon="[[managedByIcon_]]"></iron-icon>
      <div id="content"
          inner-h-t-m-l="[[getManagementString_(showDeviceInfo)]]">
      </div>
    </template>
<!--_html_template_end_-->`;
}
