import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">:host{box-sizing:border-box;display:block;padding-bottom:2px;padding-inline-end:var(--settings-menu-padding-inline-end);padding-inline-start:var(--settings-menu-padding-inline-start);padding-top:var(--settings-menu-padding-top);width:var(--settings-menu-width)}:host *{-webkit-tap-highlight-color:transparent}[selectable]>:focus{background-color:transparent}#menuSeparator{border-bottom:var(--cr-separator-line);margin-bottom:8px;margin-top:8px}#topMenu>os-settings-menu-item{margin-bottom:8px}#topMenu>os-settings-menu-item:last-of-type{margin-bottom:calc(48px - calc(var(--tap-target-padding) + var(--settings-menu-item-border-width)))}</style>
<iron-selector id="topMenu"
    role="navigation"
    selectable="os-settings-menu-item"
    attr-for-selected="path"
    selected="[[selectedItemPath_]]"
    on-iron-activate="onItemActivated_"
    on-iron-select="onItemSelected_"
    on-iron-deselect="onItemDeselected_">
  <template id="topMenuRepeat" is="dom-repeat" items="[[menuItems_]]">
    <os-settings-menu-item path="[[item.path]]"
        icon="[[item.icon]]"
        label="[[item.label]]"
        sublabel="[[item.sublabel]]"
        tooltip-position="[[getMenuItemTooltipPosition_(isRtl_)]]">
    </os-settings-menu-item>
  </template>
</iron-selector>
<!--_html_template_end_-->`;
}
