import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared">:host{box-sizing:border-box;display:block}#subpageHeader{min-height:40px;padding-bottom:16px;padding-top:16px}#subpageTitle{color:var(--cros-sys-primary);flex:1;font:var(--cros-button-1-font)}#titleIcon{height:36px;margin-inline-end:12px;margin-inline-start:2px;width:36px}#backButton{--cr-icon-button-fill-color:var(--cros-sys-primary);margin-inline-end:10px;margin-inline-start:-10px}#cardBody{margin-bottom:0}paper-spinner-lite{height:var(--cr-icon-size);width:var(--cr-icon-size)}cr-search-field{--cr-search-field-input-width:200px;margin-inline-start:16px}#searchField::part(searchInput){--cr-input-background-color:var(--cros-sys-input_field_on_shaded)}</style>
<div id="subpageHeader" class="cr-row first">
  <cr-icon-button id="backButton" class="icon-arrow-back"
      hidden="[[hideBackButton]]" on-click="onBackClick_"
      aria-label$="[[getBackButtonAriaLabel_(pageTitle)]]"
      aria-roledescription$=
          "[[getBackButtonAriaRoleDescription_(pageTitle)]]">
  </cr-icon-button>
  <template is="dom-if" if="[[titleIcon]]">
    <img id="titleIcon" src="[[titleIcon]]" aria-hidden="true">
  </template>
  <h1 id="subpageTitle">[[pageTitle]]</h1>
  <template is="dom-if" if="[[learnMoreUrl]]">
    <cr-icon-button iron-icon="cr:help-outline" dir="ltr"
        aria-label="[[getLearnMoreAriaLabel_(pageTitle)]]" on-click="onHelpClick_">
    </cr-icon-button>
  </template>
  <template is="dom-if" if="[[searchLabel]]">
    <cr-search-field id="searchField"
        label="[[searchLabel]]"
        on-search-changed="onSearchChanged_"
        clear-label="$i18n{clearSearch}">
    </cr-search-field>
  </template>
  <template is="dom-if" if="[[showSpinner]]">
    <paper-spinner-lite active title$="[[spinnerTitle]]">
    </paper-spinner-lite>
  </template>
  <slot name="subpage-title-extra"></slot>
</div>

<template is="dom-if" if="[[!multiCard]]">
  <settings-card id="cardBody">
    <slot></slot>
  </settings-card>
</template>
<template is="dom-if" if="[[multiCard]]">
  <slot></slot>
</template>
<!--_html_template_end_-->`;
}
