import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-page-host-style settings-shared">:host{display:flex;flex-direction:column;height:100%;--settings-main-basis:calc(var(--cr-centered-card-max-width) / var(--cr-centered-card-width-percentage));--cr-card-border-radius:4px;--cr-card-shadow:var(--cr-elevation-1);--cr-toolbar-padding-top:8px}settings-toolbar{min-height:56px;z-index:3}#drawer{--cr-drawer-border-start-end-radius:12px;--cr-drawer-border-end-end-radius:12px;--cr-drawer-header-color:var(--cros-sys-primary);--cr-drawer-header-font:var(--cros-title-1-font);--cr-drawer-header-padding:22px;--cr-drawer-width:var(--settings-menu-width);--cr-separator-line:none}#cr-container-shadow-top{z-index:2}#container{align-items:flex-start;display:flex;flex:1;overflow:overlay;position:relative}#left,#center{flex:1 1 0}#left{flex-grow:0;height:100%;position:sticky;top:0;z-index:100}#left os-settings-menu{height:100%;overflow:auto;overscroll-behavior:contain}#center{box-sizing:border-box;flex-basis:var(--settings-main-basis);height:100%;padding-top:8px}#center>os-settings-main{min-height:100%}@media (max-width:980px){#left{display:none}#center{min-width:auto;padding:0 3px}}#drawerIcon{--iron-icon-fill-color:var(--cros-sys-primary);cursor:pointer;margin-inline-end:6px;margin-inline-start:0;outline:none}</style>
<settings-prefs id="prefs" prefs="{{prefs}}"></settings-prefs>
<iron-media-query query="(max-width: [[narrowThreshold_]]px)"
    query-matches="{{isNarrow}}">
</iron-media-query>
<template is="dom-if" if="[[showToolbar_]]">
  <settings-toolbar on-settings-toolbar-menu-tap="onMenuButtonClick_"
      spinner-active="[[toolbarSpinnerActive_]]"
      role="banner"
      narrow="[[isNarrow]]"
      narrow-threshold="980"
      show-menu="[[isNarrow]]">
  </settings-toolbar>
</template>
<template is="dom-if" if="[[showNavMenu_]]">
  <cr-drawer id="drawer" on-close="onMenuClose_" heading="$i18n{settings}"
      align="$i18n{textdirection}">
    <div slot="header-icon">
      <cr-icon-button id="drawerIcon"
          iron-icon="cr20:menu"
          on-click="onDrawerIconClick_"
          title="$i18n{close}">
      </cr-icon-button>
    </div>
    <div slot="body">
      <template is="dom-if" id="drawerTemplate">
        <os-settings-menu
            is-drawer-menu
            page-availability="[[pageAvailability_]]"
            on-iron-activate="onMenuItemSelected_">
        </os-settings-menu>
      </template>
    </div>
  </cr-drawer>
</template>
<!-- #container is the shadow container for CrContainerShadowMixin. -->
<div id="container" class="no-outline">
  <div id="left">
    <template is="dom-if" if="[[showNavMenu_]]">
      <os-settings-menu
          page-availability="[[pageAvailability_]]"
          on-iron-activate="onMenuItemSelected_">
      </os-settings-menu>
    </template>
  </div>
  <div id="center">
    <os-settings-main
        prefs="{{prefs}}"
        toolbar-spinner-active="{{toolbarSpinnerActive_}}"
        page-availability="[[pageAvailability_]]">
    </os-settings-main>
  </div>
</div>
<!--_html_template_end_-->`;
}
