import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-icons cr-hidden-style settings-shared">:host{align-items:center;background-color:var(--settings-base-bg-color);color:var(--cros-text-color-secondary);display:flex;height:var(--settings-toolbar-height);padding-top:var(--settings-toolbar-padding-top)}h1{color:var(--cros-sys-primary);flex:1;font:var(--cros-title-1-font);margin-inline-start:8px;padding-inline-end:12px}#leftContent{position:relative;transition:opacity 100ms}#leftSpacer{align-items:center;box-sizing:border-box;display:flex;padding-inline-start:var(--settings-toolbar-padding-inline-start);width:var(--settings-menu-width)}:host([narrow]) #leftSpacer{width:20px;padding-inline-start:var(--settings-toolbar-padding-inline-start-narrow)}cr-icon-button{--cr-icon-button-fill-color:currentColor;--cr-icon-button-size:32px;min-width:32px}#centeredContent{display:flex;flex:1 1 0;justify-content:center}:host([narrow]) #centeredContent{position:absolute;width:100%;z-index:-1}:host([narrow]:not([showing-search_])) #centeredContent{justify-content:flex-end}:host([has-overlay]){transition:visibility var(--cr-toolbar-overlay-animation-duration);visibility:hidden}#settingsTitle{white-space:nowrap}:host([narrow][showing-search_]) #settingsTitle{display:none}:host([showing-search_][is-search-box-cutoff_]) os-settings-search-box{--cr-toolbar-field-width:min(80vw,var(--settings-toolbar-search-box-width));margin-inline-start:48px}:host([showing-search_][is-search-box-cutoff_][narrow]) os-settings-search-box{--cr-toolbar-field-width:min(80vw,var(--settings-toolbar-narrow-search-box-width))}:host([showing-search_][narrow]:not([is-search-box-cutoff_])) os-settings-search-box{--cr-toolbar-field-width:var(--settings-toolbar-narrow-search-box-width)}:host(:not([narrow]):not([is-search-box-cutoff_])) os-settings-search-box{--cr-toolbar-field-width:var(--settings-toolbar-search-box-width)}:host(:not([narrow])) #leftContent{flex:0 1 0}:host(:not([narrow])) #centeredContent{flex-basis:var(--settings-main-basis)}</style>
<iron-media-query query="(max-width: 780px)"
    query-matches="{{isSearchBoxCutoff_}}">
</iron-media-query>
<div id="leftContent">
  <div id="leftSpacer">
    <template is="dom-if" if="[[showMenu]]">
      <cr-icon-button id="menuButton" class="no-overlap"
          iron-icon="cr20:menu" on-click="onMenuClick_"
          aria-label="$i18n{menuButtonLabel}"
          title="$i18n{menuButtonLabel}">
      </cr-icon-button>
    </template>
    <h1 id="settingsTitle">$i18n{settings}</h1>
  </div>
</div>

<div id="centeredContent" hidden$="[[!showSearch]]">
  <os-settings-search-box id="searchBox" narrow="[[narrow]]"
      showing-search="{{showingSearch_}}">
  </os-settings-search-box>
</div>
<!--_html_template_end_-->`;
}
