// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-personalization-page' is the settings page containing
 * personalization settings.
 */
import 'chrome://resources/ash/common/cr_elements/cr_link_row/cr_link_row.js';
import '../os_settings_page/os_settings_animated_pages.js';
import '../os_settings_page/os_settings_subpage.js';
import '../os_settings_page/settings_card.js';
import '../settings_shared.css.js';
import '../controls/settings_toggle_button.js';
import { PrefsMixin } from '/shared/settings/prefs/prefs_mixin.js';
import { I18nMixin } from 'chrome://resources/ash/common/cr_elements/i18n_mixin.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { DeepLinkingMixin } from '../common/deep_linking_mixin.js';
import { RouteObserverMixin } from '../common/route_observer_mixin.js';
import { Section } from '../mojom-webui/routes.mojom-webui.js';
import { routes } from '../router.js';
import { PersonalizationHubBrowserProxyImpl } from './personalization_hub_browser_proxy.js';
import { getTemplate } from './personalization_page.html.js';
const SettingsPersonalizationPageElementBase = DeepLinkingMixin(RouteObserverMixin(PrefsMixin(I18nMixin(PolymerElement))));
export class SettingsPersonalizationPageElement extends SettingsPersonalizationPageElementBase {
    static get is() {
        return 'settings-personalization-page';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            section_: {
                type: Number,
                value: Section.kPersonalization,
                readOnly: true,
            },
        };
    }
    constructor() {
        super();
        this.personalizationHubBrowserProxy_ =
            PersonalizationHubBrowserProxyImpl.getInstance();
    }
    openPersonalizationHub_() {
        this.personalizationHubBrowserProxy_.openPersonalizationHub();
    }
    /**
     * Overridden from DeepLinkingMixin.
     */
    currentRouteChanged(route) {
        // Does not apply to the personalization page.
        if (route !== routes.PERSONALIZATION) {
            return;
        }
        this.attemptDeepLink();
    }
}
customElements.define(SettingsPersonalizationPageElement.is, SettingsPersonalizationPageElement);
