// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'startup-settings-card' is the card element containing settings that allow
 * the user to configure the restore apps and pages options on startup.
 */
import 'chrome://resources/ash/common/cr_elements/cr_link_row/cr_link_row.js';
import '../os_settings_page/settings_card.js';
import '../settings_shared.css.js';
import { loadTimeData } from 'chrome://resources/js/load_time_data.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { DeepLinkingMixin } from '../common/deep_linking_mixin.js';
import { RouteObserverMixin } from '../common/route_observer_mixin.js';
import { Setting } from '../mojom-webui/setting.mojom-webui.js';
import { routes } from '../router.js';
import { getTemplate } from './startup_settings_card.html.js';
const StartupSettingsCardElementBase = RouteObserverMixin(DeepLinkingMixin(PolymerElement));
export class StartupSettingsCardElement extends StartupSettingsCardElementBase {
    constructor() {
        super(...arguments);
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kRestoreAppsAndPages,
        ]);
    }
    static get is() {
        return 'startup-settings-card';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            prefs: {
                type: Object,
                notify: true,
            },
            /**
             * List of options for the on startup dropdown menu.
             */
            onStartupDropdownOptions_: {
                type: Array,
                value: () => {
                    return [
                        { value: 1, name: loadTimeData.getString('onStartupAlways') },
                        { value: 2, name: loadTimeData.getString('onStartupAskEveryTime') },
                        { value: 3, name: loadTimeData.getString('onStartupDoNotRestore') },
                    ];
                },
                readOnly: true,
            },
        };
    }
    currentRouteChanged(newRoute) {
        if (newRoute !== routes.SYSTEM_PREFERENCES) {
            return;
        }
        this.attemptDeepLink();
    }
}
customElements.define(StartupSettingsCardElement.is, StartupSettingsCardElement);
