import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared"></style>

<os-settings-animated-pages id="pages" section="[[section_]]">
  <div route-path="default">
    <storage-and-power-settings-card></storage-and-power-settings-card>

    <language-settings-card
        prefs="{{prefs}}"
        languages="[[languages]]"
        language-helper="[[languageHelper]]">
    </language-settings-card>

    <date-time-settings-card prefs="{{prefs}}"
        active-time-zone-display-name="{{activeTimeZoneDisplayName_}}">
    </date-time-settings-card>

    <template is="dom-if" if="[[shouldShowFilesSettingsCard_]]">
      <files-settings-card prefs="{{prefs}}"></files-settings-card>
    </template>

    <search-and-assistant-settings-card prefs="{{prefs}}">
    </search-and-assistant-settings-card>

    <template is="dom-if" if="[[shouldShowStartupSettingsCard_]]">
      <startup-settings-card prefs="{{prefs}}"></startup-settings-card>
    </template>

    <multitasking-settings-card prefs="{{prefs}}">
    </multitasking-settings-card>

    <template is="dom-if" if="[[shouldShowResetSettingsCard_]]">
      <reset-settings-card></reset-settings-card>
    </template>
  </div>

  <!-- Date and Time subpages -->
  <template is="dom-if" route-path="/dateTime/timeZone">
    <os-settings-subpage page-title="$i18n{timeZoneSubpageTitle}"
        learn-more-url="$i18n{timeZoneSettingsLearnMoreURL}">
      <timezone-subpage prefs="{{prefs}}"
          active-time-zone-display-name="{{activeTimeZoneDisplayName_}}">
      </timezone-subpage>
    </os-settings-subpage>
  </template>

  <!-- Files subpages -->
  <template is="dom-if" route-path="/smbShares">
    <os-settings-subpage page-title="$i18n{smbSharesTitle}">
      <settings-smb-shares-page prefs="{{prefs}}">
      </settings-smb-shares-page>
    </os-settings-subpage>
  </template>

  <template is="dom-if" if="[[shouldStampGoogleDriveSubpage_]]">
    <template is="dom-if" route-path="/googleDrive">
      <os-settings-subpage page-title="$i18n{googleDriveLabel}"
          show-spinner="[[showSpinner_]]">
        <settings-google-drive-subpage prefs="{{prefs}}"
            show-spinner="{{showSpinner_}}">
        </settings-google-drive-subpage>
      </os-settings-subpage>
    </template>
  </template>

  <template is="dom-if" if="[[shouldStampOfficeSubpage_]]">
    <template is="dom-if" route-path="/officeFiles">
      <os-settings-subpage page-title="$i18n{officeSubpageTitle}">
        <settings-office-page prefs="{{prefs}}">
        </settings-office-page>
      </os-settings-subpage>
    </template>

    <template is="dom-if" route-path="/oneDrive">
      <os-settings-subpage page-title="$i18n{oneDriveLabel}">
        <settings-one-drive-subpage prefs="{{prefs}}">
        </settings-one-drive-subpage>
      </os-settings-subpage>
    </template>
  </template>

  <!-- Languages subpages -->
  <template is="dom-if" route-path="/osLanguages/languages">
    <os-settings-subpage page-title="$i18n{languagesPageTitle}">
      <os-settings-languages-page-v2 prefs="{{prefs}}"
          languages="[[languages]]"
          language-helper="[[languageHelper]]">
      </os-settings-languages-page-v2>
    </os-settings-subpage>
  </template>

  <!-- "App Languages" sub-page. -->
  <template is="dom-if" route-path="/osLanguages/languages/appLanguages">
    <os-settings-subpage page-title="$i18n{appLanguagesTitle}">
      <os-settings-app-languages-page prefs="{{prefs}}">
      </os-settings-app-languages-page>
    </os-settings-subpage>
  </template>

  <!-- Search subpages -->
  <template is="dom-if" if="[[isQuickAnswersSupported_]]">
    <template is="dom-if" route-path="/osSearch/search">
      <os-settings-subpage page-title="$i18n{searchSubpageTitle}">
        <settings-search-subpage prefs="{{prefs}}">
        </settings-search-subpage>
      </os-settings-subpage>
    </template>
  </template>

  <!-- Storage and Power subpages -->
  <template is="dom-if" route-path="/storage">
    <os-settings-subpage page-title="$i18n{storageTitle}">
      <settings-storage prefs="{{prefs}}">
      </settings-storage>
    </os-settings-subpage>
  </template>

  <template is="dom-if" if="[[isExternalStorageEnabled_]]">
    <template is="dom-if" route-path="/storage/externalStoragePreferences">
      <os-settings-subpage page-title="$i18n{storageExternal}">
        <settings-storage-external prefs="{{prefs}}">
        </settings-storage-external>
      </os-settings-subpage>
    </template>
  </template>

  <template is="dom-if" route-path="/power">
    <os-settings-subpage page-title="$i18n{powerTitle}">
      <settings-power prefs="{{prefs}}">
      </settings-power>
    </os-settings-subpage>
  </template>
</os-settings-animated-pages>
<!--_html_template_end_-->`;
}
