// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{OptimizationTarget}from"./autofill_ml_internals.mojom-webui.js";import{getCss}from"./log_details.css.js";import{getHtml}from"./log_details.html.js";export class LogDetailsElement extends CrLitElement{static get is(){return"log-details"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{log:{type:Object}}}#log_accessor_storage={formSignature:"0",formUrl:{url:""},modelOutputTypes:[],fieldPredictions:[],startTime:{internalValue:0n},endTime:{internalValue:0n},duration:{microseconds:0n},optimizationTarget:OptimizationTarget.kUnknown};get log(){return this.#log_accessor_storage}set log(value){this.#log_accessor_storage=value}getOptimizationTargetText_(target){switch(target){case OptimizationTarget.kAutofill:return"Autofill";case OptimizationTarget.kPassword:return"Password Manager";default:return"Unknown"}}static TOP_PREDICTIONS_COUNT=5;getTopPredictions_(probabilities){if(!probabilities){return[]}return probabilities.map(((probability,typeIndex)=>{const type=this.log.modelOutputTypes[typeIndex];return{type:type??"[ERROR]",probability:probability,percentage:`${(probability*100).toFixed(2)}%`}})).sort(((a,b)=>b.probability-a.probability)).slice(0,LogDetailsElement.TOP_PREDICTIONS_COUNT)}formatFieldTokens_(tokens){return tokens.join(" / ")}}customElements.define(LogDetailsElement.is,LogDetailsElement);