// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert,assertNotReached}from"chrome://resources/js/assert.js";import{CustomElement}from"chrome://resources/js/custom_element.js";import{GattResult,Property}from"./device.mojom-webui.js";import{connectToDevice}from"./device_broker.js";import{showSnackbar,SnackbarType}from"./snackbar.js";import{getTemplate}from"./value_control.html.js";let ValueLoadOptions;export const ValueDataType={HEXADECIMAL:"Hexadecimal",UTF8:"UTF-8",DECIMAL:"Decimal"};export class Value{constructor(initialValue){this.value_=initialValue}getArray(){return this.value_}setArray(newValue){this.value_=newValue}setAs(valueDataType,newValue){switch(valueDataType){case ValueDataType.HEXADECIMAL:this.setValueFromHex_(newValue);break;case ValueDataType.UTF8:this.setValueFromUTF8_(newValue);break;case ValueDataType.DECIMAL:this.setValueFromDecimal_(newValue);break}}getAs(valueDataType){switch(valueDataType){case ValueDataType.HEXADECIMAL:return this.toHex_();case ValueDataType.UTF8:return this.toUTF8_();case ValueDataType.DECIMAL:return this.toDecimal_()}assertNotReached();return""}toHex_(){if(this.value_.length===0){return""}return this.value_.reduce((function(result,value,index){return result+("0"+value.toString(16)).substr(-2)}),"0x")}setValueFromHex_(newValue){if(!newValue){this.value_=[];return}if(!newValue.startsWith("0x")){throw new Error('Expected new value to start with "0x".')}const result=[];for(let i=2;i<newValue.length;i+=2){result.push(parseInt(newValue.substr(i,2),16))}this.value_=result}toUTF8_(){return this.value_.reduce((function(result,value){return result+String.fromCharCode(value)}),"")}setValueFromUTF8_(newValue){if(!newValue){this.value_=[];return}this.value_=Array.from(newValue).map((function(char){return char.charCodeAt(0)}))}toDecimal_(){return this.value_.join("-")}setValueFromDecimal_(newValue){if(!newValue){this.value_=[];return}if(!/^[0-9\-]*$/.test(newValue)){throw new Error("New value can only contain numbers and hyphens.")}this.value_=newValue.split("-").map((function(val){return parseInt(val,10)}))}}export class ValueControlElement extends CustomElement{static get is(){return"value-control"}static get template(){return getTemplate()}static get observedAttributes(){return["data-value","data-options"]}constructor(){super();this.value_=new Value([]);this.deviceAddress_=null;this.serviceId_=null;this.characteristicId_=null;this.descriptorId_=null;this.properties_=Number.MAX_SAFE_INTEGER;this.valueInput_=this.shadowRoot.querySelector("input");this.typeSelect_=this.shadowRoot.querySelector("select");this.writeBtn_=this.shadowRoot.querySelector("button.write");this.readBtn_=this.shadowRoot.querySelector("button.read");this.unavailableMessage_=this.shadowRoot.querySelector("h3")}connectedCallback(){this.classList.add("value-control");this.valueInput_.addEventListener("change",function(){try{this.value_.setAs(this.typeSelect_.value,this.valueInput_.value)}catch(e){showSnackbar(e.message,SnackbarType.ERROR)}}.bind(this));this.typeSelect_.addEventListener("change",this.redraw.bind(this));this.readBtn_.addEventListener("click",this.readValue_.bind(this));this.writeBtn_.addEventListener("click",this.writeValue_.bind(this));this.redraw()}attributeChangedCallback(name,oldValue,newValue){assert(name==="data-value"||name==="data-options");if(oldValue===newValue){return}if(name==="data-options"){const options=JSON.parse(newValue);this.deviceAddress_=options.deviceAddress;this.serviceId_=options.serviceId;this.characteristicId_=options.characteristicId;this.descriptorId_=options.descriptorId;if(options.properties){this.properties_=options.properties}}else{this.value_.setArray(JSON.parse(newValue))}this.redraw()}redraw(){this.readBtn_.hidden=(this.properties_&Property.READ)===0;this.writeBtn_.hidden=(this.properties_&Property.WRITE)===0&&(this.properties_&Property.WRITE_WITHOUT_RESPONSE)===0;const isAvailable=!this.readBtn_.hidden||!this.writeBtn_.hidden;this.unavailableMessage_.hidden=isAvailable;this.valueInput_.hidden=!isAvailable;this.typeSelect_.hidden=!isAvailable;if(!isAvailable){return}this.valueInput_.value=this.value_.getAs(this.typeSelect_.value)}setValue(value){this.value_.setArray(value);this.redraw()}getErrorString_(result){return Object.keys(GattResult).find((function(key){return GattResult[key]===result}))}readValue_(){this.readBtn_.disabled=true;assert(this.deviceAddress_);connectToDevice(this.deviceAddress_).then(function(device){if(this.descriptorId_){return device.readValueForDescriptor(this.serviceId_,this.characteristicId_,this.descriptorId_)}return device.readValueForCharacteristic(this.serviceId_,this.characteristicId_)}.bind(this)).then(function(response){this.readBtn_.disabled=false;if(response.result===GattResult.SUCCESS){this.setValue(response.value);showSnackbar(this.deviceAddress_+": Read succeeded",SnackbarType.SUCCESS);return}const errorString=this.getErrorString_(response.result);showSnackbar(this.deviceAddress_+": "+errorString,SnackbarType.ERROR,"Retry",this.readValue_.bind(this))}.bind(this))}writeValue_(){this.writeBtn_.disabled=true;assert(this.deviceAddress_);connectToDevice(this.deviceAddress_).then(function(device){if(this.descriptorId_){return device.writeValueForDescriptor(this.serviceId_,this.characteristicId_,this.descriptorId_,this.value_.getArray())}return device.writeValueForCharacteristic(this.serviceId_,this.characteristicId_,this.value_.getArray())}.bind(this)).then(function(response){this.writeBtn_.disabled=false;if(response.result===GattResult.SUCCESS){showSnackbar(this.deviceAddress_+": Write succeeded",SnackbarType.SUCCESS);return}const errorString=this.getErrorString_(response.result);showSnackbar(this.deviceAddress_+": "+errorString,SnackbarType.ERROR,"Retry",this.writeValue_.bind(this))}.bind(this))}}customElements.define("value-control",ValueControlElement);