// components/browsing_topics/mojom/browsing_topics_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { String16Spec as mojoBase_mojom_String16Spec } from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
import { TimeSpec as mojoBase_mojom_TimeSpec, TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'browsing_topics.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getBrowsingTopicsConfiguration() {
        return this.proxy.sendMessage(0, PageHandler_GetBrowsingTopicsConfiguration_ParamsSpec.$, PageHandler_GetBrowsingTopicsConfiguration_ResponseParamsSpec.$, [], false);
    }
    getBrowsingTopicsState(calculateNow) {
        return this.proxy.sendMessage(1, PageHandler_GetBrowsingTopicsState_ParamsSpec.$, PageHandler_GetBrowsingTopicsState_ResponseParamsSpec.$, [
            calculateNow
        ], false);
    }
    getModelInfo() {
        return this.proxy.sendMessage(2, PageHandler_GetModelInfo_ParamsSpec.$, PageHandler_GetModelInfo_ResponseParamsSpec.$, [], false);
    }
    classifyHosts(hosts) {
        return this.proxy.sendMessage(3, PageHandler_ClassifyHosts_ParamsSpec.$, PageHandler_ClassifyHosts_ResponseParamsSpec.$, [
            hosts
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_GetBrowsingTopicsConfiguration_ParamsSpec.$, PageHandler_GetBrowsingTopicsConfiguration_ResponseParamsSpec.$, impl.getBrowsingTopicsConfiguration.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_GetBrowsingTopicsState_ParamsSpec.$, PageHandler_GetBrowsingTopicsState_ResponseParamsSpec.$, impl.getBrowsingTopicsState.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_GetModelInfo_ParamsSpec.$, PageHandler_GetModelInfo_ResponseParamsSpec.$, impl.getModelInfo.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_ClassifyHosts_ParamsSpec.$, PageHandler_ClassifyHosts_ResponseParamsSpec.$, impl.classifyHosts.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "browsing_topics.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    getBrowsingTopicsConfiguration;
    getBrowsingTopicsState;
    getModelInfo;
    classifyHosts;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getBrowsingTopicsConfiguration =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_GetBrowsingTopicsConfiguration_ParamsSpec.$, PageHandler_GetBrowsingTopicsConfiguration_ResponseParamsSpec.$, this.getBrowsingTopicsConfiguration.createReceiverHandler(true /* expectsResponse */), false);
        this.getBrowsingTopicsState =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_GetBrowsingTopicsState_ParamsSpec.$, PageHandler_GetBrowsingTopicsState_ResponseParamsSpec.$, this.getBrowsingTopicsState.createReceiverHandler(true /* expectsResponse */), false);
        this.getModelInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_GetModelInfo_ParamsSpec.$, PageHandler_GetModelInfo_ResponseParamsSpec.$, this.getModelInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.classifyHosts =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_ClassifyHosts_ParamsSpec.$, PageHandler_ClassifyHosts_ResponseParamsSpec.$, this.classifyHosts.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const WebUIBrowsingTopicsConfigurationSpec = { $: {} };
export const WebUITopicSpec = { $: {} };
export const WebUIEpochSpec = { $: {} };
export const WebUIBrowsingTopicsStateSpec = { $: {} };
export const WebUIModelInfoSpec = { $: {} };
export const PageHandler_GetBrowsingTopicsConfiguration_ParamsSpec = { $: {} };
export const PageHandler_GetBrowsingTopicsConfiguration_ResponseParamsSpec = { $: {} };
export const PageHandler_GetBrowsingTopicsState_ParamsSpec = { $: {} };
export const PageHandler_GetBrowsingTopicsState_ResponseParamsSpec = { $: {} };
export const PageHandler_GetModelInfo_ParamsSpec = { $: {} };
export const PageHandler_GetModelInfo_ResponseParamsSpec = { $: {} };
export const PageHandler_ClassifyHosts_ParamsSpec = { $: {} };
export const PageHandler_ClassifyHosts_ResponseParamsSpec = { $: {} };
export const WebUIGetBrowsingTopicsStateResultSpec = { $: {} };
export const WebUIGetModelInfoResultSpec = { $: {} };
mojo.internal.Struct(WebUIBrowsingTopicsConfigurationSpec.$, 'WebUIBrowsingTopicsConfiguration', [
    mojo.internal.StructField('browsingTopicsEnabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('privacySandboxAdsApisOverrideEnabled', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('overridePrivacySandboxSettingsLocalTestingEnabled', 0, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('browsingTopicsBypassIpIsPubliclyRoutableCheckEnabled', 0, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('browsingTopicsDocumentApiEnabled', 0, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('configVersion', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('browsingTopicsParametersEnabled', 0, 5, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('numberOfEpochsToExpose', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('timePeriodPerEpoch', 16, 0, mojoBase_mojom_TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('numberOfTopTopicsPerEpoch', 12, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('useRandomTopicProbabilityPercent', 24, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('maxEpochIntroductionDelay', 32, 0, mojoBase_mojom_TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('numberOfEpochsOfObservationDataToUseForFiltering', 28, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('maxNumberOfApiUsageContextDomainsToKeepPerTopic', 40, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('maxNumberOfApiUsageContextEntriesToLoadPerEpoch', 44, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('maxNumberOfApiUsageContextDomainsToStorePerPageLoad', 48, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('taxonomyVersion', 52, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('disabledTopicsList', 56, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 72],]);
mojo.internal.Struct(WebUITopicSpec.$, 'WebUITopic', [
    mojo.internal.StructField('topicId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('topicName', 8, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isRealTopic', 4, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('observedByDomains', 16, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(WebUIEpochSpec.$, 'WebUIEpoch', [
    mojo.internal.StructField('topics', 0, 0, mojo.internal.Array(WebUITopicSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('calculationTime', 8, 0, mojoBase_mojom_TimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('modelVersion', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('taxonomyVersion', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(WebUIBrowsingTopicsStateSpec.$, 'WebUIBrowsingTopicsState', [
    mojo.internal.StructField('epochs', 0, 0, mojo.internal.Array(WebUIEpochSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('nextScheduledCalculationTime', 8, 0, mojoBase_mojom_TimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebUIModelInfoSpec.$, 'WebUIModelInfo', [
    mojo.internal.StructField('modelVersion', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('modelFilePath', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_GetBrowsingTopicsConfiguration_ParamsSpec.$, 'PageHandler_GetBrowsingTopicsConfiguration_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetBrowsingTopicsConfiguration_ResponseParamsSpec.$, 'PageHandler_GetBrowsingTopicsConfiguration_ResponseParams', [
    mojo.internal.StructField('config', 0, 0, WebUIBrowsingTopicsConfigurationSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetBrowsingTopicsState_ParamsSpec.$, 'PageHandler_GetBrowsingTopicsState_Params', [
    mojo.internal.StructField('calculateNow', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetBrowsingTopicsState_ResponseParamsSpec.$, 'PageHandler_GetBrowsingTopicsState_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, WebUIGetBrowsingTopicsStateResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_GetModelInfo_ParamsSpec.$, 'PageHandler_GetModelInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetModelInfo_ResponseParamsSpec.$, 'PageHandler_GetModelInfo_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, WebUIGetModelInfoResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_ClassifyHosts_ParamsSpec.$, 'PageHandler_ClassifyHosts_Params', [
    mojo.internal.StructField('hosts', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ClassifyHosts_ResponseParamsSpec.$, 'PageHandler_ClassifyHosts_ResponseParams', [
    mojo.internal.StructField('topicsForHosts', 0, 0, mojo.internal.Array(mojo.internal.Array(WebUITopicSpec.$, false), false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Union(WebUIGetBrowsingTopicsStateResultSpec.$, 'WebUIGetBrowsingTopicsStateResult', {
    'overrideStatusMessage': {
        'ordinal': 0,
        'type': mojo.internal.String,
    },
    'browsingTopicsState': {
        'ordinal': 1,
        'type': WebUIBrowsingTopicsStateSpec.$,
    },
});
export var WebUIGetBrowsingTopicsStateResultFieldTags;
(function (WebUIGetBrowsingTopicsStateResultFieldTags) {
    WebUIGetBrowsingTopicsStateResultFieldTags[WebUIGetBrowsingTopicsStateResultFieldTags["OVERRIDE_STATUS_MESSAGE"] = 0] = "OVERRIDE_STATUS_MESSAGE";
    WebUIGetBrowsingTopicsStateResultFieldTags[WebUIGetBrowsingTopicsStateResultFieldTags["BROWSING_TOPICS_STATE"] = 1] = "BROWSING_TOPICS_STATE";
})(WebUIGetBrowsingTopicsStateResultFieldTags || (WebUIGetBrowsingTopicsStateResultFieldTags = {}));
export function whichWebUIGetBrowsingTopicsStateResult(u) {
    if (u.overrideStatusMessage !== null && u.overrideStatusMessage !== undefined) {
        return WebUIGetBrowsingTopicsStateResultFieldTags.OVERRIDE_STATUS_MESSAGE;
    }
    if (u.browsingTopicsState !== null && u.browsingTopicsState !== undefined) {
        return WebUIGetBrowsingTopicsStateResultFieldTags.BROWSING_TOPICS_STATE;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(WebUIGetModelInfoResultSpec.$, 'WebUIGetModelInfoResult', {
    'overrideStatusMessage': {
        'ordinal': 0,
        'type': mojo.internal.String,
    },
    'modelInfo': {
        'ordinal': 1,
        'type': WebUIModelInfoSpec.$,
    },
});
export var WebUIGetModelInfoResultFieldTags;
(function (WebUIGetModelInfoResultFieldTags) {
    WebUIGetModelInfoResultFieldTags[WebUIGetModelInfoResultFieldTags["OVERRIDE_STATUS_MESSAGE"] = 0] = "OVERRIDE_STATUS_MESSAGE";
    WebUIGetModelInfoResultFieldTags[WebUIGetModelInfoResultFieldTags["MODEL_INFO"] = 1] = "MODEL_INFO";
})(WebUIGetModelInfoResultFieldTags || (WebUIGetModelInfoResultFieldTags = {}));
export function whichWebUIGetModelInfoResult(u) {
    if (u.overrideStatusMessage !== null && u.overrideStatusMessage !== undefined) {
        return WebUIGetModelInfoResultFieldTags.OVERRIDE_STATUS_MESSAGE;
    }
    if (u.modelInfo !== null && u.modelInfo !== undefined) {
        return WebUIGetModelInfoResultFieldTags.MODEL_INFO;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
