// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/cr_elements/cr_shared_style.css.js";import"./certificate_provisioning_details_dialog.js";import"./certificate_provisioning_entry.js";import"./certificate_shared.css.js";import{WebUiListenerMixin}from"//resources/cr_elements/web_ui_listener_mixin.js";import{focusWithoutInk}from"//resources/js/focus_without_ink.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{CertificateProvisioningViewDetailsActionEvent}from"./certificate_manager_types.js";import{CertificateProvisioningBrowserProxyImpl}from"./certificate_provisioning_browser_proxy.js";import{getTemplate}from"./certificate_provisioning_list.html.js";const CertificateProvisioningListElementBase=WebUiListenerMixin(PolymerElement);export class CertificateProvisioningListElement extends CertificateProvisioningListElementBase{static get is(){return"certificate-provisioning-list"}static get template(){return getTemplate()}static get properties(){return{removeHeaderPadding:{type:Boolean,value:false},provisioningProcesses_:{type:Array,value(){return[]}},provisioningDetailsDialogModel_:Object,showProvisioningDetailsDialog_:Boolean}}previousAnchor_=null;headerClassList_(removeHeaderPadding){return removeHeaderPadding?"header-box":"header-box padding"}hasCertificateProvisioningEntries_(provisioningProcesses){return provisioningProcesses.length!==0}onCertificateProvisioningProcessesChanged_(certProvisioningProcesses){this.provisioningProcesses_=certProvisioningProcesses;if(!this.provisioningDetailsDialogModel_){return}const certProfileId=this.provisioningDetailsDialogModel_.certProfileId;const newDialogModel=this.provisioningProcesses_.find((process=>process.certProfileId===certProfileId));if(newDialogModel){this.provisioningDetailsDialogModel_=newDialogModel}else{this.shadowRoot.querySelector("certificate-provisioning-details-dialog").close()}}connectedCallback(){super.connectedCallback();this.addWebUiListener("certificate-provisioning-processes-changed",this.onCertificateProvisioningProcessesChanged_.bind(this));CertificateProvisioningBrowserProxyImpl.getInstance().refreshCertificateProvisioningProcesses()}ready(){super.ready();this.addEventListener(CertificateProvisioningViewDetailsActionEvent,(event=>{const detail=event.detail;this.provisioningDetailsDialogModel_=detail.model;this.previousAnchor_=detail.anchor;this.showProvisioningDetailsDialog_=true;event.stopPropagation();CertificateProvisioningBrowserProxyImpl.getInstance().refreshCertificateProvisioningProcesses()}))}onDialogClose_(){this.showProvisioningDetailsDialog_=false;focusWithoutInk(this.previousAnchor_);this.previousAnchor_=null}}customElements.define(CertificateProvisioningListElement.is,CertificateProvisioningListElement);