// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'certificate-provisioning-details-dialog' allows the user to
 * view the details of an in-progress certiifcate provisioning process.
 */
import '//resources/cr_elements/cr_expand_button/cr_expand_button.js';
import '//resources/cr_elements/cr_dialog/cr_dialog.js';
import '//resources/cr_elements/cr_collapse/cr_collapse.js';
import './certificate_shared.css.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { CertificateProvisioningBrowserProxyImpl } from './certificate_provisioning_browser_proxy.js';
import { getTemplate } from './certificate_provisioning_details_dialog.html.js';
export class CertificateProvisioningDetailsDialogElement extends PolymerElement {
    static get is() {
        return 'certificate-provisioning-details-dialog';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            model: Object,
            advancedExpanded_: Boolean,
        };
    }
    close() {
        this.$.dialog.close();
    }
    onRefresh_() {
        CertificateProvisioningBrowserProxyImpl.getInstance()
            .triggerCertificateProvisioningProcessUpdate(this.model.certProfileId);
    }
    onReset_() {
        CertificateProvisioningBrowserProxyImpl.getInstance()
            .triggerCertificateProvisioningProcessReset(this.model.certProfileId);
    }
    shouldHideLastFailedStatus_() {
        return this.model.lastUnsuccessfulMessage.length === 0;
    }
    arrowState_(opened) {
        return opened ? 'cr:arrow-drop-up' : 'cr:arrow-drop-down';
    }
    boolToString_(bool) {
        return bool.toString();
    }
}
customElements.define(CertificateProvisioningDetailsDialogElement.is, CertificateProvisioningDetailsDialogElement);
