// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { TestImportManager } from '/common/testing/test_import_manager.js';
/**
 * The metric used to record the average FaceLandmarker performance time on a
 * single video frame (in milliseconds).
 */
const FACELANDMARKER_PERFORMANCE_METRIC = 'Accessibility.FaceGaze.AverageFaceLandmarkerLatency';
/** A class used to record metrics for FaceGaze. */
export class MetricsUtils {
    latencies_ = [];
    addFaceLandmarkerResultLatency(val) {
        this.latencies_.push(val);
        if (this.latencies_.length >= 100) {
            this.writeHistogram_();
            this.latencies_ = [];
        }
    }
    writeHistogram_() {
        let sum = 0;
        for (const val of this.latencies_) {
            sum += val;
        }
        const average = Math.ceil(sum / this.latencies_.length);
        chrome.metricsPrivate.recordMediumTime(FACELANDMARKER_PERFORMANCE_METRIC, average);
    }
}
TestImportManager.exportForTesting(MetricsUtils);
