// Use of this source code is governed by a MIT license that can be
// found in the LICENSE file.
export var JaPhoneticMap;
(function (JaPhoneticMap) {
    /** A map containing phonetic disambiguation data for Japanese. */
    JaPhoneticMap.MAP = new Map([
        [' ', ' スペース'],
        ['團', 'ダン，ダンタイコウドウノダンノキュウジ'],
        ['土', 'ドヨウビ ノ ド，ツチ'],
        ['圜', 'カン，クニガマエニシゼンカンキョウノカンノツクリ'],
        ['園', 'ドウブツエン ノ エン'],
        ['圓', 'エン，ヒャクエンダマノエンノキュウジ'],
        ['圖', 'ズ，トショカンノトノキュウジ'],
        ['國', 'クニ，コクゴノコクノキュウジ'],
        ['圈', 'ケン，シュトケンノケンノキュウジ'],
        ['圉', 'ギョ，クニガマエニシアワセ'],
        ['圏', 'シュトケン ノ ケン'],
        ['圍', 'カコム，イゴノイノキュウジ'],
        ['圃', 'ハタケ ノ イミ ノ ホジョウ ノ ホ'],
        ['圀', 'クニノイタイジ，トクガワミツクニノクニ'],
        ['圄', 'ゴ，クニガマエニタゴサクノゴ'],
        ['圻', 'キ，ツチヘンニショクパンイッキンノキン'],
        ['圸', 'ママ，ツチヘンニヤマ'],
        ['地', 'チキュウ ノ チ'],
        ['圷', 'アクツ，ツチヘンニジョウゲノゲ'],
        ['在', 'ソンザイ ノ ザイ'],
        ['圭', 'ツチ フタツ ノ ケイ'],
        ['圦', 'イリ，ツチヘンニニュウガクスルノニュウ'],
        ['圧', 'アツリョク ノ アツ'],
        ['亀', 'ドウブツ ノ カメ，キ'],
        ['棲', 'ドウセイスル ノ セイ，スム'],
        ['亂', 'コンランスルノラン，ミダレル'],
        ['亅', 'ケツ，カンジノブシュノハネボウ'],
        ['了', 'リョウショウスル ノ リョウ'],
        ['争', 'キョウソウ ノ ソウ，アラソウ'],
        ['予', 'ヨテイ ノ ヨ'],
        ['事', 'ジケン ノ ジ，コト'],
        ['亊', 'ジケンノジ，コトノイタイジ'],
        ['二', 'カンスウジ ノ ニ'],
        ['于', 'ウ，ウチュウノウノウカンムリヲトッタモノ'],
        ['云', 'ウンヌン ノ ウン，イウ'],
        ['棡', 'コウ，キヘンニオカヤマケンノオカ'],
        ['互', 'ゴカク ノ ゴ，タガイ'],
        ['井', 'イドミズ ノ イ'],
        ['五', 'カンスウジ ノ ゴ'],
        ['棧', 'サンバシノサンノキュウジ'],
        ['亙', 'ジンメイヨウワタル ノ キョヨウジタイ'],
        ['亘', 'ジンメイ ノ ワタル，カキネ ノ カキ ノ ツクリ'],
        ['些', 'ササイ ノ サ，イササカ'],
        ['亜', 'アネッタイ ノ ア'],
        ['亟', 'キ，ホッキョクノキョクノツクリ'],
        ['亞', 'アネッタイノアノキュウジ'],
        ['亡', 'ボウメイスル ノ ボウ'],
        ['亠', 'トウ，ブシュノナベブタ'],
        ['棒', 'テツボウ ノ ボウ'],
        ['亢', 'コウ，テイコウスルノコウノツクリ'],
        ['亥', 'イ，ジュウニシ ノ イノシシ'],
        ['交', 'コウツウ ノ コウ，マジワル'],
        ['亦', 'セツゾクシ ノ マタ，ヘンカスル ノ ヘン ノ ウエガワ'],
        ['棘', 'トゲ，キョクヒドウブツノキョク'],
        ['亨', 'キョウ，ナベブタニ クチニ リョウ'],
        ['享', 'キョウラクテキ ノ キョウ'],
        ['亭', 'テイシュ ノ テイ'],
        ['京', 'トウキョウ ノ キョウ'],
        ['亮', 'ジンメイ ノ リョウ，ショカツリョウ ノ リョウ'],
        ['亰', 'トウキョウノキョウノイタイジ'],
        ['亳', 'ハク，コダイチュウゴクノインノミヤコノヒトツ'],
        ['棄', 'ハキスル ノ キ，ステル'],
        ['棆', 'リン，キヘンニリンリテキナノリン'],
        ['亶', 'タン，ブツダンノダンノツクリ'],
        ['棉', 'ショクブツ ノ ワタ，キヘン'],
        ['棊', 'キ，ショウギヲサスノギノイタイジ'],
        ['人', 'ヒト，ニンゲン ノ ニン'],
        ['棍', 'コンボウノコン，キヘンニコンチュウノコン'],
        ['酳', 'イン，ジュウニシノトリノミギニイトガシラニツキ'],
        ['酵', 'コウボキン ノ コウ'],
        ['k', 'ケイ キッチン'],
        ['酪', 'ラクノウ ノ ラク'],
        ['霊', 'レイエン ノ レイ，タマ'],
        ['酘', 'トウ，ジュウニシノトリノミギニルマタ'],
        ['‡', 'ダブルダガー'],
        ['酖', 'タン，ジュウニシノトリノミギニシズムノツクリ'],
        ['酉', 'トリ，ジュウニシ ノ トリ'],
        ['酋', 'シュウチョウ ノ シュウ'],
        ['棹', 'トウ，サオ，キヘンニタッキュウノタク'],
        ['棺', 'カンオケ ノ カン，ヒツギ'],
        ['酌', 'バンシャク ノ シャク'],
        ['A', 'エイ アニマル'],
        ['蓁', 'シン，クサカンムリニシンノシコウテイノシン'],
        ['蓆', 'セキ，クサカンムリニザセキノセキ'],
        ['蓄', 'チョチク ノ チク'],
        ['蓊', 'オウ，クサカンムリニオキナ'],
        ['蓋', 'ズガイコツ ノ ガイ，フタ'],
        ['蓉', 'ショクブツ ノ フヨウ ノ ヨウ'],
        ['蓍', 'シ，クサカンムリニヒレノツクリ'],
        ['蓐', 'ジョク，クサカンムリニブジョクスルノジョク'],
        ['蓑', 'ミノムシ ノ ミノ'],
        ['蓖', 'ヒマシユノヒ'],
        ['蓚', 'シュウ，クサカンムリニシュウリスルノシュウ'],
        ['蓙', 'ゴザノザ，クサカンムリニギンザノザ'],
        ['棠', 'トウ，コッカイギジドウノドウノツチノカワリニモクザイノモク'],
        ['蓮', 'レンコン ノ レン，ハス'],
        ['蓬', 'ホウライサン ノ ホウ，ヨモギ'],
        ['棣', 'テイ，キヘンニレイヅクリ'],
        ['蓴', 'ジュンサイノジュン'],
        ['蓿', 'シュク，クサカンムリニシュクダイノシュク'],
        ['蓼', 'タデクウムシモスキズキノタデ'],
        ['有', 'ユウメイジン ノ ユウ，アル'],
        ['月', 'ゲツヨウビ ノ ゲツ，ツキ'],
        ['朋', 'ホウユウ ノ ホウ，トモ'],
        ['服', 'ヨウフク ノ フク'],
        ['朏', 'ヒ、ミカヅキ、ツキヘンニデル'],
        ['最', 'サイショ ノ サイ，モットモ'],
        ['會', 'カイシャノカイ，アウノキュウジ'],
        ['望', 'キボウ ノ ボウ，ノゾム'],
        ['朝', 'アサヒ ノ アサ，チョウ'],
        ['期', 'キタイスル ノ キ'],
        ['朞', 'キ、キホンノキノツチノカワリニツキ'],
        ['朕', 'チンオモウニ ノ チン'],
        ['朔', 'サクジツ ノ サク，ツイタチ'],
        ['朗', 'ロウドク ノ ロウ'],
        ['朖', 'ロウドクノロウノイタイジ、ツキヘンニカイリョウスルノリョウ'],
        ['木', 'モクヨウビ ノ モク，キ'],
        ['末', 'ネンマツ ノ マツ，スエ'],
        ['未', 'ミライ ノ ミ'],
        ['札', 'ナフダ ノ フダ，サツ'],
        ['本', 'ホンモノ ノ ホン，モト'],
        ['朮', 'ジュツ、ジュツゴノジュツノツクリ'],
        ['朧', 'モウロウトスルノロウ'],
        ['朦', 'モウロウトスルノモウ'],
        ['朸', 'ロク、キヘンニチカラ'],
        ['机', 'ツクエ'],
        ['朽', 'ロウキュウカスル ノ キュウ，クチル'],
        ['森', 'シンリン ノ シン，モリ'],
        ['朿', 'シ、トゲ、シゲキスルノシノヒダリガワ'],
        ['朱', 'シュイロ ノ シュ'],
        ['棯', 'ジン，キヘンニザンネンノネン'],
        ['朴', 'ソボクナ ノ ボク'],
        ['朷', 'トウ、キヘンニカタナ'],
        ['朶', 'ミミタブヲイミスルジダノダ'],
        ['棔', 'コン，キヘンニコンスイジョウタイノコン'],
        ['棕', 'シュロノキノシュ'],
        ['棗', 'ショクブツノナツメ'],
        ['棚', 'タナオロシ ノ タナ'],
        ['砿', 'イシヘン ニ ヒロイ ノ コウ'],
        ['砺', 'レイ，イシヘン ニ ガンダレ ニ マン'],
        ['破', 'ハカイスル ノ ハ，ヤブル'],
        ['砲', 'ホウガンナゲ ノ ホウ'],
        ['砥', 'トイシ ノ ト'],
        ['砦', 'トリデ，コレ ノ シタニ イシ'],
        ['棟', 'ビョウトウ ノ トウ，ムネ'],
        ['砠', 'ショ，イシヘンニクミノツクリ'],
        ['研', 'ケンキュウ ノ ケン'],
        ['砕', 'クダク，フンサイスル ノ サイ'],
        ['砒', 'ゲンソノヒソノヒ'],
        ['砌', 'セイ，ミギリ，イシヘンニセツジツナノセツ'],
        ['砂', 'サトウ ノ サ，スナ'],
        ['髱', 'ホウ，カミガシラニツツム'],
        ['髷', 'キョク，マゲ，カミガシラニマゲル'],
        ['髴', 'ホウフツノフツ，カミガシラニフットウスルノフツノツクリ'],
        ['髻', 'ケイ，カミガシラニダイキチノキチ'],
        ['髣', 'ホウフツノホウ，カミガシラニセイホウケイノホウ'],
        ['髢', 'テイ，カミガシラニナリ，カモジ'],
        ['髦', 'ボウ，カミガシラニケイトノケ'],
        ['髫', 'チョウ，カミガシラニマネクノツクリ'],
        ['髪', 'カミノケ ノ カミ，ハツ'],
        ['髯', 'ゼン，ホウヒゲ'],
        ['髮', 'カミノケノカミノキュウジ'],
        ['髭', 'クチヒゲ ノ ヒゲ'],
        ['髓', 'セキズイノズイノキュウジ'],
        ['髑', 'ドクロノドク'],
        ['棋', 'キ，ショウギ ノ ギ'],
        ['體', 'カラダ，タイイクノタイノキュウジ'],
        ['高', 'タカイ，サイコウ ノ コウ'],
        ['髟', 'ヒョウ，カミガシラ'],
        ['髞', 'ソウ，タカイヒクイノタカイニアヤツルノツクリ'],
        ['髀', 'ヒ，ホネヘンニイヤシイ'],
        ['髄', 'セキズイ ノ ズイ'],
        ['髏', 'ドクロノロ'],
        ['巉', 'ザン，ヤマヘンニザンゲンスルノザンノツクリ'],
        ['巍', 'ギ，ヤマノシタニギシワジンデンノギ'],
        ['巌', 'ガンリュウジマ ノ ガン，イワオ'],
        ['巛', 'セン，ブシュノマガリガワ'],
        ['州', 'キュウシュウチホウ ノ シュウ'],
        ['川', 'カセン ノ セン，カワ'],
        ['巓', 'ヤマノイタダキヲイミスルサンテンノテン'],
        ['巒', 'ラン，コイビトノコイノキュウジノココロノカワリニヤマ'],
        ['巖', 'ゲンジュウナノゲン，キビシイノキュウジ'],
        ['巫', 'ジンジャノミコノフ'],
        ['巨', 'キョダイナ ノ キョ'],
        ['差', 'サベツカスル ノ サ'],
        ['巣', 'ハチノス ノ ス'],
        ['巡', 'ジュンカイ ノ ジュン，メグル'],
        ['巧', 'ギコウテキナ ノ コウ，タクミ'],
        ['左', 'ヒダリ，サユウ ノ サ'],
        ['工', 'ズコウ ノ コウ'],
        ['巻', 'ノリマキ ノ マキ'],
        ['巾', 'ゾウキン ノ キン，ハバ'],
        ['巽', 'ホウガク ノ タツミ'],
        ['巳', 'ミ，ジュウニシ ノ ミ'],
        ['已', 'ブンポウノイゼンケイノイ'],
        ['己', 'ジコショウカイ ノ コ，オノレ'],
        ['樒', 'ミツ，キヘンニヒミツノミツ'],
        ['巷', 'チマタ ノ コエ ノ チマタ，コウ'],
        ['巵', 'シ，サカズキノイタイジ'],
        ['巴', 'トモエナゲ ノ トモエ'],
        ['燕', 'ツバメ'],
        ['燔', 'ハン，ヒヘンニバンゴウノバン'],
        ['燗', 'アツカンノカン'],
        ['燐', 'リンサンヒリョウ ノ リン'],
        ['燒', 'ニクヲヤクノヤクノキュウジ'],
        ['營', 'エイギョウノエイ，イトナムノキュウジ'],
        ['燃', 'ネンリョウ ノ ネン，モエル'],
        ['燎', 'リョウゲンノヒノリョウ'],
        ['燉', 'トン，ヒヘンニチュウゴクノトンコウノトン'],
        ['燈', 'トウダイ ノ トウ，ヒヘン ニ ノボル'],
        ['燵', 'コタツノタツ'],
        ['燼', 'カイジンニキスノジン'],
        ['燿', 'ヨウ，ヒヘンニニチヨウビノヨウノツクリ'],
        ['燹', 'セン，ブタノツクリフタツノシタニカヨウビノカ'],
        ['燻', 'クンセイノクン，クスベルノイタイジ'],
        ['燥', 'カンソウキ ノ ソウ'],
        ['燧', 'スイ，ヒヘンニトゲルノキュウジ'],
        ['燦', 'サンゼントカガヤク ノ サン'],
        ['燠', 'イク，ヒヘンニオクバノオクノキュウジ'],
        ['燭', 'ショクダイ ノ ショク，ロウソク ノ ソク'],
        ['燬', 'キ，ヒヘンニメイヨキソンノキ'],
        ['燮', 'チョウワサセルノイミノショウ'],
        ['齒', 'ハブラシノハノキュウジ'],
        ['鰥', 'カン，オトコヤモメノヤモオ'],
        ['麸', 'オフノフ，ムギニオット'],
        ['樵', 'キコリ'],
        ['麺', 'メンルイ ノ メン'],
        ['齟', 'ソゴヲキタスノソ'],
        ['齎', 'モタラス，セイ'],
        ['鰯', 'イワシ，サカナヘン ニ ヨワイ'],
        ['齲', 'ウシノウ，ムシバ'],
        ['X', 'エックス エックスセン'],
        ['齷', 'アクセクスルノアク，ハノキュウジノミギニオクジョウノオク'],
        ['齶', 'アゴ，ガク，ハノキュウジノミギニガクゼントスルノガクノツクリ'],
        ['訳', 'ツウヤク ノ ヤク，ワケ'],
        ['許', 'キョカスル ノ キョ，ユルス'],
        ['閇', 'ヘイテンノヘイ，トジルノイタイジ'],
        ['門', 'センモン ノ モン'],
        ['訶', 'マカフシギノカ'],
        ['閂', 'カンヌキ'],
        ['訴', 'ウッタエル，ソショウ ノ ソ'],
        ['註', 'チュウシャク ノ チュウ，ゴンベン ニ シュジンコウ ノ シュ'],
        ['診', 'シンサツスル ノ シン，ミル'],
        ['閏', 'ウルウドシ ノ ウルウ'],
        ['閉', 'ヘイテン ノ ヘイ，トジル'],
        ['閊', 'ムネガツカエルノツカエル，モンガマエニヤマ'],
        ['証', 'ショウメイショ ノ ショウ'],
        ['訣', 'ケツベツ ノ ケツ，ワカレル'],
        ['閖', 'ロウ，モンガマエニミズ'],
        ['閑', 'カンコドリ ノ カン，ヒマ'],
        ['訥', 'ボクトツノトツ'],
        ['間', 'ジカン ノ カン，アイダ'],
        ['訪', 'ホウモンスル ノ ホウ，オトズレル'],
        ['閘', 'コウ，モンガマエニコウオツノコウ'],
        ['閙', 'ドウ，モンガマエニイチバノイチ'],
        ['設', 'セツビ ノ セツ'],
        ['訓', 'クンレン ノ クン'],
        ['閥', 'ハバツ ノ バツ'],
        ['訐', 'ケツ，ゴンベンニホス'],
        ['託', 'タクジショ ノ タク'],
        ['訖', 'キツ，ゴンベンニアマゴイノコウ'],
        ['関', 'カンケイ ノ カン，セキ'],
        ['閣', 'テンシュカク ノ カク'],
        ['訛', 'オクニナマリノナマリ、カ'],
        ['閭', 'リョ，モンガマエニオフロノロ'],
        ['記', 'キロク ノ キ，シルス'],
        ['訟', 'ソショウ ノ ショウ'],
        ['訝', 'ケゲンナカオノゲン、イブカル'],
        ['訃', 'フホウヲキクノフ'],
        ['訂', 'テイセイスル ノ テイ'],
        ['r', 'アール ルーム'],
        ['閲', 'エツランスル ノ エツ'],
        ['閼', 'フサグヲイミスルモンガマエノアツ'],
        ['訊', 'ジンモン ノ ジン，トウ'],
        ['閾', 'イキ，モンガマエニアルイハノアル'],
        ['計', 'トケイ ノ ケイ，ハカル'],
        ['討', 'トウロンスル ノ トウ'],
        ['訌', 'コウ、ゴンベンニズガコウサクノコウ'],
        ['齧', 'ゲッシルイノゲツ，カジル'],
        ['送', 'ホウソウキョク ノ ソウ，オクル'],
        ['.', 'ピリオド'],
        ['蕀', 'キョク，クサカンムリニキョクヒドウブツノキョク'],
        ['蕁', 'ジンマシンノジン'],
        ['蕃', 'バン，クサカンムリ ニ バンゴウ ノ バン'],
        ['蕎', 'ショクブツ ノ ソバ，キョウ'],
        ['蕈', 'シン，クサカンムリニニシノシタニハヤオキノハヤイ'],
        ['蕉', 'ミズバショウ ノ ショウ'],
        ['蕊', 'メシベ ノ シベ，ズイ'],
        ['蕋', 'メシベノシベ，ズイノイタイジ，クサカンムリニシケツスルノシミッツ'],
        ['蕕', 'ユウ，クサカンムリニユウヨスルノユウ'],
        ['蕗', 'ショクブツ ノ フキ'],
        ['蕘', 'ジョウ，クサカンムリニギョウシュンノギョウノキュウジ'],
        ['蕚', 'ショクブツノハナノガクノイタイジ'],
        ['蕣', 'シュン，クサカンムリニギョウシュンノシュン'],
        ['蕭', 'ショウ，クサカンムリニゲンシュクナノシュクノキュウジ'],
        ['蕨', 'ショクブツ ノ ワラビ'],
        ['蕩', 'ホウトウムスコ ノ トウ'],
        ['蕪', 'ヤサイ ノ カブ'],
        ['蕷', 'ヨ，クサカンムリニアズケル'],
        ['蕾', 'ツボミ，ライ，クサカンムリニカミナリ'],
        ['駁', 'ハンバクスル ノ バク'],
        ['嚔', 'テイ，クサメ'],
        ['嚏', 'テイ，クサメノイタイジ'],
        ['嚊', 'カカアデンカノカカ，クチヘンニハナカゼノハナ'],
        ['嚆', 'ハジマリヲイミスルコウシノコウ'],
        ['嚇', 'イカクスル ノ カク'],
        ['嚀', 'ネイ，クチヘンニテイネイノネイ'],
        ['嚼', 'ソシャクスルノシャク，カム'],
        ['嚴', 'ゲンジュウナノゲン，キビシイノキュウジ'],
        ['嚶', 'オウ，クチヘンニサクラノキュウジノツクリ'],
        ['嚮', 'キョウ，ウマレコキョウノキョウノシタニムカウ'],
        ['嚥', 'エンゲスルノエン'],
        ['嚠', 'リュウ，クチヘンニリュウホウノリュウ'],
        ['嚢', 'ヒョウノウ ノ ノウ，フクロ'],
        ['桾', 'クン，キヘンニショクンノクン'],
        ['桿', 'カン、キヘンニホスノイタイジ'],
        ['桶', 'オケ，フロオケ ノ オケ'],
        ['桷', 'カク，キヘンニツノ'],
        ['桴', 'フ，キヘンニツメノシタニコドモノコ'],
        ['档', 'トウ，キヘンニベントウノトウ'],
        ['桧', 'ショクブツ ノ ヒノキ，キヘン ニ カイシャ ノ カイ'],
        ['桙', 'ウ，ホコ，キヘンニシャカムニノム'],
        ['桟', 'サンバシ ノ サン'],
        ['桜', 'サクラ'],
        ['桝', 'キヘン ノ マス ノ イタイジ'],
        ['桓', 'カンムテンノウ ノ カン'],
        ['桐', 'キリ ノ タンス ノ キリ'],
        ['桑', 'クワノキ ノ クワ，ソウ'],
        ['桔', 'キヘン ニ キチ，キキョウ ノ イチモジメ'],
        ['案', 'アンナイ ノ アイ'],
        ['桎', 'シッコクトナルノシツ，アシカセ，キヘンニゲシノシ'],
        ['桍', 'コ，キヘンニハカマノツクリ'],
        ['桂', 'ゲッケイジュ ノ ケイ，カツラ'],
        ['桃', 'モモタロウ ノ モモ'],
        ['桀', 'ケツ，ゴウケツノケツノツクリ'],
        ['桁', 'ケタハズレ ノ ケタ'],
        ['框', 'アガリカマチノカマチ'],
        ['碆', 'ハ，ハチョウガアウノハノシタニイシバシノイシ'],
        ['碇', 'テイハク ノ テイ，イカリ'],
        ['碁', 'ゴイシ ノ ゴ'],
        ['碎', 'クダク，フンサイスルノサイノキュウジ'],
        ['碌', 'ロク，イシヘンニミドリノキュウジノツクリ'],
        ['碍', 'ユウズウムゲ ノ ゲ，ガイ'],
        ['颪', 'オロシ，ジョウゲノシタノシタニカゼ'],
        ['驥', 'キビニフスノキ'],
        ['碗', 'イシヘン ノ チャワン ノ ワン'],
        ['碕', 'イシヘン ニ キミョウナ ノ キ'],
        ['碓', 'ウス，イシヘン ニ フルトリ'],
        ['碑', 'キネンノヒ ノ ヒ，イシブミ'],
        ['碚', 'ハイ，イシヘンニバイリツノバイノツクリ'],
        ['驫', 'ヒョウ，ウマガミッツ'],
        ['驪', 'レイ，ウマヘンニウルワシイ'],
        ['驕', 'キョウマンナノキョウ，オゴル'],
        ['碧', 'ヘキガン ノ ヘキ'],
        ['驗', 'シケンヲウケルノケンノキュウジ'],
        ['碣', 'ケツ，イシヘンニカッショクノカツノツクリ'],
        ['碯', 'ノウ，イシヘンニズノウノノウノキュウジノツクリ'],
        ['驟', 'シュウウノシュウ，ウマヘンニジュラクダイノジュ'],
        ['碪', 'キヌタ，イシヘンニハナハダシイ'],
        ['驛', 'エキビルノエキノキュウジ'],
        ['碩', 'セキガク ノ セキ，イシヘン ニ ページ'],
        ['驅', 'ヨンリンクドウノク，カケルノキュウジ'],
        ['碵', 'セキ，イシヘンニテイシュクノテイ'],
        ['驀', 'バクシンスルノバク'],
        ['驃', 'ヒョウ，ウマヘンニトウヒョウスルノヒョウ'],
        ['驂', 'サン，ウマヘンニサンカスルノサン，マイルノキュウジ'],
        ['碾', 'テン，イシヘンニハッテンノテン'],
        ['碼', 'ナガサノタンイノヤード'],
        ['確', 'カクニン ノ カク，タシカ'],
        ['駈', 'カケル，ウマヘン ニ オカ'],
        ['颱', 'タイフウヲイミスルタイ，カゼノミギニダイドコロノダイ'],
        ['o', 'オー オープン'],
        ['颶', 'グ，カゼノミギニドウグノグ'],
        ['悒', 'ユウ，リッシンベンニトユウノユウ'],
        ['悗', 'バン，リッシンベンニメンキョノメン'],
        ['悖', 'ボツ，リッシンベンニボッパツスルノボツノヒダリガワ'],
        ['悔', 'コウカイスル ノ カイ，クヤム'],
        ['悛', 'カイシュンノジョウノシュン'],
        ['悚', 'ショウ，リッシンベンニタバ'],
        ['悟', 'サトル，カクゴ ノ ゴ'],
        ['悃', 'コン，リッシンベンニコマル'],
        ['悁', 'エン，リッシンベンニキヌイトノキヌノツクリ'],
        ['悄', 'ショウゼンタルスガタノショウ，リッシンベンニショウゾウガノショウ'],
        ['悋', 'シットヲイミスルリンキノリン'],
        ['闃', 'ケキ，モンガマエニモクテキノモクノシタニイヌ'],
        ['悉', 'シッカイ ノ シツ，コトゴトク'],
        ['悍', 'セイカンナカオツキノカン'],
        ['悌', 'テイ，リッシンベン ニ オトウト'],
        ['悳', 'トク，ドウトクノトクノイタイジ'],
        ['悲', 'ヒゲキ ノ ヒ，カナシイ'],
        ['悶', 'クモンスル ノ モン，モダエル'],
        ['悵', 'チョウ，リッシンベンニチョウタンノチョウ'],
        ['悴', 'ショウスイスルノスイ'],
        ['悸', 'ドウキガスルノキ'],
        ['悽', 'セイ，リッシンベンニフサイノサイ，ツマ'],
        ['悼', 'アイトウ ノ トウ，イタム'],
        ['患', 'カンジャ ノ カン，ワズラウ'],
        ['悠', 'ユウユウジテキ ノ ユウ'],
        ['悧', 'レイリノリ，リッシンベンニケンリノリ'],
        ['悦', 'エツラク ノ エツ，ヨロコブ'],
        ['悪', 'ゼンアク ノ アク，ワルイ'],
        ['悩', 'ナヤム，クノウスル ノ ノウ'],
        ['E', 'イー エッグ'],
        ['闊', 'ウカツナノカツ'],
        ['闖', 'チンニュウスルノチン，モンガマエニウマ'],
        ['闕', 'ケイバツノケッショノケツ'],
        ['誰', 'ダレカサン ノ ダレ'],
        ['課', 'ホウカゴ ノ カ'],
        ['誼', 'ヨシミヲツウズル ノ ヨシミ，ギ'],
        ['調', 'チョウサ ノ チョウ，シラベル'],
        ['誹', 'ヒボウスル ノ ヒ，ソシル'],
        ['誥', 'コウ，ゴンベンニツゲル'],
        ['誤', 'ゴカイスル ノ ゴ，アヤマリ'],
        ['誦', 'シヲアンショウスルノショウ'],
        ['誡', 'カイ，ゴンベンニイマシメル'],
        ['誠', 'セイジツナ ノ セイ，マコト'],
        ['誣', 'ブコクザイノブ'],
        ['読', 'ヨム，ドクショ ノ ドク'],
        ['説', 'セツメイ ノ セツ，トク'],
        ['誨', 'カイ，ゴンベンニマイニチノマイ'],
        ['誕', 'タンジョウビ ノ タン'],
        ['關', 'カンケイスルノカン，セキノキュウジ'],
        ['誑', 'タブラカス，キョウ'],
        ['誓', 'チカウ，セイヤクショ ノ セイ'],
        ['語', 'コクゴ ノ ゴ，カタル'],
        ['誘', 'サソウ，ユウワク ノ ユウ'],
        ['誚', 'ショウ，ゴンベンニショウゾウガノショウ'],
        ['誅', 'テンチュウヲクワエルノチュウ'],
        ['誄', 'ルイ，ゴンベンニライスキ'],
        ['誇', 'ホコリ，コチョウスル ノ コ'],
        ['誂', 'アツラエル，チョウ'],
        ['認', 'カクニン ノ ニン，ミトメル'],
        ['誌', 'ザッシ ノ シ'],
        ['誉', 'メイヨ ノ ヨ，ホマレ'],
        ['闥', 'タツ，モンガマエニハイタツノタツ'],
        ['闢', 'テンチカイビャクノビャク'],
        ['嵌', 'ハメキザイクノハメル，カン'],
        ['嵎', 'グウ，ヤマヘンニグウゼンノグウノツクリ'],
        ['嵋', 'ビ，ヤマヘンニマユゲノマユ'],
        ['嵜', 'ナガサキケンノサキノイタイジ'],
        ['℡', 'テレフォン'],
        ['嵐', 'アラシヤマ ノ アラシ'],
        ['嵒', 'ガン，シナモノノシナノシタニヤマ'],
        ['嵬', 'カイ，ヤマノシタニオニ'],
        ['嵯', 'サガテンノウ ノ サ'],
        ['嵩', 'カサアゲスル ノ カサ'],
        ['嵶', 'タワ，ヤマヘンニヨワイ'],
        ['嵳', 'サ，ヤマノシタニサベツカスルノサ'],
        ['灘', 'ナダ，サンズイ ニ ムズカシイ'],
        ['灑', 'サイ，サンズイニチュウカナベノカ'],
        ['灌', 'カンガイヨウスイノカン'],
        ['嫁', 'ハナヨメ ノ ヨメ'],
        ['災', 'サイナン ノ サイ，ワザワイ'],
        ['灼', 'シャクネツ ノ シャク'],
        ['灸', 'オキュウヲスエル ノ キュウ'],
        ['灰', 'ハイイロ ノ ハイ'],
        ['灯', 'ケイコウトウ ノ トウ'],
        ['火', 'カヨウビ ノ カ，ヒ'],
        ['灣', 'ワンガンノワンノキュウジ'],
        ['嘯', 'ショウ，ウソブク，クチヘンニシシュウノシュウノツクリ'],
        ['嘩', 'クチゲンカ ノ カ'],
        ['嘶', 'イナナク，セイ'],
        ['嘴', 'クチバシ，シ'],
        ['嘲', 'チョウショウスルノチョウ，アザケル'],
        ['嘱', 'ショクタクスル ノ ショク'],
        ['嘸', 'サゾカシノサゾ，クチヘンニムリノム'],
        ['嘆', 'ナゲク，タンガンスル ノ タン'],
        ['嘉', 'カ，ヨロコブ ノ シタガ クワエル'],
        ['嘖', 'サク，クチヘンニセキニンノセキ'],
        ['嘗', 'ガシンショウタン ノ ショウ，ナメル'],
        ['嘔', 'オウトスルノオウ，クチヘンニクベツスルノクノキュウジ'],
        ['嘛', 'ラマキョウノマ，クチヘンニマスイノマ'],
        ['嘘', 'ウソツキ ノ ウソ'],
        ['槽', 'ヨクソウ ノ ソウ'],
        ['槿', 'キン，ショクブツノムクゲ'],
        ['槹', 'コウ，キヘンニサツキノイチモジメ'],
        ['槻', 'ショクブツ ノ ツキ，キヘン ニ キソクテキ ノ キ'],
        ['槲', 'コク，キヘンニツノニホクトシチセイノト'],
        ['槭', 'シュク，キヘンニトオイシンセキノセキ'],
        ['槨', 'カク，キヘンニリンカクノカク'],
        ['槫', 'セン，キヘンニセンモンノセンノキュウジ'],
        ['槧', 'ザン，ザンシンナノザンノシタニモクザイノモク'],
        ['槝', 'カシノキノカシ，キヘンニシマグニノシマ'],
        ['槞', 'ロウ，キヘンニキョウリュウノリュウ'],
        ['様', 'カミサマ ノ サマ，ヨウ'],
        ['℃', 'ドシー'],
        ['槐', 'カイ，ショクブツノエンジュ'],
        ['槓', 'コウ，キヘンニミツグ'],
        ['槌', 'テッツイ ノ ツイ，ツチ'],
        ['槍', 'ヤリナゲ ノ ヤリ'],
        ['槎', 'サ，キヘンニサベツカスルノサ'],
        ['槊', 'サク，ハッサクノサクノシタニモクザイノモク'],
        ['構', 'コウゾウ ノ コウ，カマエル'],
        ['槇', 'ショクブツノマキノキュウジ'],
        ['槁', 'コウ，キヘンニタカイヒクイノタカイ'],
        ['槃', 'ネハンノハン'],
        ['\\', 'エンマーク'],
        ['藏', 'レイゾウコノゾウノイタイジ'],
        ['藍', 'アイイロ ノ アイ，ラン'],
        ['藉', 'セキ，ロウゼキモノノセキ，'],
        ['藁', 'ムギワラ ノ ワラ'],
        ['藜', 'アカザ，レイ'],
        ['藝', 'ゲイジュツノゲイノキュウジ'],
        ['藕', 'グウ，クサカンムリニスキヘンニグウゼンノグウノツクリ，'],
        ['藐', 'バク，クサカンムリニワカサトビボウノボウ'],
        ['藪', 'ヤブ，ソウ'],
        ['鑷', 'ジョウ、カネヘンニミミミッツ'],
        ['藩', 'ハイハンチケン ノ ハン'],
        ['藤', 'フジ ノ ハナ ノ フジ，トウ'],
        ['藥', 'クスリノイタイジ'],
        ['藾', 'ライ，クサカンムリニイライスルノライノキュウジ'],
        ['藺', 'イグサノイ，リン'],
        ['藻', 'ウミ ノ モクズ ノ モ，ソウ'],
        ['藹', 'ワキアイアイノアイ'],
        ['藷', 'クサカンムリ ニ ショクン ノ ショ'],
        ['怕', 'ハ，オソレル，リッシンベンニシロイ'],
        ['怖', 'キョウフ ノ フ，コワイ'],
        ['怐', 'コウ，リッシンベンニハイクノク'],
        ['怒', 'ゲキドスル ノ ド，イカル'],
        ['思', 'フシギ ノ シ，オモウ'],
        ['怜', 'リッシンベン ニ メイレイ ノ レイ'],
        ['怙', 'エコヒイキノコ，リッシンベンニチュウコシャノコ'],
        ['怛', 'ダツ，リッシンベンニガンタンノタン'],
        ['怏', 'オウ，リッシンベンニチュウオウノオウ'],
        ['怎', 'ソウ，サクヤノサクノツクリノシタニココロ'],
        ['怱', 'ソウ，ネギノクサカンムリノシタガワ'],
        ['怺', 'エイ，リッシンベンニエイキュウノエイ'],
        ['急', 'トッキュウ ノ キュウ，イソグ'],
        ['性', 'コセイテキ ノ セイ'],
        ['怦', 'ヒョウ，リッシンベンニヘイワノヘイ'],
        ['怡', 'イ，リッシンベンニダイドコロノダイ'],
        ['怠', 'タイマン ノ タイ，ナマケル'],
        ['怯', 'ヒキョウモノ ノ キョウ，オビエル'],
        ['怩', 'ジクジタルノジ，ハジル'],
        ['怨', 'オンネン ノ オン，ウラミ'],
        ['怫', 'フツ，リッシンベンニドル'],
        ['怪', 'カイブツ ノ カイ，アヤシイ'],
        ['笈', 'オイ，タケカンムリ ニ オヨブ'],
        ['笊', 'ザル'],
        ['笋', 'タケノコ，ジュンノイタイジ'],
        ['笏', 'コツ，クゲノモツシャク'],
        ['笂', 'ウツボ，タケカンムリニヒノマルノマル'],
        ['笄', 'コウガイ，ケイ，タケカンムリニトリイ'],
        ['鯲', 'ドジョウ，ウオヘンニナニナニニオイテノオ'],
        ['笆', 'ハ，タケカンムリニトモエ'],
        ['鯰', 'ナマズ，ウオヘンニザンネンノネン'],
        ['笘', 'チョウ，タケカンムリニドクセンスルノセン'],
        ['笙', 'フエノショウ'],
        ['笛', 'フエヲフク ノ フエ'],
        ['笞', 'ムチ，タケカンムリニダイドコロノダイ'],
        ['鯨', 'クジラ，ホゲイ ノ ゲイ'],
        ['笑', 'エガオ ノ エ，ワラウ'],
        ['鯤', 'コン，ウオヘンニコンチュウノコン'],
        ['鯣', 'スルメ，ウオヘンニボウエキフウノエキ'],
        ['鯢', 'ゲイ，ウオヘンニニラムノツクリ'],
        ['鯡', 'ヒ，ウオヘンニヒジョウグチノヒ'],
        ['笨', 'ホン，タケカンムリニホンモノノホン'],
        ['第', 'ダイイチインショウ ノ ダイ'],
        ['笠', 'ハナガサ ノ カサ'],
        ['鯖', 'サバ，サカナヘン ニ アオ'],
        ['鯔', 'サカナノボラ，ウオヘンニマガリガワノシタニタンボノタ'],
        ['笥', 'タンス ノ ス'],
        ['符', 'ギモンフ ノ フ'],
        ['鯏', 'アサリ，ウオヘンニケンリノリ'],
        ['笹', 'ショクブツ ノ ササ'],
        ['厳', 'ゲンジュウナ ノ ゲン，キビシイ'],
        ['鯊', 'サカナノハゼ，サンズイニスクナイノシタニウオ'],
        ['鯉', 'コイノボリ ノ コイ'],
        ['鯆', 'ホ，ウオヘンニシジンノトホノホ'],
        ['笳', 'カ，アシブエ，タケカンムリニカソクドノカ'],
        ['笵', 'ハン，タケカンムリニカワガハンランスルノハン'],
        ['笶', 'シ，タケカンムリニユミヤノヤ'],
        ['鯀', 'コン，ウオヘンニケイレツノケイ'],
        ['峙', 'タイジスルノジ，ヤマヘンニテラ'],
        ['峇', 'コウ，ヤマノシタニゴウカクノゴウ'],
        ['峅', 'クラ，ヤマヘンニベントウノベン'],
        ['島', 'シマグニ ノ シマ，トウ'],
        ['峰', 'サイコウホウ ノ ホウ，ミネ'],
        ['峽', 'ツガルカイキョウノキョウノキュウジ'],
        ['峻', 'キュウシュンナ ノ シュン'],
        ['峺', 'コウ，ヤマヘンニサラシナノサラ'],
        ['峡', 'ツガルカイキョウ ノ キョウ'],
        ['峠', 'トウゲ ノ チャヤ ノ トウゲ'],
        ['峯', 'ヤマカンムリ ノ ミネ，ホウ'],
        ['峭', 'ショウ，ヤマヘンニショウゾウガノショウ'],
        ['峪', 'ヨク，ヤマヘンニタニ'],
        ['峩', 'ヤマヘンニワレノガノイタイジ'],
        ['峨', 'ヤマヘン ニ ワレ ノ ガ'],
        ['烱', 'ヒヘンケイガンノシノケイノイタイジ'],
        ['烹', 'カッポウギ ノ ホウ'],
        ['烽', 'ノロシヲイミスルホウ，ヒヘンニミネノツクリ'],
        ['烈', 'キョウレツナ ノ レツ'],
        ['烋', 'コウ，キュウジツノキュウニレンガ'],
        ['烏', 'ウゴウノシュウ ノ ウ，カラス'],
        ['烙', 'ラクインヲオスノラク'],
        ['烝', 'ジョウ，スイジョウキノジョウからクサカンムリヲトッタカタチ'],
        ['烟', 'エントツノエンノイタイジ，ヒヘンニインガオウホウのイン'],
        ['㈱', 'カッコカブ'],
        ['㈲', 'カッコユウゲン'],
        ['㈹', 'カッコダイヒョウ'],
        ['s', 'エス スポーツ'],
        ['謾', 'マン、ゴンベンニウナギノツクリ'],
        ['銓', 'セン、カネヘンニゼンコクノゼン'],
        ['銕', 'テツノイタイジ、カネヘンニソンノウジョウイノイ'],
        ['謹', 'キンガシンネン ノ キン'],
        ['銘', 'メイガラ ノ メイ'],
        ['銚', 'オチョウシ ノ チョウ'],
        ['銛', 'モリデツクノモリ'],
        ['謳', 'セイシュンヲオウカスルノオウ'],
        ['銀', 'ギンイロ ノ ギン'],
        ['謬', 'ゴビュウ ノ ビュウ'],
        ['謫', 'タク、ゴンベンニテキハツスルノテキノツクリ'],
        ['銅', 'ドウメダル ノ ドウ'],
        ['謨', 'ボ、ゴンベンニバクダイナノバク'],
        ['謦', 'ケイガイニセッスルノケイ'],
        ['謡', 'ミンヨウ ノ ヨウ'],
        ['謠', 'ミンヨウノヨウノキュウジ'],
        ['謝', 'カンシャスル ノ シャ'],
        ['講', 'コウシュウカイ ノ コウ'],
        ['謚', 'オクリナ，シゴウノシノイタイジ'],
        ['謙', 'ケンソンスル ノ ケン'],
        ['銷', 'ショウ、カネヘンニショウゾウガノショウ'],
        ['謗', 'ヒボウスルノボウ，ソシル'],
        ['咨', 'シ，ハカル，ツギノシタニクチ'],
        ['謔', 'カイギャクノギャク'],
        ['謐', 'セイヒツナノヒツ'],
        ['謎', 'ナゾヲトク ノ ナゾ'],
        ['謌', 'ウタ，カ，ゴンベンニカノウセイノカヲカサネル'],
        ['謇', 'ケン，サムイノシタニテンノカワリニゴンベン'],
        ['謄', 'コセキトウホン ノ トウ'],
        ['謂', 'イワレ，ゴンベン ニ イブクロ ノ イ'],
        ['謁', 'ハイエツスル ノ エツ'],
        ['謀', 'インボウ ノ ボウ，ハカル'],
        ['I', 'アイ インク'],
        ['楊', 'ツマヨウジ ノ ヨウ，ヤナギ'],
        ['楔', 'クサビガタモジノクサビ，セツ'],
        ['楕', 'ダエンケイ ノ ダ'],
        ['楓', 'ショクブツ ノ カエデ，キヘン ニ カゼ'],
        ['楞', 'ロウ，キヘンニアミガシラニオヤカタノカタ'],
        ['楜', 'コ，キヘンニクロコショウノコ'],
        ['楝', 'レン，キヘンニイサメルノツクリ'],
        ['楚', 'シメンソカ ノ ソ'],
        ['楙', 'ボウ，ハヤシノアイダニムジュンノム'],
        ['楢', 'ナラノキ ノ ナラ'],
        ['楠', 'クスノキ ノ クス，キヘン ニ ミナミ'],
        ['楡', 'ニレノキノニレ'],
        ['楮', 'ショクブツノコウゾ'],
        ['楯', 'キヘン ニ ムジュン ノ ジュン，タテ'],
        ['業', 'ジュギョウ ノ ギョウ'],
        ['楪', 'チョウ，キヘンニシャベルノツクリ'],
        ['楫', 'シュウ，キヘンニクチノシタニミミ'],
        ['楷', 'カイショタイノカイ'],
        ['楴', 'テイ，キヘンニテイオウノテイ'],
        ['極', 'ホッキョク ノ キョク'],
        ['楳', 'キヘン ニ ナニガシ ノ ボウ，ウメ'],
        ['楾', 'ハンゾウ，キヘンニイズミ'],
        ['楼', 'マテンロウ ノ ロウ'],
        ['楽', 'オンガク ノ ガク，タノシイ'],
        ['楸', 'シュウ，キヘンニキセツノアキ'],
        ['楹', 'エイ，キヘンニミチル，エイ'],
        ['艘', 'フネヲカゾエルタンイノソウ'],
        ['艙', 'ソウ，フネヘンニカマクラバクフノクラ'],
        ['艚', 'ソウ，フネヘンニソウトウシュウノソウ'],
        ['艝', 'ソリ，フネヘンニユキグニノユキ'],
        ['艟', 'トウ，フネヘンニグリムドウワノドウ'],
        ['艀', 'ハシケ'],
        ['艇', 'ヒコウテイ ノ テイ'],
        ['艱', 'カンナンシンクノカン'],
        ['色', 'イロエンピツ ノ イロ，ショク'],
        ['艶', 'ヨウエンナ ノ エン，ツヤ'],
        ['艷', 'ヨウエンナノエン，ツヤノキュウジ'],
        ['艸', 'ソウ，ブシュノクサカンムリ'],
        ['艾', 'モグサ，ガイ'],
        ['艢', 'ショウ，フネヘンニリンショクノショク'],
        ['艤', 'ギ，フネヘンニギムノギ'],
        ['艦', 'センスイカン ノ カン'],
        ['艨', 'モウ，フネヘンニケイモウスルノモウ'],
        ['艪', 'フナコギニツカウロ，フネヘンニロドンナノロ'],
        ['艫', 'フネノトモ，フネヘンニハゼノキノハゼノツクリ'],
        ['艮', 'ウシトラ ノ コン'],
        ['良', 'カイリョウ ノ リョウ，ヨイ'],
        ['喨', 'リョウ，クチヘンニジンメイ，ショカツリョウノリョウ'],
        ['喩', 'ヒユノユ，タトエル'],
        ['喪', 'モチュウ ノ モ'],
        ['喫', 'キツエンスル ノ キツ'],
        ['喬', 'キョウボク ノ キョウ，タカシ'],
        ['單', 'タンジュンナノタンノキュウジ'],
        ['喧', 'ケンカリョウセイバイ ノ ケン'],
        ['喰', 'クチヘン ニ タベル ノ クウ'],
        ['営', 'エイギョウ ノ エイ，イトナム'],
        ['喉', 'ノドボトケ ノ ノド，コウ'],
        ['喊', 'カンセイヲアゲルノカン，サケブ'],
        ['喋', 'シャベル'],
        ['喀', 'カッケツスルノカク，クチヘンニオキャクノキャク'],
        ['喃', 'ナン，クチヘンニナンボクノナン'],
        ['善', 'ゼンアク ノ ゼン，ヨイ'],
        ['喇', 'ガッキノラッパノラツ'],
        ['喘', 'ゼンソクノゼン'],
        ['喙', 'カイ，クチバシ，タニンゴトニヨウカイスルノカイ'],
        ['喚', 'ショウニンカンモン ノ カン'],
        ['喜', 'キゲキ ノ キ，ヨロコブ'],
        ['喝', 'キョウカツスル ノ カツ'],
        ['喞', 'ショク，カコツ，クチヘンニソク'],
        ['喟', 'キ，クチヘンニイブクロノイ'],
        ['中', 'チュウガク ノ チュウ，ナカ'],
        ['宀', 'ベン，ブシュノウカンムリ'],
        ['它', 'タ，ヘビカラムシヘンヲトッタカタチ'],
        ['宅', 'ジュウタク ノ タク'],
        ['宇', 'ウチュウ ノ ウ'],
        ['守', 'シュビ ノ シュ，マモル'],
        ['安', 'アンシン ノ アン，ヤスイ'],
        ['宋', 'チュウゴク ノ コクメイ ノ ソウ'],
        ['完', 'カンリョウスル ノ カン'],
        ['宍', 'シシ，ウカンムリ ニ カンスウジ ノ ロク'],
        ['宏', 'ウカンムリ ニ ナム ノ コウ'],
        ['宕', 'トウ，アタゴ ノ ニモジメ，ウカンムリ ニ イシ'],
        ['宗', 'シュウキョウカイカク ノ シュウ'],
        ['官', 'ケイサツカン ノ カン'],
        ['宙', 'ウチュウセン ノ チュウ'],
        ['定', 'ヨテイ ノ テイ，サダメル'],
        ['宛', 'アテナ ノ アテ'],
        ['宜', 'ベンギ ノ ギ，ヨロシク'],
        ['宝', 'ホウセキ ノ ホウ，タカラ'],
        ['実', 'ジツリョク ノ ジツ，ミ'],
        ['客', 'オキャク ノ キャク'],
        ['宣', 'センデン ノ セン'],
        ['室', 'キョウシツ ノ シツ'],
        ['宥', 'ナダメル，ユウジョ ノ ユウ'],
        ['宦', 'カンガンノカン，ウカンムリニソウリダイジンノジン'],
        ['宮', 'オミヤマイリ ノ ミヤ，キュウ'],
        ['宰', 'ソウリヲ イミスル サイショウ ノ サイ'],
        ['害', 'サイガイ ノ ガイ'],
        ['宴', 'エンカイ ノ エン，ウタゲ'],
        ['宵', 'ヨイノクチ ノ ヨイ'],
        ['家', 'イエ，カゾク ノ カ'],
        ['宸', 'シン，ウカンムリニジュウニシノタツ'],
        ['容', 'ヨウセキ ノ ヨウ'],
        ['宿', 'シュクハク ノ シュク，ヤド'],
        ['箒', 'ソウ，ホウキ，タケカンムリニソウジキノソウノツクリ'],
        ['算', 'サンスウ ノ サン'],
        ['箔', 'アルミハク ノ ハク'],
        ['箕', 'ノウグ ノ ミ，タケカンムリ ニ ソ'],
        ['箚', 'トウ，タケカンムリニゴウカカクノゴウニリットウ'],
        ['箘', 'キン，タケカンムリニクニガマエノナカニノギヘンノノギ'],
        ['箙', 'フク，エビラ，タケカンムリニヨウフクノフク'],
        ['箟', 'キン，タケカンムリニコンチュウノコン'],
        ['箜', 'ク，タケカンムリニソラ'],
        ['箝', 'カンコウレイノカン'],
        ['箆', 'ヘラ'],
        ['箇', 'カジョウガキ ノ カ'],
        ['箋', 'ショホウセンノセン'],
        ['箏', 'ソウキョクノソウ，コト'],
        ['箍', 'タガガハズレルノタガ'],
        ['箱', 'ハコニツメル ノ ハコ'],
        ['箴', 'シン，タケカンムリニハリキュウノハリノツクリ'],
        ['箸', 'ハシオキ ノ ハシ'],
        ['管', 'カンリスル ノ カン'],
        ['箪', 'タンス ノ タン'],
        ['箭', 'セン，タケカンムリ ニ マエ'],
        ['砧', 'キヌタ，イシヘン ニ ウラナウ'],
        ['乃', 'ノギタイショウ ノ ノ，スナワチ'],
        ['㊨', 'マルミギ'],
        ['㊦', 'マルシタ'],
        ['㊧', 'マルヒダリ'],
        ['㊤', 'マルウエ'],
        ['㊥', 'マルナカ'],
        ['`', 'アクサングラーブ'],
        ['魁', 'キョカイ ノ カキ，サキガケ'],
        ['魃', 'ヒデリヲイミスルカンバツノバツ'],
        ['魂', 'タマシイ，シンコン ノ コン'],
        ['魅', 'ミリョク ノ ミ'],
        ['憚', 'キタンノナイノタン，ハバカル'],
        ['憙', 'キ，キドアイラクノキノシタニココロ'],
        ['憖', 'ギン，ライネンノライノキュウジトイヌノシタニココロ'],
        ['憔', 'ショウスイスルノショウ'],
        ['魍', 'チミモウリョウノモウ'],
        ['憑', 'ヒョウイスルノヒョウ，キツネツキノツク'],
        ['憐', 'カレンナ ノ レン，アワレム'],
        ['魑', 'チミモウリョウリョウノチ'],
        ['憎', 'ニクム，ゾウオ ノ ゾウ'],
        ['憊', 'ヒロウコンパイノハイ'],
        ['憇', 'キュウケイノケイ，イコウノイタイジ'],
        ['魘', 'エンセイカンノエンノシタニオニ'],
        ['魚', 'サカナ，キンギョ ノ ギョ'],
        ['憂', 'ユウウツ ノ ユウ，ウレウ'],
        ['憾', 'イカンナク ノ カン'],
        [
            '憺',
            'クシンサンタンノタン，リッシンベンニタンニンノタンノキュウジノツクリ',
        ],
        ['憶', 'キオク ノ オク，オボエル'],
        ['憲', 'ケンポウキネンビ ノ ケン'],
        ['魯', 'ロ，サカナ ノ シタニ ニチヨウビ ノ ニチ'],
        ['憮', 'ブゼントスルノブ'],
        ['憬', 'ドウケイノマトノケイ，リッシンベンニフウケイノケイ'],
        ['憫', 'レンビンノビン，リッシンベンニモンガマエニブンショウヲカクノブン'],
        ['魴', 'サカナノホウボウノホウ，ウオヘンニオヤカタノカタ'],
        ['憩', 'キュウケイ ノ ケイ，イコウ'],
        ['憧', 'ドウケイ ノ ドウ，アコガレル'],
        ['憤', 'フンガイスル ノ フン，イキドオル'],
        ['鈞', 'キン、カネヘンニヘイキンノキンノツクリ'],
        ['鈑', 'ハン、カネヘンニハンタイスルノハン'],
        ['鈔', 'ショウ、カネヘンニオオイスクナイノスクナイ'],
        ['鈕', 'チュウ、カネヘンニジュウニシノウシ'],
        ['鈎', 'カギ，カネヘン ニ ツツミガマエ ニ ム'],
        ['鈍', 'ドンカンナ ノ ドン，ニブイ'],
        ['睿', 'エイ，ヒエイザンノエイノヒダリガワ'],
        ['⊂', 'シンブブンシュウゴウ'],
        ['鈿', 'ラデンノデン'],
        ['鼾', 'イビキ'],
        ['鈷', 'カネヘン ニ フルイ ノ コ'],
        ['鈴', 'スズムシ ノ スズ'],
        ['鈩', 'ロ、カネヘンニトジマリノト'],
        ['鈬', 'ドウタクノタクノイタイジ'],
        ['6', 'ロク'],
        ['讀', 'ドクショノドク、ヨムノキュウジ'],
        ['讃', 'ゴンベン ノ ツイタ サンビカ ノ サン'],
        ['變', 'ヘンカスルノヘン，カエルノキュウジ'],
        ['讌', 'エン、ゴンベンニツバメ'],
        ['讎', 'フクシュウスルノシュウ、アダノイタイジ'],
        ['讐', 'フクシュウスル ノ シュウ，アダ'],
        ['讓', 'ジョウホスルノジョウ、ユズルノキュウジ'],
        ['讒', 'ザンゲンンスルノザン、ソシル'],
        ['讖', 'ヨゲンヲイミスルゴンベンノシン'],
        ['讙', 'カン，ゴンベンニカンガイヨウスイノカンノツクリ'],
        ['讚', 'ゴンベンノツイタサンビカノサンノイタイジ'],
        ['属', 'フゾク ノ ゾク'],
        ['屑', 'クズイレ ノ クズ'],
        ['屐', 'ゲキ，キグツ，シカバネニギョウニンベンニシエンスルノシ'],
        ['屓', 'ヒイキノキ，シカバネニカイガラノカイ'],
        ['展', 'ハッテン ノ テン'],
        ['屈', 'リクツ ノ クツ'],
        ['屋', 'オクジョウ ノ オク，ヤ'],
        ['届', 'トドケル'],
        ['屍', 'シカバネ'],
        ['屏', 'ビョウブノビョウ'],
        ['屎', 'シニョウノシ，クソ'],
        ['屁', 'ヒ，ヘリクツノヘ'],
        ['局', 'ユウビンキョク ノ キョク'],
        ['居', 'ジュウキョ ノ キョ，イル'],
        ['屆', 'トドケルノキュウジ'],
        ['屹', 'キツリツスルノキツ'],
        ['山', 'ヤマ，サンミャク ノ サン'],
        ['屶', 'カイ，ナタ，ヤマノシタニカタナ'],
        ['屬', 'フゾクノゾクノキュウジ'],
        ['屯', 'チュウトンスル ノ トン'],
        ['屮', 'ヒダリヲイミスルサ，ヤマノナガイタテボウガシタニヌケル'],
        ['屡', 'シバシバ'],
        ['屠', 'トサツスル ノ ト，ホフル'],
        ['履', 'リレキショ ノ リ'],
        ['層', 'コウソウビル ノ ソウ'],
        ['獪', 'ロウカイナノカイ'],
        ['獨', 'ドクリツノドクノキュウジ'],
        ['獣', 'ヤジュウ ノ ジュウ，ケモノ'],
        ['獻', 'ケンケツスルノケンノキュウジ'],
        ['獺', 'ドウブツノカワウソ'],
        ['獸', 'ヤジュウノジュウ，ケモノノキュウジ'],
        ['獲', 'カクトク ノ カク，エル'],
        ['獰', 'ドウモウナノドウ'],
        ['獵', 'リョウジュウノリョウノキュウジ'],
        ['獏', 'ケモノヘンノドウブツノバク'],
        ['獎', 'ショウガクキンノショウノキュウジノイタイジ'],
        ['獅', 'シシマイ ノ イチモジメ ノ シ'],
        ['獄', 'ジゴク ノ ゴク'],
        ['獗', 'ショウケツヲキワメルノケツ'],
        ['唳', 'レイ，クチヘンニモドル'],
        ['唱', 'ガッショウ ノ ショウ，トナエル'],
        ['唸', 'ウナル，クチヘンニザンネンノネン'],
        ['唹', 'オ，クチヘンニナニナニニオイテノオ'],
        ['唾', 'ダエキ ノ ダ，ツバ'],
        ['售', 'シュウ，ウル，フルトリノシタニクチ'],
        ['唯', 'ユイイツ ノ ユイ'],
        ['唐', 'ケントウシ ノ トウ'],
        ['唖', 'アゼントスル ノ ア'],
        ['唔', 'ゴ，クチヘンニタゴサクノゴ'],
        ['唆', 'シサスル ノ サ'],
        ['唇', 'クチビル，シン'],
        ['唄', 'ウタ，クチヘン ニ カイガラ ノ カイ'],
        ['唏', 'キ，クチヘンニキボウノキ'],
        ['絃', 'ゲン，イトヘン ニ ゲンマイ ノ ゲン'],
        ['終', 'シュウギョウシキ ノ シュウ，オワル'],
        ['絆', 'バンソウコウノバン，キズナ'],
        ['絅', 'ケイ，イトヘンニコウジョウシンノコウカラテンヲトッタモノ'],
        ['組', 'クミ，ソシキ ノ ソ'],
        ['絋', 'イトヘンニヒロバノヒロ'],
        ['絏', 'セツ，イトヘンニエイコウダンノエイ'],
        ['絎', 'コウ，イトヘンニリョコウスルノコウ'],
        ['経', 'ケイケンスル ノ ケイ'],
        ['結', 'ケツロン ノ ケツ'],
        ['絖', 'コウ，イトヘンニヒカリ'],
        ['絛', 'ジョウ，ジョウケンノジョウノキュウジノキノカワリニイト'],
        ['絞', 'シボル，コウシュケイ ノ コウ'],
        ['絣', 'カスリノキモノノカスリ'],
        ['絢', 'ケンランゴウカ ノ ケン'],
        ['絡', 'レンラクスル ノ ラク，カラム'],
        ['給', 'キュウショクシツ ノ キュウ'],
        ['絨', 'ソラトブジュウタンノジュウ'],
        ['絮', 'リュウジョノジョ，ワタ'],
        ['絳', 'コウ，イトヘンニコウスイリョウノコウノツクリ'],
        ['絲', 'ケイトノイトノキュウジ，イトフタツ'],
        ['統', 'トウイツ ノ トウ'],
        ['絶', 'ゼッタイテキ ノ ゼツ'],
        ['絵', 'エホン ノ エ'],
        ['絹', 'キヌイト ノ キヌ'],
        ['絽', 'ロノキモノノロ'],
        ['鼡', 'ネズミノイタイジ'],
        ['w', 'ダブリュー ウィンドウ'],
        ['櫁', 'ミツ，キヘンニハチミツノミツ'],
        ['櫂', 'トウ，フネヲコグカイ'],
        ['櫃', 'オヒツノヒツ'],
        ['櫚', 'シュロノキノロ'],
        ['櫛', 'カミヲ トカス クシ'],
        ['櫞', 'クエンサンノエン，キヘンニエンガワノエンノキュウジ'],
        ['櫟', 'クヌギ，レキ，キヘンニオンガクカノガクノキュウジ'],
        ['櫑', 'ライ，キヘンニスイデンノデンガミッツ'],
        ['櫓', 'ヒノミヤグラ ノ ヤグラ'],
        ['櫨', 'ハゼノキ ノ ハゼ'],
        ['櫪', 'レキ，キヘンニレキシカノレキノキュウジタイ'],
        ['櫺', 'レイ，キヘンニアメカンムリニクチミッツ'],
        ['櫻', 'サクラノキュウジ'],
        ['苛', 'イラダツ，カコク ノ カ'],
        ['苙', 'リュウ、クサカンムリニドクリツノリツ'],
        ['苞', 'ホウ、クサカンムリニツツム'],
        ['苟', 'イヤシクモ、クサカンムリニハイクノク'],
        ['苜', 'モク、クサカンムリニモクテキノモク'],
        ['苒', 'ゼン、フタタビノイッカクメノカワリニクサカンムリ'],
        ['苓', 'レイ，クサカンムリ ニ メイレイ ノ レイ'],
        ['苑', 'ジングウガイエン ノ エン'],
        ['M', 'エム マイク'],
        ['苗', 'ナエギ ノ ナエ，ビョウ'],
        ['苔', 'ショクブツ ノ コケ，タイ'],
        ['苅', 'カル，クサカンムリ ノ カル'],
        ['苺', 'クダモノノイチゴ、クサカンムリニハハ'],
        ['苻', 'フ、クサカンムリニフロクノフ'],
        ['苹', 'ヘイ、クサカンムリニヘイボンナノヘイ'],
        ['苳', 'トウ、クサカンムリニフユヤスミノフユ'],
        ['英', 'エイユウ ノ エイ'],
        ['苴', 'ショ、クサカンムリニクミノツクリ'],
        ['苫', 'トマコマイシ ノ トマ'],
        ['苣', 'キョ、クサカンムリニキョダイナノキョ'],
        ['苡', 'イ、クサカンムリニイジョウイカノイ'],
        ['苦', 'クロウ ノ ク，クルシイ'],
        ['苧', 'ショクブツ ノ カラムシ，チョ'],
        ['若', 'ワカモノ ノ ワカ'],
        ['愡', 'ソウ，リッシンベンニネギノクサカンムリノシタガワ'],
        ['愧', 'ザンキニタエナイノキ'],
        [
            '飃',
            'ヒョウヒョウトシタノヒョウノイタイジ，カゼノミギニトウヒョウスルノヒョウ',
        ],
        ['愨', 'マコトヲイミスルカク'],
        ['愬', 'ソ，ハッサクノサクノシタニココロ'],
        ['飄', 'ヒョウヒョウトシタノヒョウ，カゼノヒダリニトウヒョウスルノヒョウ'],
        ['飛', 'ヒコウキ ノ ヒ，トブ'],
        ['食', 'タベル，キュウショク ノ ショク'],
        ['愴', 'ヒソウナノソウ，リッシンベンニカマクラバクフノクラ'],
        ['飜', 'ホンヤクスルノホンノイタイジ'],
        ['愽', 'ハクブツカンノハクノイタイジ'],
        ['愼', 'シンチョウナノシン，ツツシムノキュウジ'],
        ['愿', 'ゲン，ノハラノハラノシタニココロ'],
        ['愾', 'キ，リッシンベンニクウキノキノキュウジ'],
        ['愁', 'アイシュウ ノ シュウ，ウレイ'],
        ['愀', 'ショウ，リッシンベンニキセツノアキ'],
        ['愃', 'セン，リッシンベンニセンデンスルノセン'],
        ['飯', 'ゴハン ノ ハン，メシ'],
        ['飮', 'インリョウスイノイン，ノムノキュウジ'],
        ['飭', 'チョク，ショクヘンニカタカナノノ，ヨコボウニチカラ'],
        ['愆', 'ケン，フエンスルノエンノシタニココロ'],
        ['愉', 'ユカイナ ノ ユ'],
        ['愈', 'ユ，イヨイヨ'],
        ['愍', 'ビン，タミトノブンノシタニココロ'],
        ['意', 'イミ ノ イ'],
        ['愎', 'フク，リッシンベンニオウフクノフクノツクリ'],
        ['愕', 'キョウガクスルノガク'],
        ['飾', 'ソウショクヒン ノ ショク，カザリ'],
        ['飽', 'アキル，ホウワ ノ ホウ'],
        ['飼', 'シイク ノ シ，カウ'],
        ['飲', 'ミズヲノム ノ ノム，イン'],
        ['愛', 'アイスル ノ アイ'],
        ['愚', 'グチ ノ グ，オロカ'],
        ['感', 'カンソウブン ノ カン'],
        ['飴', 'ミズアメ ノ アメ'],
        ['嬋', 'セン，オンナヘンニタンジュンノタンノキュウジ'],
        ['嬉', 'ウレシイ，キ'],
        ['嬌', 'アイキョウガアルノキョウ'],
        ['嬖', 'ヘイ，ヘキエキスルノヘキノシタニオンナ'],
        ['嬪', 'ベッピンノヒン'],
        ['#', 'シャープ'],
        ['嬬', 'ツマ，オンナヘン ニ ヒツジュヒン ノ ジュ'],
        ['嬢', 'オジョウサマ ノ ジョウ'],
        ['⇒', 'ナラバ'],
        ['⇔', 'ドウチ'],
        ['嬲', 'ジョウ，ナブル，オトコ，オンナ，オトコ'],
        ['嬰', 'アカンボウヲ イミスル エイジ ノ エイ'],
        ['嬶', 'カカア，オンナヘンニハナカゼノハナ'],
        ['稔', 'ミノル，ノギヘン ニ ザンネン ノ ネン'],
        ['稗', 'ショクブツ ノ ヒエ'],
        ['稜', 'ヤマ ノ リョウセン ノ リョウ'],
        ['稟', 'リンギショノリン'],
        ['稘', 'キ，ノギヘンニソノ'],
        ['稙', 'チョク，ノギヘンニチョクゼンノチョク'],
        ['稚', 'ヨウチエン ノ チ'],
        ['稀', 'マレ，ノギヘン ニ キボウ ノ キ'],
        ['稍', 'ショウ，ノギヘンニショウゾウガノショウ'],
        ['税', 'ゼイキン ノ ゼイ'],
        ['稈', 'ムギワラヲイミスルバッカンノカン'],
        ['程', 'ニッテイ ノ テイ，ホド'],
        ['稷', 'シャショクノシンノショク，ノギヘン'],
        ['稱', 'イチニンショウノショウノキュウジ'],
        ['稲', 'イネ，イナサク ノ イナ'],
        ['稼', 'カセグ，カ'],
        ['稽', 'ケイコスル'],
        ['稾', 'ゲンコウヨウシノコウノイタイジ'],
        ['稿', 'ゲンコウヨウシ ノ コウ'],
        ['稻', 'イネノキュウジ'],
        ['稠', 'チュウミツナノチュウ'],
        ['種', 'シュルイ ノ シュ，タネ'],
        ['口', 'クチブエ ノ クチ，コウ'],
        ['叢', 'ソウショ ノ ソウ，クサムラ'],
        ['叡', 'ヒエイザン ノ エイ'],
        ['句', 'ハイク ノ ク'],
        ['栴', 'ショクブツ ノ センダン ノ セン'],
        ['叫', 'サケブ，ゼッキョウ ノ キョウ'],
        ['只', 'タダイマ ノ タダ'],
        ['叩', 'カタタキ ノ タタク'],
        ['叨', 'トウ，クチヘンニカタナ'],
        ['可', 'カノウセイ ノ カ'],
        ['叮', 'テイ，クチヘンニイッチョウメノチョウ'],
        ['叭', 'ガッキノラッパノハ'],
        ['召', 'ショウシュウスル ノ ショウ，メス'],
        ['右', 'ミギ，サユウ ノ ユウ'],
        ['史', 'レキシテキ ノ シ'],
        ['叱', 'シカル，シッセキスル ノ シツ'],
        ['台', 'ダイドコロ ノ ダイ'],
        ['号', 'バンゴウ ノ ゴウ'],
        ['叶', 'カナウ，クチヘン ニ ジュウ'],
        ['叺', 'フクロノカマス，クチヘンニハイル'],
        ['司', 'シカイシャ ノ シ'],
        ['參', 'サンカスルノサン，マイルノキュウジ'],
        ['参', 'サンカスル ノ サン，マイル'],
        ['友', 'ユウジン ノ ユウ，トモ'],
        ['及', 'フキュウスル ノ キュウ，オヨブ'],
        ['叉', 'ヤシャ ノ シャ'],
        ['仁', 'ジンギ ノ ジン，ニオウ ノ ニ'],
        ['収', 'シュウニュウ ノ シュウ，オサメル'],
        ['反', 'ハンタイスル ノ ハン'],
        ['双', 'ソウガンキョウ ノ ソウ'],
        ['从', 'シタガウノイタイジ，ヒトフタツ'],
        ['受', 'ジュケン ノ ジュ，ウケル'],
        ['取', 'シュザイ ノ シュ，トル'],
        ['格', 'ゴウカク ノ カク'],
        ['叛', 'ハンラン ノ ハン，ソムク'],
        ['叙', 'ジジョデン ノ ジョ'],
        ['★', 'クロボシ'],
        ['☆', 'ホシジルシ'],
        ['班', 'ハンチョウ ノ ハン'],
        ['珮', 'ハイ，ハイヨウスルノハイノニンベンノカワリニオウヘン'],
        ['珪', 'オウヘン ニ ツチ フタツ ノ ケイ，ケイソウド ノ ケイ'],
        ['珥', 'ジ，オウヘンニミミ'],
        ['今', 'コンゲツ ノ コン，イマ'],
        ['珠', 'シュザン ノ シュ，タマ'],
        ['核', 'カクカゾク ノ カク'],
        ['現', 'ゲンジツ ノ ゲン，アラワレル'],
        ['珸', 'ゴ，オウヘンニコクゴノゴノツクリ'],
        ['珱', 'ヨウ，オウヘンニサクラノツクリ'],
        ['珍', 'メズラシイ，チンミ ノ チン'],
        ['珎', 'メズラシイ，チンミノチンノイタイジ'],
        ['珈', 'カ，コーヒーノアテジノイチモジメ'],
        ['珊', 'サンゴショウ ノ サン'],
        ['珀', 'コハクイロノハク'],
        ['珂', 'オウヘン ニ カノウセイ ノ カ'],
        ['珞', 'ラク，オウヘンニカクジノカク'],
        ['栫', 'ソン，キヘンニソンザイスルノソン'],
        ['仙', 'センニン ノ セン，ニンベン ニ ヤマ'],
        ['㌫', 'カナパーセント'],
        ['㌦', 'カナドル'],
        ['㌧', 'カナトン'],
        ['栗', 'クリノキ ノ クリ'],
        ['㌢', 'カナセンチ'],
        ['㌣', 'カナセント'],
        ['栖', 'スム，セイ，キヘン ニ ニシ'],
        ['㌻', 'カナページ'],
        ['㌶', 'カナヘクタール'],
        ['㌍', 'カナカロリー'],
        ['㌃', 'カナアール'],
        ['㌘', 'カナグラム'],
        ['㌔', 'カナキリ'],
        ['仭', 'フカサノタンイノジンノイタイジ，ニンベンニヤイバノイタイジ'],
        ['价', 'カイ，ニンベンニチュウカイスルノカイ'],
        ['栃', 'トチギケン ノ トチ'],
        ['d', 'ディー デスク'],
        ['驢', 'ドウブツノロバノロ'],
        ['鎚', 'カネヘン ノ ツチ'],
        ['鎔', 'ヨウ、カネヘンニヨウセキノヨウ'],
        ['鎖', 'サコク ノ サ，クサリ'],
        ['鎗', 'ヤリ，カネヘン ニ クラ，ソウ'],
        ['鎌', 'カマクラ ノ カマ'],
        ['鎹', 'コハカスガイノカスガイ'],
        ['鎰', 'イツ、カネヘンニリエキノエキ'],
        ['鎬', 'シノギヲケズルノシノギ'],
        ['鎭', 'チンアツスルノチン，シズメルノキュウジ'],
        ['鎮', 'チンアツスル ノ チン，シズメル'],
        ['鎧', 'ヨロイ，ガイシュウイッショク ノ ガイ'],
        ['蠏', 'カニノイタイジ，ムシヘンニカイケツスルノカイ'],
        ['蠎', 'ウワバミヲイミスルボウ，クサカンムリニホンソウスルノホン'],
        ['蠍', 'サソリ'],
        ['蠅', 'ムシノハエ'],
        ['蠑', 'エイ，ムシヘンニサカエルノキュウジ'],
        ['蠖', 'カク，ムシヘンニカクトクスルノカクノツクリ'],
        ['蠕', 'ゼンドウウンンドウノゼン'],
        ['蠣', 'カキ，ムシヘンニゲキレイスルノレイノキュウジノヒダリガワ'],
        ['蠢', 'ウゴメク，シュン'],
        ['蠡', 'レイ，ケイガシラニイノコ，ソノシタニムシフタツ'],
        ['蠧', 'ホンニツクムシノトギョノト'],
        ['蠻', 'ナンバンボウエキノバンノキュウジ'],
        ['蠹', 'ホンニツクムシノトギョノトノイタイジ'],
        ['蠱', 'コワクスルノコ，ムシミッツノシタニサラ'],
        ['蠶', 'ヨウサンノサン，カイコノキュウジ'],
        ['橘', 'タチバナ，カンキツ ノ キツ'],
        ['橙', 'トウ，ショクブツノダイダイ'],
        ['機', 'ヒコウキ ノ キ'],
        ['橇', 'セイ，ノリモノノソリ'],
        ['橄', 'カンランサンノカン，キヘンニユウカンナノカン'],
        ['橋', 'ホドウキョウ ノ キョウ，ハシ'],
        ['橈', 'ドウ，タワム，トウコツノトウ'],
        ['鼓', 'タイコ ノ コ，ツヅミ'],
        ['橲', 'ジサ，キヘンニキゲキノキ'],
        ['橸', 'マサ，キヘンニスイショウダマノショウ'],
        ['橿', 'カシハラジングウ ノ カシ'],
        ['橢', 'ダエンケイノダノキュウジ'],
        ['橡', 'キヘン ニ ドウブツ ノ ゾウ，トチ'],
        ['橦', 'トウ，キヘンニワラベ'],
        [':', 'コロン'],
        ['荘', 'ベッソウチ ノ ソウ'],
        ['荐', 'セン，クサカンムリニソンザイスルノソン'],
        ['荒', 'アレル，コウヤ ノ コウ'],
        ['荏', 'エゴマ ノ エ'],
        ['草', 'クサ，ソウゲン ノ ソウ'],
        ['荊', 'クサカンムリ ニ ケイムショ ノ ケイ，イバラ'],
        ['荅', 'トウ，クサカンムリニゴウカクノゴウ'],
        ['荀', 'ジュン，クサカンムリニゲジュンノジュン'],
        ['作', 'サクブン ノ サク，ツクル'],
        ['荼', 'ダビニフスノダ'],
        ['荻', 'オギ'],
        ['荵', 'ニン、クサカンムリニニンジャノニン'],
        ['荷', 'ニモツ ノ ニ'],
        ['荳', 'トウ、マメ、クサカンムリニマメモチノマメ'],
        ['咲', 'ハナガサク ノ サク'],
        ['咳', 'セキバライ ノ セキ'],
        ['咼', 'カ，ナベノツクリ'],
        ['咽', 'ジビインコウカ ノ イン，ノド'],
        ['咾', 'ロウ，クチヘンニロウジンノロウ'],
        ['咸', 'シンノミヤコ，カンヨウノカン'],
        ['咤', 'シッタゲキレイノタ，クチヘンニジュウタクノタク'],
        ['咥', 'テツ，クチヘンニゲシノシ'],
        ['咢', 'ガク，キョウガクスルノガクノツクリ'],
        ['咬', 'カム，コウ，クチヘンニマジワル'],
        ['咯', 'ラク，クチヘンニオノオノ'],
        ['茆', 'ボウ、クサカンムリニジュウニシノウサギ'],
        ['咫', 'ナガサノタンイノシ，シャクハチノシャクノミギニタダイマノタダ'],
        ['咐', 'ホ，クチヘンニフロクノフ，ツケル'],
        ['咒', 'ノロウ，ジュモンノジュノイタイジ'],
        ['咄', 'トッサノトツ，クチヘンニデル'],
        ['咆', 'トラノホウコウノホウ，ホエル'],
        ['咀', 'カミクダクイミノソシャクノソ'],
        ['和', 'ワフク ノ ワ'],
        ['咎', 'トガメル'],
        ['咏', 'エイ，クチヘンニエイキュウノエイ'],
        ['咋', 'サクネン ノ サク ノ ヒヘン ノ カワリニ クチヘン'],
        ['緇', 'シ，イトヘンニシチョウヘイノシノツクリ'],
        ['総', 'ソウリダイジン ノ ソウ'],
        ['緋', 'ヒイロ ノ ヒ'],
        ['緊', 'キンキュウ ノ キン'],
        ['緕', 'シ，イトヘンニイッセイシャゲキノセイ'],
        ['緑', 'ミドリ，リョクチャ ノ リョク'],
        ['緒', 'ナイショ ノ ショ'],
        ['緝', 'シュウ，イトヘンニクチノシタニミミ'],
        ['緜', 'モメンノメンノイタイジ'],
        ['緞', 'ドンスノドン，イトヘンニネダンノダン'],
        ['緘', 'カンモクノカン，イトヘンニシンノミヤコカンヨウノカン，'],
        ['線', 'センロ ノ セン'],
        ['緤', 'セツ，イトヘンニシャベルノツクリ'],
        ['緡', 'ビン，イトヘンニタミノシタニマイニチノニチ'],
        ['締', 'テイケツスル ノ テイ，シメル'],
        ['緬', 'チリメン ノ メン'],
        ['緯', 'イドケイド ノ イ'],
        ['緩', 'ユルヤカ，カンワスル ノ カン'],
        ['編', 'ヘンシュウスル ノ ヘン，アム'],
        ['練', 'レンシュウ ノ レン'],
        ['緲', 'ビョウ，イトヘンニモクテキノモクニスクナイ'],
        ['緻', 'チミツナノチ'],
        ['骰', 'トウ，ホネヘンニナゲルノツクリ'],
        ['Ⅸ', 'ローマスウジ キュウ'],
        ['Ⅹ', 'ローマスウジ ジュウ'],
        ['Ⅲ', 'ローマスウジ サン'],
        ['Ⅳ', 'ローマスウジ ヨン'],
        ['Ⅰ', 'ローマスウジ イチ'],
        ['Ⅱ', 'ローマスウジ ニ'],
        ['Ⅶ', 'ローマスウジ ナナ'],
        ['Ⅷ', 'ローマスウジ ハチ'],
        ['Ⅴ', 'ローマスウジ ゴ'],
        ['Ⅵ', 'ローマスウジ ロク'],
        ['媚', 'ビヤクノビ，コビル'],
        ['媛', 'エヒメケン ノ ヒメ'],
        ['媒', 'バイカイスル ノ バイ'],
        ['媼', 'オウ，オンナヘンニオンセンノオンノキュウジノツクリ'],
        ['媽', 'ボ，オンナヘンニウマ'],
        ['媾', 'コウ，オンナヘンニミゾノツクリ'],
        ['窟', 'ドウクツ ノ クツ'],
        ['窘', 'タシナメル，キン'],
        ['窖', 'コウ，アナカンムリニツゲル'],
        ['窗', 'マドノイタイジ'],
        [
            '窕',
            'ヨウチョウタルビジンノチョウ，アナカンムリニイッチョウエンノチョウ',
        ],
        ['窒', 'チッソ ノ チツ'],
        ['窓', 'マドグチ ノ マド，ソウ'],
        ['窈', 'ヨウチョウタルビジンノヨウ，アナカンムリニオサナイ'],
        ['窄', 'シヤキョウサク ノ サク，スボマル'],
        ['窃', 'セットウハン ノ セツ'],
        ['突', 'ショウトツスル ノ トツ，ツク'],
        ['窿', 'リュウ，アナカンムリニリュウキスルノリュウノキュウジ'],
        ['窺', 'アナカンムリ ノ ウカガウ'],
        ['窶', 'ヤツレル，ク'],
        ['窰', 'カマモトノカマノイタイジ'],
        ['窮', 'キュウクツ ノ キュウ，キワマル'],
        ['窯', 'カマモト ノ カマ，ヨウ'],
        ['窪', 'クボム，クボチ ノ クボ'],
        ['窩', 'カ，アナカンムリニナベノツクリ'],
        ['{', 'チュウカッコ'],
        ['額', 'キンガク ノ ガク，ヒタイ'],
        ['㎡', 'ヘイホウメートル'],
        ['㎞', 'キロメートル'],
        ['㎜', 'ミリメートル'],
        ['㎝', 'センチメートル'],
        ['㎎', 'ミリグラム'],
        ['㎏', 'キログラム'],
        ['披', 'ヒロウエン ノ ヒ'],
        ['題', 'シュクジュダイ ノ ダイ'],
        ['顏', 'カオ，ガンメンノガンノキュウジ'],
        ['顎', 'アゴ，ガク'],
        ['顛', 'コト ノ テンマツ ノ テン'],
        ['顋', 'エラ，フシギノシノミギニページ'],
        ['抬', 'タイ，テヘンニダイドコロノダイ'],
        ['顆', 'カリュウノカ，ツブ'],
        ['抻', 'シン，テヘンニシンコクスルノシン'],
        ['抹', 'マッチャ ノ マツ'],
        ['類', 'ジンルイ ノ ルイ'],
        ['願', 'ガンボウ ノ ガン，ネガウ'],
        ['抽', 'チュウセン ノ チュウ'],
        ['押', 'オウシュウスル ノ オウ，オス'],
        ['顕', 'ケンビキョウ ノ ケン，アキラカ'],
        ['顔', 'カオイロ ノ カオ，ガン'],
        ['抱', 'ホウフヲカタル ノ ホウ，ダク'],
        ['抵', 'テイコウスル ノ テイ'],
        ['把', 'ハアクスル ノ ハ'],
        ['抉', 'ケツ，テヘンニタスウケツノケツノツクリ'],
        ['顫', 'セン，ブツダンノダンノツクリノミギニページ'],
        ['抃', 'ベンブスルノベン，テヘンニナベブタノシタニカタカナノト'],
        ['抂', 'キョウ，テヘンニオウサマノオウ'],
        ['顧', 'コモン ノ コ，カエリミル'],
        ['技', 'ギジュツ ノ ギ，ワザ'],
        ['抄', 'コセキショウホン ノ ショウ'],
        ['抛', 'ホウテキスルノホウ，テヘンニカンスウジノキュウニチカラ'],
        ['折', 'コッセツ ノ セツ，オル'],
        ['択', 'センタクシ ノ タク'],
        ['抜', 'バツグン ノ バツ，ヌケル'],
        ['抓', 'ソウ，ツネル，テヘンニツメ'],
        ['抒', 'ジョジョウシノジョ，テヘンニヨテイノヨ'],
        ['抑', 'ヨクセイスル ノ ヨク，オサエル'],
        ['抗', 'テイコウスル ノ コウ'],
        ['抖', 'トウ，テヘンニホクトシチセイノト'],
        ['投', 'トウシュ ノ トウ，ナゲル'],
        ['抔', 'ホウ，テヘンニフシギノフ'],
        ['顯', 'ケンビキョウノケンノキュウジ'],
        ['Q', 'キュー クエスチョン'],
        ['沃', 'ヒヨクナトチ ノ ヨク'],
        ['沂', 'ギ，サンズイニショクパンイッキンノキン'],
        ['沁', 'シン，シミル，サンズイニココロ'],
        ['錢', 'ツリセンノセンノキュウジ'],
        ['錣', 'テツ、カネヘンニツヅルノツクリ'],
        ['錠', 'テジョウ ノ ジョウ'],
        ['錮', 'キンコケイノコ、カネヘンニカタメル'],
        ['錯', 'サクランスル ノ サク'],
        ['錬', 'レンキンジュツ ノ レン'],
        ['沈', 'チンボツスル ノ チン，シズム'],
        ['錫', 'キンゾク ノ スズ，シャク'],
        ['沍', 'ゴ，サンズイニタガイ'],
        ['沌', 'コントントシタ ノ トン'],
        ['沓', 'クツ，ミズ ノ シタニ ヒ'],
        ['沒', 'チンボツスルノボツノキュウジ'],
        ['沐', 'モクヨクスルノモク'],
        ['録', 'ロクオン ノ ロク'],
        ['沖', 'オキ，オキナワケン ノ オキ'],
        ['沛', 'ハイゼンタルアメのハイ'],
        ['沚', 'シ，サンズイニキンシスルノシ'],
        ['沙', 'ゴブサタ ノ サ，サンズイ ニ スクナイ'],
        ['錺', 'カザリ、カネヘンニホウコウザイノホウ'],
        ['錻', 'ブリキノブ、カネヘンニブキノブ'],
        ['錆', 'サビドメ ノ サビ'],
        ['沢', 'コウタク ノ タク，サワ'],
        ['没', 'チンボツスル ノ ボツ'],
        ['沫', 'ホウマツ ノ マツ，サンズイ ニ スエ'],
        ['錏', 'ア、カネヘンニアジアノアノキュウジ'],
        ['沮', 'イキソソウノソ，サンズイニソシスルノソノツクリ'],
        ['河', 'サンズイ ノ カワ'],
        ['沱', 'ダ，サンズイニブッダノダノツクリ'],
        ['錐', 'シカクスイ ノ スイ'],
        ['治', 'セイジ ノ ジオサメル'],
        ['沺', 'テン，サンズイニスイデンノデン'],
        ['油', 'セイキユ ノ ユ，アブラ'],
        ['沸', 'フットウスル ノ フツ，ワク'],
        ['沿', 'エンガン ノ エン，ソウ'],
        ['沾', 'テン，サンズイニドクセンスルノセン'],
        ['沽', 'コケンニカカワルノコ，サンズイニチュウコヒンノコ'],
        ['沼', 'ヌマチ ノ ヌマ，ショウ'],
        ['袍', 'ホウ、コロモヘンニツツム'],
        ['袈', 'オボウサン ノ ケサ ノ ケ'],
        ['袋', 'フクロ，ユウタイルイ ノ タイ'],
        ['袁', 'エン，ルイジンエンノエンノツクリ'],
        ['袂', 'タモト'],
        ['袞', 'コンリョウノソデノコン'],
        ['袙', 'バク、コロモヘンニクロシロノシロ'],
        ['顴', 'ケン，カンヅメノカンノキュウジノツクリノミギニページ'],
        ['袗', 'シン、コロモヘンニシンサツシツノシンノツクリ'],
        ['袖', 'フリソデ ノ ソデ'],
        ['袒', 'サタンスルノタン、ハダヌグ'],
        ['袮', 'ネ、コロモヘンニイチニンショウノショウノツクリ'],
        ['被', 'ヒガイシャ ノ ヒ，コウムル'],
        ['袤', 'ボウ，コロモノアイダニムジュンノム'],
        ['袢', 'ジュバンノバン'],
        ['袿', 'ケイ、コロモヘンニツチフタツ'],
        ['顳', 'ジョウ，ミミミッツノミギニページ'],
        ['袵', 'ジン、コロモヘンニセキニンノニン'],
        ['袴', 'ハオリハカマ ノ ハカマ'],
        ['袷', 'アワセ，コロモヘン ニ ゴウカク ノ ゴウ'],
        ['袱', 'フク、チャブダイノニモジメ'],
        ['袰', 'ホロ、ハハノシタニコロモ'],
        ['卦', 'ハッケ ノ ケ'],
        ['占', 'ドクセンスル ノ セン，シメル'],
        ['卯', 'ウ，ジュウニシ ノ ウサギ'],
        ['卮', 'シ，サカズキ'],
        ['卩', 'セツ，ブシュノワリフ'],
        ['卵', 'タマゴ'],
        ['却', 'ヘンキャクスル ノ キャク'],
        ['卷', 'カン，ノリマキノマキノキュウジ'],
        ['危', 'キケン ノ キ，アブナイ'],
        ['印', 'インサツ ノ イン'],
        ['即', 'ソクザニ ノ ソク，スナワチ'],
        ['卿', 'キョウ，スウキケイ ノ ケイ'],
        ['卸', 'オロシウリ ノ オロシ'],
        ['卻', 'ヘンキャクスルノキャクノイタイジ'],
        ['卅', 'ソウ，カンスウジノサンジュウ'],
        ['升', 'イッショウビン ノ ショウ，マス'],
        ['卆', 'ソツギョウノソツノイタイジ'],
        ['十', 'カンスウジ ノ ジュウ'],
        ['區', 'クベツスルノクノキュウジ'],
        ['\'', 'アポストロフィ'],
        ['卍', 'マンジ'],
        ['卉', 'カキエンゲイノキ'],
        ['午', 'ショウゴ ノ ゴ'],
        ['半', 'ハンブン ノ ハン，ナカバ'],
        ['協', 'キョウリョクスル ノ キョウ'],
        ['南', 'ナンボク ノ ナン，ミナミ'],
        ['卑', 'ヒレツナ ノ ヒ，イヤシイ'],
        ['卓', 'タッキュウ ノ タク'],
        ['卒', 'ソツギョウ ノ ソツ'],
        ['卜', 'ウラナウ，ボク'],
        ['卞', 'ベン，ナベブタノシタニカタカナノト'],
        ['単', 'タンジュン ノ タン'],
        ['博', 'ハクブツカン ノ ハク'],
        ['牴', 'テイ，ウシヘンニヒクイノツクリ'],
        ['牲', 'ギセイシャ ノ セイ'],
        ['牾', 'ゴ，ウシヘンニコクゴノゴノツクリ'],
        ['牽', 'ケンインスル ノ ケン'],
        ['特', 'トクベツ ノ トク'],
        ['牧', 'ボクジョウ ノ ボク'],
        ['牢', 'ロウヤ ノ ロウ'],
        ['牡', 'ハナ ノ ボタン ノ ボ，オス'],
        ['物', 'ドウブツ ノ ブツ，モノ'],
        ['牒', 'サイゴツウチョウ ノ チョウ，フダ'],
        ['牟', 'シャカムニ ノ ム，ム ノ シタニ ウシ'],
        ['牝', 'ヒンバ ノ ヒン，メス'],
        ['牛', 'ウシ，ギュウニュウ ノ ギュウ'],
        ['牙', 'ゾウゲ ノ ゲ，キバ'],
        ['牘', 'トク，カタヘンニハンバイスルノバイノキュウジ'],
        ['片', 'カタオモイ ノ カタ，ヘン'],
        ['牆', 'ショウ，カキ，ショウヘンニリンショクノショク'],
        ['牀', 'コシカケノショウギノショウ，ショウヘンニクサキノキ'],
        ['牌', 'イハイ ノ ハイ，フダ'],
        ['牋', 'ショホウセンノセンノイタイジ'],
        ['版', 'モクハンガ ノ ハン'],
        ['吾', 'ワレ，ゴ，カンスウジ ノ ゴ ノ シタニ クチ'],
        ['吼', 'シシクノク，クチヘンニコウシモウシノコウ'],
        ['吽', 'アウンノコキュウノウン，クチヘンニドウブツノウシ'],
        ['吻', 'セップンスル ノ フン'],
        ['吸', 'コキュウスル ノ キュウ，スウ'],
        ['吹', 'スイソウガク ノ スイ，フク'],
        ['吶', 'トツベンノトツ，クチヘンニコクナイノナイ'],
        ['吮', 'セン，クチヘンニカタカナノムノシタニヒトアシ'],
        ['听', 'オモサノタンイノポンド'],
        ['吭', 'コウ，クチヘンニテイコウスルノコウノツクリ'],
        ['含', 'フクム，ガンチク ノ ガン'],
        ['吩', 'フン，クチヘンニハンブンノブン'],
        ['否', 'ヒテイスル ノ ヒ'],
        ['吠', 'ホエル，クチヘン ニ イヌ'],
        ['吟', 'ギンミスル ノ ギン'],
        ['吝', 'リンショクカノリン'],
        ['君', 'ショクン ノ クン，キミ'],
        ['閃', 'ヒラメキ，センコウ ノ セン'],
        ['吐', 'トイキ ノ ト，ハク'],
        ['向', 'コウジョウスル ノ コウ，ムカウ'],
        ['后', 'コウゴウ ノ ゴウ，キサキ'],
        ['吏', 'ヤクニンヲ イミスル カンリ ノ リ'],
        ['同', 'オナジ，ドウジ ノ ドウ'],
        ['名', 'ナマエ ノ ナ，メイ'],
        ['吊', 'ツルス，クチ ノ シタニ ハバ'],
        ['吋', 'ナガサ ノ タンイ ノ インチ'],
        ['合', 'ゴウカク ノ ゴウ，アウ'],
        ['吉', 'キチトキョウ ノ キチ，ヨシ'],
        ['各', 'カクジ ノ カク，オノオノ'],
        ['吃', 'ドモル，キツオン ノ キツ'],
        ['吁', 'ク，クチヘンニウチュウノウノウカンムリヲトッタモノ'],
        ['籏', 'ハタ，タケカンムリニハタヲフルノハタ'],
        ['籍', 'コクセキ ノ セキ'],
        ['籌', 'チュウ，タケカンムリニコトブキノキュウジ'],
        ['籃', 'ヨウランキノラン'],
        ['籀', 'チュウ，タケカンムリニテヘントリュウガクセイノシュウ'],
        ['籟', 'ライ，タケカンムリニイライスルノライノキュウジ'],
        ['籘', 'トウイスノトウノイタイジ'],
        ['籖', 'クジビキノクジ，センノイタイジ'],
        ['籔', 'ス，タケカンムリニカズノキュウジ'],
        ['籐', 'トウイスノトウ'],
        ['閔', 'ビン，モンガマエニブンショウヲカクノブン'],
        ['籬', 'リ，マガキ'],
        ['籥', 'ヤク，タケカンムリニブシュノヤク'],
        ['籤', 'クジビキノクジ，セン'],
        ['籠', 'ロウジョウスルノロウ，カゴ'],
        ['籾', 'モミガラ ノ モミ'],
        ['籵', 'ナガサノタンイノデカメートル'],
        ['米', 'コメ，シンマイ ノ マイ'],
        ['閤', 'タイコウキ ノ コウ'],
        ['閧', 'コウ，モンガマエニキョウツウテンノキョウ'],
        ['閠', 'ウルウドシノウルウノイタイジ'],
        ['錦', 'ニシキ，キン'],
        ['閨', 'ケイボウノケイ，ネヤ'],
        ['言', 'ゲンゴ ノ ゲン，イウ'],
        ['錨', 'イカリ，カネヘン ニ ナエ'],
        ['h', 'エイチ ホテル'],
        ['閹', 'エン，モンガマエニキソクエンエンノエン'],
        ['錵', 'ニエ、カネヘンニハナビノハナ'],
        ['閻', 'エンマサマノエン'],
        ['比', 'ヒカクスル ノ ヒ，クラベル'],
        ['毒', 'ショウドク ノ ドク'],
        ['毓', 'イク，マイニチノマイニナガレルノツクリ'],
        ['毟', 'ムシル，スクナイノシタニウモウノモウ'],
        ['毘', 'ビシャモンテン ノ ビ'],
        ['毛', 'ケイト ノ ケ，ウモウ ノ モウ'],
        ['毅', 'キゼントシタ ノ キ'],
        ['毆', 'オウダスルノオウ，ナグルノキュウジ'],
        ['毀', 'メイヨキソンノキ'],
        ['母', 'フボ ノ ボ，ハハ'],
        ['毎', 'マイニチ ノ マイ'],
        ['毋', 'ブ，ナカレ，マイニチノマイノシタガワ'],
        ['毳', 'セイ，ウモウノモウガミッツ'],
        ['毬', 'マリ，ウモウノモウノミギニモトメル'],
        ['毯', 'ジュウタンノタン，ウモウノモウニホノオ'],
        ['毫', 'キゴウスルノゴウ'],
        ['菠', 'ハ、クサカンムリニハチョウガアウノハ'],
        ['華', 'ゴウカ ノ カ，ハナヤカ'],
        ['菫', 'ショクブツノスミレ'],
        ['菩', 'ボダイジュ ノ ボ'],
        ['菷', 'ソウ、ホウキ，クサカンムリニソウジキノソウノツクリ'],
        ['菴', 'アン，イオリ，クサカンムリニキソクエンエンノエン'],
        ['菲', 'ヒ、クサカンムリニヒジョウグチノヒ'],
        ['菰', 'コモカブリ ノ コモ，クサカンムリ ニ コドク ノ コ'],
        ['菱', 'ヒシガタ ノ ヒシ'],
        ['菽', 'シュク、クサカンムリニシュクジョノシュクノツクリ'],
        ['菻', 'リン、クサカンムリニゾウキバヤシノハヤシ'],
        ['菅', 'スゲガサ ノ スゲ，カン'],
        ['菁', 'セイ、カブ、クサカンムリニセイシュンノセイノキュウジタイ'],
        ['菎', 'コン、クサカンムリニコンチュウノコン'],
        ['菌', 'サッキンスル ノ キン'],
        ['菊', 'キクニンギョウ ノ キク'],
        ['菖', 'ハナショウブ ノ ショウ'],
        ['菓', 'オカシ ノ カ'],
        ['菟', 'ト，クサカンムリ ニ ウサギ'],
        ['菜', 'ヤサイ ノ サイ，ナ'],
        ['菘', 'スズナ、クサカンムリニマツノキノマツ'],
        ['戯', 'ギキョク ノ ギ'],
        ['戮', 'サツリクスルノリク'],
        ['駒', 'コマ，ウマヘン ニ ハイク ノ ク'],
        ['駑', 'ドバノド，ヤッコノシタニウマ'],
        ['截', 'セツゼンタルノセツ，サイバイスルノサイノキノカワリニフルトリ'],
        ['駟', 'シ，ウマヘンニカンスウジノヨン'],
        ['駝', 'ドウブツノラクダノダ'],
        ['戦', 'センソウ ノ セン，タタカウ'],
        ['戡', 'カン，ハナハダシイノミギニホコヅクリ'],
        ['駘', 'シュンプタイトウノタイ'],
        ['駆', 'ヨンリンクドウ ノ ク，カケル'],
        ['房', 'レイダンボウ ノ ボウ'],
        ['駄', 'ダガシ ノ ダ'],
        ['戸', 'トジマリ ノ ト，コ'],
        ['戻', 'モドル，ヘンレイキン ノ レイ'],
        ['戴', 'タイカンシキ ノ タイ，イタダク'],
        ['戰', 'センソウノセン，タタカウノキュウジ'],
        ['戳', 'タク，センタクモノノタクノツクリニホコヅクリ'],
        ['戲', 'ギキョクノギノキュウジ'],
        ['戍', 'ジュ，マモル，ボシンセンソウノボノナカニテン'],
        ['戌', 'ジュツ，ジュウニシノイヌ'],
        ['戎', 'エビス，ホコガマエ ノ ジュウ'],
        ['戉', 'マサカリ，エツ，カネヘンナシ'],
        ['戈', 'カ，ブシュノホコヅクリ'],
        ['駱', 'ドウブツノラクダノラク'],
        ['戊', 'ボシンセンソウ ノ ボ'],
        ['駿', 'シュンメ ノ シュン'],
        ['駻', 'カンバノカン，アラウマ'],
        ['戀', 'コイビトノコイノキュウジ'],
        ['駸', 'シン，ウマヘンニシンリャクスルノシンノツクリ'],
        ['戝', 'サンゾクノゾクノイタイジ'],
        ['戟', 'シゲキスル ノ ゲキ，ホコ'],
        ['戞', 'カツ，ユウウツノユウノウエガワニホコヅクリ'],
        ['駢', 'ヘン，ウマヘンニヘイヨウスルノヘイノツクリ'],
        ['戛', 'カツ，ページノハノカワリニホコヅクリ'],
        ['戚', 'トオイシンセキ ノ セキ'],
        ['戔', 'サン，アサイノキュウジノツクリ'],
        ['駭', 'ガイ，オドロク，ウマヘンニジュウニシノイノシシ'],
        ['或', 'アルイハ ノ アル'],
        ['我', 'ガマン ノ ガ，ワレ'],
        ['成', 'セイチョウスル ノ セイ，ナル'],
        ['戒', 'ケイカイスル ノ カイ，イマシメル'],
        ['錚', 'ソウ、カネヘンニアラソウノキュウジ'],
        ['錘', 'ボウスイケイ ノ スイ，オモリ'],
        ['錙', 'シ、カネヘンニシチョウヘイノシノツクリ'],
        ['娑', 'シャバニデルノシャ'],
        ['娟', 'ケン，オンナヘンニキヌイトノキヌノツクリ'],
        ['娜', 'アダッポイノダ'],
        ['娚', 'ナン，オンナヘンニオトコ'],
        ['娘', 'ヒトリムスメ ノ ムスメ'],
        ['娃', 'アイ，オンナヘン ニ ツチ フタツ'],
        ['威', 'イゲンガアル ノ イ'],
        ['娉', 'ヘイ，オンナヘンニショウヘイスルノヘイ'],
        ['娶', 'メトル，シュ'],
        ['娵', 'シュ，オンナヘンニシュザイノシュ'],
        ['娼', 'ショウフ ノ ショウ，オンナヘン ニ ヒガ フタツ'],
        ['娥', 'ガ，オンナヘンニガマンノガ'],
        ['娠', 'ニンシンスル ノ シン'],
        ['娯', 'ゴラク ノ ゴ'],
        ['娩', 'ブンベンスル ノ ベン'],
        ['産', 'ザイサン ノ サン'],
        ['甥', 'オイメイ ノ オイ'],
        ['甦', 'ソ，ヨミガエル，サラシナノサラニジドウセイトノセイ'],
        ['用', 'リヨウスル ノ ヨウ，モチイル'],
        ['甫', 'シジン ノ トホ ノ ホ'],
        ['甬', 'ヨウ，ニホンブヨウノヨウノツクリ'],
        ['田', 'スイデン ノ デン，タ'],
        ['由', 'リユウ ノ ユウ'],
        ['甲', 'コウオツ ノ コウ'],
        ['申', 'シンコクスル ノ シン，モウス'],
        ['男', 'オトコ，ダンシ ノ ダン'],
        ['甸', 'デン，ツツミガマエニタンボノタ'],
        ['町', 'マチ，シチョウソン ノ チョウ'],
        ['画', 'ガヨウシ ノ ガ'],
        ['甼', 'マチ，シチョウソンノチョウノイタイジ'],
        ['甃', 'シュウ，カワラノウエニキセツノアキ'],
        ['甄', 'ケン，ケムリノツクリノミギニカワラ'],
        ['甅', 'センチグラム，カワラノミギニタンイノリン'],
        ['甌', 'オウ，クベツノクノキュウジノミギニカワラ'],
        ['甍', 'ボウ，イラカ'],
        ['甎', 'セン，センモンカノセンノキュウジノミギニカワラ'],
        ['甑', 'モノヲムス コシキ'],
        ['甓', 'ヘキ，カベノツチノカワリニカワラ'],
        ['甕', 'オウ，カメ，ヨウリツスルノヨウノツクリノシタニカワラ'],
        ['甘', 'アマイ，カンミリョウ ノ カン'],
        ['甚', 'ジンダイナ ノ ジン，ハナハダシイ'],
        ['甜', 'テンサイトウ ノ テン'],
        ['甞', 'ガシンショウタンノショウノイタイジ'],
        ['生', 'イキル，セイカツ ノ セイ'],
        ['勧', 'カンユウスル ノ カン，ススメル'],
        ['勦', 'ソウ，ハチノスノキュウジニチカラ'],
        ['勤', 'キンム ノ キン'],
        ['勣', 'セキ，セキニンノセキニチカラ'],
        ['勢', 'セイリョク ノ セイ，イキオイ'],
        ['勠', 'リク，ゴビュウノビュウノツクリニチカラ'],
        ['勿', 'モチロン ノ モチ'],
        ['勾', 'キュウコウバイ ノ コウ'],
        ['勺', 'ヨウセキ ノ タンイ ノ シャク，ツツミガマエ ニ テン'],
        ['勹', 'ホウ，ブシュノツツミガマエ'],
        ['勸', 'カンユウスルノカン，ススメルノキュウジ'],
        ['勵', 'ゲキレイスルノレイノキュウジ'],
        ['勳', 'クンショウノクン，イサオノキュウジ'],
        ['勲', 'クンショウ ノ クン，イサオ'],
        ['勍', 'ケイ，トウキョウノキョウニチカラ'],
        ['勉', 'ベンキョウ ノ ベン'],
        ['勇', 'ユウキ ノ ユウ，イサマシイ'],
        ['勅', 'チョクメイ ノ チョク'],
        ['勃', 'ボッパツスル ノ ボツ'],
        ['勁', 'ケイ，ツヨイ，ケイドウミャクノケイノヒダリガワニチカラ'],
        ['募', 'ボシュウスル ノ ボ，ツノル'],
        ['勞', 'ロウドウノロウノキュウジ'],
        ['勝', 'カチマケ ノ カチ，ショウ'],
        ['務', 'ギム ノ ム，ツトメル'],
        ['勘', 'オカンジョウ ノ カン'],
        ['勗', 'キョク，ニチョウビノニチノシタニキュウジョスルノジョ'],
        ['5', 'ゴ'],
        ['動', 'ドウブツ ノ ドウ，ウゴク'],
        ['勒', 'ミロクボサツノロク'],
        ['ゃ', 'チイサイ ヤカン ノ ヤ'],
        ['狸', 'タヌキ'],
        ['狽', 'ロウバイスル ノ バイ'],
        ['狼', 'オオカミ，ロウバイスル ノ ロウ'],
        ['狷', 'ケンカイナノケン，ケモノヘンニキヌイトノキヌノツクリ'],
        ['狩', 'シュリョウ ノ シュ，カリ'],
        ['狭', 'セマイ，キョウ'],
        ['独', 'ドクリツ ノ ドク'],
        ['狡', 'コウカツナノコウ，ズルイ'],
        ['狠', 'コン，ケモノヘンニダイコンノコンノツクリ'],
        ['狢', 'ケモノヘンノドウブツノムジナ'],
        ['狙', 'ソゲキ ノ ソ，ネラウ'],
        ['狛', 'コマイヌ ノ コマ，ケモノヘン ニ シロ'],
        ['狐', 'キツネ'],
        ['狒', 'ドウブツノヒヒノヒ'],
        ['狗', 'テング ノ ク，イヌ'],
        ['狎', 'コウ，ナレル，ケモノヘンニコウオツノコウ'],
        ['狃', 'ジュウ，ケモノヘンニジュウニシノウシ'],
        ['狂', 'クルウ，キョウゲン ノ キョウ'],
        ['狄', 'ナンバンホクテキノテキ'],
        ['狆', 'イヌノチン'],
        ['〝', 'ヒゲヒラキ'],
        ['〟', 'ヒゲトジ'],
        ['【', 'クロカッコ'],
        ['】', 'トジクロカッコ'],
        ['〒', 'ユウビン'],
        ['〓', 'ゲタジルシ'],
        ['〔', 'キッコウ'],
        ['〕', 'トジキッコウ'],
        ['〈', 'ヤマカッコ'],
        ['〉', 'トジヤマカッコ'],
        ['《', 'ニジュウヤマカッコ'],
        ['》', 'トジニジュウヤマカッコ'],
        ['「', 'カギ'],
        ['」', 'トジカギ'],
        ['『', 'ニジュウカギ'],
        ['』', 'トジニジュウカギ'],
        ['　', 'スペース'],
        ['、', 'テン'],
        ['。', 'マル'],
        ['〃', 'オナジク'],
        ['々', 'オドリジ'],
        ['〆', 'シメ'],
        ['〇', 'ゼロ'],
        ['§', 'セクション'],
        ['¨', 'ウムラウト'],
        ['´', 'アクサンテギュ'],
        ['¶', 'ダンラクキゴウ'],
        ['°', 'ド'],
        ['±', 'プラスマイナス'],
        ['邨', 'ムラ，シチョウソンノソンノイタイジ'],
        ['邪', 'ジャマ ノ ジャ，ヨコシマ'],
        ['邯', 'カンタンノユメノカン'],
        ['氏', 'シメイ ノ シ，ウジ'],
        ['那', 'ワカダンナ ノ ナ'],
        ['氈', 'モウセンゴケノセン'],
        ['邦', 'イホウジン ノ ホウ'],
        ['邸', 'テイタク ノ テイ，ヤシキ'],
        ['气', 'キ，ブシュノキガマエ'],
        ['気', 'クウキ ノ キ'],
        ['嶋', 'トウ，ヤマヘン ニ トリ ノ シマ'],
        ['民', 'コクミン ノ ミン，タミ'],
        ['氓', 'ボウ，ボウメイスルノボウノミギニコクミンノミン'],
        ['嶌', 'トウ，シマグニノシマノイタイジ，ヤマノシタニトリ'],
        ['邵', 'ショウ，マネクノツクリノミギニオオザト'],
        ['氛', 'フン，キガマエニハンブンノブン'],
        ['氤', 'イン，キガマエニインガオウホウノイン'],
        ['邊', 'シュウヘンノヘン，アタリノキュウジ'],
        ['氣', 'クウキノキノキュウジ'],
        ['邏', 'ケイラスルノラ'],
        ['邀', 'ヨウ，シンニョウニゲキレイスルノゲキノツクリ'],
        ['邁', 'マイシンスルノマイ'],
        ['邂', 'メグリアウイミノカイコウノカイ'],
        ['邃', 'スイ，シンニュウニアナカンムリニグンタイノタイノツクリ'],
        ['還', 'カンレキ ノ カン，カエル'],
        ['邇', 'ジ，シンニョウニソツジナガラノジ'],
        ['水', 'スイヨウビ ノ スイ，ミズ'],
        ['氷', 'ヒョウガ ノ ヒョウ，コオリ'],
        ['邑', 'トユウ ノ ユウ，ムラ'],
        ['氾', 'カワガハンランスル ノ ハン'],
        ['永', 'エイキュウ ノ エイ，ナガイ'],
        ['褓', 'ホウ、ムツキ、コロモヘンニホケンシツノホ'],
        ['褒', 'ホメル，ホウビ ノ ホウ'],
        ['褐', 'カッショク ノ カツ'],
        ['嶄', 'ザン，ヤマノシタニザンシンナノザン'],
        ['褝', 'タン、コロモヘンニタンジュンノタン'],
        ['複', 'フクザツ ノ フク'],
        ['褄', 'ツジツマガアウノツマ'],
        ['U', 'ユー ユージュアリー'],
        ['褂', 'カイ、コロモヘンニカケブトンノカケノツクリ'],
        ['嶇', 'ク，ヤマヘンニクベツスルノクノキュウジ'],
        ['褊', 'ヘン、コロモヘンニヘンペイソクノヘン'],
        ['褶', 'シュウキョクサンミャクノシュウ、ヒダ'],
        ['千', 'カンスウジ ノ セン'],
        ['褻', 'ワイセツナノセツ'],
        ['褸', 'ランルヲマトウノル'],
        ['褥', 'サンジョクノジョク、コロモヘンニブジョクノジョク'],
        [
            '褫',
            'チ，テイシンショウノテイノキュウジノシンニョウノカワリニコロモヘン',
        ],
        ['褪', 'イロアセルノアセル、コロモヘンニタイクツノタイ'],
        ['嶝', 'トウ，ヤマヘンニトザンノト'],
        ['歟', 'ヨ，アタエルノキュウジニフカケツノケツ'],
        ['歛', 'カン，ケンサスルノケンノキュウジノツクリニフカケツノケツ'],
        [
            '歙',
            'キュウ，ゴウカクノゴウノシタニウモウノウ，ソノミギニフカケツノケツ',
        ],
        ['麈', 'シュ，シカノシタニシュジンコウノシュ'],
        ['歔', 'キョ，キョエイシンノキョノキュウジニフカケツノケツ'],
        ['麋', 'ビ，シカノシタニコメ'],
        ['麌', 'オジカ，ゴ，シカノシタニゴフクヤノゴノキュウジケイ'],
        ['歓', 'カンゲイ ノ カン，ヨロコブ'],
        ['歐', 'オウベイノオウノキュウジ'],
        ['歎', 'ナゲク，タンニショウ ノ タン'],
        ['麑', 'カノコ，ゲイ，シカノシタニジドウセイトノジノキュウジ'],
        ['歌', 'ウタ，カシュ ノ カ'],
        ['麓', 'サンロク ノ ロク，フモト'],
        ['麕', 'ノロジカノノロ，シカノシタニクニガマエニノギヘンノノギ'],
        ['歉', 'ケン，カネルニフカケツノケツ'],
        ['歇', 'カンケツセンノケツ，カッショクノカツノツクリニフカケツノケツ'],
        ['歃', 'ソウ，ソウニュウクノソウノキュウジノツクリニフカケツノケツ'],
        ['麟', 'キリン ノ リン'],
        ['歿', 'ボツ，カバネヘンニチンボツノボツノキュウジノツクリ'],
        ['死', 'シボウ ノ シ，シヌ'],
        ['歸', 'キタクスルノキ，カエルノキュウジ'],
        ['歹', 'ガツ，ブシュノカバネヘン'],
        ['麩', 'オフノフ，ムギノキュウジニオット'],
        ['歴', 'レキシ ノ レキ'],
        ['歳', 'サイゲツ ノ サイ，トシ'],
        ['歯', 'ハブラシ ノ ハ，シ'],
        ['歪', 'ヒズム，ワイキョクスル ノ ワイ'],
        ['歩', 'アルク，ホドウ ノ ホ'],
        ['武', 'ブキ ノ ブ'],
        ['麹', 'コウジキン ノ コウジ'],
        ['此', 'ヒガンシガン ノ シ，コノ'],
        ['麻', 'マスイ ノ マ，アサ'],
        ['止', 'キンシスル ノ シ，トメル'],
        ['正', 'タダシイ，ショウガツ ノ ショウ'],
        ['麾', 'イエヤスキカノキ，マスイノマノシタニウモウノモウ'],
        ['歡', 'カンゲイスルノカンノキュウジ'],
        ['聨', 'ミミヘンノレンゴウノレンノイタイジ'],
        ['聯', 'ミミヘン ノ レンゴウ ノ レン'],
        ['聡', 'ソウメイナ ノ ソウ，サトイ'],
        ['聢', 'シカト，ミミヘンニサダメル'],
        ['聹', 'ネイ，ミミヘンニテイネイノネイ'],
        ['聽', 'ホチョウキノチョウノキュウジ'],
        ['聾', 'ロウガッコウ ノ ロウ'],
        ['聿', 'イツ，ブシュノフデヅクリ'],
        ['聰', 'ソウメイナノソウノキュウジ'],
        ['聲', 'オンセイノセイ，コエノキュウジ'],
        ['聳', 'ソビエル'],
        ['聴', 'チョウカク ノ チョウ，キク'],
        ['聶', 'ジョウ，ミミミッツ'],
        ['職', 'ショクギョウ ノ ショク'],
        ['聊', 'ブリョウヲカコツノリョウ'],
        ['聆', 'レイ，ミミヘンニメイレイスルノレイ'],
        ['聘', 'ショウヘイスルノヘイ'],
        ['聚', 'ジュラクダイノジュ'],
        ['聞', 'シンブン ノ ブン，キコエル'],
        ['聟', 'ムコノイタイジ，ツウチヒョウノチノシタニミミ'],
        ['聒', 'カツ，ミミヘンニシタヲカムノシタ'],
        ['聖', 'セイカリレー ノ セイ'],
        ['+', 'プラス'],
        ['糒', 'ヒ，ホシイイ，コメヘンニジュンビスルノビノツクリ'],
        ['糖', 'ブドウトウ ノ トウ'],
        ['糘', 'スクモ，コメヘンニイエ'],
        ['糜', 'ビランノビ'],
        ['糟', 'カス，ソウコウ ノ ツマ ノ ソウ'],
        ['糞', 'フンニョウ ノ フン，クソ'],
        ['糀', 'コウジ，コメヘンニハナビノハナ'],
        ['糂', 'サン，コメヘンニハナハダシイ'],
        ['糅', 'ジュウ，コメヘンニジュウドウノジュウ'],
        ['糊', 'ノリヅケ ノ ノリ，コ'],
        ['糎', 'ナガサ ノ タンイ ノ センチメートル'],
        ['糲', 'レイ，コメヘンニハゲムノキュウジノヒダリガワ'],
        ['糴', 'テキ，カイヨネ'],
        ['糶', 'チョウ，ウリヨネ'],
        ['糸', 'ケイト ノ イト，シ'],
        ['系', 'タイヨウケイ ノ ケイ'],
        ['糺', 'キュウダンスルノキュウ，イトヘンニフダノツクリ'],
        ['糾', 'フンキュウスル ノ キュウ'],
        ['糠', 'ヌカヅケ ノ ヌカ'],
        ['糢', 'アイマイモコノモ，コメヘンニバクダイナノバク'],
        ['糧', 'ショクリョウ ノ リョウ，カテ'],
        ['糯', 'モチゴメ，コメヘンニヒツジュヒンノジュ'],
        ['妙', 'キミョウナ ノ ミョウ'],
        ['妛', 'ヤマノシタニカンスウジノイチ，ソノシタニオンナ'],
        ['妝', 'ショウ，ショウグンノショウノキュウジノヒダリガワニオンナ'],
        ['妓', 'ゲイギ ノ ギ，オンナヘン ニ ササエル'],
        ['妖', 'モリ ノ ヨウセイ ノ ヨウ'],
        ['妊', 'ニンシンスル ノ ニン'],
        ['妍', 'ケン，オンナヘンニケンキュウノケンノツクリ'],
        ['妁', 'シャク，オンナヘンニヨウセキノタンイノシャク'],
        ['如', 'トツジョ ノ ジョ'],
        ['妃', 'オウヒ ノ ヒ，キサキ'],
        ['妄', 'コダイモウソウ ノ モウ'],
        ['妹', 'イモウト，シマイ ノ マイ'],
        ['妻', 'フサイ ノ サイ，ツマ'],
        ['妾', 'メカケ，ショウ'],
        ['妲', 'ダツ，オンナヘンニガンタンノタン'],
        ['妨', 'ボウガイスル ノ ボウ，サマタゲル'],
        ['妬', 'シットスル ノ ト，ネタム'],
        ['妣', 'ヒ，オンナヘンニヒカクスルノヒ'],
        ['妥', 'ダキョウスル ノ ダ'],
        ['疫', 'メンエキ ノ エキ'],
        ['疣', 'イボ，ユウ，ヤマイダレニモットモ'],
        ['疥', 'ヒフビョウノカイセンノカイ，ヤマイダレニカイゴノカイ'],
        ['疸', 'オウダンノダン，ヤマイダレニガンタンノタン'],
        ['疹', 'フウシン ノ シン'],
        ['疾', 'シッペイ ノ シツ'],
        ['疼', 'トウツウノトウ，ウズク'],
        ['疽', 'エソヲオコスノソ'],
        ['疲', 'ツカレル，ヒロウスル ノ ヒ'],
        ['疳', 'カン，ヤマイダレニアマイ'],
        ['疱', 'ミズボウソウノホウ'],
        ['疵', 'キズ，ヤマイダレニヒガンシガンノシ'],
        ['疊', 'タタミノキュウジ'],
        ['疋', 'オリモノ ノ タンイ ノ ヒキ'],
        ['疉', 'タタミノキュウジノシタガヘンカシタイタイジ'],
        ['疎', 'カソチ ノ ソ'],
        ['疏', 'ソスイ ノ ソ，ベンソ ノ ソ'],
        ['疂', 'タタミノキュウジノチュウオウガヘンカシタイタイジ'],
        ['疆', 'シンキョウウイグルジチクノキョウ'],
        ['疇', 'ハンチュウノハン，タヘンニコトブキノキュウジ'],
        ['疚', 'キュウ，ヤマイダレニエイキュウノキュウ'],
        ['疝', 'センキモチノセン，ヤマイダレニヤマ'],
        ['疑', 'ギモン ノ ギ，ウタガウ'],
        ['疔', 'メンチョウノチョウ'],
        ['l', 'エル ラブ'],
        ['掵', 'ハバ，テヘンニイノチ'],
        ['掴', 'ツカム，テヘン ニ クニ'],
        ['掲', 'ケイジバン ノ ケイ，カカゲル'],
        ['饑', 'キキンニミマワレルノキ，ヒダルイ'],
        ['掾', 'エン，テヘンニエンガワノエンノキュウジノツクリ'],
        ['饒', 'ジョウゼツノジョウ，ユタカ'],
        ['掻', 'ヒッカク ノ カク，カッカソウヨウ ノ ソウ'],
        ['饗', 'キョウエン ノ キョウ，モテナス'],
        ['控', 'コウジョスル ノ コウ，ヒカエル'],
        ['接', 'セツゾクスル ノ セツ'],
        ['掣', 'セイ，セイゲンスルノセイノシタニテ'],
        ['探', 'タンケン ノ タン，サガス'],
        ['採', 'サイヨウ ノ サイ，トル'],
        ['掠', 'カスメル，リャクダツ ノ リャク'],
        ['掬', 'スクイナゲ ノ スクウ'],
        ['掫', 'ソウ，テヘンニシュザイスルノシュ'],
        ['措', 'ソチスル ノ ソ'],
        ['掩', 'エンゴシャゲキ ノ エン'],
        ['推', 'スイセンスル ノ スイ，オス'],
        ['掖', 'エキ，テヘンニヒルヨルノヨル'],
        ['排', 'ハイジョスル ノ ハイ'],
        ['掟', 'オキテ，テヘンニサダメル'],
        ['掛', 'カケブトン ノ カケ'],
        ['掘', 'ホル，ハックツ ノ クツ'],
        ['掃', 'ソウジスル ノ ソウ，ハク'],
        ['掀', 'キン，テヘンニキンキジャクヤクノキン'],
        ['掏', 'トウ，テヘンニトウゲイカノトウノツクリ'],
        ['掎', 'キ，テヘンニキミョウナノキ'],
        ['掌', 'ショウアクスル ノ ショウ，テノヒラ'],
        ['掉', 'チョウ，テヘンニタッキュウノタク'],
        ['授', 'ジュギョウ ノ ジュ，サズケル'],
        ['蹂', 'ジュウリンスルノジュウ'],
        ['蹄', 'テイテツ ノ テイ，ヒヅメ'],
        ['蹇', 'ケン，サムイノシタニテンノカワリニアシ'],
        ['蹈', 'トウ，アシヘンニイネノキュウジノツクリ'],
        ['蹉', 'ジンセイノサテツノサ'],
        ['蹊', 'ケイ，アシヘンニケイリュウヅリノケイノキュウジノツクリ'],
        ['蹌', 'ヨロメク，ソウロウノソウ'],
        ['蹐', 'セキ，アシヘンニセキズイノセキ'],
        ['蹕', 'ヒツ，アシヘンニヒッキョウノヒツ'],
        ['蹙', 'ヒンシュクヲカウノシュク'],
        ['蹟', 'キセキ ノ セキ，アシヘン ニ セキニン ノ セキ'],
        ['蹠', 'セキ，アシヘンニショミンノショ'],
        ['蹣', 'スイホマンサンノマン，アシヘンニマンゾクノマンノキュウジノツクリ'],
        ['蹤', 'ショウ，アシヘンニジュウジスルノジュウノキュウジ'],
        ['蹲', 'ソンキョスルノソン，アシヘンニソンケイスルノソン'],
        ['蹴', 'ケル，シュウキュウ ノ シュウ'],
        ['蹶', 'ケツ，アシヘンニユウボクミンゾクノトッケツノケツ'],
        ['蹼', 'ホク，アシヘンニダボクノボクノツクリ'],
        ['進', 'シンポ ノ シン，ススム'],
        ['涎', 'スイゼンノマトノゼン，ヨダレ'],
        ['涌', 'ワク，コワクダニ ノ ワク'],
        ['逶', 'イ，シンニョウニガッキュウイインノイ'],
        ['消', 'ショウボウシャ ノ ショウ，ケス'],
        ['涅', 'ネハンノネ'],
        ['逹', 'ハイタツノタツノイタイジ'],
        ['逾', 'ユ，シンニョウニニレノキノニレノツクリ'],
        ['逼', 'ヒッパクスル ノ ヒツ'],
        ['逢', 'ダンジョ ノ アイビキ ノ アイ'],
        ['連', 'レンラク ノ レン'],
        ['造', 'カイゾウ ノ ゾウ，ツクル'],
        ['涜', 'ボウトクスル ノ トク，ケガス'],
        ['涛', 'トウ，サンズイ ニ コトブキ'],
        ['逧', 'サコ，シンニョウニタニ'],
        ['涙', 'ナミダ，ルイセン ノ ルイ'],
        ['涕', 'テイ，ナミダ，サンズイニオトウト'],
        ['涓', 'ケン，サンズイニキヌイトノキヌノツクリ'],
        ['涯', 'イッショウガイ ノ ガイ'],
        ['逓', 'テイシンショウ ノ テイ'],
        ['逐', 'チクジ ノ チク'],
        ['逑', 'キュウ、シンニョウニモトメル'],
        ['逖', 'テキ、シンニョウニイテキノテキ'],
        ['逗', 'トウリュウスル ノ トウ，シンニョウ ニ マメ'],
        ['途', 'トチュウ ノ ト'],
        ['逕', 'ケイ、シンニョウニケイドウミャクノケイノヒダリガワ'],
        ['通', 'コウツウ ノ ツウ，トオル'],
        ['這', 'ハウ'],
        ['逞', 'タクマシイ，テイ'],
        ['速', 'ソクド ノ ソク，ハヤイ'],
        ['逝', 'セイキョスル ノ セイ，ユク'],
        ['逃', 'ニゲル，トウボウスル ノ トウ'],
        ['退', 'タイクツ ノ タイ'],
        ['涼', 'スズシイ，ノウリョウ ノ リョウ'],
        ['逆', 'ギャクテン ノ ギャク，サカサ'],
        ['涸', 'カレル，サンズイニカタマル'],
        ['逋', 'ホ、シンニョウニシジンノトホノホ'],
        ['涵', 'トクヲカンヨウスルノカン'],
        ['逎', 'シュウ，シンニョウニジュウニシノトリ'],
        ['液', 'エキタイ ノ エキ'],
        ['逍', 'サンポヲイミスルショウヨウノショウ'],
        ['覘', 'テン，ドクセンスルノセンノミギニケンブツスルノケン'],
        ['B', 'ビー ボーイ'],
        ['覓', 'ベキ，ツメノシタニケンブツスルノケン'],
        ['覗', 'ノゾキミル ノ ノゾク'],
        ['視', 'シリョクケンサ ノ シ'],
        ['覈', 'ガク，オオイカンムリニゲキレイスルノゲキノツクリ'],
        ['見', 'ミル，ケンブツ ノ ケン'],
        ['覊', 'キビセイサクノキノイタイジ'],
        ['規', 'キソクテキ ノ キ'],
        ['要', 'ヨウキュウスル ノ ヨウ'],
        ['覃', 'タン，オオイカンムリノシタニハヤオキノハヤイ'],
        ['覇', 'セイハスル ノ ハ'],
        ['覆', 'フクメン ノ フク，オオウ'],
        ['覺', 'カンカクノカク，オボエルノキュウジ'],
        ['覽', 'ハクランカイノランノキュウジ'],
        ['覿', 'コウカテキメンノテキ'],
        ['観', 'カンキャク ノ カン'],
        [
            '覲',
            'キン，キンムノキンノキュウジタイノチカラノカワリニケンブツスルノケン',
        ],
        ['覩', 'ト，カガクシャノシャノキュウジタイノミギニケンブツスルノケン'],
        ['親', 'オヤ，リョウシン ノ シン'],
        ['覬', 'キ，ガイセンモンノガイノミギニケンブツスルノケン'],
        ['覯', 'コウ，ミゾノツクリノミギニケンブツスルノケン'],
        ['覡', 'ケキ，ジンジャノミコノフノミギニケンブツスルノケン'],
        ['覧', 'ハクランカイ ノ ラン'],
        ['覦', 'ユ，ニレノキノニレノツクリノミギニケンブツスルノケン'],
        ['も', 'モミジ ノ モ'],
        ['剰', 'ジシンカジョウ ノ ジョウ'],
        ['剳', 'ゴジュウノトウノトウノツクリニリットウ'],
        ['割', 'ワリアイ ノ ワリ'],
        ['創', 'ソウリツスル ノ ソウ'],
        ['ょ', 'チイサイ ヨット ノ ヨ'],
        ['や', 'ヤカン ノ ヤ'],
        ['ゅ', 'チイサイ ユカタ ノ ユ'],
        ['り', 'リンゴ ノ リ'],
        ['る', 'ルスバン ノ ル'],
        ['よ', 'ヨット ノ ヨ'],
        ['ら', 'ラジオ ノ ラ'],
        ['剽', 'ヒョウセツスルノヒョウ'],
        ['わ', 'ワカメ ノ ワ'],
        ['れ', 'レモン ノ レ'],
        ['ろ', 'ロウカ ノ ロ'],
        ['を', 'ヲワリ ノ オ'],
        ['ん', 'オシマイ ノ ン'],
        ['ゐ', 'ムカシ ノ イ'],
        ['ゑ', 'ムカシ ノ エ'],
        ['剥', 'ハクリスル ノ ハク，ハガレル'],
        ['剤', 'ヤクザイシ ノ ザイ'],
        ['剩', 'ジョウ，ジシンカジョウノジョウノキュウジ'],
        ['゛', 'ダクテン'],
        ['剪', 'ニワキヲセンテイスルノセン，キル'],
        ['ゞ', 'クリカエシダクテン'],
        ['゜', 'ハンダクテン'],
        ['ゝ', 'クリカエシ'],
        ['ア', 'アサヒ ノ ア'],
        ['ィ', 'チイサイ イチゴ ノ イ'],
        ['ァ', 'チイサイ アサヒ ノ ア'],
        ['ウ', 'ウサギ ノ ウ'],
        ['ェ', 'チイサイ エイゴ ノ エ'],
        ['イ', 'イチゴ ノ イ'],
        ['ゥ', 'チイサイ ウサギ ノ ウ'],
        ['オ', 'オオサカ ノ オ'],
        ['カ', 'カゾク ノ カ'],
        ['エ', 'エイゴ ノ エ'],
        ['ォ', 'チイサイ オオサカ ノ オ'],
        ['ギ', 'ギンコウ ノ ギ'],
        ['ク', 'クスリ ノ ク'],
        ['ガ', 'ガッコウ ノ ガ'],
        ['キ', 'キッテ ノ キ'],
        ['ゲ', 'ゲーム ノ ゲ'],
        ['コ', 'コドモ ノ コ'],
        ['グ', 'グランド ノ グ'],
        ['ケ', 'ケシキ ノ ケ'],
        ['ザ', 'ザブトン ノ ザ'],
        ['シ', 'シンブン ノ シ'],
        ['則', 'ホウソク ノ ソク'],
        ['サ', 'サクラ ノ サ'],
        ['ズ', 'ズボン ノ ズ'],
        ['セ', 'セカイ ノ セ'],
        ['ジ', 'ジカン ノ ジ'],
        ['ス', 'スズメ ノ ス'],
        ['前', 'マエ，ゼンゴ ノ ゼン'],
        ['剌', 'ハツラツノラツ'],
        ['剏', 'ソウ，ヘイヨウスルノヘイノツクリニヤイバノイタイジ'],
        ['ソ', 'ソロバン ノ ソ'],
        ['罘', 'フウ，アミガシラニフシギノフ'],
        ['罟', 'コ，アミガシラニチュウコシャノコ'],
        ['网', 'ボウ，ブシュノアミガシラ'],
        ['罐', 'カンヅメノカンノキュウジ'],
        ['罕', 'トリアミヲイミスルカン'],
        ['罔', 'モウ，モウマクノモウノツクリ'],
        ['罎', 'アキビンノビン，ホトギヘンニクモリ'],
        ['罍', 'ライ，タハタノタミッツノシタニホトギ'],
        ['罌', 'オウ，カイガラノカイフタツノシタニホトギ'],
        ['罅', 'ヒビワレルノヒビ，カ'],
        ['罹', 'リカンスルノリ，カカル'],
        ['罸', 'ツミトバツノバツノイタイジ'],
        ['署', 'ショメイスル ノ ショ'],
        ['罰', 'ツミトバツ ノ バツ'],
        ['罷', 'ヒメンスル ノ ヒ'],
        ['罵', 'バセイ ノ バ，ノノシル'],
        ['罫', 'ケイセンヲヒク ノ ケイ'],
        ['罪', 'ハンザイ ノ ザイ，ツミ'],
        ['罩', 'トウ，アミガシラニタッキュウノタク'],
        ['罨', 'アンポウノアン'],
        ['置', 'ソウチ ノ チ，オク'],
        ['ゴ', 'ゴリラ ノ ゴ'],
        ['罠', 'ワナ，アミガシラニタミ'],
        ['罧', 'シノヅケ，アミガシラニミツリンノリン'],
        ['嶂', 'ショウ，ヤマヘンニブンショウヲカクノショウ'],
        ['邱', 'キュウ，サキュウノキュウノミギニオオザト'],
        ['ゼ', 'ゼンブ ノ ゼ'],
        ['擠', 'セイ，テヘンニヘソノツクリ'],
        ['擡', 'タイトウスルノタイ，テヘンニダイドコロノダイノキュウジ'],
        ['擢', 'バッテキスル ノ テキ'],
        ['擣', 'トウ，テヘンニコトブキノキュウジ'],
        ['擦', 'マサツ ノ サツ，スル'],
        ['擧', 'センキョノキョ，アゲルノキュウジ'],
        ['擬', 'モギテン ノ ギ'],
        ['擯', 'ヒン，テヘンニライヒンノヒン'],
        ['鸚', 'トリノオウムノオウ'],
        ['擱', 'カクザスルノカク，テヘンニテンシュカクノカク'],
        ['擲', 'トウテキキョウギノテキ，ナゲウツ'],
        ['擴', 'カクダイスルノカクノキュウジ'],
        ['擶', 'セン，テヘンニタケカンムリニマエ'],
        ['擺', 'ハイ，テヘンニヒメンスルノヒ'],
        ['擽', 'リャク，テヘンニオンガクノガクノキュウジ'],
        ['擾', 'ジョウラン ノ ジョウ，テヘン ニ ユウウツ ノ ユウ'],
        ['擁', 'ヨウリツスル ノ ヨウ'],
        ['擂', 'ライ，テヘンニカミナリ'],
        ['擅', 'ドクセンジョウノセン，テヘンニダンカノダンノツクリ'],
        ['擇', 'センタクシノタクノキュウジ'],
        ['操', 'ソウジュウスル ノ ソウ，アヤツル'],
        ['擒', 'キン，テヘンニモウキンルイノキン'],
        ['擔', 'タンニンノタンノキュウジ'],
        ['擘', 'ヘキ，カベノツチノカワリニテ'],
        ['據', 'キョテンノキョノキュウジ'],
        ['胱', 'ボウコウエンノコウ'],
        ['胴', 'ドウアゲ ノ ドウ'],
        ['胸', 'キョウイ ノ キョウ，ムネ'],
        ['胼', 'ヘイ，ニクヅキニヘイゴウスルノヘイノツクリ'],
        ['能', 'サイノウ ノ ノウ'],
        ['胡', 'クロコショウ ノ コ'],
        ['胤', 'ゴラクイン ノ イン，タネ'],
        ['胥', 'ショ，オリモノノタンイノヒキノシタニニクヅキ'],
        ['Y', 'ワイ ヤング'],
        ['胯', 'コ，ニクヅキニハカマノツクリ'],
        ['胖', 'ハン，ニクヅキニハンブンノハン'],
        ['驤', 'ジョウ，ウマヘンニユズルノツクリノキュウジ'],
        ['胚', 'ハイガマイノハイ'],
        ['胛', 'コウ，ニクヅキニコウオツノコウ'],
        ['胙', 'ソ，ニクヅキニムカシナガラノナガラ'],
        ['胞', 'サイボウ ノ ボウ'],
        ['胝', 'チ，ニクヅキニテイコウスルノテイノツクリ'],
        ['胃', 'イブクロ ノ イ'],
        ['胆', 'ダイタンナ ノ タン'],
        ['胄', 'チュウ，リユウノユウノシタニニクヅキ'],
        ['胎', 'ジュタイスル ノ ジュ'],
        ['背', 'セボネ ノ セ'],
        ['難', 'コンナン ノ ナン，ムズカシイ'],
        ['離', 'ハナレル，リリク ノ リ'],
        ['挺', 'クウテイブタイ ノ テイ'],
        ['挽', 'バンカイスル ノ バン'],
        ['挿', 'ソウニュウスル ノ ソウ，サス'],
        ['挾', 'ハサム，キョウノキュウジ'],
        ['雫', 'シズク，アメカンムリ ニ シタ'],
        ['雪', 'ユキダルマ ノ ユキ，セツ'],
        ['雨', 'アメ，ウテン ノ ウ'],
        ['挨', 'アイサツスル ノ アイ'],
        ['挫', 'ネンザ ノ ザ，クジク'],
        ['雰', 'フンイキ ノ フン'],
        ['雷', 'カミナリ，ライウ ノ ライ'],
        ['零', 'レイサイキギョウ ノ レイ'],
        ['振', 'サンシンスル ノ シン，フル'],
        ['電', 'デンワ ノ デン'],
        ['雹', 'ヒョウアラレノヒョウ，アメカンムリニツツム'],
        ['挧', 'ウ，テヘンニウモウノウ'],
        ['挙', 'センキョ ノ キョ，アゲル'],
        ['雁', 'ワタリドリ ノ ガン，カリ'],
        ['雀', 'スズメ，ジャク'],
        ['雇', 'ヤトウ，コヨウスル ノ コ'],
        ['集', 'シュウゴウスル ノ シュウ，アツマル'],
        ['挟', 'ハサム，キョウ'],
        ['雄', 'オスメス ノ オス，ユウ'],
        ['挑', 'チョウセンスル ノ チョウ，イドム'],
        ['驩', 'カン，ウマヘンニカンボクノカン'],
        ['雉', 'トリノキジ、チ'],
        ['雎', 'ショ、ナオカツノカツノミギニフルトリ'],
        ['雍', 'シンノヨウセイテイノヨウ'],
        ['雌', 'オスメス ノ メス，シ'],
        ['按', 'アンマ ノ アン'],
        ['挈', 'ケツ，ケイヤクスルノケイノダイノカワリニテ'],
        ['雑', 'ザツオン ノ ザツ'],
        ['挌', 'カク，テヘンニカクジノカク'],
        ['雕', 'チョウ、シュウヘンノシュウノミギニフルトリ'],
        ['持', 'ジゾクスル ノ ジ，モツ'],
        ['雙', 'ソウガンキョウノソウノキュウジ'],
        ['挂', 'ケイ，テヘンニツチフタツ'],
        ['指', 'シドウスル ノ シ，ユビ'],
        ['雜', 'ザツオンノザツノイキュウジ'],
        ['車', 'クルマ，デンシャ ノ シャ'],
        ['軋', 'アツレキノアツ'],
        ['軈', 'ヤガテ、ミヘンニオウエンスルノオウノキュウジ'],
        ['軌', 'キドウニノル ノ キ'],
        ['軍', 'グンタイ ノ グン'],
        ['軆', 'タイ、ミヘンニユタカ'],
        ['軅', 'ヤガテ、ミヘンニトリノカリ'],
        ['軛', 'クビキ、クルマヘンニヤクドシノヤク'],
        ['∇', 'ナブラ'],
        ['軒', 'イッケンヤ ノ ケン，ノキ'],
        ['軫', 'シン、クルマヘンニシンサツスルノシンノツクリ'],
        ['転', 'ウンテン ノ テン，コロガス'],
        ['軣', 'ゴウ、トドロクノイタイジ'],
        ['軻', 'カ、クルマヘンニカノウセイノカ'],
        ['軸', 'カケジク ノ ジク'],
        ['√', 'ルート'],
        ['軾', 'ショク、クルマヘンニニュウガクシキノシキ'],
        ['軼', 'イツ、クルマヘンニウシナウ'],
        ['軽', 'カルイオモイ ノ カルイ，ケイ'],
        ['∝', 'ヒレイ'],
        ['夢', 'ユメ，ムチュウ ノ ム'],
        ['大', 'ダイショウ ノ ダイ，オオキイ'],
        ['夥', 'カ，オビタダシイ'],
        ['太', 'フトイホソイ ノ フトイ，タイ'],
        ['夫', 'オット，フサイ ノ フ'],
        ['天', 'テンキヨホウ ノ テン'],
        ['央', 'チュウオウ ノ オウ'],
        ['夬', 'カイ，ワケル，タスウケツノケツノツクリ'],
        ['夭', 'ヨウセツスルノヨウ，ワカイ'],
        ['夲', 'トウ，オオキイノシタニスウジノジュウ'],
        ['知', 'チシキ ノ チ，シル'],
        ['失', 'シツレン ノ シツウシナウ'],
        ['夷', 'ジョウイ ノ イ，エビス'],
        ['夸', 'カ，コチョウスルノコノツクリ'],
        ['驚', 'オドロク，キョウタン ノ キョウ'],
        ['夾', 'キョウ，ハサムノキュウジノツクリ'],
        ['頗', 'スコブル'],
        ['夂', 'チ，ブシュノフユガシラ'],
        ['夊', 'スイ，ブシュノスイニョウ'],
        ['変', 'ヘンカ ノ ヘン，カエル'],
        ['夏', 'ナツヤスミ ノ ナツ，カ'],
        ['/', 'スラッシュ'],
        ['頚', 'クビ，ケイ'],
        ['夐', 'ケイ，スイニョウノハルカ'],
        ['外', 'ガイコク ノ ガイ，ソト'],
        ['夕', 'ユウガタ ノ ユウ'],
        ['多', 'オオイスクナイ ノ オオイ，タ'],
        ['夛', 'オオイスクナイノオオイノイタイジ'],
        ['夘', 'ジュウニシノウノイタイジ'],
        ['夙', 'ツトニ，シュク'],
        ['夜', 'コンヤ ノ ヤ，ヨル'],
        ['∨', 'マタハ'],
        ['琥', 'コハクイロノコ'],
        ['琢', 'セッサタクマ ノ タク，ミガク'],
        ['驍', 'ウマヘンニギョウシュンノギョウノキュウジ'],
        ['琿', 'コン，オウヘンニグンタイノグン'],
        ['琺', 'ホウロウナベノホウ，オウヘンニホウリツノホウ'],
        ['琴', 'モッキン ノ キン，コト'],
        ['琵', 'ビワコ ノ ビ'],
        ['琶', 'ビワコ ノ ニモジメ ノ ハ'],
        ['琲', 'ハイ，コーヒーノアテジノニモジメ'],
        ['琳', 'オウヘン ニ ハヤシ ノ リン'],
        ['琉', 'リュウキュウ ノ リュウ'],
        ['琅', 'ロウ，オウヘンニカイリョウスルノリョウ'],
        ['理', 'リユウ ノ リ'],
        ['∮', 'シュウカイセキブン'],
        ['球', 'チキュウ ノ キュウ，タマ'],
        ['出', 'デル，ガイシュツ ノ シュツ'],
        ['凹', 'オウトツ ノ オウ，クボム'],
        ['凸', 'オウトツ ノ トツ'],
        ['凾', 'ハコダテノハコ，カンノイタイジ'],
        ['函', 'ハコダテ ノ ハコ，カン'],
        ['凱', 'ガイセンモン ノ ガイ'],
        ['凰', 'トリノホウオウノオウ'],
        ['凶', 'キチトキョウ ノ キョウ'],
        ['凵', 'ケン，ブシュノウケバコ'],
        ['凪', 'ユウナギ ノ ナギ'],
        ['凩', 'コガラシ'],
        ['凭', 'ヒョウ，モタレル'],
        ['凡', 'ヘイボン ノ ボン'],
        ['几', 'キチョウメンノキ，ツクエ'],
        ['凧', 'タコアゲ ノ タコ'],
        ['処', 'ショブン ノ ショ'],
        ['凛', 'リンレツタルノリンノイタイジ'],
        ['凝', 'コル，ギョウコスル ノ ギョウ'],
        ['凜', 'リンレツタルノリン'],
        ['凖', 'ジュンビスルノジュンノイタイジ'],
        ['頏', 'コウ，テイコウスルノコウノツクリノミギニページ'],
        ['凋', 'チョウラク ノ チョウ，シボム'],
        ['凉', 'スズシイノイタイジ，ニスイ'],
        ['頌', 'ショウシュンノショウ，オオヤケニページ'],
        ['凍', 'レイトウスル ノ トウ，コオル'],
        ['凌', 'リョウガスル ノ リョウ，シノグ'],
        ['准', 'ヒジュンスル ノ ジュン'],
        ['凅', 'コ，コオル，ニスイニカタマル'],
        ['凄', 'セイサンナ ノ セイ，スゴイ'],
        ['頷', 'ウナズク，ガン'],
        ['頸', 'ケイツイノケイ，クビ'],
        ['頼', 'タノム，イライ ノ ライ'],
        ['頽', 'タイハイテキナニタイ，ハゲヤマノハゲノミギニページ'],
        ['頡', 'ケツ，ダイキチノキチニページ'],
        ['鞣', 'ナメス，ジュウ'],
        ['}', 'トジチュウカッコ'],
        ['頭', 'アタマ，ズツウ ノ ズ'],
        ['ﾇ', 'ヌリエ ノ ヌ'],
        ['p', 'ピー パパ'],
        ['醴', 'アマザケ，レイ'],
        [
            '醵',
            'キョキンノキョ，ジュウニシノトリノミギニゲキダンノゲキノヒダリガワ',
        ],
        ['洒', 'オシャレノシャ，サンズイニニシ'],
        ['洗', 'センタクモノ ノ セン，アラウ'],
        ['洙', 'シュ，サンズイニシュイロノシュ'],
        ['洛', 'ジョウラクスル ノ ラク'],
        ['醸', 'ジョウゾウスル ノ ジョウ，カモス'],
        ['洟', 'ハナミズ，イ，サンズイニジョウイノイ'],
        ['洞', 'ドウクツ ノ ドウ，ホラ'],
        ['醤', 'ショウユ ノ ショウ，ヒシオ'],
        ['醢', 'カイ，ジュウニシノトリノミギニミギノシタニサラ'],
        ['洋', 'ヨウフク ノ ヨウ'],
        ['醯', 'ケイ，ジュウニシノトリノミギニナガレルノツクリノシタニサラ'],
        ['洌', 'セイレツナイズミノレツ，サンズイニギョウレツノレツ'],
        ['醪', 'モロミ，ロウ'],
        ['醫', 'オイシャサンノイノキュウジ'],
        ['洳', 'ジョ，サンズイニトツジョノジョ'],
        ['洲', 'サンカクス ノ ス，サンズイツキ'],
        ['洵', 'シュン，サンズイニゲジュンノジュン'],
        ['醒', 'カクセイザイ ノ セイ，サメル'],
        ['洶', 'キョウ，サンズイニムネガイタムノムネノツクリ'],
        ['醜', 'シュウタイ ノ シュウ，ミニクイ'],
        ['洸', 'コウ，サンズイニヒカリ'],
        ['活', 'セイカツ ノ カツ'],
        ['洽', 'コウ，サンズイニゴウカクノゴウ'],
        ['派', 'ハバツ ノ ハ'],
        ['醇', 'ホウジュンナカオリ ノ ジュン'],
        ['津', 'ツナミ ノ ツ，シン'],
        ['醂', 'ミリンノリン，ジュウニシノトリノミギニハヤシ'],
        ['洩', 'キミツロウエイ ノ エイ，モラス'],
        ['醍', 'ダイゴミ ノ ダイ'],
        ['洫', 'キョク，サンズイニケツエキノケツ'],
        ['洪', 'コウズイ ノ コウ'],
        ['醉', 'デイスイスルノスイノキュウジ'],
        ['醋', 'サク，ジュウニシノトリノミギニムカシ'],
        ['蘢', 'ロウ，クサカンムリニキョウリュウノリュウノキュウジ'],
        ['蘯', 'ホウトウムスコノトウノイタイジ'],
        ['蘭', 'ランガク ノ ラン'],
        ['蘰', 'カズラ，クサカンムリニイトヘンニウナギノツクリ'],
        ['蘿', 'ラ，クサカンムリニモウラスルノラ'],
        [
            '蘂',
            'メシベノシベ，ズイノイタイジ，クサカンムリニココロミッツニジュモクノモク',
        ],
        ['蘇', 'ソセイスル ノ ソ，ヨミガエル'],
        ['蘆', 'アシ，クサカンムリニハゼノキノハゼノツクリ'],
        ['蘋', 'ヒン，クサカンムリニヒンパンナノヒンノキュウジ'],
        ['蘊', 'ウンチクヲカタムケルノウン，イトヘン'],
        ['蘓', 'ソセイノソノイタイジ，クサカンムリニノギヘンニサカナ'],
        ['蘗', 'オウバクシュウノバクノイタイジ'],
        ['蘖', 'ゲツ，ヒコバエ'],
        ['蘚', 'セン，コケ，クサカンムリニシンセンナノセン'],
        ['龍', 'タツ，リュウ ノ キュウジ'],
        ['摩', 'マサツ ノ マ'],
        ['摯', 'シンシナタイドノシ，シツジノシツノシタニテ'],
        ['摧', 'サイ，テヘンニモヨオシノツクリ'],
        ['摺', 'テスリアシスリ ノ スリ'],
        ['龝', 'アキ，ノギヘンニカメノキュウジ'],
        ['摸', 'モシャスル ノ モ，テヘン'],
        ['龕', 'ガンドウノガン，ゴウカクノゴウノシタニリュウ'],
        ['摶', 'タン，テヘンニセンモンノセンノキュウジ'],
        ['摎', 'コウ，テヘンニニカワノツクリ'],
        ['摂', 'セッセイスル ノ セイ，トル'],
        ['龠', 'ブシュノヤク，フエ'],
        ['摘', 'テキハツスル ノ テキ，ツム'],
        ['腴', 'ユ，ニクヅキニシュユノマノユ'],
        ['腰', 'ヨウツウ ノ ヨウ，コシ'],
        ['腱', 'アキレスケンノケン'],
        ['F', 'エフ フレンド'],
        ['腿', 'ダイタイコツ ノ タイ，モモ'],
        ['腸', 'ダイチョウ，ショウチョウ ノ チョウ'],
        ['腹', 'ハラペコ ノ ハラ，フク'],
        ['腺', 'コウジョウセン ノ セン'],
        ['腥', 'セイ，ニクヅキニワクセイノセイ'],
        ['腦', 'ズノウメイセキノノウノキュウジ'],
        ['腮', 'エラ，ニクヅキニシアンガオノシ'],
        ['腫', 'シュヨウ ノ シュ，ハレル'],
        ['腔', 'コウクウゲカ ノ クウ，ニクヅキニソラ'],
        ['腕', 'ウデ，ワンリョク ノ ワン'],
        ['腐', 'クサル，フハイスル ノ フ'],
        ['腑', 'フヌケノフ'],
        ['腓', 'ヒコツノヒ，コムラ'],
        ['腟', 'チツ，ニクヅキニキョウシツノシツ'],
        ['腆', 'テン，ニクヅキニコクゴジテンノテン'],
        ['腎', 'ジンゾウビョウ ノ ジン'],
        ['腋', 'エキ，ワキ，ニクヅキニヨルヒルノヨル'],
        ['郢', 'エイ，ゾウテイスルノテイノミギニオオザト'],
        ['郡', 'チメイ ノ グン，コオリ'],
        ['翕', 'キュウ，ゴウカクスルノゴウニウモウノウ'],
        ['翔', 'ヒショウスルノショウ，カケル，ヒツジニウモウノウ'],
        ['習', 'レンシュウ ノ シュウ，ナラウ'],
        ['翌', 'ヨクジツ ノ ヨク'],
        ['翊', 'ヨク，ドクリツノリツノミギニウモウノウ'],
        ['翅', 'シ，ササエルノミギニウモウノウ'],
        ['翆', 'ヒスイノスイノイタイジ'],
        ['翁', 'オキナ，オウ'],
        ['翼', 'ツバサ，ビヨク ノ ヨク'],
        ['翹', 'ギョウ，ギョウシュンノギョウノキュウジニウモウノウ'],
        ['翻', 'ホンヤクスル ノ ホン'],
        [
            '翰',
            'ショカンヲ オクル ノ カン，シンカンセン ノ カン ノ ホス ノ カワリニ ウモウ ノ ウ',
        ],
        ['翳', 'カゲリ，エイ，オイシャサンノイニルマタ，ソノシタニウモウノウ'],
        ['翩', 'ヘンポントヒルガエルノヘン'],
        ['翫', 'ガン，レンシュウ ノ シュウ ニ ゲンキ ノ ゲン'],
        ['翦', 'セン，マエウシロノマエノシタニウモウノウ'],
        ['翡', 'ヒスイノヒ，ヒジョウグチノヒノシタニウモウノウ'],
        ['翠', 'ヒスイ ノ スイ'],
        ['墮', 'ダラクスルノダノキュウジ'],
        ['墨', 'ボクジュウ ノ ボク，スミ'],
        ['墫', 'タルノイタイジ'],
        ['墳', 'コフン ノ フン'],
        ['鐡', 'テツドウノテツノキュウジノテイノカワリニマメノシタガワ'],
        ['墾', 'カイコンチ ノ コン'],
        ['墸', 'ツチヘンニチョシャノチョノキュウジタイ'],
        ['墹', 'ママ，ツチヘンニアイダ'],
        ['墺', 'オウ，ツチヘンニオクバノオクノキュウジ'],
        ['墻', 'ショウ，ツチヘンニリンショクノショク'],
        ['墅', 'ショ，ノハラノノノシタニツチ'],
        ['境', 'コッキョウ ノ キョウ，サカイ'],
        ['増', 'ゾウカスル ノ ゾウ，フエル'],
        ['墓', 'ボチ ノ ボ，ハカ'],
        ['墜', 'ツイラクスル ノ ツイ'],
        ['墟', 'ハイキョノキョ'],
        ['環', 'シゼンカンキョウ ノ カン'],
        ['郊', 'トウキョウキンコウ ノ コウ'],
        ['璽', 'ギョメイギョジ ノ ジ'],
        ['璧', 'ヘキ，カンペキナノヘキ'],
        ['璢', 'ルリイロノルノイタイジ'],
        ['郎', 'モモタロウ ノ ロウ'],
        ['璞', 'ハク，アラタマ，オウヘンニシモベノツクリ'],
        ['璃', 'ルリイロ ノ リ'],
        ['璋', 'ショウ，オウヘンニブンショウヲカクノショウ'],
        ['郛', 'フ，ツメノシタニコドモノコノミギニオオザト'],
        ['鰭', 'サカナ ノ ヒレ'],
        ['陥', 'オチイル，カンラク ノ カン'],
        ['除', 'ジョガイ ノ ジョ，ノゾク'],
        ['陦', 'トウ、コザトヘンニコトブキ'],
        ['陣', 'シュツジンスル ノ ジン'],
        ['院', 'ニュウインスル ノ イン'],
        ['陬', 'ソウ、コザトヘンニシュトクスルノシュ'],
        ['陪', 'バイシンイン ノ バイ'],
        ['陵', 'キュウリョウチ ノ リョウ，ミササギ'],
        ['陷', 'オチイル，カンラクノカンノキュウジ'],
        ['陶', 'トウゲイカ ノ トウ'],
        ['陰', 'インキナ ノ イン，カゲ'],
        ['陳', 'チンレツスル ノ チン'],
        ['陲', 'スイ、コザトヘンニスイチョクノスイ'],
        ['陽', 'タイヨウケイ ノ ヨウ'],
        ['陸', 'リクジョウ ノ リク'],
        ['険', 'ボウケン ノ ケン，ケワシイ'],
        ['附', 'コザトヘンノ ツイタ フゾク ノ フ'],
        ['陀', 'アミダブツ ノ ダ'],
        ['陂', 'ハ，コザトヘンニケガワノカワ'],
        ['降', 'ユキガフル ノ フル，コウ'],
        ['陌', 'ハク，コザトヘンニカンスウジノヒャク'],
        ['陏', 'ダ，コザトヘンニユウメイジンノユウ'],
        ['陋', 'ガンメイコロウノロウ'],
        ['限', 'ゲンカイ ノ ゲン，カギル'],
        ['陝', 'チュウゴクノセンセイショウノセン'],
        ['陜', 'セン，コザトヘンニセマイノキュウジノツクリ'],
        ['陟', 'チョク、コザトヘンニアルクノキュウジ'],
        ['陞', 'ショウ、コザトヘンニイッショウビンノショウノシタニドヨウビノド'],
        ['陛', 'ヘイカ ノ ヘイ'],
        ['轌', 'ソリ、クルマヘンニユキ'],
        ['轍', 'ワダチ'],
        ['轎', 'キョウ、クルマヘンニホドウキョウノキョウノツクリ'],
        ['轉', 'ウンテンスルノテンノキュウジ'],
        ['轄', 'カンカツスル ノ カツ'],
        ['轅', 'エン、ナガエ、クルマヘンニルイジンエンノエンノツクリ'],
        ['轆', 'ロクロノロク'],
        ['轂', 'コシキ、コクモツノコクノノギノカワリニクルマ'],
        ['轜', 'ジ、クルマヘンニヒツジュヒンノジュ'],
        ['轟', 'ゴウオン ノ ゴウ，トドロク'],
        ['轗', 'カン、クルマヘンニカンソウブンノカン'],
        [']', 'トジカクカッコ'],
        ['轤', 'ロクロノロ'],
        ['轡', 'クツワ'],
        ['轢', 'アツレキノレキ'],
        ['轣', 'レキ、クルマヘンニレキシカノレキ'],
        ['鼻', 'ハナカゼ ノ ハナ'],
        ['溘', 'コウ，サンズイニキョネンノキョニサラ'],
        ['溟', 'メイ，サンズイニメイフクヲイノルノメイ'],
        ['溝', 'ミゾ，ハイスイコウ ノ コウ'],
        ['溜', 'リュウインガサガル ノ リュウ，タマリ'],
        ['源', 'スイゲン ノ ゲン，ミナモト'],
        ['鄲', 'カンタンノユメノタン'],
        ['準', 'ジュンビスル ノ ジュン'],
        ['鄰', 'トナリ，リンジンノリンノタイジ'],
        ['鄭', 'ジンメイ ノ テイセイコウ ノ テイ'],
        ['溏', 'トウ，サンズイニケントウシノトウ'],
        ['溌', 'ゲンキハツラツ ノ ハツ'],
        ['溂', 'ハツラツノラツ，サンズイニシゲキスルノシ'],
        ['満', 'マンゾク ノ マン'],
        ['溺', 'デキアイスル ノ デキ，オボレル'],
        ['溽', 'ジョク，サンズイニブジョクノジョク'],
        ['鄙', 'ヘンピナノヒ，ヒナ'],
        ['溲', 'ソウ，サンズイニサンバソウノソウ'],
        ['溷', 'コン，サンズイニクニガマエノナカニブタノツクリ'],
        ['溶', 'ヨウエキ ノ ヨウ，トケル'],
        ['溪', 'ケイリュウヅリノケイノキュウジ'],
        ['溯', 'ソジョウスルノソ，サンズイニハッサクノサク'],
        ['溢', 'アフレル，ノウイッケツ ノ イツ'],
        ['鄂', 'ガク，ワニノツクリノミギニオオザト'],
        ['溥', 'シンコクコウテイノフギノフ'],
        ['蚤', 'ムシ ノ ノミ'],
        ['蚣', 'コウ，ムシヘンニオオヤケ'],
        ['蚯', 'キュウ，ムシヘンニサキュウノキュウ'],
        ['蚩', 'オロカヲイミスルシ'],
        ['蚫', 'アワビ，ムシヘンニツツム'],
        ['蚪', 'トウ，ムシヘンニホクトシチセイノト'],
        ['蚶', 'カン，ムシヘンニアマイ'],
        ['蚰', 'ユウ，ムシヘンニリユウノユウ'],
        ['蚌', 'イツボウノアラソイノボウ'],
        ['蚋', 'ゼイ，ムシヘンニコクナイノナイ'],
        ['蚊', 'カトリセンコウ ノ カ'],
        ['蚕', 'ヨウサン ノ サン，カイコ'],
        ['蚓', 'イン，ミミズ，ムシヘンニインリョクノイン'],
        ['兼', 'カネル，ケンギョウ ノ ケン'],
        ['典', 'コクゴジテン ノ テン'],
        ['兵', 'ヘイタイ ノ ヘイ'],
        ['具', 'ドウグ ノ グ'],
        ['其', 'ソノタ ノ ソ'],
        ['共', 'キョウツウ ノ キョウ，トモ'],
        ['六', 'カンスウジ ノ ロク'],
        ['公', 'シュジンコウ ノ コウ，オオヤケ'],
        ['兮', 'ケイ，カンスウジノハチノシタニゴウキュウスルノゴウノシタガワ'],
        ['兩', 'リョウテノリョウノキュウジ'],
        ['全', 'ゼンコク ノ ゼン，マッタク'],
        ['八', 'カンスウジ ノ ハチ'],
        ['兪', 'ユ，ニレノキノニレノツクリ'],
        ['入', 'ハイル，ニュウガク ノ ニュウ'],
        ['兢', 'センセンキョウキョウノキョウ，コクフクスルノコクフタツ'],
        ['兜', 'テツカブト ノ カブト'],
        ['党', 'ヨトウヤトウ ノ トウ'],
        ['兔', 'ドウブツノウサギノイタイジ'],
        ['児', 'ジドウセイト ノ ジ'],
        ['兒', 'ジドウセイトノジノキュウジ'],
        ['免', 'メンキョ ノ メン'],
        ['兌', 'ダカンシヘイノダ'],
        ['3', 'サン'],
        ['兎', 'ウサギ'],
        ['光', 'ヒカリ，ニッコウ ノ コウ'],
        ['先', 'センセイ ノ セン，サキ'],
        ['克', 'コクフクスル ノ コク，カツ'],
        ['充', 'ジュウジツ ノ ジュウ'],
        ['兄', 'アニ オトウト ノ アニ'],
        ['兇', 'キョウダンニタオレル ノ キョウ，ヒトアシ ノ キョウ'],
        ['兆', 'イッチョウエン ノ チョウ'],
        ['允', 'インカ ノ イン，ユルス'],
        ['兀', 'ゴツ，カンスウジノイチノシタニヒトアシ'],
        ['元', 'ゲンキ ノ ゲン，モト'],
        ['顱', 'ロ，ハゼノキノハゼノツクリノミギニページ'],
        ['匸', 'ケイ，ブシュノカクシガマエ'],
        ['顰', 'ヒンシュクヲカウノヒン'],
        ['繧', 'ウン，イトヘンニクモユキノクモ'],
        ['繦', 'スキ，キョウ，イトヘンニユミニイエドモノヒダリガワ'],
        ['繭', 'マユ，カイコ ノ マユ'],
        ['繪', 'カイガノカイ，エホンノエノキュウジ'],
        ['繩', 'ジョウモンドキノジョウノキュウジ'],
        ['繰', 'クル，クリカエシ ノ クリ'],
        ['繿', 'ラン，イトヘンニエイガカントクノカン'],
        ['繽', 'ヒン，イトヘンニライヒンノヒン'],
        ['繼', 'ナマチュウケイノケイノキュウジ'],
        ['繻', 'オリモノノシュスノシュ'],
        ['繹', 'エンエキホウノエキ'],
        ['繆', 'ビュウ，イトヘンニニカワノツクリ'],
        ['繃', 'ホウタイヲマクノホウ，イトヘンニクズレル'],
        ['繁', 'ハンエイスル ノ ハン，シゲル'],
        ['繍', 'シシュウスル ノ シュウ'],
        ['繋', 'ケイリュウスル ノ ケイ，ツナグ'],
        ['繊', 'カガクセンイ ノ セン'],
        ['繖', 'サン，イトヘンニサンポミチノサン'],
        ['繕', 'シュウゼンスル ノ ゼン，ツクロウ'],
        ['織', 'ソシキ ノ シキ'],
        ['繞', 'カンジブシュノニョウ，イトヘンニギョウシュンノギョウノキュウジ'],
        ['繝', 'ゲン，イトヘンニアイダノキュウジ'],
        ['繚', 'リョウランノリョウ，イトヘンニドウリョウノリョウノツクリ'],
        ['繙', 'ハン，ヒモトク'],
        ['駕', 'ガ，リョウガスル ノ ガ'],
        ['駐', 'チュウシャジョウ ノ チュウ'],
        ['駛', 'シ，ハセル，ウマヘンニレキシノシ'],
        ['駅', 'エキビル ノ エキ'],
        ['t', 'ティー タイム'],
        ['旬', 'ゲジュン ノ ジュン'],
        ['旭', 'キョクジツ ノ キョク，アサヒ'],
        ['鼕', 'トウ，ツヅミノシタニフユ'],
        ['旨', 'ロンシヲ ノベル ノ シ，ムネ'],
        ['早', 'ソウチョウ ノ ソウ，ハヤイ'],
        ['日', 'ニチヨウビ ノ ニチ，ヒ'],
        ['旦', 'ガンタン ノ タン'],
        ['旧', 'キュウレキ ノ キュウ'],
        ['无', 'ム，ナイ，テンキヨホウノテンノヨンカクメヲオツニスル'],
        ['旡', 'キ，ツマル，キトクケンノキ，スデニノツクリ'],
        ['既', 'キトクケン ノ キ，スデニ'],
        ['鼇', 'オオガメヲイミスルゴウ'],
        ['旺', 'ショクヨクオウセイナ ノ オウ'],
        ['旻', 'ビン，アキゾラ，ニチヨウビノニチノシタニサクブンノブン'],
        ['鼎', 'テイダン ノ テイ，カナエ'],
        ['旱', 'カンバツノカン，ヒデリ'],
        ['鼈', 'ベッコウアメノベツ'],
        ['旌', 'ハタジルシヲイミスルセイ'],
        ['族', 'スイゾクカン ノ ゾク'],
        ['旋', 'センカイスル ノ セン'],
        ['旄', 'ケデツクッタハタカザリノボウ'],
        ['旅', 'リョコウ ノ リョ，タビ'],
        ['旆', 'オオキナハタヲイミスルタイハイノハイ'],
        ['旁', 'ホウ，カンジノブシュノツクリ'],
        ['旃', 'セン，ホウヘンニセンダンノキノセンノツクリ'],
        ['旙', 'ハタガヒルガエルサマノハンノイタイジ'],
        ['鼠', 'ネズミ'],
        ['旛', 'ハタガヒルガエルサマノハン'],
        ['鼬', 'ドウブツノイタチ'],
        ['旗', 'コッキ ノ キ，ハタ'],
        ['旒', 'ハタヲカゾエルタンイノリュウ'],
        ['臾', 'シュユノマノユ'],
        ['臼', 'ダッキュウスル ノ キュウ，ウス'],
        ['臺', 'ダイドコロノダイノキュウジ'],
        ['臻', 'シン，ブシュノイタルニシンノシコウテイノシン'],
        ['致', 'イッチスル ノ チ，イタス'],
        ['至', 'シキュウ ノ シ，イタル'],
        ['臭', 'クサイ，アクシュウ'],
        ['自', 'ジテンシャ ノ ジ，ミズカラ'],
        ['臨', 'リンジ ノ リン'],
        ['臧', 'ゾウ，レイゾウコノゾウノイタイジカラクサカンムリヲトッタカタチ'],
        ['臥', 'フス，ガシンショウタン ノ ガ'],
        ['臣', 'ソウリダイジン ノ ジン'],
        ['臠', 'レン，コイビトノコイノキュウジノココロノカワリニニク'],
        ['駲', 'ウマヘンニキュウシュウチホウノシュウ'],
        ['臟', 'ゴゾウロップノゾウノイタイジ'],
        ['臚', 'ロ，ニクヅキニハゼノキノハゼノツクリ'],
        ['臘', 'ロウ，ニクヅキニリョウジュウノリョウノキュウジノツクリ'],
        ['臙', 'エン，ニクヅキニツバメ'],
        ['臓', 'シンゾウカンゾウ ノ ゾウ'],
        ['臑', 'ジュ，ニクヅキニジュヨウトキョウキュウノジュ'],
        ['臍', 'セイカタンデンノセイ，ヘソ'],
        ['臈', 'ロウ，ニクヅキニクズモチノクズ'],
        ['臉', 'セン，ニクヅキニマブタノツクリ'],
        ['臆', 'オクビョウナ ノ オク'],
        ['臂', 'ハチメンロッピノヒ，ヒジ'],
        ['臀', 'シリヲイミスルデンブノデン'],
        ['韮', 'ショクブツ ノ ニラ'],
        ['韭', 'ショクブツノニラノセイジ'],
        ['響', 'オンキョウ ノ キョウ，ヒビク'],
        ['韻', 'ヨインガノコル ノ イン'],
        ['韶', 'ショウ、オンガクノオンニマネクノツクリ'],
        ['韵', 'ヨインガノコルノインノイタイジ'],
        ['音', 'オト，オンガク ノ オン'],
        ['韲', 'ナマスヲイミスルセイノイタイジ'],
        ['韋', 'イダテンノイ'],
        ['韈', 'ベツ，カワヘンニケイベツスルノベツ'],
        ['韆', 'セン，カワヘンニサセンスルノセン'],
        ['韃', 'ダッタンジンノタツ'],
        ['韜', 'リクトウサンリャクノトウ'],
        ['韓', 'カンコクジン ノ カン'],
        ['返', 'ヘンジ ノ ヘン，カエス'],
        ['近', 'キンジョ ノ キン，チカイ'],
        ['J', 'ジェイ ジャパン'],
        ['迚', 'トテモ、シンニョウニチュウガクノチュウ'],
        ['迄', 'コレマデ ノ マデ'],
        ['迅', 'ジンソクナ ノ ジン'],
        ['迂', 'ウカイスル ノ ウ'],
        ['駮', 'ハク，ウマヘンニマジワル'],
        ['迎', 'カンゲイスル ノ ゲイ，ムカエル'],
        ['迷', 'メイワク ノ メイ，マヨウ'],
        ['迴', 'カイ、シンニョウニカイスウケンノカイ'],
        ['述', 'ジュツゴ ノ ジュツ，ノベル'],
        ['追', 'ツイセキスル ノ ツイ，オウ'],
        ['迺', 'ナイ，シンニョウニニシヒガシノニシ'],
        ['迸', 'ホトバシル，ホウ'],
        ['迹', 'セキ，シンニョウニソクセキヲノコスノセキノツクリ'],
        ['迦', 'オシャカサマ ノ カ'],
        ['迥', 'ケイ，シンニョウニケイガンノシノケイノツクリ'],
        ['迢', 'チョウ、シンニョウニチョウノウリョクノチョウノツクリ'],
        ['迯', 'ニゲル，トウボウスルノトウノイタイジ'],
        ['>', 'ダイナリ'],
        ['迪', 'テキ，シンニョウニリユウノユウ'],
        ['迫', 'ハクリョク ノ ハク，セマル'],
        ['迩', 'シンニョウ ニ ナンジ ノ イタイジ ノ ニ'],
        ['堯', 'ギョウシュンノギョウノキュウジ'],
        ['堪', 'カンニンブクロ ノ カン，タエル'],
        ['堤', 'テイボウ ノ テイ，ツツミ'],
        ['堡', 'キョウトウホのホ，ホケンシツノホノシタニツチ'],
        ['堽', 'コウ，ツチヘンニアミガシラニタダシイ'],
        ['堺', 'オオサカフサカイシ ノ サカイ'],
        ['場', 'バショ ノ バ，ジョウ'],
        ['堵', 'アンドスル ノ ト'],
        ['堰', 'エンテイ ノ エン，セキ'],
        ['報', 'ホウドウ ノ ホウ'],
        ['堊', 'アク，アネッタイノアノキュウジタイノシタニツチ'],
        ['堋', 'ホウ，ツチヘンニホウユウノホウ'],
        ['堆', 'タイセキブツ ノ タイ'],
        ['堅', 'ケンジツナ ノ ケン，カタイ'],
        ['堂', 'コッカイギジドウ ノ ドウ'],
        ['堀', 'ホリバタ ノ ホリ'],
        ['堝', 'カ，ツチヘンニナベノツクリ'],
        ['堙', 'イン，ツチヘンニエントツノエンノツクリ'],
        ['堕', 'ダラクスル ノ ダ'],
        ['眸', 'メイボウコウシノボウ'],
        ['眺', 'ナガメル，チョウボウ ノ チョウ'],
        ['眼', 'ソウガンキョウ ノ ガン'],
        ['眷', 'サイシケンゾクノケン'],
        ['眩', 'ゲンワクスルノゲン，マブシイ'],
        ['眠', 'ネムル，スイミン ノ ミン'],
        ['眤', 'ジツ，メヘンニアマデラノアマ'],
        ['眥', 'シ，ヒガンシガンノシノシタニモクテキノモク'],
        ['眦', 'シ，メヘンニヒガンシガンノシ'],
        ['眛', 'マイ，メヘンニミライノミ'],
        ['眞', 'マゴコロノマノキュウジ'],
        ['真', 'マゴコロ ノ マ，シン'],
        ['眈', 'コシタンタンノタン'],
        ['眉', 'マユ，ハクビ ノ ビ'],
        ['看', 'カンビョウ ノ カン'],
        ['県', 'トドウフケン ノ ケン'],
        ['省', 'ショウリャクスル ノ ショウ，ハブク'],
        ['眄', 'ウコサベンノベン'],
        ['眇', 'タメツスガメツノスガメ'],
        ['僅', 'ワズカ，キンサ ノ キン'],
        ['僂', 'ロウ，ニンベンニロウカクノロウノキュウジノツクリ'],
        ['像', 'ブツゾウ ノ ゾウ'],
        ['働', 'ロウドウ ノ ドウ，ハタラク'],
        ['僊', 'セン，ニンベンニサセンスルノセンノツクリ'],
        ['僉', 'シケンヲウケルノケンノキュウジノツクリ'],
        ['僖', 'キ，ニンベンニキゲキノキ，ヨロコブ'],
        ['僕', 'シモベ，コウボク ノ ボク'],
        ['僑', 'チュウゴク ノ カキョウ ノ キョウ'],
        ['僞', 'ギゾウノギ，ニセノキュウジ'],
        ['僚', 'カイシャ ノ ドウリョウ ノ リョウ'],
        ['僧', 'ソウリョ ノ ソウ'],
        ['僥', 'ギョウコウノギョウ，ニンベンニギョウシュンギョウノキュウジ'],
        ['僣', 'センエツナガラノセンノイタイジ'],
        ['僮', 'ドウ，ニンベンニワラベ'],
        ['僭', 'センエツナガラノセン'],
        ['僵', 'キョウ，ニンベンニカシハラジングウノカシノツクリ'],
        ['僻', 'ヘキチ ノ ヘキ'],
        ['價', 'カチノカ，アタイノキュウジ'],
        ['魏', 'ギシワジンデンノギ'],
        ['渝', 'ユ，サンズイニニレノキノニレノツクリ'],
        ['渟', 'テイ，サンズイニテイシュカンパクノテイ'],
        ['渙', 'タイショウカンパツノカン，サンズイニカンキセンノカンノツクリ'],
        ['減', 'ゲンショウスル ノ ゲン，ヘル'],
        ['渚', 'ナギサ，ショ'],
        ['渕', 'フチノイタイジ，サンズイニハナガサクノサクノツクリニリットウ'],
        ['渓', 'ケイリュウヅリ ノ ケイ'],
        ['渉', 'ダンタイコウショウ ノ ショウ'],
        ['済', 'キュウサイスル ノ サイ，スマス'],
        ['渋', 'ジュウタイスル ノ ジュウ，シブイ'],
        ['渊', 'フチノイタイジ，タテボウニホンノナカニコメ'],
        ['清', 'セイケツ ノ セイ，キヨイ'],
        ['渇', 'カツボウスル ノ カツ，カワク'],
        ['渾', 'コンシンノチカラノコン，サンズイニグンタイノグン'],
        ['游', 'ユウ，アソブノシンニョウノカワリニサンズイ'],
        ['渺', 'ビョウ，サンズイニモクテキノモクニスクナイ'],
        ['渭', 'イスイノイ，サンズイニイブクロノイ'],
        ['測', 'ソクテイ ノ ソク，ハカル'],
        ['港', 'クウコウ ノ コウ，ミナト'],
        ['渮', 'カ，サンズイニイラツク'],
        ['温', 'オンセン ノ オン，アタタマル'],
        ['渫', 'シュンセツスルノセツ'],
        ['渥', 'アツミハントウ ノ アツ'],
        ['渤', 'ボッカイワンノボツ'],
        ['渦', 'ウズマキ ノ ウズ，カ'],
        ['渡', 'ハシヲワタル ノ ワタル'],
        ['渠', 'アンキョ ノ キョ，ミゾ'],
        ['渣', 'サ，サンズイニケンサノサ'],
        ['蜩', 'ヒグラシ、ムシヘンニシュウヘンノシュウ'],
        ['蜥', 'セキ，ムシヘンニブンセキスルノセキ'],
        ['蜿', 'エン、ムシヘンニアテナノアテ'],
        ['蜻', 'トンボノイチモジメ，セイ、ムシヘンニアオノキュウジ'],
        ['蜷', 'ニナ，ムシヘンニノリマキノマキノキュウジ'],
        ['蜴', 'エキ、ムシヘンニボウエキフウノエキ'],
        ['a', 'エイ アニマル'],
        ['蜍', 'ジョ、ムシヘンニアマリ'],
        ['蜊', 'カイノアサリ、ムシヘンニケンリノリ'],
        ['蜉', 'フ，ムシヘンニツメノシタニコドモノコ'],
        ['蜈', 'ゴ，ムシヘンニゴフクヤノゴノキュウジケイ'],
        ['蜆', 'シジミ，ケン'],
        ['蜃', 'シンキロウノシン'],
        ['蜂', 'ハチミツ ノ ハチ，ホウ'],
        ['蜀', 'サンゴクシノショク'],
        ['蜜', 'ハチミツ ノ ミツ'],
        ['蜚', 'ゴキブリノイチモジメ，ヒジョウグチノヒノシタニムシ'],
        ['蜘', 'クモ，ムシヘン ニ チシキ ノ チ'],
        ['蜒', 'エン，ムシヘンニエンチョウスルノエン'],
        ['蜑', 'タン，エンチョウスルノエンノシタニムシ'],
        ['魔', 'マホウ ノ マ'],
        ['敷', 'シク，ザシキ ノ シキ'],
        ['整', 'セイリスル ノ セイ，トトノエル'],
        ['敵', 'テキミカタ ノ テキ'],
        ['敲', 'スイコウヲカサネルノコウ，タタク'],
        ['数', 'サンスウ ノ スウ，カズ'],
        ['數', 'サンスウノスウノキュウジ'],
        ['敦', 'チュウゴク ノ トンコウ ノ トン'],
        ['敢', 'ユウカンナ ノ カン，アエテ'],
        ['散', 'サンポ ノ サン，チル'],
        ['敬', 'ソンケイ ノ ケイ，ウヤマウ'],
        ['敖', 'ゴウ，ゴウマンナノゴウノツクリ'],
        ['敗', 'ハイボク ノ ハイ，ヤブレル'],
        ['敕', 'チョクメイノチョクノキュウジ'],
        ['救', 'キュウジョ ノ キュウ，スクウ'],
        ['敞', 'カイグンコウショウノショウタレナシ'],
        ['敝', 'ヘイイハボウノヘイ，ニジュウアシナシ'],
        ['敘', 'ジジョデンノジョノイタイジ'],
        ['教', 'キョウカショ ノ キョウ，オシエル'],
        ['故', 'コキョウ ノ コ，ユエ'],
        ['敏', 'ビンカンナ ノ ビン'],
        ['敍', 'ジジョデンノジョノキュウジ'],
        ['效', 'コウカテキナノコウノキュウジ'],
        ['7', 'ナナ'],
        ['徳', 'ドウトク ノ トク'],
        ['徴', 'トクチョウテキナ ノ チョウ'],
        ['徹', 'テツヤスル ノ テツ'],
        ['徼', 'キョウ，ギョウニンベンニゲキレイスルノゲキノツクリ'],
        ['徽', 'キショウヲツケル ノ キ，シルシ'],
        ['徠', 'ジュガクシャノオギュウソライノライ'],
        ['御', 'オンチュウ ノ オン，ゴハン ノ ゴ'],
        ['徨', 'ホウコウスルノコウ，サマヨウ'],
        ['復', 'オウフク ノ フク'],
        ['循', 'アクジュンカン ノ ジュン'],
        ['徭', 'ヨウ，ギョウニンベンニユレルノキュウジノツクリ'],
        ['微', 'ビセイブツ ノ ビ'],
        ['徐', 'ジョコウスル ノ ジョ'],
        ['徑', 'エンノハンケイノケイノキュウジ'],
        ['徒', 'トホ ノ ト'],
        ['従', 'ジュウジスル ノ ジュウ，シタガウ'],
        ['得', 'トクイ ノ トク，エル'],
        ['徘', 'ハイカイスルノハイ，サマヨウ'],
        ['徙', 'シ，ギョウニンベンニトメルニハシルノシタガワ'],
        ['從', 'ジュウジスルノジュウ，シタガウノキュウジ'],
        ['往', 'オウフク ノ オウ'],
        ['征', 'エンセイグン ノ セイ'],
        ['徂', 'ジュガクシャノオギュウソライノソ'],
        ['徃', 'オウフクスルノオウノイタイジ'],
        ['径', 'エン ノ ハンケイ ノ ケイ'],
        ['待', 'キタイスル ノ タイ，マツ'],
        ['徇', 'ジュン，ギョウニンベンニゲジュンノジュン'],
        ['很', 'コン，ギョウニンベンニダイコンノコンノツクリ'],
        ['徊', 'ハイカイスルノカイ，ギョウニンベンニマワル'],
        ['律', 'ホウリツ ノ リツ'],
        ['後', 'ウシロ，ゼンゴ ノ ゴ'],
        ['ｫ', 'チイサイ オオサカ ノ オ'],
        ['≒', '二アリーイコール'],
        ['≪', 'ヒジョウニチイサイ'],
        ['≫', 'ヒジョウニオオキイ'],
        ['≦', 'ショウナリイコール'],
        ['≧', 'ダイナリイコール'],
        ['≠', 'ノットイコール'],
        ['≡', 'ゴウドウ'],
        ['ω', 'ギリシャ オメガ'],
        ['ψ', 'ギリシャ プサイ'],
        ['χ', 'ギリシャ カイ'],
        ['φ', 'ギリシャ ファイ'],
        ['υ', 'ギリシャ ウプシロン'],
        ['τ', 'ギリシャ タウ'],
        ['σ', 'ギリシャ シグマ'],
        ['ρ', 'ギリシャ ロー'],
        ['π', 'ギリシャ パイ'],
        ['x', 'エックス エックスセン'],
        ['靱', 'キョウジンナノジンノイタイジ'],
        ['靴', 'クツシタ ノ クツ，カ'],
        ['靹', 'ドウ，カワヘンニコクナイノナイ'],
        ['瞋', 'シン，メヘンニマゴコロノマノキュウジ'],
        ['靺', 'マツ，カワヘンニネンマツノマツ'],
        ['瞎', 'カツ，メヘンニサイガイノガイノキュウジタイ'],
        ['靼', 'ダッタンジンノタン'],
        ['靡', 'フウビスルノビ，ナビク'],
        ['靠', 'コウ，ツゲルノシタニヒジョウグチノヒ'],
        ['瞑', 'メイモクスルノメイ'],
        ['靤', 'ホウ，ジメンノメンノミギニツツム'],
        ['靦', 'テン、ジメンノメンノミギニケンブツスルノケン'],
        ['革', 'カクメイ ノ カク'],
        ['靨', 'エクボ、エンセイカンノエンノシタニジメンノメン'],
        ['靫', 'ウツボカズラノウツボ'],
        ['瞞', 'ギマンニミチタノマン'],
        ['瞠', 'ドウ，メヘンニドウモクスルノドウ'],
        ['青', 'アオイ，セイシュン ノ セイ'],
        ['瞥', 'イチベツスル ノ ベツ'],
        ['静', 'レイセイ ノ セイ，シズカ'],
        ['靜', 'レイセイノセイ、シズカノキュウジ'],
        ['瞬', 'シュンカン ノ シュン，マタタク'],
        ['瞭', 'メイリョウナ ノ リョウ'],
        ['瞳', 'ヒトミ，ドウコウ ノ ドウ'],
        ['瞰', 'チョウカンズノカン，ミオロス'],
        ['靂', 'セイテンノヘキレキノレキ'],
        ['瞶', 'キ，メヘンニキチョウヒンノキ'],
        ['靄', 'アサモヤノモヤ'],
        ['靆', 'タイ、クモノミギニタイホジョウノタイ'],
        ['靉', 'アイ、クモノミギニアイスルノアイ'],
        ['瞻', 'セン，メヘンニタンニンノタンノキュウジノツクリ'],
        ['瞹', 'アイ，メヘンニアイスルノアイ'],
        ['瞿', 'キョウクスルノクノツクリ，メガフタツノシタニフルトリ'],
        ['瞼', 'マブタ，ガンケンノケン'],
        ['瞽', 'コ，ツヅミノシタニモクテキノモク'],
        ['豚', 'ブタ，トンジル ノ トン'],
        ['豐', 'ユタカナノキュウジ'],
        ['豕', 'シ，ブシュノイノコ'],
        ['豈', 'アニハカランヤノアニ'],
        ['豊', 'ホウサク ノ ホウ，ユタカ'],
        ['豌', 'エンドウマメノエン'],
        ['豎', 'ジュ、ケンジツナノケンノツチノカワリニマメ'],
        ['豁', 'カツゼントサトルノカツ'],
        ['豆', 'トウフ ノ トウ，マメ'],
        ['豸', 'チ，ブシュノムジナ'],
        ['豹', 'ドウブツ ノ ヒョウ'],
        ['豺', 'サイロウノムレノサイ、ヤマイヌ'],
        ['豼', 'ヒ，ムジナヘンニヒカクスルノヒ'],
        ['豪', 'ゴウカイナ ノ ゴウ'],
        ['豫', 'ヨテイノヨノキュウジ'],
        ['豬', 'チョ、イノコノミギニカガクシャノシャノキュウジタイ'],
        ['象', 'インショウテキ ノ ショウ，ゾウ'],
        ['豢', 'コブシノテノカワリニイノコ'],
        ['澤', 'コウタクノタク，サワノキュウジ'],
        ['澣', 'カン，サンズイニシンカンセンノカン'],
        ['澡', 'ソウ，サンズイニソウジュウスルノソウノツクリ'],
        ['澪', 'ミオツクシノミオ，レイ'],
        ['澳', 'オウ，サンズイニオクバノオクノキュウジ'],
        ['澱', 'チンデンスル ノ デン，ヨドム'],
        ['澹', 'アンタンタルクモユキノタン'],
        ['澆', 'ギョウ，サンズイニギョウシュンノギョウノキュウジ'],
        ['澄', 'ミズガスム ノ スム'],
        ['澂', 'ミズガスムノスムノイタイジ'],
        ['澁', 'ジュウタイスルノジュウ，シブイノキュウジ'],
        ['澀', 'ジュウタイスルノジュウ，シブイノノキュウジノイタイジ'],
        ['澎', 'ホウ，サンズイニツヅミノヒダリガワニサンヅクリ'],
        ['澗', 'カン，サンズイ ニ アイダ'],
        ['澑', 'リュウインガサガルノリュウ，タマリノイタイジ'],
        ['伺', 'シンタイウカガイ ノ ウカガイ'],
        ['螳', 'カマキリヲイミスルトウロウノトウ，ムシヘンニコウカイドウノドウ'],
        ['螻', 'ロウ，ムシノケラノイチモジメ'],
        ['螺', 'ラセン ノ ラ'],
        ['螽', 'シュウ，キセツノフユノシタニムシフタツ'],
        ['N', 'エヌ ノベンバー'],
        ['螢', 'ホタル，ケイコウトウノケイノキュウジ'],
        ['螫', 'セキ，オンシャヲウアタエルノシャノシタニムシ'],
        ['螯', 'ゴウ，ゴウマンナノゴウノツクリノシタニムシ'],
        ['螟', 'メイ，ムシヘンニメイフクヲイノルノメイ'],
        ['螂', 'カマキリヲイミスルトウロウノロウ，ムシヘンニモモタロウノロウ'],
        ['融', 'キンユウ ノ ユウ'],
        ['狹', 'キョウ，セマイノキュウジ'],
        ['伯', 'ハクシャク ノ ハク'],
        ['佰', 'ハク，ニンベンニカンスウジノヒャク'],
        ['偈', 'ゲ，ニンベンニカッショクノカツノツクリ'],
        ['佳', 'カサク ノ カ，ニンベン ニ ツチ フタツ ノ カ'],
        ['併', 'ヘイヨウスル ノ ヘイ，アワセル'],
        ['佶', 'キツ，ニンベンニダイキチノキチ'],
        ['偃', 'エン，ニンベンニエンテイノエン，セキノツクリ'],
        ['佻', 'ケイチョウフハクノチョウ'],
        ['佼', 'ニンベン ニ マジワル ノ コウ'],
        ['假', 'カメンノカ，カリノキュウジ'],
        ['使', 'シヨウスル ノ シ，ツカウ'],
        ['做', 'サ，ニンベンニコキョウノコ'],
        ['停', 'テイシャ ノ テイ'],
        ['佩', 'ハイヨウスルノハイ，オビル'],
        ['偕', 'カイ，トモニ，ニンベンニミナサマノミナ'],
        ['佯', 'ヨウ，ニンベンニドウブツノヒツジ'],
        ['佐', 'ホサスル ノ サ'],
        ['佑', 'テンユウ ノ ユウ，ニンベン ニ ミギ'],
        ['体', 'カラダ，タイイク ノ タイ'],
        ['何', 'ナニモノ ノ ナニ'],
        ['佗', 'タ，ワビ，ニンベンニウカンムリニカタカナノヒ'],
        ['余', 'ヨユウ ノ ヨ，アマル'],
        ['佚', 'アンイツノイツ，ニンベンニウシナウ'],
        ['佛', 'ブツゾウノブツノキュウジ'],
        ['健', 'ケンコウ ノ ケン，スコヤカ'],
        ['佝', 'ク，ニンベンニハイクノク'],
        ['佞', 'カンネイノネイ'],
        ['偸', 'トウ，ニンベンニユカイナノユノツクリ'],
        ['佃', 'ツクダニ ノ ツクダ'],
        ['偽', 'ギゾウ ノ ギ，ニセ'],
        ['但', 'タダシガキ ノ タダシ'],
        ['佇', 'チョリツスルノチョ，タタズム'],
        ['偲', 'コジンヲ シノブ ノ シノブ'],
        ['偵', 'テイサツスル ノ テイ'],
        ['位', 'タンイ ノ イ'],
        ['低', 'ヒクイ，テイ'],
        ['住', 'ジュウショ ノ ジュウ，スム'],
        ['$', 'ドル'],
        ['祷', 'モクトウスル ノ トウ，イノル'],
        ['祺', 'キ，シメスヘンニソレ'],
        ['祿', 'ゲンロクブンカノロクノキュウジ'],
        ['祢', 'ネ，シメスヘン ニ ナンジ ノ イタイジ'],
        ['祠', 'シ，ホコラ，シメスヘンニシカイシャノシ'],
        ['祥', 'フショウジ ノ ショウ'],
        ['票', 'トウヒョウスル ノ ヒョウ'],
        ['傾', 'カタムク，ケイコウ ノ ケイ'],
        ['祭', 'サイジツ ノ サイ，マツリ'],
        ['祓', 'ハライキヨメルノハライ，フツ'],
        ['祐', 'テンユウ ノ ユウ，シメスヘン ニ ミギ'],
        ['祗', 'シ，シメスヘンニヒクイノツクリ'],
        ['祖', 'ソセン ノ ソ'],
        ['祕', 'ヒミツノヒノキュウジ'],
        ['祚', 'クライヲウケツグセンソノソ'],
        ['祟', 'タタル，スイ'],
        ['神', 'カミサマ ノ カミ，シン'],
        ['祝', 'シュクジツ ノ シュク，イワウ'],
        ['祁', 'シメスヘン ニ オオザト ノ キ'],
        ['祀', 'サイシノシ，マツル'],
        ['祇', 'ギオンマツリ ノ ギ'],
        ['祉', 'シャカイフクシ ノ シ'],
        ['祈', 'イノル，キガンスル ノ キ'],
        ['齡', 'ネンレイノレイノキュウジ'],
        ['齢', 'ネンレイ ノ レイ'],
        ['書', 'キョウカショ ノ ショ，カク'],
        ['曹', 'ソウトウシュウ ノ ソウ'],
        ['鰡', 'ウオヘンニリュウガクノリュウ，ボラ'],
        ['曼', 'マンダラノマン'],
        ['曽', 'キソジ ノ ソ'],
        ['曾', 'キソジ ノ ソ ノ キュウジ'],
        ['替', 'フリカエコウザ ノ カエル'],
        ['曰', 'イワクツキノイワク'],
        ['曲', 'キョクセン ノ キョク，マガル'],
        ['曳', 'エイコウスル ノ エイ，ヒク'],
        ['更', 'ヘンコウ ノ コウ，サラニ'],
        ['曵', 'フネヲエイコウスルノエイノイタイジ'],
        ['曷', 'カツ、カッショクノカツノツクリ'],
        ['鰲', 'ゴウ，ゴウマンノゴウノツクリノシタニサカナ'],
        ['曩', 'ノウ，ヨウビノニチノシタニユズルノキュウジノツクリ'],
        ['鰰', 'サカナノハタハタ，ウオヘンニカミサマノカミ'],
        ['曠', 'コウヤノコウ，ニチヘンニヒロイノキュウジ'],
        ['鰻', 'ウナギ'],
        ['鰹', 'カツオ，ウオヘン ニ カタイ'],
        ['鰾', 'ウキブクロ，ウオヘンニトウヒョウスルノヒョウ'],
        ['曦', 'ギ，ウツクシイタイヨウヲイミスルニチヘンノギ'],
        ['曙', 'アケボノ，ショ'],
        ['曚', 'ボウ，ニチヘンニケイモウスルノモウ'],
        ['曜', 'ニチヨウビ ノ ヨウ'],
        ['曝', 'サラス，ニチヘン ニ ボウリョク ノ ボウ'],
        ['鰄', 'イ，ウオヘンニイゲンガアルノイ'],
        ['鰊', 'サカナノニシン，レン'],
        ['鰈', 'サカナノカレイ'],
        ['鰉', 'コウ，ウオヘンニコウタイシノコウ'],
        ['銃', 'ケンジュウウ ノ ジュウ'],
        ['曖', 'アイマイナノアイ'],
        ['鰍', 'カジカ，ウオヘン ニ アキ'],
        ['鰒', 'フグ，ウオヘンニハラノツクリ'],
        ['曉', 'アカツキノキュウジ'],
        ['鰐', 'ドウブツ ノ ワニ'],
        ['鰔', 'カン，ウオヘンニハリキュウノハリノツクリ'],
        ['鰕', 'ウオヘンノエビ，カ'],
        ['曁', 'キ，キトクケンノキノシタニガンタンノタン'],
        ['曄', 'ヨウ，ニチヘンニチュウカナベノカ'],
        ['曇', 'クモリ，ドンテン ノ ドン'],
        ['０', 'ゼロ'],
        ['１', 'イチ'],
        ['２', 'ニ'],
        ['３', 'サン'],
        ['４', 'ヨン'],
        ['５', 'ゴ'],
        ['６', 'ロク'],
        ['７', 'ナナ'],
        ['８', 'ハチ'],
        ['９', 'キュウ'],
        ['：', 'コロン'],
        ['；', 'セミコロン'],
        ['＜', 'ショウナリ'],
        ['＝', 'イコール'],
        ['＞', 'ダイナリ'],
        ['？', 'クエスチョン'],
        ['！', 'カンタンフ'],
        ['＃', 'シャープ'],
        ['＄', 'ドル'],
        ['％', 'パーセント'],
        ['＆', 'アンド'],
        ['（', 'カッコ'],
        ['）', 'トジカッコ'],
        ['＊', 'アスタリスク'],
        ['＋', 'プラス'],
        ['，', 'コンマ'],
        ['－', 'マイナス'],
        ['．', 'ピリオド'],
        ['／', 'スラッシュ'],
        ['Ｐ', 'ピー パパ'],
        ['Ｑ', 'キュー クエスチョン'],
        ['Ｒ', 'アール ルーム'],
        ['Ｓ', 'エス スポーツ'],
        ['e', 'イー エッグ'],
        ['Ｕ', 'ユー ユージュアリー'],
        ['Ｖ', 'ブイ ビデオ'],
        ['Ｗ', 'ダブリュー ウィンドウ'],
        ['Ｘ', 'エックス エックスセン'],
        ['Ｙ', 'ワイ ヤング'],
        ['Ｚ', 'ゼット ズー'],
        ['［', 'カクカッコ'],
        ['＼', 'バックスラッシュ'],
        ['］', 'トジカクカッコ'],
        ['＾', 'ベキジョウ'],
        ['＿', 'アンダーライン'],
        ['＠', 'アットマーク'],
        ['Ａ', 'エイ アニマル'],
        ['Ｂ', 'ビー ボーイ'],
        ['Ｃ', 'シー キャット'],
        ['Ｄ', 'ディー デスク'],
        ['Ｅ', 'イー エッグ'],
        ['Ｆ', 'エフ フレンド'],
        ['Ｇ', 'ジー ゴルフ'],
        ['Ｈ', 'エイチ ホテル'],
        ['Ｉ', 'アイ インク'],
        ['Ｊ', 'ジェイ ジャパン'],
        ['Ｋ', 'ケイ キッチン'],
        ['Ｌ', 'エル ラブ'],
        ['Ｍ', 'エム マイク'],
        ['Ｎ', 'エヌ ノベンバー'],
        ['Ｏ', 'オー オープン'],
        ['瘁', 'スイ，ヤマイダレニソツギョウノソツ'],
        ['瘍', 'イカイヨウノヨウ'],
        ['瘉', 'ユ，ヤマイダレニニレノキノツクリ'],
        ['瘋', 'フウテンノフウ，ヤマイダレニカゼ'],
        ['瘟', 'オン，ヤマイダレニオンセンノオンノキュウジノツクリ'],
        ['瘤', 'ドウミャクリュウノリュウ，コブ'],
        ['瘧', 'オコリ，ヤマイダレニギャクタイノギャク'],
        ['瘠', 'セキ，ヤマイダレニセキズイノセキ'],
        ['瘡', 'ミズボウソウノソウ'],
        ['瘢', 'ハンコンノハン，ヤマイダレニイッパンテキノハン'],
        ['瘴', 'ショウ，ヤマイダレニブンショウヲカクノショウ'],
        ['瘰', 'ルイレキノルイ，ヤマイダレニルイセキスルノルイ'],
        ['瘻', 'ジロウノロウ，ヤマイダレニカズノキュウジノヒダリガワ'],
        ['賢', 'ケンジャ ノ ケン，カシコイ'],
        ['賣', 'ショウバイノバイ、ウルノキュウジ'],
        ['賠', 'バイショウキン ノ バイ'],
        ['賦', 'ゲップバライ ノ フ'],
        ['賤', 'ゲセンナノセン，イヤシイ'],
        ['質', 'シツモン ノ シツ'],
        ['賭', 'トバク ノ ト，カケル'],
        ['賺', 'ナダメスカスノスカス'],
        ['賻', 'フ、カイヘンニハクブツカンノハクノツクリ'],
        ['購', 'コウニュウスル ノ コウ'],
        ['槙', 'ショクブツ ノ マキ，キヘン ニ マゴコロ ノ マ'],
        ['賂', 'ワイロ ノ ロ'],
        ['賃', 'チンギン ノ チン'],
        ['賀', 'ネンガジョウ ノ ガ'],
        ['賁', 'ヒ，フンカスルノフンノツクリ'],
        ['資', 'シゲン ノ シ'],
        ['賄', 'ワイロ ノ ワイ，マカナウ'],
        ['賊', 'サンゾク ノ ゾク'],
        ['賈', 'コ、オオイガシラニカイガラノカイ'],
        ['賎', 'イヤシイ，セン'],
        ['賍', 'ゾウブツザイノゾウノタイジ'],
        ['賓', 'ライヒン ノ ヒン'],
        ['賑', 'ニギワウ，インシン ノ シン'],
        ['賚', 'ライ，ライネンノライノキュウジノシタニカイガラノカイ'],
        ['賛', 'サンセイスル ノ サン'],
        ['賞', 'ノーベルショウ ノ ショウ'],
        ['賜', 'オンシ ノ シ，タマワル'],
        ['弸', 'ホウ，ユミヘンニホウユウヲイミスルホウ'],
        ['弾', 'ダンリョク ノ ダン，ハズム'],
        ['弼', 'ホヒツ ノ ヒツ，スケ'],
        ['弱', 'キョウジャク ノ ジャク，ヨワイ'],
        ['強', 'ベンキョウ ノ キョウ，ツヨイ'],
        ['張', 'キンチョウスル ノ チョウ，ハル'],
        ['弩', 'チョウドキュウノド，ヤッコノシタニユミ'],
        ['弯', 'ワンガンノワンノツクリ'],
        ['弭', 'ビ，ユミヘンニミミ'],
        ['弦', 'ゲンガッキ ノ ゲン，ツル'],
        ['弧', 'コヲエガク ノ コ'],
        ['弥', 'アミダブツ ノ ミ'],
        ['弛', 'ユルム，シカンスル ノ シ'],
        ['弘', 'コウボウタイシ ノ コウ，ヒロイ'],
        ['弟', 'アニオトオト ノ オトオト'],
        ['弓', 'ユミヤ ノ ユミ'],
        ['弐', 'ケイヤクショニ ツカウ スウジ ノ ニ'],
        ['弑', 'シギャクスルノシ，コロスノヒダリガワニニュウガクシキノシキ'],
        ['弖', 'テニヲハノテ，ユミノシタニカンスウジノイチ'],
        ['弗', 'フッソ ノ フツ，ドル'],
        ['弔', 'トムラウ，チョウジ ノ チョウ'],
        ['引', 'インヨウスル ノ イン，ヒク'],
        ['弊', 'ヘイガイ ノ ヘイ'],
        ['弋', 'ヨク，ブシュノシキガマエ'],
        ['弉', 'サンゾウホウシゲンジョウノジョウノイタイジ'],
        ['式', 'ニュウガクシキ ノ シキ'],
        ['弌', 'イチ，カンスウジノイチノイタイジ，シキガマエニイチ'],
        ['弍', 'カンスウジノニノイタイジ，シキガマエニニ'],
        ['弃', 'ハイキスルノキ，ステルノイタイジ'],
        [';', 'セミコロン'],
        ['弁', 'ベントウ ノ ベン'],
        ['弄', 'ホンロウスル ノ ロウ，モテアソブ'],
        ['◆', 'クロヒシガタ'],
        ['◇', 'ヒシガタ'],
        ['○', 'マルジルシ'],
        ['◎', 'ニジュウマル'],
        ['●', 'クロマル'],
        ['黐', 'トリモチノモチ，キビヘンニハナレルノツクリ'],
        ['◯', 'オオキナマル'],
        ['騾', 'ドウブツノラバノラ'],
        ['點', 'テンスウノテンノキュウジ'],
        ['埓', 'ラチガアカナイノラチノイタイジ'],
        ['埒', 'ラチガアカナイノラチ'],
        ['俸', 'ホウキュウ ノ ホウ'],
        ['俾', 'ヘイ，ニンベンニヒクツナノヒ'],
        ['埖', 'ゴミ，ツチヘンニハナビノハナ'],
        ['埔', 'ホ，ツチヘンニシジンノトホノホ'],
        ['俳', 'ハイク ノ ハイ'],
        ['域', 'チイキ ノ イキ'],
        ['埜', 'ヤ，ハヤシ ノ シタニ ツチ'],
        ['埃', 'ホコリマミレノホコリ，ジンアイノアイ'],
        ['埀', 'スイチョクノスイ，タレルノイタイジ'],
        ['修', 'シュウリスル ノ シュウ'],
        ['埆', 'カク，ツチヘンニツノ'],
        ['埋', 'ウメル，マイボツスル ノ マイ'],
        ['俣', 'ミナマタビョウ ノ マタ'],
        ['信', 'シンゴウキ ノ シン'],
        ['城', 'ジョウカマチ ノ ジョウ，シロ'],
        ['俤', 'オモカゲ，ニンベンニオトウト'],
        ['俥', 'クルマ，ニンベンニデンシャノシャ'],
        ['俚', 'リゲンノリ，ニンベンニサトガエリノサト'],
        ['俛', 'ベン，ニンベンニメンキョノメン'],
        ['俘', 'トリコ，フリョノフ'],
        ['執', 'シツジ ノ シツ，トル'],
        ['俟', 'シ，マツ，ニンベンニカタカナノムノシタニユミヤノヤ'],
        ['埴', 'ハニワ ノ ハニ'],
        ['基', 'キホン ノ キ，モトヅク'],
        ['培', 'サイバイスル ノ バイ，ツチカウ'],
        ['俑', 'ヘイバヨウノヨウ'],
        ['俗', 'フウゾク ノ ゾク'],
        ['俔', 'ケン，ニンベンニケンブツスルノケン'],
        ['埼', 'サイタマケン ノ イチモジメ ノ サキ'],
        ['埣', 'サイ，ツチヘンニソツギョウノソツ'],
        ['埠', 'ミナト ノ フトウ ノ フ'],
        ['俎', 'マナイタ，ソジョウノソ'],
        ['係', 'カンケイ ノ ケイ，カカリ'],
        ['促', 'サイソクスル ノ ソク，ウナガス'],
        ['俄', 'ニワカ，ガゼン ノ ガ'],
        ['黨', 'ヨトウヤトウノトウノキュウジ'],
        ['鱚', 'サカナノキス，ウオヘンニヨロコブ'],
        ['黻', 'ヒザカケヲイミスルフツ'],
        ['鱒', 'マス，サカナヘン ニ ソンケイスル ノ ソン'],
        ['黹', 'チ，ブシュノフツ'],
        ['迭', 'コウテツスル ノ テツ'],
        ['黽', 'ビン，ナワノキュウジノツクリ'],
        ['鱈', 'タラ，サカナヘン ニ ユキ'],
        ['銹', 'シュウ、カネヘンニヒイデル'],
        ['騁', 'テイ，ハセル，ウマヘンニショウヘイスルノヘイノツクリ'],
        ['騅', 'スイ，ウマヘンニフルトリ'],
        ['|', 'タテボウ'],
        ['漫', 'マンガ ノ マン'],
        ['漬', 'ツケモノ ノ ツケル'],
        ['漠', 'サハラサバク ノ バク'],
        ['漣', 'レン，サザナミ'],
        ['漢', 'カンジテスト ノ カン'],
        ['漸', 'ゼンゾウスル ノ ゼン，ヨウヤク'],
        ['漿', 'ショウ，ショウグンノショウノキュウジノシタニミズ'],
        ['漾', 'ヨウ，サンズイニカミサマノカミノキュウジノツクリ'],
        ['漱', 'ナツメソウセキノソウ，ススグ'],
        ['漲', 'チョウ，ミナギル'],
        ['漉', 'チャコシ ノ コス'],
        ['漏', 'モラス，ロウデン ノ ロウ'],
        ['漁', 'ギョコウ ノ ギョ'],
        ['漂', 'ヒョウリュウスル ノ ヒョウ，タダヨウ'],
        ['漆', 'ウルシヌリ ノ ウルシ，シツ'],
        ['漑', 'カンガイヨウスイノガイ'],
        ['漓', 'ボッコンリンリノリ，サンズイニリリクノリノヒダリガワ'],
        ['漕', 'コグ，ソウテイ ノ ソウ'],
        ['演', 'エンソウスル ノ エン'],
        ['萸', 'ユ、クサカンムリニシュユノマノユ'],
        ['落', 'ラクセンスル ノ ラク，オチル'],
        ['萼', 'ショクブツノハナノガク'],
        ['萱', 'クサカンムリ ニ センデン ノ セン'],
        ['萵', 'ワ，クサカンムリニナベノツクリ'],
        ['萪', 'カ、クサカンムリニキョウカショノカ'],
        ['萩', 'ショクブツ ノ ハギ'],
        ['萬', 'マンネンヒツノマン、ヨロズノキュウジ'],
        ['萢', 'ヤチ、クサカンムリニアワダテルノアワ'],
        ['萠', 'ホウガノホウ，モエルノイタイジ'],
        ['鱧', 'サカナノハモ，ウオヘンニユタカ'],
        ['萓', 'ギ、クサカンムリニベンギノギ'],
        ['萋', 'セイ、クサカンムリニアイサイカノサイ'],
        ['萎', 'イシュクスル ノ イ，ナエル'],
        ['萍', 'ヘイ，クサカンムリニサンズイニヘイワノヘイ'],
        ['萌', 'ホウガ ノ ホウ，モエル'],
        ['萃', 'スイ、クサカンムリニソツギョウノソツ'],
        ['萇', 'チョウ、クサカンムリニチョウナンノチョウ'],
        ['萄', 'ブドウシュ ノ ドウ'],
        ['鶤', 'コン，グンタイノグンノミギニトリ'],
        ['鶯', 'ウグイス，アタマニカヨウビノカガフタツ'],
        ['鶩', 'ボク，ムジュンノムトノブンノシタニトリ'],
        ['鶫', 'ツグミ，ニシンノツクリノミギニトリ'],
        ['鶴', 'トリ ノ ツル'],
        ['鶲', 'オウ，オキナノミギニトリ'],
        ['鶸', 'ジャク，ヨワイノミギニトリ，ヒワ'],
        ['鶺', 'セキレイノセキ'],
        ['鶻', 'コツ，ホネノミギニトリ'],
        ['鶇', 'ツグミ，ヒガシノミギニトリ'],
        ['鶏', 'ニワトリ，ヨウケイ ノ ケイ'],
        ['鶉', 'トリノウズラ'],
        ['鶚', 'ガク，ワニノツクリノミギニトリ，ミサゴ'],
        ['時', 'ジカン ノ ジ，トキ'],
        ['晃', 'ニチヨウビ ノ ニチ ノ シタニ ヒカリ，アキラ'],
        ['ﾘ', 'リンゴ ノ リ'],
        ['晁', 'チョウ，ニチヨウビノニチノシタニイッチョウエンノチョウ'],
        ['ﾞ', 'ダクテン'],
        ['ﾟ', 'ハンダクテン'],
        ['晄', 'コウ，ニチヘンニヒカリ'],
        ['ﾝ', 'オシマイ ノ ン'],
        ['ﾒ', 'メガネ ノ メ'],
        ['晋', 'チュウゴク ノ コクメイ ノ シン，ススム'],
        ['ﾐ', 'ミカン ノ ミ'],
        ['晉', 'チュウゴクノコクメイノシン，ススムノキュウジ'],
        ['ﾖ', 'ヨット ノ ヨ'],
        ['晏', 'アン，ニチヨウビノニチノシタニアンシンノアン'],
        ['ﾔ', 'ヤカン ノ ヤ'],
        ['ﾕ', 'ユカタ ノ ユ'],
        ['晒', 'サラシモメン ノ サラシ'],
        ['ﾋ', 'ヒカリ ノ ヒ'],
        ['ﾈ', 'ネズミ ノ ネ'],
        ['R', 'アール ルーム'],
        ['ﾎ', 'ホケン ノ ホ'],
        ['ﾏ', 'マッチ ノ マ'],
        ['ﾌ', 'フトン ノ フ'],
        ['ﾍ', 'ヘイワ ノ ヘ'],
        ['ﾂ', 'ツバメ ノ ツ'],
        ['ﾃ', 'テガミ ノ テ'],
        ['ﾀ', 'タバコ ノ タ'],
        ['ﾁ', 'チキュウ ノ チ'],
        ['晞', 'キ，ニチヘンニキボウノキ'],
        ['晟', 'セイ，ニチヨウビノニチノシタニセイチョウスルノセイ'],
        ['ﾄ', 'トウキョウ ノ ト'],
        ['晝', 'ヒルヤスミノヒル，チュウノキュウジ'],
        ['晢', 'セツ，コッセツスルノセツノシタニニチヨウビノニチ'],
        ['晦', 'ミソカ，ニチヘン ニ マイ'],
        ['晧', 'コウ，ヒヘンニツゲル'],
        ['晤', 'ゴ，ニチヘンニタゴサクノゴ'],
        ['晨', 'シン，ニチヨウビノニチノシタニジュウニシノタツ'],
        ['晩', 'バンゴハン ノ バン'],
        ['普', 'フキュウスル ノ フ'],
        ['景', 'フウケイ ノ ケイ'],
        ['晰', 'ズノウメイセキノセキ'],
        ['面', 'ジメン ノ メン'],
        ['晶', 'スイショウダマ ノ ショウ'],
        ['晴', 'ハレ，セイテン ノ セイ'],
        ['智', 'チ，シル ノ シタニ ニチヨウビ ノ ニチ'],
        ['馗', 'ショウキサマノキ'],
        ['惠', 'メグム，チエノエノキュウジ'],
        ['靭', 'キョウジンナ ノ ジン'],
        ['称', 'イチニンショウ ノ ショウ'],
        ['馘', 'カクシュスルノカク，クビヘンニアル'],
        ['移', 'イドウ ノ イ，ウツル'],
        ['香', 'コウシンリョウ ノ コウ，カオリ'],
        ['秤', 'テンビン ノ ビン，ハカリ'],
        ['秧', 'オウ，ノギヘンニチュウオウシュウケンノオウ'],
        ['秦', 'シン ノ シコウテイ ノ シン'],
        ['秡', 'ハツ、ノギヘンニハライキヨメルノハライノツクリ'],
        ['秣', 'リョウマツノマツ'],
        ['秬', 'キョ、ノギヘンニキョダイナノキョ'],
        ['秩', 'チツジョ ノ チツ'],
        ['秕', 'シイナ，ノギヘンニヒカクスルノヒ'],
        ['科', 'キョウカショ ノ カ'],
        ['秒', 'ビョウヨミ ノ ビョウ'],
        ['租', 'ソゼイ ノ ソ'],
        ['靖', 'ヤスクニジンジャ ノ ヤス'],
        ['秘', 'ヒミツ ノ ヒ'],
        ['私', 'シテツ ノ シ，ワタシ'],
        ['秀', 'シュウサイ ノ シュウ，ヒイデル'],
        ['秉', 'コクモツノタンイヘイ'],
        ['秋', 'アキマツリ ノ アキ，シュウ'],
        ['庸', 'ボンヨウナ ノ ヨウ'],
        ['庵', 'イオリ，タクアン ノ アン'],
        ['庶', 'ショミン ノ ショ'],
        ['康', 'ケンコウ ノ コウ，イエヤス ノ ヤス'],
        ['庭', 'テイエン ノ テイ，ニワ'],
        ['庫', 'レイゾウコ ノ コ'],
        ['度', 'オンドケイ ノ ド'],
        ['座', 'ザセキ ノ ザ，スワル'],
        ['庠', 'ショウ，マダレニヒツジ'],
        ['府', 'トドウフケン ノ フ'],
        ['庚', 'コウシンヅカ ノ コウ，カノエ'],
        ['底', 'ソコヂカラ ノ ソコ，テイ'],
        ['庖', 'マダレ ノ ホウチョウ ノ ホウ'],
        ['店', 'ミセ，ショウテン ノ テン'],
        ['序', 'ジュンジョ ノ ジョ'],
        ['床', 'トコヤ ノ トコ，ショウ'],
        ['庄', 'ショウヤ ノ ショウ'],
        ['庇', 'ヒゴスル ノ ヒ，ヒサシ'],
        ['庁', 'キショウチョウ ノ チョウ'],
        ['広', 'ヒロバ ノ ヒロ，コウ'],
        ['╋', 'フトクロス'],
        ['靈', 'レイエンノレイ、タマノキュウジ'],
        ['╂', 'フトタテセンクロス'],
        ['馳', 'ゴチソウ ノ チ，ハセル'],
        ['馭', 'ギョシャノギョ，ウマヘンニマタ'],
        ['餮', 'テツ，ムサボル'],
        ['馮', 'ヒョウ，タノム，ニスイニウマ'],
        ['馨', 'ジンメイ ノ カオル，ケイ，カグワシイ'],
        ['皎', 'コウ，シロヘンニマジワル'],
        ['鑼', 'ドラヤキノラ'],
        ['鑿', 'コウグノノミ'],
        ['鑾', 'ラン，コイビトノコイノキュウジノココロノカワリニキンヨウビノキン'],
        ['皋', 'ショクブツノサツキノイタイジ'],
        ['皈', 'キタクスルノキ，カエルノイタイジ'],
        ['皆', 'ミナサマ ノ ミナ，カイ'],
        ['皇', 'コウタイシ ノ コウ'],
        ['的', 'モクテキ ノ テキ'],
        ['皃', 'ビボウヲタモツノボウノイタイジ'],
        ['皀', 'キョウ，ハクチョウノハクノシタニカタカナノヒ'],
        ['皚', 'ガイ，シロヘンニヨロイノツクリ'],
        ['皙', 'セキ，ブンセキスルノセキノシタニハクチョウノハク'],
        ['皖', 'カン，シロヘンニカンリョウスルノカン'],
        ['皓', 'メイボウコウシノコウ，シロヘンニツゲル'],
        ['皐', 'ショクブツ ノ サツキ'],
        ['鑢', 'コウグノヤスリ'],
        ['皮', 'カワヲムク ノ カワ，ヒ'],
        ['鑞', 'ロウヅケザイクノロウ'],
        ['鑛', 'テッコウセキノコウノキュウジ'],
        ['鑚', 'ケンサンヲツムノサンノイタイジ'],
        ['鑑', 'ズカン ノ カン'],
        ['鑓', 'ヤリ，カネヘン ニ ハケンスル ノ ケン'],
        ['鑒', 'ズカンノカンノイタイジ'],
        ['皿', 'サラウドン ノ サラ'],
        ['皺', 'シワヲノバスノシワ'],
        ['皸', 'クン，ショウグンノグンノミギニケガワノカワ'],
        ['皹', 'クン，ショウグンノグンノヒダリニケガワノカワ'],
        ['皷', 'ツヅミノイタイジ，ツクリガケガワノカワ'],
        ['皴', 'シュン，シュンビンサノシュンノツクリニケガワノカワ'],
        ['鑁', 'バンナジノバン'],
        ['皰', 'ニキビ，ホウ，ケガワノカワニツツム'],
        ['赤', 'アカンボウ ノ アカ，セキ'],
        ['赦', 'オンシャ ノ シャ，ユルス'],
        ['赧', 'カオヲアカラメルイミノタンガンノタン'],
        ['邉', 'シュウヘンノヘン，アタリノキュウジノイタイジ'],
        ['赭', 'シャ，アカイロノアカノミギニカガクシャノシャノキュウジタイ'],
        ['赫', 'アカヲ フタツ ナラベタ カク'],
        ['赴', 'フニンスル ノ フ，オモムク'],
        ['起', 'キリツスル ノ キ，オキル'],
        ['走', 'ハシル，キョウソウ ノ ソウ'],
        ['赱', 'ハシル，キョウソウノソウノイタイジ'],
        ['赳', 'キュウ、ソウニョウニサケブノツクリ'],
        ['i', 'アイ インク'],
        ['釼', 'ケン、カネヘンニヤイバ'],
        ['梳', 'ソ，クシケズル，キヘンニナガレルノツクリ'],
        ['梱', 'コンポウスル ノ コン'],
        ['械', 'キカイテキ ノ カイ'],
        ['梶', 'カジノキ ノ カジ，キヘン ニ オ'],
        ['梵', 'ボンジノボン'],
        ['梺', 'フモト，ハヤシノシタニウエシタノシタ'],
        ['梹', 'ショクブツノビンロウジュノビンノイタイジ，キヘンニヘイタイノヘイ'],
        ['梼', 'トウ，キヘン ニ コトブキ'],
        ['梢', 'マッショウシンケイ ノ ショウ，コズエ'],
        ['梠', 'リョ，キヘンニオフロノロ'],
        ['梧', 'ゴ，キヘン ニ ワレ，アオギリ'],
        ['梦', 'ユメ，ムチュウノムノイタイジ'],
        ['梨', 'クダモノ ノ ナシ'],
        ['梯', 'ハシゴ，キヘン ニ オトウト'],
        ['梭', 'サ，キヘンニシュンビンサノシュンノツクリ'],
        ['梓', 'アズサ，ジョウシスル ノ シ'],
        ['梗', 'ノウコウソク ノ コウ'],
        ['梔', 'ショクブツノクチナシ'],
        ['梛', 'ダ，キヘンニワカダンナノナ'],
        ['鋏', 'ドウグノハサミ'],
        ['梟', 'フクロウ'],
        ['條', 'ジョウケンノジョウノキュウジ'],
        ['梃', 'テコイレノテコ，テイ'],
        ['梁', 'リョウザンパク ノ リョウ，ハリ'],
        ['梅', 'ウメボシ ノ ウメ'],
        ['梏', 'シッコクトナルノコク，テカセ'],
        ['梍', 'ソウ，キヘンニシロクロノシロニカンスウジノナナ'],
        ['蒼', 'ガンメンソウハク ノ ソウ，アオイ'],
        ['蒿', 'コウ，クサカンムリニタカイヒクイノタカイ'],
        ['蒹', 'ケン，クサカンムリニカネル'],
        ['蒸', 'ジョウキ ノ ジョウ，ムス'],
        ['蒻', 'コンニャクノニャク'],
        ['鋲', 'ガビョウ ノ ビョウ'],
        ['蒲', 'カバヤキ ノ カバ'],
        ['蒭', 'スウ，クサカンムリニハンスウスルノスウ'],
        ['蒡', 'キンピラゴボウノボウ'],
        ['蒜', 'ショクブツ ノ ヒル'],
        [
            '蒟',
            'コンニャクノイチモジメ，クサカンムリニドクリツノリツ，ソノミギニハイクノク',
        ],
        ['蒙', 'ケイモウスル ノ モウ'],
        ['蒔', 'タネヲマク ノ マク'],
        ['蒐', 'クサカンムリ ニ オニ ノ シュウ'],
        ['蒋', 'クサカンムリ ニ ショウグン ノ ショウ'],
        ['蒄', 'カン、クサカンムリニゲッケイカンノカン'],
        ['蒂', 'タイ，クサカンムリニテイオウノテイ'],
        ['‰', 'パーミル'],
        ['″', 'ビョウ'],
        ['褞', 'オン、コロモヘンニオンセンノオンノキュウジノツクリ'],
        ['※', 'コメジルシ'],
        ['?', 'クエスチョン'],
        ['乾', 'カワク，カンソウキ ノ カン'],
        ['坑', 'タンコウ ノ コウ，アナ'],
        ['坐', 'ザセキ ノ ザカラマダレヲトッタザ，スワル'],
        ['鋤', 'ノウグ ノ スキ，カネヘン ニ タスケル'],
        ['乱', 'コンラン ノ ラン，ミダレル'],
        ['乳', 'ギュウニュウ ノ ニュウ，チチ'],
        ['均', 'ヘイキン ノ キン'],
        ['址', 'シ，シロアトヲイミスルジョウシノシ'],
        ['坂', 'サカミチ ノ サカ'],
        ['坏', 'タカツキノツキ'],
        ['坎', 'カン，アナ，ツチヘンニホケツノケツ'],
        ['乢', 'カイ，ヤマヘンニレイギノレイノツクリ'],
        ['坊', 'ボウズ ノ ボウ'],
        ['九', 'カンスウジ ノ キュウ'],
        ['乞', 'コウ，アマゴイスル ノ コウ'],
        ['也', 'クウヤネンブツ ノ ヤ，ナリ'],
        ['乘', 'ジョウシャスルノジョウ，ノルノキュウジ'],
        ['乙', 'コウオツ ノ オツ'],
        ['乕', 'ドウブツノトラノイタイジ'],
        ['坿', 'フ，ツチヘンニフロクノフ'],
        ['乗', 'ジョウシャスル ノ ジョウ，ノル'],
        ['坤', 'ケンコン ノ コン，ツチヘン ニ モウス'],
        ['乎', 'コ，ヨブ ノ ツクリ'],
        ['坦', 'ヘイタンナミチ ノ タン'],
        ['坡', 'ハ，ツチヘンニケガワノカワ'],
        ['鋭', 'エイリナ ノ エイ，スルドイ'],
        ['之', 'コレ，アクタガワリュウノスケ ノ ノ'],
        ['久', 'エイキュウ ノ キュウ，ヒサシイ'],
        ['坩', 'カン，ルツボ，ツチヘンニアマイ'],
        ['乂', 'ガイ，クサカリノカリノヒダリガワ'],
        ['坪', 'タテツボ ノ ツボ'],
        ['褌', 'フンドシ、コロモヘンニグンタイノグン'],
        ['硼', 'ゲンソノホウソノホウ'],
        ['硴', 'カキ，イシヘンニハナビノハナ'],
        ['硲', 'ハザマ，イシヘン ニ タニ'],
        ['硯', 'スズリ'],
        ['硬', 'ヒャクエンコウカ ノ コウ，カタイ'],
        ['硫', 'リュウサン ノ リュウ'],
        ['―', 'バー'],
        ['硝', 'ショウサンエン ノ ショウ'],
        ['硅', 'ゲンソノケイソノケイ，イシヘンニツチフタツ'],
        ['“', 'クォーテーション'],
        ['麁', 'ソ，アライ，カタカナノクノシタニシカ'],
        ['麒', 'キリンジノキ，シカノミギニソノ'],
        ['鴬', 'ウグイス'],
        ['鴪', 'イツ，アナヲホルノアナノミギニトリ'],
        ['鴫', 'シギヤキ ノ シギ'],
        ['鴨', 'トリ ノ カモ'],
        ['鴦', 'エンオウノオウ，オシドリ'],
        ['麗', 'カレイナ ノ レイ，ウルワシイ'],
        ['鴣', 'トリノシャコノコ，チュウコシャノコノミギニトリ'],
        ['鴾', 'ボウ，シャカムニノムノミギニトリ'],
        ['鴿', 'コウ，ゴウカクノゴウノミギニトリ'],
        ['鴻', 'コウコク ノ ココロザシ ノ コウ，オオトリ'],
        ['鴎', 'カモメ'],
        ['G', 'ジー ゴルフ'],
        ['鴈', 'ガン，ガンダレニニンベンニトリ'],
        ['鴉', 'キバニトリ，カラス'],
        ['鴆', 'チン，シズムノツクリノミギニトリ'],
        ['鴇', 'トリ ノ トキ'],
        ['鴃', 'トリヘンニカイテキノカイ，モズ'],
        ['麝', 'ジャコウジカノジャ，シカノシタニハンシャノシャ'],
        ['鴟', 'シ，テイコウスルノテイノツクリノミギニトリ'],
        ['鴛', 'エンオウ ノ エン，オシドリ'],
        ['鴕', 'ダ，トリヘンニブッダノダノツクリ'],
        ['鴒', 'セキレイノレイ'],
        ['柄', 'ヒトガラ ノ ガラ'],
        ['柆', 'ロウ，キヘンニドクリツノリツ'],
        ['柁', 'カジ，キヘン ニ ウカンムリ ニ カタカナ ノ ヒ'],
        ['柎', 'フ，キヘンニフロクノフ'],
        ['柏', 'カシワモチ ノ カシワ'],
        ['柊', 'ショクブツ ノ ヒイラギ，キヘン ニ フユ'],
        ['柔', 'ジュウドウ ノ ジュウ，ヤワラカイ'],
        ['某', 'ナニガシ ノ ボウ'],
        ['柑', 'カンキツルイ ノ カン'],
        ['染', 'センショク ノ セン，ソメル'],
        ['柝', 'タク，キヘンニハイセキウンドウノセキ'],
        ['柞', 'サク，キヘンニサクブンノサクノツクリ'],
        ['柘', 'ザクロ ノ イチモジメ，キヘン ニ イシ'],
        ['柚', 'ショクブツ ノ ユズ，ユウ'],
        ['麥', 'ムギノキュウジ'],
        ['柤', 'サ，キヘンニナオカツノカツ'],
        ['柧', 'コ，キヘンニウリ'],
        ['麦', 'ムギチャ ノ ムギ'],
        ['柢', 'テイ，キヘンニヒクイノツクリ'],
        ['柬', 'カン，イサメルノツクリ'],
        ['柮', 'トツ，キヘンニガイシュツスルノトツ'],
        ['柯', 'カ，キヘンニカノウセイノカ'],
        ['開', 'カイハツ ノ カイ，ヒラク'],
        ['柩', 'ヒツギ，レイキュウシャノキュウ'],
        ['柴', 'シバイヌ ノ シバ，タキギ ノ シバ'],
        ['柵', 'サクデカコム ノ サク'],
        ['柱', 'ハシラ，チュウ'],
        ['柳', 'ヤナギ，センリュウ ノ リュウ'],
        ['柾', 'ショクブツ ノ マサキ，キヘン ニ タダシイ'],
        ['柿', 'クダモノ ノ カキ'],
        ['麪', 'メンルイノメンノイタイジ'],
        ['査', 'ケンサ ノ サ'],
        ['焔', 'ホノオ，ヒヘン ノ ホノオ'],
        ['焙', 'バイセンスルノバイ，アブル'],
        ['焚', 'フンショコウジュ ノ フン，タキビ ノ タキ'],
        ['焜', 'コン，ヒヘンニコンチュウノコン'],
        ['麭', 'ホウ，ムギノキュウジニツツム'],
        ['焉', 'シュウエンノチノエン'],
        ['金', 'キンヨウビ ノ キン，カネ'],
        ['然', 'ダイシゼン ノ ゼン'],
        ['焼', 'ニクヲヤク ノ ヤク'],
        ['無', 'ムリ ノ ム，ナイ'],
        ['焦', 'ショウテンキョリ ノ ショウ'],
        ['闇', 'クラヤミ ノ ヤミ'],
        ['路', 'ドウロ ノ ロ'],
        ['釐', 'リ，ミライノミニノブンノシタニタンイノリン'],
        ['跪', 'ヒザマズク，キ'],
        ['跫', 'キョウ、キョウリュウノキョウノココロノカワリニテアシノアシ'],
        ['跨', 'コセンキョウ ノ コ，マタグ'],
        ['闍', 'アジャリノジャ'],
        ['闌', 'ラン，ハランバンジョウノランノツクリ'],
        ['跣', 'セン，アシヘンニイキサキノサキ'],
        ['跡', 'ツイセキスル ノ セキ，アト'],
        ['跿', 'ト，アシヘンニダッソウスルノソウ'],
        ['跼', 'キョク，アシヘンニヤッキョクノキョク'],
        ['闔', 'コウ，モンガマエニキョネンノキョニサラ'],
        ['V', 'ブイ ビデオ'],
        ['践', 'ジッセンスル ノ セン'],
        ['跳', 'チョウヤクスル ノ チョウ，トブ'],
        ['闘', 'トウギュウシ ノ トウ，タタカウ'],
        ['跏', 'カ、アシヘンニカソクドノカ'],
        ['跌', 'ジンセイノサテツノテツ'],
        ['跋', 'チョウリョウバッコノバツ'],
        ['闡', 'セン，モンガマエニタンジュンナノタンノキュウジ'],
        ['麼', 'モ，マスイノマノシタニイトガシラ'],
        ['跂', 'キ，アシヘンニササエル'],
        ['跟', 'コン，アシヘンニダイコンノコンノツクリ'],
        ['距', 'キョリ ノ キョ'],
        ['跚', 'スイホマンサンノサン、アシヘンニイッサツニサツノサツ'],
        ['跛', 'ハ，アシヘンニケガワノカワ'],
        ['跖', 'セキ、アシヘンニイシ'],
        ['麿', 'ウタマロ ノ マロ'],
        ['劭', 'ショウ，マネクノツクリニチカラ'],
        ['針', 'ホウシン ノ シン，ハリ'],
        ['帆', 'ハンセン ノ ハ，ホバシラ ノ ホ'],
        ['市', 'シヤクショ ノ シ，イチ'],
        ['布', 'ヌノ，モウフ ノ フ'],
        ['希', 'キボウ ノ キ，マレ'],
        ['帋', 'ガヨウシノシ，カミノイタイジ'],
        ['帖', 'テチョウ ノ チョウ，ハバニウラナウ'],
        ['帑', 'ド，ヤッコノシタニハバ'],
        ['帝', 'テイオウ ノ テイ，ミカド'],
        ['帚', 'ホウキ，ソウジキノソウノツクリ'],
        ['帛', 'ハク，ハクチョウノハクノシタニハバ'],
        ['帙', 'チツ，ハバヘンニウシナウ'],
        ['帥', 'ダイゲンスイ ノ スイ'],
        ['帯', 'ケイタイ ノ タイ，オビ'],
        ['席', 'ザセキ ノ セキ'],
        ['師', 'ボクシ ノ シ'],
        ['非', 'ヒジョウグチ ノ ヒ'],
        ['帶', 'ケイタイノタイ，オビノキュウジ'],
        ['帷', 'カタビラ，ハバヘンニフルトリ'],
        ['帳', 'レンラクチョウ ノ チョウ'],
        ['帰', 'キタクスル ノ キ，カエル'],
        ['帽', 'ダツボウスル ノ ボウ'],
        ['常', 'ヒジョウグチ ノ ジョウ'],
        [',', 'コンマ'],
        ['回', 'マワル，カイテン ノ カイ'],
        ['四', 'カンスウジ ノ ヨン'],
        ['囚', 'シュウジン ノ シュウ，トラワレル'],
        ['囘', 'マワル，カイテンノカイノイタイジ，ドウガマエニジュウニシノミ'],
        ['囗', 'イ，ブシュノクニガマエ'],
        ['囓', 'ゲツ，クチヘンニゲッシルイノゲツ'],
        ['囑', 'ショク，ショクタクスルノショクノキュウジ'],
        ['囎', 'ソ，クチヘンニカイガラノカイニキソジノソノキュウジ'],
        ['囈', 'ゲイ，クチヘンニゲイジュツノゲイノキュウジ'],
        ['囃', 'ゴニンバヤシノハヤシ'],
        ['囂', 'ケンケンゴウゴウノゴウ'],
        ['囁', 'ササヤク'],
        ['囀', 'サエズル，クチヘンニウンテンノテンノキュウジ'],
        ['囿', 'ユウ，クニガマエニユウメイジンノユウ'],
        ['国', 'コクゴ ノ コク，クニ'],
        ['固', 'コタイ ノ コ，カタイ'],
        ['囹', 'レイ，クニガマエニメイレイスルノレイ'],
        ['図', 'トショカン ノ ト，ズ'],
        ['囲', 'イゴ ノ イ，カコム'],
        ['困', 'コンナン ノ コン，コマル'],
        ['囮', 'オトリソウサノオトリ'],
        ['団', 'ダンタイコウドウ ノ ダン'],
        ['因', 'ゲンイン ノ イン，チナミニ'],
        ['偉', 'イダイ ノ イ，エライ'],
        ['ё', 'キリル ィヨー'],
        ['偏', 'ヘンセイフウ ノ ヘン，カタヨル'],
        ['с', 'キリル エス'],
        ['р', 'キリル エル'],
        ['у', 'キリル ウー'],
        ['т', 'キリル テー'],
        ['х', 'キリル ハー'],
        ['ф', 'キリル エフ'],
        ['ч', 'キリル チェー'],
        ['ц', 'キリル ツェー'],
        ['щ', 'キリル シシャー'],
        ['ш', 'キリル シャー'],
        ['ы', 'キリル ウィ'],
        ['ъ', 'キリル コウオンキゴウ'],
        ['э', 'キリル エー'],
        ['ь', 'キリル ナンオンキゴウ'],
        ['я', 'キリル ヤー'],
        ['ю', 'キリル ユー'],
        ['覚', 'カンカク ノ カク，オボエル'],
        ['蔆', 'ヒシガタノヒシノイタイジ'],
        ['蔀', 'シトミ，クサカンムリ ニ ブチョウ ノ ブ'],
        ['蔗', 'ショトウノショ，クサカンムリニショミンノショ'],
        ['蔕', 'タイ，クサカンムリニオビノキュウジ'],
        ['蔔', 'ホク，クサカンムリニホフクゼンシンノフク'],
        ['蔓', 'マンエンスル ノ マン，ツル'],
        ['蔑', 'ケイベツスル ノ ベツ，サゲスム'],
        ['偐', 'ガン，ニンベンニヒコボシノヒコノキュウジ'],
        ['蔟', 'ソク，クサカンムリニスイゾクカンノゾク'],
        ['蔚', 'クサカンムリ ニ リクグンタイイ ノ イ'],
        ['蔘', 'シン，クサカンムリニサンギインノサンノキュウジ'],
        ['蔦', 'ショクブツ ノ ツタ'],
        ['蔡', 'サイ，クサカンムリニシュクサイジツノサイ'],
        ['蔭', 'クサカンムリ ノ カゲ'],
        ['蔬', 'ソサイルイノソ'],
        ['蔵', 'レイゾウコ ノ ゾウ'],
        ['2', 'ニ'],
        ['蔽', 'シャヘイスル ノ ヘイ'],
        ['偖', 'シャ，ニンベンニカガクシャノシャノキュウジタイ'],
        ['偬', 'ソウ，ニンベンニネギノクサカンムリヲトッタモノ'],
        ['仆', 'ボク，ニンベンニウラナウノボク'],
        ['仇', 'アダ，キュウテキ ノ キュウ'],
        ['仄', 'ソクブンスルノソク，ホノカ'],
        ['仂', 'ロク，ニンベンニチカラ'],
        ['什', 'ジュウキ ノ ジュウ，ニンベン ニ カンスウジ ノ ジュウ'],
        ['栲', 'コウ，キヘンニサンコウショノコウ'],
        ['栽', 'サイバイスル ノ サイ'],
        ['仏', 'ブツゾウ ノ ブツ，ホトケ'],
        ['仍', 'ジョウ，ニンベンニノギタイショウノノ'],
        ['根', 'ダイコン ノ コン，ネ'],
        ['介', 'カイゴ ノ カイ，スケ'],
        ['他', 'タニン ノ タ'],
        ['仗', 'ギジョウヘイノジョウ'],
        ['仔', 'シサイナ ノ シ，ニンベン ニ コドモ ノ コ'],
        ['仕', 'シゴト ノ シ，ツカエル'],
        ['校', 'ガッコウ ノ コウ'],
        ['栢', 'カヤ，キヘン ニ ヒャク'],
        ['仞', 'フカサノタンイノジン，ニンベンニカタナニテン'],
        ['仟', 'セン，ニンベンニカンスウジノセン'],
        ['仝', 'ドウジョウ'],
        ['栩', 'ク，キヘンニウモウノウ'],
        ['付', 'フロク ノ フ，ツケル'],
        ['株', 'カブシキ ノ カブ'],
        ['令', 'メイレイ ノ レイ'],
        ['以', 'イジョウ，イカ ノ イ'],
        ['代', 'ダイヒョウ ノ ダイ，カワル'],
        ['栓', 'センヌキ ノ セン'],
        ['仮', 'カメン ノ カ，カリ'],
        ['栞', 'シオリヲハサムノシオリ'],
        ['件', 'ジョウケン ノ ケン'],
        ['栄', 'エイヨウ ノ エイ，サカエル'],
        ['仲', 'ナカマ ノ ナカ'],
        ['仰', 'ギョウテンスル ノ ギョウ，アオグ'],
        ['栂', 'ショクブツ ノ ツガ，キヘン ニ ハハ'],
        ['任', 'セキニン ノ ニン'],
        ['m', 'エム マイク'],
        ['側', 'リョウガワ ノ ガワ，ソク'],
        ['偶', 'グウゼン ノ グウ'],
        ['磁', 'ジシャク ノ ジ'],
        ['磅', 'オモサノタンイノポンド'],
        ['磆', 'カツ，イシヘンニホネ'],
        ['骸', 'ガイコツ ノ ガイ，ムクロ'],
        ['磋', 'セッサタクマノサ，イシヘンニサ'],
        ['磊', 'ゴウホウライラクノライ'],
        ['骼', 'カク，ホネヘンニゴウカクノカクノツクリ'],
        ['磑', 'ガイ，イシヘンニヨロイノツクリ'],
        ['磐', 'ジョウバンセン ノ バン'],
        ['磔', 'タッケイノタク，ハリツケ'],
        ['骨', 'ガイコツ ノ コツ，ホネ'],
        ['磚', 'セン，カワラ，イシヘンニセンモンノセンノキュウジ'],
        ['骭', 'カン，ホネヘンニアセノツクリ'],
        ['磧', 'セキ，カワラ，イシヘンニセキニンノセキ'],
        ['磨', 'ケンマスル ノ マ，ミガク'],
        ['磬', 'ケイ，コエノキュウジノミミノカワリニイシ'],
        ['磯', 'イソヅリ ノ イソ'],
        ['磴', 'トウ，イシヘンニトザンノト'],
        ['磽', 'コウ，イシヘンニギョウシュンノギョウノキュウジ'],
        ['李', 'リカニ カンムリヲ タダサズ ノ リ，スモモ'],
        ['杏', 'アンズ，キョウリン ノ キョウ'],
        ['杉', 'スギノキ ノ スギ'],
        ['杆', 'カン、キヘンニホス'],
        ['杁', 'イリ、キヘンニハイル'],
        ['杞', 'キユウニオワルノキ'],
        ['束', 'ヤクソク ノ ソク'],
        ['杜', 'モリ，キヘン ニ ツチ'],
        ['杙', 'ヨク、キヘンニダイヒョウノダイノツクリ'],
        ['杖', 'ハクジョウ ノ ジョウ，ツエ'],
        ['杓', 'シャクシジョウギ ノ シャク'],
        ['材', 'ザイリョウ ノ ザイ'],
        ['村', 'ムラ，シチョウソン ノ ソン'],
        ['杯', 'カンパイ ノ ハイ，サカズキ'],
        ['杭', 'クイヲウツ ノ クイ'],
        ['杪', 'ビョウ、コズエ、キヘンニスクナイ'],
        ['杤', 'トチギケンノトチノイタイジ、キヘンニマンネンヒツノマン'],
        ['来', 'ライネン ノ ライ，クル'],
        ['杢', 'モク，キ ノ シタニ コウ'],
        ['杣', 'ソマ、キヘンニヤマ'],
        ['杠', 'コウ、キヘンニズガコウサクノコウ'],
        ['条', 'ジョウケン ノ ジョウ'],
        ['松', 'マツノキ ノ マツ，ショウ'],
        ['板', 'コクバン ノ バン，イタ'],
        ['杼', 'ジョ、キヘンニヨテイノヨ'],
        ['杷', 'ショクブツ ノ ビワ ノ ハ，キヘン ニ トモエ'],
        ['杵', 'ウスキネ ノ キネ'],
        ['杲', 'コウ，アキラカ，ニチヨウビノニチノシタニジュモクノモク'],
        ['杳', 'ヨウトシテシレナイノヨウ，ヨウビノモクノシタニニチ'],
        ['杰', 'ゴウケツノケツノイタイジ，モクザイノモクノシタニレンガ'],
        ['東', 'トウザイ ノ トウ，ヒガシ'],
        ['貅', 'キュウ、ムジナヘンニヤスム'],
        ['C', 'シー キャット'],
        ['⑦', 'マルナナ'],
        ['⑧', 'マルハチ'],
        ['⑤', 'マルゴ'],
        ['⑥', 'マルロク'],
        ['③', 'マルサン'],
        ['④', 'マルヨン'],
        ['①', 'マルイチ'],
        ['②', 'マルニ'],
        ['⑮', 'マルジュウゴ'],
        ['⑯', 'マルジュウロク'],
        ['⑬', 'マルジュウサン'],
        ['⑭', 'マルジュウヨン'],
        ['⑪', 'マルジュウイチ'],
        ['⑫', 'マルジュウニ'],
        ['⑨', 'マルキュウ'],
        ['⑩', 'マルジュウ'],
        ['⑲', 'マルジュウキュウ'],
        ['⑳', 'マルニジュウ'],
        ['⑰', 'マルジュウナナ'],
        ['⑱', 'マルジュウハチ'],
        ['嶐', 'リュウ，ヤマノシタニリュウキスルノリュウニイッカククワエタカタチ'],
        ['嶬', 'ギ，ヤマヘンニギムノギ'],
        ['嶮', 'ケン，ヤマヘンニシケンヲウケルノケンノキュウジノツクリ'],
        ['嶢', 'ギョウ，ヤマヘンニギョウシュンノギョウノキュウジ'],
        ['嶺', 'サンレイ ノ レイ，ミネ'],
        ['嶼', 'ショ，ヤマヘンニアタエルノキュウジ'],
        ['嶽', 'サンガクブノガクノキュウジ'],
        ['嶷', 'ギ，ヤマノシタニギモンノギ'],
        ['黌', 'ショウヘイコウノコウ'],
        ['熙', 'キ，モトシュショウノホソカワモリヒロノヒロ'],
        ['熟', 'ジュクゴ ノ ジュク，ジュクスル'],
        ['熔', 'ヨウガン ノ ヨウ，ヒヘン ニ ナイヨウ ノ ヨウ'],
        ['熕', 'コウ，ヒヘンニシャカイコウケンノコウ'],
        ['熊', 'ドウブツ ノ クマ'],
        ['熈', 'コウキジテンノキノイタイジ'],
        ['熏', 'クンセイノクン，クスベル'],
        ['熄', 'ソク，ヒヘンニイキヲスルノイキ'],
        ['熹', 'キ，キゲキノキニレンガ'],
        ['熾', 'シレツナノシ'],
        ['熱', 'ネツ，アツイ'],
        ['熨', 'ノシ，リクグンタイイノイノシタニカヨウビノカ'],
        ['熬', 'ゴウ，ゴウマンナノゴウノツクリニレンガ'],
        ['鯵', 'アジ，サカナヘン ニ マイル'],
        ['詰', 'ツメル，キツモン ノ キツ'],
        ['話', 'ハナシ，デンワ ノ ワ'],
        ['該', 'ガイトウスル ノ ガイ'],
        ['詳', 'ショウサイ ノ ショウ，クワシイ'],
        ['詼', 'カイ，ゴンベンニハイイロノハイノキュウジタイ'],
        ['詠', 'エイタン ノ エイ，ヨム'],
        ['詢', 'ジュン，ゴンベンニゲジュンノジュン'],
        ['詣', 'モウデル，サンケイスル ノ ケイ'],
        ['鯱', 'サカナノシャチ'],
        ['試', 'シアイ ノ シ，ココロミル'],
        ['詩', 'シヲツクル ノ シ'],
        ['詫', 'オワビスル ノ ワビ'],
        ['詬', 'コウ，ゴンベンニコウゴウヘイカノゴウ'],
        ['詭', 'キベンヲロウスルノキ'],
        ['詮', 'センサクスル ノ セン'],
        ['詐', 'サギシ ノ サ'],
        ['詑', 'タ，ゴンベン ニ ウカンムリ ニ カタカナ ノ ヒ'],
        ['詒', 'タイ，ゴンベンニダイドコロノダイ'],
        ['詔', 'ショウチョク ノ ショウ，ミコトノリ'],
        ['評', 'ヒョウカスル ノ ヒョウ'],
        ['詛', 'ジュソノソ、ゴンベンニナオカツノカツ'],
        ['詞', 'サクシサッキョク ノ シ'],
        ['詁', 'クンコガクノコ、ゴンベンニチュウコシャノコ'],
        ['詆', 'テイ，ゴンベンニテイコウスルノテイノツクリ'],
        ['詈', 'バリゾウゴンノリ'],
        ['長', 'ナガイ，チョウタン ノ チョウ'],
        ['榿', 'キ，キヘンニヨロイノツクリ'],
        ['榾', 'コツ，キヘンニホネ'],
        ['榻', 'トウ，キヘンニヨウビノニチノシタニハネ'],
        ['榴', 'リュウ，ザクロ，キヘンニリュウガクスルノリュウ'],
        ['榲', 'オツ，キヘンニオンセンノオンノキュウジタイノツクリ'],
        ['榱', 'スイ，キヘンニオトロエル'],
        ['榮', 'エイヨウノエイ，サカエルノキュウジ'],
        ['榧', 'カヤノキノカヤ'],
        ['榠', 'メイ，キヘンニメイフクヲイノルノメイ'],
        ['榜', 'ヒョウボウスルノボウ'],
        ['榛', 'ショクブツ ノ ハシバミ'],
        ['榕', 'ヨウ，キヘンニヨウセキノヨウ'],
        ['榔', 'ショクブツ ノ ビンロウジュ ノ ロウ'],
        ['榑', 'フ，キヘンニハクブツカンノハクノキュウジノツクリ'],
        ['榎', 'エノキ，キヘン ニ ナツ'],
        ['榊', 'ショクブツ ノ サカキ，キヘン ニ カミサマ ノ カミ'],
        ['概', 'ガイネン ノ ガイ，オオムネ'],
        ['榁', 'ムロノキノムロ，キヘンニムロマチノムロ'],
        ['鯛', 'サカナ ノ タイ'],
        ['Z', 'ゼット ズー'],
        ['ﾚ', 'レモン ノ レ'],
        ['ﾛ', 'ロウカ ノ ロ'],
        ['鯒', 'サカナノコチ，ウオヘンニオケノツクリ'],
        ['鯑', 'カズノコ，ウオヘンニマレ'],
        ['鷙', 'シ，シツジノシツノシタニトリ'],
        ['噤', 'キン，ツグム，クチヘンニキンシスルノキン'],
        ['器', 'ガッキ ノ キ，ウツワ'],
        ['噫', 'アア，クチヘンニイミノイ'],
        ['噪', 'ソウ，クチヘンニソウジュウスルノソウノツクリ'],
        ['噬', 'ホゾヲカムノカム，クチヘンニゼイチクノゼイ'],
        ['噴', 'フンカスル ノ フン，フク'],
        ['噸', 'オモサ ノ タンイ ノ トン'],
        ['噺', 'ハナシカ ノ ハナシ，クチヘン ニ アタラシイ'],
        ['噂', 'ウワサバナシ ノ ウワサ'],
        ['噌', 'ミソ ノ ソ'],
        ['噎', 'エツ，ムセブ，クチヘンニケイヤクショニツカウイチノキュウジ'],
        ['噐', 'ウツワ，ガッキノキノイタイジ'],
        ['噛', 'カム，クチヘン ニ ハ'],
        ['0', 'ゼロ'],
        ['ﾓ', 'モミジ ノ モ'],
        ['薈', 'ワイ，クサカンムリニカイシャインノカイノキュウジ'],
        ['薊', 'ショクブツノアザミ'],
        ['薀', 'ウンチクヲカタムケルノウン，サンズイ'],
        ['薄', 'ウスイ，ケイハク ノ ハク'],
        ['薇', 'ビ，バライロノバラノニモジメ'],
        ['薙', 'クサナギ ノ ナギ'],
        ['薛', 'カワラヨモギヲイミスルセツ'],
        ['薜', 'ヘイ，クサカンムリニカベノウエガワ'],
        ['薑', 'キョウ，クサカンムリニカシハラジングウノカシノツクリ'],
        ['薐', 'リョウ，クサカンムリニヤマノリョウセンノリョウ'],
        ['薔', 'ショウ，バライロノバラノイチモジメ'],
        ['薗', 'ソノ，クサカンムリ ニ ガクエン ノ エン'],
        ['薩', 'サツマハン ノ サツ'],
        ['薨', 'コウキョスルノコウ，ミマカル'],
        ['薫', 'クンプウ ノ クン，カオル'],
        ['薪', 'タキギ，マキワリ ノ マキ'],
        ['薬', 'ヤクヒン ノ ヤク，クスリ'],
        ['薯', 'バレイショ ノ ショ，イモ'],
        ['薮', 'ヤブ，クサカンムリ ニ サンスウ ノ スウ'],
        ['薤', 'ラッキョウ'],
        ['薦', 'スイセンジョウ ノ セン，ススメル'],
        ['薹', 'ダイ，トウガタツノトウ'],
        ['薺', 'ナナクサノナズナ，セイ'],
        ['霽', 'セイ、アメカンムリニイッセイシャゲキノセイノキュウジ？'],
        ['霹', 'セイテンノヘキレキノヘキ'],
        ['霧', 'ノウム ノ ム，キリ'],
        ['癧', 'ルイレキノレキ，ヤマイダレニレキシカノレキノキュウジ'],
        ['霓', 'ゲイ、アメカンムリニジドウセイトノジノキュウジ'],
        ['筋', 'キンニク ノ キン，スジ'],
        ['等', 'イットウショウ ノ トウ，ヒトシイ'],
        ['筈', 'テハズ ノ ハズ'],
        ['筏', 'イカダ'],
        ['筍', 'タケノコ，ジュン'],
        ['筌', 'チャセンノセン，タケカンムリニゼンコクノゼン'],
        ['騰', 'フットウスル ノ トウ'],
        ['筆', 'フデバコ ノ フデ，ヒツ'],
        ['筅', 'チャセンノセン，タケカンムリニイキサキノサキ'],
        ['騫', 'ケン，サムイノシタニテンノカワリニウマ'],
        ['騨', 'ヒダタカヤマ ノ ダ'],
        ['筝', 'ソウキョクノソウ，コトノイタイジ'],
        ['筒', 'ツツ，スイトウ ノ トウ'],
        ['筑', 'チクゼンニ ノ チク'],
        ['筐', 'キョウタイノキョウ，ハコ'],
        ['策', 'サクリャク ノ サク'],
        ['答', 'コタエ，トウアン ノ トウ'],
        ['騙', 'ダマス'],
        ['筮', 'ゼイチクノゼイ'],
        ['筬', 'セイ，オサ，タケカンムリニセイリツスルノセイ'],
        ['騒', 'サワグ，ソウオン ノ ソウ'],
        ['験', 'ニュウガクシケン ノ ケン'],
        ['筧', 'カケヒ，タケカンムリニケンブツスルノケン'],
        ['筥', 'ロ，タケカンムリニオフロノロ'],
        ['筺', 'キョウタイノキョウ，ハコノイタイジ'],
        ['騎', 'キヘイタイ ノ キ'],
        ['騏', 'キリンノキ，ウマヘンニソノ'],
        ['筱', 'ジョウ，シノダケノシノノイタイジ'],
        ['筰', 'サク，タケカンムリニサクブンノサク'],
        ['筵', 'エン，ムシロ，タケカンムリニエンキスルノエン'],
        ['筴', 'キョウ，タケカンムリニセマイノキュウジノツクリ'],
        ['惑', 'メイワク ノ ワク'],
        ['惓', 'ケン，リッシンベンニノリマキノマキ'],
        ['惘', 'ボウ，リッシンベンニモウマクノモウノツクリ'],
        ['惚', 'ホレル，コウコツ ノ コツ'],
        ['惜', 'オシム，セキハイ ノ セキ'],
        ['惟', 'シイ ノ イ，リッシンベン ニ フルトリ'],
        ['情', 'ユウジョウ ノ ジョウ，ナサケ'],
        ['惆', 'チュウ，リッシンベンニシュウヘンノシュウ'],
        ['惇', 'リッシンベン ニ キョウラクテキ ノ キョウ，トン'],
        ['惰', 'タイダ ノ ダ'],
        ['惱', 'ナヤム，クノウスルノノウノキュウジ'],
        ['想', 'カンソウブン ノ ソウ'],
        ['惴', 'ズイ，リッシンベンニゼンソクノゼンノツクリ'],
        ['惶', 'コウ，リッシンベンニコウタイシノコウ'],
        ['惷', 'シュン，キセツノハルノシタニココロ'],
        ['惹', 'ジャッキスル ノ ジャク，ヒク'],
        ['惺', 'セイ，リッシンベンニホシ'],
        ['惻', 'ソクインノジョウノソク，リッシンベンニホウソクノソク'],
        ['q', 'キュー クエスチョン'],
        ['惡', 'ゼンアクノアク，ワルイノキュウジ'],
        ['惣', 'オソウザイ ノ ソウ'],
        ['惧', 'キグスルノグ'],
        ['惨', 'ザンパイスル ノ ザン，ミジメ'],
        ['霖', 'リンウノリン、アメエカンムリニサンリンノリン'],
        ['瀝', 'ヒレキスルノレキ'],
        ['瀞', 'ナガトロ ノ トロ，サンズイ ニ シズカ'],
        ['瀟', 'ショウシャナタテモノノショウ'],
        ['瀘', 'ロ，サンズイニハゼノキノハゼノツクリ'],
        ['瀚', 'コウカンナゾウショノカン'],
        ['瀛', 'ウミヲイミスルサンズイノエイ'],
        ['瀕', 'ヒンシ ノ ジュウショウ ノ ヒン'],
        ['瀑', 'ナイアガラバクフノバク'],
        ['瀏', 'リュウ，サンズイニリュウホウノリュウ'],
        ['瀉', 'イッシャセンリノシャ，サンズイニシャシンノシャノキュウジ'],
        ['瀋', 'チュウゴクノシンヨウノシン，サンズイニシンサスルノシン'],
        ['瀁', 'ヨウ，サンズイニヤシナウ'],
        ['瀾', 'ハランバンジョウノラン'],
        ['瀰', 'ビ，サンズイニアミダブツノミノキュウジ'],
        ['瀲', 'レン，サンズイニイッテンニシュウレンスルノレン'],
        ['瀬', 'セトモノ ノ セ'],
        ['瀦', 'ミズタマリヲ イミスル チョ'],
        ['瀧', 'タキ ノ キュウジ'],
        ['諺', 'コトワザ，ゲン'],
        ['鋒', 'キュウセンポウ ノ ホウ，ホコサキ'],
        ['諸', 'ショクン ノ ショ'],
        ['諾', 'ショウダクスル ノ ダク'],
        ['諳', 'ソランズル，アン'],
        ['諱', 'イミナ，ゴンベンニイダイナノイノツクリ'],
        ['諷', 'フウシノフウ，ゴンベンニカゼ'],
        ['諫', 'イサメル，カン'],
        ['諮', 'シモンスル ノ シ，ハカル'],
        ['諭', 'キョウユ ノ ユ，サトス'],
        ['諢', 'コン，ゴンベンニグンタイノグン'],
        ['諠', 'ケン，ゴンベンニセンデンスルノセン'],
        ['諡', 'オクリナ，シゴウノシ'],
        ['諦', 'アキラメル，テイカンスル ノ テイ'],
        ['諧', 'カイギャクノカイ'],
        ['諤', 'カンカンガクガクノガク'],
        ['諚', 'ジョウ，ゴンベンニサダメル'],
        ['諛', 'ユ，ゴンベンニシュユノマノユ'],
        ['諞', 'ヘン，ゴンベンニヘンペイソクノヘン'],
        ['諜', 'チョウホウキカン ノ チョウ'],
        ['諒', 'リョウカイスル ノ リョウ，ゴンベン ニ キョウト ノ キョウ'],
        ['鋺', 'カナマリ、カネヘンニウデノツクリ'],
        ['鋸', 'ノコギリ，キョ'],
        ['論', 'ケツロン ノ ロン'],
        ['鋼', 'コウテツ ノ コウ，ハガネ'],
        ['請', 'セイキュウショ ノ セイ，コウ'],
        ['諏', 'スワコ ノ ス'],
        ['諌', 'イサメル，カンゲンスル ノ カン'],
        ['諍', 'イサカイ，ソウ'],
        ['諂', 'ヘツラウ，テン'],
        ['倚', 'イ，ニンベンニキミョウナノキ'],
        ['鋩', 'ボウ、カネヘンニクサカンムリニボウメイスルノボウ'],
        ['談', 'ジョウダンヲイウ ノ ダン'],
        ['諄', 'ジュン，ゴンベンニキョウラクテキノキョウ'],
        ['倖', 'ギョウコウ ノ コウ，ニンベン ニ サチ'],
        ['適', 'テキトウ ノ テキ'],
        ['倔', 'クツ，ニンベンニリクツノクツ'],
        ['ﾆ', 'ニホン ノ ニ'],
        ['遥', 'ヨウハイスル ノ ヨウ，ハルカ'],
        ['崑', 'コンロンサンミャクノコン，ヤマノシタニコンチュウノコン'],
        ['崖', 'ガケ，ダンガイ ノ ガイ'],
        ['崗', 'カコウガンノコウ，オカヤマケンノオカノイタイジ'],
        ['崔', 'サイ，ヤマノシタニフルトリ'],
        ['崕', 'ガケ，ダンガイノガイノイタイジ'],
        ['崚', 'リョウ，ヤマヘンニリョウセンノリョウノツクリ'],
        ['崛', 'クツ，ヤマヘンニリクツノクツ'],
        ['崘', 'コンロンサンミャクノロンノイタイジ'],
        ['崙', 'コンロンサンミャクノロン'],
        ['崟', 'ギン，ヤマノシタニキンヨウビノキン'],
        ['倭', 'ギシワジンデン ノ ワ'],
        ['崇', 'スウハイスル ノ スウ，アガメル'],
        ['崋', 'ワタナベカザンノカ'],
        ['崎', 'ナガサキ ノ サキ'],
        ['遽', 'キュウキョキタクスルノキョ'],
        ['崢', 'ソウ，ヤマヘンニアラソウノキュウジ'],
        ['倦', 'ケンタイカン ノ ケン，ウム'],
        ['崩', 'ホウカイスル ノ ホウ，クズレル'],
        ['選', 'センキョ ノ セン，エラブ'],
        ['ﾅ', 'ナマエ ノ ナ'],
        ['遺', 'イデン ノ イ'],
        ['侘', 'タ，ワビシイノワビ，ニンベンニジュウタクノタク'],
        ['遷', 'サセンスル ノ セン'],
        ['遲', 'チコクスルノチ，オソイノキュウジ'],
        ['遍', 'フヘンテキナ ノ ヘン'],
        ['嗣', 'ヨツギ ノ ツギ，セイシ ノ シ'],
        ['遏', 'アツ，シンニョウニカッショクノカツノツクリ'],
        ['嗤', 'シ，ワラウ，アザワラウ'],
        ['倶', 'クラブ ノ ク'],
        ['嗹', 'レン，クチヘンニレンラクノレン'],
        ['嗾', 'ソウ，ソソノカス，クチヘンニスイゾクカンノゾク'],
        ['嗽', 'ソウ，クチススグ，クチヘンニナツメソウセキノソウノツクリ'],
        ['嗷', 'ゴウ，クチヘンニゴウマンノゴウノツクリ'],
        ['嗇', 'リンショクカノショク'],
        ['嗅', 'キュウカクノキュウ，カグ'],
        ['嗄', 'コエガカレルノカレル，クチヘンニナツ'],
        ['嗚', 'オエツノオ，クチヘンニカラス'],
        ['嗟', 'トッサノサ，クチヘンニサベツカスルノサ'],
        ['嗜', 'シコウヒンノシ，タシナム'],
        ['遇', 'ユウグウスル ノ グウ'],
        ['嗔', 'シン，イカル，クチヘンニマゴコロノマノキュウジ'],
        ['遙', 'ヨウハイスルノヨウ，ハルカノキュウジ'],
        ['霙', 'ミゾレ、アメカンムリニエイユウノエイ'],
        ['違', 'イハン ノ イ，チガウ'],
        ['達', 'ハイタツ ノ タツ'],
        ['震', 'ジシン ノ シン，フルエル'],
        ['舒', 'ジョ，シュクシャノシャノキュウジノミギニヨテイノヨ'],
        ['舐', 'ナメル，シタヘンニウジガミノウジ'],
        ['舗', 'ホソウスル ノ ホ'],
        ['舖', 'ホソウドウロノホノキュウジ'],
        ['舛', 'ソムクヲ イミスル セン，マス'],
        ['舘', 'ヤカタ ノ イタイジ，カン'],
        ['舟', 'ゴエツドウシュウ ノ シュウ，フネ'],
        ['舞', 'カブキ ノ ブ，マウ'],
        ['舜', 'ギョウシュン ノ シュン'],
        ['舂', 'ウスヅク，ショウ'],
        ['舁', 'カゴヲカクノカク'],
        ['與', 'アタエル，キュウヨノヨノキュウジ'],
        ['舅', 'シュウト'],
        ['舊', 'キュウレキノキュウノキュウジ'],
        ['舉', 'センキョノキョ，アゲルノキュウジノイタイジ'],
        ['興', 'キョウミ ノ キョウ'],
        ['舎', 'ガッコウ ノ コウシャ ノ シャ'],
        ['舍', 'ガッコウノコウシャノシャノキュウジ'],
        ['舌', 'シタヲカム ノ シタ'],
        ['舳', 'フネノヘサキ，フネヘンニリユウノユウ'],
        ['舷', 'ウゲンサゲン ノ ゲン，フナバタ'],
        ['舶', 'ハクライヒン ノ ハク'],
        ['舵', 'カジ，ソウダシュ ノ ダ'],
        ['船', 'フネ，センチョウ ノ セン'],
        ['舸', 'カ，フネヘンニカノウセイノカ'],
        ['舫', 'モヤイムスビノモヤイ'],
        ['航', 'コウクウキ ノ コウ'],
        ['舩', 'フネ，フネヘンニオオヤケ'],
        ['舮', 'フネノトモ，フネヘンニトジマリノト'],
        ['般', 'イッパンテキ ノ ハン'],
        ['椁', 'カク，キヘンニキョウラクテキナノキョウ'],
        ['椀', 'キヘン ノ シルワン ノ ワン'],
        ['椅', 'イス ノ イ'],
        ['椄', 'ショウ，キヘンニメカケ'],
        ['椈', 'キク，キヘンニキクノハナノキクノクサカンムリナシ'],
        ['椋', 'ムクドリ ノ ムク，キヘン ニ キョウト ノ キョウ'],
        ['植', 'ショクブツ ノ ショク，ウエル'],
        ['椌', 'コウ，キヘンニクウキノクウ'],
        ['椏', 'ア，キヘンニアネッタイノアノキュウジ'],
        ['椎', 'セキツイ ノ ツイ，シイ'],
        ['椒', 'サンショウウオノショウ'],
        ['椙', 'スギ，キヘン ニ ニチガ フタツ'],
        ['椛', 'カバ，キヘン ニ ハナ'],
        ['椚', 'ショクブツノクヌギ，キヘンニセンモンノモン'],
        ['検', 'ケンサ ノ ケン'],
        ['椡', 'ショクブツノクヌギ，キヘンニトウチャクノトウ'],
        ['椣', 'ショクブツノシデ，キヘンニコクゴジテンノテン'],
        ['椢', 'カイ，キヘンニコクゴノコク'],
        ['椥', 'チ，キヘンニチシキノチ'],
        ['椦', 'ケン，キヘンニジョウシャケンノケンノカタナノカワリニチカラ'],
        ['椨', 'タブノキ，キヘンニトドウフケンノフ'],
        ['椪', 'ショクブツノポンカンノポン，キヘンニナラブ'],
        ['椰', 'ヤシノキノヤ'],
        ['椴', 'トドマツ ノ トド，キヘン ニ シュダン ノ ダン'],
        ['椶', 'シュロノキノシュノイタイジ'],
        ['椹', 'チン，キヘンニハナハダシイ'],
        ['椽', 'テン，キヘンニエンガワノエンノキュウジタイノツクリ'],
        ['椿', 'ショクブツ ノ ツバキ，キヘン ニ ハル'],
        ['篌', 'コウ，タケカンムリニオウコウキゾクノコウ'],
        ['篏', 'ハメキザイクノハメル，カンノイタイジ'],
        ['築', 'ケンチク ノ チク，キズク'],
        ['鮹', 'タコ，ウオヘンニショウゾウガノショウ'],
        ['篋', 'キョウ，タケカンムリニハコガマエノナカニセマイノキュウジノツクリ'],
        ['鮴', 'サカナノゴリ，ウオヘンニヤスム'],
        ['範', 'モハン ノ ハン'],
        ['篇', 'タケカンムリ ノ ヘンシュウスル ノ ヘン'],
        ['篆', 'テンコクノテン'],
        ['篁', 'コウ，タカムラ，タケカンムリニコウタイシノコウ'],
        ['節', 'キセツ ノ セツ，フシ'],
        ['篝', 'コウ，カガリビノカガリ'],
        ['鮭', 'サケ，サカナヘン ニ ツチ フタツ'],
        ['鮮', 'シンセンナ ノ セン，アザヤカ'],
        ['鮨', 'スシ，ウオヘンニウマイ'],
        ['鮪', 'マグロ，サカナヘン ニ アル'],
        ['鮫', 'サメ，サカナヘン ニ マジワル'],
        ['鮠', 'サカナノハヤ，ウオヘンニアブナイ'],
        ['篭', 'カゴ ノ イタイジ，タケカンムリ ニ キョウリュウ ノ リュウ'],
        ['鮟', 'サカナノアンコウノアン，ウオヘンニヤスイ'],
        ['篩', 'フルイニカケルノフルイ'],
        ['鰤', 'サカナノブリ'],
        ['霍', 'カク，アメカンムリニフルトリ'],
        ['篥', 'ヒチリキノリキ，タケカンムリニクリノキノクリ'],
        ['篤', 'キトクジョウタイ ノ トク'],
        ['鮖', 'カジカ，ウオヘンニイシ'],
        ['篦', 'ヘラ'],
        ['篠', 'シノダケ ノ シノ'],
        ['鮒', 'フナ，サカナヘン ニ ツケル'],
        ['鮓', 'スシ，ウオヘンニサクブンノサクノツクリ'],
        ['鮎', 'アユ，サカナヘン ニ ウラナウ'],
        ['篷', 'ホウ，トマ，タケカンムリニダンジョノアイビキノアイ'],
        ['篶', 'エン，タケカンムリニシュウエンノチノエン'],
        ['篳', 'ヒチリキノヒチ，タケカンムリニヒッキョウノヒツ'],
        ['鮃', 'ヒラメ，ウオヘンニタイラ'],
        ['恚', 'イ，ツチフタツノシタニココロ'],
        ['恙', 'ヨウ，ツツガナククラスノツツガ'],
        ['恟', 'キョウ，リッシンベンニカラダノムネノツクリ'],
        ['恒', 'コウオンドウブツ ノ コウ，ツネニ'],
        ['鰮', 'オン，ウオヘンニトラワレビトノシュウノシタニサラ'],
        ['恐', 'キョウフ ノ キョウ，オソロシイ'],
        ['恕', 'カンジョ ノ ジョ，ユルス'],
        ['恊', 'キョウリョクスルノキョウノイタイジ'],
        ['恋', 'コイビト ノ コイ，レン'],
        ['恍', 'コウコツノヒトノコウ'],
        ['恂', 'ジュン，リッシンベンニゲジュンノジュン'],
        ['恃', 'キョウジヲタモツノジ'],
        ['恁', 'ジン，セキニンノニンノシタニココロ'],
        ['恆', 'コウオンドウブツノコウ，ツネニノキュウジ'],
        ['^', 'ベキジョウ'],
        ['恰', 'カップクガヨイ ノ カツ，アタカモ'],
        ['恷', 'キュウ，キュウジツノキュウノシタニココロ'],
        ['恵', 'メグム，チエ ノ エ'],
        ['恪', 'カク，リッシンベンニカクジノカク'],
        ['恫', 'ドウカツスルノドウ'],
        ['恨', 'ウラミ，ツウコン ノ コン'],
        ['恩', 'オンガエシ ノ オン'],
        ['息', 'イキヲスル ノ イキ，ソク'],
        ['恬', 'ムヨクテンタンノテン'],
        ['恭', 'キョウジュン ノ キョウ，ウヤウヤシイ'],
        ['恢', 'テンモウカイカイ ノ カイ'],
        ['恣', 'シイテキナノシ，ホシイママ'],
        ['恠', 'カイブツノカイノイタイジ，リッシンベンニソンザイノザイ'],
        ['恤', 'ジュツ，リッシンベンニケツエキノケツ'],
        ['恥', 'ハジヲカク ノ ハジ'],
        ['鰺', 'サカナノアジノイタイジ，カタカナノムガミッツ'],
        ['寃', 'エンザイヲハラスノエンノイタイジ'],
        ['寂', 'セイジャク ノ ジャク，サビシイ'],
        ['寇', 'モウコシュウライノゲンコウノコウ'],
        ['密', 'ヒミツ ノ ミツ'],
        ['寅', 'トラ，ジュウニシ ノ トラ'],
        ['寄', 'キフスル ノ キ，ヨル'],
        ['寉', 'トリノツルノイタイジ，ウカンムリニフルトリ'],
        ['富', 'ホウフ ノ フ，トム'],
        ['寓', 'グウワ ノ グウ'],
        ['寒', 'アツイサムイ ノ サムイ，カン'],
        ['寐', 'ムビノビ，ネムル'],
        ['寔', 'ショク，ウカンムリニゼヒノゼ'],
        ['寛', 'カンダイナ ノ カン，ヒロイ'],
        ['鰆', 'サワラ，ウオヘンニハル'],
        ['察', 'ケイサツ ノ サツ'],
        ['寞', 'セキバクノバク'],
        ['寝', 'シンシツ ノ シン，ネル'],
        ['寢', 'シンシツノシン，ネルノキュウジ'],
        ['寡', 'カモクナ ノ カ，スクナイ'],
        ['寧', 'テイネイ ノ ネイ'],
        ['實', 'ジツリョクノジツ，ミノキュウジ'],
        ['寥', 'セキリョウカンノリョウ'],
        ['寤', 'サメルヲイミスルゴ'],
        ['寫', 'シャシンノシャ，ウツスノキュウジ'],
        ['審', 'シンサスル ノ シン'],
        ['寨', 'サイ，サムイノシタニテンノカワリニモクザイノモク'],
        ['寮', 'ガクセイリョウ ノ リョウ'],
        ['寳', 'ホウセキノホウ，タカラノキュウジノイタイジ'],
        ['寰', 'カン，ウカンムリニシゼンカンキョウノカンノツクリ'],
        ['寶', 'ホウセキノホウ，タカラノキュウジ'],
        ['寵', 'チョウアイヲウケル ノ チョウ'],
        ['寺', 'テラ，ジイン ノ ジ'],
        ['寸', 'スンポウ ノ スン'],
        ['寿', 'コトブキ，ジュミョウ ノ ジュ'],
        ['対', 'ハンタイ ノ タイ'],
        ['鰌', 'ドジョウ，ウオヘンニシュウチョウサンノシュウ'],
        ['鰓', 'エラ，ウオヘンニオモウ'],
        ['4', 'ヨン'],
        ['岔', 'タ，ハンブンノブンノシタニヤマ'],
        ['岐', 'ブンキテン ノ キ'],
        ['岑', 'シン，ヤマノシタニコンゲツノコン'],
        ['鰛', 'オン，ウオヘンニオンセンノオンノツクリ'],
        ['岌', 'キュウ，ヤマノシタニフキュウスルノキュウ'],
        ['岶', 'ハク，ヤマヘンニシロイ'],
        ['岷', 'ビン，ヤマヘンニコクミンノミン'],
        ['岱', 'ダイヒョウ ノ ダイ ノ シタニ ヤマ，タイ'],
        ['岳', 'サンガク ノ ガク，タケ'],
        ['岼', 'ユリ，ヤマヘンニタイラ'],
        ['岾', 'ハケ，ヤマヘンニドクセンスルノセン'],
        ['岸', 'カイガン ノ ガン，キシ'],
        ['岻', 'チ，ヤマヘンニヒクイノツクリ'],
        ['岡', 'オカヤマケン ノ オカ'],
        ['岬', 'エリモミサキ ノ ミサキ'],
        ['岨', 'ケンソ ノ ソ，ヤマヘン ニ カツ'],
        ['岩', 'イワ，ガンセキ'],
        ['岫', 'シュウ，イワアナ，ヤマヘンニリユウノユウ'],
        ['鹵', 'ロカクノロ，シオ'],
        ['鹸', 'コナセッケン ノ ケン'],
        ['鮗', 'コノシロ，ウオヘンニフユ'],
        ['鮑', 'アワビ，ウオヘンニツツム'],
        ['饐', 'イ，スエル'],
        ['饕', 'トウ，ムサボル'],
        ['鳶', 'トリ ノ トビ'],
        ['Ｔ', 'ティー タイム'],
        ['饉', 'キキンニミマワレルノキン'],
        ['饋', 'キ，オクル，ショクヘンニキチョウヒンノキ'],
        ['饌', 'セン，ソナエル，ショクヘンニエラブノツクリ'],
        ['炮', 'ホウ，ヒヘンニツツム'],
        ['炯', 'ケイガンノシノケイ，ヒヘンニドウガマエニクチ'],
        ['炬', 'キョ，カガリビ，ヒヘンニキョダイナノキョ'],
        ['炭', 'セキタン ノ タン，スミ'],
        ['炳', 'ヘイ，ヒヘンニコウオツヘイノヘイ'],
        ['為', 'コウイ ノ イ，タメ'],
        ['炸', 'バクダンガサクレツスルノサク'],
        ['点', 'テンスウ ノ テン'],
        ['饂', 'ドン，ウドンノイチモジメ'],
        ['炎', 'エンジョウスル ノ エン，ホノオ'],
        ['饅', 'マンジュウノマン'],
        ['炊', 'スイハンキ ノ スイ，タク'],
        ['炉', 'ダンロ ノ ロ'],
        ['炒', 'イタメル，チャーハンノイチモジメ'],
        ['炙', 'ジンコウニカイシャスルノシャ，アブル'],
        ['譽', 'メイヨノヨ、ホマレノキュウジ'],
        ['鉗', 'カンシブンベンノカン'],
        ['鉐', 'セキ、カネヘンニイシ'],
        ['譴', 'ケンセキショブンノケン、セメル'],
        ['護', 'ホゴシャ ノ ゴ'],
        ['議', 'カイギシツ ノ ギ'],
        ['譱', 'ゼンアクノゼン，ヨイノイタイジ'],
        ['譲', 'ジョウホスル ノ ジョウ，ユズル'],
        ['鉚', 'リュウ、カネヘンニジュウニシノウ'],
        ['譬', 'タトエバナシノタトエ、ヒ'],
        ['鉄', 'テツドウ ノ テツ'],
        ['譯', 'ツウヤクスルノヤク、ワケノキュウジ'],
        ['譫', 'センモウジョウタイノセン'],
        ['警', 'ケイサツ ノ ケイ'],
        ['鉉', 'ゲン、カネヘンニゲンマイノゲン'],
        ['鉈', 'ナタ'],
        ['鉋', 'ダイクドウグノカンナ'],
        ['譜', 'フメン ノ フ'],
        ['譟', 'ソウ、ゴンベンニソウジュウスルノソウノツクリ'],
        ['識', 'チシキ ノ シキ'],
        ['譚', 'タン，ゴンベンニニシノシタニハヤオキノハヤイ'],
        ['譛', 'シン，ゴンベンニフリカエノカエ'],
        ['譖', 'シン，ゴンベンニセンエツナガラノセンノツクリ'],
        ['鉾', 'カマボコ ノ ホコ'],
        ['譌', 'オクニナマリノナマリノイタイジ'],
        ['鉤', 'コウ、カギ、カネヘンニハイクノク'],
        ['譎', 'ケツ、ゴンベンニタチバナノツクリ'],
        ['譏', 'キ、ゴンベンニキカガクノキ'],
        ['u', 'ユー ユージュアリー'],
        ['證', 'ショウ、ショウメイショノショウノキュウジ'],
        ['鉢', 'ハチウエ ノ ハチ'],
        ['譁', 'カ、ゴンベンニチュウカナベノカ'],
        ['z', 'ゼット ズー'],
        ['檎', 'リンゴ ノ ゴ'],
        ['檍', 'ヨク，キヘンニイミガナイノイ'],
        ['檀', 'ダンカ ノ ダン'],
        ['檄', 'ゲキヲトバスノゲキ'],
        ['檜', 'ショクブツノヒノキ，キヘンニカイシャノカイノキュウジ'],
        ['檐', 'エン，サンタンタルノタンノツクリ'],
        ['檗', 'オウバクシュウノバク，カベノツチノカワリニショクブツノキ'],
        ['檪', 'クヌギ，レキ，キヘンニオンガクカノガク'],
        ['檮', 'トウ，キヘンニコトブキノキュウジ'],
        ['檬', 'モウ，レモンノニモジメ'],
        ['檣', 'ショウ，ホバシラ'],
        ['檢', 'ケンサスルノケンノキュウジ'],
        ['檠', 'ケイ，ソンケイスルノケイノシタニモクザイノモク'],
        ['檻', 'セッカンスルノカン，オリ'],
        ['檸', 'ネイ，レモンノイチモジメ'],
        ['檳', 'ショクブツノビンロウジュノビン'],
        ['K', 'ケイ キッチン'],
        ['啣', 'クツワノイタイジ，クチヘンニオロシウリノオロシ'],
        ['啼', 'テイ，ナク，クチヘンニテイオウノテイ'],
        ['啾', 'シュウ，ナク，クチヘンニアキマツリノアキ'],
        ['啻', 'タダ，テイオウノテイノシタニクチ'],
        ['啌', 'コウ，クチヘンニクウキノクウ'],
        ['問', 'モンダイ ノ モン，トウ'],
        ['啅', 'タク，クチヘンニタッキュウノタク'],
        ['啄', 'タクボク ノ タク，ツイバム'],
        ['商', 'ショウバイ ノ ショウ'],
        ['啀', 'イガミアウノイガム，ガイ'],
        ['啝', 'カ，クチヘンニワフクノワ'],
        ['啜', 'ススル，セツ'],
        ['啗', 'タン，クラウ，クチヘンニアンコノアンノツクリ'],
        ['啖', 'タンカヲキルノタン'],
        ['啓', 'ケイハツ ノ ケイ'],
        ['銑', 'センテツ ノ セン，カネヘン ニ サキ'],
        ['銖', 'シュ、カネヘンニシュイロノシュ'],
        ['孅', 'セン，オンナヘンニクジビキノクジノシタガワ'],
        ['孀', 'ソウ，ヤモメ，オンナヘンニシモバシラノシモ'],
        ['孃', 'オジョウサマノジョウノキュウジ'],
        ['銜', 'カン、ギョウガマエニキンヨウビノキン'],
        ['孕', 'ハラム，ヨウ'],
        ['孔', 'コウシモウシ ノ コウ'],
        ['字', 'ローマジ ノ ジ'],
        ['孑', 'ノコリヲイミスルケツ，コドモノコノミギウデガカケタカタチ'],
        ['子', 'コドモ ノ コ'],
        ['孝', 'オヤフコウ ノ コウ'],
        ['孜', 'ツトム，コヘン ニ ノブン'],
        ['孟', 'コウシモウシ ノ モウ'],
        ['存', 'ソンザイスル ノ ソン'],
        ['孛', 'ボツ，ボッパツスルノヒダリガワ'],
        ['孚', 'フ，ハグクム，ツメノシタニコドモノコ'],
        ['孥', 'ド，ヤッコノシタニコドモノコ'],
        ['孤', 'コドク ノ コ'],
        ['学', 'マナブ，ガクシュウ ノ ガク'],
        ['季', 'キセツフウ ノ キ'],
        ['孩', 'ガイ，コヘンニジュウニシノイノシシ'],
        ['孫', 'マゴノテ ノ マゴ，ソン'],
        ['孵', 'タマゴガフカスルノフ'],
        ['→', 'ミギヤジルシ'],
        ['↑', 'ウエヤジルシ'],
        ['←', 'ヒダリヤジルシ'],
        ['孱', 'サン，シカバネニコドモノコガミッツ'],
        ['孰', 'シュク，ガクシュウジュクノジュクカラツチヲトッタカタチ'],
        ['孳', 'ジ，ジヒブカイノジノココロノカワリニコドモノコ'],
        ['學', 'マナブ，ガクシュウノガクノキュウジ'],
        ['孺', 'ジュ，コヘンニヒツジュヒンノジュ'],
        ['芒', 'ボウ、クサカンムリニボウメイスルノボウ'],
        ['芝', 'シバフ ノ シバ'],
        ['芟', 'サン、クサカンムリニルマタ'],
        ['芙', 'ショクブツ ノ フヨウ ノ フ'],
        ['芍', 'ショクブツノシャクヤクノシャク'],
        ['芋', 'ヤキイモ ノ イモ'],
        ['!', 'カンタンフ'],
        ['花', 'ハナ，カビン ノ カ'],
        ['芳', 'カンバシイ，ホウコウザイ ノ ホウ'],
        ['芽', 'ハツガ ノ ガ，キノメ ノ メ'],
        ['芹', 'ショクブツ ノ セリ'],
        ['芸', 'ゲイジュツ ノ ゲイ'],
        ['芻', 'スウ、ハンスウドウブツノスウ'],
        ['芥', 'アクタガワショウ ノ アクタ'],
        ['芦', 'アシ，クサカンムリ ニ トジマリ ノ ト'],
        ['芭', 'バショウ ノ バ'],
        ['芬', 'アクシュウフンプンノフン'],
        ['芯', 'エンピツ ノ シン ノ シン'],
        ['芫', 'ゲン、クサカンムリニゲンキナノゲン'],
        ['謖', 'ナイテバショクヲキルノショク'],
        ['週', 'イッシュウカン ノ シュウ'],
        ['逵', 'キ、シンニョウニリクジョウノリクノツクリ'],
        ['賽', 'サイセンバコノサイ'],
        ['逸', 'イツダツスル'],
        ['銭', 'ツリセン ノ セン'],
        ['逡', 'シュンジュンスルノシュン'],
        ['穗', 'イナホノホノキュウジ'],
        ['穐', 'アキ，ノギヘン ニ カメ'],
        ['穆', 'ノギヘン ノ ボク'],
        ['穃', 'ヨウ，ノギヘンニヨウセキノヨウ'],
        ['穂', 'イナホ ノ ホ'],
        ['穀', 'コクモツ ノ コク'],
        ['穏', 'ヘイオン ノ オン，オダヤカ'],
        ['穎', 'スグレルヲ イミスル エイ，ホサキ，ノギヘン'],
        ['積', 'メンセキ ノ セキ，ツモル'],
        ['穉', 'ヨウチエンノチノイタイジ'],
        ['究', 'ケンキュウ ノ キュウ'],
        ['穴', 'アナヲホル ノ アナ'],
        ['穰', 'ゴコクホウジョウノジョウノキュウジ'],
        ['穿', 'ウガツ，センコウスル ノ セン'],
        ['逮', 'タイホジョウ ノ タイ'],
        ['穽', 'オトシアナヲイミスルカンセイノセイ'],
        ['空', 'クウキ ノ クウ，ソラ'],
        ['穹', 'ソウキュウノキュウ，アナカンムリニユミ'],
        ['穣', 'ゴコクホウジョウ ノ ジョウ'],
        ['穢', 'ケガレ，ワイ'],
        ['穡', 'ショク，ノギヘンニリンショクノショク'],
        ['穫', 'シュウカクスル ノ カク，トリイレル'],
        ['穩', 'ヘイオンノオン，オダヤカノキュウジ'],
        ['鬆', 'ショウ，カミガシラニマツノキノマツ'],
        ['懐', 'カイチュウデントウ ノ カイ，フトコロ'],
        ['懌', 'エキ，リッシンベンニサワノキュウジノツクリ'],
        ['懍', 'リン，リッシンベンニリンギスルリン'],
        ['懈', 'ケタイスルノケ，リッシンベンニカイケツスルノカイ'],
        ['應', 'オウエンスルノオウノキュウジ'],
        ['懊', 'オウノウスルノオウ，ナヤム'],
        ['懋', 'ボウ，ハヤシノアイダニムジュンスルノム，ソノシタニココロ'],
        ['鬟', 'カン，カミガシラニジュンカンスルノカンノツクリ'],
        ['懆', 'ソウ，リッシンベンニソウジュウスルノソウノツクリ'],
        ['懇', 'コンシンカイ ノ コン，ネンゴロ'],
        ['鬚', 'シュ，ヒゲ，カミガシラニヒッスノス'],
        ['鬘', 'マン，カミガシラニマンダラノマン'],
        ['懃', 'インギンブレイノギン'],
        ['懼', 'キョウクスルノク，リッシンベンニメガフタツノシタニフルトリ'],
        ['懽', 'カン，リッシンベンニカンガイヨウスイノカンノツクリ'],
        ['懾', 'ショウ，リッシンベンニミミミッツ'],
        ['懿', 'ダイヨンダイイトクテンノウノイ'],
        ['懸', 'イッショウケンメイ ノ ケン，カケル'],
        ['鬣', 'リョウ，カミガシラニリョウジュウノリョウノキュウジノツクリ'],
        ['懺', 'ザンゲスルノザン，クイル'],
        ['懴', 'ザンゲスルノザン，クイルノイタイジ'],
        ['鬯', 'チョウ，ブシュノニオイザケ'],
        ['懶', 'ランダナノラン，リッシンベンニイライスルノライノキュウジ'],
        ['懷', 'カイチュウデントウノカイ，フトコロノキュウジ'],
        ['鬪', 'トウギュウシノトウノキュウジ，タタカウ'],
        ['懲', 'コラシメル，チョウバツ ノ チョウ'],
        ['鬩', 'ゲキ，トウガマエニニラムノツクリ'],
        ['鬲', 'カク，ヘダタリノツクリ'],
        ['鬱', 'ユウウツナノウツ'],
        ['懦', 'キョウダノダ，ヨワイ，リッシンベンニヒツジュヒンノジュ'],
        ['鬻', 'シュク，カユノシタニヘダテルノツクリ'],
        ['懣', 'フンマンヤルカカタナシノマン'],
        ['猩', 'ショウコウネツノショウ，ケモノヘンニホシ'],
        ['猪', 'イノシシ，チョトツモウシン ノ チョ'],
        ['猫', 'ヤマネコ ノ ネコ'],
        ['献', 'ケンケツスル ノ ケン'],
        ['猯', 'タン，ケモノヘンニマッタンノタンノツクリ'],
        ['猥', 'ヒワイナノワイ'],
        ['猾', 'コウカツナジンブツノカツ，ケモノヘンニホネ'],
        ['猿', 'ルイジンエン ノ エン，サル'],
        ['猴', 'コウ，ケモノヘンニオウコウキゾクノコウ'],
        ['猶', 'ユウヨスル ノ ユウ'],
        ['猷', 'ハカリゴトヲ イミスル ユウ'],
        ['猊', 'ゲイカノゲイ'],
        ['猛', 'モウショ ノ モウ'],
        ['猜', 'サイギシンノサイ'],
        ['猝', 'ソツ，ケモノヘンニソツギョウノソツ'],
        ['猟', 'リョウジュウ ノ リョウ'],
        ['猖', 'ショウケツヲキワメルノショウ'],
        ['猗', 'イ，ケモノヘンニキミョウナノキ'],
        ['鏝', 'ハンダゴテノコテ'],
        ['鏘', 'ショウ、カネヘンニショウグンノショウノキュウジ'],
        ['鏗', 'コウ、カネヘンニケンジツナノケン'],
        ['鏖', 'オウ、ドウブツノシカノシタニキンヨウビノキン'],
        ['逅', 'メグリアイノカイコウノコウ'],
        ['鏑', 'カブラヤ ノ カブラ'],
        ['鏐', 'リョウ、カネヘンニニカワノツクリ'],
        ['鏈', 'レン、カネヘンニレンラクノレン'],
        ['鏃', 'ユミヤノヤジリ'],
        ['b', 'ビー ボーイ'],
        ['透', 'トウメイナ ノ トウ，スケル'],
        ['鏨', 'コウグノタガネ'],
        ['鏥', 'シュウ，カネヘンニヤド'],
        ['鏤', 'ルキンノル，チリバメル'],
        ['鏡', 'カガミ，ソウガンキョウ ノ キョウ'],
        ['㍾', 'メイジ'],
        ['㍽', 'タイショウ'],
        ['㍼', 'ショウワ'],
        ['㍻', 'ヘイセイ'],
        ['㍍', 'カナメートル'],
        ['㍊', 'カナミリバール'],
        ['㍉', 'カナミリ'],
        ['㍗', 'カナワット'],
        ['㍑', 'カナリットル'],
        ['尚', 'オショウサン ノ ショウ'],
        ['尖', 'トガル，センエイ ノ セン'],
        ['尓', 'ジ，アミダブツノミノツクリ'],
        ['少', 'オオイスクナイ ノ ショウ，ショウ'],
        ['導', 'ユウドウ ノ ドウ，ミチビク'],
        ['小', 'ダイショウ ノ ショウ，チイサイ'],
        ['對', 'ハンタイノタイノキュウジ'],
        ['尊', 'ソンケイスル ノ ソン，トウトブ'],
        ['尋', 'ジンモンスル ノ ジン，タズネル'],
        ['專', 'センモンノセンノキュウジ'],
        ['尉', 'リクグンタイイ ノ イ'],
        ['将', 'ショウグン ノ ショウ'],
        ['將', 'ショウグンノショウノキュウジ'],
        ['射', 'ハンシャ ノ シャ'],
        ['尅', 'ゲコクジョウノコクノイタイジ，コクフクスルノコクニスン'],
        ['専', 'センモン ノ セン'],
        ['封', 'フウトウ ノ フウ'],
        ['尾', 'ビコウスル ノ ビ，オッポ ノ オ'],
        ['尿', 'トウニョウビョウ ノ ニョウ'],
        ['尼', 'アマデラ ノ アマ，ニ'],
        ['尽', 'ジンリョクスル ノ ジン，ツクス'],
        ['尺', 'シャクハチ ノ シャク'],
        ['尻', 'シリゴミスル ノ シリ'],
        ['尸', 'シ，ブシュノシカバネ'],
        ['尹', 'イン，イセエビノイノツクリ'],
        ['就', 'シュウショク ノ シュウ，ツク'],
        ['尭', 'ギョウシュン ノ ギョウ'],
        ['尨', 'ボウ，ムクイヌ'],
        ['尤', 'セツゾクシ ノ モットモ'],
        ['尢', 'オウ，ブシュノマゲアシ'],
        ['尠', 'セン，ハナハダシイニスクナイ'],
        ['8', 'ハチ'],
        ['哲', 'テツガク ノ テツ'],
        ['哽', 'コウ，クチヘンニサラシナノサラ'],
        ['哺', 'ホニュウルイノホ'],
        ['哦', 'ガ，クチヘンニガマンノガ'],
        ['哥', 'ウタ，カ，カノウセイノカヲカサネル'],
        ['哢', 'ロウ，クチヘンニホンロウスルノロウ'],
        ['員', 'ガッキュウイイン ノ イン'],
        ['哮', 'ホエル，ホウコウスルノコウ'],
        ['哭', 'ドウコクスルノコク，ナク'],
        ['哩', 'タンイ ノ マイル，クチヘン ニ サト'],
        ['哨', 'ゼンショウセン ノ ショウ'],
        ['哘', 'サソウ，クチヘンニリョコウノコウ'],
        ['哇', 'アイ，クチヘンニツチフタツ'],
        ['哄', 'コウ，クチヘンニキョウツウノキョウ'],
        ['哂', 'シン，ワラウ，クチヘンニニシヒガシノニシ'],
        ['品', 'シナモノ ノ シナ，ヒン'],
        ['哀', 'キドアイラク ノ アイ，アワレム'],
        ['哉', 'ゼンザイ ノ サイ，カナ'],
        ['哈', 'ゴウ，クチヘンニゴウカクノゴウ'],
        [
            '剱',
            'ケン，ツルギノイタイジ，ジョウヨウカンジノケンノツクリガヤイバノイタイジ',
        ],
        ['茜', 'アカネイロ ノ アカネ'],
        ['茘', 'クダモノノレイシノレイ，クサカンムリニカタナガミッツ'],
        ['茗', 'ミョウガノミョウ，クサカンムリニナマエノナ'],
        ['茖', 'カク、クサカンムリニオノオノ'],
        ['む', 'ムシ ノ ム'],
        ['茎', 'クキ，チカケイ ノ ケイ'],
        ['め', 'メガネ ノ メ'],
        ['茉', 'マツ、クサカンムリニネンマツノマツ'],
        ['ゆ', 'ユカタ ノ ユ'],
        ['茅', 'カヤブキ ノ カヤ'],
        ['茄', 'クサカンムリ ニ クワエル ノ カ，ナス'],
        ['范', 'ハン、クサカンムリニカワガハンランスルノハン'],
        ['茂', 'ハンモ ノ モ，シゲル'],
        ['剴', 'ガイ，ヨロイノツクリニリットウ'],
        ['茹', 'ジョ，ユデル，クサカンムリニトツジョノジョ'],
        ['茸', 'マツタケ ノ タケ，キノコ'],
        ['茶', 'チャイロ ノ チャ'],
        ['茵', 'イン、クサカンムリニインガオウホウノイン'],
        ['茴', 'ウイキョウノウイ、クサカンムリニカイスウケンノカイ'],
        ['茲', 'シ、クサカンムリニイトガシラフタツ'],
        ['茱', 'シュ，クサカンムリニシュイロノシュ'],
        ['茯', 'ブクリョウノブク，クサカンムリニキフクニトムノフク'],
        ['茫', 'ボウゼンジシツノボウ，クサカンムリニサンズイニボウメイスルノボウ'],
        ['茨', 'イバラキケン ノ イバラ'],
        ['茣', 'ゴザノゴ，クサカンムリニゴフクヤノゴノキュウジケイ'],
        ['ゎ', 'チイサイ ワカメ ノ ワ'],
        ['剿', 'ハチノスノスニリットウ'],
        ['剣', 'ケンドウ ノ ケン，ツルギ'],
        ['矼', 'コウ，イシヘンニズガコウサクノコウ'],
        ['紀', 'キゲンゼン ノ キ'],
        ['紂', 'インノチュウオウノチュウ，イトヘンニスンポウノスン'],
        ['約', 'ヤクソク ノ ヤク'],
        ['紅', 'コウチャ ノ コウ，ベニ'],
        ['紆', 'ウヨキョクセツノウ'],
        ['紊', 'ブン，フウキビンランノビン'],
        ['紋', 'モンショウ ノ モン'],
        ['納', 'ノウゼイ ノ ノウ，オサメル'],
        ['紐', 'コシヒモ ノ ヒモ'],
        ['純', 'ジュンスイ ノ ジュン'],
        ['紕', 'ヒ，イトヘンニヒカクスルノヒ'],
        ['紗', 'オリモノ ノ シャ，イトヘン ニ スクナイ'],
        ['紘', 'ハッコウイチウ ノ コウ'],
        ['紙', 'ガヨウシ ノ シ，カミ'],
        ['級', 'サイコウキュウ ノ キュウ'],
        ['紛', 'フンシツスル ノ フン，マギレル'],
        ['紜', 'ウン，イトヘンニデンセツノデンノツクリ'],
        ['素', 'ソシツ ノ ソ'],
        ['紡', 'ボウセキ ノ ボウ，ツムグ'],
        ['索', 'サクイン ノ サク'],
        ['紫', 'シガイセン ノ シ，ムラサキ'],
        ['紬', 'ツムギ，イトヘン ニ リユウ ノ ユウ'],
        ['紮', 'ケッサツノサツ，ナフダノフダノシタニイト'],
        ['累', 'ルイセキスル ノ ルイ'],
        ['細', 'ホソイフトイ ノ ホソイ，サイ'],
        ['紲', 'セツ，イトヘンニセカイノセ'],
        ['紳', 'シンシテキナ ノ シン'],
        ['紵', 'チョ，イトヘンニチョキンノチョノツクリ'],
        ['紹', 'ジコショウカイ ノ ショウ'],
        ['紺', 'コンイロ ノ コン'],
        ['紿', 'タイ，イトヘンニダイドコロノダイ'],
        ['樌', 'カン，キヘンニイッカンスルノカン'],
        ['樋', 'ヒグチイチヨウ ノ ヒ，トイ'],
        ['樊', 'トリカゴノイミノハンロウノハン'],
        ['樅', 'モミノキノモキ'],
        ['樂', 'オンガクノガク，タノシイノキュウジ'],
        ['樟', 'ショウノウ ノ ショウ，クス'],
        ['樞', 'チュウスウノスウノキュウジ'],
        ['標', 'モクヒョウ ノ ヒョウ'],
        ['樛', 'キュウ，キヘンニニカワノツクリ'],
        ['樔', 'ソウ，キヘンニハチノスノス'],
        ['樗', 'ショクブツ ノ オウチ，チョ'],
        ['樓', 'マテンロウノロウノキュウジ'],
        ['剔', 'テキシュツスルノテキ，ボウエキノエキ，ヤサシイニリットウ'],
        ['樮', 'ホクソ，キヘンニニシノシタニカヨウビノカ'],
        ['権', 'ケンリ ノ ケン'],
        ['樫', 'カシノキ ノ カシ'],
        ['横', 'タテヨコ ノ ヨコ，オウ'],
        ['剖', 'カイボウスル ノ ボウ'],
        ['模', 'モケイ ノ モ'],
        ['樣', 'カミサマノサマ，ヨウノキュウジ'],
        ['樢', 'チョウ，キヘンニヤキトリノトリ'],
        ['樽', 'タルザケ ノ タル'],
        ['樹', 'ジュモク ノ ジュ'],
        ['樸', 'ボク，キヘンニイチニンショウノボクノツクリ'],
        ['樺', 'シラカバ ノ カバ'],
        ['y', 'ワイ ヤング'],
        ['樶', 'サイ，キヘンニサイダイサイショウノサイ'],
        ['剛', 'シツジツゴウケン ノ ゴウ'],
        ['站', 'ヘイタンセンノタン'],
        ['竚', 'チョ，タツヘンニウカンムリニイッチョウメノチョウ'],
        ['竝', 'ナラブノキュウジ'],
        ['竜', 'キョウリュウ ノ リュウ，タツ'],
        ['竟', 'ヒッキョウノキョウ'],
        ['竓', 'リョウノタンイノミリリットル'],
        ['竒', 'キミョウナノキノイタイジ'],
        ['竕', 'リョウノタンイノデシリットル'],
        ['竈', 'カマド'],
        ['立', 'ドクリツ ノ リツ，タツ'],
        ['竊', 'セットウハンノセツノキュウジ'],
        ['竍', 'リョウノタンイノデカリットル'],
        ['竏', 'リョウノタンイノキロリットル'],
        ['竃', 'カマド'],
        ['剞', 'キ，キミョウナノキニリットウ'],
        ['竅', 'キョウ，アナカンムリニシゲキノゲキノツクリ'],
        ['竄', 'カイザンスルノザン，アナカンムリニネズミ'],
        ['竇', 'トウ，アナカンムリニハンバイノバイノキュウジ'],
        ['竹', 'タケ，ショウチクバイ ノ チク'],
        ['竸', 'キョウソウスルノキョウ，キソウノイタイジ'],
        ['竺', 'テンジク ノ ジク'],
        ['竿', 'サオダケ ノ サオ，カン'],
        ['竰', 'リョウノタンイノセンチリットル'],
        ['剃', 'ソル，テイハツ ノ テイ'],
        ['競', 'キョウソウスル ノ キョウ，キソウ'],
        ['竪', 'タテゴト ノ タテ'],
        ['竭', 'ケツ，タツヘンニカッショクノカツノツクリ'],
        ['端', 'タンマツ ノ タン，ハシ'],
        ['竡', 'リョウノタンイノヘクトリットル'],
        ['章', 'ブンショウヲヨム ノ ショウ'],
        ['竣', 'シュンコウシキ ノ シュン'],
        ['竢', 'シ，タツヘンニアイサツノアイノツクリ'],
        ['童', 'グリムドウワ ノ ドウ'],
        ['竦', 'スクム，ショウ'],
        ['慧', 'ケイガン ノ ケイ，サトイ'],
        ['慥', 'ソウ，リッシンベンニカイゾウスルノゾウ'],
        ['慢', 'ジマンスル ノ マン'],
        ['慣', 'シュウカン ノ カン，ナレル'],
        ['慮', 'エンリョスル ノ リョ'],
        ['慯', 'ショウ，リッシンベンニキリキズノキズ'],
        ['慫', 'ショウ，フクジュウスルノジュウノキュウジノシタニココロ'],
        ['慨', 'カンガイムリョウ ノ ガイ'],
        ['慶', 'ケイチョウキュウカ ノ ケイ，ヨロコブ'],
        ['慷', 'ヒフンコウガイノコウ，リッシンベンニイエヤスノヤス'],
        ['慴', 'ショウ，リッシンベンニレンシュウスルノシュウ，ナラウ'],
        ['慵', 'ヨウ，リッシンベンニボンヨウナノヨウ'],
        ['慳', 'ケン，リッシンベンニケンジツナノケン'],
        ['慰', 'イシャリョウ ノ イ，ナグサメル'],
        ['慱', 'タン，リッシンベンニセンモンノセンノキュウジ'],
        ['慾', 'ヨクボウ ノ ヨク，シタゴコロアリ'],
        ['剋', 'ゲコクジョウノコク，コクフクスルノコクニリットウ'],
        ['風', 'カゼ，タイフウ ノ フウ'],
        ['慇', 'インギンナノイン'],
        ['慄', 'センリツスルノリツ'],
        ['削', 'サクゲンスル ノ サク，ケズル'],
        ['慂', 'ヨウ，コワクダニノワクノシタニココロ'],
        ['颯', 'サッソウトシタノサツ'],
        ['慎', 'シンチョウナ ノ シン，ツツシム'],
        ['ゾ', 'ゾウキン ノ ゾ'],
        ['慌', 'アワテル，キョウコウ ノ コウ'],
        ['慍', 'ウン，リッシンベンニオンセンノオンノキュウジタイノツクリ'],
        ['慊', 'ケン，リッシンベンニカネル'],
        ['態', 'タイド ノ タイ'],
        ['慈', 'ジヒブカイ ノ ジ，イツクシム'],
        ['タ', 'タバコ ノ タ'],
        ['慕', 'ボジョウ ノ ボ，シタウ'],
        ['慓', 'ヒョウ，リッシンベンニトウヒョウスルノヒョウ'],
        ['慟', 'ドウコクスルノドウ'],
        ['慝', 'トク，トクメイノトクノシタニココロ'],
        ['慚', 'ザンキニタエナイノザン，リッシンベン'],
        ['慘', 'ザンパイスルノザン，ミジメノキュウジ'],
        ['慙', 'ザンキニタエナイノザン，シタゴコロ'],
        ['嫌', 'キラウ，ケンオ ノ ケン'],
        ['嫋', 'ジョウ，タオヤカ'],
        ['嫉', 'シットスル ノ シツ，ソネム'],
        ['嫂', 'ソウ，アニヨメ'],
        ['Å', 'オングストローム'],
        ['嫗', 'オウ，オンナヘンニクベツノクノキュウジ'],
        ['嫖', 'ヒョウ，オンナヘンニトウヒョウノヒョウ'],
        ['嫐', 'ドウ，ナヤマシイ，オンナ，オトコ，オンナ'],
        ['嫩', 'ドン，オンナヘンニセイリスルノセイノウエガワ'],
        ['嫦', 'ジョウ，オンナヘンニヒジョウグチノジョウ'],
        ['嫣', 'エン，オンナヘンニシュウエンノチノエン'],
        ['嫡', 'チャクナン ノ チャク'],
        ['№', 'ナンバー'],
        ['嫻', 'カン，オンナヘンニモンガマエニモクヨウビノモク'],
        ['嫺', 'カン，オンナヘンニモンガマエニツキ'],
        ['㏄', 'シーシー'],
        ['㏍', 'ケーケー'],
        ['厠', 'カワヤ，ガンダレニホウソクノソク'],
        ['厥', 'ユウボクミンゾクノトッケツノケツ'],
        ['厦', 'カ，ガンダレニナツ'],
        ['厨', 'チュウボウ ノ チュウ，クリヤ'],
        ['厩', 'キュウシャ ノ キュウ，ウマヤ'],
        ['厭', 'エンセイカン ノ エン，イトウ'],
        ['厮', 'シ，ガンダレニシカイノケンイノシ'],
        ['厰', 'カイグンコウショウノショウノイタイジ，ガンダレ'],
        ['♯', 'シャープ'],
        ['♭', 'フラット'],
        ['♪', 'オンプ'],
        ['厶', 'シ，ワタクシ，カタカナノム'],
        ['去', 'キョネン ノ キョ，サル'],
        ['厂', 'カン，ブシュノガンダレ'],
        ['厄', 'ヤクドシ ノ ヤク'],
        ['厖', 'ボウダイナノボウ，ガンダレニムクイヌ'],
        ['厘', 'クブクリン ノ リン'],
        ['厚', 'アツガミ ノ アツ'],
        ['♂', 'オス'],
        ['♀', 'メス'],
        ['原', 'ゲンイン ノ ゲン，ハラ'],
        ['俺', 'オレサマ ノ オレ'],
        ['%', 'パーセント'],
        ['俶', 'シュク，ニンベンニシュクジョノシュクノツクリ'],
        ['俵', 'ドヒョウ ノ ヒョウ，タワラ'],
        ['俯', 'ウツムク，フカンスルノフ'],
        ['行', 'リョコウ ノ コウ，イク'],
        ['衍', 'フエンスルノエン'],
        ['血', 'ケツエキ ノ ケツ，チ'],
        ['衂', 'ジク，チヘンニヤイバノイタイジ'],
        ['衄', 'ジク，チヘンニジュウニシノウシ'],
        ['衆', 'シュウギイン ノ シュウ'],
        ['衙', 'ヤクショヲオイミスルカンガノガ'],
        ['衛', 'エイセイテキ ノ エイ'],
        ['衝', 'ショウトツスル ノ ショウ'],
        ['衞', 'エイセイテキノエイノキュウジ'],
        ['衒', 'キヲテラウノテラウ，ゲン'],
        ['術', 'ゲイジュツ ノ ジュツ'],
        ['街', 'ガイロジュ ノ ガイ'],
        ['表', 'ウラオモテ ノ オモテ，ヒョウ'],
        ['衫', 'サン，コロモヘンニサンヅクリ'],
        ['衡', 'ヘイコウカンカク ノ コウ'],
        ['衢', 'チマタヲイミスルガイクノク'],
        ['衣', 'イフク ノ イ，コロモ'],
        ['衽', 'ジン、コロモヘンニジンシンノランノジン'],
        ['衾', 'ドウキンスルノキン'],
        ['衿', 'エリ，コロモヘン ニ イマ'],
        ['衰', 'スイジャクスル ノ スイ，オトロエル'],
        ['衲', 'ノウ、コロモヘンニコクナイノナイ'],
        ['衵', 'ジツ、コロモヘンニニチヨウビノニチ'],
        ['衷', 'ワヨウセッチュウ ノ チュウ'],
        ['保', 'ホケンシツ ノ ホ，タモツ'],
        ['俐', 'レイリノリ，ニンベンニケンリノリ'],
        ['玲', 'レイロウナ ノ レイ，オウヘン ニ メイレイ ノ レイ'],
        ['玳', 'ドウブツノタイマイノタイ，オウヘンニダイヒョウノダイ'],
        ['玻', 'ハ，オウヘンニケガワノカワ'],
        ['玩', 'ガング ノ ガン，モテアソブ'],
        ['俊', 'シュンビンサ ノ シュン'],
        ['玖', 'オウヘン ニ ヒサシイ ノ ク'],
        ['率', 'ヒリツ ノ リツ，ヒキイル'],
        ['玄', 'ゲンマイ ノ ゲン'],
        ['王', 'オウサマ ノ オウ'],
        ['玉', 'ミズタマ ノ タマ，ギョク'],
        ['鍠', 'コウ、カネヘンニコウタイシノコウ'],
        ['鍬', 'ノウグ ノ クワ，カネヘン ニ アキ'],
        ['鍮', 'キンゾクノシンチュウノチュウ'],
        ['鍵', 'カギ，ケンバン ノ ケン'],
        ['鍼', 'シン，ハリキュウノハリ'],
        ['鍾', 'ショウニュウドウ ノ ショウ'],
        ['鍄', 'リョウ、カネヘンニトウキョウノキョウ'],
        ['鍋', 'ナベモノ ノ ナベ'],
        ['鍍', 'トキン ノ ト，カネヘン ニ オンドケイ ノ ド'],
        ['鍔', 'カタナ ノ ツバ，ガク'],
        ['鍖', 'チン、カネヘンニハナハダシイ'],
        ['鍛', 'キタエル，タンレン ノ タン'],
        ['鍜', 'カ，カネヘンニヒマツブシノヒマノツクリ'],
        ['綉', 'シシュウスルノシュウノイタイジ'],
        ['綏', 'スイゼイテンノウノスイ'],
        ['続', 'レンゾク ノ ゾク，ツヅク'],
        ['綛', 'カスリ，イトヘンニシノビ'],
        ['継', 'ケイゾクスル ノ ケイ，ツグ'],
        ['綟', 'レイ，イトヘンニモドル'],
        ['綜', 'サクソウスル ノ ソウ，イトヘン ニ シュウキョウ ノ シュウ'],
        ['經', 'ケイケンスルノケイノキュウジ'],
        ['綫', 'シンカンセンノセンノイタイジ'],
        ['綮', 'ケイ，ケイハツノケイノクチノカワリニイト'],
        ['綯', 'ナワヲナウノナウ'],
        ['綬', 'シジュホウショウ ノ ジュ，イトヘン ニ ウケル'],
        ['維', 'イジスル ノ イ'],
        ['綢', 'チュウ，イトヘンニシュウヘンノシュウノキュウジタイ'],
        ['綣', 'ケン，イトヘンニノリマキノマキノキュウジ'],
        ['綺', 'キレイナノキ，イトヘンニキミョウナノキ'],
        ['綻', 'ハタンスル ノ タン，ホコロビル'],
        ['綸', 'リンゲンアセノゴトシノリン'],
        ['綾', 'アヤオリ ノ アヤ'],
        ['綿', 'ワタ，モメン ノ メン'],
        ['綽', 'ヨユウシャクシャクノシャク'],
        ['網', 'モウマク ノ モウ，アミ'],
        ['綰', 'ワン，イトヘンニケイサツカンノカン'],
        ['綱', 'ツナヒキ ノ ツナ，コウ'],
        ['綴', 'ツヅル'],
        ['綵', 'サイ，イトヘンニハクシュカッサイノサイノキュウジタイ'],
        ['殖', 'ヨウショクスル ノ ショク，フヤス'],
        ['殕', 'ホウ，カバネヘンニバイリツノバイノツクリ'],
        ['殞', 'イン，カバネヘンニガッキュウイインノイン'],
        ['殘', 'ザンネンノザン，ノコルノキュウジ'],
        ['殆', 'ホトンド'],
        ['殄', 'テン，カバネヘンニシンサツスルノシンノツクリ'],
        ['殃', 'オウ，カバネヘンニチュウオウノオウ'],
        ['殀', 'ヨウ，カバネヘンニヨウカイヘンゲノヨウノツクリ'],
        ['殍', 'ヒョウ，カバネヘンニツメノシタニコドモノコ'],
        ['残', 'ザンネン ノ ザン，ノコル'],
        ['殊', 'トクシュ ノ シュ，コトニ'],
        ['殉', 'ジュンキョウシャ ノ ジュン'],
        ['殷', 'チュウゴクノオウチョウノイン'],
        ['段', 'シュダン ノ ダン'],
        ['殴', 'オウダスル ノ オウ，ナグル'],
        ['殳', 'シュ，ブシュノルマタ'],
        ['殲', 'テキヲセンメツスルノセン'],
        ['殱', 'テキヲセンメツスルノセンノイタイジ'],
        ['f', 'エフ フレンド'],
        ['殿', 'トノサマ ノ トノ'],
        ['殼', 'カイガラノカラ，カクノキュウジ'],
        ['殻', 'カイガラ ノ ガラ，カク'],
        ['殺', 'サツジン ノ サツ，コロス'],
        ['会', 'カイシャ ノ カイ，アウ'],
        ['殤', 'ショウ，カバネヘンニキリキズノツクリ'],
        ['殯', 'ヒン，モガリ，カバネヘンニライヒンノヒン'],
        ['殫', 'タン，カバネヘンニタンジュンノタンノキュウジ'],
        ['殪', 'エイ，カバネヘンニケイヤクショニツカウスウジイチノキュウジ'],
        ['餞', 'ハナムケ，センベツノセン'],
        ['呻', 'シンギンスルノシン，ウメク'],
        ['命', 'ウンメイ ノ メイ，イノチ'],
        ['呼', 'コキュウスル ノ コ，ヨブ'],
        ['呱', 'ココノコエヲアゲルノコ'],
        ['呰', 'シ，ヒガンシガンノシノシタニクチ'],
        ['味', 'イミ ノ ミ，アジ'],
        ['呵', 'タンカヲキルノカ，クチヘンニカノウセイノカ'],
        ['呷', 'コウ，サケヲアオルノアオル，クチヘンニコウオツノコウ'],
        ['呶', 'ド，クチヘンニヤッコ'],
        ['周', 'シュウヘン ノ シュウ，マワリ'],
        ['呪', 'ノロウ，ジュモン ノ ジュ'],
        ['呟', 'ツブヤク'],
        ['呑', 'ヘイドンスル ノ ドン，ノム'],
        ['呉', 'ゴフクヤ ノ ゴ，クレ'],
        ['呈', 'ゾウテイスル ノ テイ'],
        ['告', 'コウコク ノ コク，ツゲル'],
        ['呎', 'ナガサノタンイノフィート'],
        ['呀', 'カ，クチヘンニキバ'],
        ['呂', 'オフロ ノ ロ'],
        ['呆', 'アキレル，ボウゼントスル ノ ボウ'],
        ['<', 'ショウナリ'],
        ['婚', 'ケッコンスル ノ コン'],
        ['婁', 'ロウカク ノ ロウ ノ キュウジ ノ ツクリ'],
        ['婀', 'アダッポイノア'],
        ['婆', 'ロウバシン ノ バ'],
        ['婉', 'エンキョクヒョウゲンノエン'],
        ['婿', 'ハナムコ ノ ムコ'],
        ['婢', 'ヒ，オンナヘンニヒクツナノヒ'],
        ['婦', 'フウフ ノ フ'],
        ['婪', 'ドンランナノラン，ハヤシノシタニオンナ'],
        ['婬', 'イン，オンナヘンニインランノインノツクリ'],
        ['莠', 'ユウ，クサカンムリニヒイデル'],
        ['莢', 'キョウ，マメノサヤ'],
        ['鷦', 'ショウ，コゲルノミギニトリ'],
        ['莨', 'ロウ、タバコ、クサカンムリニカイリョウスルノリョウ'],
        ['莫', 'バクダイナ ノ バク'],
        ['莪', 'ガ，クサカンムリニガマンノガ'],
        ['莱', 'ホウライサン ノ ライ'],
        ['莵', 'ト，クサカンムリニウサギノイタイジ'],
        ['莽', 'ソウモウノシンノモウ'],
        ['莅', 'リ，クサカンムリニタンイノイ'],
        ['莇', 'ショ、クサカンムリニキュウジョスルノジョ'],
        ['莉', 'リ、クサカンムリニリエキノリ'],
        ['莊', 'ベッソウチノソウノイタイジ'],
        ['莎', 'サ、クサカンムリニゴブサタノサ'],
        ['鷯', 'リョウ，ドウリョウノリョウノツクリノミギニトリ'],
        ['莓', 'クダモノノイチゴ、クサカンムリニマイニチノマイ'],
        ['莖', 'チカケイノケイノキュウジ'],
        ['莚', 'エン，ムシロ，クサカンムリニエンキスルノエン'],
        ['莟', 'カン，クサカンムリニフクメル'],
        ['莞', 'クサカンムリ ニ カンリョウスル ノ カン'],
        ['鷲', 'トリ ノ ワシ'],
        ['鷽', 'ガク，ガクカンムリノキュウジタイノシタニトリ'],
        ['鷺', 'シラサギ ノ サギ'],
        ['鷆', 'テン，マゴコロノマノキュウジノミギニトリ'],
        ['餐', 'バンサン ノ サン'],
        ['畢', 'ヒッキョウ ノ ヒツ，オワル'],
        ['畠', 'ハタケ，シロ ノ シタニ タ'],
        ['畧', 'リャクゴノリャクノイタイジ'],
        ['畦', 'アゼミチ ノ アゼ，タ ニ ツチ フタツ'],
        ['略', 'リャクゴ ノ リャク'],
        ['畤', 'ジ，タヘンニテラ'],
        ['畫', 'ガヨウシノガノキュウジ'],
        ['番', 'バンゴウ ノ バン'],
        ['畩', 'ケサ，タヘンニコロモガエノコロモ'],
        ['畭', 'ヨ，タヘンニアマリ'],
        ['畳', 'タタミ，ヨジョウハン ノ ジョウ'],
        ['異', 'イコク ノ イ，コトナル'],
        ['畷', 'シジョウナワテシ ノ ナワテ'],
        ['當', 'トウバンノトウ，アタルノキュウジ'],
        ['畴', 'ハン，タヘンニコトブキ'],
        ['畸', 'キ，タヘンニキミョウナノキ'],
        ['畿', 'キンキチホウ ノ キ'],
        ['畆', 'メンセキノタンイノセ，ウネノイタイジ'],
        ['畄', 'リュウガクノリュウノイタイジ'],
        ['畋', 'テン，スイデンノデンニノブン'],
        ['畊', 'コウ，タガヤスノイタイジ'],
        ['畉', 'フ，タガヤス，タヘンニオット'],
        ['畏', 'イフスル ノ イ，カシコマル'],
        ['畍', 'セカイノカイノイタイジ'],
        ['界', 'セカイ ノ カイ'],
        ['畑', 'タハタ ノ ハタ，ハタケ'],
        ['畔', 'コハン ノ ハン，ホトリ'],
        ['畛', 'シン，アゼ，タヘンニシンサツスルノシンノツクリ'],
        ['畚', 'ホン，オマイリノマイノサンズクリノカワリニスイデンノデン'],
        ['留', 'リュウガク ノ リュウ'],
        ['畝', 'ハタケ ノ ウネ，メンセキ ノ タンイ ノ セ'],
        ['畜', 'カチク ノ チク'],
        ['頒', 'ハンプスル ノ ハン'],
        ['頓', 'セイトンスル ノ トン'],
        ['預', 'ヨキン ノ ヨ，アズケル'],
        ['頑', 'ガンバル ノ ガン'],
        ['括', 'ソウカツ ノ カツ，ククル'],
        ['拭', 'フッショク ノ ショク，ヌグウ'],
        ['拮', 'キッコウスルノキツ'],
        ['拯', 'ジョウ，テヘンニダイジンヲイミスルジョウショウノジョウ'],
        ['拠', 'キョテン ノ キョ'],
        ['拡', 'カクダイ ノ カク'],
        ['領', 'ダイトウリョウ ノ リョウ'],
        ['昊', 'コウ，ニチヨウビノニチノシタニテンキヨホウノテン'],
        ['頂', 'チョウテン ノ チョウ，イタダキ'],
        ['頃', 'コロアイ ノ コロ'],
        ['頁', 'ページ'],
        ['順', 'ジュンバン ノ ジュン'],
        ['拾', 'オカネヲ ヒロウ ノ ヒロウ'],
        ['拿', 'ダホスルノダ，ゴウカクノゴウノシタニテ'],
        ['拱', 'コマヌク，キョウ，テヘンノキョウツウノキョウ'],
        ['須', 'ヒッス ノ ス，スベカラク'],
        ['拳', 'ケンジュウ ノ ケン，コブシ'],
        ['拵', 'コシラエル，ソン'],
        ['拶', 'アイサツ ノ サツ'],
        ['拷', 'ゴウモンスル ノ ゴウ'],
        ['拈', 'ネン，テヘンニドクセンスルノセン'],
        ['拉', 'ラチスルノラ'],
        ['拊', 'フ，テヘンニフロクノフ'],
        ['拌', 'カクハンスルノハン，カキマゼル'],
        ['拍', 'ハクシュスル ノ ハク'],
        ['頴', 'スグレルヲ イミスル エイ，ホサキ，シメス'],
        ['拏', 'ダホスルノダ，ヤッコノシタニテ'],
        ['頻', 'ヒンパンナ ノ ヒン'],
        ['拂', 'カネヲハラウノハラウノキュウジ'],
        ['担', 'タンニン ノ タン'],
        ['拆', 'タク，テヘンニハイセキウンドウノセキ'],
        ['拇', 'ボインヲオスノボ'],
        ['拘', 'コウソクジカン ノ コウ'],
        ['拙', 'チセツ ノ セツ，ツタナイ'],
        ['招', 'マネク，ショウタイスル ノ ショウ'],
        ['拜', 'オガムノキュウジ'],
        ['拝', 'オガム，ハイケイ ノ ハイ'],
        ['頤', 'オトガイ'],
        ['拐', 'ユウカイジケン ノ カイ'],
        ['拑', 'カン，テヘンニアマイ'],
        ['拒', 'キョヒスル ノ キョ，コバム'],
        ['拓', 'カイタクスル ノ タク'],
        ['拔', 'バツグンノバツ，ヌケルノキュウジ'],
        ['頬', 'ホオヅエ ノ ホオ'],
        ['拗', 'ヨウオンノヨウ，テヘンニオオサナイ'],
        ['爵', 'ハクシャク ノ シャク'],
        ['父', 'フボ ノ フ，チチ'],
        ['爰', 'オウエンスルノエンノキュウジノツクリ'],
        ['爲', 'コウイノイ，タメノキュウジ'],
        ['爼', 'マナイタ，ソジョウノソノイタイジ'],
        ['爽', 'サワヤカ，ソウカイナ ノ ソウ'],
        ['爾', 'ソツジナガラ ノ ジ，ナンジ'],
        ['爿', 'ショウヘン，ショウグンノショウノキュウジノヘン'],
        ['爺', 'コウコウヤ ノ ヤ，ジイ'],
        ['爻', 'コウ，ハンバクスルノバクノツクリ'],
        ['爬', 'ハチュウルイノハ'],
        ['爭', 'アラソウノキュウジ'],
        ['爨', 'ハンゴウスイサンノサン'],
        ['爪', 'ツメキリ ノ ツメ'],
        ['爐', 'ダンロノロノキュウジ'],
        ['爛', 'テンシンランマンノラン'],
        ['爆', 'バクハツスル ノ バク'],
        ['爍', 'シャク，ヒヘンニタノシイノキュウジ'],
        ['況', 'ジッキョウチュウケイ ノ キョウ'],
        ['部', 'ブチョウ ノ ブ'],
        ['泄', 'ハイセツブツノセツ'],
        ['泅', 'シュウ，サンズイニシュウジンフクノシュウ'],
        ['郭', 'リンカク ノ カク，クルワ'],
        ['泉', 'オンセン ノ セン，イズミ'],
        ['泊', 'シュクハクスル ノ ハク，トマル'],
        ['泌', 'ヒニョウキ ノ ヒ'],
        ['郤', 'ケキ，タニノミギニオオザト'],
        ['泓', 'オウ，サンズイニコウボウタイシノコウ'],
        ['法', 'ホウリツ ノ ホウ'],
        ['都', 'トカイ ノ ト，ミヤコ'],
        ['泗', 'シ，サンズイニカンスウジノヨン'],
        ['泙', 'ヘイ，サンズイニヘイワノヘイ'],
        ['泛', 'ハン，サンズイニビンボウノボウ'],
        ['郷', 'ウマレコキョウ ノ キョウ'],
        ['泝', 'ソ，サンズイニハイセキウンドウノセキ'],
        ['郵', 'ユウビン ノ ユウ'],
        ['泡', 'アワ，スイホウ ノ ホウ'],
        ['波', 'ツナミ ノ ナミ，ハ'],
        ['泣', 'ナク，ゴウキュウスル ノ キュウ'],
        ['泥', 'デイスイ ノ デイ，ドロ'],
        ['注', 'チュウモクスル ノ チュウ，ソソグ'],
        ['泪', 'ナミダノイタイジ，サンズイニモクテキノモク'],
        ['泯', 'ビン，サンズイニコクミンノミン'],
        ['泰', 'アンタイ ノ タイ'],
        ['泱', 'オウ，サンズイニチュウオウノオウ'],
        ['泳', 'スイエイ ノ エイ，オヨグ'],
        ['ほ', 'ホケン ノ ホ'],
        ['ぺ', 'ペット ノ ペ'],
        ['べ', 'ベルト ノ ベ'],
        ['へ', 'ヘイワ ノ ヘ'],
        ['み', 'ミカン ノ ミ'],
        ['ま', 'マッチ ノ マ'],
        ['ぽ', 'ポスト ノ ポ'],
        ['ぼ', 'ボタン ノ ボ'],
        ['び', 'ビール ノ ビ'],
        ['ひ', 'ヒカリ ノ ヒ'],
        ['ぱ', 'パジャマ ノ パ'],
        ['ば', 'バナナ ノ バ'],
        ['ぷ', 'プリント ノ プ'],
        ['ぶ', 'ブランコ ノ ブ'],
        ['ふ', 'フトン ノ フ'],
        ['ぴ', 'ピアノ ノ ピ'],
        ['に', 'ニホン ノ ニ'],
        ['な', 'ナマエ ノ ナ'],
        ['ど', 'ドレミ ノ ド'],
        ['と', 'トウキョウ ノ ト'],
        ['は', 'ハガキ ノ ハ'],
        ['の', 'ノハラ ノ ノ'],
        ['ね', 'ネズミ ノ ネ'],
        ['ぬ', 'ヌリエ ノ ヌ'],
        ['っ', 'チイサイ ツバメ ノ ツ'],
        ['ぢ', 'ハナヂ ノ ヂ'],
        ['ち', 'チキュウ ノ チ'],
        ['だ', 'ダルマ ノ ダ'],
        ['で', 'デンワ ノ デ'],
        ['て', 'テガミ ノ テ'],
        ['づ', 'ツヅミ ノ ヅ'],
        ['つ', 'ツバメ ツ'],
        ['せ', 'セカイ ノ セ'],
        ['ず', 'ズボン ノ ズ'],
        ['す', 'スズメ ノ ス'],
        ['じ', 'ジカン ノ ジ'],
        ['た', 'タバコ ノ タ'],
        ['ぞ', 'ゾウキン ノ ゾ'],
        ['そ', 'ソロバン ノ ソ'],
        ['ぜ', 'ゼンブ ノ ゼ'],
        ['こ', 'コドモ ノ コ'],
        ['げ', 'ゲーム ノ ゲ'],
        ['け', 'ケシキ ノ ケ'],
        ['ぐ', 'グランド ノ グ'],
        ['し', 'シンブン ノ シ'],
        ['ざ', 'ザブトン ノ ザ'],
        ['さ', 'サクラ ノ サ'],
        ['ご', 'ゴリラ ノ ゴ'],
        ['か', 'カゾク ノ カ'],
        ['お', 'オオサカ ノ オ'],
        ['ぉ', 'チイサイ オオサカ ノ オ'],
        ['え', 'エイゴ ノ エ'],
        ['く', 'クスリ ノ ク'],
        ['ぎ', 'ギンコウ ノ ギ'],
        ['き', 'キッテ ノ キ'],
        ['が', 'ガッコウ ノ ガ'],
        ['ぃ', 'チイサイ イチゴ ノ イ'],
        ['あ', 'アサヒ ノ ア'],
        ['ぁ', 'チイサイ アサヒ ノ ア'],
        ['ぇ', 'チイサイ エイゴ ノ エ'],
        ['う', 'ウサギ ノ ウ'],
        ['ぅ', 'チイサイ ウサギ ノ ウ'],
        ['い', 'イチゴ ノ イ'],
        ['匪', 'ヒゾク ノ ヒ，ハコガマエ ニ ヒジョウグチ ノ ヒ'],
        ['匯', 'カイ，ハコガマエニサンズイトフルトリ'],
        ['匣', 'コウ，ハコガマエニコウオツノコウ'],
        ['匠', 'キョショウ ノ ショウ，タクミ'],
        ['匡', 'タダス，キョウ，ハコガマエ ニ オウ'],
        ['区', 'クベツ ノ ク'],
        ['医', 'オイシャサン ノ イ'],
        ['S', 'エス スポーツ'],
        ['匹', 'イッピキニヒキ ノ ヒキ'],
        ['匿', 'トクメイ ノ トク，カクス'],
        ['匳', 'ハコガマエニシケンヲウケルノケンノキュウジノツクリ'],
        ['匱', 'キ，ハコガマエニキチョウヒンノキ'],
        ['匈', 'ユウボクミンゾクノキョウドノキョウ'],
        ['匏', 'ホウ，ヒサゴ，ハカマノツクリニ，ヒョウガフルノヒョウノシタガワ'],
        ['匍', 'ホフクゼンシンノホ'],
        ['匂', 'イイニオイ ノ ニオイ'],
        ['匁', 'オモサ ノ タンイ ノ モンメ'],
        ['匆', 'ソウ，ネギカラクサカンムリトココロヲトッタカタチ'],
        ['包', 'ホウタイ ノ ホウ，ツツム'],
        ['匚', 'ホウ，ブシュノハコガマエ'],
        ['匙', 'サジカゲン ノ サジ'],
        ['匝', 'ソウ，ハコガマエ ニ ハバ'],
        ['匐', 'ホフクゼンシンノフク'],
        ['化', 'カセキ ノ カ，バケル'],
        ['北', 'キタミナミ ノ キタ，ホク'],
        ['匕', 'サジヲイミスルヒ'],
        ['餉', 'ショウ，ショクヘンニムカウ'],
        ['餃', 'ギョーザノイチモジメ'],
        ['裔', 'マツエイノエイ'],
        ['裕', 'ヨユウ ノ ユウ'],
        ['裘', 'キュウ、カワゴロモ'],
        ['裙', 'クン、コロモヘンニショクンノクン'],
        ['裟', 'オボウサン ノ ケサ ノ サ'],
        ['補', 'ホジョ ノ ホ，オギナウ'],
        ['裝', 'フクソウノソウノキュウジ'],
        ['裂', 'ブンレツスル ノ レツ，サケル'],
        ['裃', 'レイフクノカミシモ'],
        ['裁', 'サイバン ノ サイ，サバク'],
        ['裄', 'ユキタケノユキ、コロモヘンニリョコウキノコウ'],
        ['装', 'フクソウ ノ ソウ'],
        ['鋳', 'チュウゾウスル ノ チュウ，イル'],
        ['裏', 'ウラオモテ ノ ウラ'],
        ['裲', 'リョウ、コロモヘンニリョウテノリョウノキュウジ'],
        ['裳', 'イショウ ノ ショウ，モスソ'],
        ['裴', 'ハイ、ヒジョウグチノヒノシタニコロモ'],
        [')', 'トジカッコ'],
        ['裸', 'ハダカ，ラタイ ノ ラ'],
        ['裹', 'カ、コロモノアイダニコウカテキノカ'],
        ['裾', 'スソノ ノ スソ'],
        ['餬', 'コ，カユ，ショクヘンニクロコショウノコ'],
        ['裼', 'セキ、コロモヘンニボウエキフウノエキ'],
        ['製', 'セイゾウスル ノ セイ'],
        ['裡', 'キンリ ノ リ，コロモヘン ニ サト'],
        ['裨', 'ヒ、コロモヘンニヒクツナノヒ'],
        ['耨', 'ドウ，スキヘンニブジョクスルノジョク'],
        ['耡', 'ジョ，スキヘンニキュウジョスルノジョ'],
        ['耻', 'ハジヲカクノハジノイタイジ'],
        ['耿', 'コウ，ミミヘンニカヨウビノカ'],
        ['耽', 'タンデキスル ノ タン，フケル'],
        ['耳', 'ミミ，ジビカ ノ ジ'],
        ['耶', 'ウヤムヤ ノ ヤ'],
        ['耋', 'テツ，ロウジンノロウノシタニダイシキュウノシ，'],
        ['而', 'シコウシテ，ケイジジョウ ノ ジ'],
        ['考', 'カンガエル，サンコウショ ノ コウ'],
        ['老', 'ロウジン ノ ロウ'],
        ['耀', 'エイヨウエイガ ノ ヨウ，カガヤク'],
        ['耆', 'キ，ロウジンノロウノシタニマイニチノニチ'],
        ['者', 'ガクシャ ノ シャ，モノ'],
        ['耄', 'モウロクスルノモウ，ロウジンノロウノシタニケイトノケ'],
        ['耙', 'ハ，スキヘンニトモエ'],
        ['耘', 'コウウンキノウン，ブシュノスキヘンニウンヌンノウン'],
        ['耜', 'シ，スキヘンニケイサツカンノカンノシタガワ'],
        ['耒', 'ライ，ブシュノスキヘン'],
        ['耐', 'ニンタイ ノ タイ，タエル'],
        ['耗', 'ショウモウヒン ノ モウ'],
        ['耕', 'タガヤス，ノウコウ ノ コウ'],
        ['簍', 'ロウ，タケカンムリニロウカクノロウノキュウジノツクリ'],
        ['簇', 'ソウ，ムラガル，タケカンムリニスイゾクカンノゾク'],
        ['簀', 'スノコノス'],
        ['簟', 'テン，タカムシロ，タケカンムリニニシノシタニハヤオキノハヤイ'],
        ['簔', 'ミノノイタイジ，タケカンムリニオトロエルノヘンケイ'],
        ['簗', 'サカナヲトルヤナ，タケカンムリニリョウザンパクノリョウ'],
        ['簑', 'ミノノイタイジ，タケカンムリニオトロエル'],
        ['簒', 'サンダツスルノサン，ウバウ'],
        ['簓', 'ササラ'],
        ['簪', 'カンザシ，シン'],
        ['簫', 'ショウ，タケカンムリニゲンシュクナノシュクノキュウジ'],
        ['簧', 'コウ，タケカンムリニキイロノキノキュウジ'],
        ['簡', 'カンタンナ ノ カン'],
        ['簣', 'キ，タケカンムリニキチョウヒンノキ'],
        ['簽', 'セン，タケカンムリニシケンヲウケルノケンノキュウジノツクリ'],
        ['簾', 'スダレ，レン'],
        ['簿', 'メイボ ノ ボ'],
        ['簸', 'ハ，タケカンムリ ニ ソノタ ノ ソニ カワ'],
        ['簷', 'エン、タケカンムリニタンニンノタンノキュウジノツクリ'],
        ['鉞', 'フエツノエツ、マサカリ'],
        ['欝', 'ユウウツナ ノ ウツ'],
        ['欟', 'カン，キヘンニカンキャクノカンノキュウジ'],
        ['黄', 'キイロ ノ キ，オウ'],
        ['欒', 'イッカダンランノラン'],
        ['黏', 'ネバル，ネン，キビヘンニドクセンスルノセン'],
        ['黎', 'レイメイキノレイ'],
        ['黍', 'コクモツ ノ キビ，ショ'],
        ['欖', 'カンランサンノラン，キヘンニハクランカイノランノキュウジ'],
        ['黒', 'コクバン ノ コク，クロ'],
        ['權', 'ケンリノケンノキュウジ'],
        ['鉛', 'エンピツ ノ エン，ナマリ'],
        ['黔', 'クロイ，ケン，クロイノミギニイマ'],
        ['黛', 'マユズミ'],
        ['黙', 'チンモク ノ モク，ダマル'],
        ['默', 'チンモクスルノモク，ダマルノキュウジ'],
        ['欅', 'ケヤキ，キヘンニセンキョケンノキョノキュウジ'],
        ['欄', 'クウラン ノ ラン'],
        ['黝', 'アオグロイ，ユウ，クロノミギニオサナイ'],
        ['黜', 'シリゾケル，チュツ，クロノミギニデル'],
        ['欹', 'キ，キミョウナノキニフカケツノケツ'],
        ['欸', 'アイ，アイサツノアイノツクリニフカケツノケツ'],
        ['欺', 'サギ ノ ギ，アザムク'],
        ['欽', 'キンテイケンポウ ノ キン'],
        ['黥', 'ゲイ，イレズミ，クロノミギニトウキョウノキョウ'],
        ['款', 'エンシャッカン ノ カン'],
        ['欲', 'ヨクボウ ノ ヨク，ホシイ'],
        ['黯', 'クライ，アン，クロノミギニオンガクノオン'],
        ['欷', 'キ，キボウノキニフカケツノケツ'],
        ['黷', 'ケガス，トク，クロノミギニハンバイノバイノキュウジ'],
        ['黶', 'ホクロ，エン'],
        ['黴', 'カビ，バイキンノバイ'],
        ['次', 'モクジ ノ ジ，ツギ'],
        ['欠', 'ホケツ ノ ケツ，カケル'],
        ['欣', 'キンキジャクヤク ノ キン，ヨロコブ'],
        ['欧', 'オウベイ ノ オウ'],
        ['黼', 'ヌイトリノモヨウヲイミスルフ'],
        ['痣', 'アザ，ヤマイダレニココロザシ'],
        ['痢', 'ゲリヲスル ノ リ'],
        ['痩', 'ヤセル，ソウシン ノ ソウ'],
        ['痴', 'グチ ノ チ'],
        ['痰', 'タンガカラムノタン'],
        ['痳', 'リン，ヤマイダレニハヤシ'],
        ['痲', 'ヤマイダレノマヒスルノマ'],
        ['痼', 'ジビョウヲイミスルコシツノコ'],
        ['痿', 'イ，ヤマイダレニガッキュウイインノイ'],
        ['痾', 'ア，ヤマイダレニアミダブツノア'],
        ['痺', 'マヒスルノヒ，シビレル'],
        ['病', 'ビョウキ ノ ビョウ，ヤマイ'],
        ['症', 'カフンショウ ノ ショウ'],
        ['痃', 'ケン，ヤマイダレニゲンマイノゲン'],
        ['痂', 'カ，カサブタ，ヤマイダレニカソクドノカ'],
        ['痍', 'ショウイグンジンノイ'],
        ['痊', 'セン，ヤマイダレニゼンコクノゼン'],
        ['痕', 'コンセキヲ ノコス ノ コン'],
        ['痔', 'イボジ ノ ジ'],
        ['痒', 'カッカソウヨウノヨウ，カユイ'],
        ['痞', 'ヒ，ヤマイダレニヒテイスルノヒ'],
        ['痙', 'イケイレンノケイ'],
        ['痘', 'テンネントウ ノ トウ'],
        ['痛', 'ズツウ ノ ツウ，イタイ'],
        ['首', 'シュト ノ シュ，クビ'],
        ['扱', 'アツカウ'],
        ['扶', 'フヨウカゾク ノ フ'],
        ['批', 'ヒハンスル ノ ヒ'],
        ['找', 'カ，テヘンニホコヅクリ'],
        ['承', 'ショウダクスル ノ ショウ'],
        ['扼', 'セッシヤクワンノヤク'],
        ['扣', 'コウ，テヘンニクチ'],
        ['扠', 'サ，テヘンニヤシャノシャ'],
        ['鉱', 'テッコウセキ ノ コウ'],
        ['扨', 'サテ，テヘンニヤイバノイタイジ'],
        ['扮', 'フンソウヲコラス ノ フン'],
        ['馴', 'カイナラス ノ ナラス，ジュン'],
        ['打', 'タゲキ ノ ダ，ウツ'],
        ['払', 'カネヲハラウ ノ ハラウ'],
        ['馼', 'ブン，ウマヘンニサクブンノブン'],
        ['扛', 'コウ，テヘンニズガコウサクノコウ'],
        ['托', 'タクハツ ノ タク'],
        ['j', 'ジェイ ジャパン'],
        ['扞', 'カン，テヘンニホス'],
        ['馥', 'フクイクタルノフク，カオリ'],
        ['所', 'ジュウショ ノ ショ，トコロ'],
        ['扁', 'ヘン，ヘンシュウスル，アムノツクリ'],
        ['扇', 'センプウキ ノ セン，オウギ'],
        ['馬', 'ウマ，バシャ ノ バ'],
        ['手', 'テアシ ノ テ，シュ'],
        ['扈', 'チョウリョウバッコノコ'],
        ['扉', 'トビラ，モンピ ノ ヒ'],
        ['扎', 'サツ，テヘンニレイギノレイノツクリ'],
        ['才', 'サイノウ ノ サイ'],
        ['鉦', 'ショウコ ノ ショウ，カネヘン ニ タダシイ'],
        ['姚', 'ヨウ，オンナヘンニイッチョウエンノチョウ'],
        ['姙', 'ニン，ニンシンスルノニンノイタイジ'],
        ['′', 'フン'],
        ['姜', 'ショウガノニモジメ，ヒツジノシタニオンナ'],
        ['姓', 'セイメイハンダン ノ セイ'],
        ['姑', 'コソク ノ コ，シュウトメ'],
        ['姐', 'アネゴハダ ノ アネ'],
        ['委', 'ガッキュウイイン ノ イ'],
        ['始', 'カイシスル ノ シ，ハジメル'],
        ['†', 'ダガー'],
        ['姉', 'アネ，シマイ ノ シ'],
        ['‥', 'テンテン'],
        ['…', 'テンテンテン'],
        ['姆', 'ボ，オンナヘンニハハ'],
        ['姻', 'コンイン ノ イン'],
        ['‐', 'ハイフン'],
        ['姿', 'スガタ，シセイ ノ シ'],
        ['’', 'トジシングル'],
        ['‘', 'シングル'],
        ['”', 'トジクォーテーション'],
        ['姶', 'オンナヘン ニ ゴウカク ノ ゴウ'],
        ['姫', 'オヒメサマ ノ ヒメ'],
        ['姪', 'オイメイ ノ メイ'],
        ['姨', 'イ，オンナヘンニソンノウジョウイノイ'],
        ['釣', 'サカナツリ ノ ツリ'],
        ['姦', 'カシマシイ，オンナミッツ ノ カン'],
        ['姥', 'ウバザクラ ノ ウバ'],
        ['ヽ', 'クリカエシ'],
        ['ー', 'チョウオン'],
        ['ヾ', 'クリカエシダクテン'],
        ['・', 'ナカテン'],
        ['ヵ', 'チイサイ カゾク ノ カ'],
        ['ヴ', 'ウサギ ノ ウニ ダクテン'],
        ['ヶ', 'チイサイ ケシキ ノ ケ'],
        ['ヱ', 'ムカシ ノ エ'],
        ['ヰ', 'ムカシ ノ イ'],
        ['ン', 'オシマイ ノ ン'],
        ['ヲ', 'ヲワリ ノ オ'],
        ['ロ', 'ロウカ ノ ロ'],
        ['レ', 'レモン ノ レ'],
        ['ワ', 'ワカメ ノ ワ'],
        ['ヮ', 'チイサイ ワカメ ノ ワ'],
        ['ラ', 'ラジオ ノ ラ'],
        ['ヨ', 'ヨット ノ ヨ'],
        ['ル', 'ルスバン ノ ル'],
        ['リ', 'リンゴ ノ リ'],
        ['ュ', 'チイサイ ユカタ ノ ユ'],
        ['ヤ', 'ヤカン ノ ヤ'],
        ['ョ', 'チイサイ ヨット ノ ヨ'],
        ['ユ', 'ユカタ ノ ユ'],
        ['メ', 'メガネ ノ メ'],
        ['ム', 'ムシ ノ ム'],
        ['ャ', 'チイサイ ヤカン ノ ヤ'],
        ['モ', 'モミジ ノ モ'],
        ['ポ', 'ポスト ノ ポ'],
        ['ボ', 'ボタン ノ ボ'],
        ['ミ', 'ミカン ノ ミ'],
        ['マ', 'マッチ ノ マ'],
        ['ベ', 'ベルト ノ ベ'],
        ['ヘ', 'ヘイワ ノ ヘ'],
        ['ホ', 'ホケン ノ ホ'],
        ['ペ', 'ペット ノ ペ'],
        ['フ', 'フトン ノ フ'],
        ['ピ', 'ピアノ ノ ピ'],
        ['プ', 'プリント ノ プ'],
        ['ブ', 'ブランコ ノ ブ'],
        ['パ', 'パジャマ ノ パ'],
        ['バ', 'バナナ ノ バ'],
        ['ビ', 'ビール ノ ビ'],
        ['ヒ', 'ヒカリ ノ ヒ'],
        ['ネ', 'ネズミ ノ ネ'],
        ['ヌ', 'ヌリエ ノ ヌ'],
        ['ハ', 'ハガキ ノ ハ'],
        ['ノ', 'ノハラ ノ ノ'],
        ['ド', 'ドレミ ノ ド'],
        ['ト', 'トウキョウ ノ ト'],
        ['ニ', 'ニホン ノ ニ'],
        ['ナ', 'ナマエ ノ ナ'],
        ['ヅ', 'ツヅミ ノ ヅ'],
        ['ツ', 'ツバメ ノ ツ'],
        ['デ', 'デンワ ノ デ'],
        ['テ', 'テガミ ノ テ'],
        ['チ', 'チキュウ ノ チ'],
        ['ダ', 'ダルマ ノ ダ'],
        ['ッ', 'チイサイ ツバメ ノ ツ'],
        ['ヂ', 'ハナヂ ノ ヂ'],
        ['劬', 'ク，ハイクノクニチカラ'],
        ['@', 'アットマーク'],
        ['助', 'キュウジョ ノ ジョ，タスケル'],
        ['努', 'ドリョク ノ ド'],
        ['劫', 'ミライエイゴウ ノ ゴウ'],
        ['加', 'ツイカ ノ カ，クワエル'],
        ['劣', 'オトル，ユウレツ ノ レツ'],
        ['劼', 'カツ，ダイキチノキチニチカラ'],
        ['劾', 'ダンガイスル ノ ガイ'],
        ['効', 'コウカテキ ノ コウ'],
        ['労', 'ロウドウ ノ ロウ'],
        ['劵', 'ケン，ジョウシャケンノケンノカタナノカワリニチカラ'],
        ['励', 'ゲキレイスル ノ レイ，ハゲマス'],
        ['劍', 'ケン，ツルギノキュウジ'],
        ['劈', 'ヘキ，カベノツチノカワリニカタナ'],
        ['劉', 'リュウホウ ノ リュウ'],
        ['劇', 'ニンギョウゲキ ノ ゲキ'],
        ['劃', 'ワカツ，カクゼン ノ カク'],
        ['釟', 'ハツ、カネヘンニカンスウジノハチ'],
        ['功', 'フセイコウ ノ コウ'],
        ['力', 'チカラ，タイリョク ノ リョク'],
        ['劔', 'ケン，ツルギノイタイジ，ツクリガヤイバノイタイジ'],
        ['劑', 'ヤクザイシノザイノキュウジ'],
        ['劒', 'ケン，ツルギノイタイジ，ツクリガカタナニテン'],
        ['鋪', 'カネヘン ノ ホ'],
        ['踊', 'オドル，ブヨウ ノ ヨウ'],
        ['踉', 'ヨロメク，ソウロウノロウ'],
        ['踈', 'カソチノソノイタイジ，アシヘンニヤクソクノソク'],
        ['踏', 'フム，ザットウ ノ トウ'],
        ['踐', 'ジッセンスルノセンノキュウジ'],
        ['釘', 'クギ'],
        ['踟', 'チ，アシヘンニケンチジノチ'],
        ['踞', 'ソンキョスルノキョ，アシヘンニジュウキョノキョ'],
        ['踝', 'クルブシ，カ'],
        ['踪', 'シッソウジケンノソウ'],
        ['踰', 'ユ，アシヘンニニレノキノニレノツクリ'],
        ['踵', 'カカト，ショウ'],
        ['踴', 'オドル，ブヨウノヨウノイタイジ，アシヘンニイサマシイ'],
        ['釁', 'スキマヲイミスルキンゲキノキン'],
        ['釀', 'ジョウゾウスルノジョウ，カモスノキュウジ'],
        ['野', 'ヤサイ ノ ヤ，ノハラ ノ ノ'],
        ['里', 'サトガエリ ノ サト，リ'],
        ['釈', 'シャクホウスル ノ シャク'],
        ['襖', 'ショウジフスマ ノ フスマ'],
        ['襞', 'ヒダ，カベノツチノカワリニコロモ'],
        ['襟', 'エリマキ ノ エリ'],
        ['襄', 'ジョウ，ユズルノキュウジノツクリ'],
        ['襁', 'キョウ、コロモヘンニベンキョウノキョウ'],
        ['襃', 'キヨホウヘンノホウノイタイジ'],
        ['襌', 'タン、コロモヘンニタンジュンノタンノキュウジ'],
        ['襍', 'ザツオンノザツノイタイジ'],
        ['襴', 'キンランドンスノラン'],
        ['襷', 'タスキ'],
        ['襲', 'シュウゲキ ノ シュウ，オソウ'],
        ['襾', 'エ，ブシュノオオイカンムリ'],
        ['西', 'ニシヒガシ ノ ニシ，セイ'],
        ['襤', 'ランルヲマトウノラン'],
        ['襦', 'ジュバンノジュ'],
        ['襠', 'トウ、コロモヘンニベントウノトウノキュウジ'],
        ['襭', 'ケツ，コロモヘンニダイキチノキチニページ'],
        ['襯', 'シン、コロモヘンニオヤコノオヤ'],
        ['襪', 'ベツ，コロモヘンニケイベツスルノベツ'],
        ['鸛', 'トリノコウノトリ，カン'],
        ['鸞', 'シンランショウニンノラン'],
        ['犹', 'ユウ，ケモノヘンニセツゾクシノモットモ'],
        ['状', 'ネンガジョウ ノ ジョウ'],
        ['犲', 'サイ，ケモノヘンニカタカナノオ'],
        ['犯', 'ハンザイ ノ ハン'],
        ['犬', 'イヌ，モウドウケン ノ ケン'],
        ['黠', 'カツ，クロノミギニダイキチノキチ'],
        ['犧', 'ギセイシャノギノキュウジ'],
        ['犢', 'トク，コウシ，ウシヘンニハンバイスルノバイノキュウジ'],
        ['犠', 'ギセイシャ ノ ギ'],
        ['犖', 'ラク，ホタルノキュウジノムシノカワリニドウブツノウシ'],
        ['犒', 'コウ，ウシヘンニタカイヒクイノタカイ'],
        ['犇', 'ホン，ヒシメク，ドウブツノウシミッツ'],
        ['犂', 'レイ，カラスキ'],
        ['犀', 'ドウブツ ノ サイ'],
        ['犁', 'レイ，カラスキノイタイジ'],
        ['遭', 'ソウナンスル ノ ソウ'],
        ['遯', 'トン，シンニョウニトンジルノトン'],
        ['遮', 'シャダンスル ノ シャ，サエギル'],
        ['汎', 'ハンヨウセイ ノ ハン'],
        ['遨', 'ゴウ，シンニョウニゴウマンナノゴウノツクリ'],
        ['求', 'ヨウキュウ ノ キュウ，モトメル'],
        ['汀', 'ミギワ，サンズイ ニ イッチョウメ ノ チョウ'],
        ['汁', 'ミソシル ノ シル，カジュウ ノ ジュウ'],
        ['遡', 'サカノボル，ソジョウスル ノ ソ'],
        ['遠', 'エンソク ノ エン，トオイ'],
        ['遣', 'ハケンスル ノ ケン，ツカワス'],
        ['汚', 'オセン ノ オ，キタナイ'],
        ['遼', 'ゼントリョウエン ノ リョウ，ハルカ'],
        ['避', 'ヒショチ ノ ヒ，サケル'],
        ['汞', 'コウ，ズガコウサクノコウノシタニミズ'],
        ['江', 'エドジダイ ノ エ'],
        ['汝', 'ナンジ，サンズイ ニ オンナ'],
        ['遵', 'ジュンシュスル ノ ジュン，シンニョウ ニ ソンケイ ノ ソン'],
        ['汐', 'チョウセキ ノ セキ，シオ'],
        ['遶', 'ジョウ，シンニョウニギョウシュンノギョウノキュウジ'],
        ['汗', 'アセ，ハッカン ノ カン'],
        ['汕', 'サン，サンズイニヤマ'],
        ['汪', 'オウ，サンズイニオウサマノオウ'],
        ['汨', 'ベキラノベキ，サンズイニヨウビノニチ'],
        ['過', 'カコ ノ カ，スギル'],
        ['遉', 'テイ，シンニョウニテイシュクナノテイ'],
        ['運', 'ウンドウ ノ ウン，ハコブ'],
        ['遊', 'ユウエンチ ノ ユウ，アソブ'],
        ['汢', 'ヌタ，サンズイニツチ'],
        ['池', 'チョスイチ ノ チ，イケ'],
        ['遁', 'トンソウスル ノ トン'],
        ['遂', 'スイコウスル ノ スイ，トゲル'],
        ['決', 'タスウケツ ノ ケツ，キメル'],
        ['遜', 'ケンソンスル ノ ソン'],
        ['遞', 'テイシンショウノテイノキュウジ'],
        ['汾', 'フン，サンズイニハンブンノブン'],
        ['遘', 'コウ，シンニョウニミゾノツクリ'],
        ['汽', 'キテキ ノ キ'],
        ['汲', 'クム，キュウキュウトスル ノ キュウ'],
        ['汳', 'ハン，サンズイニハンタイスルノハン'],
        ['汰', 'シゼントウタ ノ タ'],
        ['遖', 'アッパレ，シンニョウニミナミ'],
        ['遑', 'コウ、シンニョウニコウタイシノコウ'],
        ['遐', 'カ，シンニョウニヒマツブシノヒマノツクリ'],
        ['道', 'ミチ，ドウロ ノ ドウ'],
        ['遒', 'シュウ，シンニョウニシュウチョウサンノシュウ'],
        ['粗', 'ソマツナ ノ ソ，アライ'],
        ['粕', 'サケカス ノ カス，コメヘン ニ シロ'],
        ['粒', 'ツブ，リュウシ ノ リュウ'],
        ['粐', 'ヌカ，コメヘンニトジマリノト'],
        ['粟', 'キビアワ ノ アワ'],
        ['粛', 'ゲンシュクナ ノ シュク'],
        ['粘', 'ネバル，ネンド ノ ネン'],
        ['粂', 'クメ，ヒサシイ ノ シタニ コメ'],
        ['粃', 'シイナ，コメヘンニヒカクスルノヒ'],
        ['粁', 'キョリ ノ タンイ ノ キロメートル'],
        ['粍', 'ナガサ ノ タンイ ノ ミリメートル'],
        ['粋', 'ジュンスイナ ノ スイ，イキ'],
        ['粉', 'フンマツ ノ フン，コナ'],
        ['粲', 'サン，サンゼントカガヤクノサンノツクリ'],
        ['粳', 'ウルチマイノウルチ'],
        ['粱', 'リョウ，リョウザンパクノリョウノキノカワリニコメ'],
        ['精', 'セイシンテキ ノ セイ'],
        ['粽', 'ソウ，チマキ'],
        ['粹', 'ジュンスイナノスイノキュウジ'],
        ['粧', 'オケショウ ノ ショウ'],
        ['粤', 'チュウゴクカントンショウヲイミスルエツ'],
        ['粥', 'オカユ ノ カユ'],
        ['粢', 'シトギ，モクジノジノシタニコメ'],
        ['粡', 'トウ，コメヘンニオナジ'],
        ['粮', 'ショクリョウノリョウ，カテノイタイジ'],
        ['粭', 'スクモ，コメヘンニゴウカクノゴウ'],
        ['粫', 'ウルチ，コメヘンニケイジジョウノジ'],
        ['粨', 'ナガサノタンイノヘクトメートル'],
        ['撥', 'ハネル，ハツ，テヘンニハツメイノハツノキュウジ'],
        ['撤', 'テッタイスル ノ テツ'],
        ['撫', 'アイブスル ノ ブ，ナデル'],
        ['撩', 'リョウランノリョウ，テヘンニドウリョウノリョウノツクリ'],
        ['撮', 'サツエイスル ノ サツ，トル'],
        ['播', 'デンパスル ノ ハ，マク'],
        ['撲', 'ダボク ノ ボク'],
        ['撰', 'チョクセンワカシュウ ノ セン，エラブ'],
        ['撻', 'ベンタツスルノタツ'],
        ['撹', 'カクランスル ノ カク'],
        ['撼', 'シンカンサセルノカン，テヘンニカンソウブンノカン'],
        ['撃', 'コウゲキ ノ ゲキ，ウツ'],
        ['撈', 'ギョロウノロウ，テヘンニロウドウノロウノキュウジ'],
        ['撓', 'フトウフクツノトウ，タワム'],
        ['撒', 'ミズヲマク ノ マク，サン'],
        ['撕', 'シ，テヘンニシカイノケンイノシ'],
        ['鹽', 'シオノキュウジ，エン'],
        ['撚', 'ヒネル，テヘン ニ シゼン ノ ゼン'],
        ['鹿', 'ドウブツ ノ シカ'],
        [
            '鹹',
            'カンスイコノカン，カライ，ロカクノロノミギニハリキュウノハリノツクリ',
        ],
        ['撞', 'ジカドウチャク ノ ドウ，ツク'],
        ['W', 'ダブリュー ウィンドウ'],
        ['×', 'カケル'],
        ['魄', 'ハク，シロヘンニオニ'],
        ['÷', 'ワル'],
        ['奘', 'サンゾウホウシゲンジョウノジョウ'],
        ['奚', 'ケイ，ケイリュウヅリノケイノキュウジノツクリ'],
        ['奕', 'イゴヲイミスルエキ'],
        ['奔', 'ホンソウスル ノ ホン'],
        ['套', 'ジョウトウシュダン ノ トウ'],
        ['契', 'ケイヤクスル ノ ケイ'],
        ['奐', 'カン，カンキセンノカンノツクリ'],
        ['奏', 'エンソウスル ノ ソウ，カナデル'],
        ['奎', 'ケイ，オオキイノシタニツチフタツ'],
        ['奉', 'ホウシカツドウ ノ ホウ，タテマツル'],
        ['奈', 'ナラケン ノ ナ'],
        ['奄', 'アマミオオシマ ノ イチモジメ ノ エン'],
        ['奇', 'キミョウナ ノ キ'],
        ['魎', 'チミモウリョウノリョウ'],
        ['好', 'ダイスキ ノ スキ，コウ'],
        ['奸', 'カン，オンナヘンニホス'],
        ['奴', 'ドレイ ノ ド，ヤツ'],
        ['女', 'オンナ，ジョシ ノ ジョ'],
        ['奬', 'ショウガクキンノショウノキュウジ'],
        ['奮', 'コウフン ノ フン，フルウ'],
        ['奩', 'レン，ハコ，オオキイノシタニクベツノクノキュウジ'],
        ['奨', 'ショウガクキン ノ ショウ'],
        ['奪', 'ウバウ，リャクダツ ノ ダツ'],
        ['奥', 'オクバ ノ オク'],
        ['奧', 'オクバノオクノキュウジ'],
        ['奠', 'オコウデンノデン，シュウチョウノシュウノシタニオオキイ'],
        ['奢', 'ゴウシャノシャ，オゴリ'],
        ['肭', 'ドツ，ニクヅキニコクナイノナイ'],
        ['肬', 'イボ，ユウ，ニクヅキニモットモ'],
        ['肯', 'コウテイヒテイ ノ コウ'],
        ['肩', 'カタコリ ノ カタ，ケン'],
        ['肪', 'シボウブン ノ ボウ'],
        ['肥', 'ヒマン ノ ヒ，コエル'],
        ['股', 'コカンセツ ノ コ，マタ'],
        ['肢', 'センタクシ ノ シ'],
        ['ﾙ', 'ルスバン ノ ル'],
        ['肺', 'ハイカツリョウ ノ ハイ'],
        ['肴', 'シュコウ ノ コウ，サカナ'],
        ['肱', 'ココウノシン ノ コウ，ヒジ'],
        ['育', 'キョウイク ノ イク，ソダテル'],
        ['肌', 'ハダイロ ノ ハダ'],
        ['肉', 'ギュウニク ノ ニク'],
        ['ﾜ', 'ワカメ ノ ワ'],
        ['肋', 'ロクマクエン ノ ロク'],
        ['肅', 'ゲンシュクナノシュクノキュウジ'],
        ['肄', 'イ，ギモンノギノヒダリガワニフデヅクリ'],
        ['肇', 'クニヲハジメル ノ ハジメ，チョウ'],
        ['肆', 'シ，ケイヤクショニツカウスウジノヨン'],
        ['-', 'マイナス'],
        ['肝', 'カンゾウ ノ カン，キモ'],
        ['肘', 'ヒジ，ニクヅキニスンポウ ノ スン'],
        ['肛', 'オシリノコウモンノコウ'],
        ['肚', 'ズ，ニクヅキニドヨウビノド'],
        ['肖', 'ショウゾウガ ノ ショウ'],
        ['肓', 'ヤマイコウコウノウシロノコウ'],
        ['ﾑ', 'ムシ ノ ム'],
        ['ﾗ', 'ラジオ ノ ラ'],
        ['ﾊ', 'ハガキ ノ ハ'],
        ['ﾉ', 'ノハラ ノ ノ'],
        ['躅', 'チョク，アシヘンニサンゴクシノショク'],
        ['躄', 'ヘキ，カベノツチノカワリニテアシノアシ'],
        ['躇', 'チュウチョスルノチョ'],
        ['躁', 'ソウウツビョウノソウ'],
        ['躍', 'カツヤクスル ノ ヤク'],
        ['躋', 'セイ，アシヘンニヘソノツクリ'],
        ['躊', 'チュウチョスルノチュウ'],
        ['躔', 'テン，アシヘンニマトウノツクリ'],
        ['躑', 'テキ，アシヘンニトウテキキョウギノテキノツクリ'],
        ['躓', 'ツマズク，チ'],
        ['躙', 'ジュウリンスルノリン'],
        ['躡', 'ジョウ、アシヘンニミミミッツ'],
        ['躬', 'キュウ、ミヘンニユミ'],
        ['躯', 'タイク ノ ク，ミ'],
        ['身', 'シンチョウタイジュウ ノ シン，ミ'],
        ['躪', 'ジュウリンスルノリンノイタイジ'],
        ['躱', 'タ、ミヘンニジダノジ'],
        ['躰', 'タイ，ミヘンニホンモノノホン'],
        ['躾', 'シツケ、ミヘンニウツクシイ'],
        ['遅', 'オソイ，チコク ノ チ'],
        ['雲', 'クモノウエ ノ クモ，ウン'],
        ['瑯', 'ホウロウナベノロウ，オウヘンニモモタロウノロウ'],
        ['瑪', 'メノウノメ'],
        ['瑩', 'ホタルノキュウジノムシノカワリニタマ'],
        ['瑤', 'ヨウ，オウヘンニユレルノツクリノキュウジ'],
        ['瑣', 'ハンサナテツヅキノサ'],
        ['瑠', 'ルリイロ ノ ル'],
        ['瑾', 'キン，キズヲイミスルカキンノキン'],
        ['瑶', 'ヨウ，オウヘンニユレルノツクリ'],
        ['瑳', 'セッサタクマ ノ サ，オウヘン ニ サ'],
        ['瑰', 'オウヘンニオニ'],
        ['瑁', 'ドウブツノタイマイノマイ'],
        ['瑟', 'キンシツアイワスノシツ'],
        ['瑞', 'ズイウン ノ ズイ，シルシ'],
        ['瑜', 'ユ，オウヘンニニレノキノニレノツクリ'],
        ['瑛', 'オウヘン ニ エイゴ ノ エイ'],
        ['瑚', 'サンゴショウ ノ ゴ'],
        ['瑙', 'メノウノノウ'],
        ['瑕', 'キズヲイミスルカシノカ'],
        ['援', 'オウエンスル ノ エン'],
        ['揶', 'ヤユスルノヤ'],
        ['餝', 'ショク，カザルノイタイジ，ショクヘンニホウコウザイノホウ'],
        ['餘', 'ヨユウノヨ，アマルノキュウジ'],
        ['餔', 'ホ，クラウ，ショクヘンニシジンノトホノホ'],
        ['餒', 'ダイ，ショクヘンニダキョウスルノダ，ウエル'],
        ['餓', 'ガシスル ノ ガ，ウエル'],
        ['揺', 'ユレル，ドウヨウスル ノ ヨウ'],
        ['餌', 'エサ，エヅケ ノ エ'],
        ['養', 'エイヨウ ノ ヨウ，ヤシナウ'],
        ['握', 'アクリョク ノ アク，ニギル'],
        ['揣', 'シマオクソクノシ，テヘンニタンマツノタンノツクリ'],
        ['揮', 'シキスル ノ キ'],
        ['餅', 'モチツキ ノ モチ'],
        ['揩', 'カイ，テヘンニミナサマノミナ'],
        ['餾', 'リュウ，ムス，ショクヘンニリュウガクノリュウ'],
        ['揖', 'イチユウ ノ ユウ，テヘン ニ クチ ノ シタニ ミミ'],
        ['餽', 'キ，マツル，ショクヘンニオニ'],
        ['提', 'テイアン ノ テイ'],
        ['雅', 'ユウガ ノ ガ，ミヤビ'],
        ['插', 'ソウニュウスルノソウ，サスノキュウジ'],
        ['揚', 'アゲル，カラアゲ'],
        ['換', 'カンキセン ノ カン，カエル'],
        ['揄', 'ヤユスルノユ'],
        ['雋', 'フルトリノシタニオウトツノオウノシタ１カクヲトッタモノ'],
        ['揆', 'ヒャクショウイッキノキ'],
        ['揀', 'カン，テヘンニサカナノニシンノツクリ'],
        ['館', 'トショカン ノ カン'],
        ['揃', 'ソロエル'],
        ['餤', 'タン，クラウ，ショクヘンニホノオ'],
        ['描', 'エガク，ビョウシャスル ノ ビョウ'],
        ['揉', 'モム，テヘンニジュウドウノジュウ'],
        ['餠', 'モチツキノモチノキュウジ'],
        ['餡', 'クズアンノアン'],
        ['雖', 'イエドモ'],
        ['淌', 'ショウ，サンズイニオショウサンノショウ'],
        ['釶', 'シ、カネヘンニクウヤネンブツノヤ'],
        ['釵', 'サイ、カネヘンニヤシャノシャ'],
        ['淋', 'サビシイ，サンズイ ニ ハヤシ'],
        ['釿', 'ギン、カネヘンニパンイッキンノキン'],
        ['淅', 'セキ，サンズイニブンセキスルノセキ'],
        ['淆', 'ギョクセキコンコウノコウ'],
        ['淇', 'キ，サンズイニキホンノキカラツチヲトッタカタチ'],
        ['淀', 'ヨドガワ ノ ヨド'],
        ['釧', 'クシロ，コンセンゲンヤ ノ セン'],
        ['釦', 'イフク ノ ボタン'],
        ['淞', 'ショウ，サンズイニマツノキノマツ'],
        ['淘', 'シゼントウタ ノ トウ'],
        ['淙', 'ソウ，サンズイニシュウキョウカイカクノシュウ'],
        ['釡', 'カマメシノカマノイタイジ'],
        ['淕', 'リク，サンズイニリクジョウノリクノツクリ'],
        ['淑', 'シュクジョ ノ シュク'],
        ['淒', 'セイ，サンズイニツマオットノツマ'],
        ['淬', 'サイ，サンズイニソツギョウノソツ'],
        ['釖', 'トウ、カネヘンニカタナ'],
        ['淮', 'ワイガノワイ，サンズイニフルトリ'],
        ['淨', 'ジョウスイキノジョウノキュウジ'],
        ['淪', 'リン，サンズイニケツロンノロンノツクリ'],
        ['淫', 'インラン ノ イン，ミダラ'],
        ['淤', 'オケツノオ，トドコオル'],
        ['淦', 'カン，サンズイニキンヨウビノキン'],
        ['釜', 'カマメシ ノ カマ'],
        ['釛', 'コク，カネヘンニチカラ'],
        ['淡', 'タンスイギョ ノ タン，アワイ'],
        ['n', 'エヌ ノベンバー'],
        ['采', 'ハクシュカッサイ ノ サイ'],
        ['釆', 'ハン，バンゴウ ノ バン カラ タ ヲ トッタ ジ'],
        ['淹', 'エン，サンズイニアマミオオシマノイチモジメ'],
        ['淺', 'アサイノキュウジ'],
        ['添', 'ソエル，テンプスル ノ テン'],
        ['量', 'コウスイリョウ ノ リョウ，ハカル'],
        ['淵', 'ミズガ ヨドンデ フカイ フチ'],
        ['重', 'タイジュウ ノ ジュウ，オモイ'],
        ['混', 'コンザツ ノ コン'],
        ['釋', 'シャクホウスルノシャクノキュウジ'],
        ['深', 'シンコクナ ノ シン，フカイ'],
        ['釉', 'ユウヤクノユウ，ウワグスリ'],
        ['淳', 'ジュン，サンズイ ニ キョウラクテキナ ノ キョウ'],
        ['副', 'フクカイチョウ ノ フク'],
        ['制', 'セイゲンスル ノ セイ'],
        ['刷', 'インサツ ノ サツ，スル'],
        ['刳', 'クリヌクノクル，コ'],
        ['到', 'トウチャクスル ノ トウ，イタル'],
        ['刺', 'シゲキスル ノ シ，サス'],
        ['刻', 'ジコク ノ コク，キザム'],
        ['券', 'ジョウシャケン ノ ケン'],
        ['刹', 'セツナテキナノナ'],
        ['刧', 'ミライエイゴウノゴウノイタイジ'],
        ['判', 'ハンダン ノ ハン'],
        ['別', 'トクベツ ノ ベツ，ワカレル'],
        ['刮', 'カツモクスルノカツ'],
        ['刪', 'サン，ケズル，イッサツニサツノサツノミギニリットウ'],
        ['利', 'ケンリ ノ リ'],
        ['列', 'ギョウレツ ノ レツ'],
        ['刔', 'ケツ，エグル，タスウケツノケツノツクリノミギニリットウ'],
        ['刑', 'ケイムショ ノ ケイ'],
        ['初', 'サイショ ノ ショ，ハジメテ'],
        ['分', 'ハンブン ノ ブン，ワケル'],
        ['切', 'タイセツ ノ セツ，キル'],
        ['刄', 'ハモノノハ，ヤイバノイタイジ'],
        ['刃', 'ハモノ ノ ハ，ヤイバ'],
        ['刀', 'カタナ，ニホントウ ノ トウ'],
        ['刎', 'フンケイノマジワリノフン'],
        ['刊', 'シュウカンシ ノ カン'],
        ['刋', 'セン，カタカナノチノミギニリットウ'],
        ['刈', 'クサカリ ノ カリ，カル'],
        ['軟', 'ジュウナン ノ ナン，ヤワラカ'],
        ['項', 'コウモク ノ コウ，キョウツウコウ ノ コウ'],
        ['D', 'ディー デスク'],
        ['觜', 'クチバシ，シ，ヒガンシガンノシノシタニツノ'],
        ['觝', 'テイ，ツノヘンニテイコウスルノテイノツクリ'],
        ['觚', 'コ，ツノヘンニウリ'],
        ['角', 'カクド ノ カク，ツノ'],
        ['觀', 'カンキャクノカン，ミルノキュウジ'],
        ['觸', 'セッショクスルノショク，フレルノキュウジ'],
        ['觴', 'ショウ、ツノヘンニキリキズノキズノツクリ'],
        ['触', 'セッショクスル ノ ショク，フレル'],
        ['觧', 'カイ，ツノヘンニヒツジ'],
        ['解', 'カイケツスル ノ カイ'],
        ['脳', 'ズノウ ノ ノウ'],
        ['脱', 'ヌグ，ダツボウ ノ ダツ'],
        ['脾', 'ゾウキノヒゾウノヒ'],
        ['脹', 'ボウチョウスル ノ チョウ，ニクヅキニナガイ'],
        ['脣', 'シン，クチビル，ジュウニシノタツノシタニニクヅキ'],
        ['脯', 'ホ，ニクヅキニシジンノトホノホ'],
        ['脩', 'ソクシュウヲオサメルノシュウ'],
        ['脛', 'ケイ，スネ，ニクヅキニケイツイノケイノヒダリガワ'],
        ['脚', 'キャクホン ノ キャク，アシ'],
        ['脇', 'ワキヤク ノ ワキ'],
        ['脆', 'ゼイジャクナ ノ ゼイ，モロイ'],
        ['脅', 'キョウハク ノ キョウ，オドス'],
        ['脂', 'シボウ ノ シ，アブラ'],
        ['脊', 'セキズイ ノ セキ'],
        ['脉', 'サンミャクノミャクノイタイジ，ニクヅキニエイキュウノエイ'],
        ['脈', 'サンミャク ノ ミャク'],
        ['缸', 'コウ，ホトギヘンニズガコウサクノコウ'],
        ['缺', 'ホケツノケツ，カケルノキュウジ'],
        ['缶', 'カンヅメ ノ カン'],
        ['搦', 'カラメテノカラメ，テヘンニキョウジャクノジャク'],
        ['搭', 'トウジョウテツヅキ ノ トウ'],
        ['搬', 'ハンニュウスル ノ ハン'],
        ['搨', 'トウ，テヘンニニチヨウビノニチノシタニハネ'],
        ['搴', 'ケン，サムイノシタニテンノカワリニテ'],
        ['搶', 'ソウ，テヘンニカマクラバクフノクラ'],
        ['搾', 'サクシュ ノ サク，シボル'],
        ['携', 'ケイタイ ノ ケイ，タズサエル'],
        ['搆', 'コウ，テヘンニミゾノツクリ'],
        ['損', 'ソンガイ ノ ソン'],
        ['搏', 'ミャクハクノハク，テヘンニハクブツカンノハクノツクリ'],
        ['搗', 'モチツキノツキ'],
        ['搖', 'ユレル，ドウヨウスルノヨウノキュウジ'],
        ['搓', 'サ，テヘンニサベツカスルノサ'],
        ['搜', 'ソウサジョウノソウ，サガスノキュウジ'],
        ['瓱', 'ミリグラム，カワラニウモウノモウ'],
        ['瓰', 'デシグラム，カワラニハンブンニスルノブン'],
        ['瓲', 'トン，カワラニチュウトンスルノトン'],
        ['瓷', 'シ，カワラノウエニモクジノジ'],
        ['瓶', 'アキビン ノ ビン'],
        ['瓸', 'ヘクトグラム，カワラニカンスウジノヒャク'],
        ['瓠', 'コ，ヒサゴ，ハカマノツクリニウリ'],
        ['瓣', 'ハナビラノベンノキュウジ'],
        ['瓢', 'ヒョウタン ノ ヒョウ，ヒサゴ'],
        ['瓧', 'デカグラム，カワラニカンスウジノジュウ'],
        ['瓦', 'レンガ ノ ガ，カワラ'],
        ['瓩', 'キログラム，カワラニカンスウジノセン'],
        ['瓮', 'オウ，オオヤケノシタニカワラ'],
        ['瓔', 'ヨウ，オウヘンニサクラノキュウジノツクリ'],
        ['瓜', 'ウリ，スイカ ノ カ'],
        ['瓊', 'ケイ，ヤサカニノマガタマノニ'],
        ['瓏', 'レイロウタルノロウ，オウヘンニキョウリュウノリュウノキュウジ'],
        ['隠', 'インキョスル ノ イン，カクレル'],
        ['隣', 'トナリ，リンジン ノ リン'],
        ['捺', 'ナツインスル ノ ナツ'],
        ['捻', 'ネンザ ノ ネン，ヒネル'],
        ['隧', 'トンネルヲイミスルスイドウノスイ'],
        ['捶', 'スイ，テヘンニスイチョクノスイ'],
        ['捷', 'ビンショウナ ノ ショウ'],
        ['險', 'ボウケンカノケンノキュウジ'],
        ['捲', 'マクル，ケンドジュウライ ノ ケン'],
        ['据', 'スエル，スエオキ ノ スエ'],
        ['隱', 'イン、カクレルノキュウジ'],
        ['隲', 'シツ、コザトヘンニスコシノシタニバシャノバ'],
        ['隴', 'リョウ、コザトヘンニキョウリュウノリュウノキュウジ'],
        ['捫', 'モン，テヘンニセンモンノモン'],
        ['捨', 'シシャゴニュウ ノ シャ，ステル'],
        ['捩', 'レイ，ネジル，テヘンニモドル'],
        ['隸', 'レイ、ドレイカイホウノレイノキュウジ'],
        ['捧', 'ササゲル，ホウ'],
        ['隻', 'フネイッセキ ノ セキ'],
        ['隼', 'トリ ノ ハヤブサ'],
        ['捜', 'ソウサジョウ ノ ソウ，サガス'],
        ['隅', 'ヨスミ ノ スミ，グウ'],
        ['隆', 'リュウキスル ノ リュウ'],
        ['隈', 'クマ，カイワイ ノ ワイ'],
        ['捗', 'シンチョクジョウキョウ ノ チョク，ハカドル'],
        ['隊', 'グンタイ ノ タイ'],
        ['捕', 'タイホスル ノ ホ，トラエル'],
        ['隍', 'コウ、コザトヘンニコウタイシノコウ'],
        ['捐', 'ギエンキンノエン，テヘンニキヌイトノキヌノツクリ'],
        ['随', 'ズイヒツ ノ ズイ'],
        ['捏', 'ネツゾウスルノネツ，コネル'],
        ['捌', 'ウリサバク ノ サバク，テヘン ニ ワカレル'],
        ['捍', 'カン，テヘンニヒデリヲイミスルカンバツノカン'],
        ['隔', 'カンカク ノ カク，ヘダタリ'],
        ['隕', 'インセキノイン、オチル'],
        ['捉', 'トラエル，テヘン ニ アシ'],
        ['隘', 'アイロノアイ、セマイ'],
        ['隙', 'スキマ ノ スキ，ゲキ'],
        ['際', 'ジッサイ ノ サイ'],
        ['障', 'ショウガイブツ ノ ショウ'],
        ['↓', 'シタヤジルシ'],
        ['壥', 'ツチヘンニガンダレニボクジュウノボクノキュウジ'],
        ['壤', 'ドジョウカイリョウノジョウノキュウジ'],
        ['壯', 'ソウダイナノソウノキュウジ'],
        ['壮', 'ソウダイナ ノ ソウ'],
        ['壬', 'ジンシンノラン ノ ジン'],
        ['士', 'ベンゴシ ノ シ'],
        ['壷', 'オモウツボ ノ ツボ'],
        ['売', 'ショウバイ ノ バイ，ウル'],
        ['壱', 'ケイヤクショニ ツカウ スウジ ノ イチ'],
        ['声', 'コエ，オンセイ ノ セイ'],
        ['[', 'カクカッコ'],
        ['壼', 'コン，サムライノシタニワカンムリ，アネッタイノアノキュウジ'],
        ['壻', 'ハナムコノムコノイタイジ，ツチヘン'],
        ['壺', 'オモウツボノツボノセイジ'],
        ['壹', 'ケイヤクショノツカウスウジイチノキュウジ'],
        ['壇', 'ブツダン ノ ダン'],
        ['壅', 'ヨウ，ヨウリツスルノヨウノツクリノシタニツチ'],
        ['壁', 'ヘキガ ノ ヘキ，カベ'],
        ['壌', 'ドジョウカイリョウ ノ ジョウ'],
        ['壊', 'ハカイ ノ カイ，コワス'],
        ['⌒', 'コキゴウ'],
        ['壗', 'ママ，ツチヘンニワガママノママノツクリ'],
        ['壕', 'ボウクウゴウ ノ ゴウ'],
        ['壓', 'アツリョクノアツノキュウジ'],
        ['壑', 'タニヲイミスルガク'],
        ['(', 'カッコ'],
        ['壟', 'ロウ，キョウリュウノリュウノキュウジノシタニツチ'],
        ['壞', 'コワス，ハカイノカイノキュウジ'],
        ['壜', 'ビン，ツチヘンニクモリ'],
        ['壙', 'コウ，ツチヘンニヒロバノヒロノキュウジ'],
        ['壘', 'ルイセキスルノルイノキュウジ'],
        ['冽', 'リンレツノレツ，ニスイニギョウレツノレツ'],
        ['冰', 'ヒョウガノヒョウ，コオリノイタイジ，ニスイ'],
        ['冱', 'コ，ニスイニゴカクノゴ'],
        ['冲', 'チュウ，ニスイニチュウガッコウノチュウ'],
        ['决', 'タスウケツノケツ，キメルノイタイジ，ニスイ'],
        ['冴', 'メガサエル ノ サエル'],
        ['况', 'ジッキョウチュウケイノキョウノイタイジ，ニスイ'],
        ['冶', 'ヤキンガク ノ ヤ'],
        ['冷', 'レイトウ ノ レイ，ツメタイ'],
        ['冨', 'フジサン ノ フ ノ イタイジ，ワカンムリ'],
        ['冩', 'シャシンノシャ，ウツスノキュウジノイタイジ，ワカンムリ'],
        ['冪', 'ベキ，ワカンムリニジマクノマク'],
        ['冫', 'ヒョウ，ブシュノニスイ'],
        ['冬', 'フユヤスミ ノ フユ，トウ'],
        ['冠', 'カンムリ，エイカン ノ カン'],
        ['冢', 'チョウ，カイヅカノツカノモトノジ'],
        ['冤', 'エンザイヲハラスノエン'],
        ['冥', 'メイフクヲ イノル ノ メイ'],
        ['冦', 'モウコシュウライノゲンコウノコウノイタイジ'],
        ['写', 'シャシン ノ シャ，ウツス'],
        ['冐', 'ボウケンカノボウノイタイジ'],
        ['冑', 'カッチュウノチュウ，カブト'],
        ['冒', 'ボウケンカ ノ ボウ'],
        ['冓', 'コウ，ミゾノツクリ'],
        ['冕', 'ベン，カンムリ'],
        ['冖', 'ベキ，ブシュノワカンムリ'],
        ['冗', 'ジョウダンヲイウ ノ ジョウ'],
        ['冉', 'ゼン，フタタビカライッカクメヲトッタカタチ'],
        ['冊', 'イッサツニサツ ノ サツ'],
        ['册', 'イッサツニサツノサツノキュウジ'],
        ['再', 'フタタビ，サイ'],
        ['冏', 'ケイ，ドウガマエニカタカナノルトロ'],
        ['冀', 'キ，キタノシタニコトナル'],
        ['冂', 'ケイ，ブシュノドウガマエ'],
        ['内', 'コクナイ ノ ナイ，ウチ'],
        ['円', 'ヒャクエンダマ ノ エン'],
        ['輌', 'リョウ、クルマヘンニリョウテノリョウ'],
        ['輊', 'チ、クルマヘンニゲシトウジノシ'],
        ['載', 'レンサイ ノ サイ，ノセル'],
        ['輅', 'ロ、クルマヘンニカクジノカク'],
        ['較', 'ヒカクテキ ノ カク'],
        ['輟', 'テツ、クルマヘンニツヅルノツクリ'],
        ['輝', 'カガヤク，キ'],
        ['輜', 'シチョウヘイノシ'],
        ['輛', 'リョウ、クルマヘンニリョウテノリョウノキュウジ'],
        ['輙', 'チョウ，クルマヘンニウケトルノトル'],
        ['輕', 'カルイオモイノカルイノキュウジ'],
        ['輔', 'クルマヘン ノ ホサ ノ ホ'],
        ['輓', 'バン，クルマヘンニメンキョノメン'],
        ['輒', 'チョウ，クルマヘンニミミニオツ'],
        ['輯', 'ヘンシュウ ノ シュウ，クルマヘン ニ クチニ ミミ'],
        ['輪', 'シャリン ノ リン，ワ'],
        ['輩', 'センパイ コウハイ ノ ハイ'],
        ['輦', 'ホウレンノレン、オットフタツノシタニクルマ'],
        ['1', 'イチ'],
        ['輾', 'テン、クルマヘンニハッテンノテン'],
        ['輻', 'フク、クルマヘンニシュクフクノフクノツクリ'],
        ['輹', 'フク、クルマヘンニオウフクスルノフクノツクリ'],
        ['輸', 'ユニュウ ノ ユ'],
        ['輳', 'ソウ、クルマヘンニカナデル'],
        ['虧', 'キ，トラガシラニフルトリミギニオセンスルノオノツクリ'],
        ['虫', 'ムシ，コンチュウ ノ チュウ'],
        ['虱', 'シラミ，カゼノイッカクメヲトッタモノ'],
        ['虹', 'ニジ，ナナイロ ノ ニジ'],
        ['虻', 'アブハチトラズ ノ アブ'],
        ['虍', 'コ，ブシュノトラガシラ'],
        ['虎', 'トラ，モウコ ノ コ'],
        ['虐', 'ギャクタイ ノ ギャク，シイタゲル'],
        ['虔', 'ケイケンナイノリノケン'],
        ['處', 'ショブンスルノショノキュウジ'],
        ['虚', 'キョエイシン ノ キョ'],
        ['虜', 'ホリョ ノ リョ，トリコ'],
        ['虞', 'グビジンソウ ノ グ'],
        ['號', 'バンゴウノゴウノキュウジ'],
        ['酸', 'サンソ ノ サン'],
        ['浜', 'スナハマ ノ ハマ'],
        ['酲', 'テイ，ジュウニシノトリノミギニゾウテイスルノテイ'],
        ['浚', 'シュセツスルノシュン'],
        ['酷', 'ザンコク ノ コク，ヒドイ'],
        ['浙', 'セッコウショウノセツ，サンズイニコッセツスルノセツノツクリ'],
        ['酩', 'メイテイスルノメイ'],
        ['浄', 'ジョウスイキ ノ ジョウ'],
        ['浅', 'アサイ フカイ ノ アサイ'],
        ['酬', 'ホウシュウ ノ シュウ'],
        ['流', 'リュウコウ ノ リュウ，ナガス'],
        ['酣', 'カン，ジュウニシノトリノミギニアマイ'],
        ['酢', 'スノモノ ノ ス'],
        ['酥', 'ソ，ジュウニシノトリノミギニノギヘンノノギ'],
        ['海', 'ウミ，カイガイ ノ カイ'],
        ['浴', 'ニュウヨクスル ノ ヨク，アビル'],
        ['酒', 'サケ，ニホンシュ ノ シュ'],
        ['酔', 'ヨウ，デイスイ ノ スイ'],
        ['浸', 'シントウスル ノ シン，ヒタス'],
        ['浹', 'ショウ，サンズイニセマイノキュウジノツクリ'],
        ['浦', 'ツツウラウラ ノ ウラ'],
        ['浤', 'コウ，サンズイニウカンムリニカタカナノナトム'],
        ['酊', 'メイテイスルノテイ'],
        ['配', 'ハイタツ ノ ハイ，クバル'],
        ['浣', 'カンチョウスルノカン，サンズイニカンリョウスルノカン'],
        ['酎', 'イモジョウチュウ ノ チュウ'],
        ['浮', 'フリョク ノ フ，ウク'],
        ['浬', 'タンイ ノ カイリ，サンズイ ニ サト'],
        ['浪', 'ロウヒスル ノ ロウ'],
        ['浩', 'コウゼン ノ コウ，サンズイ ニ ツゲル'],
        ['羣', 'グンシュウノグン，ムレルノイタイジ'],
        ['群', 'グンシュウ ノ グン，ムレ'],
        ['羨', 'センボウスル ノ セン，ウラヤム'],
        ['義', 'ギム ノ ギ'],
        ['羮', 'ミズヨウカンノカン，アツモノノイタイジ'],
        ['羯', 'ガッキノカッコノカツ'],
        ['羲', 'チュウゴクノデンセツジョウノテンシ，フクギノギ'],
        ['丼', 'ドンブリ'],
        ['羶', 'セン，ヒツジヘンニブツダンノダンノツクリ'],
        ['羸', 'ルイジャクノルイ'],
        ['羹', 'ミズヨウカンノカン，アツモノ'],
        ['羽', 'ハネ，ウモウ ノ ウ'],
        ['羂', 'ケン，アミガシラニキヌイトノキヌ'],
        ['羃', 'ベキ，アミガシラニジマクノマク'],
        ['羆', 'ヒグマ，アミガシラニクマ'],
        ['羇', 'キ，アミガシラニカクメイノカクニキミョウナノキ'],
        ['羅', 'モウラスル ノ ラ'],
        ['羊', 'ヨウモウ ノ ヨウ，ヒツジ'],
        ['羈', 'キビセイサクノキ'],
        ['美', 'ビジン ノ ビ，ウツクシイ'],
        [
            '羌',
            'チュウゴクホクセイブミンゾクノヒトツ，キョウ，ヒツジノシタニヒトアシ',
        ],
        ['羔', 'コウ，コヒツジ，ヒツジノシタニレンガ'],
        ['羚', 'レイ，ヒツジヘンニメイレイスルノレイ'],
        ['羞', 'シュウチシンノシュウ'],
        ['羝', 'テイ，オヒツジ，ヒツジヘンニテイコウスルノテイノツクリ'],
        ['斯', 'シカイ ノ ケンイ ノ シ，カク'],
        ['断', 'ハンダン ノ ダン'],
        ['斬', 'ザンシンナ ノ ザン，キル'],
        ['斫', 'シャク，イシヘンニパンイッキンノキン'],
        ['齔', 'シン，ハノキュウジノミギニカタカナノヒ'],
        ['斧', 'ドウグ ノ オノ'],
        ['斥', 'ハイセキスル ノ セキ，シリゾケル'],
        ['斤', 'ショクパンイッキン ノ キン'],
        ['斡', 'アッセンスル ノ アツ'],
        ['施', 'シセツ ノ シ，ホドコス'],
        ['於', 'ナニナニニオイテ ノ オ'],
        ['方', 'オヤカタ ノ カタ，ホウガク ノ ホウ'],
        ['斷', 'ダンネンスルノダンノキュウジ'],
        ['齋', 'ショサイノサイノキュウジ'],
        ['齊', 'イッセイシャゲキノセイノキュウジ'],
        ['齏', 'ナマスヲイミスルセイ'],
        ['新', 'アタラシイ，シンブン ノ シン'],
        ['斎', 'ショサイニコモル ノ サイ'],
        ['斌', 'ヒン，ブンブリョウドウ ノ ブント ブ'],
        ['斉', 'イッセイシャゲキ ノ セイ'],
        ['斈', 'マナブ，ガクシュウノガクノイタイジ'],
        ['文', 'サクブン ノ ブン'],
        ['斃', 'ノタレジニヲイミスルヘイシノヘイ'],
        ['斂', 'イッテンニシュウレンスルノレン'],
        ['斟', 'シンシャクスルノシン，クム'],
        ['齠', 'チョウ，ハノキュウジノミギニショウシュウレイジョウノショウ'],
        ['齣', 'コマ，ハノキュウジノミギニハイクノク'],
        ['斜', 'ナナメ，シャメン ノ シャ'],
        ['斛', 'ヨウリョウノタンイノコク，ツノヘンニタンイノト'],
        ['料', 'リョウリスル ノ リョウ'],
        ['齦', 'ギン，ハグキ'],
        ['斗', 'ホクトシチセイ ノ ト'],
        ['齪', 'アクセクスルノセク，ハノキュウジノミギニアシ'],
        ['齬', 'ソゴヲキタスノゴ'],
        ['斑', 'マダラ，ハンテン ノ ハン'],
        ['斐', 'ヒ，カイノクニ ノ ニモジメ'],
        ['剄', 'ケイドウミャクノケイノヒダリガワニリットウ'],
        ['並', 'ナミキ ノ ナミ，ナラブ'],
        ['不', 'フシギ ノ フ'],
        ['下', 'ジョウゲ ノ ゲ，シタ'],
        ['塩', 'ショクエン ノ エン，シオ'],
        ['填', 'ジュウテンスル ノ テン，ハメル'],
        ['H', 'エイチ ホテル'],
        ['塢', 'オ，ツチヘンニウゴウノシュウノウ'],
        ['塹', 'ザンゴウノザン'],
        ['塾', 'ガクシュウジュク ノ ジュク'],
        ['塰', 'アマ，ウミノシタニツチ'],
        ['塲', 'バショノバノイタイジ'],
        ['塵', 'フンジン ノ ジン，チリ'],
        ['塋', 'エイ，ハカ，エイギョウノエイノキュウジノロノカワリニツチ'],
        ['塊', 'ダンカイ ノ カイ，カタマリ'],
        ['塁', 'マンルイ ノ ルイ'],
        ['塀', 'ヘイ，イタベイ ノ ヘイ'],
        ['塙', 'ハナワ，ツチヘン ニ タカイ'],
        ['塘', 'トウ，ツチヘン ニ ケントウシ ノ トウ'],
        ['塚', 'ツカ，カイヅカ ノ ツカ'],
        ['塞', 'ノウコウソク ノ ソク，フサガル'],
        ['塑', 'カソセイ ノ ソ'],
        ['塒', 'ジ，ネグラ，ツチヘンニニチジノジ'],
        ['塔', 'ゴジュウ ノ トウ'],
        ['塗', 'トソウ ノ ト，ヌル'],
        ['膸', 'セキズイノズイノイタイジ'],
        ['膺', 'ケンケンフクヨウノヨウ'],
        ['膽', 'ダイタンナノタンノキュウジ'],
        ['膿', 'カノウスル ノ ノウ，ウミ'],
        ['膾', 'ジンコウニカイシャスルノカイ，ナマス'],
        ['膰', 'ハン，ニクヅキニバンゴウノバン'],
        ['膳', 'アゲゼンスエゼン ノ ゼン'],
        ['膵', 'スイゾウノスイ'],
        ['膩', 'ジ，ニクヅキニケイヤクショニツカウカンスウジノニノキュウジ'],
        ['膨', 'ボウチョウスル ノ ボウ，フクラム'],
        ['膠', 'コウゲンビョウノコウ，ニカワ'],
        ['膣', 'チツ，ニクヅキニチッソノチツ'],
        ['膤', 'ユキ，ニクヅキニユキグニノユキ'],
        ['膚', 'ヒフ ノ フ，ハダ'],
        ['膝', 'ヒザマクラ ノ ヒザ'],
        ['膜', 'モウマク ノ マク'],
        ['膓', 'チョクチョウノチョウノイタイジ，ニクヅキニキリキズノキズノツクリ'],
        ['膕', 'カク，ニクヅキニユキグニノクニノキュウジ'],
        ['膈', 'カク，ニクヅキニヘダテルノツクリ'],
        ['膊', 'ジョウハクコツノハク'],
        ['膏', 'ナンコウヲヌル ノ コウ'],
        ['膀', 'ボウコウエンノボウ'],
        ['膃', 'オットセイノオツ'],
        ['膂', 'リョ，リョヒノリョノシタニニクヅキ'],
        ['辛', 'コウシンリョウ ノ シン，カライ'],
        ['辜', 'ムコノコ，チュウコシャノコノシタニカライ'],
        ['辟', 'ヘキエキスルノヘキ'],
        ['辞', 'コクゴジテン ノ ジ'],
        ['辱', 'ブジョクスル ノ ジョク，ハズカシメル'],
        ['辰', 'タツ，ジュウニシ ノ タツ'],
        ['農', 'ノウギョウ ノ ノウ'],
        ['辷', 'シンニョウニカンスウジノイチ，スベル'],
        ['辻', 'ヨツツジ ノ ツジ'],
        ['辺', 'シュウヘン ノ ヘン，アタリ'],
        ['込', 'モウシコム ノ コム'],
        ['辿', 'タドル'],
        ['辣', 'ラツワンノラツ'],
        ['辧', 'ベンベツスルノベンノキュウジ，カライ，シンフタツノアイダニカタナ'],
        [
            '辨',
            'ベンベツスルノベンノキュウジ，カライ，シンフタツノアイダニリットウ',
        ],
        ['辭', 'コクゴジテンノジノキュウジ'],
        ['辯', 'ベンゴシノベンノキュウジ，カライフタツノアイダニゲンゴノゲン'],
        ['辮', 'ベンパツノベン，カライ，シンフタツノアイダニイト'],
        ['⊇', 'ブブンシュウゴウギャク'],
        ['⊆', 'ブブンシュウゴウ'],
        ['睹', 'ト，メヘンニカガクシャノシャノキュウジタイ'],
        ['⊃', 'シンブブンシュウゴウギャク'],
        ['睾', 'ダンセイノコウガンノコウ'],
        ['睫', 'マツゲ，ショウ'],
        ['睨', 'ヘイゲイスルノゲイ，ニラム'],
        ['督', 'エイガカントク ノ トク'],
        ['睡', 'スイミン ノ スイ'],
        ['睦', 'シンボクカイ ノ ボク，ムツマジイイ'],
        ['睥', 'ヘイゲイスルノヘイ，ニラム'],
        ['睛', 'ガリョウテンセイヲカクノセイ，ヒトミ'],
        ['睚', 'ガイ，メヘンニイッショウガイノガイノツクリ'],
        ['⊥', 'スイチョク'],
        ['⊿', 'サンカクケイ'],
        ['着', 'キモノ ノ キ，チャク'],
        ['睇', 'テイ，メヘンニアニオトウトノオトウト'],
        ['阪', 'オオサカ ノ サカ，ハン'],
        ['阨', 'アイ，コザトヘンニヤクドシノヤク'],
        ['阮', 'ゲン，コザトヘンニガンタンノガン'],
        ['阯', 'シ，コザトヘンニキンシスルノシ'],
        ['阡', 'セン，コザトヘンニカンスウジノセン'],
        ['阻', 'ソシスル ノ ソ，ハバム'],
        ['阿', 'アミダブツ ノ ア'],
        ['防', 'ヨボウスル ノ ボウ，フセグ'],
        ['阜', 'ギフケン ノ フ，オカ'],
        ['儂', 'ノウ，ニンベンニノウギョウノノウ'],
        ['儀', 'ギシキ ノ ギ'],
        ['儁', 'シュン，ニンベンニフルトリニユミ'],
        ['億', 'オクマンチョウジャ ノ オク'],
        ['儉', 'ケンヤクスルノケンノキュウジ'],
        ['儒', 'ジュガク ノ ジュ'],
        ['儖', 'ラン，ニンベンニカントクスルノカン'],
        ['儔', 'チュウ，ニンベンニコトブキノキュウジ'],
        ['儕', 'セイ，ニンベンニイッセイシャゲキノセイノキュウジ'],
        ['儚', 'ボウ，ニンベンニユメ，ハカナイ'],
        ['儘', 'ワガママノママ，ジン'],
        ['償', 'バイショウキン ノ ショウ，ツグナウ'],
        ['儡', 'カイライセイケンノライ'],
        ['優', 'ユウショウスル ノ ユウ，ヤサシイ'],
        ['儲', 'モウカル，ニンベン ニ ショクン ノ ショ'],
        ['儷', 'レイ，ニンベンニウルワシイ'],
        ['儺', 'ダ，ニンベンニコンナンノナン'],
        ['儻', 'トウ，ニンベンニヨトウヤトウノトウノキュウジ'],
        ['儿', 'ジン，ブシュノヒトアシ'],
        ['儼', 'ゲン，ニンベンニゲンジュウナノゲン'],
        ['滝', 'タキツボ ノ タキ'],
        ['滞', 'ジュウタイスル ノ タイ，トドコオル'],
        ['滑', 'エンカツ ノ カツ，ナメラカ'],
        ['滓', 'ザンシノシ，サンズイニウカンムリニカライ'],
        ['滔', 'ミズガトウトウトナガレルノトウ'],
        ['滕', 'トウ，フジノハナノフジノクサカンムリナシ'],
        ['滉', 'コウ，サンズイニホロバシャノホロノツクリ'],
        ['滋', 'ジヨウキョウソウ ノ ジ'],
        ['滌', 'テキ，サンズイニジョウケンノジョウノキュウジ'],
        ['滂', 'ボウ，サンズイニロボウノボウノツクリ'],
        ['滄', 'ソウ，サンズイニカマクラバクフノクラ'],
        ['滅', 'ハメツスル ノ メツ，ホロビル'],
        ['滸', 'スイコデンノコ'],
        ['滾', 'タギル，コン'],
        ['滿', 'マンゾクノマンノキュウジ'],
        ['滲', 'シン，ニジム，サンズイニサンカスルノサンノキュウジ'],
        ['滴', 'スイテキ ノ テキ，シズク'],
        ['滷', 'ロ，サンズイニロカクヒンノロ'],
        ['滬', 'コ，サンズイニバッコスルノコ'],
        ['滯', 'ジュウタイスルノタイ，トドコオルノキュウジ'],
        ['_', 'アンダーライン'],
        ['蛩', 'キョウ、キョウリュウノキョウノココロノカワリニムシ'],
        ['蛮', 'ナンバンボウエキ ノ バン'],
        ['蛯', 'エビ，ムシヘンニロウジンノロウ'],
        ['蛬', 'キョウ、キョウツウスルノキョウノシタニムシ'],
        ['蛭', 'チヲスウドウブツ ノ ヒル'],
        ['蛤', 'ハマグリ，ムシヘン ニ アウ'],
        ['蛻', 'モヌケノカラノモヌケ'],
        ['蛸', 'ギョカイルイ ノ タコ'],
        ['蛹', 'ムシノサナギ、ヨウ'],
        ['蛾', 'ガ，ムシ ノ ガ'],
        ['蛋', 'タンパクシツ ノ タン'],
        ['蛉', 'トンボノニモジメ，レイ，ムシヘンニメイレイスルノレイ'],
        ['蛎', 'ウミ ノ カキ，レイ'],
        ['蛍', 'ホタル，ケイコウトウ ノ ケイ'],
        ['蛆', 'ウジムシノウジ，ショ'],
        ['蛇', 'ヘビ，ダイジャ ノ ジャ'],
        ['蛄', 'スシネタノシャコノコ'],
        ['蛛', 'クモ，ムシヘンニシュイロノシュ'],
        ['蛙', 'ドウブツ ノ カエル'],
        ['蛞', 'ナメクジノイチモジメ，ムシヘンニシタヲカムノシタ'],
        ['蛟', 'コウ、ミズチ、ムシヘンニマジワル'],
        ['蛔', 'カイ、ムシヘンニカイスウケンノカイ'],
        ['Ψ', 'ギリシャ プサイ'],
        ['Ω', 'ギリシャ オメガ'],
        ['Π', 'ギリシャ パイ'],
        ['Ρ', 'ギリシャ ロー'],
        ['Σ', 'ギリシャ シグマ'],
        ['Τ', 'ギリシャ タウ'],
        ['Υ', 'ギリシャ ウプシロン'],
        ['Φ', 'ギリシャ ファイ'],
        ['Χ', 'ギリシャ カイ'],
        ['θ', 'ギリシャ シータ'],
        ['ι', 'ギリシャ イオタ'],
        ['κ', 'ギリシャ カッパ'],
        ['λ', 'ギリシャ ラムダ'],
        ['μ', 'ギリシャ ミュー'],
        ['ν', 'ギリシャ ニュー'],
        ['ξ', 'ギリシャ グザイ'],
        ['ο', 'ギリシャ オミクロン'],
        ['α', 'ギリシャ アルファ'],
        ['β', 'ギリシャ ベータ'],
        ['γ', 'ギリシャ ガンマ'],
        ['δ', 'ギリシャ デルタ'],
        ['ε', 'ギリシャ イプシロン'],
        ['ζ', 'ギリシャ ゼータ'],
        ['η', 'ギリシャ イータ'],
        ['Θ', 'ギリシャ シータ'],
        ['Ι', 'ギリシャ イオタ'],
        ['Κ', 'ギリシャ カッパ'],
        ['Λ', 'ギリシャ ラムダ'],
        ['Μ', 'ギリシャ ミュー'],
        ['Ν', 'ギリシャ ニュー'],
        ['Ξ', 'ギリシャ グザイ'],
        ['Ο', 'ギリシャ オミクロン'],
        ['Α', 'ギリシャ アルファ'],
        ['Β', 'ギリシャ ベータ'],
        ['Γ', 'ギリシャ ガンマ'],
        ['Δ', 'ギリシャ デルタ'],
        ['Ε', 'ギリシャ イプシロン'],
        ['Ζ', 'ギリシャ ゼータ'],
        ['Η', 'ギリシャ イータ'],
        ['縦', 'タテヨコ ノ タテ，ジュウ'],
        ['縡', 'サイ，イトヘンニテッケツサイショウノサイ'],
        ['縢', 'イトカガリノカガル，トウ'],
        ['縣', 'トドウフケンノケンノキュウジ'],
        ['縮', 'タンシュク ノ シュク，チヂム'],
        ['縫', 'サイホウスル ノ ホウ，ヌウ'],
        ['縵', 'マン，イトヘンニマンダラノマン'],
        ['縷', 'イチルノノゾミノル'],
        ['縱', 'ジュウ，タテヨコノタテノキュウジ'],
        ['縲', 'ルイ，イトヘンニルイセキスルノルイ'],
        ['總', 'ソウリダイジンノソウノキュウジ'],
        ['績', 'セイセキヒョウ ノ セキ'],
        ['縹', 'ヒョウ，ハナダ，イトヘンニトウヒョウスルノヒョウ'],
        ['縺', 'レン，モツレル'],
        ['縻', 'キビセイサクノビ'],
        ['縄', 'ナワ，ジョウモンドキ ノ ジョウ'],
        ['縅', 'ヨロイノオドシ，イトヘンニイカクスルノイ'],
        ['縁', 'エンガワ ノ エン，フチ'],
        ['縉', 'シン，イトヘンニチュウゴクノコクメイノシン，ススムノキュウジ'],
        ['縊', 'イシスルノイ，クビル'],
        ['縋', 'スガリツクノスガル，ツイ，イトヘンニツイセキスルノツイ'],
        ['縒', 'ヨリヲモドスノヨリ，イトヘンニサベツカノサ'],
        ['縞', 'シマモヨウ ノ シマ'],
        ['縟', 'ジョク，イトヘンニブジョクスルノジョク'],
        ['縛', 'シバル，ソクバク ノ バク'],
        ['攵', 'ボク，ブシュノノブン，ハイボクスルノハイノツクリ'],
        ['攴', 'ボク，ブシュノトマタ'],
        ['攷', 'コウ，ギコウテキナノコウノツクリノミギニノブン'],
        ['收', 'シュウニュウノシュウノキュウジ'],
        ['改', 'カイリョウ ノ カイ，アラタメル'],
        ['攸', 'ユウ，ニンベンニタテボウニノブン'],
        ['攻', 'コウゲキ ノ コウ，セメル'],
        ['政', 'セイジカ ノ セイ'],
        ['放', 'ホウソウキョク ノ ホウ，ハナツ'],
        ['攣', 'ケイレンヲオコスノレン'],
        ['攤', 'タン，テヘンニコンナンナノナンノキュウジ'],
        ['騷', 'サワグ，ソウオンノソウノキュウジ'],
        ['攫', 'イッカクセンキンノカク，ツカム'],
        ['攪', 'コウランスルノコウ，ミダス'],
        ['攬', 'ラン，テヘンニハクランカイノランノキュウジ'],
        ['支', 'シエンスル ノ シ，ササエル'],
        ['鳳', 'ホウオウ ノ オウ，オオトリ'],
        ['攘', 'ソンノウジョウイノジョウ，ハラウ'],
        ['鳰', 'ミズトリノニオ，ニュウガクノニュウニトリ'],
        ['攝', 'セッセイスルノセイ，トルノキュウジ'],
        ['攜', 'ケイタイスルノケイ，タズサエルノイタイジ'],
        ['鳴', 'ヒメイヲアゲル ノ メイ，ナク'],
        ['鳫', 'ガン，ガンダレニトリ'],
        ['攀', 'ガンペキヲトウハンスルノハン'],
        ['鳩', 'トリ ノ ハト'],
        ['攅', 'サン，アツメル，テヘンニサンセイスルノサン'],
        ['鳬', 'ミズドリノケリ，トリノヨツテンノカワリニツクエノツクリ'],
        ['鬧', 'ドウ，トウガマエニイチバノイチ'],
        ['鳧', 'ミズドリノケリ，トリノシタニツクエノツクリ'],
        ['鳥', 'トリ，ヤチョウ ノ チョウ'],
        ['∈', 'ゾクスル'],
        ['∋', 'ゲントシテフクム'],
        ['∀', 'フツウゲンテイシ'],
        ['∃', 'ソンザイゲンテイシ'],
        ['∂', 'ラウンドディー'],
        ['石', 'ホウセキ ノ セキ，イシ'],
        ['短', 'チョウタン ノ タン，ミジカイ'],
        ['矯', 'キョウセイシリョク ノ キョウ'],
        ['矮', 'ワイショウナノワイ'],
        ['矩', 'クケイ ノ ク'],
        ['∟', 'チョッカク'],
        ['∞', 'ムゲンダイ'],
        ['∑', 'シグマ'],
        ['矧', 'ヤヘン ニ インヨウスル ノ イン，ハグ'],
        ['矣', 'イ，アイサツノアイノツクリ'],
        ['矢', 'ユミヤ ノ ヤ'],
        ['∩', 'キャップ'],
        ['矜', 'キョウジヲタモツノキョウ'],
        ['∫', 'インテグラル'],
        ['∪', 'カップ'],
        ['∬', 'ダブルインテグラル'],
        ['矛', 'ムジュン ノ ム，ホコ'],
        ['矚', 'ショク，メヘンニフゾクノゾクノキュウジ'],
        ['∠', 'カク'],
        ['矗', 'チク，チョクゼンノチョクガミッツ'],
        ['∥', 'タテヘイコウ'],
        ['∧', 'オヨビ'],
        ['矍', 'ゲンキカクシャクノカク'],
        ['鑵', 'カン、カネヘンニカンヅメノカンノキュウジノツクリ'],
        ['∽', 'ソウジ'],
        ['矇', 'モウ，メヘンニケイモウスルノモウ'],
        ['∵', 'ナゼナラバ'],
        ['∴', 'ユエニ'],
        ['鞭', 'キョウベンヲトル ノ ベン，ムチ'],
        ['鞨', 'カツ、カワヘンニカッショクノカツノツクリ'],
        ['鞫', 'キク，カワヘンニツツミガマエノナカニゴンベン'],
        ['鞦', 'シュウ，カワヘンニキセツノアキ'],
        ['鞠', 'ケマリ ノ マリ，キク'],
        ['鑰', 'ヤク，カネヘンニブシュノヤク'],
        ['鬥', 'トウ，ブシュノトウガマエ'],
        ['鞴', 'フイゴ，カワヘンニジュンビスルノビノツクリ'],
        ['鬢', 'ビン，カミガシラニライヒンノヒン'],
        ['鞳', 'トウ、カワヘンニゴジュウノトウノトウノツクリ'],
        ['鞍', 'アンバ ノ アン，クラ'],
        ['鞏', 'キョウ、キョウノココロノカワリニカクメイノカク'],
        ['鞋', 'ワラジノニモジメ，カイ'],
        ['鞄', 'カバン'],
        ['鞅', 'オウ，カワヘンニチュウオウノオウ'],
        ['鞆', 'トモ、カワヘンニコウオツヘイノヘイ'],
        ['鞁', 'ヒ，カワヘンニケガワノカワ'],
        ['鞜', 'トウ，カワヘンニミズノシタニニチヨウビノニチ'],
        ['鬮', 'キュウ，トウガマエニドウブツノカメノキュウジ'],
        ['鞘', 'カタナ ノ サヤ，ショウ'],
        ['v', 'ブイ ビデオ'],
        ['鞐', 'コハゼ、カワヘンニウエシタ'],
        ['鑪', 'ロ、カネヘンニハゼノキノハゼノツクリ'],
        ['鬨', 'トキノコエヲアゲルノトキ'],
        ['鑠', 'ゲンキカクシャクノシャク'],
        ['隨', 'ズイヒツノズイノキュウジ'],
        ['忱', 'シン，リッシンベンニチンボツスルノチンノツクリ'],
        ['忰', 'ショウスイスルノスイノイタイジ'],
        ['念', 'ザンネン ノ ネン'],
        ['忻', 'キン，リッシンベンニパンイッキンノキン'],
        ['忸', 'ジクジタルノジク，ハジル'],
        ['忿', 'フン，フンベツノフンノシタニココロ'],
        ['忽', 'コツゼン ノ コツ，タチマチ'],
        ['忠', 'チュウコクスル ノ チュウ'],
        ['忤', 'ゴ，リッシンベンニショウゴノゴ'],
        ['快', 'カイテキ ノ カイ，ココロヨイ'],
        ['鬼', 'オニ，キュウケツキ ノ キ'],
        ['隰', 'シツ、コザトヘンニシメッポイノキュジノツクリ'],
        ['志', 'ココロザス，イシ ノ シ'],
        ['忖', 'ソンタクスルノソン，リッシンベンニスンポウノスン'],
        ['忙', 'イソガシイ，タボウ ノ ボウ'],
        ['忘', 'ボウネンカイ ノ ボウ，ワスレル'],
        ['忝', 'テン，カタジケナイ，テンプスルノテンノツクリ'],
        ['応', 'オウエン ノ オウ'],
        ['心', 'ココロ，アンシン ノ シン'],
        ['必', 'ヒツヨウ ノ ヒツ，カナラズ'],
        ['忍', 'ニンジャ ノ ニン，シ ノ ブ'],
        ['忌', 'イッシュウキ ノ キ，イム'],
        ['隶', 'イ、ドレイカイホウノレイノツクリ'],
        ['隷', 'ドレイカイホウ ノ レイ'],
        ['隹', 'スイ、ブシュノフルトリ'],
        ['L', 'エル ラブ'],
        ['鑄', 'チュウゾウスルノチュウ、イルノキュウジ'],
        ['隋', 'ケンズイシノズイ'],
        ['階', 'カイダンヲ ノボル ノ カイ'],
        ['谺', 'カ、コダマ、タニヘンニキバ'],
        ['谿', 'ケイ，ケイリュウヅリノケイノキュウジノツクリノミギニタニ'],
        ['谷', 'タニガワ ノ タニ，コク'],
        ['隗', 'カイ、コザトヘンニオニ'],
        ['蝮', 'ヘビノマムシ、フク'],
        ['蝨', 'シラミ'],
        ['蝪', 'トウ，ムシヘンニバショノバノツクリ'],
        ['蝦', 'ムシヘン ノ エビ，カ'],
        ['蝠', 'コウモリノニモジメ，ムシヘンニフクカイチョウノフクノヒダリガワ'],
        ['蝣', 'ユウ、アソブノシンリョウノカワリニムシヘン'],
        ['蝿', 'ムシ ノ ハエ'],
        ['蝸', 'カタツムリノカギュウノカ'],
        ['蝴', 'コ、ムシヘンニクロコショウノコ'],
        ['蝶', 'アゲハチョウ ノ チョウ'],
        ['蝌', 'カ、ムシヘンニキョウカショノカ'],
        ['蝎', 'ダカツノゴトクキラウノカツ、ムシヘンニカッショクノカツノツクリ'],
        ['"', 'クォーテーション'],
        ['蝉', 'セミシグレ ノ セミ'],
        ['蝋', 'ロウソクタテ ノ ロウ'],
        ['蝟', 'イ、ムシヘンニイブクロノイ'],
        ['蝙', 'コウモリノイチモジメ、ムシヘンニヘンペイソクノヘン'],
        ['蝕', 'ニッショク ノ ショク，ムシバム'],
        ['蝗', 'コウ、イナゴ、ムシヘンニコウタイシノコウ'],
        ['蝓', 'ナメクジノニモジメ，ムシヘンニニレノキノニレノツクリ'],
        ['醺', 'ビクンヲオビルノクン'],
        ['傅', 'フイクスルノフ，メノト'],
        ['估', 'コ，ニンベンニチュウコシャノコ'],
        ['傀', 'カイライセイケンノカイ'],
        ['伶', 'レイジン ノ レイ，ニンベン ニ メイレイ ノ レイ'],
        ['伴', 'ドウハンスル ノ ハン，トモナウ'],
        ['傍', 'ボウカンシャ ノ ボウ，カタワラ'],
        ['伸', 'シンシュク ノ シン，ノビル'],
        ['伽', 'オトギバナシ ノ トギ，カ'],
        ['似', 'ルイジ ノ ジ，ニル'],
        ['傑', 'ゴウケツ ノ ケツ'],
        ['傘', 'ラッカサン ノ サン，カサ'],
        ['備', 'ジュンビスル ノ ビ，ソナエル'],
        ['傚', 'コウ，ニンベンニコウカテキノコウノキュウジ'],
        ['休', 'ヤスム，キュウジツ ノ キュウ'],
        ['伐', 'バッサイスル ノ バツ'],
        ['催', 'モヨオス，カイサイ ノ サイ'],
        ['傭', 'ヨウヘイ ノ ヨウ，ヤトウ'],
        ['伝', 'デンセツ ノ デン，ツタエル'],
        ['伜', 'セガレノイタイジ，ニンベンニカンスウジノキュウトジュウ'],
        ['傴', 'ウ，ニンベンニクベツスルノクノキュウジ'],
        ['債', 'サイムヲオウ ノ サイ'],
        ['企', 'キカク ノ キ，クワダテル'],
        ['傷', 'キズ，ジュウショウ ノ ショウ'],
        ['傲', 'ゴウマンナノゴウ'],
        ['傳', 'デンセツノデンノキュウジ'],
        ['伊', 'イセエビ ノ イ'],
        ['伉', 'コウ，ニンベンニテイコウスルノコウノツクリ'],
        ['伏', 'キフクニトム ノ フク，フセル'],
        ['伎', 'カブキ ノ キ'],
        ['伍', 'ラクゴスル ノ ゴ，ニンベン ニ カンスウジ ノ ゴ'],
        ['湧', 'ユウシュツスル ノ ユウ，ワク'],
        ['湫', 'シュウ，サンズイニアキマツリノアキ'],
        ['湮', 'ショウコインメツノイン，サンズイニケムリノツクリ'],
        ['湯', 'ネットウ ノ トウ，ユ'],
        ['湲', 'エン，サンズイニオウエンスルノエンノツクリ'],
        ['醗', 'サケヲハッコウサセル ノ ハツ，カモス'],
        ['湶', 'セン，サンズイニオンセンノセン'],
        ['醐', 'ダイゴミ ノ ゴ'],
        ['湾', 'ワンガン ノ ワン'],
        ['湿', 'シツド ノ シツ，シメル'],
        ['湃', 'ハイ，サンズイニオガムノキュウジ'],
        ['湊', 'ミナト，サンズイ ニ カナデル'],
        ['湎', 'チンメンスルノメン，サンズイニジメンノメン'],
        ['湍', 'タン，サンズイニタンマツノタンノツクリ'],
        ['湖', 'コハン ノ コ，ミズウミ'],
        ['湛', 'ミズヲタタエル ノ タン'],
        ['湘', 'ショウナンカイガン ノ ショウ'],
        ['湟', 'コウ，サンズイニコウタイシノコウ'],
        ['纎', 'カガクセンイノセンノキュウジノイタイジ'],
        ['纏', 'ハンテン ノ テン，マトウ'],
        ['續', 'レンゾクノゾク，ツヅクノキュウジ'],
        ['纈', 'コウケチゾメノケチ'],
        ['纉', 'サン，イトヘンニサンセイスルノサン'],
        ['纂', 'ジショヲヘンサンスル ノ サン'],
        ['纃', 'シ，イトヘンニイッセイシャゲキノセイノキュウジ'],
        ['纜', 'ラン，イトヘンニハクランカイノランノキュウジ'],
        ['纛', 'トク，ドクヤクノドクノシタニトドウフケンノケンノキュウジ'],
        ['纖', 'カガクセンイノセンノキュウジ'],
        ['纔', 'ワズカヲイミスルイトヘンノサイ'],
        ['纒', 'ハンテンノテン，マトウノイタイジ'],
        ['纓', 'エイ，イトヘンニサクラノキュウジノツクリ'],
        ['纐', 'コウケチゾメノコウ'],
        ['暹', 'セン，シンポノシンノウエニニチヨウビノニチ'],
        ['暸', 'リョウ，メイリョウナノリョウノメノカワリニヨウビノニチ'],
        ['暾', 'トン，ニチヘンニチュウゴクノトンコウノトン'],
        ['暼', 'ヘツ，イチベツスルノベツノメノカワリニヨウビノニチ'],
        ['鱗', 'ウロコ，ヘンリン ノ リン'],
        ['暴', 'ボウリョク ノ ボウ，アバレル'],
        ['暫', 'ザンテイテキ ノ ザン，シバラク'],
        ['暮', 'オセイボ ノ ボ，クラス'],
        ['暢', 'リュウチョウナ ノ チョウ'],
        ['鱇', 'サカナノアンコウノコウ，ウオヘンニイエヤスノヤス'],
        ['鱆', 'ショウ，ウオヘンニブンショウヲカクノショウ'],
        ['暦', 'セイレキ ノ レキ，コヨミ'],
        ['暘', 'ヨウ，ニチヘンニタイヨウケイノヨウノツクリ'],
        ['鱸', 'サカナノスズキ'],
        ['暝', 'メイ，ニチヘンニメイフクヲイノルノメイ'],
        ['暑', 'アツイサムイ ノ アツイ，ショ'],
        ['鱶', 'サカナノフカ，ウオヘンニヤシナウ'],
        ['暗', 'アンキスル ノ アン，クライ'],
        ['暖', 'ダンボウ ノ ダン，アタタカイ'],
        ['暉', 'キ，ニチヘンニグンタイノグン'],
        ['暈', 'メマイヲイミスルゲンウンノウン'],
        ['暎', 'エイ，ニチヘンニエイユウノエイ'],
        ['暃', 'ニチヨウビノニチノシタニヒジョウグチノヒ'],
        ['暁', 'アカツキ'],
        ['暇', 'キュウカ ノ カ，ヒマ'],
        ['鱠', 'ウオヘンノナマス'],
        ['暄', 'ケン，ニチヘンニセンデンノセン'],
        ['c', 'シー キャット'],
        ['鉅', 'キョ、カネヘンニキョダイナノキョ'],
        ['壽', 'コトブキ，ジュミョウノジュノキュウジ'],
        ['彷', 'ホウコウスルノホウ，ギョウニンベンニオヤカタノカタ'],
        ['影', 'エイキョウ ノ エイ，カゲ'],
        ['彰', 'ヒョウショウジョウ ノ ショウ'],
        ['彳', 'テキ，ブシュノギョウニンベン'],
        ['彼', 'ヒガンバナ ノ ヒ，カレ'],
        ['彿', 'フツ，ギョウニンベンニドル'],
        ['役', 'ヤクワリ ノ ヤク'],
        ['彦', 'ヒコボシ ノ ヒコ'],
        ['彡', 'サン，ブシュノサンヅクリ'],
        ['形', 'チョウホウケイ ノ ケイ，カタチ'],
        ['彭', 'ホウ，ボウチョウリツノボウノツクリ'],
        ['彬', 'ヒン，ハヤシニ サンヅクリ，アキラ'],
        ['彩', 'シキサイ ノ サイ，イロドル'],
        ['彫', 'チョウコクカ ノ チョウ，ホル'],
        ['彪', 'トラニサンヅクリ ノ ヒョウ'],
        ['彗', 'ハレースイセイノスイ'],
        ['彖', 'タン，ケイガシラニイノコ'],
        ['彑', 'ケイ，ブシュノケイガシラ'],
        ['当', 'トウバン ノ トウ，アタル'],
        ['彝', 'イ，ゴイノイノウエガワニコメ，イト，ニジュウアシ'],
        ['彜', 'イ，ゴイノイノウエガワニコナ，ニジュウアシ'],
        ['彙', 'キホンゴイノイ'],
        ['彁', 'ユミヘンニカノウセイノカヲカサネル'],
        ['彌', 'アミダブツノミノキュウジ'],
        ['彎', 'ワンガンノワンノキュウジノツクリ'],
        ['彈', 'ダンリョクノダン，ハズムノキュウジ'],
        ['彊', 'ジキョウジュツ ノ キョウ，ツヨイ'],
        ['ｓ', 'エス スポーツ'],
        ['ｒ', 'アール ルーム'],
        ['ｑ', 'キュー クエスチョン'],
        ['ｐ', 'ピー パパ'],
        ['ｗ', 'ダブリュー ウィンドウ'],
        ['ｖ', 'ブイ ビデオ'],
        ['ｕ', 'ユー ユージュアリー'],
        ['ｔ', 'ティー タイム'],
        ['｛', 'チュウカッコ'],
        ['ｚ', 'ゼット ズー'],
        ['ｙ', 'ワイ ヤング'],
        ['ｘ', 'エックス エックスセン'],
        ['～', 'ナミセン'],
        ['｝', 'トジチュウカッコ'],
        ['｜', 'タテセン'],
        ['ｃ', 'シー キャット'],
        ['ｂ', 'ビー ボーイ'],
        ['ａ', 'エイ アニマル'],
        ['｀', 'アクサングラーブ'],
        ['ｇ', 'ジー ゴルフ'],
        ['ｆ', 'エフ フレンド'],
        ['ｅ', 'イー エッグ'],
        ['ｄ', 'ディー デスク'],
        ['ｋ', 'ケイ キッチン'],
        ['ｊ', 'ジェイ ジャパン'],
        ['ｉ', 'アイ インク'],
        ['ｈ', 'エイチ ホテル'],
        ['ｏ', 'オー オープン'],
        ['ｎ', 'エヌ ノベンバー'],
        ['ｍ', 'エム マイク'],
        ['ｌ', 'エル ラブ'],
        ['ｳ', 'ウサギ ノ ウ'],
        ['ｲ', 'イチゴ ノ イ'],
        ['ｱ', 'アサヒ ノ ア'],
        ['ｰ', 'チョウオン'],
        ['ｷ', 'キッテ ノ キ'],
        ['ｶ', 'カゾク ノ カ'],
        ['ｵ', 'オオサカ ノ オ'],
        ['ｴ', 'エイゴ ノ エ'],
        ['ｻ', 'サクラ ノ サ'],
        ['ｺ', 'コドモ ノ コ'],
        ['ｹ', 'ケシキ ノ ケ'],
        ['ｸ', 'クスリ ノ ク'],
        ['ｿ', 'ソロバン ノ ソ'],
        ['ｾ', 'セカイ ノ セ'],
        ['ｽ', 'スズメ ノ ス'],
        ['ｼ', 'シンブン ノ シ'],
        ['｣', 'トジカギ'],
        ['｢', 'カギ'],
        ['｡', 'マル'],
        ['ｧ', 'チイサイ アサヒ ノ ア'],
        ['ｦ', 'ヲワリ ノ ヲ'],
        ['･', 'ナカテン'],
        ['､', 'テン'],
        ['9', 'キュウ'],
        ['ｪ', 'チイサイ エイゴ ノ エ'],
        ['ｩ', 'チイサイ ウサギ ノ ウ'],
        ['ｨ', 'チイサイ イチゴ ノ イ'],
        ['ｯ', 'チイサイ ツバメ ノ ツ'],
        ['ｮ', 'チイサイ ヨット ノ ヨ'],
        ['ｭ', 'チイサイ ユカタ ノ ユ'],
        ['ｬ', 'チイサイ ヤカン ノ ヤ'],
        ['貝', 'カイガラ ノ カイ'],
        ['貞', 'テイシュク ノ テイ'],
        ['貘', 'ムジナヘンノドウブツノバク'],
        ['貔', 'ユウモウナグンタイヲイミスルヒキュウノヒ'],
        ['貍', 'リ、ムジナヘンニサトガエリノサト'],
        ['貌', 'ビボウ ノ ボウ，カタチ'],
        ['貎', 'ゲイ、ムジナヘンニジドウセイトノジノキュウジ'],
        ['貉', 'ムジナヘンノドウブツノムジナ'],
        ['貊', 'ハク、ムジナヘンニカンスウジノヒャク'],
        ['倍', 'バイリツ ノ バイ'],
        ['貂', 'ドウブツノテン'],
        ['貽', 'イズシノイ、カイヘンニダイドコロノダイ'],
        ['貼', 'ハル，カイヘン ニ ウラナウ'],
        ['貿', 'ボウエキコウ ノ ボウ'],
        ['貸', 'ホンヲカス ノ カ'],
        ['費', 'ショウヒ ノ ヒ'],
        ['貴', 'キチョウヒン ノ キ'],
        ['買', 'カウ，バイシュウ ノ バイ'],
        ['貶', 'キヨホウヘンノヘン，オトシメル'],
        ['貰', 'モラウ'],
        ['貳', 'カンスウジノニ，シキガマエニ，ニノシタニカイガラノカイ'],
        ['貲', 'シ、ヒガンシガンノシノシタニカイガラノカイ'],
        ['貭', 'シツモンノシツノイタイジ'],
        ['責', 'セキニン ノ セキ'],
        ['貯', 'チョキン ノ チョ，タクワエル'],
        [
            '貮',
            'カンスウジノニノイタイジ，ブキノブノトメルノカワリニカイガラノカイ',
        ],
        ['販', 'ハンバイスル ノ ハン'],
        ['貨', 'カモツ ノ カ'],
        ['貫', 'イッカンスル ノ カン，ツラヌク'],
        ['貪', 'ドンヨクノドン、ムサボル'],
        ['貧', 'ヒンジャク ノ ヒン，マズシイ'],
        ['財', 'ザイサン ノ ザイ'],
        ['負', 'カチマケ ノ マケ，フ'],
        ['貢', 'シャカイコウケンスル ノ コウ，ミツグ'],
        ['龜', 'ドウブツノカメノキュウジ'],
        ['△', 'サンカク'],
        ['▲', 'クロサンカク'],
        ['▽', 'ギャクサンカク'],
        ['▼', 'クロギャクサンカク'],
        ['□', 'シカク'],
        ['■', 'クロシカク'],
        ['癇', 'カンシャクヲオコスノカン'],
        ['癆', 'ロウガイノロウ，ヤマイダレニロウドウノロウノキュウジ'],
        ['露', 'ロシュツ ノ ロ，ツユ'],
        ['療', 'チリョウスル ノ リョウ'],
        ['霰', 'アラレ、アメカンムリニサンンポスルノサン'],
        ['霾', 'バイ、アメカンムリニムジナヘンニサトガエリノサト'],
        ['癌', 'ガンサイボウ ノ ガン'],
        ['霸', 'セイハスルノハノキュウジ'],
        ['癈', 'ハイジンノハイ，ヤマイダレニハツメイノハツノキュウジ'],
        ['癖', 'アクヘキ ノ ヘキ，クセ'],
        ['霤', 'リュウ、アメカンムリニリュガクノリュウ'],
        ['癒', 'チユスル ノ ユ，イヤス'],
        ['癜', 'ヒフビョウノナマズ，テン，ヤマイダレニトノサマノトノ'],
        ['霪', 'イン、アメカンムリニインランノイン'],
        ['癘', 'ショウレイノレイ，ヤマイダレニスウジノマンノキュウジ'],
        ['O', 'オー オープン'],
        ['癢', 'ヨウ，ヤマイダレニヤシナウ'],
        ['癡', 'グチノチノキュウジ'],
        ['霑', 'テン、アメカンムリニサンズイニドクセンスルノセン'],
        ['霞', 'ハルガスミ ノ カスミ'],
        ['霜', 'シモバシラ ノ シモ'],
        ['癬', 'カイセンキンノセン'],
        ['癪', 'カンシャクヲオコスノシャク'],
        ['癩', 'ライビョウノライ'],
        ['癨', 'カク，ヤマイダレニオニノカクランノカク'],
        ['霆', 'テイ、アメカンムリニキュウテイブンガクノテイ'],
        ['癶', 'ハツ，ブシュノハツガシラ'],
        ['霄', 'ショウ、アメカンムリニショウゾウガノショウ'],
        ['癲', 'テンカンヲオコスノテン'],
        ['需', 'ヒツジュヒン ノ ジュ'],
        ['癰', 'ヒフビョウノヨウ'],
        ['霎', 'ソウ、アメカンムリニメカケ'],
        ['百', 'カンスウジ ノ ヒャク'],
        ['白', 'シロイ，ハクチョウ ノ ハク'],
        ['發', 'ハツメイノハツノキュウジ'],
        ['登', 'トザン ノ ト，ノボル'],
        ['発', 'ハツメイ ノ ハツ'],
        ['霈', 'ハイ、アメカンムリニハイゼンタルノハイ'],
        ['癸', 'キ，ジッカンノミズノト'],
        ['侵', 'シンリャク ノ シン，オカス'],
        ['倏', 'シュク，ジョウケンノジョウノキュウジノキノカワリニドウブツノイヌ'],
        ['侶', 'ソウリョ ノ リョ'],
        ['個', 'コセイテキ ノ コ'],
        ['倉', 'ソウコ ノ ソウ，クラ'],
        ['倆', 'リョウ，ニンベンニリョウテノリョウノキュウジ'],
        ['便', 'ユウビン ノ ビン，タヨリ'],
        ['倅', 'セガレ，ニンベンニソツギョウノソツ'],
        ['借', 'シャクヨウ ノ シャクカリル'],
        ['価', 'カチ ノ カ，アタイ'],
        ['侠', 'ニンキョウ ノ キョウ'],
        ['候', 'リッコウホ ノ コウ'],
        ['侭', 'ワガママ ノ ママ，ニンベン ニ ツクス'],
        ['侯', 'オウコウキゾク ノ コウ'],
        ['侮', 'ブジョクスル ノ ブ，アナドル'],
        ['倒', 'トウサンスル ノ トウ，タオレル'],
        ['侫', 'カンネイノネイノイタイジ'],
        ['們', 'モン，ニンベンニセンモンノモン'],
        ['倬', 'タク，ニンベンニタッキュウノタク'],
        ['侖', 'リン，シャリンノリンノツクリ'],
        ['侑', 'ユウ，ニンベンニユウメイジンノユウ'],
        ['倫', 'リンリテキナ ノ リン'],
        ['倨', 'キョゴウノキョ，ニンベンニジュウキョノキョ'],
        ['倩', 'セン，ニンベンニアオノキュウジタイ'],
        ['依', 'イライスル ノ イ'],
        ['値', 'ネダン ノ ネ，アタイ'],
        ['倥', 'コウ，ニンベンニクウキノクウ'],
        ['倣', 'モホウスル ノ ホウ，ナラウ'],
        ['供', 'テイキョウスル ノ キョウ，ソナエル'],
        ['倡', 'ショウ，ニンベンニガッショウキョクノショウノツクリ'],
        ['來', 'ライネンノライ，クルノキュウジ'],
        ['侃', 'カンカンガクガク ノ カン'],
        ['倹', 'ケンヤクスル ノ ケン'],
        ['侍', 'ジジュウ ノ ジ，サムライ'],
        ['侏', 'シュジュノシュ，ニンベンニシュイロノシュ'],
        ['侈', 'シャシニナガレルノシ，ニンベンニオオイスクナイノオオイ'],
        ['例', 'レイダイ ノ レイ，タトエル'],
        ['濤', 'ドトウノトウ，ナミ'],
        ['濠', 'ゴウ，サンズイ ニ ゴウカイナ ノ ゴウ'],
        ['濡', 'ヌレル'],
        ['濬', 'シュン，サンズイニヒエイザンノエイノヒダリガワ'],
        ['濮', 'ボク，サンズイニイチニンショウノボク'],
        ['濯', 'センタクモノ ノ タク'],
        ['濫', 'カセン ノ ハンラン ノ ラン'],
        ['濶', 'ウカツナノカツノイタイジ'],
        ['濱', 'スナハマノハマノキュウジ'],
        ['濳', 'センスイカンノセン，モグルノイタイジ'],
        ['濾', 'ロカスルノロ，コス'],
        ['濺', 'セン，サンズイニゲセンナノセン'],
        ['濆', 'フン，サンズイニフンカスルノフンノツクリ'],
        ['激', 'カゲキ ノ ゲキ，ハゲシイ'],
        ['濁', 'ニゴル，ダクリュウ ノ ダク'],
        ['濂', 'レン，サンズイニレンカバンノレン'],
        ['濃', 'ノウタン ノ ノウ，コイ'],
        ['濔', 'ビ，サンズイニソツジナガラノジ'],
        ['濕', 'シツドノシツ，シメルノキュウジ'],
        ['濟', 'キュウサイスルノサイ，スマスノキュウジ'],
        ['濘', 'デイネイノネイ，サンズイニテイネイノネイ'],
        ['濛', 'モウ，サンズイニケイモウスルノモウ'],
        ['郁', 'フクイク ノ イク'],
        ['飆', 'ツムジカゼ，ヒョウ，カゼノヒダリニイヌミッツ'],
        ['P', 'ピー パパ'],
        ['蟶', 'マテガイノマテ，ムシヘンニヒジリ'],
        [
            '蟷',
            'カマキリヲイミスルトウロウノトウ，ムシヘンニベントウノトウノキュウジ',
        ],
        ['蟲', 'ムシ，コンチュウノチュウノキュウジ'],
        ['蟾', 'セン，ムシヘンニタンニンノタンノキュウジノツクリ'],
        ['蟻', 'ムシ ノ アリ，ギ'],
        ['蟹', 'カニ'],
        ['蟠', 'ワダカマル，ハン，ムシヘンニバンゴウノバン'],
        ['蟯', 'ギョウチュウノギョウ'],
        ['蟒', 'ウワバミヲイミスルボウ，クサカンムリニソウモウノシンノモウ'],
        ['蟐', 'アカガエル，ムシヘンニヒジョウグチノジョウ'],
        ['蟆', 'ガマガエル，バクノイタイジ'],
        ['蟇', 'ガマガエル，バク'],
        ['蟄', 'ケイチツノチツ'],
        ['蟀', 'コオロギノニモジメ，ムシヘンニソツギョウノソツ'],
        ['蟋', 'コオロギノイチモジメ，ムシヘンニノゴメノシタニココロ'],
        ['飫', 'ヨ，アキル，ショクヘンニヒヨクナトチノヨクノツクリ'],
        ['飩', 'ドン，ウドンノニモジメ'],
        ['飢', 'キガ ノ キ，ウエル'],
        ['&', 'アンド'],
        ['￥', 'エンマーク'],
        ['￡', 'ポンド'],
        ['￠', 'セント'],
        ['￣', 'オーバーライン'],
        ['￢', 'ヒテイ'],
        ['乖', 'カイリスルノカイ，ソムクノイミ'],
        ['示', 'テンジスル ノ ジ，シメス'],
        ['礼', 'レイギ ノ レイ'],
        ['社', 'シャカイ ノ シャ，ヤシロ'],
        ['礦', 'コウ，イシヘンニヒロバノヒロノキュウジ'],
        ['礪', 'トナミヘイヤノト'],
        ['礫', 'ガレキノレキ'],
        ['礬', 'コウブツノミョウバンノバン'],
        ['礑', 'トウ，イシヘンニベントウノトウノキュウジ'],
        ['礒', 'ギ，イシヘンニギムノギ'],
        ['乍', 'ムカシナガラ ノ ナガラ'],
        ['礙', 'ガイ，イシヘンニウタガウ'],
        ['礁', 'サンゴショウ ノ ショウ'],
        ['乏', 'ビンボウ ノ ボウ，トボシイ'],
        ['礇', 'イキ，イシヘンニオクバノオクノキュウジ'],
        ['礎', 'キソテキナ ノ ソ，イシズエ'],
        ['昼', 'ヒルヤスミ ノ ヒル，チュウ'],
        ['昿', 'コウ，ニチヘンニヒロイ'],
        ['昵', 'ジッコンノアイダガラノジツ，ニチヘンニアマデラノアマ'],
        ['昴', 'スバル'],
        ['鷭', 'バン，バンゴウノバンノミギニトリ'],
        ['昶', 'チョウ，エイキュウノエイノミギニニチヨウビノニチ'],
        ['昭', 'ショウワウマレ ノ ショウ'],
        ['是', 'ゼヒ ノ ゼ'],
        ['昨', 'サクネン ノ サク'],
        ['春', 'ハルヤスミ ノ ハル，シュン'],
        ['昧', 'アイマイナ ノ マイ'],
        ['映', 'エイガ ノ エイ，ウツス'],
        ['鷹', 'トリ ノ タカ'],
        ['鷸', 'イツ，タチバナノツクリノミギニトリ，シギ'],
        ['昜', 'ヨウ，タイヨウケイノヨウノツクリ'],
        ['星', 'ホシ，セイザ ノ セイ'],
        ['鷄', 'ニワトリノキュウジ'],
        ['鷂', 'テン，マゴコロノマノミギニトリ'],
        ['鷁', 'ゲキ，リエキノエキノミギニトリ，アオサギ'],
        ['鷏', 'テン，マゴコロノマノミギニトリ'],
        ['昔', 'ムカシバナシ ノ ムカシ'],
        ['易', 'ボウエキ ノ エキ，ヤサシイ'],
        ['昌', 'ショウ，ニチ ノ シタニ ニチ'],
        ['昏', 'コンスイスル ノ コン'],
        ['明', 'セツメイ ノ メイ，アカルイ'],
        ['鷓', 'トリノシャコノシャ，ショミンノショノミギニトリ'],
        ['倪', 'タンゲイノゲイ，ニンベンニヌラムノツクリ'],
        ['昇', 'ショウカクスル ノ ショウ，ノボル'],
        ['昆', 'コンチュウ ノ コン'],
        ['昃', 'ソク，ニチヨウビノニチノシタニソクブンスルノソク'],
        ['昂', 'ゲキコウスル ノ コウ'],
        ['└', 'ヒダリシタ'],
        ['┗', 'フトヒダリシタ'],
        ['┐', 'ミギウエ'],
        ['┓', 'フトミギウエ'],
        ['鐃', 'ドウ、カネヘンニギョウシュンノギョウノキュウジ'],
        ['┝', 'タテセンフトミギ'],
        ['├', 'タテセンミギ'],
        ['┘', 'ミギシタ'],
        ['┛', 'フトミギシタ'],
        ['━', 'フトヨコセン'],
        ['─', 'ヨコセン'],
        ['┃', 'フトタテセン'],
        ['│', 'タテセン'],
        ['┌', 'ヒダリウエ'],
        ['┏', 'フトヒダリウエ'],
        ['┴', 'ヨコセンウエ'],
        ['┷', 'フトヨコセンホソウエ'],
        ['┰', 'ヨコセンフトシタ'],
        ['┳', 'フトヨコセンシタ'],
        ['┼', 'クロス'],
        ['┿', 'フトヨコセンクロス'],
        ['┸', 'ヨコセンフトウエ'],
        ['┻', 'フトヨコセンウエ'],
        ['┥', 'タテセンフトヒダリ'],
        ['┤', 'タテセンヒダリ'],
        ['┠', 'フトタテセンホソミギ'],
        ['┣', 'フトタテセンミギ'],
        ['┬', 'ヨコセンシタ'],
        ['┯', 'フトヨコセンホソシタ'],
        ['┨', 'フトタテセンホソヒダリ'],
        ['┫', 'フトタテセンヒダリ'],
        ['盈', 'ミチル，エイ'],
        ['益', 'リエキ ノ エキ'],
        ['盍', 'コウ，フタカラクサカンムリヲトッタカタチ'],
        ['盃', 'サカズキ，フシギ ノ フ ノ シタニ サラ'],
        ['盂', 'ウラボンノウ'],
        ['盆', 'ボンオドリ ノ ボン'],
        ['盛', 'オオモリ ノ モリ，セイ'],
        ['盜', 'トウナンノトウ，ヌスムノキュウジ'],
        ['盟', 'ドウメイスル ノ メイ'],
        ['盞', 'サン，サラノウエニアサイノキュウジノツクリ'],
        ['盒', 'ハンゴウスイサンノゴウ'],
        ['盗', 'トウナン ノ トウ，ヌスム'],
        ['盖', 'フタノイタイジ，サラノウエニヒツジ'],
        ['盪', 'ノウシントウノトウ'],
        ['目', 'モクテキ ノ モク，メ'],
        ['盡', 'ジンリョクスルノジン，ツクスノキュウジ'],
        ['監', 'カントクスル ノ カン'],
        ['盥', 'タライ，カン'],
        ['盤', 'エンバンナゲ ノ バン'],
        ['盧', 'ロ，ロカスルノロノツクリ'],
        ['相', 'ソウダンスル ノ ソウ，アイ'],
        ['盻', 'ケイ，メヘンニカンスウジノハチノシタニバンゴウノゴウノシタガワ'],
        ['盾', 'ムジュン ノ ジュン，タテ'],
        ['钁', 'カク，カネヘンニゲンキカクシャクノカク'],
        ['盲', 'モウガッコウ ノ モウ'],
        ['直', 'チョクセン ノ チョク，ナオル'],
        ['鄒', 'スウ，スウセイノスウノツクリノミギニオオザト'],
        ['鐘', 'ケイショウヲナラス ノ ショウ，カネ'],
        ['廿', 'カンスウジ ノ ニジュウ'],
        ['廾', 'キョウ，ブシュノニジュウアシ'],
        ['廼', 'エンニョウ ニ ニシ，ナイ'],
        ['廻', 'エンニョウ ニ マワル ノ カイ'],
        ['建', 'ケンチク ノ ケン，タテル'],
        ['廸', 'テキ，エンニョウニリユウノユウ'],
        ['廷', 'キュウテイブンガク ノ テイ'],
        ['延', 'エンキスル ノ エン，ノビル'],
        ['廴', 'イン，ブシュノエンニョウ'],
        ['廳', 'チョウ，キショウチョウノチョウノキュウジ'],
        ['廱', 'ヨウ，マダレニカワ，クチ，トモエ，フルトリ'],
        ['廰', 'チョウ，キショウチョウノチョウノキュウジノイタイジ'],
        ['廬', 'ロザンノロ，マダレニハゼノキノハゼノツクリ'],
        ['廩', 'リン，マダレニリンギスルノリン'],
        ['廨', 'カイ，マダレニカイケツスルノカイ'],
        ['廣', 'ヒロバノヒロノキュウジ'],
        ['廢', 'ハイシスルノハイ，スタレルノキュウジ'],
        ['廡', 'ブ，マダレニムリノム'],
        ['廠', 'カイグンコウショウ ノ ショウ'],
        ['廟', 'レイビョウ ノ ビョウ'],
        ['廝', 'シ，マダレニシカイノケンイノシ'],
        ['廛', 'テン，マトイノツクリ'],
        ['廚', 'チュウボウノチュウ，クリヤノキュウジ'],
        ['g', 'ジー ゴルフ'],
        ['廖', 'リョウ，マダレニゴビュウノビュウノツクリ'],
        ['廓', 'ユウカク ノ カク，クルワ'],
        ['廐', 'キュウシャノキュウ，ウマヤノイタイジ，キバ'],
        ['廏', 'キュウシャノキュウ，ウマヤノイタイジ，ルマタ'],
        ['廊', 'ワタリロウカ ノ ロウ'],
        ['廉', 'レンカバン ノ レン'],
        ['廈', 'カ，マダレニナツ'],
        ['廃', 'ハイシスル ノ ハイ，スタレル'],
        ['廂', 'ショウ，マダレニソウダンスルノソウ'],
        ['廁', 'カワヤ，マダレニホウソクノソク'],
        ['贇', 'ゲンピンヤキノイン'],
        ['贅', 'ゼイタクノゼイ'],
        ['贄', 'イケニエノニエ'],
        ['贏', 'カチマケヲイミスルエイシュノエイ'],
        ['贍', 'セン，カイヘンニクシンサンタンノタンノツクリ'],
        ['贋', 'ガンサク ノ ガン，ニセ'],
        ['贊', 'サンセイハンタイノサンノキュウジ'],
        ['贈', 'ゾウトウヒン ノ ゾウ，オクル'],
        ['贖', 'ショクザイノショク，アガナウ'],
        ['贔', 'ヒイキノヒ、カイミッツ'],
        ['贓', 'ゾウブツザイノゾウ'],
        ['贐', 'ハナムケ、ジン'],
        ['=', 'イコール'],
        ['葹', 'シ，クサカンムリニホドコス'],
        ['葺', 'ヤネヲフク ノ フク'],
        ['葱', 'ショクブツ ノ ネギ'],
        ['葵', 'アオイマツリ ノ アオイ'],
        ['葷', 'クンシュサンモンニイルヲユルサズノクン'],
        ['葩', 'ハ，クサカンムリニシロイノミギニトモエ'],
        ['葫', 'コ、クサカンムリニミズウミノツクリ'],
        ['葬', 'ソウシキ ノ ソウ，ホウムル'],
        ['葭', 'カ、アシ、クサカンムリニヒマツブシノヒマノツクリ'],
        ['葮', 'タン、クサカンムリニシュダンノダン'],
        ['葯', 'ヤク，クサカンムリニヤクソクノヤク'],
        ['葡', 'ブドウシュ ノ ブ'],
        ['葢', 'フタノイタイジ，クサカンムリニフトイニサラ'],
        ['董', 'コットウヒン ノ トウ'],
        ['葦', 'アシブエ ノ アシ'],
        ['葛', 'カットウ ノ カツ，クズ'],
        ['著', 'チョシャ ノ チョ，イチジルシイ'],
        ['葉', 'キノハ ノ ハ，ヨウ'],
        ['葎', 'ショクブツ ノ ムグラ，クサカンムリ ニ ホウリツ ノ リツ'],
        ['嬾', 'ラン，オンナヘンニタヨルノキュウジ'],
        ['葆', 'ホウ、クサカンムリニホアンノホ'],
        ['丿', 'ヘツ，カタカナノノノカタチ'],
        ['垓', 'カズノタンイノガイ'],
        ['主', 'シュジンコウ ノ シュ，ヌシ'],
        ['丹', 'タンネンナ ノ タン'],
        ['丸', 'ヒノマル ノ マル，ガン'],
        ['丶', 'チュウ，ブンノクギリフゴウ，カタチハテン'],
        ['串', 'クシカツノ クシ'],
        ['丱', 'カン，アゲマキ'],
        ['垂', 'スイチョク ノ スイ，タレル'],
        ['个', 'カ，モノノタンイ，ヤネノシタニタテボウ'],
        ['垈', 'タイ，ダイヒョウシャノダイノシタニツチ'],
        ['垉', 'ホウ，ツチヘンニツツム'],
        ['型', 'モケイ ノ ケイ，カタ'],
        ['両', 'リョウテ ノ リョウ'],
        ['垰', 'タオ，ツチヘンニウエトシタ'],
        ['丞', 'ダイジンヲ イミスル ジョウショウ ノ ジョウ'],
        ['垳', 'ガケ，ツチヘンニリョコウスルノコウ'],
        ['丙', 'コウオツヘイ ノ ヘイ'],
        ['丘', 'サキュウ ノ キュウ，オカ'],
        ['丗', 'セカイノセノキュウジ'],
        ['世', 'セカイ ノ セ，ヨ'],
        ['丕', 'ヒ，フシギノフノシタニカンスウジノイチ'],
        ['且', 'ナオカツ ノ カツ'],
        ['丑', 'ウシ，ジュウニシ ノ ウシ'],
        ['丐', 'カイ，コウ，アタエルノイミ'],
        ['垠', 'ギン，ツチヘンニダイコンノコンノツクリ'],
        ['与', 'アタエル，キュウヨ ノ ヨ'],
        ['垢', 'テアカ ノ アカ，コウ'],
        ['垣', 'カキネ ノ カキ'],
        ['垤', 'テツ，アリヅカ，ツチヘンニゲシノシ'],
        ['上', 'ジョウゲ ノ ジョウ，ウエ'],
        ['三', 'カンスウジ ノ サン'],
        ['丈', 'ダイジョウブ ノ ジョウ，タケ'],
        ['万', 'マンネンヒツ ノ マン'],
        ['垪', 'ハ，ツチヘンニヘイゴウノヘイノツクリ'],
        ['七', 'カンスウジ ノ ナナ'],
        ['丁', 'イッチョウメ ノ チョウ'],
        ['一', 'カンスウジ ノ イチ'],
        ['潮', 'マンチョウ ノ チョウ，シオ'],
        ['潯', 'ジン，サンズイニジンジョウショウガッコウノジン'],
        ['潭', 'タン，サンズイニニシノシタニハヤオキノハヤイ'],
        ['潦', 'ロウ，サンズイニメイリョウナノリョウノツクリ'],
        ['潤', 'リジュン ノ ジュン，ウルオウ'],
        ['潼', 'トウ，サンズイニグリムドウワノドウ'],
        ['潺', 'サン，サンズイニシカバネノシタニコドモノコミッツ'],
        ['潸', 'サン，サンズイニハヤシノシタニツキ'],
        ['潴', 'チョ，サンズイニイノシシ'],
        ['潰', 'ツブレル，イカイヨウ ノ カイ'],
        ['潅', 'カンボク ノ カン'],
        ['潁', 'エイ，カタカナノヒノシタニミズ，ソノミギニページ'],
        ['潟', 'ニイガタケン ノ カタ'],
        ['潜', 'センスイカン ノ セン，モグル'],
        ['潛', 'センスイカンノセン，モグルノキュウジ'],
        ['潘', 'ハン，サンズイニバンゴウノバン'],
        ['潔', 'セイケツ ノ ケツ'],
        ['禺', 'グウ，グウゼンノグウノツクリ'],
        ['禹', 'チュウゴクノデンセツノオウノウ'],
        ['禾', 'ノギヘン ノ ノギ，カ'],
        ['禿', 'ハゲヤマ ノ ハゲ'],
        ['禽', 'モウキンルイ ノ キン'],
        ['禳', 'ジョウ，シメスヘンニユズルノキュウジノツクリ'],
        ['禰', 'スクネ ノ ネ，シメスヘン ニ ナンジ'],
        ['禪', 'ザゼンノゼンノキュウジ'],
        ['禮', 'レイギノレイノキュウジ'],
        ['禦', 'ボウギョ ノ ギョ ノ キュウジ'],
        ['禧', 'キ，シメスヘンニヨロコブ'],
        ['禝', 'シャショクノシンノショク，シメスヘン'],
        ['禊', 'ミソギ，ケイ'],
        ['禎', 'テイ，シメスヘン ニ テイシュク ノ テイ'],
        ['福', 'フクビキ ノ フク'],
        ['禍', 'ワザワイ，カ'],
        ['禀', 'リンギショノリンノイタイジ'],
        ['禁', 'キンシスル ノ キン'],
        ['禄', 'ゲンロクブンカ ノ ロク'],
        ['禅', 'ザゼン ノ ゼン'],
        ['鵬', 'オオトリ，ホウユウ ノ ホウニトリ'],
        ['鵯', 'ヒヨドリ，ヒクツナノヒノミギニトリ'],
        ['鵡', 'トリ ノ オウム ノ ム'],
        ['鵠', 'コウコク ノ ココロザシ ノ コク'],
        ['鵤', 'ツノヘンニトリ，イカルガ'],
        ['鵺', 'ヨゾラノヨノミギニトリ，ヌエ'],
        ['鵲', 'カササギ，ムカシノミギニトリ'],
        ['鵈', 'ミミヘンニトリ，トビ'],
        ['鵁', 'コウ，コウツウノコウノミギニトリ'],
        ['鵄', 'シ，ゲシノシノミギニトリ'],
        ['鵆', 'ギョウガマエノナカニトリ，チドリ'],
        ['鵙', 'ケキ，カイヘンニトリ'],
        ['鵝', 'ガ，ガマンノガノミギニトリ，ガチョウノガ'],
        ['鵜', 'ウノミニスル ノ ウ'],
        ['鵞', 'ガ，ガマンノガノシタニトリ，ガチョウノガ'],
        ['鵑', 'ケン，キヌイトノキヌノツクリノミギニトリ'],
        ['鵐', 'ブ，ジンジャノミコノフノミギニトリ'],
        ['~', 'チルダ'],
        ['古', 'フルイ，コダイ ノ コ'],
        ['T', 'ティー タイム'],
        ['枇', 'ショクブツ ノ ビワ ノ ビ，キヘン ニ クラベル'],
        ['枅', 'ケイ，キヘンニセイホウケイノケイノヒダリガワ'],
        ['枌', 'フン、キヘンニハンブンノブン'],
        ['枋', 'ホウ、キヘンニセイホウケイノホウ'],
        ['枉', 'オウ、マガル、キヘンニオウサマノオウ'],
        ['林', 'シンリン ノ リン，ハヤシ'],
        ['枕', 'マクラ'],
        ['析', 'ブンセキスル ノ セキ'],
        ['枝', 'キノエダ ノ エダ'],
        ['果', 'ケッカ ノ カ，ハタス'],
        ['枚', 'マイスウ ノ マイ'],
        ['枦', 'ハゼノキノハゼノイタイジ，キヘンニトジマリノト'],
        ['枢', 'チュウスウ ノ スウ'],
        ['枡', 'マス、キヘンニイッショウビンノショウ'],
        ['枠', 'ソトワク ノ ワク'],
        ['枯', 'カレル，コカツスル ノ コ'],
        ['枩', 'マツノキノマツノイタイジ'],
        ['枷', 'カ，キヘンニカソクドノカ'],
        ['架', 'ジュウジカ ノ カ，カケル'],
        ['枴', 'カイ，キヘンニユウカイハンノカイノツクリ'],
        ['枳', 'カラタチ，キヘンニタダイマノタダ'],
        ['枹', 'フ，キヘンニヒョウガフルノヒョウノシタガワ'],
        ['枸', 'ク，キヘンニハイクノク'],
        ['в', 'キリル ヴェー'],
        ['г', 'キリル ゲー'],
        ['а', 'キリル アー'],
        ['б', 'キリル ベー'],
        ['ж', 'キリル ジェー'],
        ['з', 'キリル ゼー'],
        ['д', 'キリル デー'],
        ['е', 'キリル ィエー'],
        ['к', 'キリル カー'],
        ['л', 'キリル エル'],
        ['и', 'キリル イー'],
        ['й', 'キリル イークラトコエ'],
        ['о', 'キリル オー'],
        ['п', 'キリル ペー'],
        ['м', 'キリル エム'],
        ['н', 'キリル エヌ'],
        ['Т', 'キリル テー'],
        ['У', 'キリル ウー'],
        ['Р', 'キリル エル'],
        ['С', 'キリル エス'],
        ['Ц', 'キリル ツェー'],
        ['Ч', 'キリル チェー'],
        ['Ф', 'キリル エフ'],
        ['Х', 'キリル ハー'],
        ['Ъ', 'キリル コウオンキゴウ'],
        ['Ы', 'キリル ウィ'],
        ['Ш', 'キリル シャー'],
        ['Щ', 'キリル シシャー'],
        ['Ю', 'キリル ユー'],
        ['Я', 'キリル ヤー'],
        ['Ь', 'キリル ナンオンキゴウ'],
        ['Э', 'キリル エー'],
        ['В', 'キリル ヴェー'],
        ['Г', 'キリル ゲー'],
        ['А', 'キリル アー'],
        ['Б', 'キリル ベー'],
        ['Ж', 'キリル ジェー'],
        ['З', 'キリル ゼー'],
        ['Д', 'キリル デー'],
        ['Е', 'キリル ィエー'],
        ['К', 'キリル カー'],
        ['Л', 'キリル エル'],
        ['И', 'キリル イー'],
        ['Й', 'キリル イークラトコエ'],
        ['О', 'キリル オー'],
        ['П', 'キリル ペー'],
        ['М', 'キリル エム'],
        ['Н', 'キリル エヌ'],
        ['鑽', 'ケンサンヲツムノサン'],
        ['Ё', 'キリル ィヨー'],
        ['趨', 'スウセイ ノ スウ'],
        ['又', 'マタガシ ノ マタ'],
        ['鐇', 'ハン、カネヘンニバンゴウノバン'],
        ['趣', 'シュミ ノ シュ，オモムキ'],
        ['鐓', 'タイ、カネヘンニチュウゴクノトンコウノトン'],
        ['鐐', 'リョウ、カネヘンニドウリョウノリョウノツクリ'],
        ['趺', 'フ，アシヘンニオット'],
        ['鐔', 'タン，カネヘンニニシノシタニハヤオキノハヤイ'],
        ['趾', 'ジョウシコウエンノシ'],
        ['鐚', 'ビタイチモンノビタ'],
        ['足', 'アシ，エンソク ノ ソク'],
        ['鐙', 'アブミ'],
        ['越', 'ユウエツカン ノ エツ，コス'],
        ['趁', 'チン，ソウニョウニメズラシイノツクリ'],
        [
            '鐫',
            'セン、カネヘンニフルトリノシタニオウトツノオウノシタ１カクヲトッタモノ',
        ],
        ['*', 'アスタリスク'],
        ['超', 'チョウノウリョク ノ チョウ，コエル'],
        ['趙', 'チュウゴクノコクメイノチョウ'],
        ['鐶', 'カン、カネヘンニジュンカンスルノカンノツクリ'],
        ['鐵', 'テツドウノテツノキュウジ'],
        ['鐺', 'トウ、カネヘンニベントウノトウノキュウジ'],
        ['鐸', 'ドウタク ノ タク'],
        ['叔', 'オジオバ ノ シュク'],
        ['叟', 'サンバソウノソウ，オキナ'],
        ['霏', 'ヒ、アメカンムリニヒジョウグチノヒ'],
        ['幀', 'テイ，ハバヘンニテイシュクナノテイ'],
        ['幃', 'イ，ハバヘンニイダイナノイノツクリ'],
        ['幅', 'ゾウフクスル ノ フク，ハバ'],
        ['幄', 'アク，ハバヘンニオクジョウノオク'],
        ['幇', 'ホウジョスルノホウ'],
        ['幌', 'ホロバシャ ノ ホロ'],
        ['幎', 'ベイ，ハバヘンニメイフクヲイノルノメイ'],
        ['幕', 'ジマク ノ マク'],
        ['幔', 'マンマクノマン，ハバヘンニウナギノツクリ'],
        ['幗', 'カク，ハバヘンニクニノキュウジ'],
        ['輿', 'タマノコシ ノ コシ'],
        ['幟', 'キシヲセンメイニスルノシ，ノボリ'],
        ['幡', 'ヤハタ ノ ハタ'],
        ['幣', 'ゾウヘイキョク ノ ヘイ'],
        ['幢', 'トウ，ハバヘンニグリムドウワノドウ'],
        ['幤', 'ゾウヘイキョクノヘイノイタイジ'],
        ['平', 'ヘイワ ノ ヘイ，タイラ'],
        ['干', 'カンチョウ ノ カン，ホス'],
        ['幵', 'ケン，ホスガフタツ'],
        ['年', 'ガクネン ノ ネン，トシ'],
        ['并', 'ヘイ，ヘイヨウスルノヘイノツクリ'],
        ['幹', 'シンカンセン ノ カン，ミキ'],
        ['幸', 'コウフク ノ コウ，シアワセ'],
        ['幻', 'マボロシ，ゲンソウ ノ ゲン'],
        ['幺', 'ヨウ，ブシュノイトガシラ'],
        ['幽', 'ユウレイセン ノ ユウ'],
        ['幼', 'ヨウチエン ノ ヨウ，オサナイ'],
        ['广', 'ゲン，ブシュノマダレ'],
        ['幾', 'キカガク ノ キ'],
        ['煖', 'ダン，ヒヘンニダンボウノダンノツクリ'],
        ['煕', 'コウキジテンノキ'],
        ['雛', 'ヒナマツリ ノ ヒナ'],
        ['煙', 'エントツ ノ エン，ケムリ'],
        ['煉', 'レンガ ノ レン，ネル'],
        ['煎', 'センチャ ノ セン，イル'],
        ['煌', 'コウ，ヒヘンニコウタイシノコウ'],
        ['煽', 'アオル，センドウスル ノ セン'],
        ['煢', 'ケイ，ホタルノキュウジノカンムリニジンソクナノジンノナカミ'],
        ['照', 'ショウメイ ノ ショウ，テラス'],
        ['煦', 'ク，ヨウビノニチノミギニハイクノクニレンガ'],
        ['煥', 'サイキカンパツノカン'],
        ['煤', 'スス，バイエン ノ バイ'],
        ['煩', 'ボンノウ ノ ボン，ワズラワシイ'],
        ['煮', 'ニモノ ノ ニ，シャフツ ノ シャ'],
        ['煬', 'ヨウ，ヒヘンニタイヨウケイノヨウノツクリ'],
    ]);
})(JaPhoneticMap || (JaPhoneticMap = {}));
