// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_shared_vars.css.js";import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/polymer/v3_0/paper-spinner/paper-spinner-lite.js";import"/strings.m.js";import{loadTimeData}from"chrome://resources/ash/common/load_time_data.m.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{AddSupervisionHandler,OAuthTokenFetchStatus}from"./add_supervision.mojom-webui.js";import{AddSupervisionApiServer}from"./add_supervision_api_server.js";import{getTemplate}from"./add_supervision_ui.html.js";const ALLOWED_HOSTS=["google.com","gstatic.com","googleapis.com","google-analytics.com","lh3.googleusercontent.com","lh4.googleusercontent.com","lh5.googleusercontent.com","lh6.googleusercontent.com"];const INITIAL_FOCUS_DELAY_MS=50;export function isLocalHostForTesting(url){return url.protocol==="http:"&&url.hostname==="127.0.0.1"}function isAllowedHost(url){return url.protocol==="https:"&&ALLOWED_HOSTS.some((allowedHost=>url.host===allowedHost||url.host.endsWith("."+allowedHost)))}function isAllowedRequest(requestDetails){const requestUrl=new URL(requestDetails);return isLocalHostForTesting(requestUrl)||isAllowedHost(requestUrl)}export class AddSupervisionUi extends PolymerElement{static get is(){return"add-supervision-ui"}static get template(){return getTemplate()}static get properties(){return{webviewLoading:{type:Boolean,value:true}}}ready(){super.ready();const addSupervisionHandler=AddSupervisionHandler.getRemote();addSupervisionHandler.getOAuthToken().then((result=>{if(result.status===OAuthTokenFetchStatus.ERROR){this.showErrorPage();return}const webviewUrl=loadTimeData.getString("webviewUrl");const eventOriginFilter=loadTimeData.getString("eventOriginFilter");const webview=this.$.webview;const accessToken=result.oauthToken;const flowType=loadTimeData.getString("flowType");const platformVersion=loadTimeData.getString("platformVersion");const languageCode=loadTimeData.getString("languageCode");const url=new URL(webviewUrl);url.searchParams.set("flow_type",flowType);url.searchParams.set("platform_version",platformVersion);url.searchParams.set("access_token",accessToken);url.searchParams.set("hl",languageCode);webview.addEventListener("newwindow",(e=>{window.open(e.targetUrl)}));webview.addEventListener("contentload",(()=>{this.webviewLoading=false}));webview.addEventListener("loadstop",(()=>{setTimeout((()=>webview.focus()),INITIAL_FOCUS_DELAY_MS)}));webview.addEventListener("loadabort",(()=>{this.webviewLoading=false;this.showErrorPage()}));webview.request.onBeforeRequest.addListener((details=>({cancel:!isAllowedRequest(details.url)})),{urls:["<all_urls>"]},["blocking"]);webview.src=url.toString();this.server=new AddSupervisionApiServer(this,webview,url.toString(),eventOriginFilter)}))}showErrorPage(){this.dispatchEvent(new CustomEvent("show-error",{bubbles:true,composed:true}))}getApiServerForTest(){return this.server}}customElements.define(AddSupervisionUi.is,AddSupervisionUi);