import { getTrustedHTML } from '//resources/js/static_types.js';
export function getTemplate() {
    return getTrustedHTML `<!--_html_template_start_--><style>#dialog:focus-visible{outline:none}.title-icon{display:none}#title-icon-install,#title-icon-installed{fill:var(--cros-sys-primary)}#title-icon-error,#title-icon-connection-error{fill:var(--cros-sys-on_error_container)}#title{color:var(--cros-sys-on_surface);font:var(--cros-display-6-font);padding-top:14px;margin:0}#content-card{background-color:var(--cros-sys-base_elevated);border-radius:16px;margin:24px 0px;overflow:hidden}#essential-details{display:flex;flex-direction:row;min-height:68px;padding:0px 24px}#app-icon{margin-inline-end:14px;margin-block:auto;box-shadow:0px 0px 4px 0px var(--cros-sys-shadow_key),0px 1px 2px 0px var(--cros-sys-shadow_ambient);border-radius:100%}#name-and-url{margin-block:auto;margin:14px 0px}#name{margin:0 0 2px 0;font:var(--cros-button-1-font);color:var(--cros-sys-on_surface)}#url{margin:0;font:var(--cros-annotation-1-font);color:var(--cros-sys-on_surface);overflow-wrap:anywhere}#url-link{color:var(--cros-sys-primary)}hr{border-width:1px 0px 0px 0px;border-style:solid;border-color:var(--cros-sys-app_base_shaded);margin:0}#description-and-screenshots{padding:0px 20px 0px 20px}#description{font:var(--cros-annotation-1-font);color:var(--cros-sys-on_surface_variant);overflow-wrap:break-word;padding:12px 0px;margin:0px}#screenshot-container{margin-bottom:20px;border-radius:16px;background-color:var(--cros-sys-inverse_on_surface)}#screenshot{border-radius:16px;display:none}#error-message{color:var(--cros-sys-on_surface);font:var(--cros-body-1-font);margin-top:10px;margin-bottom:32px}div[slot=button-container]{display:flex;justify-content:flex-end;height:36px}.action-button{margin-inline-start:8px}</style>

<cr-dialog
    id="dialog"
    role="dialog"
    aria-labelledby="title"
    autofocus
    tabindex="-1">
  <svg class="title-icon" id="title-icon-install" xmlns="http://www.w3.org/2000/svg" height="32" viewBox="0 -960 960 960" width="32"><path d="M480-320 280-520l56-58 104 104v-326h80v326l104-104 56 58-200 200ZM240-160q-33 0-56.5-23.5T160-240v-120h80v120h480v-120h80v120q0 33-23.5 56.5T720-160H240Z"></svg>
  <svg class="title-icon" id="title-icon-installed" xmlns="http://www.w3.org/2000/svg" height="32" viewBox="0 -960 960 960" width="32"><path d="m437-398 227-226-57-57-170 170-85-85-56 56 141 142ZM40-120v-80h880v80H40Zm120-120q-33 0-56.5-23.5T80-320v-440q0-33 23.5-56.5T160-840h640q33 0 56.5 23.5T880-760v440q0 33-23.5 56.5T800-240H160Zm0-80h640v-440H160v440Zm0 0v-440 440Z"></svg>
  <svg class="title-icon" id="title-icon-error" xmlns="http://www.w3.org/2000/svg" height="32" viewBox="0 -960 960 960" width="32"><path d="M480-280q17 0 28.5-11.5T520-320q0-17-11.5-28.5T480-360q-17 0-28.5 11.5T440-320q0 17 11.5 28.5T480-280Zm-40-160h80v-240h-80v240Zm40 360q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Zm0-80q134 0 227-93t93-227q0-134-93-227t-227-93q-134 0-227 93t-93 227q0 134 93 227t227 93Zm0-320Z"></svg>
  <svg class="title-icon" id="title-icon-connection-error" xmlns="http://www.w3.org/2000/svg" height="32" viewBox="0 -960 960 960" width="32"><path d="m676-140-56-56 84-84-84-84 56-56 84 84 84-84 57 56-84 84 83 84-56 56-84-83-84 83Zm-196 20L0-600q95-97 219.5-148.5T480-800q136 0 260.5 51.5T960-600L822-463q-14-14-28-28.5T766-520l78-78q-79-60-172-91t-192-31q-99 0-192 31t-172 91l364 364 40-40 28.5 28.5L577-217l-97 97Zm0-357Z"></svg>
  <h1 id="title"></h1>
  <div id="content-card" style="display: none">
    <div id="essential-details">
      <img id="app-icon" is="cr-auto-img" width="32" height="32">
      <div id="name-and-url">
        <p id="name"></p>
        <p id="url">$i18n{appDetails}
          <a id="url-link" target="_blank"></a>
        </p>
      </div>
    </div>
    <hr id="divider" hidden aria-hidden="true">
    <div id="description-and-screenshots" hidden>
      <p id="description"></p>
      <div id="screenshot-container" hidden>
        <img id="screenshot" is="cr-auto-img" width="408" alt="">
      </div>
    </div>
  </div>
  <p id="error-message" style="display: none"></p>
  <div slot="button-container">
    <cros-button
        class="cancel-button"
        label="$i18n{cancel}"
        button-style="secondary">
    </cros-button>
    <cros-button
        class="action-button"
        label="$i18n{install}">
      <!-- Spinner icon from //ui/webui/resources/images/throbber_medium.svg,
           download and open in icons from https://fonts.google.com/icons. -->
      <svg class="action-icon" id="action-icon-install" xmlns="http://www.w3.org/2000/svg" viewBox="0 -960 960 960" slot="leading-icon"><path fill="currentColor" d="M480-336 288-528l51-51 105 105v-342h72v342l105-105 51 51-192 192ZM263.717-192Q234-192 213-213.15T192-264v-72h72v72h432v-72h72v72q0 29.7-21.162 50.85Q725.676-192 695.96-192H263.717Z"></svg>
      <svg class="action-icon" id="action-icon-installing" version="1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 28 28"><style>@keyframes rotate{0%{transform:rotate(0deg)}to{transform:rotate(360deg)}}@keyframes fillunfill{0%{stroke-dashoffset:58.8}50%{stroke-dashoffset:0}to{stroke-dashoffset:-58.4}}@keyframes rot{0%{transform:rotate(0deg)}to{transform:rotate(-360deg)}}@keyframes colors{0%,to{stroke:currentColor}}</style><g style="animation-duration:1568.63ms;animation-iteration-count:infinite;animation-name:rotate;animation-timing-function:linear;transform-origin:50% 50%;width:28px;height:28px"><path fill="none" d="M14 1.5A12.5 12.5 0 1 1 1.5 14" stroke-width="3" stroke-linecap="round" style="animation-duration:1333ms,5332ms,5332ms;animation-fill-mode:forwards;animation-iteration-count:infinite,infinite,infinite;animation-name:fillunfill,rot,colors;animation-play-state:running,running,running;animation-timing-function:cubic-bezier(.4,0,.2,1),steps(4),linear;transform-origin:50% 50%" stroke-dasharray="58.9" stroke-dashoffset="58.9"></g></svg>
      <svg class="action-icon" id="action-icon-open-app" xmlns="http://www.w3.org/2000/svg" viewBox="0 -960 960 960"><path fill="currentColor" d="M216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h264v72H216v528h528v-264h72v264q0 29.7-21.15 50.85Q773.7-144 744-144H216Zm171-192-51-51 357-357H576v-72h240v240h-72v-117L387-336Z"></svg>
      <svg class="action-icon" id="action-icon-try-again" xmlns="http://www.w3.org/2000/svg" viewBox="0 -960 960 960"><path fill="currentColor" d="M480-192q-120 0-204-84t-84-204q0-120 84-204t204-84q65 0 120.5 27t95.5 72v-99h72v240H528v-72h131q-29-44-76-70t-103-26q-90 0-153 63t-63 153q0 90 63 153t153 63q84 0 144-55.5T693-456h74q-9 112-91 188t-196 76Z"></svg>
    </cros-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
