// chrome/browser/ui/webui/ash/audio/audio.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export class PageHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'audio.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(page, handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            page,
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "audio.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createPageHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'audio.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getAudioDeviceInfo() {
        this.proxy.sendMessage(0, PageHandler_GetAudioDeviceInfo_ParamsSpec.$, null, [], false);
    }
    getActiveOutputDeviceName() {
        return this.proxy.sendMessage(1, PageHandler_GetActiveOutputDeviceName_ParamsSpec.$, PageHandler_GetActiveOutputDeviceName_ResponseParamsSpec.$, [], false);
    }
    getActiveInputDeviceName() {
        return this.proxy.sendMessage(2, PageHandler_GetActiveInputDeviceName_ParamsSpec.$, PageHandler_GetActiveInputDeviceName_ResponseParamsSpec.$, [], false);
    }
    openFeedbackDialog() {
        this.proxy.sendMessage(3, PageHandler_OpenFeedbackDialog_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_GetAudioDeviceInfo_ParamsSpec.$, null, impl.getAudioDeviceInfo.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_GetActiveOutputDeviceName_ParamsSpec.$, PageHandler_GetActiveOutputDeviceName_ResponseParamsSpec.$, impl.getActiveOutputDeviceName.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_GetActiveInputDeviceName_ParamsSpec.$, PageHandler_GetActiveInputDeviceName_ResponseParamsSpec.$, impl.getActiveInputDeviceName.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_OpenFeedbackDialog_ParamsSpec.$, null, impl.openFeedbackDialog.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "audio.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    getAudioDeviceInfo;
    getActiveOutputDeviceName;
    getActiveInputDeviceName;
    openFeedbackDialog;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getAudioDeviceInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_GetAudioDeviceInfo_ParamsSpec.$, null, this.getAudioDeviceInfo.createReceiverHandler(false /* expectsResponse */), false);
        this.getActiveOutputDeviceName =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_GetActiveOutputDeviceName_ParamsSpec.$, PageHandler_GetActiveOutputDeviceName_ResponseParamsSpec.$, this.getActiveOutputDeviceName.createReceiverHandler(true /* expectsResponse */), false);
        this.getActiveInputDeviceName =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_GetActiveInputDeviceName_ParamsSpec.$, PageHandler_GetActiveInputDeviceName_ResponseParamsSpec.$, this.getActiveInputDeviceName.createReceiverHandler(true /* expectsResponse */), false);
        this.openFeedbackDialog =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_OpenFeedbackDialog_ParamsSpec.$, null, this.openFeedbackDialog.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'audio.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    updateDeviceInfo(devices) {
        this.proxy.sendMessage(0, Page_UpdateDeviceInfo_ParamsSpec.$, null, [
            devices
        ], false);
    }
    updateDeviceVolume(nodeId, volume) {
        this.proxy.sendMessage(1, Page_UpdateDeviceVolume_ParamsSpec.$, null, [
            nodeId,
            volume
        ], false);
    }
    updateDeviceMute(nodeId, isMuted) {
        this.proxy.sendMessage(2, Page_UpdateDeviceMute_ParamsSpec.$, null, [
            nodeId,
            isMuted
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_UpdateDeviceInfo_ParamsSpec.$, null, impl.updateDeviceInfo.bind(impl), false);
        this.helper_internal_.registerHandler(1, Page_UpdateDeviceVolume_ParamsSpec.$, null, impl.updateDeviceVolume.bind(impl), false);
        this.helper_internal_.registerHandler(2, Page_UpdateDeviceMute_ParamsSpec.$, null, impl.updateDeviceMute.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "audio.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    updateDeviceInfo;
    updateDeviceVolume;
    updateDeviceMute;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.updateDeviceInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_UpdateDeviceInfo_ParamsSpec.$, null, this.updateDeviceInfo.createReceiverHandler(false /* expectsResponse */), false);
        this.updateDeviceVolume =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Page_UpdateDeviceVolume_ParamsSpec.$, null, this.updateDeviceVolume.createReceiverHandler(false /* expectsResponse */), false);
        this.updateDeviceMute =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, Page_UpdateDeviceMute_ParamsSpec.$, null, this.updateDeviceMute.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const DeviceDataSpec = { $: {} };
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_GetAudioDeviceInfo_ParamsSpec = { $: {} };
export const PageHandler_GetActiveOutputDeviceName_ParamsSpec = { $: {} };
export const PageHandler_GetActiveOutputDeviceName_ResponseParamsSpec = { $: {} };
export const PageHandler_GetActiveInputDeviceName_ParamsSpec = { $: {} };
export const PageHandler_GetActiveInputDeviceName_ResponseParamsSpec = { $: {} };
export const PageHandler_OpenFeedbackDialog_ParamsSpec = { $: {} };
export const Page_UpdateDeviceInfo_ParamsSpec = { $: {} };
export const Page_UpdateDeviceVolume_ParamsSpec = { $: {} };
export const Page_UpdateDeviceMute_ParamsSpec = { $: {} };
mojo.internal.Struct(DeviceDataSpec.$, 'DeviceData', [
    mojo.internal.StructField('type', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('id', 8, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('displayName', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isActive', 24, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isInput', 24, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('volumeGainPercent', 28, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isMuted', 24, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_GetAudioDeviceInfo_ParamsSpec.$, 'PageHandler_GetAudioDeviceInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetActiveOutputDeviceName_ParamsSpec.$, 'PageHandler_GetActiveOutputDeviceName_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetActiveOutputDeviceName_ResponseParamsSpec.$, 'PageHandler_GetActiveOutputDeviceName_ResponseParams', [
    mojo.internal.StructField('deviceName', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetActiveInputDeviceName_ParamsSpec.$, 'PageHandler_GetActiveInputDeviceName_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetActiveInputDeviceName_ResponseParamsSpec.$, 'PageHandler_GetActiveInputDeviceName_ResponseParams', [
    mojo.internal.StructField('deviceName', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OpenFeedbackDialog_ParamsSpec.$, 'PageHandler_OpenFeedbackDialog_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_UpdateDeviceInfo_ParamsSpec.$, 'Page_UpdateDeviceInfo_Params', [
    mojo.internal.StructField('devices', 0, 0, mojo.internal.Map(mojo.internal.Uint64, DeviceDataSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_UpdateDeviceVolume_ParamsSpec.$, 'Page_UpdateDeviceVolume_Params', [
    mojo.internal.StructField('nodeId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('volume', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Page_UpdateDeviceMute_ParamsSpec.$, 'Page_UpdateDeviceMute_Params', [
    mojo.internal.StructField('nodeId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isMuted', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
