import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style>cr-dialog{--cr-dialog-width:440px;border-radius:24px}cr-dialog [slot=title]{color:var(--cros-text-color-primary);font:var(--cros-title-2-font);padding:24px 24px 16px}cr-dialog [slot=body]{color:var(--cros-text-color-secondary);font:var(--cros-body-1-font);padding:0 24px}cr-dialog [slot=button-container]{font:var(--cros-button-1-font);padding:49px 24px 24px}.action-button{border-radius:24px}.cancel-button{border-radius:24px}.error-icon{--iron-icon-fill-color:var(--cros-icon-color-alert);--iron-icon-height:24px;--iron-icon-width:24px;padding-bottom:10px}</style>

<cr-dialog id="dialog">
  <div slot="title">
    <div id="error-icon">
      <iron-icon class="error-icon" icon="borealis_installer:error"></iron-icon>
    </div>
    $i18n{errorTitle}
  </div>
  <div slot="body">[[getMessage(behaviour)]]</div>
  <div id="link" slot="body" hidden="[[!shouldShowLink(behaviour)]]">
    <a href="[[getLink(behaviour)]]" target="_blank">$i18n{learnMore}</a>
  </div>
  <div slot="button-container">
    <cr-button
        id="cancel"
        class="cancel-button"
        on-click="onCancelButtonClicked">
      $i18n{cancel}
    </cr-button>
    <cr-button id="retry"
        class="action-button"
        on-click="onRetryButtonClicked"
        hidden="[[!shouldShowRetryButton(behaviour)]]">
      $i18n{retry}
    </cr-button>
    <cr-button
        id="storage"
        class="action-button"
        on-click="onStorageButtonClicked"
        hidden="[[!shouldShowStorageButton(behaviour)]]">
      $i18n{storage}
    </cr-button>
  </div>
</cr-dialog><!--_html_template_end_-->`}